/*
 * Decompiled with CFR 0.152.
 */
package jnacontrib.x11.demos;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import jnacontrib.x11.api.X;

public class XDesktopDemo
extends JFrame {
    private static final long serialVersionUID = 1L;
    private X.Display display = new X.Display();
    private JList desktopList;
    private JTable windowTable;
    private JButton refreshButton;
    private JButton moveWindowToDesktopButton;
    private JButton goToDesktopButton;
    private JButton moveWindowAndGoToDesktopButton;
    private JButton closeWindowButton;
    private JButton goToWindowButton;
    private JButton showDesktop;
    private JButton showSubwindows;

    public static void main(String[] args) throws X.X11Exception {
        new XDesktopDemo();
    }

    public XDesktopDemo() throws X.X11Exception {
        super("XDesktopDemo");
        this.setDefaultCloseOperation(3);
        this.initGui();
        this.refreshDesktopsAndWindows();
        this.pack();
        this.addListeners();
        this.setVisible(true);
        this.printWmInfo();
    }

    private void printWmInfo() throws X.X11Exception {
        X.Window wm = this.display.getWindowManagerInfo();
        System.out.println("wm.getTitle() = " + wm.getTitle());
        System.out.println("wm.getWindowClass() = " + wm.getWindowClass());
        System.out.println("wm.getPID() = " + wm.getPID());
    }

    private void addListeners() {
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    XDesktopDemo.this.refreshDesktopsAndWindows();
                }
                catch (X.X11Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.goToDesktopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int desktopNr = XDesktopDemo.this.desktopList.getSelectedIndex();
                if (desktopNr >= 0) {
                    try {
                        XDesktopDemo.this.display.switchDesktop(desktopNr);
                        XDesktopDemo.this.display.flush();
                    }
                    catch (X.X11Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        this.goToWindowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                X.Window window = XDesktopDemo.this.getSelectedWindow();
                try {
                    window.activate();
                    XDesktopDemo.this.display.flush();
                }
                catch (X.X11Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.showDesktop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    XDesktopDemo.this.display.showingDesktop(true);
                    XDesktopDemo.this.display.flush();
                }
                catch (X.X11Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.moveWindowToDesktopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                X.Window window = XDesktopDemo.this.getSelectedWindow();
                try {
                    window.moveToDesktop(XDesktopDemo.this.desktopList.getSelectedIndex());
                    XDesktopDemo.this.display.flush();
                }
                catch (X.X11Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.moveWindowAndGoToDesktopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                X.Window window = XDesktopDemo.this.getSelectedWindow();
                try {
                    window.moveToDesktop(XDesktopDemo.this.desktopList.getSelectedIndex());
                    window.activate();
                    XDesktopDemo.this.display.flush();
                }
                catch (X.X11Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.closeWindowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                X.Window window = XDesktopDemo.this.getSelectedWindow();
                try {
                    window.close();
                    XDesktopDemo.this.display.flush();
                }
                catch (X.X11Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.showSubwindows.addActionListener(new ActionListener(){

            private void addWindowsToArea(JTextArea area, int depth, X.Window win) throws X.X11Exception {
                X.Window[] subWindows = win.getSubwindows();
                String title = win.getTitle();
                if (title != null) {
                    area.append(String.format("%" + depth + "s0x%08X - %s", " ", win.getID(), title));
                } else {
                    area.append(String.format("%" + depth + "s0x%08X", " ", win.getID()));
                }
                area.append(System.getProperty("line.separator"));
                if (subWindows == null) {
                    return;
                }
                for (int x = 0; x < subWindows.length; ++x) {
                    this.addWindowsToArea(area, depth + 4, subWindows[x]);
                }
            }

            @Override
            public void actionPerformed(ActionEvent event) {
                X.Window window = XDesktopDemo.this.getSelectedWindow();
                try {
                    final JDialog jd = new JDialog();
                    JPanel dialogPanel = new JPanel(new BorderLayout());
                    jd.setSize(320, 240);
                    jd.setTitle("Subwindows");
                    jd.setDefaultCloseOperation(2);
                    JTextArea area = new JTextArea();
                    this.addWindowsToArea(area, 1, window);
                    dialogPanel.add((Component)area, "Center");
                    JButton closeButton = new JButton("Close");
                    closeButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            jd.dispose();
                        }
                    });
                    dialogPanel.add((Component)closeButton, "South");
                    jd.add(dialogPanel);
                    jd.setVisible(true);
                }
                catch (X.X11Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private X.Window getSelectedWindow() {
        WindowTableModel tableModel = (WindowTableModel)this.windowTable.getModel();
        return tableModel.getWindow(this.windowTable.getSelectedRow());
    }

    private void refreshDesktopsAndWindows() throws X.X11Exception {
        X.Desktop[] desktops = this.display.getDesktops();
        ArrayList<Object> list = new ArrayList<Object>(desktops.length);
        for (int i = 0; i < desktops.length; ++i) {
            list.add(desktops[i].name);
        }
        this.desktopList.clearSelection();
        this.desktopList.setModel(new SimpleListModel(list));
        int activeDesktop = this.display.getActiveDesktopNumber();
        this.desktopList.setSelectedIndex(activeDesktop);
        int activeWindowId = this.display.getActiveWindow().getID();
        int activeWindowNumber = -1;
        X.Window[] windows = this.display.getWindows();
        String[] head = new String[]{"ID", "Desktop", "Title", "X", "Y", "Width", "Height"};
        String[][] data = new String[windows.length][head.length];
        for (int i = 0; i < windows.length; ++i) {
            X.Window window = windows[i];
            X.Window.Geometry geo = window.getGeometry();
            int windowId = window.getID();
            data[i][0] = String.format("0x%08X", windowId);
            data[i][1] = "" + window.getDesktop();
            data[i][2] = window.getTitle();
            data[i][3] = "" + geo.x;
            data[i][4] = "" + geo.y;
            data[i][5] = "" + geo.width;
            data[i][6] = "" + geo.height;
            if (windowId != activeWindowId) continue;
            activeWindowNumber = i;
        }
        this.windowTable.setModel(new WindowTableModel(head, data, windows));
        if (activeWindowNumber >= 0) {
            this.windowTable.getSelectionModel().setSelectionInterval(activeWindowNumber, activeWindowNumber);
        }
    }

    private void initGui() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridBagLayout());
        JPanel panel1 = new JPanel();
        panel1.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.8;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        mainPanel.add((Component)panel1, gbc);
        panel1.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLoweredBevelBorder(), "Desktops"));
        this.desktopList = new JList();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel1.add((Component)this.desktopList, gbc);
        JPanel panel2 = new JPanel();
        panel2.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        mainPanel.add((Component)panel2, gbc);
        panel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLoweredBevelBorder(), "Windows"));
        JScrollPane scrollPane1 = new JScrollPane();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel2.add((Component)scrollPane1, gbc);
        this.windowTable = new JTable();
        this.windowTable.setEnabled(true);
        scrollPane1.setViewportView(this.windowTable);
        JPanel panel3 = new JPanel();
        panel3.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        mainPanel.add((Component)panel3, gbc);
        panel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLoweredBevelBorder(), "Actions"));
        this.goToDesktopButton = new JButton();
        this.goToDesktopButton.setText("go to desktop");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.fill = 2;
        panel3.add((Component)this.goToDesktopButton, gbc);
        this.refreshButton = new JButton();
        this.refreshButton.setText("refresh");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        panel3.add((Component)this.refreshButton, gbc);
        this.goToWindowButton = new JButton();
        this.goToWindowButton.setText("go to window");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.fill = 2;
        panel3.add((Component)this.goToWindowButton, gbc);
        this.moveWindowAndGoToDesktopButton = new JButton();
        this.moveWindowAndGoToDesktopButton.setText("move window and go to desktop");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.fill = 2;
        panel3.add((Component)this.moveWindowAndGoToDesktopButton, gbc);
        this.closeWindowButton = new JButton();
        this.closeWindowButton.setText("close window");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.fill = 2;
        panel3.add((Component)this.closeWindowButton, gbc);
        this.moveWindowToDesktopButton = new JButton();
        this.moveWindowToDesktopButton.setText("move window to desktop");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.fill = 2;
        panel3.add((Component)this.moveWindowToDesktopButton, gbc);
        this.showDesktop = new JButton();
        this.showDesktop.setText("show desktop");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 2;
        panel3.add((Component)this.showDesktop, gbc);
        this.showSubwindows = new JButton();
        this.showSubwindows.setText("show subwindows");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.fill = 2;
        panel3.add((Component)this.showSubwindows, gbc);
        this.setContentPane(mainPanel);
    }

    public static class WindowTableModel
    implements TableModel {
        private String[] head;
        private String[][] data;
        private X.Window[] windows;

        public WindowTableModel(String[] head, String[][] data, X.Window[] windows) {
            this.head = head;
            this.data = data;
            this.windows = windows;
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public int getColumnCount() {
            return this.head.length;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.head[columnIndex];
        }

        public Class getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.data[rowIndex][columnIndex];
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
        }

        public X.Window getWindow(int rowIndex) {
            return this.windows[rowIndex];
        }
    }

    public static class SimpleListModel
    extends AbstractListModel {
        private static final long serialVersionUID = 1L;
        private ArrayList<Object> list;

        public SimpleListModel(ArrayList<Object> list) {
            this.list = list;
        }

        @Override
        public int getSize() {
            return this.list.size();
        }

        @Override
        public Object getElementAt(int i) {
            return this.list.get(i);
        }
    }
}

