// model-body.mustache

// licenseInfo.mustache

/**
 * Libre Graph API
 * Libre Graph is a free API for cloud collaboration inspired by the MS Graph API.
 *
 * The version of the OpenAPI document: v1.0.4
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

#include "OAIApplication.h"

#include <QDebug>
#include <QJsonArray>
#include <QJsonDocument>
#include <QObject>

#include "OAIHelpers.h"

namespace OpenAPI {

class OAIApplicationPrivate {
    friend class OAIApplication;

     QString id;
     bool id_isSet;
     bool id_isValid;

     QList<OAIAppRole> app_roles;
     bool app_roles_isSet;
     bool app_roles_isValid;

     QString display_name;
     bool display_name_isSet;
     bool display_name_isValid;
};

OAIApplication::OAIApplication()
    : d_ptr()
{
}

OAIApplication::OAIApplication(const OAIApplication& other)
    : d_ptr(other.d_ptr)
{
}

OAIApplication::OAIApplication(QString json)
    : d_ptr(nullptr)
{
    this->fromJson(json);
}

OAIApplication::~OAIApplication() = default;

void OAIApplication::initializeModel() {
    if (d_ptr == nullptr) {
        d_ptr.reset(new OAIApplicationPrivate{});

        Q_D(OAIApplication);


        d->id_isSet = false;
        d->id_isValid = false;

        d->app_roles_isSet = false;
        d->app_roles_isValid = false;

        d->display_name_isSet = false;
        d->display_name_isValid = false;
    }
}

void OAIApplication::fromJson(QString jsonString) {
    QByteArray array(jsonString.toUtf8());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
}

void OAIApplication::fromJsonObject(QJsonObject json) {
    initializeModel();

    Q_D(OAIApplication);

    d->id_isValid = ::OpenAPI::fromJsonValue(d->id, json[QString("id")]);
    d->id_isSet = !json[QString("id")].isNull() && d->id_isValid;

    d->app_roles_isValid = ::OpenAPI::fromJsonValue(d->app_roles, json[QString("appRoles")]);
    d->app_roles_isSet = !json[QString("appRoles")].isNull() && d->app_roles_isValid;

    d->display_name_isValid = ::OpenAPI::fromJsonValue(d->display_name, json[QString("displayName")]);
    d->display_name_isSet = !json[QString("displayName")].isNull() && d->display_name_isValid;
}

QString OAIApplication::asJson() const {
    QJsonObject obj = this->asJsonObject();
    QJsonDocument doc(obj);
    QByteArray bytes = doc.toJson();
    return QString(bytes);
}

QJsonObject OAIApplication::asJsonObject() const {
    Q_D(const OAIApplication);
    if(!d){
        return {};
    }
    QJsonObject obj;
    if (d->id_isSet) {
        obj.insert(QString("id"), ::OpenAPI::toJsonValue(d->id));
    }
    if (d->app_roles.size() > 0) {
        obj.insert(QString("appRoles"), ::OpenAPI::toJsonValue(d->app_roles));
    }
    if (d->display_name_isSet) {
        obj.insert(QString("displayName"), ::OpenAPI::toJsonValue(d->display_name));
    }
    return obj;
}

QString OAIApplication::getId() const {
    Q_D(const OAIApplication);
    if(!d){
        return {};
    }
    return d->id;
}
void OAIApplication::setId(const QString &id) {
    Q_D(OAIApplication);
    Q_ASSERT(d);

    d->id = id;
    d->id_isSet = true;
}

bool OAIApplication::is_id_Set() const{
    Q_D(const OAIApplication);
    if(!d){
        return false;
    }

    return d->id_isSet;
}

bool OAIApplication::is_id_Valid() const{
    Q_D(const OAIApplication);
    if(!d){
        return false;
    }
    return d->id_isValid;
}

QList<OAIAppRole> OAIApplication::getAppRoles() const {
    Q_D(const OAIApplication);
    if(!d){
        return {};
    }
    return d->app_roles;
}
void OAIApplication::setAppRoles(const QList<OAIAppRole> &app_roles) {
    Q_D(OAIApplication);
    Q_ASSERT(d);

    d->app_roles = app_roles;
    d->app_roles_isSet = true;
}

bool OAIApplication::is_app_roles_Set() const{
    Q_D(const OAIApplication);
    if(!d){
        return false;
    }

    return d->app_roles_isSet;
}

bool OAIApplication::is_app_roles_Valid() const{
    Q_D(const OAIApplication);
    if(!d){
        return false;
    }
    return d->app_roles_isValid;
}

QString OAIApplication::getDisplayName() const {
    Q_D(const OAIApplication);
    if(!d){
        return {};
    }
    return d->display_name;
}
void OAIApplication::setDisplayName(const QString &display_name) {
    Q_D(OAIApplication);
    Q_ASSERT(d);

    d->display_name = display_name;
    d->display_name_isSet = true;
}

bool OAIApplication::is_display_name_Set() const{
    Q_D(const OAIApplication);
    if(!d){
        return false;
    }

    return d->display_name_isSet;
}

bool OAIApplication::is_display_name_Valid() const{
    Q_D(const OAIApplication);
    if(!d){
        return false;
    }
    return d->display_name_isValid;
}

bool OAIApplication::isSet() const {
    Q_D(const OAIApplication);
    if(!d){
        return false;
    }
    bool isObjectUpdated = false;
    do {
        if (d->id_isSet) {
            isObjectUpdated = true;
            break;
        }

        if (d->app_roles.size() > 0) {
            isObjectUpdated = true;
            break;
        }

        if (d->display_name_isSet) {
            isObjectUpdated = true;
            break;
        }
    } while (false);
    return isObjectUpdated;
}

bool OAIApplication::isValid() const {
    Q_D(const OAIApplication);
    if(!d){
        return false;
    }
    // only required properties are required for the object to be considered valid
    return d->id_isValid && true;
}

} // namespace OpenAPI
