# SPDX-License-Identifier: MPL-2.0
# Copyright ijl (2023-2025)

import datetime

import orjson

from .util import needs_data, read_fixture_bytes

FIXTURE_ISSUE_335 = {
    "pfkrpavmb": "maxyjzmvacdwjfiifmzwbztjmnqdsjesykpf",
    "obtsdcnmi": "psyucdnwjr",
    "ghsccsccdwep": 1673954411550,
    "vyqvkq": "ilfcrjas",
    "drfobem": {
        "mzqwuvwsglxx": 1673954411550,
        "oup": "mmimyli",
        "pxfepg": {
            "pnqjr": "ylttscz",
            "rahfmy": "xrcsutu",
            "rccgrkom": "fbt",
            "xulnoryigkhtoybq": "hubxdjrnaq",
            "vdwriwvlgu": datetime.datetime(
                2023,
                1,
                15,
                15,
                23,
                38,
                686000,
                tzinfo=datetime.timezone.utc,
            ),
            "fhmjsszqmxwfruiq": "fzghfrbjxqccf",
            "dyiurstuzhu": None,
            "tdovgfimofmclc": datetime.datetime(
                2023,
                1,
                15,
                15,
                23,
                38,
                686000,
                tzinfo=datetime.timezone.utc,
            ),
            "iyxkgbwxdlrdc": datetime.datetime(
                2023,
                1,
                17,
                11,
                19,
                55,
                761000,
                tzinfo=datetime.timezone.utc,
            ),
            "jnjtckehsrtwhgzuhksmclk": ["tlejijcpbjzygepptbxgrugcbufncyupnivbljzhxe"],
            "zewoojzsiykjf": datetime.datetime(
                2023,
                1,
                17,
                11,
                17,
                46,
                140960,
                tzinfo=datetime.timezone.utc,
            ),
            "muzabbfnxptvqwzbeilkz": False,
            "wdiuepootdqyniogblxgwkgcqezutcesb": None,
            "lzkthufcerqnxdypdts": datetime.datetime(
                2023,
                1,
                17,
                11,
                19,
                56,
                73000,
                tzinfo=datetime.timezone.utc,
            ),
            "epukgzafaubmn": 50000.0,
            "cdpeessdedncodoajdqsos": 50000.0,
            "adxucexfjgfwxo": "jwuoomwdrfklgt",
            "sotxdizdpuunbssidop": None,
            "lxmgvysiltbzfkjne": None,
            "wyeaarjbilfmjbfzjuzv": None,
            "cwlcgx": -1272.22,
            "oniptvyaub": -1275.75,
            "hqsfeelokxlwnha": datetime.datetime(
                2023,
                1,
                17,
                11,
                19,
                55,
                886000,
                tzinfo=datetime.timezone.utc,
            ),
            "nuidlcyrxcrkyytgrnmc": -733.5,
            "wmofdeftonjcdnkg": -737.03,
            "bnsttxjfxxgxphfiguqew": datetime.datetime(
                2023,
                1,
                17,
                11,
                19,
                55,
                886000,
                tzinfo=datetime.timezone.utc,
            ),
            "audhoqqxjliwnsqttwsadmwwv": -737.03,
            "badwwjzugwtdkbsamckoljfrrumtrt": datetime.datetime(
                2023,
                1,
                17,
                11,
                19,
                55,
                886000,
                tzinfo=datetime.timezone.utc,
            ),
            "zlbggbbjgsugkgkqjycxwdx": -1241.28,
            "fxueeffryeafcxtkfzdmlmgu": -538.72,
            "yjmapfqummrsyujkosmixumjgfkwd": datetime.datetime(
                2023,
                1,
                16,
                22,
                59,
                59,
                999999,
                tzinfo=datetime.timezone.utc,
            ),
            "qepdxlodjetleseyminybdvitcgd": None,
            "ltokvpltajwbn": datetime.date(2023, 1, 17),
            "ifzhionnrpeoorsupiniwbljek": datetime.datetime(
                2023,
                1,
                17,
                11,
                19,
                49,
                113000,
                tzinfo=datetime.timezone.utc,
            ),
            "ljmmehacdawrlbhlhthm": -1241.28,
            "jnwffrtloedorwctsclshnpwjq": -702.56,
            "yhgssmtrmrcqhsdaekvoxyv": None,
            "nfzljididdzkofkrjfxdloygjxfhhoe": None,
            "mpctjlifbrgugaugiijj": None,
            "ckknohnsefzknbvnmwzlxlajsckl": None,
            "rfehqmeeslkcfbptrrghvivcrx": None,
            "nqeovbshknctkgkcytzbhfuvpcyamfrafi": None,
            "lptomdhvkvjnegsanzshqecas": 0,
            "vkbijuitbghlywkeojjf": None,
            "hzzmtggbqdglch": "xgehztikx",
            "yhmplqyhbndcfdafjvvr": False,
            "oucaxvjhjapayexuqwvnnls": None,
            "xbnagbhttfloffstxyr": 1673954411.5502248,
            "eiqrshvbjmlyzqle": {
                "dkayiglkkhfrvbliqy": ["ohjuifj"],
                "grqcjzqdiaslqaxhcqg": ["fuuxwsu"],
            },
            "uflenvgkk": {
                "ehycwsz": {
                    "jeikui": "noxawd",
                    "gkrefq": "hfonlfp",
                    "xkxs": "jzt",
                    "ztpmv": "mpscuot",
                    "zagmfzmgh": "pdculhh",
                    "jgzsrpukwqoln": 100000.0,
                    "vlqzkxbwc": datetime.datetime(
                        2023,
                        1,
                        17,
                        11,
                        19,
                        50,
                        867000,
                        tzinfo=datetime.timezone.utc,
                    ),
                    "cchovdmelbchcgvtg": -30.94,
                    "xvznnjfpwtdujqrh": 0.92059,
                    "tmsqwiiopyhlcovcxhojuzzyac": 1.0862009,
                    "tfzkaimjrpsbeswnrxeo": 0.0,
                    "isqjxmjupeiboufeaavkdj": -9.76,
                    "ywjqjiasfuifyqmz": 0.0,
                    "uvtlmdrk": 0.92028,
                    "dquzguej": None,
                    "guudreveynvhvhihegoybqrmejkj": datetime.datetime(
                        2023,
                        1,
                        17,
                        11,
                        19,
                        56,
                        73000,
                        tzinfo=datetime.timezone.utc,
                    ),
                    "agvnijfztpbpatej": "zym",
                    "mqsozcvnuvueixszfz": [
                        {
                            "oepzcayabl": "givcnhztbdmili",
                            "rhhaorqbiziqvyhglecqw": True,
                            "paxvrmateisxfqs": 1.0862009,
                            "bydrnmhvj": {
                                "kwqlickvqv": "beinfgmofalgytujorwxqfvlxtbeujmqwrdqzkfpul",
                                "cxdikf": "dfpbnpe",
                                "dnnhiy": "reeenz",
                                "tx": datetime.datetime(
                                    2023,
                                    1,
                                    17,
                                    11,
                                    19,
                                    56,
                                    73000,
                                    tzinfo=datetime.timezone.utc,
                                ),
                                "tck": datetime.date(2023, 1, 17),
                                "nvt": 0.92064,
                                "enc": 0.92059,
                                "icginezbybhcs": 1673954396073,
                                "gfamgxmknxirghgmtxl": 1673954411.5492423,
                            },
                        },
                    ],
                    "dqiabsyky": {
                        "hxzdtwunrr": "fozhshbmijhujcznqykxtlaxfbtdpzvwvjtyuqzlyw",
                        "tmpscl": "tbivvoa",
                        "vjjjvl": "arukeb",
                        "fm": datetime.datetime(
                            2023,
                            1,
                            17,
                            11,
                            19,
                            56,
                            73000,
                            tzinfo=datetime.timezone.utc,
                        ),
                        "rjq": datetime.date(2023, 1, 17),
                        "oax": 0.92064,
                        "gdv": 0.92059,
                        "vousomtllbpsh": 1673954396073,
                        "pgiblyqswxvwkpmpyay": 1673954411.5492423,
                    },
                    "gebil": [
                        {
                            "bzrjh": 0.92065,
                            "izmljcvqinm": 3.25,
                            "legczrbxlrmcep": None,
                        },
                    ],
                    "eqg": [
                        {
                            "yngp": "kako",
                            "udntq": {
                                "wzygahsmwd": "hplammnltegchpaorxaremhymtqtxdpfzzoyouimnw",
                                "iofcbwwgu": datetime.datetime(
                                    2023,
                                    1,
                                    17,
                                    11,
                                    19,
                                    50,
                                    867000,
                                    tzinfo=datetime.timezone.utc,
                                ),
                                "nengib": "zpyilz",
                                "sorpcw": "ixhzipg",
                                "kruw": "taq",
                                "vaqaj": "kravspj",
                                "omkjhzkxp": "watatag",
                                "ckwtjcqkjxmdn": 100000.0,
                                "kpjtgiuhfqx": 3.25,
                                "upkgqboyyg": 0.92065,
                                "gkshzyqtpmolnybr": 0.92065,
                                "oeiueaildnobcyzzpqwjwivkgj": 1.0861891,
                                "hiheqtjxyjnweryve": 0.0,
                                "wntcyohtaeylkylp": 0.0,
                                "jmebuufukzzymohzynpxzp": -9.76,
                                "rblubytyjuvbeurwrqmz": 0.0,
                                "xpscrgcnratymu": None,
                            },
                        },
                    ],
                    "kpmgmiqgmswzebawzciss": -0.7,
                    "ktggnjdemtfxhnultritqokgbjucktdiooic": 0.92058,
                    "oawdfonaymcwwvmszhdlemjcnb": datetime.datetime(
                        2023,
                        1,
                        17,
                        11,
                        19,
                        55,
                        886000,
                        tzinfo=datetime.timezone.utc,
                    ),
                    "bwfkzqjqqjdgbfbbjwoxhweihipy": "lzvn",
                    "feslxjpurrukajwellwjqww": 0.0,
                    "ptuysyuuhwkfqlugjlxkohwanzijtzknupfikp": None,
                    "gquuleqhpsbyiluhijdddreenggl": datetime.datetime(
                        2023,
                        1,
                        17,
                        11,
                        19,
                        50,
                        867000,
                        tzinfo=datetime.timezone.utc,
                    ),
                    "auhxrvhvvtszkkkpyhbhvpjlypjoyz": "vqdxfdvgxqcu",
                },
            },
        },
        "qbov": "vylhkevwf",
        "uidiyv": {
            "qkyoj": {
                "cclzxqbosqmj": 1673954395761,
                "rzijfrywwwcr": 1,
                "toujesmzk": "afnu",
                "aqmpunnlt": "nyreokscjljpfcrrstxgvwddphymgzkvuolbigqhla",
                "ofrjrk": "rlffwrw",
                "legyfjl": {
                    "byalenyqro": "tbzhyxo",
                    "qxrtujt": 0.92028,
                    "onmhbvy": 0,
                    "cbhmp": "vqrkzbg",
                },
            },
        },
    },
}


@needs_data
def test_issue331_1_pretty():
    as_bytes = read_fixture_bytes("issue331_1.json.xz")
    as_obj = orjson.loads(as_bytes)
    for _ in range(1000):
        assert orjson.loads(orjson.dumps(as_obj, option=orjson.OPT_INDENT_2)) == as_obj


@needs_data
def test_issue331_1_compact():
    as_bytes = read_fixture_bytes("issue331_1.json.xz")
    as_obj = orjson.loads(as_bytes)
    for _ in range(1000):
        assert orjson.loads(orjson.dumps(as_obj)) == as_obj


@needs_data
def test_issue331_2_pretty():
    as_bytes = read_fixture_bytes("issue331_2.json.xz")
    as_obj = orjson.loads(as_bytes)
    for _ in range(1000):
        assert orjson.loads(orjson.dumps(as_obj, option=orjson.OPT_INDENT_2)) == as_obj


@needs_data
def test_issue331_2_compact():
    as_bytes = read_fixture_bytes("issue331_2.json.xz")
    as_obj = orjson.loads(as_bytes)
    for _ in range(1000):
        assert orjson.loads(orjson.dumps(as_obj)) == as_obj


def test_issue335_compact():
    for _ in range(1000):
        assert orjson.dumps(FIXTURE_ISSUE_335)


def test_issue335_pretty():
    for _ in range(1000):
        assert orjson.dumps(FIXTURE_ISSUE_335, option=orjson.OPT_INDENT_2)
