// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>A Retention configuration for an object.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct ObjectLockRetention {
    /// <p>Indicates the Retention mode for the specified object.</p>
    pub mode: ::std::option::Option<crate::types::ObjectLockRetentionMode>,
    /// <p>The date on which this Object Lock Retention will expire.</p>
    pub retain_until_date: ::std::option::Option<::aws_smithy_types::DateTime>,
}
impl ObjectLockRetention {
    /// <p>Indicates the Retention mode for the specified object.</p>
    pub fn mode(&self) -> ::std::option::Option<&crate::types::ObjectLockRetentionMode> {
        self.mode.as_ref()
    }
    /// <p>The date on which this Object Lock Retention will expire.</p>
    pub fn retain_until_date(&self) -> ::std::option::Option<&::aws_smithy_types::DateTime> {
        self.retain_until_date.as_ref()
    }
}
impl ObjectLockRetention {
    /// Creates a new builder-style object to manufacture [`ObjectLockRetention`](crate::types::ObjectLockRetention).
    pub fn builder() -> crate::types::builders::ObjectLockRetentionBuilder {
        crate::types::builders::ObjectLockRetentionBuilder::default()
    }
}

/// A builder for [`ObjectLockRetention`](crate::types::ObjectLockRetention).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct ObjectLockRetentionBuilder {
    pub(crate) mode: ::std::option::Option<crate::types::ObjectLockRetentionMode>,
    pub(crate) retain_until_date: ::std::option::Option<::aws_smithy_types::DateTime>,
}
impl ObjectLockRetentionBuilder {
    /// <p>Indicates the Retention mode for the specified object.</p>
    pub fn mode(mut self, input: crate::types::ObjectLockRetentionMode) -> Self {
        self.mode = ::std::option::Option::Some(input);
        self
    }
    /// <p>Indicates the Retention mode for the specified object.</p>
    pub fn set_mode(mut self, input: ::std::option::Option<crate::types::ObjectLockRetentionMode>) -> Self {
        self.mode = input;
        self
    }
    /// <p>Indicates the Retention mode for the specified object.</p>
    pub fn get_mode(&self) -> &::std::option::Option<crate::types::ObjectLockRetentionMode> {
        &self.mode
    }
    /// <p>The date on which this Object Lock Retention will expire.</p>
    pub fn retain_until_date(mut self, input: ::aws_smithy_types::DateTime) -> Self {
        self.retain_until_date = ::std::option::Option::Some(input);
        self
    }
    /// <p>The date on which this Object Lock Retention will expire.</p>
    pub fn set_retain_until_date(mut self, input: ::std::option::Option<::aws_smithy_types::DateTime>) -> Self {
        self.retain_until_date = input;
        self
    }
    /// <p>The date on which this Object Lock Retention will expire.</p>
    pub fn get_retain_until_date(&self) -> &::std::option::Option<::aws_smithy_types::DateTime> {
        &self.retain_until_date
    }
    /// Consumes the builder and constructs a [`ObjectLockRetention`](crate::types::ObjectLockRetention).
    pub fn build(self) -> crate::types::ObjectLockRetention {
        crate::types::ObjectLockRetention {
            mode: self.mode,
            retain_until_date: self.retain_until_date,
        }
    }
}
