/*imagemath all functions that do library independent pixel calculations*/
#include "defs.h"
#include "imageio.h"

/*Internal functions:-------------------------------------------------------*/
inline long min(long a, long b) {
   if (a<b) return a;
   return b;
}
inline long max(long a, long b) {
   if (a>b) return a;
   return b;
}
inline long val(long a) {
   if (a<0) return -a;
   return a;
}

/*External functions:-------------------------------------------------------*/

inline int scalepixelim(ImagePtr im, long x1, long y1, long x2, long y2) {
/*Gives back the average brightness of a pixel area specified*/
/*in 1/256 pixels in both directions*/

   long tx,xscale,ty,yscale,sum;	/*working vars*/
   unsigned long long actual;

   sum=(x2-x1)*(y2-y1);
   actual=0;
   tx=x1-(x1%256);
   while (tx<x2) {
      xscale=min(tx+256,x2)-max(tx,x1);
      ty=y1-(y1%256);
      while (ty<y2) {
         yscale=min(ty+256,y2)-max(ty,y1);
	 actual+=xscale*yscale*pixelbrightim(im,tx/256,ty/256);
         ty+=256;
      }
      tx+=256;
   }
   /*go through every pixel involved and calculate its area, then*/
   /*add its value times area to the overallbrightness*/
   actual/=sum;
   /*divide the overall brightness through the overall area*/
   return (int)actual;
}

/*---------------------------------------------------------------------------*/

inline int diffscalepixelim(ImagePtr im, long x1, long y1, long x2, long y2) {
/*Gives back the average difference of a pixel area specified*/
/*in 1/256 pixels in both directions*/

   long tx,xscale,ty,yscale,sum,average;	/*working vars*/
   unsigned long long actual;

   sum=(x2-x1)*(y2-y1);
   actual=0;
   average=scalepixelim(im,x1,y1,x2,y2);
   
   tx=x1-(x1%256);
   while (tx<x2) {
      xscale=min(tx+256,x2)-max(tx,x1);
      ty=y1-(y1%256);
      while (ty<y2) {
         yscale=min(ty+256,y2)-max(ty,y1);
	 actual+=xscale*yscale*val(pixelbrightim(im,tx/256,ty/256)-average);
         ty+=256;
      }
      tx+=256;
   }
   /*go through every pixel involved and calculate its area, then*/
   /*add its difference times area to the overalldifference*/
   actual/=sum;
   /*divide the overall difference through the overall area*/
   return actual;
}


/*---------------------------------------------------------------------------*/

inline int xsectorsim(ImagePtr im,int sectorsize) {
   int answer; /*return value*/
   answer=( widthim(im)/sectorsize );
   return answer;
}

inline int ysectorsim(ImagePtr im, int sectorsize) {
   int answer; /*return value*/
   answer=( heightim(im)/sectorsize );
   return answer;
}
/*Give back the amount of sectors in x and y direction in im*/
/*---------------------------------------------------------------------------*/

inline int drawsectorim(ImagePtr im,int xpos, int ypos, int color,int sectorsize,int method) {
/*Draws or Outlines a sector in im, not sure yet <g>*/
/*0 if OK, -1 if i am not too lazy to detect errors here <g>*/
/*method 0 will draw the whole sector, method 1 only outlines it*/


   int t,tt,x,y;
   x=xpos*sectorsize;
   y=ypos*sectorsize;
   if (method==0) {
      t=0;
      while (t<sectorsize) {
         tt=0;
         while (tt<sectorsize) {
            drawpixelim(im,x+t,y+tt,color);
            tt++;
         }
         t++;
      }
   } else {
      t=0;
      while (t<sectorsize) {
	 drawpixelim(im,x+t,y,color);
	 drawpixelim(im,x+t,y+sectorsize-1,color);
	 t++;
      }
      t=1;
      while (t<sectorsize-1) {
	 drawpixelim(im,x,y+t,color);
	 drawpixelim(im,x+sectorsize-1,y+t,color);
	 t++;
      }
      
   }

   return 0;
   /* TODO: be less lazy */
}

