<!--⚠️ Note that this file is in Markdown but contains specific syntax for our doc-builder (similar to MDX) that may not be
rendered properly in your Markdown viewer.
-->

# 🤗 Hub client bibliothek

Die `huggingface_hub` Bibliothek ermöglicht die Interaktion mit dem [Hugging Face Hub](https://hf.co), einer Plattform für maschinelles Lernen, die für Entwickler und Mitwirkende konzipiert ist. Hier können Sie vorab trainierte Modelle und Datensätze entdecken, mit zahlreichen Apps für maschinelles Lernen experimentieren und eigene Modelle sowie Datensätze mit der Community teilen. Die `huggingface_hub` Bibliothek macht es einfach, all das in Python umzusetzen.

In der [Kurzanleitung](quick-start) der `huggingface_hub` Bibliothek erfahren Sie wie Sie Dateien vom Hub herunterladen, Repositories erstellen und Inhalte auf den Hub hochladen können. Weiterführend können Sie sich über Verwaltung von Repositories, die Interaktion in Diskussionen und den Zugriff auf die Inferenz-API auf dem 🤗 Hub informieren.

<div class="mt-10">
  <div class="w-full flex flex-col space-y-4 md:space-y-0 md:grid md:grid-cols-2 md:gap-y-4 md:gap-x-5">

    <a class="!no-underline border dark:border-gray-700 p-5 rounded-lg shadow hover:shadow-lg" href="./guides/overview">
      <div class="w-full text-center bg-gradient-to-br from-indigo-400 to-indigo-500 rounded-lg py-1.5 font-semibold mb-5 text-white text-lg leading-relaxed">Schritt-für-Schritt-Anleitungen</div>
      <p class="text-gray-700">Praktische Leitfäden, um ein bestimmtes Ziel zu erreichen. Durchstöbern Sie diese Anleitungen, um zu erfahren, wie Sie mit huggingface_hub echte Herausforderungen meistern können.</p>
    </a>

    <a class="!no-underline border dark:border-gray-700 p-5 rounded-lg shadow hover:shadow-lg" href="./concepts/git_vs_http">
      <div class="w-full text-center bg-gradient-to-br from-pink-400 to-pink-500 rounded-lg py-1.5 font-semibold mb-5 text-white text-lg leading-relaxed">Konzeptionelle Leitfäden</div>
      <p class="text-gray-700">Methodische Erklärungen zum Aufbau eines besseren Verständnisses der Huggingface_hub-Philosophie.</p>
    </a>

  </div>
</div>

<!-- <a class="!no-underline border dark:border-gray-700 p-5 rounded-lg shadow hover:shadow-lg" href="./package_reference/overview">
  <div class="w-full text-center bg-gradient-to-br from-purple-400 to-purple-500 rounded-lg py-1.5 font-semibold mb-5 text-white text-lg leading-relaxed">Referenz</div>
  <p class="text-gray-700">Umfassende und technische Beschreibung der Klassen und Methoden von huggingface_hub.</p>
</a> -->

<!--
<a class="!no-underline border dark:border-gray-700 p-5 rounded-lg shadow hover:shadow-lg" href="./tutorials/overview"
  ><div class="w-full text-center bg-gradient-to-br from-blue-400 to-blue-500 rounded-lg py-1.5 font-semibold mb-5 text-white text-lg leading-relaxed">Tutorials</div>
  <p class="text-gray-700">Learn the basics and become familiar with using huggingface_hub to programmatically interact with the 🤗 Hub!</p>
</a> -->

## Beitragen

Alle Beiträge zum `huggingface_hub` sind willkommen und werden gleichermaßen geschätzt! 🤗 Neben dem Hinzufügen neuer Features oder dem Beheben von Problemen können Sie auch zur Verbesserung der Dokumentation beitragen, indem Sie ihre Richtigkeit und Aktualität gewährleisten. Sie können auch bei der Lösung von Fragen mithelfen oder neue Features vorschlagen, um die Bibliothek weiterzuentwickeln. Schauen Sie in die [Beitragsrichtlinien](https://github.com/huggingface/huggingface_hub/blob/main/CONTRIBUTING.md), um mehr zu erfahren über das Melden von Problemen, das Vorschlagen von Features, das Einreichen eines Pull Requests, und das Testen Ihrer Code-Einsendungen, um sicherzustellen dass alles so wie erwartet funktioniert.

Mitwirkende halten sich bitte an unseren [Verhaltenskodex](https://github.com/huggingface/huggingface_hub/blob/main/CODE_OF_CONDUCT.md), um eine inklusive und einladende Umgebung zur Zusammenarbeit für Alle zu gewährleisten.
