/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_cs extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_lad = "ladinština";
        final String metaValue_ccp = "čakma";
        final String metaValue_kpe = "kpelle";
        final String metaValue_nqo = "n’ko";
        final Object[][] data = new Object[][] {
            { "001", "svět" },
            { "002", "Afrika" },
            { "003", "Severní Amerika" },
            { "005", "Jižní Amerika" },
            { "009", "Oceánie" },
            { "011", "západní Afrika" },
            { "013", "Střední Amerika" },
            { "014", "východní Afrika" },
            { "015", "severní Afrika" },
            { "017", "střední Afrika" },
            { "018", "jižní Afrika" },
            { "019", "Amerika" },
            { "021", "Severní Amerika (oblast)" },
            { "029", "Karibik" },
            { "030", "východní Asie" },
            { "034", "jižní Asie" },
            { "035", "jihovýchodní Asie" },
            { "039", "jižní Evropa" },
            { "053", "Australasie" },
            { "054", "Melanésie" },
            { "057", "Mikronésie (region)" },
            { "061", "Polynésie" },
            { "142", "Asie" },
            { "143", "Střední Asie" },
            { "145", "západní Asie" },
            { "150", "Evropa" },
            { "151", "východní Evropa" },
            { "154", "severní Evropa" },
            { "155", "západní Evropa" },
            { "202", "subsaharská Afrika" },
            { "419", "Latinská Amerika" },
            { "AC", "Ascension" },
            { "AD", "Andorra" },
            { "AE", "Spojené arabské emiráty" },
            { "AF", "Afghánistán" },
            { "AG", "Antigua a Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Albánie" },
            { "AM", "Arménie" },
            { "AO", "Angola" },
            { "AQ", "Antarktida" },
            { "AR", "Argentina" },
            { "AS", "Americká Samoa" },
            { "AT", "Rakousko" },
            { "AU", "Austrálie" },
            { "AW", "Aruba" },
            { "AX", "Ålandy" },
            { "AZ", "Ázerbájdžán" },
            { "BA", "Bosna a Hercegovina" },
            { "BB", "Barbados" },
            { "BD", "Bangladéš" },
            { "BE", "Belgie" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulharsko" },
            { "BH", "Bahrajn" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Svatý Bartoloměj" },
            { "BM", "Bermudy" },
            { "BN", "Brunej" },
            { "BO", "Bolívie" },
            { "BQ", "Karibské Nizozemsko" },
            { "BR", "Brazílie" },
            { "BS", "Bahamy" },
            { "BT", "Bhútán" },
            { "BV", "Bouvetův ostrov" },
            { "BW", "Botswana" },
            { "BY", "Bělorusko" },
            { "BZ", "Belize" },
            { "CA", "Kanada" },
            { "CC", "Kokosové ostrovy" },
            { "CD", "Kongo – Kinshasa" },
            { "CF", "Středoafrická republika" },
            { "CG", "Kongo – Brazzaville" },
            { "CH", "Švýcarsko" },
            { "CI", "Pobřeží slonoviny" },
            { "CK", "Cookovy ostrovy" },
            { "CL", "Chile" },
            { "CM", "Kamerun" },
            { "CN", "Čína" },
            { "CO", "Kolumbie" },
            { "CP", "Clippertonův ostrov" },
            { "CQ", "Sark" },
            { "CR", "Kostarika" },
            { "CU", "Kuba" },
            { "CV", "Kapverdy" },
            { "CW", "Curaçao" },
            { "CX", "Vánoční ostrov" },
            { "CY", "Kypr" },
            { "CZ", "Česko" },
            { "DE", "Německo" },
            { "DG", "Diego García" },
            { "DJ", "Džibutsko" },
            { "DK", "Dánsko" },
            { "DM", "Dominika" },
            { "DO", "Dominikánská republika" },
            { "DZ", "Alžírsko" },
            { "EA", "Ceuta a Melilla" },
            { "EC", "Ekvádor" },
            { "EE", "Estonsko" },
            { "EG", "Egypt" },
            { "EH", "Západní Sahara" },
            { "ER", "Eritrea" },
            { "ES", "Španělsko" },
            { "ET", "Etiopie" },
            { "EU", "Evropská unie" },
            { "EZ", "eurozóna" },
            { "FI", "Finsko" },
            { "FJ", "Fidži" },
            { "FK", "Falklandské ostrovy" },
            { "FM", "Mikronésie" },
            { "FO", "Faerské ostrovy" },
            { "FR", "Francie" },
            { "GA", "Gabon" },
            { "GB", "Spojené království" },
            { "GD", "Grenada" },
            { "GE", "Gruzie" },
            { "GF", "Francouzská Guyana" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "GL", "Grónsko" },
            { "GM", "Gambie" },
            { "GN", "Guinea" },
            { "GP", "Guadeloupe" },
            { "GQ", "Rovníková Guinea" },
            { "GR", "Řecko" },
            { "GS", "Jižní Georgie a Jižní Sandwichovy ostrovy" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Guinea-Bissau" },
            { "GY", "Guyana" },
            { "HK", "Hongkong – ZAO Číny" },
            { "HM", "Heardův ostrov a McDonaldovy ostrovy" },
            { "HN", "Honduras" },
            { "HR", "Chorvatsko" },
            { "HT", "Haiti" },
            { "HU", "Maďarsko" },
            { "IC", "Kanárské ostrovy" },
            { "ID", "Indonésie" },
            { "IE", "Irsko" },
            { "IL", "Izrael" },
            { "IM", "Ostrov Man" },
            { "IN", "Indie" },
            { "IO", "Britské indickooceánské území" },
            { "IQ", "Irák" },
            { "IR", "Írán" },
            { "IS", "Island" },
            { "IT", "Itálie" },
            { "JE", "Jersey" },
            { "JM", "Jamajka" },
            { "JO", "Jordánsko" },
            { "JP", "Japonsko" },
            { "KE", "Keňa" },
            { "KG", "Kyrgyzstán" },
            { "KH", "Kambodža" },
            { "KI", "Kiribati" },
            { "KM", "Komory" },
            { "KN", "Svatý Kryštof a Nevis" },
            { "KP", "Severní Korea" },
            { "KR", "Jižní Korea" },
            { "KW", "Kuvajt" },
            { "KY", "Kajmanské ostrovy" },
            { "KZ", "Kazachstán" },
            { "LA", "Laos" },
            { "LB", "Libanon" },
            { "LC", "Svatá Lucie" },
            { "LI", "Lichtenštejnsko" },
            { "LK", "Srí Lanka" },
            { "LR", "Libérie" },
            { "LS", "Lesotho" },
            { "LT", "Litva" },
            { "LU", "Lucembursko" },
            { "LV", "Lotyšsko" },
            { "LY", "Libye" },
            { "MA", "Maroko" },
            { "MC", "Monako" },
            { "MD", "Moldavsko" },
            { "ME", "Černá Hora" },
            { "MF", "Svatý Martin (Francie)" },
            { "MG", "Madagaskar" },
            { "MH", "Marshallovy ostrovy" },
            { "MK", "Severní Makedonie" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Barma)" },
            { "MN", "Mongolsko" },
            { "MO", "Macao – ZAO Číny" },
            { "MP", "Severní Mariany" },
            { "MQ", "Martinik" },
            { "MR", "Mauritánie" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Mauricius" },
            { "MV", "Maledivy" },
            { "MW", "Malawi" },
            { "MX", "Mexiko" },
            { "MY", "Malajsie" },
            { "MZ", "Mosambik" },
            { "NA", "Namibie" },
            { "NC", "Nová Kaledonie" },
            { "NE", "Niger" },
            { "NF", "Norfolk" },
            { "NG", "Nigérie" },
            { "NI", "Nikaragua" },
            { "NL", "Nizozemsko" },
            { "NO", "Norsko" },
            { "NP", "Nepál" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Nový Zéland" },
            { "OM", "Omán" },
            { "PA", "Panama" },
            { "PE", "Peru" },
            { "PF", "Francouzská Polynésie" },
            { "PG", "Papua-Nová Guinea" },
            { "PH", "Filipíny" },
            { "PK", "Pákistán" },
            { "PL", "Polsko" },
            { "PM", "Saint-Pierre a Miquelon" },
            { "PN", "Pitcairnovy ostrovy" },
            { "PR", "Portoriko" },
            { "PS", "Palestinská území" },
            { "PT", "Portugalsko" },
            { "PW", "Palau" },
            { "PY", "Paraguay" },
            { "QA", "Katar" },
            { "QO", "vnější Oceánie" },
            { "RE", "Réunion" },
            { "RO", "Rumunsko" },
            { "RS", "Srbsko" },
            { "RU", "Rusko" },
            { "RW", "Rwanda" },
            { "SA", "Saúdská Arábie" },
            { "SB", "Šalamounovy ostrovy" },
            { "SC", "Seychely" },
            { "SD", "Súdán" },
            { "SE", "Švédsko" },
            { "SG", "Singapur" },
            { "SH", "Svatá Helena" },
            { "SI", "Slovinsko" },
            { "SJ", "Špicberky a Jan Mayen" },
            { "SK", "Slovensko" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somálsko" },
            { "SR", "Surinam" },
            { "SS", "Jižní Súdán" },
            { "ST", "Svatý Tomáš a Princův ostrov" },
            { "SV", "Salvador" },
            { "SX", "Svatý Martin (Nizozemsko)" },
            { "SY", "Sýrie" },
            { "SZ", "Eswatini" },
            { "TA", "Tristan da Cunha" },
            { "TC", "Turks a Caicos" },
            { "TD", "Čad" },
            { "TF", "Francouzská jižní území" },
            { "TG", "Togo" },
            { "TH", "Thajsko" },
            { "TJ", "Tádžikistán" },
            { "TK", "Tokelau" },
            { "TL", "Východní Timor" },
            { "TM", "Turkmenistán" },
            { "TN", "Tunisko" },
            { "TO", "Tonga" },
            { "TR", "Turecko" },
            { "TT", "Trinidad a Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Tchaj-wan" },
            { "TZ", "Tanzanie" },
            { "UA", "Ukrajina" },
            { "UG", "Uganda" },
            { "UM", "Menší odlehlé ostrovy USA" },
            { "UN", "Organizace spojených národů" },
            { "US", "Spojené státy" },
            { "UY", "Uruguay" },
            { "UZ", "Uzbekistán" },
            { "VA", "Vatikán" },
            { "VC", "Svatý Vincenc a Grenadiny" },
            { "VE", "Venezuela" },
            { "VG", "Britské Panenské ostrovy" },
            { "VI", "Americké Panenské ostrovy" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis a Futuna" },
            { "WS", "Samoa" },
            { "XA", "simulovaná diakritika" },
            { "XB", "simulovaný obousměrný zápis" },
            { "XK", "Kosovo" },
            { "YE", "Jemen" },
            { "YT", "Mayotte" },
            { "ZA", "Jihoafrická republika" },
            { "ZM", "Zambie" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "neznámá oblast" },
            { "aa", "afarština" },
            { "ab", "abcházština" },
            { "ae", "avestánština" },
            { "af", "afrikánština" },
            { "ak", "akanština" },
            { "am", "amharština" },
            { "an", "aragonština" },
            { "ar", "arabština" },
            { "as", "ásámština" },
            { "av", "avarština" },
            { "ay", "ajmarština" },
            { "az", "ázerbájdžánština" },
            { "ba", "baškirština" },
            { "be", "běloruština" },
            { "bg", "bulharština" },
            { "bi", "bislamština" },
            { "bm", "bambarština" },
            { "bn", "bengálština" },
            { "bo", "tibetština" },
            { "br", "bretonština" },
            { "bs", "bosenština" },
            { "ca", "katalánština" },
            { "ce", "čečenština" },
            { "ch", "čamoro" },
            { "co", "korsičtina" },
            { "cr", "kríjština" },
            { "cs", "čeština" },
            { "cu", "staroslověnština" },
            { "cv", "čuvaština" },
            { "cy", "velština" },
            { "da", "dánština" },
            { "de", "němčina" },
            { "dv", "maledivština" },
            { "dz", "dzongkä" },
            { "ee", "eweština" },
            { "el", "řečtina" },
            { "en", "angličtina" },
            { "eo", "esperanto" },
            { "es", "španělština" },
            { "et", "estonština" },
            { "eu", "baskičtina" },
            { "fa", "perština" },
            { "ff", "fulbština" },
            { "fi", "finština" },
            { "fj", "fidžijština" },
            { "fo", "faerština" },
            { "fr", "francouzština" },
            { "fy", "fríština (západní)" },
            { "ga", "irština" },
            { "gd", "skotská gaelština" },
            { "gl", "galicijština" },
            { "gn", "guaranština" },
            { "gu", "gudžarátština" },
            { "gv", "manština" },
            { "ha", "hauština" },
            { "he", "hebrejština" },
            { "hi", "hindština" },
            { "ho", "hiri motu" },
            { "hr", "chorvatština" },
            { "ht", "haitština" },
            { "hu", "maďarština" },
            { "hy", "arménština" },
            { "hz", "hererština" },
            { "ia", "interlingua" },
            { "id", "indonéština" },
            { "ie", "interlingue" },
            { "ig", "igboština" },
            { "ii", "iština (sečuánská)" },
            { "ik", "inupiakština" },
            { "io", "ido" },
            { "is", "islandština" },
            { "it", "italština" },
            { "iu", "inuktitutština" },
            { "ja", "japonština" },
            { "jv", "javánština" },
            { "ka", "gruzínština" },
            { "kg", "konžština" },
            { "ki", "kikujština" },
            { "kj", "kuaňamština" },
            { "kk", "kazaština" },
            { "kl", "grónština" },
            { "km", "khmérština" },
            { "kn", "kannadština" },
            { "ko", "korejština" },
            { "kr", "kanuri" },
            { "ks", "kašmírština" },
            { "ku", "kurmándží" },
            { "kv", "komijština" },
            { "kw", "kornština" },
            { "ky", "kyrgyzština" },
            { "la", "latina" },
            { "lb", "lucemburština" },
            { "lg", "gandština" },
            { "li", "limburština" },
            { "ln", "lingalština" },
            { "lo", "laoština" },
            { "lt", "litevština" },
            { "lu", "lubu-katanžština" },
            { "lv", "lotyština" },
            { "mg", "malgaština" },
            { "mh", "maršálština" },
            { "mi", "maorština" },
            { "mk", "makedonština" },
            { "ml", "malajálamština" },
            { "mn", "mongolština" },
            { "mr", "maráthština" },
            { "ms", "malajština" },
            { "mt", "maltština" },
            { "my", "barmština" },
            { "na", "naurština" },
            { "nb", "norština (bokmål)" },
            { "nd", "ndebele (Zimbabwe)" },
            { "ne", "nepálština" },
            { "ng", "ndondština" },
            { "nl", "nizozemština" },
            { "nn", "norština (nynorsk)" },
            { "no", "norština" },
            { "nr", "ndebele (Jižní Afrika)" },
            { "nv", "navažština" },
            { "ny", "ňandžština" },
            { "oc", "okcitánština" },
            { "oj", "odžibvejština" },
            { "om", "oromština" },
            { "or", "urijština" },
            { "os", "osetština" },
            { "pa", "paňdžábština" },
            { "pi", "pálí" },
            { "pl", "polština" },
            { "ps", "paštština" },
            { "pt", "portugalština" },
            { "qu", "kečuánština" },
            { "rm", "rétorománština" },
            { "rn", "kirundština" },
            { "ro", "rumunština" },
            { "ru", "ruština" },
            { "rw", "kiňarwandština" },
            { "sa", "sanskrt" },
            { "sc", "sardština" },
            { "sd", "sindhština" },
            { "se", "sámština (severní)" },
            { "sg", "sangština" },
            { "sh", "srbochorvatština" },
            { "si", "sinhálština" },
            { "sk", "slovenština" },
            { "sl", "slovinština" },
            { "sm", "samojština" },
            { "sn", "šonština" },
            { "so", "somálština" },
            { "sq", "albánština" },
            { "sr", "srbština" },
            { "ss", "siswatština" },
            { "st", "sotština (jižní)" },
            { "su", "sundština" },
            { "sv", "švédština" },
            { "sw", "svahilština" },
            { "ta", "tamilština" },
            { "te", "telugština" },
            { "tg", "tádžičtina" },
            { "th", "thajština" },
            { "ti", "tigrinijština" },
            { "tk", "turkmenština" },
            { "tl", "tagalog" },
            { "tn", "setswanština" },
            { "to", "tongánština" },
            { "tr", "turečtina" },
            { "ts", "tsonga" },
            { "tt", "tatarština" },
            { "tw", "twi" },
            { "ty", "tahitština" },
            { "ug", "ujgurština" },
            { "uk", "ukrajinština" },
            { "ur", "urdština" },
            { "uz", "uzbečtina" },
            { "ve", "venda" },
            { "vi", "vietnamština" },
            { "vo", "volapük" },
            { "wa", "valonština" },
            { "wo", "wolofština" },
            { "xh", "xhoština" },
            { "yi", "jidiš" },
            { "yo", "jorubština" },
            { "za", "čuangština" },
            { "zh", "čínština" },
            { "zu", "zuluština" },
            { "ace", "acehština" },
            { "ach", "akolština" },
            { "ada", "adangme" },
            { "ady", "adygejština" },
            { "aeb", "arabština (tuniská)" },
            { "afh", "afrihili" },
            { "agq", "aghem" },
            { "ain", "ainština" },
            { "akk", "akkadština" },
            { "akz", "alabamština" },
            { "ale", "aleutština" },
            { "aln", "albánština (Gheg)" },
            { "alt", "altajština (jižní)" },
            { "ang", "staroangličtina" },
            { "ann", "obolo" },
            { "anp", "angika" },
            { "arc", "aramejština" },
            { "arn", "mapudungun" },
            { "aro", "araonština" },
            { "arp", "arapažština" },
            { "arq", "arabština (alžírská)" },
            { "ars", "arabština (Nadžd)" },
            { "arw", "arawacké jazyky" },
            { "ary", "arabština (marocká)" },
            { "arz", "arabština (egyptská)" },
            { "asa", "asu" },
            { "ase", "znaková řeč (americká)" },
            { "ast", "asturština" },
            { "atj", "atikamekština" },
            { "avk", "kotava" },
            { "awa", "awadhština" },
            { "bal", "balúčština" },
            { "ban", "balijština" },
            { "bar", "bavorština" },
            { "bas", "basa" },
            { "bax", "bamun" },
            { "bbc", "batak toba" },
            { "bbj", "ghomala" },
            { "bej", "bedža" },
            { "bem", "bembština" },
            { "bew", "batavština" },
            { "bez", "bena" },
            { "bfd", "bafut" },
            { "bfq", "badagština" },
            { "bgc", "harijánština" },
            { "bgn", "balúčština (západní)" },
            { "bho", "bhódžpurština" },
            { "bik", "bikolština" },
            { "bin", "bini" },
            { "bjn", "bandžarština" },
            { "bkm", "kom" },
            { "bla", "siksika" },
            { "blo", "aniiština" },
            { "bpy", "bišnuprijskomanipurština" },
            { "bqi", "bachtijárština" },
            { "bra", "bradžština" },
            { "brh", "brahujština" },
            { "brx", "bodoština" },
            { "bss", "akoose" },
            { "bua", "burjatština" },
            { "bug", "bugiština" },
            { "bum", "bulu" },
            { "byn", "blinština" },
            { "byv", "medumba" },
            { "cad", "caddo" },
            { "car", "karibština" },
            { "cay", "kajugština" },
            { "cch", "atsam" },
            { "ccp", metaValue_ccp },
            { "ceb", "cebuánština" },
            { "cgg", "kiga" },
            { "chb", "čibča" },
            { "chg", "čagatajština" },
            { "chk", "čukština" },
            { "chm", "marijština" },
            { "chn", "činuk pidžin" },
            { "cho", "čoktština" },
            { "chp", "čipevajština" },
            { "chr", "čerokézština" },
            { "chy", "čejenština" },
            { "cic", "čikasavština" },
            { "ckb", "kurdština (sorání)" },
            { "clc", "čilkotinština" },
            { "cop", "koptština" },
            { "cps", "kapiznonština" },
            { "crg", "mičif" },
            { "crh", "tatarština (krymská)" },
            { "crj", "kríjština (jihovýchodní)" },
            { "crk", "kríjština (z plání)" },
            { "crl", "kríjština (severovýchodní)" },
            { "crm", "kríjština (Moose)" },
            { "crr", "algonkinština (Karolína)" },
            { "crs", "kreolština (seychelská)" },
            { "csb", "kašubština" },
            { "csw", "kríjština (z bažin)" },
            { "dak", "dakotština" },
            { "dar", "dargština" },
            { "dav", "taita" },
            { "del", "delawarština" },
            { "den", "slejvština (athabaský jazyk)" },
            { "dgr", "dogrib" },
            { "din", "dinkština" },
            { "dje", "zarmština" },
            { "doi", "dogarština" },
            { "dsb", "dolnolužická srbština" },
            { "dtp", "kadazandusunština" },
            { "dua", "dualština" },
            { "dum", "holandština (středověká)" },
            { "dyo", "jola-fonyi" },
            { "dyu", "djula" },
            { "dzg", "dazaga" },
            { "ebu", "embu" },
            { "efi", "efikština" },
            { "egl", "emilijština" },
            { "egy", "egyptština stará" },
            { "eka", "ekajuk" },
            { "elx", "elamitština" },
            { "enm", "angličtina (středověká)" },
            { "esu", "jupikština (středoaljašská)" },
            { "ewo", "ewondo" },
            { "ext", "extremadurština" },
            { "fan", "fang" },
            { "fat", "fantština" },
            { "fil", "filipínština" },
            { "fit", "finština (tornedalská)" },
            { "fon", "fonština" },
            { "frc", "francouzština (cajunská)" },
            { "frm", "francouzština (středověká)" },
            { "fro", "francouzština (stará)" },
            { "frp", "franko-provensálština" },
            { "frr", "fríština (severní)" },
            { "frs", "fríština (východní)" },
            { "fur", "furlanština" },
            { "gaa", "gaština" },
            { "gag", "gagauzština" },
            { "gan", "čínština (dialekty Gan)" },
            { "gay", "gayo" },
            { "gba", "gbaja" },
            { "gbz", "daríjština (zoroastrijská)" },
            { "gez", "geez" },
            { "gil", "kiribatština" },
            { "glk", "gilačtina" },
            { "gmh", "hornoněmčina (středověká)" },
            { "goh", "hornoněmčina (stará)" },
            { "gon", "góndština" },
            { "gor", "gorontalo" },
            { "got", "gótština" },
            { "grb", "grebo" },
            { "grc", "starořečtina" },
            { "gsw", "němčina (Švýcarsko)" },
            { "guc", "wayúuština" },
            { "gur", "frafra" },
            { "guz", "gusii" },
            { "gwi", "gwichʼin" },
            { "hai", "haidština" },
            { "hak", "čínština (dialekty Hakka)" },
            { "haw", "havajština" },
            { "hax", "haidština (jižní)" },
            { "hif", "hindština (Fidži)" },
            { "hil", "hiligajnonština" },
            { "hit", "chetitština" },
            { "hmn", "hmongština" },
            { "hsb", "hornolužická srbština" },
            { "hsn", "čínština (dialekty Xiang)" },
            { "hup", "hupa" },
            { "hur", "halkomelem" },
            { "iba", "ibanština" },
            { "ibb", "ibibio" },
            { "ikt", "inuktitutština (západokanadská)" },
            { "ilo", "ilokánština" },
            { "inh", "inguština" },
            { "izh", "ingrijština" },
            { "jam", "jamajská kreolština" },
            { "jbo", "lojban" },
            { "jgo", "ngomba" },
            { "jmc", "mašame" },
            { "jpr", "judeoperština" },
            { "jrb", "judeoarabština" },
            { "jut", "jutština" },
            { "kaa", "karakalpačtina" },
            { "kab", "kabylština" },
            { "kac", "kačijština" },
            { "kaj", "jju" },
            { "kam", "kambština" },
            { "kaw", "kawi" },
            { "kbd", "kabardinština" },
            { "kbl", "kanembu" },
            { "kcg", "tyap" },
            { "kde", "makonde" },
            { "kea", "kapverdština" },
            { "ken", "kenyang" },
            { "kfo", "koro" },
            { "kgp", "kaingang" },
            { "kha", "khásí" },
            { "kho", "chotánština" },
            { "khq", "koyra chiini" },
            { "khw", "chovarština" },
            { "kiu", "zazakština" },
            { "kkj", "kako" },
            { "kln", "kalendžin" },
            { "kmb", "kimbundština" },
            { "koi", "komi-permjačtina" },
            { "kok", "konkánština" },
            { "kos", "kosrajština" },
            { "kpe", metaValue_kpe },
            { "krc", "karačajevo-balkarština" },
            { "kri", "krio" },
            { "krj", "kinaraj-a" },
            { "krl", "karelština" },
            { "kru", "kuruchština" },
            { "ksb", "šambala" },
            { "ksf", "bafia" },
            { "ksh", "kolínština" },
            { "kum", "kumyčtina" },
            { "kut", "kutenajština" },
            { "kwk", "kvakiutština" },
            { "kxv", "kúvi" },
            { "lad", metaValue_lad },
            { "lag", "langi" },
            { "lah", "lahndština" },
            { "lam", "lambština" },
            { "lez", "lezginština" },
            { "lfn", "lingua franca nova" },
            { "lij", "ligurština" },
            { "lil", "lillooetština" },
            { "liv", "livonština" },
            { "lkt", "lakotština" },
            { "lld", metaValue_lad },
            { "lmo", "lombardština" },
            { "lol", "mongština" },
            { "lou", "kreolština (Louisiana)" },
            { "loz", "lozština" },
            { "lrc", "lúrština (severní)" },
            { "lsm", "samia" },
            { "ltg", "latgalština" },
            { "lua", "luba-luluaština" },
            { "lui", "luiseňo" },
            { "lun", "lundština" },
            { "luo", "luoština" },
            { "lus", "mizoština" },
            { "luy", "luhja" },
            { "lzh", "čínština (klasická)" },
            { "lzz", "lazština" },
            { "mad", "madurština" },
            { "maf", "mafa" },
            { "mag", "magahijština" },
            { "mai", "maithiliština" },
            { "mak", "makasarština" },
            { "man", "mandingština" },
            { "mas", "masajština" },
            { "mde", "maba" },
            { "mdf", "mokšanština" },
            { "mdr", "mandar" },
            { "men", "mende" },
            { "mer", "meru" },
            { "mfe", "mauricijská kreolština" },
            { "mga", "irština (středověká)" },
            { "mgh", "makhuwa-meetto" },
            { "mgo", "meta’" },
            { "mic", "micmac" },
            { "min", "minangkabau" },
            { "mnc", "mandžuština" },
            { "mni", "manipurština" },
            { "moe", "innu-aimun" },
            { "moh", "mohawkština" },
            { "mos", "mosi" },
            { "mrj", "marijština (západní)" },
            { "mua", "mundang" },
            { "mul", "více jazyků" },
            { "mus", "kríkština" },
            { "mwl", "mirandština" },
            { "mwr", "márvárština" },
            { "mwv", "mentavajština" },
            { "mye", "myene" },
            { "myv", "erzjanština" },
            { "mzn", "mázandaránština" },
            { "nan", "čínština (dialekty Minnan)" },
            { "nap", "neapolština" },
            { "naq", "namaština" },
            { "nds", "dolnoněmčina" },
            { "new", "névárština" },
            { "nia", "nias" },
            { "niu", "niueština" },
            { "njo", "ao (jazyky Nágálandu)" },
            { "nmg", "kwasio" },
            { "nnh", "ngiemboon" },
            { "nog", "nogajština" },
            { "non", "norština historická" },
            { "nov", "novial" },
            { "nqo", metaValue_nqo },
            { "nso", "sotština (severní)" },
            { "nus", "nuerština" },
            { "nwc", "newarština (klasická)" },
            { "nym", "ňamwežština" },
            { "nyn", "ňankolština" },
            { "nyo", "ňorština" },
            { "nzi", "nzima" },
            { "ojb", "odžibvejština (severozápadní)" },
            { "ojc", "odžibvejština (střední)" },
            { "ojs", "odžibvejština (severní)" },
            { "ojw", "odžibvejština (západní)" },
            { "oka", "okanaganština" },
            { "osa", "osage" },
            { "ota", "turečtina (osmanská)" },
            { "pag", "pangasinanština" },
            { "pal", "pahlavština" },
            { "pam", "papangau" },
            { "pap", "papiamento" },
            { "pau", "palauština" },
            { "pcd", "picardština" },
            { "pcm", "nigerijský pidžin" },
            { "pdc", "němčina (pensylvánská)" },
            { "pdt", "němčina (plautdietsch)" },
            { "peo", "staroperština" },
            { "pfl", "falčtina" },
            { "phn", "féničtina" },
            { "pis", "pidžin (Šalomounovy ostrovy)" },
            { "pms", "piemonština" },
            { "pnt", "pontština" },
            { "pon", "pohnpeiština" },
            { "pqm", "malesitština-passamaquoddština" },
            { "prg", "pruština" },
            { "pro", "provensálština" },
            { "quc", "kičé" },
            { "qug", "kečuánština (chimborazo)" },
            { "raj", "rádžastánština" },
            { "rap", "rapanujština" },
            { "rar", "rarotongánština" },
            { "rgn", "romaňolština" },
            { "rhg", "rohingština" },
            { "rif", "rífština" },
            { "rof", "rombo" },
            { "rom", "romština" },
            { "rtm", "rotumanština" },
            { "rue", "rusínština" },
            { "rug", "rovianština" },
            { "rup", "arumunština" },
            { "rwk", "rwa" },
            { "sad", "sandawština" },
            { "sah", "jakutština" },
            { "sam", "samarština" },
            { "saq", "samburu" },
            { "sas", "sasakština" },
            { "sat", "santálština" },
            { "saz", "saurášterština" },
            { "sba", "ngambay" },
            { "sbp", "sangoština" },
            { "scn", "sicilština" },
            { "sco", "skotština" },
            { "sdc", "sassarština" },
            { "sdh", "kurdština (jižní)" },
            { "see", "seneca" },
            { "seh", "sena" },
            { "sei", "seriština" },
            { "sel", "selkupština" },
            { "ses", "koyraboro senni" },
            { "sga", "irština (stará)" },
            { "sgs", "žemaitština" },
            { "shi", "tašelhit" },
            { "shn", "šanština" },
            { "shu", "arabština (čadská)" },
            { "sid", "sidamo" },
            { "slh", "lushootseed (jižní)" },
            { "sli", "němčina (slezská)" },
            { "sly", "selajarština" },
            { "sma", "sámština (jižní)" },
            { "smj", "sámština (lulejská)" },
            { "smn", "sámština (inarijská)" },
            { "sms", "sámština (skoltská)" },
            { "snk", "sonikština" },
            { "sog", "sogdština" },
            { "srn", "sranan tongo" },
            { "srr", "sererština" },
            { "ssy", "saho" },
            { "stq", "fríština (saterlandská)" },
            { "str", "saliština (z úžin)" },
            { "suk", "sukuma" },
            { "sus", "susu" },
            { "sux", "sumerština" },
            { "swb", "komorština" },
            { "syc", "syrština (klasická)" },
            { "syr", "syrština" },
            { "szl", "slezština" },
            { "tce", "tutčonština (jižní)" },
            { "tcy", "tuluština" },
            { "tem", "temne" },
            { "teo", "teso" },
            { "ter", "tereno" },
            { "tet", "tetumština" },
            { "tgx", "tagiš" },
            { "tht", "tahltan" },
            { "tig", "tigrejština" },
            { "tiv", "tivština" },
            { "tkl", "tokelauština" },
            { "tkr", "cachurština" },
            { "tlh", "klingonština" },
            { "tli", "tlingit" },
            { "tly", "talyština" },
            { "tmh", "tamašek" },
            { "tog", "tonžština (nyasa)" },
            { "tok", "toki pona" },
            { "tpi", "tok pisin" },
            { "tru", "turojština" },
            { "trv", "taroko" },
            { "tsd", "tsakonština" },
            { "tsi", "tsimšijské jazyky" },
            { "ttm", "tutčonština (severní)" },
            { "ttt", "tatština" },
            { "tum", "tumbukština" },
            { "tvl", "tuvalština" },
            { "twq", "tasawaq" },
            { "tyv", "tuvinština" },
            { "tzm", "tamazight (střední Maroko)" },
            { "udm", "udmurtština" },
            { "uga", "ugaritština" },
            { "umb", "umbundu" },
            { "und", "neznámý jazyk" },
            { "vec", "benátština" },
            { "vep", "vepština" },
            { "vls", "vlámština (západní)" },
            { "vmf", "němčina (mohansko-franské dialekty)" },
            { "vmw", "makhuwština" },
            { "vot", "votština" },
            { "vro", "võruština" },
            { "vun", "vunjo" },
            { "wae", "němčina (walser)" },
            { "wal", "wolajtština" },
            { "war", "warajština" },
            { "was", "waština" },
            { "wbp", "warlpiri" },
            { "wuu", "čínština (dialekty Wu)" },
            { "xal", "kalmyčtina" },
            { "xmf", "mingrelština" },
            { "xnr", "kángrí" },
            { "xog", "sogština" },
            { "yao", "jaoština" },
            { "yap", "japština" },
            { "yav", "jangbenština" },
            { "ybb", "yemba" },
            { "yrl", "nheengatu" },
            { "yue", "kantonština" },
            { "zap", "zapotéčtina" },
            { "zbl", "bliss systém" },
            { "zea", "zélandština" },
            { "zen", "zenaga" },
            { "zgh", "tamazight (standardní marocký)" },
            { "zun", "zunijština" },
            { "zxx", "žádný jazykový obsah" },
            { "zza", "zaza" },
            { "Adlm", "adlam" },
            { "Afak", "afaka" },
            { "Aghb", "kavkazskoalbánské" },
            { "Arab", "arabské" },
            { "Aran", "nastalik" },
            { "Armi", "aramejské (imperiální)" },
            { "Armn", "arménské" },
            { "Avst", "avestánské" },
            { "Bali", "balijské" },
            { "Bamu", "bamumské" },
            { "Bass", "bassa vah" },
            { "Batk", "batacké" },
            { "Beng", "bengálské" },
            { "Blis", "Blissovo písmo" },
            { "Bopo", "bopomofo" },
            { "Brah", "bráhmí" },
            { "Brai", "Braillovo písmo" },
            { "Bugi", "buginské" },
            { "Buhd", "buhidské" },
            { "Cakm", metaValue_ccp },
            { "Cans", "slabičné písmo kanadských domorodců" },
            { "Cari", "karijské" },
            { "Cham", "čam" },
            { "Cher", "čerokí" },
            { "Cirt", "kirt" },
            { "Copt", "koptské" },
            { "Cprt", "kyperské" },
            { "Cyrl", "cyrilice" },
            { "Cyrs", "cyrilce - staroslověnská" },
            { "Deva", "dévanágarí" },
            { "Dsrt", "deseret" },
            { "Dupl", "Duployého těsnopis" },
            { "Egyd", "egyptské démotické" },
            { "Egyh", "egyptské hieratické" },
            { "Egyp", "egyptské hieroglyfy" },
            { "Elba", "elbasanské" },
            { "Ethi", "etiopské" },
            { "Geok", "gruzínské chutsuri" },
            { "Geor", "gruzínské" },
            { "Glag", "hlaholice" },
            { "Gong", "gundžala gondí" },
            { "Goth", "gotické" },
            { "Gran", "grantha" },
            { "Grek", "řecké" },
            { "Gujr", "gudžarátí" },
            { "Guru", "gurmukhi" },
            { "Hanb", "hanb" },
            { "Hang", "hangul" },
            { "Hani", "han" },
            { "Hano", "hanunóo" },
            { "Hans", "zjednodušené" },
            { "Hant", "tradiční" },
            { "Hebr", "hebrejské" },
            { "Hira", "hiragana" },
            { "Hluw", "anatolské hieroglyfy" },
            { "Hmng", "hmongské" },
            { "Hmnp", "nyiakeng puachue hmong" },
            { "Hrkt", "japonské slabičné" },
            { "Hung", "staromaďarské" },
            { "Inds", "harappské" },
            { "Ital", "etruské" },
            { "Jamo", "jamo" },
            { "Java", "javánské" },
            { "Jpan", "japonské" },
            { "Jurc", "džürčenské" },
            { "Kali", "kayah li" },
            { "Kana", "katakana" },
            { "Khar", "kháróšthí" },
            { "Khmr", "khmerské" },
            { "Khoj", "chodžiki" },
            { "Knda", "kannadské" },
            { "Kore", "korejské" },
            { "Kpel", metaValue_kpe },
            { "Kthi", "kaithi" },
            { "Lana", "lanna" },
            { "Laoo", "laoské" },
            { "Latf", "latinka - lomená" },
            { "Latg", "latinka - galská" },
            { "Latn", "latinka" },
            { "Lepc", "lepčské" },
            { "Limb", "limbu" },
            { "Lina", "lineární A" },
            { "Linb", "lineární B" },
            { "Lisu", "Fraserovo" },
            { "Loma", "loma" },
            { "Lyci", "lýkijské" },
            { "Lydi", "lýdské" },
            { "Mahj", "mahádžaní" },
            { "Mand", "mandejské" },
            { "Mani", "manichejské" },
            { "Maya", "mayské hieroglyfy" },
            { "Mend", "mendské" },
            { "Merc", "meroitické psací" },
            { "Mero", "meroitické" },
            { "Mlym", "malajlámské" },
            { "Modi", "modí" },
            { "Mong", "mongolské" },
            { "Moon", "Moonovo písmo" },
            { "Mroo", "mro" },
            { "Mtei", "mejtej majek (manipurské)" },
            { "Mymr", "myanmarské" },
            { "Narb", "staroseveroarabské" },
            { "Nbat", "nabatejské" },
            { "Nkgb", "naxi geba" },
            { "Nkoo", metaValue_nqo },
            { "Nshu", "nü-šu" },
            { "Ogam", "ogamské" },
            { "Olck", "santálské (ol chiki)" },
            { "Orkh", "orchonské" },
            { "Orya", "urijské" },
            { "Osma", "osmanské" },
            { "Palm", "palmýrské" },
            { "Pauc", "pau cin hau" },
            { "Perm", "staropermské" },
            { "Phag", "phags-pa" },
            { "Phli", "pahlavské klínové" },
            { "Phlp", "pahlavské žalmové" },
            { "Phlv", "pahlavské knižní" },
            { "Phnx", "fénické" },
            { "Plrd", "Pollardova fonetická abeceda" },
            { "Prti", "parthské klínové" },
            { "Qaag", "zawgyi" },
            { "Rjng", "redžanské" },
            { "Rohg", "hanifi" },
            { "Roro", "rongorongo" },
            { "Runr", "runové" },
            { "Samr", "samařské" },
            { "Sara", "sarati" },
            { "Sarb", "starojihoarabské" },
            { "Saur", "saurášterské" },
            { "Sgnw", "SignWriting" },
            { "Shaw", "Shawova abeceda" },
            { "Shrd", "šáradá" },
            { "Sidd", "siddham" },
            { "Sind", "chudábádí" },
            { "Sinh", "sinhálské" },
            { "Sora", "sora sompeng" },
            { "Sund", "sundské" },
            { "Sylo", "sylhetské" },
            { "Syrc", "syrské" },
            { "Syre", "syrské - estrangelo" },
            { "Syrj", "syrské - západní" },
            { "Syrn", "syrské - východní" },
            { "Tagb", "tagbanwa" },
            { "Takr", "takrí" },
            { "Tale", "tai le" },
            { "Talu", "tai lü nové" },
            { "Taml", "tamilské" },
            { "Tang", "tangut" },
            { "Tavt", "tai viet" },
            { "Telu", "telugské" },
            { "Teng", "tengwar" },
            { "Tfng", "berberské" },
            { "Tglg", "tagalské" },
            { "Thaa", "thaana" },
            { "Thai", "thajské" },
            { "Tibt", "tibetské" },
            { "Tirh", "tirhuta" },
            { "Ugar", "ugaritské klínové" },
            { "Vaii", "vai" },
            { "Visp", "viditelná řeč" },
            { "Wara", "varang kšiti" },
            { "Wole", "karolínské (woleai)" },
            { "Xpeo", "staroperské klínové písmo" },
            { "Xsux", "sumero-akkadské klínové písmo" },
            { "Yiii", "yi" },
            { "Zinh", "zděděné" },
            { "Zmth", "matematický zápis" },
            { "Zsye", "emodži" },
            { "Zsym", "symboly" },
            { "Zxxx", "bez zápisu" },
            { "Zyyy", "obecné" },
            { "Zzzz", "neznámé písmo" },
            { "de_CH", "němčina standardní (Švýcarsko)" },
            { "en_GB", "angličtina (Velká Británie)" },
            { "en_US", "angličtina (USA)" },
            { "es_ES", "španělština (Evropa)" },
            { "fa_AF", "darí" },
            { "nl_BE", "vlámština" },
            { "pt_PT", "portugalština (Evropa)" },
            { "ro_MD", "moldavština" },
            { "sw_CD", "svahilština (Kongo)" },
            { "ar_001", "arabština (moderní standardní)" },
            { "key.ca", "Kalendář" },
            { "key.cf", "Měnový formát" },
            { "key.co", "Řazení" },
            { "key.cu", "Měna" },
            { "key.em", "Zobrazení emodži" },
            { "key.hc", "Hodinový cyklus (12 vs. 24)" },
            { "key.lb", "Styl zalamování řádků" },
            { "key.lw", "Zalamování řádků uprostřed slova" },
            { "key.ms", "Měrná soustava" },
            { "key.nu", "Čísla" },
            { "key.ss", "Zlom věty za zkratkou" },
            { "key.tz", "Časové pásmo" },
            { "key.va", "Varianta národního prostředí" },
            { "nds_NL", "dolnosaština" },
            { "zh_Hans", "čínština (zjednodušená)" },
            { "%%SCOTLAND", "angličtina (Skotsko)" },
            { "%%WADEGILE", "Wade-Giles" },
            { "type.ca.roc", "Kalendář Čínské republiky" },
            { "type.co.eor", "Evropské řazení" },
            { "type.hc.h11", "12hodinový systém (0–11)" },
            { "type.hc.h12", "12hodinový systém (1–12)" },
            { "type.hc.h23", "24hodinový systém (0–23)" },
            { "type.hc.h24", "24hodinový systém (1–24)" },
            { "type.m0.bgn", "Transliterace podle BGN" },
            { "type.nu.arab", "Arabsko-indické číslice" },
            { "type.nu.armn", "Arménské číslice" },
            { "type.nu.bali", "Balijské číslice" },
            { "type.nu.beng", "Bengálské číslice" },
            { "type.nu.cakm", "Čakmské číslice" },
            { "type.nu.deva", "Číslice písma dévanágarí" },
            { "type.nu.ethi", "Etiopské číslice" },
            { "type.nu.geor", "Gruzínské číslice" },
            { "type.nu.grek", "Řecké číslice" },
            { "type.nu.gujr", "Gudžarátské číslice" },
            { "type.nu.guru", "Číslice gurmukhí" },
            { "type.nu.hans", "Číslice zjednodušené čínštiny" },
            { "type.nu.hant", "Číslice tradiční čínštiny" },
            { "type.nu.hebr", "Hebrejské číslice" },
            { "type.nu.java", "Javánské číslice" },
            { "type.nu.jpan", "Japonské číslice" },
            { "type.nu.khmr", "Khmerské číslice" },
            { "type.nu.knda", "Kannadské číslice" },
            { "type.nu.laoo", "Laoské číslice" },
            { "type.nu.latn", "Západní číslice" },
            { "type.nu.mlym", "Malajálamské číslice" },
            { "type.nu.mong", "Mongolské číslice" },
            { "type.nu.mtei", "Manipurské číslice" },
            { "type.nu.mymr", "Myanmarské číslice" },
            { "type.nu.olck", "Santálské číslice" },
            { "type.nu.orya", "Urijské číslice" },
            { "type.nu.osma", "Somálské číslice" },
            { "type.nu.saur", "Saurášterské číslice" },
            { "type.nu.sund", "Sundské číslice" },
            { "type.nu.taml", "Tamilské tradiční číslice" },
            { "type.nu.telu", "Telugské číslice" },
            { "type.nu.thai", "Thajské číslice" },
            { "type.nu.tibt", "Tibetské číslice" },
            { "type.nu.vaii", "Vaiské číslice" },
            { "type.ca.dangi", "Korejský kalendář Dangi" },
            { "type.co.ducet", "Výchozí řazení Unicode" },
            { "type.lb.loose", "Volný styl zalamování řádků" },
            { "type.nu.roman", "Římské číslice" },
            { "type.ca.coptic", "Koptský kalendář" },
            { "type.ca.hebrew", "Hebrejský kalendář" },
            { "type.ca.indian", "Indický národní kalendář" },
            { "type.co.compat", "Předchozí řazení, kompatibilita" },
            { "type.co.pinyin", "Řazení podle pchin-jinu" },
            { "type.co.search", "Obecné hledání" },
            { "type.co.stroke", "Řazení podle tahů" },
            { "type.co.unihan", "Řazení podle radikálů" },
            { "type.co.zhuyin", "Řazení podle ču-jinu" },
            { "type.d0.fwidth", "Plná šířka" },
            { "type.d0.hwidth", "Poloviční šířka" },
            { "type.lb.normal", "Běžný styl zalamování řádků" },
            { "type.lb.strict", "Striktní styl zalamování řádků" },
            { "type.m0.ungegn", "Transliterace podle UNGEGN" },
            { "type.ms.metric", "Metrická soustava" },
            { "type.nu.native", "Nativní číslice" },
            { "type.ca.chinese", "Čínský kalendář" },
            { "type.ca.islamic", "Kalendář podle hidžry" },
            { "type.ca.iso8601", "Kalendář ISO-8601" },
            { "type.ca.persian", "Perský kalendář" },
            { "type.cf.account", "Účetní měnový formát" },
            { "type.d0.npinyin", "Numerický" },
            { "type.nu.arabext", "Rozšířené arabsko-indické číslice" },
            { "type.nu.armnlow", "Malé arménské číslice" },
            { "type.nu.finance", "Finanční zápis čísel" },
            { "type.nu.greklow", "Malé řecké číslice" },
            { "type.nu.hanidec", "Čínské desítkové číslice" },
            { "type.nu.hansfin", "Finanční číslice zjednodušené čínštiny" },
            { "type.nu.hantfin", "Finanční číslice tradiční čínštiny" },
            { "type.nu.jpanfin", "Japonské finanční číslice" },
            { "type.nu.tamldec", "Tamilské číslice" },
            { "type.ca.buddhist", "Buddhistický kalendář" },
            { "type.ca.ethiopic", "Etiopský kalendář" },
            { "type.ca.japanese", "Japonský kalendář" },
            { "type.cf.standard", "Standardní měnový formát" },
            { "type.co.phonetic", "Fonetické řazení" },
            { "type.co.searchjl", "Vyhledávat podle počáteční souhlásky písma hangul" },
            { "type.co.standard", "Standardní řazení" },
            { "type.ms.uksystem", "Britská měrná soustava" },
            { "type.ms.ussystem", "Americká měrná soustava" },
            { "type.nu.fullwide", "Číslice – plná šířka" },
            { "type.nu.romanlow", "Malé římské číslice" },
            { "type.ca.gregorian", "Gregoriánský kalendář" },
            { "type.co.phonebook", "Řazení telefonního seznamu" },
            { "type.co.dictionary", "Slovníkové řazení" },
            { "type.co.traditional", "Tradiční řazení" },
            { "type.nu.traditional", "Tradiční číslovky" },
            { "type.ca.islamic-civil", "Kalendář podle hidžry (občanský)" },
            { "type.ca.islamic-umalqura", "Kalendář podle hidžry (Umm al-Qura)" },
            { "type.ca.ethiopic-amete-alem", "Etiopský kalendář (amete alem)" },
        };
        return data;
    }
}
