//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-cloud-kit")]
#[cfg(target_vendor = "apple")]
use objc2_cloud_kit::*;
use objc2_foundation::*;

use crate::*;

/// Built-in sharing services
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/appkit/nssharingservicename?language=objc)
// NS_TYPED_EXTENSIBLE_ENUM
pub type NSSharingServiceName = NSString;

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nssharingservicenamecomposeemail?language=objc)
    pub static NSSharingServiceNameComposeEmail: &'static NSSharingServiceName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nssharingservicenamecomposemessage?language=objc)
    pub static NSSharingServiceNameComposeMessage: &'static NSSharingServiceName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nssharingservicenamesendviaairdrop?language=objc)
    pub static NSSharingServiceNameSendViaAirDrop: &'static NSSharingServiceName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nssharingservicenameaddtosafarireadinglist?language=objc)
    pub static NSSharingServiceNameAddToSafariReadingList: &'static NSSharingServiceName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nssharingservicenameaddtoiphoto?language=objc)
    pub static NSSharingServiceNameAddToIPhoto: &'static NSSharingServiceName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nssharingservicenameaddtoaperture?language=objc)
    pub static NSSharingServiceNameAddToAperture: &'static NSSharingServiceName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nssharingservicenameuseasdesktoppicture?language=objc)
    pub static NSSharingServiceNameUseAsDesktopPicture: &'static NSSharingServiceName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nssharingservicenamepostonfacebook?language=objc)
    pub static NSSharingServiceNamePostOnFacebook: &'static NSSharingServiceName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nssharingservicenamepostontwitter?language=objc)
    pub static NSSharingServiceNamePostOnTwitter: &'static NSSharingServiceName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nssharingservicenamepostonsinaweibo?language=objc)
    pub static NSSharingServiceNamePostOnSinaWeibo: &'static NSSharingServiceName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nssharingservicenamepostontencentweibo?language=objc)
    pub static NSSharingServiceNamePostOnTencentWeibo: &'static NSSharingServiceName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nssharingservicenamepostonlinkedin?language=objc)
    pub static NSSharingServiceNamePostOnLinkedIn: &'static NSSharingServiceName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nssharingservicenameuseastwitterprofileimage?language=objc)
    pub static NSSharingServiceNameUseAsTwitterProfileImage: &'static NSSharingServiceName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nssharingservicenameuseasfacebookprofileimage?language=objc)
    pub static NSSharingServiceNameUseAsFacebookProfileImage: &'static NSSharingServiceName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nssharingservicenameuseaslinkedinprofileimage?language=objc)
    pub static NSSharingServiceNameUseAsLinkedInProfileImage: &'static NSSharingServiceName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nssharingservicenamepostimageonflickr?language=objc)
    pub static NSSharingServiceNamePostImageOnFlickr: &'static NSSharingServiceName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nssharingservicenamepostvideoonvimeo?language=objc)
    pub static NSSharingServiceNamePostVideoOnVimeo: &'static NSSharingServiceName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nssharingservicenamepostvideoonyouku?language=objc)
    pub static NSSharingServiceNamePostVideoOnYouku: &'static NSSharingServiceName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nssharingservicenamepostvideoontudou?language=objc)
    pub static NSSharingServiceNamePostVideoOnTudou: &'static NSSharingServiceName;
}

extern "C" {
    /// This service differs from other NSSharingServices in that it allows the user to establish a persistent sharing session for the specified items with potentially many participants, instead of sending a copy of the items. You can invoke this service with an NSItemProvider that has registered a CKShare
    /// &
    /// CKContainer via either -registerCloudKitShare:container: or -registerCloudKitShareWithPreparationHandler:. (Registering other types on the same provider to enable other sharing services is allowed.)
    ///
    /// When performed, this service gives the user the opportunity to invite participants and start sharing. If the content is already shared, the service instead allows the user to view or modify participation or stop sharing. To detect changes the service makes to the CKShare, implement -sharingService:didSaveShare: and -sharingService:didStopSharing:.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/appkit/nssharingservicenamecloudsharing?language=objc)
    pub static NSSharingServiceNameCloudSharing: &'static NSSharingServiceName;
}

extern_class!(
    /// NSSharingService can be used to share items to different kinds of local and remote services. Items are objects which respond to the NSPasteboardWriting protocol, like NSURL, NSImage or NSString. If an NSURL is a file URL (point to a video for example), then the content of the file will be shared. If the URL is remote, then the URL itself will be shared.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/appkit/nssharingservice?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSSharingService;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for NSSharingService {}
);

impl NSSharingService {
    extern_methods!(
        #[unsafe(method(delegate))]
        #[unsafe(method_family = none)]
        pub unsafe fn delegate(
            &self,
            mtm: MainThreadMarker,
        ) -> Option<Retained<ProtocolObject<dyn NSSharingServiceDelegate>>>;

        /// This is a [weak property][objc2::topics::weak_property].
        /// Setter for [`delegate`][Self::delegate].
        #[unsafe(method(setDelegate:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDelegate(
            &self,
            delegate: Option<&ProtocolObject<dyn NSSharingServiceDelegate>>,
        );

        #[unsafe(method(title))]
        #[unsafe(method_family = none)]
        pub unsafe fn title(&self) -> Retained<NSString>;

        #[cfg(feature = "NSImage")]
        #[unsafe(method(image))]
        #[unsafe(method_family = none)]
        pub unsafe fn image(&self) -> Retained<NSImage>;

        #[cfg(feature = "NSImage")]
        #[unsafe(method(alternateImage))]
        #[unsafe(method_family = none)]
        pub unsafe fn alternateImage(&self) -> Option<Retained<NSImage>>;

        /// Title of the service in the Share menu. Can be modified.
        #[unsafe(method(menuItemTitle))]
        #[unsafe(method_family = none)]
        pub unsafe fn menuItemTitle(&self) -> Retained<NSString>;

        /// Setter for [`menuItemTitle`][Self::menuItemTitle].
        #[unsafe(method(setMenuItemTitle:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setMenuItemTitle(&self, menu_item_title: &NSString);

        /// NSArray of NSString objects representing handles (example: email adresses)
        #[unsafe(method(recipients))]
        #[unsafe(method_family = none)]
        pub unsafe fn recipients(&self) -> Option<Retained<NSArray<NSString>>>;

        /// Setter for [`recipients`][Self::recipients].
        #[unsafe(method(setRecipients:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setRecipients(&self, recipients: Option<&NSArray<NSString>>);

        #[unsafe(method(subject))]
        #[unsafe(method_family = none)]
        pub unsafe fn subject(&self) -> Option<Retained<NSString>>;

        /// Setter for [`subject`][Self::subject].
        #[unsafe(method(setSubject:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setSubject(&self, subject: Option<&NSString>);

        /// Message body as string
        #[unsafe(method(messageBody))]
        #[unsafe(method_family = none)]
        pub unsafe fn messageBody(&self) -> Option<Retained<NSString>>;

        /// URL to access the post on Facebook, Twitter, Sina Weibo, etc. (also known as permalink)
        #[unsafe(method(permanentLink))]
        #[unsafe(method_family = none)]
        pub unsafe fn permanentLink(&self) -> Option<Retained<NSURL>>;

        /// Account name used for sending on Twitter or Sina Weibo
        #[unsafe(method(accountName))]
        #[unsafe(method_family = none)]
        pub unsafe fn accountName(&self) -> Option<Retained<NSString>>;

        /// NSArray of NSURL objects representing the files that were shared
        #[unsafe(method(attachmentFileURLs))]
        #[unsafe(method_family = none)]
        pub unsafe fn attachmentFileURLs(&self) -> Option<Retained<NSArray<NSURL>>>;

        /// Returns a list of NSSharingServices which could share all the provided items together. sharingServicesForItems can be used to build a custom UI, or to populate a contextual NSMenu.
        /// The items represent the objects to be shared and must conform to the
        /// <NSPasteboardWriting
        /// > protocol or be an NSItemProvider or an NSDocument. (e.g. NSString, NSImage, NSURL, etc.)
        #[deprecated = "Use -[NSSharingServicePicker standardShareMenuItem] instead."]
        #[unsafe(method(sharingServicesForItems:))]
        #[unsafe(method_family = none)]
        pub unsafe fn sharingServicesForItems(
            items: &NSArray,
        ) -> Retained<NSArray<NSSharingService>>;

        /// Returns an NSSharingService representing one of the built-in services.
        #[unsafe(method(sharingServiceNamed:))]
        #[unsafe(method_family = none)]
        pub unsafe fn sharingServiceNamed(
            service_name: &NSSharingServiceName,
        ) -> Option<Retained<NSSharingService>>;

        #[cfg(all(feature = "NSImage", feature = "block2"))]
        /// Creates a custom NSSharingService object. Custom sharing services can be added to the NSSharingServicePicker with the sharingServicePicker:sharingServicesForItems:proposedSharingServices: delegate method.
        #[unsafe(method(initWithTitle:image:alternateImage:handler:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithTitle_image_alternateImage_handler(
            this: Allocated<Self>,
            title: &NSString,
            image: &NSImage,
            alternate_image: Option<&NSImage>,
            block: &block2::DynBlock<dyn Fn()>,
        ) -> Retained<Self>;

        /// Use -initWithTitle:image:alternateImage:handler: instead
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        /// Returns whether a service can do something with all the provided items. This can be used to validate a custom UI such as a dedicated Twitter button. If items is nil, the method will return YES when the service is configured. Therefore you could call it once at launch time with nil items to check whether to display the button or not, and then with real items to enable and disable the button depending on the context or selection.
        ///
        /// The items represent the objects to be shared and must conform to the
        /// <NSPasteboardWriting
        /// > protocol or be an NSItemProvider or an NSDocument. (e.g. NSString, NSImage, NSURL, etc.)
        #[unsafe(method(canPerformWithItems:))]
        #[unsafe(method_family = none)]
        pub unsafe fn canPerformWithItems(&self, items: Option<&NSArray>) -> bool;

        /// Manually performs the service on the provided items. In most cases this will display a sharing window.
        ///
        /// The items represent the objects to be shared and must conform to the
        /// <NSPasteboardWriting
        /// > protocol or be an NSItemProvider or an NSDocument. (e.g. NSString, NSImage, NSURL, etc.)
        #[unsafe(method(performWithItems:))]
        #[unsafe(method_family = none)]
        pub unsafe fn performWithItems(&self, items: &NSArray);
    );
}

/// Methods declared on superclass `NSObject`.
impl NSSharingService {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

/// Use the sharing scope to specify the nature of the things you are sharing.
///
/// The sharing scope can be modified from the default value of NSSharingContentScopeItem by setting a different value in the out parameter in sharingService:sourceWindowForShareItems:sharingContentScope:.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/appkit/nssharingcontentscope?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSSharingContentScope(pub NSInteger);
impl NSSharingContentScope {
    /// NSSharingContentScopeItem: use when sharing a clearly identified item, e.g. a file represented by its icon.
    #[doc(alias = "NSSharingContentScopeItem")]
    pub const Item: Self = Self(0);
    /// NSSharingContentScopePartial: use when sharing a portion of a more global content, e.g. part of a webpage
    #[doc(alias = "NSSharingContentScopePartial")]
    pub const Partial: Self = Self(1);
    /// NSSharingContentScopeFull: use when sharing the whole content of the current document, e.g. the url of the webpage
    #[doc(alias = "NSSharingContentScopeFull")]
    pub const Full: Self = Self(2);
}

unsafe impl Encode for NSSharingContentScope {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSSharingContentScope {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nssharingservicedelegate?language=objc)
    pub unsafe trait NSSharingServiceDelegate: NSObjectProtocol + MainThreadOnly {
        #[optional]
        #[unsafe(method(sharingService:willShareItems:))]
        #[unsafe(method_family = none)]
        unsafe fn sharingService_willShareItems(
            &self,
            sharing_service: &NSSharingService,
            items: &NSArray,
        );

        #[optional]
        #[unsafe(method(sharingService:didFailToShareItems:error:))]
        #[unsafe(method_family = none)]
        unsafe fn sharingService_didFailToShareItems_error(
            &self,
            sharing_service: &NSSharingService,
            items: &NSArray,
            error: &NSError,
        );

        #[optional]
        #[unsafe(method(sharingService:didShareItems:))]
        #[unsafe(method_family = none)]
        unsafe fn sharingService_didShareItems(
            &self,
            sharing_service: &NSSharingService,
            items: &NSArray,
        );

        #[optional]
        #[unsafe(method(sharingService:sourceFrameOnScreenForShareItem:))]
        #[unsafe(method_family = none)]
        unsafe fn sharingService_sourceFrameOnScreenForShareItem(
            &self,
            sharing_service: &NSSharingService,
            item: &AnyObject,
        ) -> NSRect;

        #[cfg(feature = "NSImage")]
        /// When non-nil, the image returned would be used for the transitioning animation. When nil, the transitioning animation is disabled.
        #[optional]
        #[unsafe(method(sharingService:transitionImageForShareItem:contentRect:))]
        #[unsafe(method_family = none)]
        unsafe fn sharingService_transitionImageForShareItem_contentRect(
            &self,
            sharing_service: &NSSharingService,
            item: &AnyObject,
            content_rect: NonNull<NSRect>,
        ) -> Option<Retained<NSImage>>;

        #[cfg(all(feature = "NSResponder", feature = "NSWindow"))]
        #[optional]
        #[unsafe(method(sharingService:sourceWindowForShareItems:sharingContentScope:))]
        #[unsafe(method_family = none)]
        unsafe fn sharingService_sourceWindowForShareItems_sharingContentScope(
            &self,
            sharing_service: &NSSharingService,
            items: &NSArray,
            sharing_content_scope: NonNull<NSSharingContentScope>,
        ) -> Option<Retained<NSWindow>>;

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        /// The following method is invoked when the service is performed and wants to display its contents in a popover. The delegate should return the view that will act as the anchor of the popover, along with the target rectangle within the bounds of that view and preferred edge of that rectangle for the popover to appear. The delegate may also return nil, indicating that there is no anchoring view currently available, in which case the service may attempt to display the service via some other means.
        ///
        /// The service named NSSharingServiceNameCloudSharing prefers to display itself using a popover anchored to an "Add People" or "Share" button. If no such button is available or visible, return nil.
        #[optional]
        #[unsafe(method(anchoringViewForSharingService:showRelativeToRect:preferredEdge:))]
        #[unsafe(method_family = none)]
        unsafe fn anchoringViewForSharingService_showRelativeToRect_preferredEdge(
            &self,
            sharing_service: &NSSharingService,
            positioning_rect: NonNull<NSRect>,
            preferred_edge: NonNull<NSRectEdge>,
        ) -> Option<Retained<NSView>>;
    }
);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscloudkitsharingserviceoptions?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSCloudKitSharingServiceOptions(pub NSUInteger);
bitflags::bitflags! {
    impl NSCloudKitSharingServiceOptions: NSUInteger {
/// Allow the user to configure the share with the standard set of options.
        #[doc(alias = "NSCloudKitSharingServiceStandard")]
        const Standard = 0;
/// The user is allowed to share publicly.
        #[doc(alias = "NSCloudKitSharingServiceAllowPublic")]
        const AllowPublic = 1<<0;
/// The user is allowed to share privately.
        #[doc(alias = "NSCloudKitSharingServiceAllowPrivate")]
        const AllowPrivate = 1<<1;
/// The user is allowed to grant participants read-only permissions.
        #[doc(alias = "NSCloudKitSharingServiceAllowReadOnly")]
        const AllowReadOnly = 1<<4;
/// The user is allowed to grant participants read/write permissions.
        #[doc(alias = "NSCloudKitSharingServiceAllowReadWrite")]
        const AllowReadWrite = 1<<5;
    }
}

unsafe impl Encode for NSCloudKitSharingServiceOptions {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSCloudKitSharingServiceOptions {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscloudsharingservicedelegate?language=objc)
    pub unsafe trait NSCloudSharingServiceDelegate: NSSharingServiceDelegate {
        /// When an NSSharingServiceNameCloudSharing sharing service is dismissed it will invoke this method on the delegate, with an error if there was any. If the delegate implements this method, NSSharingServiceNameCloudSharing will not send -sharingService:didFailToShareItems:error: or -sharingService:didShareItems:.
        #[optional]
        #[unsafe(method(sharingService:didCompleteForItems:error:))]
        #[unsafe(method_family = none)]
        unsafe fn sharingService_didCompleteForItems_error(
            &self,
            sharing_service: &NSSharingService,
            items: &NSArray,
            error: Option<&NSError>,
        );

        /// The options returned by this method describe how the user is allowed to configure the share: whether the share is public or private, and whether participants have read-only or read/write permissions. If this method is not implemented, NSCloudKitSharingServiceStandard is assumed.
        #[optional]
        #[unsafe(method(optionsForSharingService:shareProvider:))]
        #[unsafe(method_family = none)]
        unsafe fn optionsForSharingService_shareProvider(
            &self,
            cloud_kit_sharing_service: &NSSharingService,
            provider: &NSItemProvider,
        ) -> NSCloudKitSharingServiceOptions;

        #[cfg(feature = "objc2-cloud-kit")]
        #[cfg(target_vendor = "apple")]
        /// When an NSSharingServiceNameCloudSharing sharing service successfully saves modifications to the CKShare, it will invoke this method on the delegate with the last-known state of the CKShare on the server.
        #[optional]
        #[unsafe(method(sharingService:didSaveShare:))]
        #[unsafe(method_family = none)]
        unsafe fn sharingService_didSaveShare(
            &self,
            sharing_service: &NSSharingService,
            share: &CKShare,
        );

        #[cfg(feature = "objc2-cloud-kit")]
        #[cfg(target_vendor = "apple")]
        /// When an NSSharingServiceNameCloudSharing sharing service stops sharing it will delete the CKShare from the server, then invoke this method on the delegate with the last-known state of the CKShare.
        #[optional]
        #[unsafe(method(sharingService:didStopSharing:))]
        #[unsafe(method_family = none)]
        unsafe fn sharingService_didStopSharing(
            &self,
            sharing_service: &NSSharingService,
            share: &CKShare,
        );
    }
);

mod private_NSItemProviderNSCloudKitSharing {
    pub trait Sealed {}
}

/// Category "NSCloudKitSharing" on [`NSItemProvider`].
#[doc(alias = "NSCloudKitSharing")]
pub unsafe trait NSItemProviderNSCloudKitSharing:
    ClassType + Sized + private_NSItemProviderNSCloudKitSharing::Sealed
{
    extern_methods!(
        #[cfg(all(feature = "block2", feature = "objc2-cloud-kit"))]
        #[cfg(target_vendor = "apple")]
        /// Use this method when you want to share a collection of CKRecords but don't currently have a CKShare. When the preparationHandler is called, you should create a new CKShare with the appropriate root CKRecord. After ensuring the share and all records have been saved to the server, invoke the preparationCompletionHandler with either the resulting CKShare and its CKContainer, or an NSError if saving failed. Invoking the service with a CKShare registered with this method will prompt the user to start sharing.
        #[unsafe(method(registerCloudKitShareWithPreparationHandler:))]
        #[unsafe(method_family = none)]
        unsafe fn registerCloudKitShareWithPreparationHandler(
            &self,
            preparation_handler: &block2::DynBlock<
                dyn Fn(
                    NonNull<block2::DynBlock<dyn Fn(*mut CKShare, *mut CKContainer, *mut NSError)>>,
                ),
            >,
        );

        #[cfg(feature = "objc2-cloud-kit")]
        #[cfg(target_vendor = "apple")]
        /// Use this method when you have a CKShare that is already saved to the server. Invoking the service with a CKShare registerd with this method will allow the owner to make modifications to the share settings, or will allow a participant to view the share settings.
        #[unsafe(method(registerCloudKitShare:container:))]
        #[unsafe(method_family = none)]
        unsafe fn registerCloudKitShare_container(&self, share: &CKShare, container: &CKContainer);
    );
}

impl private_NSItemProviderNSCloudKitSharing::Sealed for NSItemProvider {}
unsafe impl NSItemProviderNSCloudKitSharing for NSItemProvider {}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nssharingservicepicker?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSSharingServicePicker;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for NSSharingServicePicker {}
);

impl NSSharingServicePicker {
    extern_methods!(
        #[unsafe(method(delegate))]
        #[unsafe(method_family = none)]
        pub unsafe fn delegate(
            &self,
        ) -> Option<Retained<ProtocolObject<dyn NSSharingServicePickerDelegate>>>;

        /// This is a [weak property][objc2::topics::weak_property].
        /// Setter for [`delegate`][Self::delegate].
        #[unsafe(method(setDelegate:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDelegate(
            &self,
            delegate: Option<&ProtocolObject<dyn NSSharingServicePickerDelegate>>,
        );

        /// Returns a new picker. The items represent the objects to be shared and must conform to the
        /// <NSPasteboardWriting
        /// > protocol or be an NSItemProvider or an NSDocument. (e.g. NSString, NSImage, NSURL, etc.)
        #[unsafe(method(initWithItems:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithItems(this: Allocated<Self>, items: &NSArray) -> Retained<Self>;

        /// Use initWithItems: instead.
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        /// Shows the picker, populated with sharing services related to the instance items. When the user selects one of the sharing services, the sharing service will be performed. Note that this method must be called on mouseDown.
        #[unsafe(method(showRelativeToRect:ofView:preferredEdge:))]
        #[unsafe(method_family = none)]
        pub unsafe fn showRelativeToRect_ofView_preferredEdge(
            &self,
            rect: NSRect,
            view: &NSView,
            preferred_edge: NSRectEdge,
        );

        /// Closes the picker UI. `-[NSSharingServicePickerDelegate sharingServicePicker:didChooseSharingService:]` will be invoked if `delegate` is set, with a `nil` service.
        #[unsafe(method(close))]
        #[unsafe(method_family = none)]
        pub unsafe fn close(&self);

        #[cfg(feature = "NSMenuItem")]
        /// Returns a menu item suitable to display the picker for the given items.
        #[unsafe(method(standardShareMenuItem))]
        #[unsafe(method_family = none)]
        pub unsafe fn standardShareMenuItem(&self, mtm: MainThreadMarker) -> Retained<NSMenuItem>;
    );
}

/// Methods declared on superclass `NSObject`.
impl NSSharingServicePicker {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nssharingservicepickerdelegate?language=objc)
    pub unsafe trait NSSharingServicePickerDelegate: NSObjectProtocol {
        /// Allows the delegate to customize exactly what appears in the sharing service picker by reordering or removing the services before the picker is presented. It's possible to add custom services by mutating the proposedSharingServices array and adding new NSSharingService instances:
        ///
        /// ```objc
        /// NSMutableArray *sharingServices = [proposedServices mutableCopy];
        /// NSSharingService * customService = [[NSSharingService alloc] initWithTitle:
        /// "
        /// Service Title"
        /// image:image alternateImage:alternateImage
        /// handler:^{ [self doCustomServiceWithItems:items]; } ];
        /// [sharingServices addObject:customService];
        /// return [sharingServices autorelease];
        /// ```
        /// The items represent the objects to be shared and must conform to the
        /// <NSPasteboardWriting
        /// > protocol or be an NSItemProvider or an NSDocument. (e.g. NSString, NSImage, NSURL, etc.)
        #[optional]
        #[unsafe(method(sharingServicePicker:sharingServicesForItems:proposedSharingServices:))]
        #[unsafe(method_family = none)]
        unsafe fn sharingServicePicker_sharingServicesForItems_proposedSharingServices(
            &self,
            sharing_service_picker: &NSSharingServicePicker,
            items: &NSArray,
            proposed_services: &NSArray<NSSharingService>,
        ) -> Retained<NSArray<NSSharingService>>;

        /// Sent when the user has selected a service and the picker is about to execute it.
        #[optional]
        #[unsafe(method(sharingServicePicker:delegateForSharingService:))]
        #[unsafe(method_family = none)]
        unsafe fn sharingServicePicker_delegateForSharingService(
            &self,
            sharing_service_picker: &NSSharingServicePicker,
            sharing_service: &NSSharingService,
            mtm: MainThreadMarker,
        ) -> Option<Retained<ProtocolObject<dyn NSSharingServiceDelegate>>>;

        /// Sent when the user has selected a service and before it is executed. Service will be nil if the picker was dismissed.
        #[optional]
        #[unsafe(method(sharingServicePicker:didChooseSharingService:))]
        #[unsafe(method_family = none)]
        unsafe fn sharingServicePicker_didChooseSharingService(
            &self,
            sharing_service_picker: &NSSharingServicePicker,
            service: Option<&NSSharingService>,
        );

        #[cfg(feature = "NSSharingCollaborationModeRestriction")]
        /// Used to specify the case where the share picker should not support some modes of sharing even if they are supported by the items being shared.
        /// Disabling all possible modes at the same time is not supported behavior.
        #[optional]
        #[unsafe(method(sharingServicePickerCollaborationModeRestrictions:))]
        #[unsafe(method_family = none)]
        unsafe fn sharingServicePickerCollaborationModeRestrictions(
            &self,
            sharing_service_picker: &NSSharingServicePicker,
        ) -> Option<Retained<NSArray<NSSharingCollaborationModeRestriction>>>;
    }
);
