/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2025 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * TransfDIFSOctahedronV2Iteration https://www.shadertoy.com/view/sd2yWW
 * and https://iquilezles.org/articles/distfunctions/

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_transf_difs_octahedron_v2.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 TransfDIFSOctahedronV2Iteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	REAL4 q = z;
	REAL addCol = 0.0f;
	if (fractal->transformCommon.functionEnabledFFalse)
	{
		REAL4 h = fractal->transformCommon.offsetF000;
		q.x = clamp(q.x, -h.x, h.x);
		q.y = clamp(q.y, -h.y, h.y);
		q.z = clamp(q.z, -h.z, h.z);
		z = z - q;
	}

	REAL4 oldZ = z;
	REAL t = 0.0f;
	z *= fractal->transformCommon.scaleA1;
	aux->DE *= fractal->transformCommon.scaleA1;

	if (fractal->transformCommon.rotation2EnabledFalse
			&& aux->i >= fractal->transformCommon.startIterationsC
			&& aux->i < fractal->transformCommon.stopIterationsC)
	{
		z = Matrix33MulFloat4(fractal->transformCommon.rotationMatrix, z);
	}

	z = fabs(z);
	REAL m = 0.0f;
	if (!fractal->transformCommon.functionEnabledAFalse)
	{
		m = (z.x + z.y + z.z - fractal->transformCommon.offset1) * FRAC_1_3_F;
	}
	else
	{
		z -= fractal->transformCommon.offset000;
		m = (z.x + z.y + z.z - fractal->transformCommon.offset1) * FRAC_1_3_F;
		m = m * m * fractal->transformCommon.scale1;
	}

	q = z - (REAL4){m, m, m, 0.0f};
	REAL4 k = z;
	k.x = min(q.x, 0.0f);
	k.y = min(q.y, 0.0f);
	k.z = min(q.z, 0.0f);
	t = (k.x + k.y + k.z) * 0.5f;
	if (fractal->transformCommon.functionEnabledBFalse) q = fabs(z);
	q = q + (REAL4){t, t, t, 0.0f}; // - k * fractal->transformCommon.scale015;

	if (!fractal->transformCommon.functionEnabledAFalse)
		t = fractal->transformCommon.offset1;
	else
		t = fractal->transformCommon.offsetA1;
	REAL4 p = q;
	q.x = clamp(q.x, 0.0f, t);
	q.y = clamp(q.y, 0.0f, t);
	q.z = clamp(q.z, 0.0f, t);
	REAL4 o = q;
	q = z - q;
	t = dot(q, q);
	t = t / native_sqrt(t);
	REAL zcd = t * sign(m) - fractal->transformCommon.offset0005;
	addCol = fractal->foldColor.difs0000.x; // octhed color

	// box
	if (fractal->transformCommon.functionEnabledDFalse)
	{
		REAL4 zc = aux->const_c;
		zc = fabs(zc) - fractal->transformCommon.additionConstant0555;
		zc.x = max(zc.x, 0.0f);
		zc.y = max(zc.y, 0.0f);
		zc.z = max(zc.z, 0.0f);
		REAL zcb = length(zc) + min(max(max(zc.x, zc.y), zc.z), 0.0f);

		if (!fractal->transformCommon.functionEnabledJFalse)
		{
			if (zcb < zcd)
			{
				zcd = zcb;
				addCol = fractal->transformCommon.offset4;
			}
		}
		else
		{
			if (zcb > zcd)
			{
				zcd = zcb;
				addCol = fractal->transformCommon.offset4; // box color
			}
		}
	}

	// sphere
	if (fractal->transformCommon.functionEnabledEFalse)
	{
		REAL zcs = length(aux->const_c) - fractal->transformCommon.scale08;
		if (zcs < zcd)
		{
			zcd = zcs;
			if (!fractal->transformCommon.functionEnabledGFalse)
			{
				addCol = fractal->transformCommon.offset2;
			}
			else
			{
				addCol += fractal->transformCommon.offset2; // sphere color
			}
		}
	}

	if (fractal->analyticDE.enabledFalse)
		aux->DE = aux->DE * fractal->analyticDE.scale1 + fractal->analyticDE.offset0;

	aux->dist = min(aux->dist, zcd / aux->DE);

	if (fractal->foldColor.auxColorEnabledFalse && aux->i >= fractal->foldColor.startIterationsA
			&& aux->i < fractal->foldColor.stopIterationsA)
	{
		if (fractal->foldColor.auxColorEnabledAFalse)
		{
			t = oldZ.x * oldZ.y;
			if ((t > 0.0f && oldZ.z > 0.0f) || (t < 0.0f && oldZ.z < 0.0f))
				addCol += fractal->foldColor.difs0000.y;
			if (t > 0.0f) addCol += fractal->foldColor.difs0000.z;
			if (fractal->foldColor.difs0000.w != 0.0f)
			{
				p -= o;
				if (dot(p, p) > 0.0f) addCol += fractal->foldColor.difs0000.w;
			}
		}
		aux->color += addCol;
	}
	return z;
}