/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2020 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * CollatzIteration formula
 * @reference https://mathr.co.uk/blog/2016-04-10_collatz_fractal.html
 *            https://en.wikipedia.org/wiki/Collatz_conjecture#Iterating_on_real_or_complex_numbers

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_collatz.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 CollatzIteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	Q_UNUSED(fractal);

	REAL4 xV = (REAL4){1.0f, 1.0f, 1.0f, 0.0f};
	REAL4 temp = xV + z * 2.0f;
	temp *= RotateAroundVectorByAngle4(z, xV.xyz, M_PI_F);
	z = xV + z * 4.0f - temp;
	z /= 4.0f;
	aux->DE = aux->DE * 4.0f + 1.0f;
	return z;
}