/*
 * Decompiled with CFR 0.152.
 */
package pcgen.system;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.output.TeeOutputStream;
import org.apache.commons.lang.StringUtils;
import pcgen.core.SettingsHandler;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.facade.core.CharacterFacade;
import pcgen.facade.core.PartyFacade;
import pcgen.facade.core.SourceSelectionFacade;
import pcgen.facade.core.UIDelegate;
import pcgen.gui2.UIPropertyContext;
import pcgen.io.ExportException;
import pcgen.io.ExportHandler;
import pcgen.io.ExportUtilities;
import pcgen.io.PCGFile;
import pcgen.persistence.SourceFileLoader;
import pcgen.system.CharacterManager;
import pcgen.system.ConfigurationSettings;
import pcgen.system.PCGenSettings;
import pcgen.util.Logging;
import pcgen.util.fop.FopTask;

public class BatchExporter {
    private final String exportTemplateFilename;
    private final UIDelegate uiDelegate;
    private final boolean isPdf;

    public BatchExporter(String exportTemplateFilename, UIDelegate uiDelegate) {
        this.exportTemplateFilename = exportTemplateFilename;
        this.uiDelegate = uiDelegate;
        this.isPdf = ExportUtilities.isPdfTemplate(exportTemplateFilename);
    }

    public boolean exportCharacter(String characterFilename, String outputFile) {
        File file = new File(characterFilename);
        if (!PCGFile.isPCGenCharacterFile(file)) {
            Logging.errorPrint("Invalid character file specified: " + file.getAbsolutePath());
            return false;
        }
        String outFilename = outputFile;
        if (outFilename == null) {
            outFilename = this.generateOutputFilename(characterFilename);
        }
        Logging.log(Logging.INFO, "Started export of " + file.getAbsolutePath() + " using " + this.exportTemplateFilename + " to " + outFilename);
        SourceSelectionFacade sourcesForCharacter = CharacterManager.getRequiredSourcesForCharacter(file, this.uiDelegate);
        Logging.log(Logging.INFO, "Loading sources " + sourcesForCharacter.getCampaigns() + " using game mode " + sourcesForCharacter.getGameMode());
        SourceFileLoader loader = new SourceFileLoader(sourcesForCharacter, this.uiDelegate);
        loader.execute();
        CharacterFacade character = CharacterManager.openCharacter(file, this.uiDelegate, loader.getDataSetFacade());
        if (character == null) {
            return false;
        }
        File templateFile = new File(this.exportTemplateFilename);
        File outFile = new File(outFilename);
        if (this.isPdf) {
            return BatchExporter.exportCharacterToPDF(character, outFile, templateFile);
        }
        return BatchExporter.exportCharacterToNonPDF(character, outFile, templateFile);
    }

    public boolean exportParty(String partyFilename, String outputFile) {
        File file = new File(partyFilename);
        if (!PCGFile.isPCGenPartyFile(file)) {
            Logging.errorPrint("Invalid party file specified: " + file.getAbsolutePath());
            return false;
        }
        String outFilename = outputFile;
        if (outFilename == null) {
            outFilename = this.generateOutputFilename(partyFilename);
        }
        Logging.log(Logging.INFO, "Started export of party " + file.getAbsolutePath() + " using " + this.exportTemplateFilename + " to " + outFilename);
        SourceSelectionFacade sourcesForCharacter = CharacterManager.getRequiredSourcesForParty(file, this.uiDelegate);
        SourceFileLoader loader = new SourceFileLoader(sourcesForCharacter, this.uiDelegate);
        loader.execute();
        PartyFacade party = CharacterManager.openParty(file, this.uiDelegate, loader.getDataSetFacade());
        File templateFile = new File(this.exportTemplateFilename);
        File outFile = new File(outFilename);
        if (this.isPdf) {
            return BatchExporter.exportPartyToPDF(party, outFile, templateFile);
        }
        return BatchExporter.exportPartyToNonPDF(party, outFile, templateFile);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean exportCharacterToPDF(CharacterFacade character, File outFile, File templateFile) {
        String templateExtension = FilenameUtils.getExtension((String)templateFile.getName());
        boolean isTransformTemplate = "xslt".equalsIgnoreCase(templateExtension) || "xsl".equalsIgnoreCase(templateExtension);
        boolean useTempFile = PCGenSettings.OPTIONS_CONTEXT.initBoolean("generateTempFileWithPdf", false);
        String outFileName = FilenameUtils.removeExtension((String)outFile.getAbsolutePath());
        File tempFile = isTransformTemplate ? new File(outFileName + ".xml") : new File(outFileName + ".fo");
        try (BufferedOutputStream fileStream = new BufferedOutputStream(new FileOutputStream(outFile));
             ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
             ByteArrayOutputStream exportOutput = useTempFile ? new TeeOutputStream((OutputStream)byteOutputStream, (OutputStream)new FileOutputStream(tempFile)) : byteOutputStream;){
            FopTask task;
            ByteArrayInputStream inputStream;
            if (isTransformTemplate) {
                BatchExporter.exportCharacter(character, exportOutput);
                inputStream = new ByteArrayInputStream(byteOutputStream.toByteArray());
                task = FopTask.newFopTask((InputStream)inputStream, templateFile, fileStream);
            } else {
                BatchExporter.exportCharacter(character, templateFile, exportOutput);
                inputStream = new ByteArrayInputStream(byteOutputStream.toByteArray());
                task = FopTask.newFopTask((InputStream)inputStream, null, fileStream);
            }
            character.setDefaultOutputSheet(true, templateFile);
            task.run();
            if (!StringUtils.isNotBlank(task.getErrorMessages())) return true;
            Logging.errorPrint("BatchExporter.exportCharacterToPDF failed: " + task.getErrorMessages());
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            Logging.errorPrint("BatchExporter.exportCharacterToPDF failed", e);
            return false;
        }
        catch (ExportException e) {
            Logging.errorPrint("BatchExporter.exportCharacterToPDF failed", e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean exportCharacterToNonPDF(CharacterFacade character, File outFile, File templateFile) {
        try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), "UTF-8"));){
            character.export(new ExportHandler(templateFile), bw);
            character.setDefaultOutputSheet(false, templateFile);
            boolean bl = true;
            return bl;
        }
        catch (UnsupportedEncodingException e) {
            Logging.errorPrint("Unable to create output file " + outFile.getAbsolutePath(), e);
            return false;
        }
        catch (IOException e) {
            Logging.errorPrint("Unable to create output file " + outFile.getAbsolutePath(), e);
            return false;
        }
        catch (ExportException e) {
            return false;
        }
    }

    public static File getTempOutputFilename(File templateFile) {
        String extension = ExportUtilities.getOutputExtension(templateFile.getName(), ExportUtilities.isPdfTemplate(templateFile));
        try {
            return File.createTempFile("currentPC", "." + extension, SettingsHandler.getTempPath());
        }
        catch (IOException ioe) {
            ShowMessageDelegate.showMessageDialog("Could not create temporary preview file.", "PCGen", MessageType.ERROR);
            Logging.errorPrint("Could not create temporary preview file.", ioe);
            return null;
        }
    }

    public static boolean exportPartyToPDF(PartyFacade party, File outFile, File templateFile) {
        String templateExtension = ExportUtilities.getOutputExtension(templateFile.getName(), false);
        boolean isTransformTemplate = "xslt".equalsIgnoreCase(templateExtension) || "xsl".equalsIgnoreCase(templateExtension);
        boolean useTempFile = PCGenSettings.OPTIONS_CONTEXT.initBoolean("generateTempFileWithPdf", false);
        String outFileName = FilenameUtils.removeExtension((String)outFile.getAbsolutePath());
        File tempFile = isTransformTemplate ? new File(outFileName + ".xml") : new File(outFileName + ".fo");
        try (BufferedOutputStream fileStream = new BufferedOutputStream(new FileOutputStream(outFile));
             ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
             ByteArrayOutputStream exportOutput = useTempFile ? new TeeOutputStream((OutputStream)byteOutputStream, (OutputStream)new FileOutputStream(tempFile)) : byteOutputStream;){
            FopTask task;
            if (isTransformTemplate) {
                BatchExporter.exportParty(party, exportOutput);
                ByteArrayInputStream inputStream = new ByteArrayInputStream(byteOutputStream.toByteArray());
                task = FopTask.newFopTask((InputStream)inputStream, templateFile, fileStream);
            } else {
                SettingsHandler.setSelectedPartyPDFOutputSheet(templateFile.getAbsolutePath());
                BatchExporter.exportParty(party, templateFile, exportOutput);
                ByteArrayInputStream inputStream = new ByteArrayInputStream(byteOutputStream.toByteArray());
                task = FopTask.newFopTask((InputStream)inputStream, null, fileStream);
            }
            task.run();
        }
        catch (IOException e) {
            Logging.errorPrint("BatchExporter.exportPartyToPDF failed", e);
            return false;
        }
        catch (ExportException e) {
            Logging.errorPrint("BatchExporter.exportPartyToPDF failed", e);
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean exportPartyToNonPDF(PartyFacade party, File outFile, File templateFile) {
        try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), "UTF-8"));){
            party.export(new ExportHandler(templateFile), bw);
            boolean bl = true;
            return bl;
        }
        catch (UnsupportedEncodingException e) {
            Logging.errorPrint("Unable to create output file " + outFile.getAbsolutePath(), e);
            return false;
        }
        catch (IOException e) {
            Logging.errorPrint("Unable to create output file " + outFile.getAbsolutePath(), e);
            return false;
        }
    }

    public static void exportParty(PartyFacade party, OutputStream outputStream) throws IOException, ExportException {
        try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));){
            for (CharacterFacade character : party) {
                File templateFile = BatchExporter.getXMLTemplate(character);
                character.export(new ExportHandler(templateFile), bw);
            }
        }
    }

    public static void exportParty(PartyFacade party, File templateFile, OutputStream outputStream) throws IOException, ExportException {
        try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));){
            for (CharacterFacade character : party) {
                character.export(new ExportHandler(templateFile), bw);
            }
        }
    }

    public static void removeTemporaryFiles() {
        boolean cleanUp = UIPropertyContext.getInstance().initBoolean("cleanupTempFiles", true);
        if (!cleanUp) {
            return;
        }
        String aDirectory = SettingsHandler.getTempPath() + File.separator;
        new File(aDirectory).list(new FilenameFilter(){

            @Override
            public boolean accept(File aFile, String aString) {
                try {
                    if (aString.startsWith("currentPC")) {
                        File tf = new File(aFile, aString);
                        tf.delete();
                    }
                }
                catch (Exception e) {
                    Logging.errorPrint("removeTemporaryFiles", e);
                }
                return false;
            }
        });
    }

    public static void exportCharacter(CharacterFacade character, OutputStream outputStream) throws IOException, ExportException {
        BatchExporter.exportCharacter(character, BatchExporter.getXMLTemplate(character), outputStream);
    }

    public static void exportCharacter(CharacterFacade character, File templateFile, OutputStream outputStream) throws IOException, ExportException {
        try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));){
            character.export(new ExportHandler(templateFile), bw);
        }
    }

    public static File getXMLTemplate(CharacterFacade character) {
        File template = FileUtils.getFile((String[])new String[]{ConfigurationSettings.getSystemsDir(), "gameModes", character.getDataSet().getGameMode().getName(), "base.xml.ftl"});
        if (!template.exists()) {
            template = new File(ConfigurationSettings.getOutputSheetsDir(), "base.xml.ftl");
        }
        return template;
    }

    private String generateOutputFilename(String characterFilename) {
        File charFile = new File(characterFilename);
        String charname = charFile.getName();
        String extension = ExportUtilities.getOutputExtension(this.exportTemplateFilename, this.isPdf);
        String outputName = charname.substring(0, charname.lastIndexOf(46)) + "." + extension;
        return new File(charFile.getParent(), outputName).getAbsolutePath();
    }
}

