/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst.output.prereq;

import java.io.IOException;
import java.io.Writer;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteOperator;
import pcgen.persistence.PersistenceLayerException;

public class AbstractPrerequisiteWriter {
    protected void checkValidOperator(Prerequisite prereq, PrerequisiteOperator[] comparators) throws PersistenceLayerException {
        StringBuilder comparatorString = new StringBuilder(25);
        for (int i = 0; i < comparators.length; ++i) {
            PrerequisiteOperator comparator = comparators[i];
            if (prereq.getOperator().equals((Object)comparators[i])) {
                return;
            }
            if (i > 0) {
                comparatorString.append(", ");
            }
            comparatorString.append((Object)comparator);
        }
        String kind = prereq.getKind();
        if (kind == null) {
            kind = "<NULL>";
        }
        throw new PersistenceLayerException("Cannot write token: LST syntax only supports " + comparatorString.toString() + " operators for PRE" + kind.toUpperCase() + ": " + prereq.toString());
    }

    protected boolean checkForPremultOfKind(Prerequisite prereq, String kind, boolean multiplesOnly) {
        if (prereq.getKind() == null) {
            for (Prerequisite element : prereq.getPrerequisites()) {
                if (!kind.equalsIgnoreCase(element.getKind())) {
                    return false;
                }
                if (!multiplesOnly || element.isCountMultiples()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean specialCase(Writer writer, Prerequisite prereq) throws IOException {
        try {
            return false;
        }
        catch (Exception e) {
            throw new IOException();
        }
    }

    protected PrerequisiteOperator getConsolidateMethod(String handled, Prerequisite prereq, boolean ranked) {
        PrerequisiteOperator oper;
        block10: {
            if (prereq.getKind() != null) {
                return null;
            }
            oper = null;
            for (Prerequisite p : prereq.getPrerequisites()) {
                if (!ranked && !"1".equals(p.getOperand())) {
                    return null;
                }
                if (!handled.equalsIgnoreCase(p.getKind())) {
                    return null;
                }
                if (oper == null) {
                    oper = p.getOperator();
                    continue;
                }
                if (oper.equals((Object)p.getOperator())) continue;
                return null;
            }
            String count = prereq.getOperand();
            if (PrerequisiteOperator.LT.equals((Object)oper)) {
                try {
                    int i = Integer.parseInt(count);
                    if (prereq.getPrerequisiteCount() != i) {
                        return null;
                    }
                    break block10;
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            if (!PrerequisiteOperator.GTEQ.equals((Object)oper)) {
                return null;
            }
        }
        return oper;
    }
}

