/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io.migration;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import pcgen.cdom.enumeration.StringKey;
import pcgen.core.Equipment;
import pcgen.core.PlayerCharacter;
import pcgen.core.character.EquipSet;
import pcgen.core.utils.CoreUtility;

public class EquipSetMigration {
    private static EquipSetOutputOrderComparator comparator = new EquipSetOutputOrderComparator();

    public static void migrateEquipSets(PlayerCharacter pc, int[] pcgVer) {
        if (CoreUtility.compareVersions(pcgVer, new int[]{6, 1, 3}) < 0) {
            EquipSetMigration.renumberEquipmentSets(pc);
        }
    }

    static void renumberEquipmentSets(PlayerCharacter pc) {
        Collection<EquipSet> allEquipSets = pc.getDisplay().getEquipSet();
        List<EquipSet> sortedChildrenEs = EquipSetMigration.getSortedChildren(allEquipSets, "0");
        for (EquipSet equipSet : sortedChildrenEs) {
            List<EquipSet> children = EquipSetMigration.getSortedChildren(allEquipSets, equipSet.getIdPath());
            EquipSetMigration.renumberChildren(children, allEquipSets, equipSet.getIdPath());
        }
    }

    private static List<EquipSet> getSortedChildren(Collection<EquipSet> allEquipSets, String parentIdPath) {
        ArrayList<EquipSet> children = new ArrayList<EquipSet>();
        for (EquipSet equipSet : allEquipSets) {
            if (!equipSet.getParentIdPath().equals(parentIdPath)) continue;
            children.add(equipSet);
        }
        Collections.sort(children, comparator);
        return children;
    }

    private static void renumberChildren(List<EquipSet> targets, Collection<EquipSet> allEquipSets, String newParentPath) {
        if (targets.isEmpty()) {
            return;
        }
        int index = 1;
        DecimalFormat format = new DecimalFormat("00");
        for (EquipSet equipSet : targets) {
            String oldIdPath = equipSet.getIdPath();
            equipSet.setIdPath(newParentPath + "." + format.format(index++));
            List<EquipSet> children = EquipSetMigration.getSortedChildren(allEquipSets, oldIdPath);
            EquipSetMigration.renumberChildren(children, allEquipSets, equipSet.getIdPath());
        }
    }

    private static class EquipSetOutputOrderComparator
    implements Comparator<EquipSet> {
        private EquipSetOutputOrderComparator() {
        }

        @Override
        public int compare(EquipSet arg0, EquipSet arg1) {
            String sortKey1;
            int equipOutputOrder1;
            Equipment equip0 = arg0.getItem();
            Equipment equip1 = arg1.getItem();
            int equipOutputOrder0 = equip0 == null ? 99999 : equip0.getOutputIndex();
            int n = equipOutputOrder1 = equip1 == null ? 99999 : equip1.getOutputIndex();
            if (equipOutputOrder0 != equipOutputOrder1) {
                return Integer.valueOf(equipOutputOrder0).compareTo(equipOutputOrder1);
            }
            String sortKey0 = this.getSortKey(equip0);
            if (!sortKey0.equals(sortKey1 = this.getSortKey(equip1))) {
                return sortKey0.compareTo(sortKey1);
            }
            return arg0.getIdPath().compareTo(arg1.getIdPath());
        }

        private String getSortKey(Equipment equip) {
            if (equip == null) {
                return "zzzzzzzz";
            }
            String key = equip.get(StringKey.SORT_KEY);
            if (key == null) {
                key = equip.getDisplayName();
            }
            return key;
        }
    }
}

