/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.prefs;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import pcgen.core.Globals;
import pcgen.gui2.UIPropertyContext;
import pcgen.gui2.prefs.PCGenPrefsPanel;
import pcgen.gui2.tools.Utility;
import pcgen.system.LanguageBundle;

public class ColorsPanel
extends PCGenPrefsPanel {
    private static String in_color = LanguageBundle.getString("in_Prefs_color");
    private static String in_colorPrereqQualify = LanguageBundle.getString("in_Prefs_colorPrereqQualify");
    private static String in_colorPrereqFail = LanguageBundle.getString("in_Prefs_colorPrereqFail");
    private static String in_colorAutoFeat = LanguageBundle.getString("in_Prefs_colorAutoFeat");
    private static String in_colorVirtFeat = LanguageBundle.getString("in_Prefs_colorVirtFeat");
    private static String in_colorSourceRelease = LanguageBundle.getString("in_Prefs_colorStatusRelease");
    private static String in_colorSourceAlpha = LanguageBundle.getString("in_Prefs_colorStatusAlpha");
    private static String in_colorSourceBeta = LanguageBundle.getString("in_Prefs_colorStatusBeta");
    private static String in_colorSourceTest = LanguageBundle.getString("in_Prefs_colorStatusTest");
    private JButton featAutoColor;
    private JButton featVirtualColor;
    private JButton prereqFailColor;
    private JButton prereqQualifyColor;
    private JButton sourceStatusRelease;
    private JButton sourceStatusAlpha;
    private JButton sourceStatusBeta;
    private JButton sourceStatusTest;
    private PrefsButtonListener prefsButtonHandler = new PrefsButtonListener();

    public ColorsPanel() {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        Border etched = null;
        TitledBorder title1 = BorderFactory.createTitledBorder(etched, in_color);
        title1.setTitleJustification(1);
        this.setBorder(title1);
        gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(2, 2, 2, 2);
        int col = 0;
        this.prereqQualifyColor = new JButton(in_colorPrereqQualify);
        col = this.addColorsOption(col, c, gridbag, this, this.prereqQualifyColor);
        this.prereqFailColor = new JButton(in_colorPrereqFail);
        col = this.addColorsOption(col, c, gridbag, this, this.prereqFailColor);
        this.featAutoColor = new JButton(in_colorAutoFeat);
        col = this.addColorsOption(col, c, gridbag, this, this.featAutoColor);
        this.featVirtualColor = new JButton(in_colorVirtFeat);
        col = this.addColorsOption(col, c, gridbag, this, this.featVirtualColor);
        this.sourceStatusRelease = new JButton(in_colorSourceRelease);
        col = this.addColorsOption(col, c, gridbag, this, this.sourceStatusRelease);
        this.sourceStatusAlpha = new JButton(in_colorSourceAlpha);
        col = this.addColorsOption(col, c, gridbag, this, this.sourceStatusAlpha);
        this.sourceStatusBeta = new JButton(in_colorSourceBeta);
        col = this.addColorsOption(col, c, gridbag, this, this.sourceStatusBeta);
        this.sourceStatusTest = new JButton(in_colorSourceTest);
        col = this.addColorsOption(col, c, gridbag, this, this.sourceStatusTest);
        Utility.buildConstraints(c, 5, 20, 1, 1, 1.0, 1.0);
        c.fill = 1;
        JLabel label = new JLabel(" ");
        gridbag.setConstraints(label, c);
        this.add(label);
    }

    private int addColorsOption(int col, GridBagConstraints c, GridBagLayout gridbag, JPanel colorsPanel, JButton button) {
        Utility.buildConstraints(c, 0, col++, 1, 1, 0.0, 0.0);
        gridbag.setConstraints(button, c);
        colorsPanel.add(button);
        button.addActionListener(this.prefsButtonHandler);
        return col;
    }

    @Override
    public String getTitle() {
        return in_color;
    }

    @Override
    public void setOptionsBasedOnControls() {
        UIPropertyContext.setQualifiedColor(this.prereqQualifyColor.getForeground());
        UIPropertyContext.setNotQualifiedColor(this.prereqFailColor.getForeground());
        UIPropertyContext.setAutomaticColor(this.featAutoColor.getForeground());
        UIPropertyContext.setVirtualColor(this.featVirtualColor.getForeground());
        UIPropertyContext.setSourceStatusReleaseColor(this.sourceStatusRelease.getForeground());
        UIPropertyContext.setSourceStatusAlphaColor(this.sourceStatusAlpha.getForeground());
        UIPropertyContext.setSourceStatusBetaColor(this.sourceStatusBeta.getForeground());
        UIPropertyContext.setSourceStatusTestColor(this.sourceStatusTest.getForeground());
    }

    @Override
    public void applyOptionValuesToControls() {
        this.prereqQualifyColor.setForeground(UIPropertyContext.getQualifiedColor());
        this.prereqFailColor.setForeground(UIPropertyContext.getNotQualifiedColor());
        this.featAutoColor.setForeground(UIPropertyContext.getAutomaticColor());
        this.featVirtualColor.setForeground(UIPropertyContext.getVirtualColor());
        this.sourceStatusRelease.setForeground(UIPropertyContext.getSourceStatusReleaseColor());
        this.sourceStatusAlpha.setForeground(UIPropertyContext.getSourceStatusAlphaColor());
        this.sourceStatusBeta.setForeground(UIPropertyContext.getSourceStatusBetaColor());
        this.sourceStatusTest.setForeground(UIPropertyContext.getSourceStatusTestColor());
    }

    private final class PrefsButtonListener
    implements ActionListener {
        private PrefsButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Color newColor;
            JButton source = (JButton)actionEvent.getSource();
            if (source != null && (source == ColorsPanel.this.prereqQualifyColor || source == ColorsPanel.this.prereqFailColor || source == ColorsPanel.this.featAutoColor || source == ColorsPanel.this.featVirtualColor) && (newColor = JColorChooser.showDialog(Globals.getRootFrame(), LanguageBundle.getString("in_Prefs_colorSelect") + source.getText().toLowerCase(), source.getForeground())) != null) {
                source.setForeground(newColor);
            }
        }
    }
}

