/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.facade;

import java.util.List;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.SourceFormat;
import pcgen.cdom.enumeration.StringKey;
import pcgen.core.Domain;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.character.CharacterSpell;
import pcgen.core.character.SpellInfo;
import pcgen.core.spell.Spell;
import pcgen.facade.core.SpellFacade;
import pcgen.util.SortKeyAware;

public class SpellFacadeImplem
implements SpellFacade,
SortKeyAware {
    private final PlayerCharacter pc;
    private final Spell spell;
    private final CharacterSpell charSpell;
    private final SpellInfo spellInfo;

    public SpellFacadeImplem(PlayerCharacter pc, Spell spell, CharacterSpell charSpell, SpellInfo spellInfo) {
        this.pc = pc;
        this.spell = spell;
        this.charSpell = charSpell;
        this.spellInfo = spellInfo;
    }

    @Override
    public String getSource() {
        return SourceFormat.getFormattedString(this.spell, Globals.getSourceDisplay(), true);
    }

    @Override
    public String getSourceForNodeDisplay() {
        return SourceFormat.getFormattedString(this.spell, SourceFormat.LONG, true);
    }

    @Override
    public String getKeyName() {
        return this.spell.getKeyName();
    }

    @Override
    public String getSchool() {
        return this.spell.getListAsString(ListKey.SPELL_SCHOOL);
    }

    @Override
    public String getSubschool() {
        return this.spell.getListAsString(ListKey.SPELL_SUBSCHOOL);
    }

    @Override
    public String[] getDescriptors() {
        List<String> descriptors = this.spell.getListFor(ListKey.SPELL_DESCRIPTOR);
        if (descriptors == null) {
            return new String[0];
        }
        return descriptors.toArray(new String[0]);
    }

    @Override
    public String getComponents() {
        return this.spell.getListAsString(ListKey.COMPONENTS);
    }

    @Override
    public String getRange() {
        return this.pc.getSpellRange(this.charSpell, this.spellInfo);
    }

    @Override
    public String getDuration() {
        return this.pc.parseSpellString(this.charSpell, this.spell.getListAsString(ListKey.DURATION));
    }

    @Override
    public String getCastTime() {
        return this.spell.getListAsString(ListKey.CASTTIME);
    }

    Spell getSpell() {
        return this.spell;
    }

    CharacterSpell getCharSpell() {
        return this.charSpell;
    }

    SpellInfo getSpellInfo() {
        return this.spellInfo;
    }

    @Override
    public String toString() {
        StringBuilder buff = new StringBuilder();
        if (this.spell != null) {
            buff.append(this.spell.toString());
        } else if (this.charSpell != null) {
            buff.append(this.charSpell.toString());
        }
        if (this.charSpell != null && this.charSpell.getOwner() instanceof Domain) {
            buff.append(" [").append(this.charSpell.getOwner().toString()).append("]");
        }
        if (this.spellInfo != null) {
            buff.append(this.spellInfo.toString());
        }
        return buff.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.charSpell == null ? 0 : this.charSpell.hashCode());
        result = 31 * result + (this.pc == null ? 0 : this.pc.hashCode());
        result = 31 * result + (this.spell == null ? 0 : this.spell.hashCode());
        result = 31 * result + (this.spellInfo == null ? 0 : this.spellInfo.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SpellFacadeImplem other = (SpellFacadeImplem)obj;
        if (this.charSpell == null ? other.charSpell != null : !this.charSpell.equals(other.charSpell)) {
            return false;
        }
        if (this.pc == null ? other.pc != null : !this.pc.equals(other.pc)) {
            return false;
        }
        if (this.spell == null ? other.spell != null : !this.spell.equals(other.spell)) {
            return false;
        }
        return !(this.spellInfo == null ? other.spellInfo != null : !this.spellInfo.equals(other.spellInfo));
    }

    @Override
    public boolean isNamePI() {
        return this.spell.isNamePI();
    }

    @Override
    public String getType() {
        return this.spell.getType();
    }

    @Override
    public String getSortKey() {
        String sortKey = this.spell.get(StringKey.SORT_KEY);
        if (sortKey == null) {
            sortKey = this.spell.getDisplayName();
        }
        return sortKey;
    }
}

