/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.facade;

import java.io.File;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import pcgen.base.formula.Formula;
import pcgen.base.lang.StringUtil;
import pcgen.base.util.Indirect;
import pcgen.base.util.ObjectContainer;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.ChooseInformation;
import pcgen.cdom.content.CNAbility;
import pcgen.cdom.content.CNAbilityFactory;
import pcgen.cdom.content.HitDie;
import pcgen.cdom.content.LevelCommandFactory;
import pcgen.cdom.content.fact.FactDefinition;
import pcgen.cdom.content.factset.FactSetDefinition;
import pcgen.cdom.enumeration.AspectName;
import pcgen.cdom.enumeration.FactKey;
import pcgen.cdom.enumeration.FactSetKey;
import pcgen.cdom.enumeration.FormulaKey;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.MapKey;
import pcgen.cdom.enumeration.Nature;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.RaceSubType;
import pcgen.cdom.enumeration.RaceType;
import pcgen.cdom.enumeration.SourceFormat;
import pcgen.cdom.enumeration.StringKey;
import pcgen.cdom.helper.Aspect;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.Ability;
import pcgen.core.BenefitFormatting;
import pcgen.core.BonusManager;
import pcgen.core.Deity;
import pcgen.core.Domain;
import pcgen.core.Equipment;
import pcgen.core.EquipmentModifier;
import pcgen.core.Globals;
import pcgen.core.Kit;
import pcgen.core.Movement;
import pcgen.core.PCClass;
import pcgen.core.PCStat;
import pcgen.core.PCTemplate;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;
import pcgen.core.SettingsHandler;
import pcgen.core.Skill;
import pcgen.core.SpecialProperty;
import pcgen.core.SubClass;
import pcgen.core.WeaponProf;
import pcgen.core.analysis.BonusCalc;
import pcgen.core.analysis.OutputNameFormatting;
import pcgen.core.analysis.SkillInfoUtilities;
import pcgen.core.bonus.BonusObj;
import pcgen.core.character.CharacterSpell;
import pcgen.core.character.SpellBook;
import pcgen.core.character.SpellInfo;
import pcgen.core.character.WieldCategory;
import pcgen.core.display.CharacterDisplay;
import pcgen.core.display.DescriptionFormatting;
import pcgen.core.display.SkillCostDisplay;
import pcgen.core.display.TemplateModifier;
import pcgen.core.display.VisionDisplay;
import pcgen.core.kit.BaseKit;
import pcgen.core.prereq.PrerequisiteUtilities;
import pcgen.core.spell.Spell;
import pcgen.facade.core.AbilityFacade;
import pcgen.facade.core.ClassFacade;
import pcgen.facade.core.DeityFacade;
import pcgen.facade.core.DomainFacade;
import pcgen.facade.core.EquipModFacade;
import pcgen.facade.core.EquipmentFacade;
import pcgen.facade.core.InfoFacade;
import pcgen.facade.core.InfoFactory;
import pcgen.facade.core.KitFacade;
import pcgen.facade.core.RaceFacade;
import pcgen.facade.core.SkillFacade;
import pcgen.facade.core.SpellFacade;
import pcgen.facade.core.TempBonusFacade;
import pcgen.facade.core.TemplateFacade;
import pcgen.gui2.facade.DomainFacadeImpl;
import pcgen.gui2.facade.SpellFacadeImplem;
import pcgen.gui2.facade.TempBonusFacadeImpl;
import pcgen.gui2.facade.TempBonusHelper;
import pcgen.gui2.util.HtmlInfoBuilder;
import pcgen.rules.context.LoadContext;
import pcgen.system.LanguageBundle;
import pcgen.system.PCGenSettings;
import pcgen.util.Delta;
import pcgen.util.Logging;
import pcgen.util.enumeration.Tab;
import pcgen.util.enumeration.View;

public class Gui2InfoFactory
implements InfoFactory {
    private static final String EMPTY_STRING = "";
    private static NumberFormat ADJ_FMT = new DecimalFormat("+0;-0");
    private static NumberFormat COST_FMT = new DecimalFormat("#,##0.##");
    public static final String TWO_SPACES = " &nbsp;";
    public static final String BOLD = "<b>";
    public static final String END_BOLD = "</b>";
    private final PlayerCharacter pc;
    private final CharacterDisplay charDisplay;

    public Gui2InfoFactory(PlayerCharacter pc) {
        this.pc = pc;
        this.charDisplay = pc == null ? null : pc.getDisplay();
    }

    @Override
    public String getFavoredClass(RaceFacade race) {
        if (!(race instanceof Race)) {
            return EMPTY_STRING;
        }
        String[] favClass = Globals.getContext().unparseSubtoken((Race)race, "FAVCLASS");
        return StringUtil.join((String[])favClass, (String)", ");
    }

    @Override
    public String getHTMLInfo(RaceFacade raceFacade) {
        if (!(raceFacade instanceof Race)) {
            return EMPTY_STRING;
        }
        Race race = (Race)raceFacade;
        HtmlInfoBuilder infoText = new HtmlInfoBuilder();
        if (!race.getKeyName().startsWith("<none")) {
            String favoredClass;
            LevelCommandFactory levelCommandFactory;
            String statAdjustments;
            String desc;
            String bString;
            String vision;
            String movement;
            List<RaceSubType> rst;
            infoText.appendTitleElement(OutputNameFormatting.piString(race, false));
            infoText.appendLineBreak();
            RaceType rt = race.get(ObjectKey.RACETYPE);
            if (rt != null) {
                infoText.appendI18nElement("in_irInfoRaceType", rt.toString());
            }
            if ((rst = race.getListFor(ListKey.RACESUBTYPE)) != null) {
                infoText.appendSpacer();
                infoText.appendI18nElement("in_irInfoSubType", StringUtil.join(rst, (String)", "));
            }
            if (race.getType().length() > 0) {
                infoText.appendSpacer();
                infoText.appendI18nElement("in_irInfoType", race.getType());
            }
            this.appendFacts(infoText, race);
            infoText.appendLineBreak();
            String size = race.getSize();
            if (StringUtils.isNotEmpty(size)) {
                infoText.appendI18nElement("in_size", size);
            }
            if ((movement = this.getMovement(raceFacade)).length() > 0) {
                infoText.appendSpacer();
                infoText.appendI18nElement("in_movement", movement);
            }
            if ((vision = this.getVision(raceFacade)).length() > 0) {
                infoText.appendSpacer();
                infoText.appendI18nElement("in_vision", vision);
            }
            if ((bString = PrerequisiteUtilities.preReqHTMLStringsForList(this.pc, null, race.getPrerequisiteList(), false)).length() > 0) {
                infoText.appendLineBreak();
                infoText.appendI18nElement("in_requirements", bString);
            }
            if ((desc = this.pc.getDescription(race)).length() > 0) {
                infoText.appendLineBreak();
                infoText.appendI18nFormattedElement("in_InfoDescription", DescriptionFormatting.piWrapDesc(race, desc, false));
            }
            if (StringUtils.isNotEmpty(statAdjustments = this.getStatAdjustments(raceFacade))) {
                infoText.appendLineBreak();
                infoText.appendI18nElement("in_irTableStat", statAdjustments);
            }
            if ((levelCommandFactory = race.get(ObjectKey.MONSTER_CLASS)) != null) {
                infoText.appendLineBreak();
                infoText.appendI18nFormattedElement("in_irInfoMonsterClass", String.valueOf(levelCommandFactory.getLevelCount()), OutputNameFormatting.piString(levelCommandFactory.getPCClass(), false));
            }
            if (StringUtils.isNotEmpty(favoredClass = this.getFavoredClass(raceFacade))) {
                infoText.appendLineBreak();
                infoText.appendI18nElement("in_favoredClass", favoredClass);
            }
            if ((bString = race.getSource()).length() > 0) {
                infoText.appendLineBreak();
                infoText.appendI18nElement("in_sourceLabel", bString);
            }
        }
        return infoText.toString();
    }

    @Override
    public String getHTMLInfo(ClassFacade classFacade, ClassFacade parentClassFacade) {
        String desc;
        PCClass aClass;
        if (!(classFacade instanceof PCClass)) {
            return EMPTY_STRING;
        }
        PCClass parentClass = aClass = (PCClass)classFacade;
        boolean isSubClass = aClass instanceof SubClass;
        if (isSubClass && parentClassFacade != null) {
            parentClass = (PCClass)parentClassFacade;
        }
        HtmlInfoBuilder b = new HtmlInfoBuilder(OutputNameFormatting.piString(aClass, false));
        b.appendLineBreak();
        if (isSubClass && aClass.getSafe(IntegerKey.COST) != 0) {
            b.appendI18nElement("in_clInfoCost", String.valueOf(aClass.getSafe(IntegerKey.COST)));
            b.appendLineBreak();
        }
        String aString = aClass.getType();
        if (isSubClass && aString.length() == 0) {
            aString = parentClass.getType();
        }
        b.appendI18nElement("in_clInfoType", aString);
        HitDie hitDie = aClass.getSafe(ObjectKey.LEVEL_HITDIE);
        if (isSubClass && HitDie.ZERO.equals(hitDie)) {
            hitDie = parentClass.getSafe(ObjectKey.LEVEL_HITDIE);
        }
        if (!HitDie.ZERO.equals(hitDie)) {
            b.appendSpacer();
            b.appendI18nElement("in_clInfoHD", "d" + hitDie.getDie());
        }
        this.appendFacts(b, aClass);
        if (SettingsHandler.getGame().getTabShown(Tab.SPELLS)) {
            FactKey fk = FactKey.valueOf("SpellType");
            aString = (String)aClass.getResolved(fk);
            if (isSubClass && aString == null) {
                aString = parentClass.getSpellType();
            }
            b.appendSpacer();
            b.appendI18nElement("in_clInfoSpellType", aString);
            aString = aClass.getSpellBaseStat();
            if (isSubClass && (aString == null || aString.length() == 0)) {
                aString = parentClass.getSpellBaseStat();
            }
            b.appendSpacer();
            b.appendI18nElement("in_clInfoBaseStat", aString);
        }
        aString = PrerequisiteUtilities.preReqHTMLStringsForList(this.pc, null, aClass.getPrerequisiteList(), false);
        if (isSubClass && aString.length() == 0) {
            aString = PrerequisiteUtilities.preReqHTMLStringsForList(this.pc, null, parentClass.getPrerequisiteList(), false);
        }
        if (aString.length() > 0) {
            b.appendLineBreak();
            b.appendI18nElement("in_requirements", aString);
        }
        if ((desc = this.pc.getDescription(aClass)).length() > 0) {
            b.appendLineBreak();
            b.appendI18nFormattedElement("in_InfoDescription", DescriptionFormatting.piWrapDesc(aClass, desc, false));
        }
        if (isSubClass) {
            int specialtySpells = aClass.getSafe(IntegerKey.KNOWN_SPELLS_FROM_SPECIALTY);
            b.appendLineBreak();
            b.appendI18nElement("in_clSpecialtySpells", Delta.toString(specialtySpells));
            b.appendSpacer();
            b.appendI18nElement("in_clSpecialty", ((SubClass)aClass).getChoice());
        }
        aString = aClass.getSource();
        if (isSubClass && aString.length() == 0) {
            aString = parentClass.getSource();
        }
        if (aString.length() > 0) {
            b.appendLineBreak();
            b.appendI18nElement("in_source", aString);
        }
        return b.toString();
    }

    @Override
    public String getHTMLInfo(SkillFacade skillFacade) {
        String desc;
        if (!(skillFacade instanceof Skill)) {
            return EMPTY_STRING;
        }
        Skill skill = (Skill)skillFacade;
        HtmlInfoBuilder infoText = new HtmlInfoBuilder();
        infoText.appendTitleElement(OutputNameFormatting.piString(skill, false));
        infoText.appendLineBreak();
        String typeString = StringUtil.join(skill.getTrueTypeList(true), (String)". ");
        if (StringUtils.isNotBlank(typeString)) {
            infoText.appendI18nElement("in_igInfoLabelTextType", typeString);
            infoText.appendLineBreak();
        }
        this.appendFacts(infoText, skill);
        String aString = SkillInfoUtilities.getKeyStatFromStats(this.pc, skill);
        if (aString.length() != 0) {
            infoText.appendI18nElement("in_iskKEY_STAT", aString);
        }
        infoText.appendLineBreak();
        infoText.appendI18nElement("in_iskUntrained", skill.getSafe(ObjectKey.USE_UNTRAINED) != false ? LanguageBundle.getString("in_yes") : LanguageBundle.getString("in_no"));
        infoText.appendLineBreak();
        infoText.appendI18nElement("in_iskEXCLUSIVE", skill.getSafe(ObjectKey.EXCLUSIVE) != false ? LanguageBundle.getString("in_yes") : LanguageBundle.getString("in_no"));
        String bString = PrerequisiteUtilities.preReqHTMLStringsForList(this.pc, null, skill.getPrerequisiteList(), false);
        if (bString.length() > 0) {
            infoText.appendI18nFormattedElement("in_InfoRequirements", bString);
        }
        if ((desc = this.pc.getDescription(skill)).length() > 0) {
            infoText.appendLineBreak();
            infoText.appendI18nFormattedElement("in_InfoDescription", DescriptionFormatting.piWrapDesc(skill, desc, false));
        }
        if ((bString = skill.getSource()).length() > 0) {
            infoText.appendLineBreak();
            infoText.appendI18nElement("in_iskSource", bString);
        }
        if (PCGenSettings.OPTIONS_CONTEXT.getBoolean("showSkillModBreakdown", false) && (bString = SkillCostDisplay.getModifierExplanation(skill, this.pc, false)).length() != 0) {
            infoText.appendLineBreak();
            infoText.appendI18nFormattedElement("in_iskHtml_PcMod", bString);
        }
        if (PCGenSettings.OPTIONS_CONTEXT.getBoolean("showSkillRankBreakdown", false)) {
            bString = SkillCostDisplay.getRanksExplanation(this.pc, skill);
            if (bString.length() == 0) {
                bString = LanguageBundle.getString("in_none");
            }
            infoText.appendLineBreak();
            infoText.appendI18nFormattedElement("in_iskHtml_Ranks", bString);
        }
        return infoText.toString();
    }

    @Override
    public String getHTMLInfo(AbilityFacade abilityFacade) {
        String bene;
        if (!(abilityFacade instanceof Ability)) {
            return EMPTY_STRING;
        }
        Ability ability = (Ability)abilityFacade;
        HtmlInfoBuilder infoText = new HtmlInfoBuilder();
        infoText.appendTitleElement(OutputNameFormatting.piString(ability, false));
        infoText.appendLineBreak();
        infoText.appendI18nFormattedElement("Ability.Info.Type", StringUtil.join(ability.getTrueTypeList(true), (String)". "));
        BigDecimal costStr = ability.getSafe(ObjectKey.SELECTION_COST);
        if (!costStr.equals(BigDecimal.ONE)) {
            infoText.appendI18nFormattedElement("Ability.Info.Cost", COST_FMT.format(costStr));
        }
        if (ability.getSafe(ObjectKey.MULTIPLE_ALLOWED).booleanValue()) {
            infoText.appendSpacer();
            infoText.append(LanguageBundle.getString("Ability.Info.Multiple"));
        }
        if (ability.getSafe(ObjectKey.STACKS).booleanValue()) {
            infoText.appendSpacer();
            infoText.append(LanguageBundle.getString("Ability.Info.Stacks"));
        }
        this.appendFacts(infoText, ability);
        String cString = PrerequisiteUtilities.preReqHTMLStringsForList(this.pc, null, ability.getPrerequisiteList(), false);
        if (cString.length() > 0) {
            infoText.appendI18nFormattedElement("in_InfoRequirements", cString);
        }
        infoText.appendLineBreak();
        infoText.appendI18nFormattedElement("in_InfoDescription", this.getDescription(abilityFacade));
        List<CNAbility> wrappedAbility = this.getWrappedAbility(ability);
        if (ability.getSafeSizeOfMapFor(MapKey.ASPECT) > 0) {
            Set<AspectName> aspectKeys = ability.getKeysFor(MapKey.ASPECT);
            StringBuilder buff = new StringBuilder(100);
            for (AspectName key : aspectKeys) {
                if (buff.length() > 0) {
                    buff.append(", ");
                }
                buff.append(Aspect.printAspect(this.pc, key, wrappedAbility));
            }
            infoText.appendLineBreak();
            infoText.appendI18nFormattedElement("Ability.Info.Aspects", buff.toString());
        }
        if ((bene = BenefitFormatting.getBenefits(this.pc, wrappedAbility)) != null && bene.length() > 0) {
            infoText.appendLineBreak();
            infoText.appendI18nFormattedElement("Ability.Info.Benefit", BenefitFormatting.getBenefits(this.pc, wrappedAbility));
        }
        infoText.appendLineBreak();
        infoText.appendI18nFormattedElement("in_InfoSource", ability.getSource());
        return infoText.toString();
    }

    @Override
    public String getHTMLInfo(DeityFacade deityFacade) {
        if (!(deityFacade instanceof Deity)) {
            return EMPTY_STRING;
        }
        Deity aDeity = (Deity)deityFacade;
        HtmlInfoBuilder infoText = new HtmlInfoBuilder();
        if (aDeity != null) {
            infoText.appendTitleElement(OutputNameFormatting.piString(aDeity, false));
            infoText.appendLineBreak();
            infoText.appendI18nFormattedElement("in_InfoDescription", DescriptionFormatting.piWrapDesc(aDeity, this.pc.getDescription(aDeity), false));
            this.appendFacts(infoText, aDeity);
            String aString = this.getPantheons(aDeity);
            if (aString != null) {
                infoText.appendSpacer();
                infoText.appendI18nElement("in_pantheon", aString);
            }
            infoText.appendSpacer();
            infoText.appendI18nElement("in_domains", this.getDomains(aDeity));
            List<CDOMReference<WeaponProf>> dwp = aDeity.getListFor(ListKey.DEITYWEAPON);
            if (dwp != null) {
                infoText.appendSpacer();
                infoText.appendI18nFormattedElement("in_deityFavWeap", ReferenceUtilities.joinLstFormat(dwp, "|"));
            }
            if ((aString = PrerequisiteUtilities.preReqHTMLStringsForList(this.pc, null, aDeity.getPrerequisiteList(), false)).length() != 0) {
                infoText.appendSpacer();
                infoText.appendI18nFormattedElement("in_InfoRequirements", aString);
            }
            if ((aString = aDeity.getSource()).length() > 0) {
                infoText.appendSpacer();
                infoText.appendI18nFormattedElement("in_InfoSource", aString);
            }
        }
        return infoText.toString();
    }

    @Override
    public String getHTMLInfo(DomainFacade domainFacade) {
        if (!(domainFacade instanceof DomainFacadeImpl)) {
            return EMPTY_STRING;
        }
        DomainFacadeImpl domainFI = (DomainFacadeImpl)domainFacade;
        Domain aDomain = (Domain)domainFI.getRawObject();
        HtmlInfoBuilder infoText = new HtmlInfoBuilder();
        if (aDomain != null) {
            infoText.appendTitleElement(OutputNameFormatting.piString(aDomain, false));
            this.appendFacts(infoText, aDomain);
            String aString = this.pc.getDescription(aDomain);
            if (aString.length() != 0) {
                infoText.appendLineBreak();
                infoText.appendI18nFormattedElement("in_domainGrant", aString);
            }
            if ((aString = PrerequisiteUtilities.preReqHTMLStringsForList(this.pc, null, aDomain.getPrerequisiteList(), false)).length() != 0) {
                infoText.appendI18nFormattedElement("in_InfoRequirements", aString);
            }
            if ((aString = PrerequisiteUtilities.preReqHTMLStringsForList(this.pc, aDomain, domainFI.getPrerequisiteList(), false)).length() != 0) {
                infoText.appendLineBreak();
                infoText.appendI18nFormattedElement("in_domainRequirements", aString);
            }
            if ((aString = SourceFormat.getFormattedString(aDomain, Globals.getSourceDisplay(), true)).length() > 0) {
                infoText.appendI18nFormattedElement("in_InfoSource", aString);
            }
        }
        return infoText.toString();
    }

    @Override
    public String getHTMLInfo(EquipmentFacade equipFacade) {
        if (equipFacade == null || !(equipFacade instanceof Equipment)) {
            return EMPTY_STRING;
        }
        Equipment equip = (Equipment)equipFacade;
        HtmlInfoBuilder b = this.getEquipmentHtmlInfo(equip);
        String bString = equip.getSource();
        if (bString.length() > 0) {
            b.appendLineBreak();
            b.appendI18nElement("in_igInfoLabelTextSource", bString);
        }
        b.appendLineBreak();
        return b.toString();
    }

    private HtmlInfoBuilder getEquipmentHtmlInfo(Equipment equip) {
        String note;
        String IDS;
        String desc;
        Map<String, String> qualityMap;
        int charges;
        Integer a;
        String bString;
        BigDecimal cost;
        String cString;
        StringBuilder title = new StringBuilder(50);
        title.append(OutputNameFormatting.piString(equip, false));
        if (!equip.longName().equals(equip.getName())) {
            title.append("(").append(equip.longName()).append(")");
        }
        HtmlInfoBuilder b = new HtmlInfoBuilder(null, false);
        File icon = equip.getIcon();
        if (icon != null) {
            b.appendIconElement(icon.toURI().toString());
        }
        b.appendTitleElement(title.toString());
        b.appendLineBreak();
        String baseName = equip.getBaseItemName();
        if (StringUtils.isNotEmpty(baseName) && !baseName.equals(equip.getName())) {
            b.appendI18nElement("in_igInfoLabelTextBaseItem", baseName);
            b.appendLineBreak();
        }
        b.appendI18nElement("in_igInfoLabelTextType", StringUtil.join(equip.getTrueTypeList(true), (String)". "));
        this.appendFacts(b, equip);
        if (equip.isWeapon() || equip.get(ObjectKey.WIELD) != null) {
            b.appendLineBreak();
            WieldCategory wCat = equip.getEffectiveWieldCategory(this.pc);
            if (wCat != null) {
                b.appendI18nElement("in_igInfoLabelTextWield", wCat.getDisplayName());
            }
        }
        if (equip.isWeapon() || equip.isArmor() || equip.isShield()) {
            b.appendLineBreak();
            String value = this.pc.isProficientWith(equip) && equip.meetsPreReqs(this.pc) ? LanguageBundle.getString("in_igInfoLabelTextYes") : SettingsHandler.getPrereqFailColorAsHtmlStart() + LanguageBundle.getString("in_igInfoLabelTextNo") + SettingsHandler.getPrereqFailColorAsHtmlEnd();
            b.appendI18nElement("in_igInfoLabelTextProficient", value);
        }
        if ((cString = PrerequisiteUtilities.preReqHTMLStringsForList(this.pc, null, equip.getPrerequisiteList(), false)).length() > 0) {
            b.appendLineBreak();
            b.appendI18nElement("in_igInfoLabelTextReq", cString);
        }
        if ((cost = equip.getCost(this.pc)) != BigDecimal.ZERO) {
            b.appendLineBreak();
            b.appendI18nElement("in_igEqModelColCost", COST_FMT.format(cost.doubleValue()));
            b.append(" ");
            b.append(SettingsHandler.getGame().getCurrencyDisplay());
        }
        if ((bString = Globals.getGameModeUnitSet().displayWeightInUnitSet(equip.getWeight(this.pc).doubleValue())).length() > 0) {
            b.appendLineBreak();
            bString = bString + Globals.getGameModeUnitSet().getWeightUnit();
            b.appendI18nElement("in_igInfoLabelTextWeight", bString);
        }
        if ((a = equip.getMaxDex(this.pc)) != 100) {
            b.appendSpacer();
            b.appendI18nElement("in_igInfoLabelTextMaxDex", a.toString());
        }
        a = equip.acCheck(this.pc);
        if (equip.isArmor() || equip.isShield() || a != 0) {
            b.appendSpacer();
            b.appendI18nElement("in_igInfoLabelTextAcCheck", a.toString());
        }
        if (SettingsHandler.getGame().getACText().length() != 0) {
            a = equip.getACBonus(this.pc);
            if (equip.isArmor() || equip.isShield() || a != 0) {
                b.appendSpacer();
                b.appendElement(LanguageBundle.getFormattedString("in_igInfoLabelTextAcBonus", SettingsHandler.getGame().getACText()), a.toString());
            }
        }
        if (SettingsHandler.getGame().getTabShown(Tab.SPELLS)) {
            a = equip.spellFailure(this.pc);
            if (equip.isArmor() || equip.isShield() || a != 0) {
                b.appendSpacer();
                b.appendI18nElement("in_igInfoLabelTextArcaneFailure", a.toString());
            }
        }
        if ((bString = SettingsHandler.getGame().getDamageResistanceText()).length() != 0) {
            a = equip.eDR(this.pc);
            if (equip.isArmor() || equip.isShield() || a != 0) {
                b.appendSpacer();
                b.appendElement(bString, a.toString());
            }
        }
        if ((bString = equip.moveString()).length() > 0) {
            b.appendSpacer();
            b.appendI18nElement("in_igInfoLabelTextMove", bString);
        }
        if ((bString = equip.getSize()).length() > 0) {
            b.appendSpacer();
            b.appendI18nElement("in_igInfoLabelTextSize", bString);
        }
        if ((bString = equip.getDamage(this.pc)).length() > 0) {
            if (equip.isDouble()) {
                bString = bString + "/" + equip.getAltDamage(this.pc);
            }
            b.appendLineBreak();
            b.appendI18nElement("in_igInfoLabelTextDamage", bString);
        }
        int critrange = this.pc.getCritRange(equip, true);
        int altcritrange = this.pc.getCritRange(equip, false);
        String string = bString = critrange == 0 ? EMPTY_STRING : Integer.toString(critrange);
        if (equip.isDouble() && critrange != altcritrange) {
            bString = bString + "/" + (altcritrange == 0 ? EMPTY_STRING : Integer.toString(altcritrange));
        }
        if (bString.length() > 0) {
            b.appendSpacer();
            b.appendI18nElement("in_ieInfoLabelTextCritRange", bString);
        }
        bString = equip.getCritMult();
        if (equip.isDouble() && equip.getCritMultiplier() != equip.getAltCritMultiplier()) {
            bString = bString + "/" + equip.getAltCritMult();
        }
        if (bString.length() > 0) {
            b.appendSpacer();
            b.appendI18nElement("in_igInfoLabelTextCritMult", bString);
        }
        if (equip.isWeapon() && (bString = Globals.getGameModeUnitSet().displayDistanceInUnitSet(equip.getRange(this.pc).intValue())).length() > 0) {
            b.appendSpacer();
            b.appendI18nElement("in_igInfoLabelTextRange", bString + Globals.getGameModeUnitSet().getDistanceUnit());
        }
        if ((bString = equip.getContainerCapacityString()).length() > 0) {
            b.appendLineBreak();
            b.appendI18nElement("in_igInfoLabelTextContainer", bString);
        }
        if ((bString = equip.getContainerContentsString()).length() > 0) {
            b.appendSpacer();
            b.appendI18nElement("in_igInfoLabelTextCurrentlyContains", bString);
        }
        if ((charges = equip.getRemainingCharges()) >= 0) {
            b.appendLineBreak();
            b.appendI18nElement("in_igInfoLabelTextCharges", Integer.valueOf(charges).toString());
        }
        if ((qualityMap = equip.getMapFor(MapKey.QUALITY)) != null && !qualityMap.isEmpty()) {
            TreeSet<String> qualities = new TreeSet<String>();
            for (Map.Entry<String, String> me : qualityMap.entrySet()) {
                qualities.add(new StringBuilder(50).append(me.getKey()).append(": ").append(me.getValue()).toString());
            }
            b.appendLineBreak();
            b.appendI18nElement("in_igInfoLabelTextQualities", StringUtil.join(qualities, (String)", "));
        }
        if ((desc = this.pc.getDescription(equip)).length() > 0) {
            b.appendLineBreak();
            b.appendI18nFormattedElement("in_InfoDescription", DescriptionFormatting.piWrapDesc(equip, desc, false));
        }
        if ((IDS = equip.getInterestingDisplayString(this.pc)).length() > 0) {
            b.appendLineBreak();
            b.appendI18nElement("in_igInfoLabelTextProp", IDS);
        }
        if ((note = equip.getNote()).length() > 0) {
            b.appendLineBreak();
            b.appendI18nElement("in_igInfoLabelTextNote", note);
        }
        return b;
    }

    @Override
    public String getHTMLInfo(EquipModFacade equipModFacade, EquipmentFacade equipFacade) {
        String bString;
        String cString;
        String desc;
        Formula cost;
        Formula baseCost;
        if (equipModFacade == null || !(equipModFacade instanceof EquipmentModifier) || equipFacade == null || !(equipFacade instanceof Equipment)) {
            return EMPTY_STRING;
        }
        EquipmentModifier equipMod = (EquipmentModifier)equipModFacade;
        Equipment equip = (Equipment)equipFacade;
        StringBuilder title = new StringBuilder(50);
        title.append(OutputNameFormatting.piString(equipMod, false));
        HtmlInfoBuilder b = new HtmlInfoBuilder(null, false);
        b.appendTitleElement(title.toString());
        b.appendLineBreak();
        b.appendI18nElement("in_igInfoLabelTextType", StringUtil.join(equipMod.getTrueTypeList(true), (String)". "));
        int iPlus = equipMod.getSafe(IntegerKey.PLUS);
        if (iPlus != 0) {
            b.appendLineBreak();
            b.appendI18nElement("in_igInfoLabelTextPlus", String.valueOf(iPlus));
        }
        if (!"0".equals((baseCost = equipMod.getSafe(FormulaKey.BASECOST)).toString())) {
            b.appendLineBreak();
            b.appendI18nElement("in_igInfoLabelTextPrecost", String.valueOf(baseCost));
        }
        if (!"0".equals((cost = equipMod.getSafe(FormulaKey.COST)).toString())) {
            b.appendLineBreak();
            b.appendI18nElement("in_igEqModelColCost", String.valueOf(cost));
        }
        if ((desc = this.pc.getDescription(equipMod)).length() > 0) {
            b.appendLineBreak();
            b.appendI18nFormattedElement("in_InfoDescription", DescriptionFormatting.piWrapDesc(equipMod, desc, false));
        }
        StringBuilder sb = new StringBuilder(100);
        boolean first = true;
        for (SpecialProperty sp : equipMod.getSafeListFor(ListKey.SPECIAL_PROPERTIES)) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append(sp.getDisplayName());
        }
        if (sb.length() > 0) {
            b.appendLineBreak();
            b.appendI18nElement("in_igInfoLabelTextSprop", sb.toString());
        }
        if ((cString = PrerequisiteUtilities.preReqHTMLStringsForList(this.pc, equip, equipMod.getPrerequisiteList(), false)).length() > 0) {
            b.appendLineBreak();
            b.appendI18nElement("in_igInfoLabelTextReq", cString);
        }
        if ((bString = equipMod.getSource()).length() > 0) {
            b.appendLineBreak();
            b.appendI18nElement("in_igInfoLabelTextSource", bString);
        }
        b.appendLineBreak();
        return b.toString();
    }

    protected String getCostValue(EquipmentModifier equipMod) {
        Formula cost;
        Formula baseCost;
        int iPlus = equipMod.getSafe(IntegerKey.PLUS);
        StringBuilder eCost = new StringBuilder(20);
        if (iPlus != 0) {
            eCost.append("Plus:").append(iPlus);
        }
        if (!"0".equals((baseCost = equipMod.getSafe(FormulaKey.BASECOST)).toString())) {
            if (eCost.length() != 0) {
                eCost.append(", ");
            }
            eCost.append("Precost:").append(baseCost);
        }
        if (!"0".equals((cost = equipMod.getSafe(FormulaKey.BASECOST)).toString())) {
            if (eCost.length() != 0) {
                eCost.append(", ");
            }
            eCost.append("Cost:").append(cost);
        }
        String sRet = eCost.toString();
        return sRet;
    }

    @Override
    public String getHTMLInfo(TemplateFacade templateFacade) {
        String aString;
        if (templateFacade == null) {
            return EMPTY_STRING;
        }
        PCTemplate template = (PCTemplate)templateFacade;
        HtmlInfoBuilder infoText = new HtmlInfoBuilder();
        infoText.appendTitleElement(OutputNameFormatting.piString(template, false));
        this.appendFacts(infoText, template);
        RaceType rt = template.get(ObjectKey.RACETYPE);
        if (rt != null) {
            infoText.appendLineBreak();
            infoText.appendI18nElement("in_irInfoRaceType", rt.toString());
        }
        if (template.getType().length() > 0) {
            infoText.appendSpacer();
            infoText.appendI18nElement("in_irInfoType", template.getType());
        }
        if ((aString = this.pc.getDescription(template)).length() != 0) {
            infoText.appendLineBreak();
            infoText.appendI18nFormattedElement("in_InfoDescription", aString);
        }
        if ((aString = TemplateModifier.modifierString(template, this.pc)).length() > 0) {
            infoText.appendLineBreak();
            infoText.appendI18nElement("in_modifier", aString);
        }
        if ((aString = PrerequisiteUtilities.preReqHTMLStringsForList(this.pc, null, template.getPrerequisiteList(), false)).length() > 0) {
            infoText.appendLineBreak();
            infoText.appendI18nElement("in_requirements", aString);
        }
        if ((aString = template.getSource()).length() > 0) {
            infoText.appendLineBreak();
            infoText.appendI18nElement("in_sourceLabel", aString);
        }
        return infoText.toString();
    }

    @Override
    public String getHTMLInfo(KitFacade kitFacade) {
        String desc;
        if (kitFacade == null) {
            return EMPTY_STRING;
        }
        Kit kit = (Kit)kitFacade;
        HtmlInfoBuilder infoText = new HtmlInfoBuilder();
        infoText.appendTitleElement(OutputNameFormatting.piString(kit, false));
        this.appendFacts(infoText, kit);
        String aString = PrerequisiteUtilities.preReqHTMLStringsForList(this.pc, null, kit.getPrerequisiteList(), false);
        if (aString.length() > 0) {
            infoText.appendLineBreak();
            infoText.appendI18nElement("in_requirements", aString);
        }
        ArrayList<BaseKit> sortedObjects = new ArrayList<BaseKit>();
        sortedObjects.addAll(kit.getSafeListFor(ListKey.KIT_TASKS));
        Collections.sort(sortedObjects, new ObjectTypeComparator());
        String lastObjectName = EMPTY_STRING;
        for (BaseKit bk : sortedObjects) {
            String objName = bk.getObjectName();
            if (!objName.equals(lastObjectName)) {
                if (!EMPTY_STRING.equals(lastObjectName)) {
                    infoText.append("; ");
                } else {
                    infoText.appendLineBreak();
                }
                infoText.append("  <b>" + objName + "</b>: ");
                lastObjectName = objName;
            } else {
                infoText.append(", ");
            }
            infoText.append(bk.toString());
        }
        BigDecimal totalCost = kit.getTotalCost(this.pc);
        if (totalCost != null) {
            infoText.appendLineBreak();
            infoText.appendI18nFormattedElement("in_kitInfo_TotalCost", COST_FMT.format(totalCost), SettingsHandler.getGame().getCurrencyDisplay());
        }
        if ((desc = this.pc.getDescription(kit)).length() > 0) {
            infoText.appendLineBreak();
            infoText.appendI18nFormattedElement("in_InfoDescription", DescriptionFormatting.piWrapDesc(kit, desc, false));
        }
        if ((aString = kit.getSource()).length() > 0) {
            infoText.appendLineBreak();
            infoText.appendI18nElement("in_sourceLabel", aString);
        }
        return infoText.toString();
    }

    @Override
    public String getHTMLInfo(TempBonusFacade tempBonusFacade) {
        String aString;
        HtmlInfoBuilder infoText;
        if (tempBonusFacade == null) {
            return EMPTY_STRING;
        }
        if (!(tempBonusFacade instanceof TempBonusFacadeImpl)) {
            HtmlInfoBuilder infoText2 = new HtmlInfoBuilder();
            infoText2.appendTitleElement(tempBonusFacade.toString());
            return infoText2.toString();
        }
        TempBonusFacadeImpl tempBonus = (TempBonusFacadeImpl)tempBonusFacade;
        CDOMObject originObj = tempBonus.getOriginObj();
        if (originObj instanceof Equipment) {
            infoText = this.getEquipmentHtmlInfo((Equipment)originObj);
        } else {
            infoText = new HtmlInfoBuilder();
            infoText.appendTitleElement(OutputNameFormatting.piString(originObj, false));
            infoText.append(" (").append(tempBonus.getOriginType()).append(")");
        }
        if (tempBonus.getTarget() != null) {
            String targetName = this.charDisplay.getName();
            if (tempBonus.getTarget() instanceof CDOMObject) {
                targetName = ((CDOMObject)tempBonus.getTarget()).getKeyName();
            }
            infoText.appendLineBreak();
            infoText.appendI18nElement("in_itmInfoLabelTextTarget", targetName);
            StringBuilder bonusValues = new StringBuilder(100);
            Map<BonusObj, BonusManager.TempBonusInfo> bonusMap = this.pc.getTempBonusMap(originObj.getKeyName(), targetName);
            boolean first = true;
            ArrayList<BonusObj> bonusList = new ArrayList<BonusObj>(bonusMap.keySet());
            Collections.sort(bonusList, new BonusComparator());
            for (BonusObj bonusObj : bonusList) {
                if (!first) {
                    bonusValues.append(", ");
                }
                first = false;
                String adj = ADJ_FMT.format(bonusObj.resolve(this.pc, EMPTY_STRING));
                bonusValues.append(adj + " " + bonusObj.getDescription());
            }
            if (bonusValues.length() > 0) {
                infoText.appendLineBreak();
                infoText.appendI18nElement("in_itmInfoLabelTextEffect", bonusValues.toString());
            }
        }
        if (originObj instanceof Spell) {
            Spell aSpell = (Spell)originObj;
            infoText.appendLineBreak();
            infoText.appendI18nElement("in_spellDuration", aSpell.getListAsString(ListKey.DURATION));
            infoText.appendSpacer();
            infoText.appendI18nElement("in_spellRange", aSpell.getListAsString(ListKey.RANGE));
            infoText.appendSpacer();
            infoText.appendI18nElement("in_spellTarget", aSpell.getSafe(StringKey.TARGET_AREA));
        }
        if (StringUtils.isEmpty(aString = originObj.getSafe(StringKey.TEMP_DESCRIPTION)) && originObj instanceof Spell) {
            Spell sp = (Spell)originObj;
            aString = DescriptionFormatting.piWrapDesc(sp, this.pc.getDescription(sp), false);
        } else if (StringUtils.isEmpty(aString) && originObj instanceof Ability) {
            Ability ab = (Ability)originObj;
            List<CNAbility> wrappedAbility = Collections.singletonList(CNAbilityFactory.getCNAbility(ab.getCDOMCategory(), Nature.NORMAL, ab));
            aString = DescriptionFormatting.piWrapDesc(ab, this.pc.getDescription(wrappedAbility), false);
        }
        if (aString.length() > 0) {
            infoText.appendLineBreak();
            infoText.appendI18nElement("in_itmInfoLabelTextDesc", aString);
        }
        if ((aString = PrerequisiteUtilities.preReqHTMLStringsForList(this.pc, null, originObj.getPrerequisiteList(), false)).length() > 0) {
            infoText.appendLineBreak();
            infoText.appendI18nElement("in_requirements", aString);
        }
        infoText.appendLineBreak();
        infoText.appendI18nElement("in_itmInfoLabelTextSource", SourceFormat.getFormattedString(originObj, Globals.getSourceDisplay(), true));
        return infoText.toString();
    }

    @Override
    public String getHTMLInfo(InfoFacade facade) {
        if (facade == null) {
            return EMPTY_STRING;
        }
        if (facade instanceof AbilityFacade) {
            return this.getHTMLInfo((AbilityFacade)facade);
        }
        if (facade instanceof ClassFacade) {
            return this.getHTMLInfo((ClassFacade)facade, null);
        }
        if (facade instanceof DeityFacade) {
            return this.getHTMLInfo((DeityFacade)facade);
        }
        if (facade instanceof DomainFacade) {
            return this.getHTMLInfo((DomainFacade)facade);
        }
        if (facade instanceof EquipmentFacade) {
            return this.getHTMLInfo((EquipmentFacade)facade);
        }
        if (facade instanceof KitFacade) {
            return this.getHTMLInfo((KitFacade)facade);
        }
        if (facade instanceof RaceFacade) {
            return this.getHTMLInfo((RaceFacade)facade);
        }
        if (facade instanceof SkillFacade) {
            return this.getHTMLInfo((SkillFacade)facade);
        }
        if (facade instanceof SpellFacade) {
            return this.getHTMLInfo((SpellFacade)facade);
        }
        if (facade instanceof TempBonusFacade) {
            return this.getHTMLInfo((TempBonusFacade)facade);
        }
        if (facade instanceof TemplateFacade) {
            return this.getHTMLInfo((TemplateFacade)facade);
        }
        HtmlInfoBuilder infoText = new HtmlInfoBuilder();
        infoText.appendTitleElement(facade.toString());
        infoText.appendLineBreak();
        if (facade.getType().length() > 0) {
            infoText.appendI18nElement("in_irInfoType", facade.getType());
            infoText.appendLineBreak();
        }
        infoText.appendI18nElement("in_itmInfoLabelTextSource", facade.getSource());
        return infoText.toString();
    }

    @Override
    public String getLevelAdjustment(RaceFacade raceFacade) {
        if (!(raceFacade instanceof Race)) {
            return EMPTY_STRING;
        }
        Race race = (Race)raceFacade;
        return ADJ_FMT.format(race.getSafe(FormulaKey.LEVEL_ADJUSTMENT).resolve(this.pc, EMPTY_STRING));
    }

    @Override
    public int getNumMonsterClassLevels(RaceFacade raceFacade) {
        if (!(raceFacade instanceof Race)) {
            return 0;
        }
        Race race = (Race)raceFacade;
        LevelCommandFactory levelCommandFactory = race.get(ObjectKey.MONSTER_CLASS);
        if (levelCommandFactory == null) {
            return 0;
        }
        return levelCommandFactory.getLevelCount().resolve(this.pc, EMPTY_STRING).intValue();
    }

    @Override
    public String getPreReqHTML(RaceFacade race) {
        if (!(race instanceof Race)) {
            return EMPTY_STRING;
        }
        return PrerequisiteUtilities.preReqHTMLStringsForList(this.pc, null, ((Race)race).getPrerequisiteList(), true);
    }

    @Override
    public String getStatAdjustments(RaceFacade raceFacade) {
        if (!(raceFacade instanceof Race)) {
            return EMPTY_STRING;
        }
        Race race = (Race)raceFacade;
        StringBuilder retString = new StringBuilder(100);
        for (PCStat stat : this.charDisplay.getStatSet()) {
            if (this.charDisplay.isNonAbility(stat)) {
                if (retString.length() > 0) {
                    retString.append(' ');
                }
                retString.append(stat.getKeyName() + ":Nonability");
                continue;
            }
            if (BonusCalc.getStatMod(race, stat, this.pc) == 0) continue;
            if (retString.length() > 0) {
                retString.append(' ');
            }
            retString.append(stat.getKeyName() + ":" + BonusCalc.getStatMod(race, stat, this.pc));
        }
        return retString.toString();
    }

    @Override
    public String getVision(RaceFacade race) {
        if (!(race instanceof Race)) {
            return EMPTY_STRING;
        }
        return VisionDisplay.getVision(this.pc, (Race)race);
    }

    @Override
    public float getCost(EquipmentFacade equipment) {
        if (equipment instanceof Equipment) {
            return ((Equipment)equipment).getCost(this.pc).floatValue();
        }
        return 0.0f;
    }

    @Override
    public float getWeight(EquipmentFacade equipment) {
        if (equipment instanceof Equipment) {
            Float weight = ((Equipment)equipment).getWeight(this.pc);
            return (float)Globals.getGameModeUnitSet().convertWeightToUnitSet(weight.floatValue());
        }
        return 0.0f;
    }

    @Override
    public String getLevelAdjustment(TemplateFacade templateFacade) {
        if (!(templateFacade instanceof PCTemplate)) {
            return EMPTY_STRING;
        }
        PCTemplate template = (PCTemplate)templateFacade;
        return ADJ_FMT.format(template.getSafe(FormulaKey.LEVEL_ADJUSTMENT).resolve(this.pc, EMPTY_STRING));
    }

    @Override
    public String getModifier(TemplateFacade templateFacade) {
        if (!(templateFacade instanceof PCTemplate)) {
            return EMPTY_STRING;
        }
        PCTemplate template = (PCTemplate)templateFacade;
        return TemplateModifier.modifierString(template, this.pc);
    }

    @Override
    public String getPreReqHTML(TemplateFacade template) {
        if (!(template instanceof PCTemplate)) {
            return EMPTY_STRING;
        }
        return PrerequisiteUtilities.preReqHTMLStringsForList(this.pc, null, ((PCTemplate)template).getPrerequisiteList(), true);
    }

    @Override
    public String getHTMLInfo(SpellFacade spell) {
        String spellDescriptor;
        String domainlevels;
        if (spell == null || !(spell instanceof SpellFacadeImplem)) {
            return EMPTY_STRING;
        }
        SpellFacadeImplem sfi = (SpellFacadeImplem)spell;
        CharacterSpell cs = sfi.getCharSpell();
        SpellInfo si = sfi.getSpellInfo();
        Spell aSpell = cs.getSpell();
        if (aSpell == null) {
            return EMPTY_STRING;
        }
        HtmlInfoBuilder b = new HtmlInfoBuilder(OutputNameFormatting.piString(aSpell, false));
        if (si != null) {
            String addString = si.toString();
            if (addString.length() > 0) {
                b.append(" ").append(addString);
            }
            b.appendLineBreak();
            b.appendI18nElement("InfoSpells.level.title", Integer.toString(si.getOriginalLevel()));
        }
        b.appendLineBreak();
        String classlevels = aSpell.getListAsString(ListKey.SPELL_CLASSLEVEL);
        if (StringUtils.isNotEmpty(classlevels)) {
            b.appendI18nElement("in_clClass", classlevels);
            b.appendLineBreak();
        }
        if (StringUtils.isNotEmpty(domainlevels = aSpell.getListAsString(ListKey.SPELL_DOMAINLEVEL))) {
            b.appendI18nElement("in_domains", domainlevels);
            b.appendLineBreak();
        }
        b.appendI18nElement("in_spellSchool", aSpell.getListAsString(ListKey.SPELL_SCHOOL));
        String subSchool = aSpell.getListAsString(ListKey.SPELL_SUBSCHOOL);
        if (StringUtils.isNotEmpty(subSchool)) {
            b.append(" (").append(subSchool).append(")");
        }
        if (StringUtils.isNotEmpty(spellDescriptor = aSpell.getListAsString(ListKey.SPELL_DESCRIPTOR))) {
            b.append(" [").append(spellDescriptor).append("]");
        }
        b.appendLineBreak();
        this.appendFacts(b, aSpell);
        b.appendLineBreak();
        b.appendI18nElement("in_spellComponents", aSpell.getListAsString(ListKey.COMPONENTS));
        b.appendLineBreak();
        b.appendI18nElement("in_spellCastTime", aSpell.getListAsString(ListKey.CASTTIME));
        b.appendLineBreak();
        b.appendI18nElement("in_spellDuration", this.pc.parseSpellString(cs, aSpell.getListAsString(ListKey.DURATION)));
        b.appendLineBreak();
        b.appendI18nElement("in_spellRange", this.pc.getSpellRange(cs, si));
        b.appendSpacer();
        b.appendI18nElement("in_spellTarget", this.pc.parseSpellString(cs, aSpell.getSafe(StringKey.TARGET_AREA)));
        b.appendLineBreak();
        b.appendI18nElement("in_spellSavingThrow", aSpell.getListAsString(ListKey.SAVE_INFO));
        b.appendSpacer();
        b.appendI18nElement("in_spellSpellResist", aSpell.getListAsString(ListKey.SPELL_RESISTANCE));
        b.appendLineBreak();
        if (Globals.hasSpellPPCost()) {
            b.appendI18nElement("InfoSpellsSubTab.PPCost", String.valueOf(aSpell.getSafe(IntegerKey.PP_COST)));
            b.appendLineBreak();
        }
        b.appendLineBreak();
        b.appendI18nElement("in_descrip", this.pc.parseSpellString(cs, this.pc.getDescription(aSpell)));
        String cString = PrerequisiteUtilities.preReqHTMLStringsForList(this.pc, null, aSpell.getPrerequisiteList(), false);
        if (cString.length() > 0) {
            b.appendLineBreak();
            b.appendI18nElement("in_requirements", cString);
        }
        b.appendLineBreak();
        String spellSource = SourceFormat.getFormattedString(aSpell, Globals.getSourceDisplay(), true);
        if (spellSource.length() > 0) {
            b.appendLineBreak();
            b.appendI18nElement("in_source", spellSource);
        }
        return b.toString();
    }

    @Override
    public String getSpellBookInfo(String name) {
        SpellBook book = this.charDisplay.getSpellBookByName(name);
        if (book == null) {
            return EMPTY_STRING;
        }
        switch (book.getType()) {
            case 2: {
                return this.produceSpellListInfo(book);
            }
            case 3: {
                return this.produceSpellBookInfo(book);
            }
        }
        return EMPTY_STRING;
    }

    private String produceSpellListInfo(SpellBook spelllist) {
        HtmlInfoBuilder b = new HtmlInfoBuilder(spelllist.getName());
        b.append(" (");
        b.append(spelllist.getTypeName());
        b.append(")");
        b.appendLineBreak();
        if (spelllist.getDescription() != null) {
            b.appendI18nElement("in_descrip", spelllist.getDescription());
            b.appendLineBreak();
        }
        for (PCClass pcClass : this.charDisplay.getClassSet()) {
            int i;
            TreeMap<Integer, Integer> spellCountMap = new TreeMap<Integer, Integer>();
            int highestSpellLevel = -1;
            Collection<? extends CharacterSpell> sp = this.charDisplay.getCharacterSpells(pcClass);
            ArrayList<CharacterSpell> classSpells = new ArrayList<CharacterSpell>(sp);
            this.pc.addBonusKnownSpellsToList(pcClass, classSpells);
            for (CharacterSpell charSpell : classSpells) {
                for (SpellInfo spellInfo : charSpell.getInfoList()) {
                    if (!spelllist.getName().equals(spellInfo.getBook())) continue;
                    int level = spellInfo.getActualLevel();
                    int count = spellCountMap.containsKey(level) ? (Integer)spellCountMap.get(level) : 0;
                    spellCountMap.put(level, count += spellInfo.getTimes());
                    if (level <= highestSpellLevel) continue;
                    highestSpellLevel = level;
                }
            }
            if (spellCountMap.isEmpty()) continue;
            b.append("<table border=1><tr><td><font size=-1><b>");
            b.append(OutputNameFormatting.piString(pcClass, false));
            b.append("</b></font></td>");
            for (i = 0; i <= highestSpellLevel; ++i) {
                b.append("<td><font size=-2><b><center>&nbsp;");
                b.append(String.valueOf(i));
                b.append("&nbsp;</b></center></font></td>");
            }
            b.append("</tr>");
            b.append("<tr><td><font size=-1><b>Prepared</b></font></td>");
            for (i = 0; i <= highestSpellLevel; ++i) {
                b.append("<td><font size=-1><center>");
                b.append(String.valueOf(spellCountMap.get(i) == null ? 0 : (Integer)spellCountMap.get(i)));
                b.append("</center></font></td>");
            }
            b.append("</tr></table>");
            b.appendLineBreak();
        }
        return b.toString();
    }

    private String produceSpellBookInfo(SpellBook book) {
        HtmlInfoBuilder b = new HtmlInfoBuilder(book.getName());
        b.append(" (");
        b.append(book.getTypeName());
        if (book.getName().equals(this.charDisplay.getSpellBookNameToAutoAddKnown())) {
            b.append(TWO_SPACES).append(BOLD);
            b.append(LanguageBundle.getString("InfoSpellsSubTab.DefaultKnownBook")).append(END_BOLD);
        }
        b.append(")");
        b.appendLineBreak();
        b.append(LanguageBundle.getFormattedString("InfoSpells.html.spellbook.details", book.getNumPages(), book.getNumPagesUsed(), book.getPageFormula(), book.getNumSpells()));
        if (book.getDescription() != null) {
            b.appendLineBreak();
            b.appendI18nElement("in_descrip", book.getDescription());
        }
        return b.toString();
    }

    @Override
    public String getDescription(AbilityFacade ability) {
        if (ability == null || !(ability instanceof Ability)) {
            return EMPTY_STRING;
        }
        try {
            Ability a = (Ability)ability;
            List<CNAbility> wrappedAbility = this.getWrappedAbility(a);
            return DescriptionFormatting.piWrapDesc(a, this.pc.getDescription(wrappedAbility), false);
        }
        catch (Exception e) {
            Logging.errorPrint("Failed to get description for " + ability, e);
            return EMPTY_STRING;
        }
    }

    @Override
    public String getDescription(RaceFacade raceFacade) {
        if (raceFacade == null || !(raceFacade instanceof Race)) {
            return EMPTY_STRING;
        }
        try {
            Race race = (Race)raceFacade;
            return DescriptionFormatting.piWrapDesc(race, this.pc.getDescription(race), false);
        }
        catch (Exception e) {
            Logging.errorPrint("Failed to get description for " + raceFacade, e);
            return EMPTY_STRING;
        }
    }

    @Override
    public String getDescription(TemplateFacade templateFacade) {
        if (templateFacade == null || !(templateFacade instanceof PCTemplate)) {
            return EMPTY_STRING;
        }
        try {
            PCTemplate template = (PCTemplate)templateFacade;
            return DescriptionFormatting.piWrapDesc(template, this.pc.getDescription(template), false);
        }
        catch (Exception e) {
            Logging.errorPrint("Failed to get description for " + templateFacade, e);
            return EMPTY_STRING;
        }
    }

    @Override
    public String getDescription(ClassFacade classFacade) {
        if (classFacade == null || !(classFacade instanceof PCClass)) {
            return EMPTY_STRING;
        }
        try {
            PCClass pcClass = (PCClass)classFacade;
            return DescriptionFormatting.piWrapDesc(pcClass, this.pc.getDescription(pcClass), false);
        }
        catch (Exception e) {
            Logging.errorPrint("Failed to get description for " + classFacade, e);
            return EMPTY_STRING;
        }
    }

    @Override
    public String getDescription(SkillFacade skillFacade) {
        if (skillFacade == null || !(skillFacade instanceof Skill)) {
            return EMPTY_STRING;
        }
        try {
            Skill skill = (Skill)skillFacade;
            return DescriptionFormatting.piWrapDesc(skill, this.pc.getDescription(skill), false);
        }
        catch (Exception e) {
            Logging.errorPrint("Failed to get description for " + skillFacade, e);
            return EMPTY_STRING;
        }
    }

    @Override
    public String getDescription(EquipmentFacade equipFacade) {
        if (equipFacade == null || !(equipFacade instanceof Equipment)) {
            return EMPTY_STRING;
        }
        try {
            Equipment equip = (Equipment)equipFacade;
            return DescriptionFormatting.piWrapDesc(equip, this.pc.getDescription(equip), false);
        }
        catch (Exception e) {
            Logging.errorPrint("Failed to get description for " + equipFacade, e);
            return EMPTY_STRING;
        }
    }

    @Override
    public String getDescription(KitFacade kitFacade) {
        if (kitFacade == null || !(kitFacade instanceof Kit)) {
            return EMPTY_STRING;
        }
        try {
            Kit kit = (Kit)kitFacade;
            return DescriptionFormatting.piWrapDesc(kit, this.pc.getDescription(kit), false);
        }
        catch (Exception e) {
            Logging.errorPrint("Failed to get description for " + kitFacade, e);
            return EMPTY_STRING;
        }
    }

    @Override
    public String getDescription(DeityFacade deityFacade) {
        if (deityFacade == null || !(deityFacade instanceof Deity)) {
            return EMPTY_STRING;
        }
        try {
            Deity deity = (Deity)deityFacade;
            return DescriptionFormatting.piWrapDesc(deity, this.pc.getDescription(deity), false);
        }
        catch (Exception e) {
            Logging.errorPrint("Failed to get description for " + deityFacade, e);
            return EMPTY_STRING;
        }
    }

    @Override
    public String getDescription(DomainFacade domainFacade) {
        if (domainFacade == null || !(domainFacade instanceof DomainFacadeImpl)) {
            return EMPTY_STRING;
        }
        try {
            DomainFacadeImpl domain = (DomainFacadeImpl)domainFacade;
            Domain dom = (Domain)domain.getRawObject();
            if (dom == null) {
                return EMPTY_STRING;
            }
            return DescriptionFormatting.piWrapDesc(dom, this.pc.getDescription(dom), false);
        }
        catch (Exception e) {
            Logging.errorPrint("Failed to get description for " + domainFacade, e);
            return EMPTY_STRING;
        }
    }

    @Override
    public String getDescription(SpellFacade spellFacade) {
        if (spellFacade == null || !(spellFacade instanceof SpellFacadeImplem)) {
            return EMPTY_STRING;
        }
        try {
            SpellFacadeImplem spell = (SpellFacadeImplem)spellFacade;
            Spell aSpell = spell.getSpell();
            if (aSpell == null) {
                return EMPTY_STRING;
            }
            return DescriptionFormatting.piWrapDesc(aSpell, this.pc.getDescription(aSpell), false);
        }
        catch (Exception e) {
            Logging.errorPrint("Failed to get description for " + spellFacade, e);
            return EMPTY_STRING;
        }
    }

    @Override
    public String getDescription(TempBonusFacade tempBonusFacade) {
        if (tempBonusFacade == null || !(tempBonusFacade instanceof TempBonusFacadeImpl)) {
            return EMPTY_STRING;
        }
        try {
            TempBonusFacadeImpl tempBonus = (TempBonusFacadeImpl)tempBonusFacade;
            CDOMObject originObj = tempBonus.getOriginObj();
            String desc = originObj.getSafe(StringKey.TEMP_DESCRIPTION);
            if (StringUtils.isEmpty(desc)) {
                if (originObj instanceof Spell) {
                    Spell sp = (Spell)originObj;
                    desc = DescriptionFormatting.piWrapDesc(sp, this.pc.getDescription(sp), false);
                } else if (originObj instanceof Ability) {
                    Ability ab = (Ability)originObj;
                    List<CNAbility> wrappedAbility = Collections.singletonList(CNAbilityFactory.getCNAbility(ab.getCDOMCategory(), Nature.NORMAL, ab));
                    desc = DescriptionFormatting.piWrapDesc(ab, this.pc.getDescription(wrappedAbility), false);
                }
            }
            return desc;
        }
        catch (Exception e) {
            Logging.errorPrint("Failed to get description for " + tempBonusFacade, e);
            return EMPTY_STRING;
        }
    }

    private List<CNAbility> getWrappedAbility(Ability a) {
        List<CNAbility> wrappedAbility = this.pc.getMatchingCNAbilities(a);
        if (wrappedAbility.isEmpty()) {
            CNAbility cna = CNAbilityFactory.getCNAbility(a.getCDOMCategory(), Nature.NORMAL, a);
            wrappedAbility.add(cna);
        }
        return wrappedAbility;
    }

    @Override
    public String getDomains(DeityFacade deityFacade) {
        if (deityFacade == null || !(deityFacade instanceof Deity)) {
            return EMPTY_STRING;
        }
        Deity deity = (Deity)deityFacade;
        TreeSet<String> set = new TreeSet<String>();
        for (CDOMReference ref : deity.getSafeListMods(Deity.DOMAINLIST)) {
            for (Domain d : ref.getContainedObjects()) {
                set.add(OutputNameFormatting.piString(d, false));
            }
        }
        StringBuilder piString = new StringBuilder(100);
        piString.append((CharSequence)StringUtil.joinToStringBuilder(set, (String)", "));
        return piString.toString();
    }

    @Override
    public String getPantheons(DeityFacade deityFacade) {
        if (deityFacade == null || !(deityFacade instanceof Deity)) {
            return EMPTY_STRING;
        }
        Deity deity = (Deity)deityFacade;
        TreeSet set = new TreeSet(String.CASE_INSENSITIVE_ORDER);
        if (deity != null) {
            FactSetKey fk = FactSetKey.valueOf("Pantheon");
            for (ObjectContainer oc : deity.getSafeSetFor(fk)) {
                set.addAll(oc.getContainedObjects());
            }
        }
        StringBuilder piString = new StringBuilder(100);
        piString.append((CharSequence)StringUtil.joinToStringBuilder(set, (String)","));
        return piString.toString();
    }

    @Override
    public String getFavoredWeapons(DeityFacade deityFacade) {
        if (deityFacade == null || !(deityFacade instanceof Deity)) {
            return EMPTY_STRING;
        }
        Deity deity = (Deity)deityFacade;
        List<CDOMReference<WeaponProf>> wpnList = deity.getSafeListFor(ListKey.DEITYWEAPON);
        return ReferenceUtilities.joinLstFormat(wpnList, ",");
    }

    @Override
    public String getChoices(AbilityFacade abilityFacade) {
        if (abilityFacade == null || !(abilityFacade instanceof Ability)) {
            return EMPTY_STRING;
        }
        Ability ability = (Ability)abilityFacade;
        StringBuilder result = new StringBuilder(100);
        List<CNAbility> targetAbilities = this.pc.getMatchingCNAbilities(ability);
        if (ability.getSafe(ObjectKey.MULTIPLE_ALLOWED).booleanValue()) {
            ChooseInformation<?> chooseInfo = ability.get(ObjectKey.CHOOSE_INFO);
            this.processAbilities(result, targetAbilities, chooseInfo);
        }
        return result.toString();
    }

    private <T> void processAbilities(StringBuilder result, Collection<CNAbility> targetAbilities, ChooseInformation<T> chooseInfo) {
        if (chooseInfo == null) {
            return;
        }
        ArrayList choices = new ArrayList();
        for (CNAbility ab : targetAbilities) {
            List<?> sel = this.pc.getDetailedAssociations(ab);
            if (sel == null) continue;
            choices.addAll(sel);
        }
        String choiceInfo = chooseInfo.composeDisplay(choices).toString();
        if (choiceInfo.length() > 0) {
            result.append(choiceInfo);
        }
    }

    @Override
    public String getTempBonusTarget(TempBonusFacade tempBonusFacade) {
        if (tempBonusFacade == null || !(tempBonusFacade instanceof TempBonusFacadeImpl)) {
            return EMPTY_STRING;
        }
        TempBonusFacadeImpl tempBonus = (TempBonusFacadeImpl)tempBonusFacade;
        HashSet<String> targetSet = new HashSet<String>();
        if (TempBonusHelper.hasCharacterTempBonus(tempBonus.getOriginObj(), this.pc)) {
            targetSet.add(LanguageBundle.getString("in_itmBonModelTargetTypeCharacter"));
        }
        if (TempBonusHelper.hasEquipmentTempBonus(tempBonus.getOriginObj(), this.pc)) {
            targetSet.addAll(TempBonusHelper.getEquipmentApplyString(tempBonus.getOriginObj(), this.pc));
        }
        StringBuilder target = new StringBuilder(40);
        for (String string : targetSet) {
            target.append(string).append(";");
        }
        if (target.length() > 0) {
            target.deleteCharAt(target.length() - 1);
        }
        return target.toString();
    }

    @Override
    public String getMovement(RaceFacade race) {
        if (!(race instanceof Race)) {
            return EMPTY_STRING;
        }
        List<Movement> movements = ((Race)race).getListFor(ListKey.BASE_MOVEMENT);
        if (movements != null && !movements.isEmpty()) {
            return movements.get(0).toString();
        }
        return EMPTY_STRING;
    }

    private void appendFacts(HtmlInfoBuilder infoText, CDOMObject cdo) {
        Class<?> cl = cdo.getClass();
        LoadContext context = Globals.getContext();
        Collection<FactDefinition> defs = context.getReferenceContext().getConstructedCDOMObjects(FactDefinition.class);
        for (FactDefinition def : defs) {
            FactKey fk;
            Indirect fact;
            if (!def.getUsableLocation().isAssignableFrom(cl) || !def.getVisibility().isVisibleTo(View.VISIBLE_DISPLAY) || (fact = cdo.get(fk = def.getFactKey())) == null) continue;
            infoText.appendSpacer();
            infoText.append(BOLD);
            infoText.append(fk.toString());
            infoText.append(":</b>&nbsp;");
            infoText.append(fact.getUnconverted());
        }
        Collection<FactSetDefinition> setdefs = context.getReferenceContext().getConstructedCDOMObjects(FactSetDefinition.class);
        for (FactSetDefinition def : setdefs) {
            FactSetKey fk;
            String s;
            if (!def.getUsableLocation().isAssignableFrom(cl) || !def.getVisibility().isVisibleTo(View.VISIBLE_DISPLAY) || (s = this.getSetString(cdo, fk = def.getFactSetKey())) == null) continue;
            infoText.appendSpacer();
            infoText.append(BOLD);
            infoText.append(fk.toString());
            infoText.append(":</b>&nbsp;");
            infoText.append(s);
        }
    }

    private <T> String getSetString(CDOMObject cdo, FactSetKey<T> fk) {
        List<ObjectContainer<T>> set = cdo.getSetFor(fk);
        if (set == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (ObjectContainer<T> oc : set) {
            if (!first) {
                sb.append(",");
            }
            sb.append(oc.getLSTformat(false));
            first = false;
        }
        return sb.toString();
    }

    private static class BonusComparator
    implements Comparator<BonusObj> {
        private BonusComparator() {
        }

        @Override
        public int compare(BonusObj bo1, BonusObj bo2) {
            String type2;
            String type1 = bo1.getTypeOfBonus();
            if (!type1.equals(type2 = bo2.getTypeOfBonus())) {
                return type1.compareTo(type2);
            }
            return bo1.getBonusInfo().compareTo(bo2.getBonusInfo());
        }
    }

    private static class ObjectTypeComparator
    implements Comparator<BaseKit> {
        private ObjectTypeComparator() {
        }

        @Override
        public int compare(BaseKit bk1, BaseKit bk2) {
            String name1 = bk1.getObjectName();
            String name2 = bk2.getObjectName();
            return name1.compareTo(name2);
        }
    }
}

