/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.converter.loader;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.StringKey;
import pcgen.core.Campaign;
import pcgen.gui2.converter.ConversionDecider;
import pcgen.gui2.converter.Loader;
import pcgen.gui2.converter.TokenConverter;
import pcgen.gui2.converter.event.TokenProcessEvent;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.CampaignSourceEntry;
import pcgen.rules.context.EditorLoadContext;
import pcgen.util.Logging;

public class BasicLoader<T extends CDOMObject>
implements Loader {
    public static final String FIELD_SEPARATOR = "\t";
    private final Class<T> cdomClass;
    private final ListKey<CampaignSourceEntry> listkey;
    private final EditorLoadContext context;
    private final Writer changeLogWriter;

    public BasicLoader(EditorLoadContext lc, Class<T> cl, ListKey<CampaignSourceEntry> lk, Writer changeLogWriter) {
        this.context = lc;
        this.cdomClass = cl;
        this.listkey = lk;
        this.changeLogWriter = changeLogWriter;
    }

    @Override
    public List<CDOMObject> process(StringBuilder sb, int line, String lineString, ConversionDecider decider) throws PersistenceLayerException, InterruptedException {
        String[] tokens = lineString.split(FIELD_SEPARATOR);
        if (tokens.length == 0) {
            return null;
        }
        String objectName = tokens[0];
        sb.append(objectName);
        ArrayList<CDOMObject> list = new ArrayList<CDOMObject>();
        for (int tok = 1; tok < tokens.length; ++tok) {
            String token = tokens[tok];
            sb.append(FIELD_SEPARATOR);
            if (token.length() == 0) continue;
            CDOMObject obj = (CDOMObject)this.context.getReferenceContext().constructCDOMObject(this.cdomClass, line + "Test" + tok + " " + token);
            obj.put(StringKey.CONVERT_NAME, tokens[0]);
            List<CDOMObject> injected = this.processToken(sb, objectName, obj, token, decider, line);
            if (injected != null) {
                list.addAll(injected);
            }
            this.context.purge(obj);
            TokenConverter.clearConstants();
        }
        return list;
    }

    private List<CDOMObject> processToken(StringBuilder sb, String objectName, CDOMObject obj, String token, ConversionDecider decider, int line) throws PersistenceLayerException, InterruptedException {
        int colonLoc = token.indexOf(58);
        if (colonLoc == -1) {
            Logging.errorPrint("Invalid Token - does not contain a colon: " + token);
            return null;
        }
        if (colonLoc == 0) {
            Logging.errorPrint("Invalid Token - starts with a colon: " + token);
            return null;
        }
        String key = token.substring(0, colonLoc);
        String value = colonLoc == token.length() - 1 ? null : token.substring(colonLoc + 1);
        TokenProcessEvent tpe = new TokenProcessEvent(this.context, decider, key, value, objectName, obj);
        String error = TokenConverter.process(tpe);
        if (tpe.isConsumed()) {
            if (!token.equals(tpe.getResult())) {
                try {
                    this.changeLogWriter.append("Line " + line + " converted '" + token + "' to '" + tpe.getResult() + "'.\n");
                }
                catch (IOException e) {
                    Logging.errorPrint("Unable to log change", e);
                }
            }
            sb.append(tpe.getResult());
        } else {
            Logging.errorPrint(error);
        }
        return tpe.getInjected();
    }

    @Override
    public List<CampaignSourceEntry> getFiles(Campaign c) {
        return c.getSafeListFor(this.listkey);
    }

    public String getLoadName() {
        return this.cdomClass.getSimpleName();
    }
}

