/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.spell;

import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.Ungranted;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.Type;
import pcgen.cdom.list.SpellList;
import pcgen.cdom.reference.CDOMDirectSingleRef;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.core.SettingsHandler;
import pcgen.facade.core.InfoFacade;
import pcgen.persistence.lst.output.prereq.PrerequisiteWriter;

public final class Spell
extends PObject
implements InfoFacade,
Ungranted {
    public static final CDOMReference<SpellList> SPELLS;

    @Override
    public String getPCCText() {
        StringBuilder txt = new StringBuilder(200);
        txt.append(this.getDisplayName());
        txt.append("\t");
        txt.append((CharSequence)StringUtil.joinToStringBuilder(Globals.getContext().unparse(this), (String)"\t"));
        txt.append("\t");
        txt.append(PrerequisiteWriter.prereqsToString(this));
        return txt.toString();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof Spell && this.getKeyName().equalsIgnoreCase(((Spell)obj).getKeyName());
    }

    public int hashCode() {
        return this.getKeyName().hashCode();
    }

    public boolean isAllowed(Type t) {
        boolean allowed = this.containsInList(ListKey.ITEM, t);
        boolean prohibited = Type.POTION.equals(t) || this.containsInList(ListKey.PROHIBITED_ITEM, t);
        return allowed || !prohibited;
    }

    @Override
    public String toString() {
        if (SettingsHandler.guiUsesOutputNameSpells()) {
            return this.getOutputName();
        }
        return this.getDisplayName();
    }

    static {
        SpellList wpl = new SpellList();
        wpl.setName("*Spells");
        SPELLS = CDOMDirectSingleRef.getRef(wpl);
    }
}

