/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.kit;

import java.util.StringTokenizer;
import pcgen.base.formula.Formula;
import pcgen.cdom.base.FormulaFactory;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.Kit;
import pcgen.core.PCStat;
import pcgen.core.kit.BaseKit;
import pcgen.core.kit.KitStat;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.DeferredToken;
import pcgen.rules.persistence.token.ParseResult;

public class StatToken
extends AbstractTokenWithSeparator<KitStat>
implements CDOMPrimaryToken<KitStat>,
DeferredToken<Kit> {
    public String getTokenName() {
        return "STAT";
    }

    public Class<KitStat> getTokenClass() {
        return KitStat.class;
    }

    protected char separator() {
        return '|';
    }

    protected ParseResult parseTokenWithSeparator(LoadContext context, KitStat kitStat, String value) {
        StringTokenizer st = new StringTokenizer(value, "|");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int equalLoc = token.indexOf(61);
            if (equalLoc == -1) {
                return new ParseResult.Fail("Illegal " + this.getTokenName() + " did not have Stat=X format: " + value, context);
            }
            if (equalLoc != token.lastIndexOf(61)) {
                return new ParseResult.Fail("Illegal " + this.getTokenName() + " had two equal signs, is not Stat=X format: " + value, context);
            }
            String statName = token.substring(0, equalLoc);
            if (statName.length() == 0) {
                return new ParseResult.Fail("Illegal " + this.getTokenName() + " had no stat, is not Stat=X format: " + value, context);
            }
            CDOMSingleRef stat = context.getReferenceContext().getCDOMReference(PCStat.class, statName);
            String formula = token.substring(equalLoc + 1);
            if (formula.length() == 0) {
                return new ParseResult.Fail("Unable to find STAT value: " + value, context);
            }
            Formula statValue = FormulaFactory.getFormulaFor((String)formula);
            if (!statValue.isValid()) {
                return new ParseResult.Fail("StatValue in " + this.getTokenName() + " was not valid: " + statValue.toString(), context);
            }
            kitStat.addStat(stat, statValue);
        }
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, KitStat kitStat) {
        String[] stringArray;
        if (kitStat.isEmpty()) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = kitStat.toString();
        }
        return stringArray;
    }

    public boolean process(LoadContext context, Kit obj) {
        for (BaseKit bk : obj.getSafeListFor(ListKey.KIT_TASKS)) {
            if (!(bk instanceof KitStat)) continue;
            obj.removeFromListFor(ListKey.KIT_TASKS, (Object)bk);
            obj.addStat((KitStat)bk);
        }
        return true;
    }

    public Class<Kit> getDeferredTokenClass() {
        return Kit.class;
    }
}

