/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.pointbuy.method;

import java.util.Collection;
import java.util.TreeSet;
import pcgen.core.PointBuyMethod;
import pcgen.core.bonus.Bonus;
import pcgen.core.bonus.BonusObj;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class BonusToken
extends AbstractNonEmptyToken<PointBuyMethod>
implements CDOMPrimaryToken<PointBuyMethod> {
    public String getTokenName() {
        return "BONUS";
    }

    protected ParseResult parseNonEmptyToken(LoadContext context, PointBuyMethod pbm, String value) {
        BonusObj bon = Bonus.newBonus((LoadContext)context, (String)value);
        if (bon == null) {
            return new ParseResult.Fail(this.getTokenName() + " was given invalid bonus: " + value, context);
        }
        bon.setTokenSource(this.getTokenName());
        pbm.addBonus(bon);
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, PointBuyMethod pbm) {
        Collection added = pbm.getBonuses();
        String tokenName = this.getTokenName();
        TreeSet<String> bonusSet = new TreeSet<String>();
        for (BonusObj bonus : added) {
            if (!tokenName.equals(bonus.getTokenSource())) continue;
            bonusSet.add(bonus.toString());
        }
        if (bonusSet.isEmpty()) {
            return null;
        }
        return bonusSet.toArray(new String[bonusSet.size()]);
    }

    public Class<PointBuyMethod> getTokenClass() {
        return PointBuyMethod.class;
    }
}

