/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.deity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.reference.CDOMGroupRef;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.Deity;
import pcgen.core.WeaponProf;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class DeityweapToken
extends AbstractTokenWithSeparator<Deity>
implements CDOMPrimaryToken<Deity> {
    private static final Class<WeaponProf> WEAPONPROF_CLASS = WeaponProf.class;

    public String getTokenName() {
        return "DEITYWEAP";
    }

    protected char separator() {
        return '|';
    }

    protected ParseResult parseTokenWithSeparator(LoadContext context, Deity deity, String value) {
        boolean first = true;
        boolean foundAny = false;
        boolean foundOther = false;
        StringTokenizer tok = new StringTokenizer(value, "|");
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if (".CLEAR".equals(token)) {
                if (!first) {
                    return new ParseResult.Fail("  Non-sensical " + this.getTokenName() + ": .CLEAR was not the first list item", context);
                }
                context.getObjectContext().removeList((CDOMObject)deity, ListKey.DEITYWEAPON);
            } else {
                CDOMGroupRef ref;
                if ("ALL".equalsIgnoreCase(token) || "ANY".equalsIgnoreCase(token)) {
                    foundAny = true;
                    ref = context.getReferenceContext().getCDOMAllReference(WEAPONPROF_CLASS);
                } else {
                    foundOther = true;
                    ref = context.getReferenceContext().getCDOMReference(WEAPONPROF_CLASS, token);
                }
                context.getObjectContext().addToList((CDOMObject)deity, ListKey.DEITYWEAPON, (Object)ref);
            }
            first = false;
        }
        if (foundAny && foundOther) {
            return new ParseResult.Fail("Non-sensical " + this.getTokenName() + ": Contains ANY and a specific reference: " + value, context);
        }
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, Deity deity) {
        Collection added;
        Changes changes = context.getObjectContext().getListChanges((CDOMObject)deity, ListKey.DEITYWEAPON);
        Collection removedItems = changes.getRemoved();
        ArrayList<String> list = new ArrayList<String>();
        if (removedItems != null && !removedItems.isEmpty()) {
            context.addWriteMessage(".CLEAR. not supported in " + this.getTokenName());
            return null;
        }
        if (changes.includesGlobalClear()) {
            list.add(".CLEAR");
        }
        if ((added = changes.getAdded()) != null && !added.isEmpty()) {
            list.add(ReferenceUtilities.joinLstFormat((Collection)added, (String)"|", (boolean)true));
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.toArray(new String[list.size()]);
    }

    public Class<Deity> getTokenClass() {
        return Deity.class;
    }
}

