/*
 * Decompiled with CFR 0.152.
 */
package plugin.encounter;

import gmgen.GMGenSystem;
import gmgen.GMGenSystemView;
import gmgen.io.ReadXML;
import gmgen.io.VectorTable;
import gmgen.plugin.Dice;
import gmgen.plugin.InitHolder;
import gmgen.plugin.InitHolderList;
import gmgen.plugin.PcgCombatant;
import gmgen.pluginmgr.messages.AddMenuItemToGMGenToolsMenuMessage;
import gmgen.pluginmgr.messages.RequestAddTabToGMGenMessage;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.ListModel;
import pcgen.base.formula.Formula;
import pcgen.cdom.base.FormulaFactory;
import pcgen.cdom.content.ChallengeRating;
import pcgen.cdom.content.LevelCommandFactory;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.inst.PCClassLevel;
import pcgen.core.Equipment;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;
import pcgen.core.SettingsHandler;
import pcgen.core.SystemCollections;
import pcgen.core.character.EquipSet;
import pcgen.core.character.EquipSlot;
import pcgen.core.display.CharacterDisplay;
import pcgen.gui2.tools.Utility;
import pcgen.pluginmgr.InteractivePlugin;
import pcgen.pluginmgr.PCGenMessage;
import pcgen.pluginmgr.PCGenMessageHandler;
import pcgen.pluginmgr.messages.FocusOrStateChangeOccurredMessage;
import pcgen.pluginmgr.messages.TransmitInitiativeValuesBetweenComponentsMessage;
import pcgen.system.LanguageBundle;
import pcgen.util.Logging;
import plugin.encounter.EncounterModel;
import plugin.encounter.EnvironmentModel;
import plugin.encounter.RaceModel;
import plugin.encounter.gui.EncounterView;

public class EncounterPlugin
implements InteractivePlugin,
ActionListener,
ItemListener,
MouseListener {
    private static final String DIR_ENCOUNTER = "encounter_tables";
    public static final String LOG_NAME = "Encounter";
    private EncounterModel theModel;
    private EncounterView theView;
    private EnvironmentModel theEnvironments;
    private InitHolderList theList;
    private JMenuItem encounterToolsItem = new JMenuItem();
    private RaceModel theRaces;
    private static final String NAME = "Encounter";
    private static final String IN_NAME = "in_plugin_encounter_name";
    private static final String IN_NAME_MN = "in_mn_plugin_encounter_name";
    private String version = "01.00.99.01.00";
    private PCGenMessageHandler messageHandler;

    public void start(PCGenMessageHandler mh) {
        this.messageHandler = mh;
        this.theModel = new EncounterModel(this.getDataDirectory() + File.separator + DIR_ENCOUNTER);
        this.theView = new EncounterView();
        this.theRaces = new RaceModel();
        this.theList = new InitHolderList();
        this.createView();
        this.messageHandler.handleMessage((PCGenMessage)new RequestAddTabToGMGenMessage((Object)this, this.getLocalizedName(), (Component)this.getView()));
        this.initMenus();
    }

    public void stop() {
        this.messageHandler = null;
    }

    public int getPriority() {
        return SettingsHandler.getGMGenOption((String)"Encounter.LoadOrder", (int)30);
    }

    public void setModel(EncounterModel theModel) {
        this.theModel = theModel;
    }

    public EncounterModel getModel() {
        return this.theModel;
    }

    public String getPluginName() {
        return "Encounter";
    }

    private String getLocalizedName() {
        return LanguageBundle.getString((String)IN_NAME);
    }

    public RaceModel getRaces() {
        return this.theRaces;
    }

    public void setView(EncounterView theView) {
        this.theView = theView;
    }

    public JPanel getView() {
        return this.theView;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.theView.getAddCreature()) {
            this.handleAddCreature();
        } else if (e.getSource() == this.theView.getRemoveCreature()) {
            this.handleRemoveCreature();
        } else if (e.getSource() == this.theView.getTransferToTracker()) {
            this.handleTransferToTracker();
        } else if (e.getSource() == this.theView.getGenerateEncounter()) {
            this.handleGenerateEncounter(this.theModel);
        } else {
            Logging.errorPrintLocalised((String)"in_plugin_encounter_error_unhandled", (Object[])new Object[]{e.getSource()});
        }
        this.updateUI();
    }

    public void handleGenerateEncounter(EncounterModel m) {
        File f = new File(this.getDataDirectory() + File.separator + DIR_ENCOUNTER + File.separator + "environments.xml");
        if (!f.exists()) {
            Logging.errorPrintLocalised((String)"in_plugin_encounter_error_missing", (Object[])new Object[]{f});
            return;
        }
        ReadXML xml = new ReadXML(f);
        VectorTable environments = xml.getTable();
        this.theModel.clear();
        if (this.theView.getEnvironment().getSelectedIndex() == 0) {
            this.generateXofYEL(this.theView.getNumberOfCreatures().getText(), this.theView.getTargetEL());
        } else {
            this.generateXfromY(environments.crossReference((Object)this.theView.getEnvironment().getSelectedItem().toString(), (Object)"File").toString());
        }
        this.updateUI();
    }

    public void handleAddCreature() {
        if (!this.theView.getLibraryCreatures().isSelectionEmpty()) {
            Object[] values = this.theView.getLibraryCreatures().getSelectedValues();
            for (int i = 0; i < values.length; ++i) {
                this.theModel.addElement(values[i]);
            }
            this.updateUI();
        }
    }

    public void handleMessage(PCGenMessage message) {
        if (message instanceof FocusOrStateChangeOccurredMessage) {
            if (this.isActive()) {
                this.updateUI();
                this.encounterToolsItem.setEnabled(false);
            } else {
                this.encounterToolsItem.setEnabled(true);
            }
        }
    }

    public boolean isActive() {
        JTabbedPane tp = Utility.getTabbedPaneFor((Component)this.theView);
        return tp != null && JOptionPane.getFrameForComponent(tp).isFocused() && tp.getSelectedComponent().equals(this.theView);
    }

    public void handleRemoveCreature() {
        if (!this.theView.getEncounterCreatures().isSelectionEmpty()) {
            Object[] values = this.theView.getEncounterCreatures().getSelectedValues();
            for (int i = 0; i < values.length; ++i) {
                this.theModel.removeElement(values[i]);
            }
            this.updateUI();
        }
    }

    public void handleTransferToTracker() {
        JFrame oldRoot = Globals.getRootFrame();
        Globals.setRootFrame((JFrame)GMGenSystem.inst);
        this.theModel.setPCs(this.theModel.size());
        try {
            for (int i = 0; i < this.theModel.size(); ++i) {
                PlayerCharacter aPC = this.theModel.getPCs()[i];
                aPC.setImporting(false);
                if (!this.handleRace(aPC, i)) continue;
                LevelCommandFactory lcf = (LevelCommandFactory)aPC.getDisplay().getRace().get(ObjectKey.MONSTER_CLASS);
                if (lcf != null) {
                    this.handleMonster(aPC, lcf);
                } else {
                    this.handleNonMonster(aPC);
                }
                this.handleEquipment(aPC);
                aPC.setPlayersName("Enemy");
                this.theList.add((InitHolder)new PcgCombatant(aPC, "Enemy", this.messageHandler));
            }
            JOptionPane.showMessageDialog(null, "You will now be returned to PCGen so that you can finalise your selected combatants.\nOnce they are finalised, return to the GMGen Initiative tab to begin the combat!", "Combatant Setup Complete", 1);
            this.messageHandler.handleMessage((PCGenMessage)new TransmitInitiativeValuesBetweenComponentsMessage((Object)this, this.theList));
            this.removeAll();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        Globals.setRootFrame((JFrame)oldRoot);
    }

    public void initMenus() {
        this.encounterToolsItem.setMnemonic(LanguageBundle.getMnemonic((String)IN_NAME_MN));
        this.encounterToolsItem.setText(this.getLocalizedName());
        this.encounterToolsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EncounterPlugin.this.toolMenuItem(evt);
            }
        });
        this.messageHandler.handleMessage((PCGenMessage)new AddMenuItemToGMGenToolsMenuMessage((Object)this, this.encounterToolsItem));
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this.theView.getEnvironment().getSelectedIndex() == 0) {
            this.theView.getNumberOfCreatures().setEnabled(true);
            this.theView.getTargetEncounterLevel().setEnabled(true);
            this.theView.getNumberLabel().setEnabled(true);
            this.theView.getTargetLabel().setEnabled(true);
        } else {
            this.theView.getNumberOfCreatures().setEnabled(false);
            this.theView.getTargetEncounterLevel().setEnabled(false);
            this.theView.getNumberLabel().setEnabled(false);
            this.theView.getTargetLabel().setEnabled(false);
        }
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
        if (evt.getSource() == this.theView.getLibraryCreatures()) {
            if (evt.getClickCount() == 2) {
                int index = this.theView.getLibraryCreatures().locationToIndex(evt.getPoint());
                ListModel dlm = this.theView.getLibraryCreatures().getModel();
                Object item = dlm.getElementAt(index);
                this.theView.getLibraryCreatures().ensureIndexIsVisible(index);
                this.theModel.addElement(item);
                this.updateUI();
            }
        } else if (evt.getSource() == this.theView.getEncounterCreatures()) {
            try {
                if (evt.getClickCount() == 2) {
                    int index = this.theView.getEncounterCreatures().locationToIndex(evt.getPoint());
                    ListModel dlm = this.theView.getEncounterCreatures().getModel();
                    Object item = dlm.getElementAt(index);
                    this.theView.getEncounterCreatures().ensureIndexIsVisible(index);
                    this.theModel.removeElement(item);
                    this.updateUI();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    private void createView() {
        this.theEnvironments = new EnvironmentModel(this.getDataDirectory() + File.separator + DIR_ENCOUNTER);
        this.theView.getLibraryCreatures().setModel(this.theRaces);
        this.theView.getEncounterCreatures().setModel(this.theModel);
        this.theView.getEnvironment().setModel(this.theEnvironments);
        this.theView.getLibraryCreatures().addMouseListener(this);
        this.theView.getEncounterCreatures().addMouseListener(this);
        this.theView.getAddCreature().addActionListener(this);
        this.theView.getRemoveCreature().addActionListener(this);
        this.theView.getTransferToTracker().addActionListener(this);
        this.theView.getGenerateEncounter().addActionListener(this);
        this.theView.getEnvironment().addItemListener(this);
    }

    public void toolMenuItem(ActionEvent evt) {
        JTabbedPane tp = GMGenSystemView.getTabPane();
        for (int i = 0; i < tp.getTabCount(); ++i) {
            if (!(tp.getComponentAt(i) instanceof EncounterView)) continue;
            tp.setSelectedIndex(i);
        }
    }

    public void updateUI() {
        int sel = this.theView.getEnvironment().getSelectedIndex();
        if (sel == -1) {
            sel = 0;
        }
        ArrayList selected = new ArrayList();
        for (int index : this.theView.getLibraryCreatures().getSelectedIndices()) {
            selected.add(this.theRaces.elementAt(index));
        }
        this.theRaces.update();
        this.theEnvironments.update();
        for (Object obj : this.theModel.toArray()) {
            if (this.theRaces.contains(obj)) continue;
            this.theModel.removeElement(obj);
        }
        this.theView.getEnvironment().setSelectedIndex(sel);
        this.theView.setTotalEncounterLevel(Integer.toString(this.theModel.getCR()));
        if (this.theRaces.getSize() > 1) {
            this.theView.getGenerateEncounter().setEnabled(true);
        } else {
            this.theView.getGenerateEncounter().setEnabled(false);
        }
        if (this.theModel.getSize() < 1) {
            this.theView.getTransferToTracker().setEnabled(false);
        } else {
            this.theView.getTransferToTracker().setEnabled(true);
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (Object obj : selected) {
            if (!this.theRaces.contains(obj)) continue;
            arrayList.add(this.theRaces.indexOf(obj));
        }
        if (arrayList.size() > 0) {
            int[] ints = new int[arrayList.size()];
            for (int i = 0; i < ints.length; ++i) {
                ints[i] = (Integer)arrayList.get(i);
            }
            this.theView.getLibraryCreatures().setSelectedIndices(ints);
        }
    }

    private Vector<?> getMonsterFromTable(String table) throws FileNotFoundException {
        Integer num;
        String tablePath;
        Random roll = new Random(System.currentTimeMillis());
        if (table.startsWith("[")) {
            tablePath = this.getDataDirectory() + File.separator + DIR_ENCOUNTER + File.separator + table.substring(1, table.length() - 1);
            Logging.errorPrint((String)("subfile " + tablePath));
        } else {
            tablePath = table;
        }
        tablePath = tablePath.concat(".xml");
        File monsterFile = new File(tablePath);
        if (!monsterFile.exists()) {
            Logging.errorPrint((String)("could not open " + tablePath));
            return null;
        }
        ReadXML monsterTable = new ReadXML(monsterFile);
        String percent = monsterTable.findPercentageEntry(roll.nextInt(99) + 1);
        String tableEntry = monsterTable.getTable().crossReference((Object)percent, (Object)"Monster").toString();
        String numMonsters = monsterTable.getTable().crossReference((Object)percent, (Object)"Number").toString();
        if (tableEntry.startsWith("[")) {
            return this.getMonsterFromTable(tableEntry.substring(1, tableEntry.length() - 1));
        }
        try {
            num = Integer.valueOf(numMonsters);
        }
        catch (NumberFormatException e) {
            String[] dice = numMonsters.split("d");
            num = 0;
            for (int x = 0; x < Integer.parseInt(dice[0]); ++x) {
                num = num + roll.nextInt(Integer.parseInt(dice[1])) + 1;
            }
        }
        Vector<Integer> toReturn = new Vector<Integer>();
        toReturn.addElement(num);
        toReturn.addElement((Integer)Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(Race.class, tableEntry));
        return toReturn;
    }

    private String getNewIdPath(PlayerCharacter aPC, EquipSet eSet) {
        String pid = "0";
        int newID = 0;
        if (eSet != null) {
            pid = eSet.getIdPath();
        }
        for (EquipSet es : aPC.getDisplay().getEquipSet()) {
            if (!es.getParentIdPath().equals(pid) || es.getId() <= newID) continue;
            newID = es.getId();
        }
        return pid + '.' + ++newID;
    }

    private static List<String> getWeaponLocationChoices(int hands, String multiHand) {
        ArrayList<String> result = new ArrayList<String>(hands + 2);
        if (hands > 0) {
            result.add("Primary Hand");
            for (int i = 1; i < hands; ++i) {
                if (i > 1) {
                    result.add("Secondary Hand " + i);
                    continue;
                }
                result.add("Secondary Hand");
            }
            if (multiHand.length() > 0) {
                result.add(multiHand);
            }
        }
        return result;
    }

    private void addAllToEquipSet(PlayerCharacter aPC, EquipSet eqSet) {
        for (Equipment eq : aPC.getDisplay().getEquipmentSet()) {
            this.addEquipToTarget(aPC, eqSet, "", eq.clone(), new Float(1.0f));
        }
    }

    private EquipSet createDefaultEquipset(PlayerCharacter aPC) {
        EquipSet eSet;
        if (!aPC.getDisplay().hasEquipSet()) {
            String id = this.getNewIdPath(aPC, null);
            String defaultEquipSet = "Default Set";
            eSet = new EquipSet(id, defaultEquipSet);
            aPC.addEquipSet(eSet);
            Logging.debugPrint((String)("Adding EquipSet: " + defaultEquipSet));
        } else {
            eSet = aPC.getDisplay().getEquipSetByIdPath(EquipSet.DEFAULT_SET_PATH);
        }
        return eSet;
    }

    private void generateXfromY(String Environment) {
        Vector<?> critters;
        try {
            critters = this.getMonsterFromTable(Environment);
        }
        catch (FileNotFoundException e) {
            Logging.errorPrint((String)e.getMessage(), (Throwable)e);
            return;
        }
        if (critters.size() < 1) {
            Logging.debugPrint((String)"EncounterPlugin - generateXfromY found no matches");
            return;
        }
        for (int x = 0; x < (Integer)critters.firstElement(); ++x) {
            this.theModel.addElement(critters.lastElement().toString());
        }
    }

    private void generateXofYEL(String size, String totalEL) {
        File f = new File(this.getDataDirectory() + File.separator + DIR_ENCOUNTER + File.separator + "4_1.xml");
        Random roll = new Random(System.currentTimeMillis());
        ArrayList<Race> critters = new ArrayList<Race>();
        if (!f.exists()) {
            Logging.errorPrintLocalised((String)"in_plugin_encounter_error_missing", (Object[])new Object[]{f});
            return;
        }
        ReadXML xml = new ReadXML(f);
        VectorTable table41 = xml.getTable();
        if (table41 == null) {
            Logging.errorPrint((String)("ACK! error getting table41! " + f.toString()));
            return;
        }
        xml = null;
        f = null;
        String crs = (String)table41.crossReference((Object)totalEL, (Object)size);
        table41 = null;
        if (crs == null) {
            Logging.errorPrint((String)("Tables do not match the given parameters (" + totalEL + ", " + size + ")"));
            return;
        }
        Formula crFormula = FormulaFactory.getFormulaFor((String)crs);
        if (!crFormula.isValid()) {
            Logging.errorPrint((String)("CR Formula " + crs + " was not valid: " + crFormula.toString()));
        }
        ChallengeRating cr = new ChallengeRating(crFormula);
        for (Race race : Globals.getContext().getReferenceContext().getConstructedCDOMObjects(Race.class)) {
            if (!cr.equals(race.get(ObjectKey.CHALLENGE_RATING))) continue;
            critters.add(race);
        }
        int i = roll.nextInt(critters.size());
        for (int x = 0; x < Integer.parseInt(size); ++x) {
            this.theModel.addElement(((Race)critters.get(i)).toString());
        }
    }

    private void handleEquipment(PlayerCharacter aPC) {
        EquipSet eqSet = this.createDefaultEquipset(aPC);
        this.addAllToEquipSet(aPC, eqSet);
        aPC.setCalcEquipSetId(eqSet.getIdPath());
        aPC.setCalcEquipmentList();
    }

    private void handleMonster(PlayerCharacter aPC, LevelCommandFactory lcf) {
        PCClass cl = lcf.getPCClass();
        int levels = lcf.getLevelCount().resolve(aPC, "").intValue();
        Logging.debugPrint((String)("Monster Class: " + cl.getDisplayName() + " Level: " + levels));
        PCClass pcClass = aPC.getClassKeyed(cl.getKeyName());
        int currentLevels = 0;
        if (pcClass != null) {
            currentLevels = aPC.getDisplay().getLevel(pcClass);
        }
        if (currentLevels < levels) {
            aPC.incrementClassLevel(levels - currentLevels, cl);
        }
    }

    private void handleNonMonster(PlayerCharacter aPC) {
        PCClass mclass = (PCClass)Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(PCClass.class, "Warrior");
        if (mclass != null) {
            Logging.debugPrint((String)("Class: " + mclass.getDisplayName() + " Level: 1"));
            aPC.incrementClassLevel(1, mclass);
            this.rollHP(aPC);
        }
    }

    private boolean handleRace(PlayerCharacter aPC, int number) {
        Race race = (Race)Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(Race.class, (String)this.theModel.getElementAt(number));
        if (race == null) {
            return false;
        }
        aPC.setRace(race);
        aPC.setName(race.toString());
        return true;
    }

    private final List<String> locationChoices(PlayerCharacter pc, Equipment eqI) {
        int hands = 0;
        if (pc != null) {
            hands = pc.getDisplay().getHands();
        }
        List<Object> aList = new ArrayList<String>();
        if (eqI.isWeapon()) {
            if (eqI.isUnarmed()) {
                aList.add("Unarmed");
            } else if (eqI.isWeaponLightForPC(pc)) {
                aList = EncounterPlugin.getWeaponLocationChoices(hands, "");
                if (eqI.isRanged() && !eqI.isThrown()) {
                    aList.add("Both Hands");
                }
                if (eqI.isMelee()) {
                    aList.add("Two Weapons");
                }
            } else if (eqI.isWeaponOneHanded(pc)) {
                aList = EncounterPlugin.getWeaponLocationChoices(hands, "Both Hands");
                if (eqI.isMelee()) {
                    if (eqI.isDouble()) {
                        aList.add("Double Weapon");
                    } else {
                        aList.add("Two Weapons");
                    }
                }
            } else {
                aList.add("Both Hands");
                if (eqI.isMelee() && eqI.isDouble()) {
                    aList.add("Double Weapon");
                }
            }
        } else {
            String locName = EncounterPlugin.getSingleLocation(pc, eqI);
            if (locName.length() != 0) {
                aList.add(locName);
            } else {
                aList.add("Equipped");
            }
        }
        if (!eqI.isUnarmed()) {
            aList.add("Carried");
            aList.add("Not Carried");
        }
        return aList;
    }

    private static String getSingleLocation(PlayerCharacter pc, Equipment eqI) {
        if (eqI.isNatural() && eqI.getSlots(pc) == 0) {
            if (eqI.modifiedName().endsWith("Primary")) {
                return "Natural-Primary";
            }
            return "Natural-Secondary";
        }
        List eqSlotList = SystemCollections.getUnmodifiableEquipSlotList();
        if (eqSlotList == null || eqSlotList.isEmpty()) {
            return "";
        }
        for (EquipSlot es : eqSlotList) {
            if (!es.canContainType(eqI.getType())) continue;
            return es.getSlotName();
        }
        return "";
    }

    private String getEquipLocation(PlayerCharacter pc, EquipSet eSet, String locName, Equipment eqI) {
        String location = locName;
        if ("".equals(location) || location.length() == 0) {
            List<String> aList = this.locationChoices(pc, eqI);
            location = EncounterPlugin.getSingleLocation(pc, eqI);
            if (location.length() == 0 || !EncounterPlugin.canAddEquip(pc, eSet, location, eqI)) {
                List selectedList = new ArrayList();
                selectedList = Globals.getChoiceFromList((String)("Select a location for " + eqI.getName()), aList, selectedList, (int)1, (boolean)false, (boolean)true, (PlayerCharacter)pc);
                if (selectedList.size() > 0) {
                    location = (String)selectedList.get(0);
                }
            }
        }
        if ("".equals(location) || location.length() == 0) {
            return null;
        }
        if (!EncounterPlugin.canAddEquip(pc, eSet, location, eqI)) {
            JOptionPane.showMessageDialog(null, "Can not equip " + eqI.getName() + " to " + location, "GMGen", 0);
            return null;
        }
        return location;
    }

    private static boolean canAddEquip(PlayerCharacter pc, EquipSet eSet, String locName, Equipment eqI) {
        String idPath = eSet.getIdPath();
        if (locName.startsWith("Carried") || locName.startsWith("Equipped") || locName.startsWith("Not Carried")) {
            return true;
        }
        if (eqI.isUnarmed()) {
            return true;
        }
        if (locName.equals("Natural-Secondary")) {
            return true;
        }
        if (eqI.isWeaponTooLargeForPC(pc)) {
            return false;
        }
        HashMap<String, String> slotMap = new HashMap<String, String>();
        for (EquipSet eqSet : pc.getDisplay().getEquipSet()) {
            if (!eqSet.getParentIdPath().startsWith(idPath) || !eqSet.getName().equals(locName)) continue;
            Equipment eItem = eqSet.getItem();
            String nString = (String)slotMap.get(locName);
            int existNum = 0;
            if (nString != null) {
                existNum = Integer.parseInt(nString);
            }
            if (eItem != null) {
                existNum += eItem.getSlots(pc);
            }
            slotMap.put(locName, String.valueOf(existNum));
        }
        for (EquipSet eqSet : pc.getDisplay().getEquipSet()) {
            if (!eqSet.getParentIdPath().startsWith(idPath)) continue;
            if (eqI.isWeapon()) {
                if (eqSet.getName().equals(locName)) {
                    return false;
                }
                if ((locName.equals("Both Hands") || locName.equals("Double Weapon") || locName.equals("Two Weapons")) && (eqSet.getName().equals("Primary Hand") || eqSet.getName().equals("Secondary Hand") || eqSet.getName().equals("Both Hands") || eqSet.getName().equals("Double Weapon") || eqSet.getName().equals("Two Weapons"))) {
                    return false;
                }
                if ((locName.equals("Primary Hand") || locName.equals("Secondary Hand")) && (eqSet.getName().equals("Both Hands") || eqSet.getName().equals("Double Weapon") || eqSet.getName().equals("Two Weapons"))) {
                    return false;
                }
            }
            if (!eqSet.getName().equals(locName)) continue;
            String nString = (String)slotMap.get(locName);
            int existNum = 0;
            if (nString != null) {
                existNum = Integer.parseInt(nString);
            }
            existNum += eqI.getSlots(pc);
            EquipSlot eSlot = Globals.getEquipSlotByName((String)locName);
            if (eSlot == null) {
                return true;
            }
            for (String slotType : eSlot.getContainType()) {
                if (!eqI.isType(slotType) || existNum <= eSlot.getSlotCount() + (int)pc.getTotalBonusTo("SLOTS", slotType)) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    private EquipSet addEquipToTarget(PlayerCharacter aPC, EquipSet eSet, String locName, Equipment eqI, Float newQty) {
        String location = this.getEquipLocation(aPC, eSet, locName, eqI);
        String id = this.getNewIdPath(aPC, eSet);
        Logging.debugPrint((String)("--addEB-- IdPath:" + id + "  Parent:" + eSet.getIdPath() + " Location:" + location + " eqName:" + eqI.getName() + "  eSet:" + eSet.getName()));
        EquipSet newSet = new EquipSet(id, location, eqI.getName(), eqI);
        eqI.setQty(newQty);
        newSet.setQty(newQty);
        aPC.addEquipSet(newSet);
        aPC.setCurrentEquipSetName(eSet.getName());
        return newSet;
    }

    private void removeAll() {
        this.theModel.removeAllElements();
        this.theList = new InitHolderList();
        this.updateUI();
    }

    private void rollHP(PlayerCharacter aPC) {
        CharacterDisplay display = aPC.getDisplay();
        for (PCClass pcClass : display.getClassSet()) {
            for (int j = 0; j < display.getLevel(pcClass); ++j) {
                int bonus = (int)aPC.getTotalBonusTo("HD", "MIN") + (int)aPC.getTotalBonusTo("HD", "MIN;CLASS." + pcClass.getKeyName());
                int size = display.getLevelHitDie(pcClass, j + 1).getDie();
                PCClassLevel classLevel = display.getActiveClassLevel(pcClass, j);
                aPC.setHP(classLevel, Integer.valueOf(new Dice(1, size, bonus).roll()));
            }
        }
        aPC.setDirty(true);
    }

    public File getDataDirectory() {
        File dataDir = new File(SettingsHandler.getGmgenPluginDir(), this.getPluginName());
        return dataDir;
    }
}

