/*
 * Decompiled with CFR 0.152.
 */
package com.incors.plaf.kunststoff;

import com.incors.plaf.kunststoff.KunststoffLookAndFeel;
import com.incors.plaf.kunststoff.KunststoffUtilities;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTextFieldUI;

public class KunststoffTextFieldUI
extends BasicTextFieldUI {
    protected JComponent myComponent;

    public KunststoffTextFieldUI() {
    }

    KunststoffTextFieldUI(JComponent jComponent) {
        this.myComponent = jComponent;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new KunststoffTextFieldUI(jComponent);
    }

    protected void paintBackground(Graphics graphics) {
        Serializable serializable;
        Color color;
        super.paintBackground(graphics);
        ColorUIResource colorUIResource = KunststoffLookAndFeel.getTextComponentGradientColorReflection();
        if (colorUIResource != null) {
            color = KunststoffUtilities.getTranslucentColor(colorUIResource, 0);
            serializable = new Rectangle(0, 0, this.myComponent.getWidth(), this.myComponent.getHeight() / 2);
            KunststoffUtilities.drawGradient(graphics, colorUIResource, color, (Rectangle)serializable, true);
        }
        if ((color = KunststoffLookAndFeel.getTextComponentGradientColorShadow()) != null) {
            serializable = KunststoffUtilities.getTranslucentColor(color, 0);
            Rectangle rectangle = new Rectangle(0, this.myComponent.getHeight() / 2, this.myComponent.getWidth(), this.myComponent.getHeight() / 2);
            KunststoffUtilities.drawGradient(graphics, serializable, color, rectangle, true);
        }
    }
}

