module Main (main)
where

import System.Process (
   CreateProcess( env ),
   createProcess,
   shell,
   waitForProcess )
import System.Exit ( exitWith )

main :: IO ()
main = do
  -- Get a CreateProcess object corresponding to our shell command.
  let createproc = shell "shelltest test/shell/*.test"

  -- But clear its environment before running the command.
  let empty_env_createproc = createproc { env = Just [] }

  -- Ignore stdin/stdout/stderr...
  (_,_,_,hproc) <- createProcess empty_env_createproc

  -- Now run the ProcessHandle and exit with its result.
  result <- waitForProcess hproc
  exitWith result
