package libkbfs

import (
	"testing"
	"time"

	"github.com/keybase/client/go/kbfs/kbfscodec"
	"github.com/keybase/client/go/kbfs/tlf"
	"github.com/stretchr/testify/require"
)

func makeTime(data []byte) time.Time {
	var t time.Time
	err := t.UnmarshalBinary(data)
	if err != nil {
		panic(err)
	}
	return t
}

var testLRUTime = makeTime([]byte{
	// Version.
	0x1,
	// Seconds.
	0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9,
	// Nanoseconds.
	0xa, 0xb, 0xc, 0xd,
	// Zone offset.
	0xe, 0xf,
})

var testMetaDb = DiskBlockCacheMetadata{
	TlfID:            tlf.FakeID(1, tlf.Public),
	LRUTime:          legacyEncodedTime{testLRUTime},
	BlockSize:        0xface,
	FinishedPrefetch: true,
	Tag:              "mark",
}

// This was generated by starting with []byte{} in
// TestDiskBlockCacheMetadataEncodeHardcoded and copying the data in
// the error message for its require.Equal.
var testMetaDbEncoded = []byte{
	0x86, 0xa9, 0x42, 0x6c, 0x6f, 0x63,
	0x6b, 0x53, 0x69, 0x7a, 0x65, 0xcd, 0xfa, 0xce, 0xb0, 0x46,
	0x69, 0x6e, 0x69, 0x73, 0x68, 0x65, 0x64, 0x50, 0x72, 0x65,
	0x66, 0x65, 0x74, 0x63, 0x68, 0xc3, 0xad, 0x48, 0x61, 0x73,
	0x50, 0x72, 0x65, 0x66, 0x65, 0x74, 0x63, 0x68, 0x65, 0x64,
	0xc2, 0xa7, 0x4c, 0x52, 0x55, 0x54, 0x69, 0x6d, 0x65, 0xc4,
	0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb,
	0xc, 0xd, 0xe, 0xf, 0xa3, 0x54, 0x61, 0x67, 0xa4, 0x6d, 0x61,
	0x72, 0x6b, 0xa5, 0x54, 0x6c, 0x66, 0x49, 0x44, 0xc4, 0x10,
	0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	0x0, 0x17,
}

func TestDiskBlockCacheMetadataEncodeHardcoded(t *testing.T) {
	codec := kbfscodec.NewMsgpack()

	bytes, err := codec.Encode(testMetaDb)
	require.NoError(t, err)
	require.Equal(t, testMetaDbEncoded, bytes)
}

func TestDiskBlockCacheMetadataDecodeHardcoded(t *testing.T) {
	codec := kbfscodec.NewMsgpack()

	var metaDb DiskBlockCacheMetadata
	err := codec.Decode(testMetaDbEncoded, &metaDb)
	require.NoError(t, err)

	require.Equal(t, testMetaDb, metaDb)
}
