'use client';
'use strict';

var jsxRuntime = require('react/jsx-runtime');
var rem = require('../../core/utils/units-converters/rem.cjs');
require('react');
var getDefaultZIndex = require('../../core/utils/get-default-z-index/get-default-z-index.cjs');
var getSize = require('../../core/utils/get-size/get-size.cjs');
require('@mantine/hooks');
var createVarsResolver = require('../../core/styles-api/create-vars-resolver/create-vars-resolver.cjs');
require('clsx');
require('../../core/MantineProvider/Mantine.context.cjs');
require('../../core/MantineProvider/default-theme.cjs');
require('../../core/MantineProvider/MantineProvider.cjs');
require('../../core/MantineProvider/MantineThemeProvider/MantineThemeProvider.cjs');
var useProps = require('../../core/MantineProvider/use-props/use-props.cjs');
require('../../core/MantineProvider/MantineCssVariables/MantineCssVariables.cjs');
var useStyles = require('../../core/styles-api/use-styles/use-styles.cjs');
require('../../core/Box/Box.cjs');
var factory = require('../../core/factory/factory.cjs');
var DirectionProvider = require('../../core/DirectionProvider/DirectionProvider.cjs');
var ModalBase = require('../ModalBase/ModalBase.cjs');
require('../ModalBase/ModalBaseBody.cjs');
require('../ModalBase/ModalBaseCloseButton.cjs');
require('../ModalBase/ModalBaseContent.cjs');
require('../ModalBase/ModalBaseHeader.cjs');
require('../ModalBase/ModalBaseOverlay.cjs');
require('../ModalBase/ModalBaseTitle.cjs');
var ScrollArea = require('../ScrollArea/ScrollArea.cjs');
var Drawer_context = require('./Drawer.context.cjs');
var Drawer_module = require('./Drawer.module.css.cjs');

function getDrawerAlign(position) {
  switch (position) {
    case "top":
      return "flex-start";
    case "bottom":
      return "flex-end";
    default:
      return void 0;
  }
}
function getDrawerFlex(position) {
  if (position === "top" || position === "bottom") {
    return "0 0 calc(100% - var(--drawer-offset, 0rem) * 2)";
  }
  return void 0;
}
const transitions = {
  top: "slide-down",
  bottom: "slide-up",
  left: "slide-right",
  right: "slide-left"
};
const rtlTransitions = {
  top: "slide-down",
  bottom: "slide-up",
  right: "slide-right",
  left: "slide-left"
};
const defaultProps = {
  closeOnClickOutside: true,
  withinPortal: true,
  lockScroll: true,
  trapFocus: true,
  returnFocus: true,
  closeOnEscape: true,
  keepMounted: false,
  zIndex: getDefaultZIndex.getDefaultZIndex("modal"),
  position: "left"
};
const varsResolver = createVarsResolver.createVarsResolver((_, { position, size, offset }) => ({
  root: {
    "--drawer-size": getSize.getSize(size, "drawer-size"),
    "--drawer-flex": getDrawerFlex(position),
    "--drawer-height": position === "left" || position === "right" ? void 0 : "var(--drawer-size)",
    "--drawer-align": getDrawerAlign(position),
    "--drawer-justify": position === "right" ? "flex-end" : void 0,
    "--drawer-offset": rem.rem(offset)
  }
}));
const DrawerRoot = factory.factory((_props, ref) => {
  const props = useProps.useProps("DrawerRoot", defaultProps, _props);
  const {
    classNames,
    className,
    style,
    styles,
    unstyled,
    vars,
    scrollAreaComponent,
    position,
    transitionProps,
    radius,
    ...others
  } = props;
  const { dir } = DirectionProvider.useDirection();
  const getStyles = useStyles.useStyles({
    name: "Drawer",
    classes: Drawer_module,
    props,
    className,
    style,
    classNames,
    styles,
    unstyled,
    vars,
    varsResolver
  });
  const drawerTransition = (dir === "rtl" ? rtlTransitions : transitions)[position];
  return /* @__PURE__ */ jsxRuntime.jsx(Drawer_context.DrawerProvider, { value: { scrollAreaComponent, getStyles, radius }, children: /* @__PURE__ */ jsxRuntime.jsx(
    ModalBase.ModalBase,
    {
      ref,
      ...getStyles("root"),
      transitionProps: { transition: drawerTransition, ...transitionProps },
      "data-offset-scrollbars": scrollAreaComponent === ScrollArea.ScrollArea.Autosize || void 0,
      unstyled,
      ...others
    }
  ) });
});
DrawerRoot.classes = Drawer_module;
DrawerRoot.displayName = "@mantine/core/DrawerRoot";

exports.DrawerRoot = DrawerRoot;
//# sourceMappingURL=DrawerRoot.cjs.map
