import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";
import React, { useCallback, useMemo } from 'react';
import { default as AnalyticsReactContext } from '@atlaskit/analytics-next-stable-react-context';
import { useAnalyticsContext } from '../../hooks/useAnalyticsContext';
import { useTrackedRef } from '../../hooks/useTrackedRef';
var AnalyticsContext = function AnalyticsContext(_ref) {
  var data = _ref.data,
    children = _ref.children;
  var dataRef = useTrackedRef(data);
  var _useAnalyticsContext = useAnalyticsContext(),
    getAtlaskitAnalyticsEventHandlers = _useAnalyticsContext.getAtlaskitAnalyticsEventHandlers,
    getOriginalAnalyticsContext = _useAnalyticsContext.getAtlaskitAnalyticsContext;
  var getAtlaskitAnalyticsContext = useCallback(function () {
    return [].concat(_toConsumableArray(getOriginalAnalyticsContext()), [dataRef.current]);
  }, [getOriginalAnalyticsContext, dataRef]);
  var value = useMemo(function () {
    return {
      getAtlaskitAnalyticsContext: getAtlaskitAnalyticsContext,
      getAtlaskitAnalyticsEventHandlers: getAtlaskitAnalyticsEventHandlers
    };
  }, [getAtlaskitAnalyticsContext, getAtlaskitAnalyticsEventHandlers]);
  return /*#__PURE__*/React.createElement(AnalyticsReactContext.Provider, {
    value: value
  }, children);
};
export default AnalyticsContext;