import _defineProperty from "@babel/runtime/helpers/defineProperty";
import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { default as AnalyticsReactContext } from '@atlaskit/analytics-next-stable-react-context';
const ContextTypes = {
  getAtlaskitAnalyticsContext: PropTypes.func,
  getAtlaskitAnalyticsEventHandlers: PropTypes.func
};
const noop = () => [];

// eslint-disable-next-line @repo/internal/react/no-class-components
class AnalyticsContext extends Component {
  constructor(props) {
    super(props);
    _defineProperty(this, "getChildContext", () => ({
      getAtlaskitAnalyticsContext: this.getAnalyticsContext
    }));
    _defineProperty(this, "getAnalyticsContext", () => {
      const {
        data
      } = this.props;
      const {
        getAtlaskitAnalyticsContext = noop
      } = this.context;
      return [...getAtlaskitAnalyticsContext(), data];
    });
    _defineProperty(this, "getAnalyticsEventHandlers", () => {
      const {
        getAtlaskitAnalyticsEventHandlers = noop
      } = this.context;
      return getAtlaskitAnalyticsEventHandlers();
    });
    this.contextValue = {
      getAtlaskitAnalyticsContext: this.getAnalyticsContext,
      getAtlaskitAnalyticsEventHandlers: this.getAnalyticsEventHandlers
    };
  }
  render() {
    const {
      children
    } = this.props;
    return /*#__PURE__*/React.createElement(AnalyticsReactContext.Provider, {
      value: this.contextValue
    }, children);
  }
}
_defineProperty(AnalyticsContext, "contextTypes", ContextTypes);
_defineProperty(AnalyticsContext, "childContextTypes", ContextTypes);
export default AnalyticsContext;