/*
 * Decompiled with CFR 0.152.
 */
package io.bazel.kotlin.builder.guava.graph;

import io.bazel.kotlin.builder.guava.base.Preconditions;
import io.bazel.kotlin.builder.guava.graph.ElementTypesAreNonnullByDefault;
import io.bazel.kotlin.builder.guava.graph.MapIteratorCache;
import java.util.Map;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
final class MapRetrievalCache<K, V>
extends MapIteratorCache<K, V> {
    @CheckForNull
    private volatile transient CacheEntry<K, V> cacheEntry1;
    @CheckForNull
    private volatile transient CacheEntry<K, V> cacheEntry2;

    MapRetrievalCache(Map<K, V> backingMap) {
        super(backingMap);
    }

    @Override
    @CheckForNull
    V get(Object key) {
        Preconditions.checkNotNull(key);
        V value = this.getIfCached(key);
        if (value != null) {
            return value;
        }
        value = this.getWithoutCaching(key);
        if (value != null) {
            this.addToCache(key, value);
        }
        return value;
    }

    @Override
    @CheckForNull
    V getIfCached(@CheckForNull Object key) {
        Object value = super.getIfCached(key);
        if (value != null) {
            return value;
        }
        CacheEntry<K, V> entry2 = this.cacheEntry1;
        if (entry2 != null && entry2.key == key) {
            return entry2.value;
        }
        entry2 = this.cacheEntry2;
        if (entry2 != null && entry2.key == key) {
            this.addToCache(entry2);
            return entry2.value;
        }
        return null;
    }

    @Override
    void clearCache() {
        super.clearCache();
        this.cacheEntry1 = null;
        this.cacheEntry2 = null;
    }

    private void addToCache(K key, V value) {
        this.addToCache(new CacheEntry<K, V>(key, value));
    }

    private void addToCache(CacheEntry<K, V> entry2) {
        this.cacheEntry2 = this.cacheEntry1;
        this.cacheEntry1 = entry2;
    }

    private static final class CacheEntry<K, V> {
        final K key;
        final V value;

        CacheEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }
    }
}

