/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.ArrayList;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.NoOpenStartTagException;
import net.sf.saxon.event.OnEmptyHandler;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.TreeReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.OperandUsage;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.CopyOf;
import net.sf.saxon.expr.instruct.ElementCreator;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.ContentTypeTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.NamespaceIterator;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AnySimpleType;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaDeclaration;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.value.SequenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Copy
extends ElementCreator {
    private boolean copyNamespaces;
    private ItemType selectItemType = AnyItemType.getInstance();
    private ItemType resultItemType;
    private static final OperandRole FOCUS_CONTROLLING_SELECT = new OperandRole(1, OperandUsage.INSPECTION, SequenceType.OPTIONAL_ITEM);
    public static final OperandRole FOCUS_CONTROLLED_CONTENT = new OperandRole(2, OperandUsage.ABSORPTION, SequenceType.ANY_SEQUENCE);
    public static final OperandRole SAME_FOCUS_CONTENT = new OperandRole(0, OperandUsage.ABSORPTION, SequenceType.ANY_SEQUENCE);
    public static final OperandRole ON_EMPTY_ROLE = new OperandRole(0, OperandUsage.ABSORPTION, SequenceType.ANY_SEQUENCE);

    public Copy(boolean copyNamespaces, boolean inheritNamespaces, SchemaType schemaType, int validation, Expression onEmpty) {
        this.copyNamespaces = copyNamespaces;
        this.inheritNamespacesToChildren = inheritNamespaces;
        this.onEmpty = onEmpty;
        this.setValidationAction(validation, schemaType);
        boolean bl = this.preservingTypes = schemaType == null && validation == 3;
        if (copyNamespaces) {
            this.setLazyConstruction(false);
        }
    }

    public boolean isCopyNamespaces() {
        return this.copyNamespaces;
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.preservingTypes |= !visitor.getStaticContext().isSchemaAware();
        return super.simplify(visitor);
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        ItemType selectItemType;
        this.selectItemType = contextInfo.getItemType();
        if (this.onEmpty != null) {
            this.onEmpty = visitor.typeCheck(this.onEmpty, contextInfo);
            this.adoptChildExpression(this.onEmpty);
        }
        if ((selectItemType = contextInfo.getItemType()) == ErrorType.getInstance()) {
            XPathException err = new XPathException("No context item supplied for xsl:copy", "XTTE0945");
            err.setIsTypeError(true);
            err.setLocator(this);
            throw err;
        }
        this.content = visitor.typeCheck(this.content, contextInfo);
        if (selectItemType instanceof NodeTest) {
            switch (selectItemType.getPrimitiveType()) {
                case 1: {
                    this.resultItemType = NodeKindTest.ELEMENT;
                    break;
                }
                case 2: {
                    this.resultItemType = NodeKindTest.ATTRIBUTE;
                    break;
                }
                case 9: {
                    this.resultItemType = NodeKindTest.DOCUMENT;
                    break;
                }
                default: {
                    this.resultItemType = selectItemType;
                    break;
                }
            }
        } else {
            this.resultItemType = selectItemType;
        }
        this.adoptChildExpression(this.content);
        this.verifyLazyConstruction();
        this.checkContentSequence(visitor.getStaticContext());
        return this;
    }

    @Override
    public Expression copy() {
        Copy copy = new Copy(this.copyNamespaces, this.inheritNamespacesToChildren, this.getSchemaType(), this.getValidationAction(), this.onEmpty == null ? null : this.onEmpty.copy());
        copy.setContentExpression(this.content.copy());
        copy.resultItemType = this.resultItemType;
        return copy;
    }

    @Override
    public boolean replaceOperand(Expression original, Expression replacement) {
        boolean found = false;
        if (this.content == original) {
            this.content = replacement;
            found = true;
        } else if (this.onEmpty == original) {
            this.onEmpty = replacement;
            found = true;
        }
        return found;
    }

    @Override
    public int getIntrinsicDependencies() {
        return 2;
    }

    @Override
    public int getInstructionNameCode() {
        return 143;
    }

    @Override
    public Iterable<Operand> operands() {
        ArrayList<Operand> list = new ArrayList<Operand>(5);
        list.add(new Operand(this.content, SAME_FOCUS_CONTENT));
        if (this.onEmpty != null) {
            list.add(new Operand(this.onEmpty, ON_EMPTY_ROLE));
        }
        return list;
    }

    @Override
    public ItemType getItemType() {
        if (this.resultItemType != null) {
            return this.resultItemType;
        }
        TypeHierarchy th = this.getConfiguration().getTypeHierarchy();
        this.resultItemType = this.computeItemType(th);
        return this.resultItemType;
    }

    private ItemType computeItemType(TypeHierarchy th) {
        ItemType selectItemType = this.selectItemType;
        if (this.onEmpty != null) {
            selectItemType = Type.getCommonSuperType(selectItemType, this.onEmpty.getItemType());
        }
        if (!this.getContainer().getPackageData().isSchemaAware()) {
            return selectItemType;
        }
        Configuration config = this.getContainer().getConfiguration();
        if (this.getSchemaType() != null) {
            int e = th.relationship(selectItemType, NodeKindTest.ELEMENT);
            if (e == 0 || e == 2) {
                return new ContentTypeTest(1, this.getSchemaType(), config, false);
            }
            int a = th.relationship(selectItemType, NodeKindTest.ATTRIBUTE);
            if (a == 0 || a == 2) {
                return new ContentTypeTest(2, this.getSchemaType(), config, false);
            }
            return AnyNodeTest.getInstance();
        }
        switch (this.getValidationAction()) {
            case 3: {
                return selectItemType;
            }
            case 4: {
                int e = th.relationship(selectItemType, NodeKindTest.ELEMENT);
                if (e == 0 || e == 2) {
                    return new ContentTypeTest(1, Untyped.getInstance(), config, false);
                }
                int a = th.relationship(selectItemType, NodeKindTest.ATTRIBUTE);
                if (a == 0 || a == 2) {
                    return new ContentTypeTest(2, BuiltInAtomicType.UNTYPED_ATOMIC, config, false);
                }
                if (e != 4 || a != 4) {
                    return AnyNodeTest.getInstance();
                }
                return selectItemType;
            }
            case 1: 
            case 2: {
                if (selectItemType instanceof NodeTest) {
                    int fp = ((NodeTest)selectItemType).getFingerprint();
                    if (fp != -1) {
                        int e = th.relationship(selectItemType, NodeKindTest.ELEMENT);
                        if (e == 0 || e == 2) {
                            SchemaDeclaration elem = config.getElementDeclaration(fp);
                            if (elem != null) {
                                return new ContentTypeTest(1, elem.getType(), config, false);
                            }
                            return new ContentTypeTest(1, AnyType.getInstance(), config, false);
                        }
                        int a = th.relationship(selectItemType, NodeKindTest.ATTRIBUTE);
                        if (a == 0 || a == 2) {
                            SchemaDeclaration attr = config.getElementDeclaration(fp);
                            if (attr != null) {
                                return new ContentTypeTest(2, attr.getType(), config, false);
                            }
                            return new ContentTypeTest(2, AnySimpleType.getInstance(), config, false);
                        }
                    } else {
                        int e = th.relationship(selectItemType, NodeKindTest.ELEMENT);
                        if (e == 0 || e == 2) {
                            return NodeKindTest.ELEMENT;
                        }
                        int a = th.relationship(selectItemType, NodeKindTest.ATTRIBUTE);
                        if (a == 0 || a == 2) {
                            return NodeKindTest.ATTRIBUTE;
                        }
                    }
                    return AnyNodeTest.getInstance();
                }
                if (selectItemType instanceof AtomicType) {
                    return selectItemType;
                }
                return AnyItemType.getInstance();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        Expression exp;
        if (this.onEmpty != null) {
            this.onEmpty = visitor.optimize(this.onEmpty, contextItemType);
            this.adoptChildExpression(this.onEmpty);
        }
        if ((exp = super.optimize(visitor, contextItemType)) == this && this.resultItemType == null) {
            this.resultItemType = this.computeItemType(visitor.getConfiguration().getTypeHierarchy());
        }
        return exp;
    }

    @Override
    protected void promoteInst(PromotionOffer offer) throws XPathException {
        this.content = this.doPromotion(this.content, offer);
        if (this.onEmpty != null) {
            this.onEmpty = this.doPromotion(this.onEmpty, offer);
        }
    }

    @Override
    public NodeName getElementName(XPathContext context, NodeInfo copiedNode) throws XPathException {
        return new NameOfNode(copiedNode);
    }

    @Override
    public String getNewBaseURI(XPathContext context, NodeInfo copiedNode) {
        return copiedNode.getBaseURI();
    }

    @Override
    public void outputNamespaceNodes(XPathContext context, Receiver receiver, NodeName nameCode, NodeInfo copiedNode) throws XPathException {
        if (this.copyNamespaces) {
            NamespaceIterator.sendNamespaces(copiedNode, receiver);
        } else {
            receiver.namespace(nameCode.getNamespaceBinding(), 0);
        }
    }

    @Override
    public NamespaceBinding[] getActiveNamespaces() throws XPathException {
        if (this.copyNamespaces) {
            throw new UnsupportedOperationException();
        }
        return null;
    }

    @Override
    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        Controller controller = context.getController();
        SequenceReceiver out = context.getReceiver();
        Item item = context.getContextItem();
        if (item == null) {
            if (this.onEmpty != null) {
                item = this.onEmpty.evaluateItem(context);
            } else {
                return null;
            }
        }
        if (!(item instanceof NodeInfo)) {
            out.append(item, this.locationId, 2);
            return null;
        }
        NodeInfo source = (NodeInfo)item;
        switch (source.getNodeKind()) {
            case 1: {
                return super.processLeavingTail(context, (NodeInfo)item);
            }
            case 2: {
                if (this.getSchemaType() instanceof ComplexType) {
                    this.dynamicError("Cannot copy an attribute when the type requested for validation is a complex type", "XTTE1535", context);
                }
                try {
                    CharSequence aval = source.getStringValueCS();
                    if (this.onEmpty != null && aval.length() == 0) {
                        this.onEmpty.process(context);
                        break;
                    }
                    CopyOf.copyAttribute(source, (SimpleType)this.getSchemaType(), this.getValidationAction(), this, context, false);
                    break;
                }
                catch (NoOpenStartTagException err) {
                    err.setXPathContext(context);
                    throw Copy.dynamicError(this, err, context);
                }
            }
            case 3: {
                CharSequence tval = source.getStringValueCS();
                if (this.onEmpty != null && tval.length() == 0) {
                    this.onEmpty.process(context);
                    break;
                }
                out.characters(tval, this.locationId, 0);
                break;
            }
            case 7: {
                CharSequence pval = source.getStringValueCS();
                if (this.onEmpty != null && pval.length() == 0) {
                    this.onEmpty.process(context);
                    break;
                }
                out.processingInstruction(source.getDisplayName(), pval, this.locationId, 0);
                break;
            }
            case 8: {
                CharSequence cval = source.getStringValueCS();
                if (this.onEmpty != null && cval.length() == 0) {
                    this.onEmpty.process(context);
                    break;
                }
                out.comment(cval, this.locationId, 0);
                break;
            }
            case 13: {
                try {
                    source.copy(out, 0, this.locationId);
                    break;
                }
                catch (NoOpenStartTagException err) {
                    XPathException e = new XPathException(err.getMessage());
                    e.setXPathContext(context);
                    e.setErrorCodeQName(err.getErrorCodeQName());
                    throw Copy.dynamicError(this, e, context);
                }
            }
            case 9: {
                SequenceReceiver saved = out;
                boolean pop = false;
                if (this.onEmpty != null) {
                    OnEmptyHandler monitor = new OnEmptyHandler(out, this.onEmpty, context);
                    context.setReceiver(monitor);
                    pop = true;
                    out = monitor;
                }
                if (this.preservingTypes) {
                    out.startDocument(this.onEmpty != null ? 131072 : 0);
                    this.content.process(context);
                    out.endDocument();
                } else {
                    ParseOptions options = new ParseOptions(this.getValidationOptions());
                    options.setStripSpace(0);
                    Receiver val = controller.getConfiguration().getDocumentValidator(out, source.getBaseURI(), options);
                    if (val != out) {
                        TreeReceiver sr = new TreeReceiver(val);
                        ((SequenceReceiver)sr).setPipelineConfiguration(out.getPipelineConfiguration());
                        context.setReceiver(sr);
                        pop = true;
                        out = sr;
                    }
                    out.startDocument(this.onEmpty != null ? 131072 : 0);
                    this.content.process(context);
                    out.endDocument();
                }
                if (!pop) break;
                context.setReceiver(saved);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown node kind " + source.getNodeKind());
            }
        }
        return null;
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        Controller controller = context.getController();
        SequenceReceiver saved = context.getReceiver();
        SequenceOutputter seq = controller.allocateSequenceOutputter(1);
        seq.getPipelineConfiguration().setHostLanguage(this.getHostLanguage());
        context.setReceiver(seq);
        this.process(context);
        seq.close();
        context.setReceiver(saved);
        Item item = seq.getFirstItem();
        seq.reset();
        return item;
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("copy");
        if (this.onEmpty != null) {
            out.startSubsidiaryElement("on-empty");
            this.onEmpty.explain(out);
            out.endSubsidiaryElement();
        }
        out.startSubsidiaryElement("action");
        this.content.explain(out);
        out.endSubsidiaryElement();
        out.endElement();
    }
}

