/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.inventory.impl;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.felix.inventory.Format;
import org.osgi.framework.ServiceReference;

public class InventoryPrinterDescription
implements Comparable<InventoryPrinterDescription> {
    private final ServiceReference reference;
    private final Format[] formats;
    private final String name;
    private final String title;
    private final String sortKey;

    public InventoryPrinterDescription(ServiceReference ref) {
        String title;
        this.reference = ref;
        Format[] formats = null;
        Object formatsCfg = ref.getProperty("felix.inventory.printer.format");
        if (formatsCfg instanceof String) {
            Format format = Format.valueOf((String)formatsCfg);
            if (format != null) {
                formats = new Format[]{format};
            }
        } else if (formatsCfg instanceof String[]) {
            String[] formatsCfgArray = (String[])formatsCfg;
            ArrayList<Format> formatList = new ArrayList<Format>();
            for (int i = 0; i < formatsCfgArray.length; ++i) {
                Format format = Format.valueOf(formatsCfgArray[i]);
                if (format == null) continue;
                formatList.add(format);
            }
            if (!formatList.isEmpty()) {
                formats = formatList.toArray(new Format[formatList.size()]);
            }
        }
        String name = ref.getProperty("felix.inventory.printer.name") != null ? ref.getProperty("felix.inventory.printer.name").toString() : "InventoryPrinter." + ref.getProperty("service.id");
        String sortKey = null;
        if (ref.getProperty("felix.inventory.printer.title") != null) {
            title = ref.getProperty("felix.inventory.printer.title").toString();
            if (title.startsWith("%")) {
                sortKey = title.substring(1);
            }
        } else {
            title = name;
        }
        if (formats == null) {
            formats = new Format[]{Format.TEXT};
        }
        if (sortKey == null) {
            sortKey = title;
        }
        this.formats = formats;
        this.name = name;
        this.title = title;
        this.sortKey = sortKey;
    }

    public String getTitle() {
        return this.title;
    }

    public String getSortKey() {
        return this.sortKey;
    }

    public String getName() {
        return this.name;
    }

    public Format[] getFormats() {
        return this.formats;
    }

    public ServiceReference getServiceReference() {
        return this.reference;
    }

    @Override
    public int compareTo(InventoryPrinterDescription spa) {
        return this.reference.compareTo((Object)spa.reference);
    }

    public boolean equals(Object obj) {
        return this.reference.equals(obj);
    }

    public int hashCode() {
        return this.reference.hashCode();
    }

    public String toString() {
        return "InventoryPrinterDescription [title=" + this.title + ", name=" + this.name + ", formats=" + Arrays.asList(this.formats) + ", sortKey=" + this.sortKey + "]";
    }
}

