// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: envoy/api/v2/core/grpc_service.proto

package core

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on GrpcService with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *GrpcService) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on GrpcService with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in GrpcServiceMultiError, or
// nil if none found.
func (m *GrpcService) ValidateAll() error {
	return m.validate(true)
}

func (m *GrpcService) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetTimeout()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, GrpcServiceValidationError{
					field:  "Timeout",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, GrpcServiceValidationError{
					field:  "Timeout",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetTimeout()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return GrpcServiceValidationError{
				field:  "Timeout",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	for idx, item := range m.GetInitialMetadata() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, GrpcServiceValidationError{
						field:  fmt.Sprintf("InitialMetadata[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, GrpcServiceValidationError{
						field:  fmt.Sprintf("InitialMetadata[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return GrpcServiceValidationError{
					field:  fmt.Sprintf("InitialMetadata[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	switch m.TargetSpecifier.(type) {

	case *GrpcService_EnvoyGrpc_:

		if all {
			switch v := interface{}(m.GetEnvoyGrpc()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, GrpcServiceValidationError{
						field:  "EnvoyGrpc",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, GrpcServiceValidationError{
						field:  "EnvoyGrpc",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetEnvoyGrpc()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return GrpcServiceValidationError{
					field:  "EnvoyGrpc",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *GrpcService_GoogleGrpc_:

		if all {
			switch v := interface{}(m.GetGoogleGrpc()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, GrpcServiceValidationError{
						field:  "GoogleGrpc",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, GrpcServiceValidationError{
						field:  "GoogleGrpc",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetGoogleGrpc()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return GrpcServiceValidationError{
					field:  "GoogleGrpc",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		err := GrpcServiceValidationError{
			field:  "TargetSpecifier",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)

	}

	if len(errors) > 0 {
		return GrpcServiceMultiError(errors)
	}

	return nil
}

// GrpcServiceMultiError is an error wrapping multiple validation errors
// returned by GrpcService.ValidateAll() if the designated constraints aren't met.
type GrpcServiceMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m GrpcServiceMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m GrpcServiceMultiError) AllErrors() []error { return m }

// GrpcServiceValidationError is the validation error returned by
// GrpcService.Validate if the designated constraints aren't met.
type GrpcServiceValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GrpcServiceValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GrpcServiceValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GrpcServiceValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GrpcServiceValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GrpcServiceValidationError) ErrorName() string { return "GrpcServiceValidationError" }

// Error satisfies the builtin error interface
func (e GrpcServiceValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGrpcService.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GrpcServiceValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GrpcServiceValidationError{}

// Validate checks the field values on GrpcService_EnvoyGrpc with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *GrpcService_EnvoyGrpc) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on GrpcService_EnvoyGrpc with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// GrpcService_EnvoyGrpcMultiError, or nil if none found.
func (m *GrpcService_EnvoyGrpc) ValidateAll() error {
	return m.validate(true)
}

func (m *GrpcService_EnvoyGrpc) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetClusterName()) < 1 {
		err := GrpcService_EnvoyGrpcValidationError{
			field:  "ClusterName",
			reason: "value length must be at least 1 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return GrpcService_EnvoyGrpcMultiError(errors)
	}

	return nil
}

// GrpcService_EnvoyGrpcMultiError is an error wrapping multiple validation
// errors returned by GrpcService_EnvoyGrpc.ValidateAll() if the designated
// constraints aren't met.
type GrpcService_EnvoyGrpcMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m GrpcService_EnvoyGrpcMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m GrpcService_EnvoyGrpcMultiError) AllErrors() []error { return m }

// GrpcService_EnvoyGrpcValidationError is the validation error returned by
// GrpcService_EnvoyGrpc.Validate if the designated constraints aren't met.
type GrpcService_EnvoyGrpcValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GrpcService_EnvoyGrpcValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GrpcService_EnvoyGrpcValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GrpcService_EnvoyGrpcValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GrpcService_EnvoyGrpcValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GrpcService_EnvoyGrpcValidationError) ErrorName() string {
	return "GrpcService_EnvoyGrpcValidationError"
}

// Error satisfies the builtin error interface
func (e GrpcService_EnvoyGrpcValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGrpcService_EnvoyGrpc.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GrpcService_EnvoyGrpcValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GrpcService_EnvoyGrpcValidationError{}

// Validate checks the field values on GrpcService_GoogleGrpc with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *GrpcService_GoogleGrpc) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on GrpcService_GoogleGrpc with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// GrpcService_GoogleGrpcMultiError, or nil if none found.
func (m *GrpcService_GoogleGrpc) ValidateAll() error {
	return m.validate(true)
}

func (m *GrpcService_GoogleGrpc) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetTargetUri()) < 1 {
		err := GrpcService_GoogleGrpcValidationError{
			field:  "TargetUri",
			reason: "value length must be at least 1 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetChannelCredentials()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, GrpcService_GoogleGrpcValidationError{
					field:  "ChannelCredentials",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, GrpcService_GoogleGrpcValidationError{
					field:  "ChannelCredentials",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetChannelCredentials()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return GrpcService_GoogleGrpcValidationError{
				field:  "ChannelCredentials",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	for idx, item := range m.GetCallCredentials() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, GrpcService_GoogleGrpcValidationError{
						field:  fmt.Sprintf("CallCredentials[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, GrpcService_GoogleGrpcValidationError{
						field:  fmt.Sprintf("CallCredentials[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return GrpcService_GoogleGrpcValidationError{
					field:  fmt.Sprintf("CallCredentials[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(m.GetStatPrefix()) < 1 {
		err := GrpcService_GoogleGrpcValidationError{
			field:  "StatPrefix",
			reason: "value length must be at least 1 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	// no validation rules for CredentialsFactoryName

	if all {
		switch v := interface{}(m.GetConfig()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, GrpcService_GoogleGrpcValidationError{
					field:  "Config",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, GrpcService_GoogleGrpcValidationError{
					field:  "Config",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetConfig()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return GrpcService_GoogleGrpcValidationError{
				field:  "Config",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return GrpcService_GoogleGrpcMultiError(errors)
	}

	return nil
}

// GrpcService_GoogleGrpcMultiError is an error wrapping multiple validation
// errors returned by GrpcService_GoogleGrpc.ValidateAll() if the designated
// constraints aren't met.
type GrpcService_GoogleGrpcMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m GrpcService_GoogleGrpcMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m GrpcService_GoogleGrpcMultiError) AllErrors() []error { return m }

// GrpcService_GoogleGrpcValidationError is the validation error returned by
// GrpcService_GoogleGrpc.Validate if the designated constraints aren't met.
type GrpcService_GoogleGrpcValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GrpcService_GoogleGrpcValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GrpcService_GoogleGrpcValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GrpcService_GoogleGrpcValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GrpcService_GoogleGrpcValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GrpcService_GoogleGrpcValidationError) ErrorName() string {
	return "GrpcService_GoogleGrpcValidationError"
}

// Error satisfies the builtin error interface
func (e GrpcService_GoogleGrpcValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGrpcService_GoogleGrpc.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GrpcService_GoogleGrpcValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GrpcService_GoogleGrpcValidationError{}

// Validate checks the field values on GrpcService_GoogleGrpc_SslCredentials
// with the rules defined in the proto definition for this message. If any
// rules are violated, the first error encountered is returned, or nil if
// there are no violations.
func (m *GrpcService_GoogleGrpc_SslCredentials) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on GrpcService_GoogleGrpc_SslCredentials
// with the rules defined in the proto definition for this message. If any
// rules are violated, the result is a list of violation errors wrapped in
// GrpcService_GoogleGrpc_SslCredentialsMultiError, or nil if none found.
func (m *GrpcService_GoogleGrpc_SslCredentials) ValidateAll() error {
	return m.validate(true)
}

func (m *GrpcService_GoogleGrpc_SslCredentials) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetRootCerts()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, GrpcService_GoogleGrpc_SslCredentialsValidationError{
					field:  "RootCerts",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, GrpcService_GoogleGrpc_SslCredentialsValidationError{
					field:  "RootCerts",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetRootCerts()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return GrpcService_GoogleGrpc_SslCredentialsValidationError{
				field:  "RootCerts",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetPrivateKey()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, GrpcService_GoogleGrpc_SslCredentialsValidationError{
					field:  "PrivateKey",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, GrpcService_GoogleGrpc_SslCredentialsValidationError{
					field:  "PrivateKey",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetPrivateKey()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return GrpcService_GoogleGrpc_SslCredentialsValidationError{
				field:  "PrivateKey",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetCertChain()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, GrpcService_GoogleGrpc_SslCredentialsValidationError{
					field:  "CertChain",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, GrpcService_GoogleGrpc_SslCredentialsValidationError{
					field:  "CertChain",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetCertChain()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return GrpcService_GoogleGrpc_SslCredentialsValidationError{
				field:  "CertChain",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return GrpcService_GoogleGrpc_SslCredentialsMultiError(errors)
	}

	return nil
}

// GrpcService_GoogleGrpc_SslCredentialsMultiError is an error wrapping
// multiple validation errors returned by
// GrpcService_GoogleGrpc_SslCredentials.ValidateAll() if the designated
// constraints aren't met.
type GrpcService_GoogleGrpc_SslCredentialsMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m GrpcService_GoogleGrpc_SslCredentialsMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m GrpcService_GoogleGrpc_SslCredentialsMultiError) AllErrors() []error { return m }

// GrpcService_GoogleGrpc_SslCredentialsValidationError is the validation error
// returned by GrpcService_GoogleGrpc_SslCredentials.Validate if the
// designated constraints aren't met.
type GrpcService_GoogleGrpc_SslCredentialsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GrpcService_GoogleGrpc_SslCredentialsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GrpcService_GoogleGrpc_SslCredentialsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GrpcService_GoogleGrpc_SslCredentialsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GrpcService_GoogleGrpc_SslCredentialsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GrpcService_GoogleGrpc_SslCredentialsValidationError) ErrorName() string {
	return "GrpcService_GoogleGrpc_SslCredentialsValidationError"
}

// Error satisfies the builtin error interface
func (e GrpcService_GoogleGrpc_SslCredentialsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGrpcService_GoogleGrpc_SslCredentials.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GrpcService_GoogleGrpc_SslCredentialsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GrpcService_GoogleGrpc_SslCredentialsValidationError{}

// Validate checks the field values on
// GrpcService_GoogleGrpc_GoogleLocalCredentials with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *GrpcService_GoogleGrpc_GoogleLocalCredentials) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on
// GrpcService_GoogleGrpc_GoogleLocalCredentials with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in
// GrpcService_GoogleGrpc_GoogleLocalCredentialsMultiError, or nil if none found.
func (m *GrpcService_GoogleGrpc_GoogleLocalCredentials) ValidateAll() error {
	return m.validate(true)
}

func (m *GrpcService_GoogleGrpc_GoogleLocalCredentials) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(errors) > 0 {
		return GrpcService_GoogleGrpc_GoogleLocalCredentialsMultiError(errors)
	}

	return nil
}

// GrpcService_GoogleGrpc_GoogleLocalCredentialsMultiError is an error wrapping
// multiple validation errors returned by
// GrpcService_GoogleGrpc_GoogleLocalCredentials.ValidateAll() if the
// designated constraints aren't met.
type GrpcService_GoogleGrpc_GoogleLocalCredentialsMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m GrpcService_GoogleGrpc_GoogleLocalCredentialsMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m GrpcService_GoogleGrpc_GoogleLocalCredentialsMultiError) AllErrors() []error { return m }

// GrpcService_GoogleGrpc_GoogleLocalCredentialsValidationError is the
// validation error returned by
// GrpcService_GoogleGrpc_GoogleLocalCredentials.Validate if the designated
// constraints aren't met.
type GrpcService_GoogleGrpc_GoogleLocalCredentialsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GrpcService_GoogleGrpc_GoogleLocalCredentialsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GrpcService_GoogleGrpc_GoogleLocalCredentialsValidationError) Reason() string {
	return e.reason
}

// Cause function returns cause value.
func (e GrpcService_GoogleGrpc_GoogleLocalCredentialsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GrpcService_GoogleGrpc_GoogleLocalCredentialsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GrpcService_GoogleGrpc_GoogleLocalCredentialsValidationError) ErrorName() string {
	return "GrpcService_GoogleGrpc_GoogleLocalCredentialsValidationError"
}

// Error satisfies the builtin error interface
func (e GrpcService_GoogleGrpc_GoogleLocalCredentialsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGrpcService_GoogleGrpc_GoogleLocalCredentials.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GrpcService_GoogleGrpc_GoogleLocalCredentialsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GrpcService_GoogleGrpc_GoogleLocalCredentialsValidationError{}

// Validate checks the field values on
// GrpcService_GoogleGrpc_ChannelCredentials with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *GrpcService_GoogleGrpc_ChannelCredentials) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on
// GrpcService_GoogleGrpc_ChannelCredentials with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in
// GrpcService_GoogleGrpc_ChannelCredentialsMultiError, or nil if none found.
func (m *GrpcService_GoogleGrpc_ChannelCredentials) ValidateAll() error {
	return m.validate(true)
}

func (m *GrpcService_GoogleGrpc_ChannelCredentials) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	switch m.CredentialSpecifier.(type) {

	case *GrpcService_GoogleGrpc_ChannelCredentials_SslCredentials:

		if all {
			switch v := interface{}(m.GetSslCredentials()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, GrpcService_GoogleGrpc_ChannelCredentialsValidationError{
						field:  "SslCredentials",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, GrpcService_GoogleGrpc_ChannelCredentialsValidationError{
						field:  "SslCredentials",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetSslCredentials()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return GrpcService_GoogleGrpc_ChannelCredentialsValidationError{
					field:  "SslCredentials",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *GrpcService_GoogleGrpc_ChannelCredentials_GoogleDefault:

		if all {
			switch v := interface{}(m.GetGoogleDefault()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, GrpcService_GoogleGrpc_ChannelCredentialsValidationError{
						field:  "GoogleDefault",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, GrpcService_GoogleGrpc_ChannelCredentialsValidationError{
						field:  "GoogleDefault",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetGoogleDefault()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return GrpcService_GoogleGrpc_ChannelCredentialsValidationError{
					field:  "GoogleDefault",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *GrpcService_GoogleGrpc_ChannelCredentials_LocalCredentials:

		if all {
			switch v := interface{}(m.GetLocalCredentials()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, GrpcService_GoogleGrpc_ChannelCredentialsValidationError{
						field:  "LocalCredentials",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, GrpcService_GoogleGrpc_ChannelCredentialsValidationError{
						field:  "LocalCredentials",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetLocalCredentials()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return GrpcService_GoogleGrpc_ChannelCredentialsValidationError{
					field:  "LocalCredentials",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		err := GrpcService_GoogleGrpc_ChannelCredentialsValidationError{
			field:  "CredentialSpecifier",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)

	}

	if len(errors) > 0 {
		return GrpcService_GoogleGrpc_ChannelCredentialsMultiError(errors)
	}

	return nil
}

// GrpcService_GoogleGrpc_ChannelCredentialsMultiError is an error wrapping
// multiple validation errors returned by
// GrpcService_GoogleGrpc_ChannelCredentials.ValidateAll() if the designated
// constraints aren't met.
type GrpcService_GoogleGrpc_ChannelCredentialsMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m GrpcService_GoogleGrpc_ChannelCredentialsMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m GrpcService_GoogleGrpc_ChannelCredentialsMultiError) AllErrors() []error { return m }

// GrpcService_GoogleGrpc_ChannelCredentialsValidationError is the validation
// error returned by GrpcService_GoogleGrpc_ChannelCredentials.Validate if the
// designated constraints aren't met.
type GrpcService_GoogleGrpc_ChannelCredentialsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GrpcService_GoogleGrpc_ChannelCredentialsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GrpcService_GoogleGrpc_ChannelCredentialsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GrpcService_GoogleGrpc_ChannelCredentialsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GrpcService_GoogleGrpc_ChannelCredentialsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GrpcService_GoogleGrpc_ChannelCredentialsValidationError) ErrorName() string {
	return "GrpcService_GoogleGrpc_ChannelCredentialsValidationError"
}

// Error satisfies the builtin error interface
func (e GrpcService_GoogleGrpc_ChannelCredentialsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGrpcService_GoogleGrpc_ChannelCredentials.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GrpcService_GoogleGrpc_ChannelCredentialsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GrpcService_GoogleGrpc_ChannelCredentialsValidationError{}

// Validate checks the field values on GrpcService_GoogleGrpc_CallCredentials
// with the rules defined in the proto definition for this message. If any
// rules are violated, the first error encountered is returned, or nil if
// there are no violations.
func (m *GrpcService_GoogleGrpc_CallCredentials) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on
// GrpcService_GoogleGrpc_CallCredentials with the rules defined in the proto
// definition for this message. If any rules are violated, the result is a
// list of violation errors wrapped in
// GrpcService_GoogleGrpc_CallCredentialsMultiError, or nil if none found.
func (m *GrpcService_GoogleGrpc_CallCredentials) ValidateAll() error {
	return m.validate(true)
}

func (m *GrpcService_GoogleGrpc_CallCredentials) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	switch m.CredentialSpecifier.(type) {

	case *GrpcService_GoogleGrpc_CallCredentials_AccessToken:
		// no validation rules for AccessToken

	case *GrpcService_GoogleGrpc_CallCredentials_GoogleComputeEngine:

		if all {
			switch v := interface{}(m.GetGoogleComputeEngine()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, GrpcService_GoogleGrpc_CallCredentialsValidationError{
						field:  "GoogleComputeEngine",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, GrpcService_GoogleGrpc_CallCredentialsValidationError{
						field:  "GoogleComputeEngine",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetGoogleComputeEngine()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return GrpcService_GoogleGrpc_CallCredentialsValidationError{
					field:  "GoogleComputeEngine",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *GrpcService_GoogleGrpc_CallCredentials_GoogleRefreshToken:
		// no validation rules for GoogleRefreshToken

	case *GrpcService_GoogleGrpc_CallCredentials_ServiceAccountJwtAccess:

		if all {
			switch v := interface{}(m.GetServiceAccountJwtAccess()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, GrpcService_GoogleGrpc_CallCredentialsValidationError{
						field:  "ServiceAccountJwtAccess",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, GrpcService_GoogleGrpc_CallCredentialsValidationError{
						field:  "ServiceAccountJwtAccess",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetServiceAccountJwtAccess()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return GrpcService_GoogleGrpc_CallCredentialsValidationError{
					field:  "ServiceAccountJwtAccess",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *GrpcService_GoogleGrpc_CallCredentials_GoogleIam:

		if all {
			switch v := interface{}(m.GetGoogleIam()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, GrpcService_GoogleGrpc_CallCredentialsValidationError{
						field:  "GoogleIam",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, GrpcService_GoogleGrpc_CallCredentialsValidationError{
						field:  "GoogleIam",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetGoogleIam()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return GrpcService_GoogleGrpc_CallCredentialsValidationError{
					field:  "GoogleIam",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *GrpcService_GoogleGrpc_CallCredentials_FromPlugin:

		if all {
			switch v := interface{}(m.GetFromPlugin()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, GrpcService_GoogleGrpc_CallCredentialsValidationError{
						field:  "FromPlugin",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, GrpcService_GoogleGrpc_CallCredentialsValidationError{
						field:  "FromPlugin",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetFromPlugin()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return GrpcService_GoogleGrpc_CallCredentialsValidationError{
					field:  "FromPlugin",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *GrpcService_GoogleGrpc_CallCredentials_StsService_:

		if all {
			switch v := interface{}(m.GetStsService()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, GrpcService_GoogleGrpc_CallCredentialsValidationError{
						field:  "StsService",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, GrpcService_GoogleGrpc_CallCredentialsValidationError{
						field:  "StsService",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetStsService()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return GrpcService_GoogleGrpc_CallCredentialsValidationError{
					field:  "StsService",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		err := GrpcService_GoogleGrpc_CallCredentialsValidationError{
			field:  "CredentialSpecifier",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)

	}

	if len(errors) > 0 {
		return GrpcService_GoogleGrpc_CallCredentialsMultiError(errors)
	}

	return nil
}

// GrpcService_GoogleGrpc_CallCredentialsMultiError is an error wrapping
// multiple validation errors returned by
// GrpcService_GoogleGrpc_CallCredentials.ValidateAll() if the designated
// constraints aren't met.
type GrpcService_GoogleGrpc_CallCredentialsMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m GrpcService_GoogleGrpc_CallCredentialsMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m GrpcService_GoogleGrpc_CallCredentialsMultiError) AllErrors() []error { return m }

// GrpcService_GoogleGrpc_CallCredentialsValidationError is the validation
// error returned by GrpcService_GoogleGrpc_CallCredentials.Validate if the
// designated constraints aren't met.
type GrpcService_GoogleGrpc_CallCredentialsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GrpcService_GoogleGrpc_CallCredentialsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GrpcService_GoogleGrpc_CallCredentialsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GrpcService_GoogleGrpc_CallCredentialsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GrpcService_GoogleGrpc_CallCredentialsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GrpcService_GoogleGrpc_CallCredentialsValidationError) ErrorName() string {
	return "GrpcService_GoogleGrpc_CallCredentialsValidationError"
}

// Error satisfies the builtin error interface
func (e GrpcService_GoogleGrpc_CallCredentialsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGrpcService_GoogleGrpc_CallCredentials.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GrpcService_GoogleGrpc_CallCredentialsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GrpcService_GoogleGrpc_CallCredentialsValidationError{}

// Validate checks the field values on
// GrpcService_GoogleGrpc_CallCredentials_ServiceAccountJWTAccessCredentials
// with the rules defined in the proto definition for this message. If any
// rules are violated, the first error encountered is returned, or nil if
// there are no violations.
func (m *GrpcService_GoogleGrpc_CallCredentials_ServiceAccountJWTAccessCredentials) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on
// GrpcService_GoogleGrpc_CallCredentials_ServiceAccountJWTAccessCredentials
// with the rules defined in the proto definition for this message. If any
// rules are violated, the result is a list of violation errors wrapped in
// GrpcService_GoogleGrpc_CallCredentials_ServiceAccountJWTAccessCredentialsMultiError,
// or nil if none found.
func (m *GrpcService_GoogleGrpc_CallCredentials_ServiceAccountJWTAccessCredentials) ValidateAll() error {
	return m.validate(true)
}

func (m *GrpcService_GoogleGrpc_CallCredentials_ServiceAccountJWTAccessCredentials) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for JsonKey

	// no validation rules for TokenLifetimeSeconds

	if len(errors) > 0 {
		return GrpcService_GoogleGrpc_CallCredentials_ServiceAccountJWTAccessCredentialsMultiError(errors)
	}

	return nil
}

// GrpcService_GoogleGrpc_CallCredentials_ServiceAccountJWTAccessCredentialsMultiError
// is an error wrapping multiple validation errors returned by
// GrpcService_GoogleGrpc_CallCredentials_ServiceAccountJWTAccessCredentials.ValidateAll()
// if the designated constraints aren't met.
type GrpcService_GoogleGrpc_CallCredentials_ServiceAccountJWTAccessCredentialsMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m GrpcService_GoogleGrpc_CallCredentials_ServiceAccountJWTAccessCredentialsMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m GrpcService_GoogleGrpc_CallCredentials_ServiceAccountJWTAccessCredentialsMultiError) AllErrors() []error {
	return m
}

// GrpcService_GoogleGrpc_CallCredentials_ServiceAccountJWTAccessCredentialsValidationError
// is the validation error returned by
// GrpcService_GoogleGrpc_CallCredentials_ServiceAccountJWTAccessCredentials.Validate
// if the designated constraints aren't met.
type GrpcService_GoogleGrpc_CallCredentials_ServiceAccountJWTAccessCredentialsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GrpcService_GoogleGrpc_CallCredentials_ServiceAccountJWTAccessCredentialsValidationError) Field() string {
	return e.field
}

// Reason function returns reason value.
func (e GrpcService_GoogleGrpc_CallCredentials_ServiceAccountJWTAccessCredentialsValidationError) Reason() string {
	return e.reason
}

// Cause function returns cause value.
func (e GrpcService_GoogleGrpc_CallCredentials_ServiceAccountJWTAccessCredentialsValidationError) Cause() error {
	return e.cause
}

// Key function returns key value.
func (e GrpcService_GoogleGrpc_CallCredentials_ServiceAccountJWTAccessCredentialsValidationError) Key() bool {
	return e.key
}

// ErrorName returns error name.
func (e GrpcService_GoogleGrpc_CallCredentials_ServiceAccountJWTAccessCredentialsValidationError) ErrorName() string {
	return "GrpcService_GoogleGrpc_CallCredentials_ServiceAccountJWTAccessCredentialsValidationError"
}

// Error satisfies the builtin error interface
func (e GrpcService_GoogleGrpc_CallCredentials_ServiceAccountJWTAccessCredentialsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGrpcService_GoogleGrpc_CallCredentials_ServiceAccountJWTAccessCredentials.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GrpcService_GoogleGrpc_CallCredentials_ServiceAccountJWTAccessCredentialsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GrpcService_GoogleGrpc_CallCredentials_ServiceAccountJWTAccessCredentialsValidationError{}

// Validate checks the field values on
// GrpcService_GoogleGrpc_CallCredentials_GoogleIAMCredentials with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *GrpcService_GoogleGrpc_CallCredentials_GoogleIAMCredentials) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on
// GrpcService_GoogleGrpc_CallCredentials_GoogleIAMCredentials with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// GrpcService_GoogleGrpc_CallCredentials_GoogleIAMCredentialsMultiError, or
// nil if none found.
func (m *GrpcService_GoogleGrpc_CallCredentials_GoogleIAMCredentials) ValidateAll() error {
	return m.validate(true)
}

func (m *GrpcService_GoogleGrpc_CallCredentials_GoogleIAMCredentials) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for AuthorizationToken

	// no validation rules for AuthoritySelector

	if len(errors) > 0 {
		return GrpcService_GoogleGrpc_CallCredentials_GoogleIAMCredentialsMultiError(errors)
	}

	return nil
}

// GrpcService_GoogleGrpc_CallCredentials_GoogleIAMCredentialsMultiError is an
// error wrapping multiple validation errors returned by
// GrpcService_GoogleGrpc_CallCredentials_GoogleIAMCredentials.ValidateAll()
// if the designated constraints aren't met.
type GrpcService_GoogleGrpc_CallCredentials_GoogleIAMCredentialsMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m GrpcService_GoogleGrpc_CallCredentials_GoogleIAMCredentialsMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m GrpcService_GoogleGrpc_CallCredentials_GoogleIAMCredentialsMultiError) AllErrors() []error {
	return m
}

// GrpcService_GoogleGrpc_CallCredentials_GoogleIAMCredentialsValidationError
// is the validation error returned by
// GrpcService_GoogleGrpc_CallCredentials_GoogleIAMCredentials.Validate if the
// designated constraints aren't met.
type GrpcService_GoogleGrpc_CallCredentials_GoogleIAMCredentialsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GrpcService_GoogleGrpc_CallCredentials_GoogleIAMCredentialsValidationError) Field() string {
	return e.field
}

// Reason function returns reason value.
func (e GrpcService_GoogleGrpc_CallCredentials_GoogleIAMCredentialsValidationError) Reason() string {
	return e.reason
}

// Cause function returns cause value.
func (e GrpcService_GoogleGrpc_CallCredentials_GoogleIAMCredentialsValidationError) Cause() error {
	return e.cause
}

// Key function returns key value.
func (e GrpcService_GoogleGrpc_CallCredentials_GoogleIAMCredentialsValidationError) Key() bool {
	return e.key
}

// ErrorName returns error name.
func (e GrpcService_GoogleGrpc_CallCredentials_GoogleIAMCredentialsValidationError) ErrorName() string {
	return "GrpcService_GoogleGrpc_CallCredentials_GoogleIAMCredentialsValidationError"
}

// Error satisfies the builtin error interface
func (e GrpcService_GoogleGrpc_CallCredentials_GoogleIAMCredentialsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGrpcService_GoogleGrpc_CallCredentials_GoogleIAMCredentials.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GrpcService_GoogleGrpc_CallCredentials_GoogleIAMCredentialsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GrpcService_GoogleGrpc_CallCredentials_GoogleIAMCredentialsValidationError{}

// Validate checks the field values on
// GrpcService_GoogleGrpc_CallCredentials_MetadataCredentialsFromPlugin with
// the rules defined in the proto definition for this message. If any rules
// are violated, the first error encountered is returned, or nil if there are
// no violations.
func (m *GrpcService_GoogleGrpc_CallCredentials_MetadataCredentialsFromPlugin) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on
// GrpcService_GoogleGrpc_CallCredentials_MetadataCredentialsFromPlugin with
// the rules defined in the proto definition for this message. If any rules
// are violated, the result is a list of violation errors wrapped in
// GrpcService_GoogleGrpc_CallCredentials_MetadataCredentialsFromPluginMultiError,
// or nil if none found.
func (m *GrpcService_GoogleGrpc_CallCredentials_MetadataCredentialsFromPlugin) ValidateAll() error {
	return m.validate(true)
}

func (m *GrpcService_GoogleGrpc_CallCredentials_MetadataCredentialsFromPlugin) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Name

	switch m.ConfigType.(type) {

	case *GrpcService_GoogleGrpc_CallCredentials_MetadataCredentialsFromPlugin_Config:

		if all {
			switch v := interface{}(m.GetConfig()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, GrpcService_GoogleGrpc_CallCredentials_MetadataCredentialsFromPluginValidationError{
						field:  "Config",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, GrpcService_GoogleGrpc_CallCredentials_MetadataCredentialsFromPluginValidationError{
						field:  "Config",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetConfig()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return GrpcService_GoogleGrpc_CallCredentials_MetadataCredentialsFromPluginValidationError{
					field:  "Config",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *GrpcService_GoogleGrpc_CallCredentials_MetadataCredentialsFromPlugin_TypedConfig:

		if all {
			switch v := interface{}(m.GetTypedConfig()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, GrpcService_GoogleGrpc_CallCredentials_MetadataCredentialsFromPluginValidationError{
						field:  "TypedConfig",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, GrpcService_GoogleGrpc_CallCredentials_MetadataCredentialsFromPluginValidationError{
						field:  "TypedConfig",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetTypedConfig()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return GrpcService_GoogleGrpc_CallCredentials_MetadataCredentialsFromPluginValidationError{
					field:  "TypedConfig",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return GrpcService_GoogleGrpc_CallCredentials_MetadataCredentialsFromPluginMultiError(errors)
	}

	return nil
}

// GrpcService_GoogleGrpc_CallCredentials_MetadataCredentialsFromPluginMultiError
// is an error wrapping multiple validation errors returned by
// GrpcService_GoogleGrpc_CallCredentials_MetadataCredentialsFromPlugin.ValidateAll()
// if the designated constraints aren't met.
type GrpcService_GoogleGrpc_CallCredentials_MetadataCredentialsFromPluginMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m GrpcService_GoogleGrpc_CallCredentials_MetadataCredentialsFromPluginMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m GrpcService_GoogleGrpc_CallCredentials_MetadataCredentialsFromPluginMultiError) AllErrors() []error {
	return m
}

// GrpcService_GoogleGrpc_CallCredentials_MetadataCredentialsFromPluginValidationError
// is the validation error returned by
// GrpcService_GoogleGrpc_CallCredentials_MetadataCredentialsFromPlugin.Validate
// if the designated constraints aren't met.
type GrpcService_GoogleGrpc_CallCredentials_MetadataCredentialsFromPluginValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GrpcService_GoogleGrpc_CallCredentials_MetadataCredentialsFromPluginValidationError) Field() string {
	return e.field
}

// Reason function returns reason value.
func (e GrpcService_GoogleGrpc_CallCredentials_MetadataCredentialsFromPluginValidationError) Reason() string {
	return e.reason
}

// Cause function returns cause value.
func (e GrpcService_GoogleGrpc_CallCredentials_MetadataCredentialsFromPluginValidationError) Cause() error {
	return e.cause
}

// Key function returns key value.
func (e GrpcService_GoogleGrpc_CallCredentials_MetadataCredentialsFromPluginValidationError) Key() bool {
	return e.key
}

// ErrorName returns error name.
func (e GrpcService_GoogleGrpc_CallCredentials_MetadataCredentialsFromPluginValidationError) ErrorName() string {
	return "GrpcService_GoogleGrpc_CallCredentials_MetadataCredentialsFromPluginValidationError"
}

// Error satisfies the builtin error interface
func (e GrpcService_GoogleGrpc_CallCredentials_MetadataCredentialsFromPluginValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGrpcService_GoogleGrpc_CallCredentials_MetadataCredentialsFromPlugin.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GrpcService_GoogleGrpc_CallCredentials_MetadataCredentialsFromPluginValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GrpcService_GoogleGrpc_CallCredentials_MetadataCredentialsFromPluginValidationError{}

// Validate checks the field values on
// GrpcService_GoogleGrpc_CallCredentials_StsService with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *GrpcService_GoogleGrpc_CallCredentials_StsService) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on
// GrpcService_GoogleGrpc_CallCredentials_StsService with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in
// GrpcService_GoogleGrpc_CallCredentials_StsServiceMultiError, or nil if none found.
func (m *GrpcService_GoogleGrpc_CallCredentials_StsService) ValidateAll() error {
	return m.validate(true)
}

func (m *GrpcService_GoogleGrpc_CallCredentials_StsService) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for TokenExchangeServiceUri

	// no validation rules for Resource

	// no validation rules for Audience

	// no validation rules for Scope

	// no validation rules for RequestedTokenType

	if len(m.GetSubjectTokenPath()) < 1 {
		err := GrpcService_GoogleGrpc_CallCredentials_StsServiceValidationError{
			field:  "SubjectTokenPath",
			reason: "value length must be at least 1 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(m.GetSubjectTokenType()) < 1 {
		err := GrpcService_GoogleGrpc_CallCredentials_StsServiceValidationError{
			field:  "SubjectTokenType",
			reason: "value length must be at least 1 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	// no validation rules for ActorTokenPath

	// no validation rules for ActorTokenType

	if len(errors) > 0 {
		return GrpcService_GoogleGrpc_CallCredentials_StsServiceMultiError(errors)
	}

	return nil
}

// GrpcService_GoogleGrpc_CallCredentials_StsServiceMultiError is an error
// wrapping multiple validation errors returned by
// GrpcService_GoogleGrpc_CallCredentials_StsService.ValidateAll() if the
// designated constraints aren't met.
type GrpcService_GoogleGrpc_CallCredentials_StsServiceMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m GrpcService_GoogleGrpc_CallCredentials_StsServiceMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m GrpcService_GoogleGrpc_CallCredentials_StsServiceMultiError) AllErrors() []error { return m }

// GrpcService_GoogleGrpc_CallCredentials_StsServiceValidationError is the
// validation error returned by
// GrpcService_GoogleGrpc_CallCredentials_StsService.Validate if the
// designated constraints aren't met.
type GrpcService_GoogleGrpc_CallCredentials_StsServiceValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GrpcService_GoogleGrpc_CallCredentials_StsServiceValidationError) Field() string {
	return e.field
}

// Reason function returns reason value.
func (e GrpcService_GoogleGrpc_CallCredentials_StsServiceValidationError) Reason() string {
	return e.reason
}

// Cause function returns cause value.
func (e GrpcService_GoogleGrpc_CallCredentials_StsServiceValidationError) Cause() error {
	return e.cause
}

// Key function returns key value.
func (e GrpcService_GoogleGrpc_CallCredentials_StsServiceValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GrpcService_GoogleGrpc_CallCredentials_StsServiceValidationError) ErrorName() string {
	return "GrpcService_GoogleGrpc_CallCredentials_StsServiceValidationError"
}

// Error satisfies the builtin error interface
func (e GrpcService_GoogleGrpc_CallCredentials_StsServiceValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGrpcService_GoogleGrpc_CallCredentials_StsService.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GrpcService_GoogleGrpc_CallCredentials_StsServiceValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GrpcService_GoogleGrpc_CallCredentials_StsServiceValidationError{}
