/*
 * Copyright The OpenTelemetry Authors
 * SPDX-License-Identifier: Apache-2.0
 */

/*
 * DO NOT EDIT, this is an Auto-generated file from:
 * buildscripts/semantic-convention/templates/registry/semantic_attributes-h.j2
 */

#pragma once

#include "opentelemetry/common/macros.h"
#include "opentelemetry/version.h"

OPENTELEMETRY_BEGIN_NAMESPACE
namespace semconv
{
namespace user_agent
{

/**
  Name of the user-agent extracted from original. Usually refers to the browser's name.
  <p>
  <a href="https://uaparser.dev/#demo">Example</a> of extracting browser's name from original
  string. In the case of using a user-agent for non-browser products, such as microservices with
  multiple names/versions inside the @code user_agent.original @endcode, the most significant name
  SHOULD be selected. In such a scenario it should align with @code user_agent.version @endcode
 */
static constexpr const char *kUserAgentName = "user_agent.name";

/**
  Value of the <a href="https://www.rfc-editor.org/rfc/rfc9110.html#field.user-agent">HTTP
  User-Agent</a> header sent by the client.
 */
static constexpr const char *kUserAgentOriginal = "user_agent.original";

/**
  Human readable operating system name.
  <p>
  For mapping user agent strings to OS names, libraries such as <a
  href="https://github.com/ua-parser">ua-parser</a> can be utilized.
 */
static constexpr const char *kUserAgentOsName = "user_agent.os.name";

/**
  The version string of the operating system as defined in <a
  href="/docs/resource/README.md#version-attributes">Version Attributes</a>. <p> For mapping user
  agent strings to OS versions, libraries such as <a
  href="https://github.com/ua-parser">ua-parser</a> can be utilized.
 */
static constexpr const char *kUserAgentOsVersion = "user_agent.os.version";

/**
  Specifies the category of synthetic traffic, such as tests or bots.
  <p>
  This attribute MAY be derived from the contents of the @code user_agent.original @endcode
  attribute. Components that populate the attribute are responsible for determining what they
  consider to be synthetic bot or test traffic. This attribute can either be set for
  self-identification purposes, or on telemetry detected to be generated as a result of a synthetic
  request. This attribute is useful for distinguishing between genuine client traffic and synthetic
  traffic generated by bots or tests.
 */
static constexpr const char *kUserAgentSyntheticType = "user_agent.synthetic.type";

/**
  Version of the user-agent extracted from original. Usually refers to the browser's version
  <p>
  <a href="https://uaparser.dev/#demo">Example</a> of extracting browser's version from original
  string. In the case of using a user-agent for non-browser products, such as microservices with
  multiple names/versions inside the @code user_agent.original @endcode, the most significant
  version SHOULD be selected. In such a scenario it should align with @code user_agent.name @endcode
 */
static constexpr const char *kUserAgentVersion = "user_agent.version";

namespace UserAgentSyntheticTypeValues
{
/**
  Bot source.
 */
static constexpr const char *kBot = "bot";

/**
  Synthetic test source.
 */
static constexpr const char *kTest = "test";

}  // namespace UserAgentSyntheticTypeValues

}  // namespace user_agent
}  // namespace semconv
OPENTELEMETRY_END_NAMESPACE
