/*
  This file is licensed to You under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with
  the License.  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/
package org.xmlunit.assertj3;

import org.assertj.core.api.WritableAssertionInfo;

import java.util.Map;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPathFactory;

/**
 * @since XMLUnit 2.8.3
 */
class XmlAssertConfig {

    final WritableAssertionInfo info;
    DocumentBuilderFactory dbf;
    XPathFactory xpf;
    Map<String, String> prefix2Uri;

    XmlAssertConfig(WritableAssertionInfo info) {
        this.info = info;
    }
}
