## In order to help us understand your issue, please follow the guide below

- You will be asked some questions and requested to provide some information, please read them **carefully** and answer honestly
- Put an `x` into all the boxes `[ ]` relevant to your issue (like this: `[x]`)
- Please fill in the sections relevant to your issue and delete the rest.
- Use the *Preview* tab to see what your issue will actually look like

---

### What is the purpose of your issue?
- [ ] Site Support Request: Lightspark does not work correctly on a specific website.
- [ ] Bug: Lightspark has the same problem across multiple websites or SWF files.
- [ ] Feature request: a request for new features or support for new platforms, *not sites or SWF files*.
- [ ] Question, Comment, or Suggestion
- [ ] If none of the above apply, check this box.

---

### The following sections should be filled in based on the purpose listed above. Erase any section (the contents between triple ---) that does not apply.

---

### If this issue is a *bug report* or *site support request*:

#### Provide the complete URL of the page with the issue here:

URL of page

#### If it is possible to download the file and run it with the command line, please provide a link to the file here:

URL of file

#### Provide the complete set of instructions required to reproduce the problem:

1. Load the page.
2. *Insert second action here*
3. *Insert third action, and so on*

#### What kind of failure is your issue?

- [ ] **Fault**: You receive a black window instead of the flash content with a white text such as ``We're sorry, Lightspark encountered an as yet unsupported Flash file``
- [ ] **Crash**: The window disappears or your browser crashes with a message such as ``A tab has crashed``
- [ ] **Broken**: Lightspark shows something, but most of the file is not usable
- [ ] **Glitch**: Lightspark shows something and most of the file is usable, but things are missing or wrong compared to official Flash.
- [ ] **Performance**: Lightspark runs slow or uses lots of memory trying to play the file

#### Provide the Lightspark version

Output of ``lightspark -v``:

```
Paste output here
```

#### What operating system are you are running on?

- [ ] Windows 7, 8 or 10
- [ ] Windows XP, Vista or older
- [ ] Linux: *<specify distro and version here, such as Ubuntu 18.04>*
- [ ] Mac OS X: *<specify version here, such as 10.8.1>*
- [ ] Other: *<specify OS and version here>*

#### How are you are running Lightspark?

- [ ] Browser plugin for Chrome or Chromium: *<specify Chromium version here>*
- [ ] Browser plugin for Waterfox: *<specify Waterfox version here>*
- [ ] Browser plugin for other browser: *<specify browser and version here>*
- [ ] Lightspark executable on the command line

#### Which of these actions you have taken to help debug the problem?

- [ ] I attached a screen shot of the problem to this issue
- [ ] I have a backtrace listing and pasted it in the bottom section of this issue (*hint: hitting Ctrl-C after a crash will copy it to the clipboard*)
- [ ] I have reproduced the problem using the Lightspark command line executable
- [ ] I ran `lightspark -l 4` on the command line and am attaching logs to this issue (*hint: if they are too big, zip them*)

---

### If this issue is a *feature request*:

Identify the type of request:

- [ ] Support for a new OS: *<name the operating system here>*
- [ ] Support for a new browser: *<name the operating system here>*
- [ ] Support for embedding in an application: *<name the application here>*

---

### If this issue is a *question, comment, or suggestion*:

Identify the subject of this issue:

- [ ] The documentation of how to use Lightspark, including the wiki
- [ ] The build instructions to compile Lightspark from source
- [ ] The project and how it is managed (people, process, and so on)
- [ ] Other subject matter not listed

---

### Description of your issue

*Explanation of your issue in arbitrary form goes here.*
