# fm.awk

File manager written in awk

## Preview

[![asciicast](https://asciinema.org/a/9YDmY7GhnV7ku2yRhGJlQa8l4.svg)](https://asciinema.org/a/9YDmY7GhnV7ku2yRhGJlQa8l4)

## Browsing

- cd on exit: `cd $(command fm.awk)`
- last path: `export LASTPATH="$HOME/.cache/lastpath"; cd $(cat -u $LASTPATH) && $TERMINAL -e fm.awk`

## Key bindings

```
NUMBERS:
	[num] - move cursor to entry [num]
	[num]+G - Go to page [num]

NAVIGATION:
	k/↑ - up                      j/↓ - down
	l/→ - right                   h/← - left
	Ctrl-f - Half Page Down       Ctrl-u - Half Page Up
	n/PageDown - PageDown         p/PageUp - PageUp
	g/Home - first page           G/End - last page
	H - first entry               L - last entry
	M - middle entry

MODES:
	/ - search
	: - commandline mode
	    commandline mode special function:
	        {}: represent selected files/directories
	        tab completion on path: start with ' /', use tab to complete on that path
	        tab completion on cmd: completion based on command history
	            ><: enter selecting mode for directory (choose ./ to confirm destination)

SELECTION:
	␣ - bulk (de-)selection       S - bulk (de-)selection all
	s - show selected

PREVIEW:
	v - toggle preview
	> - more directory ratio      < - less directory ratio

MISC:
	r - refresh                   a - actions
	- - previous directory        ! - spawn shell
	. - toggle hidden             ? - show keybinds
```

## Actions

- [x] Bulk selection
- [x] Bulk selection all
- [x] Directory / File preview
- Actions:
    - History

Try to use those file manipulation function with cmd mode

## Configuration

edit `fm.awk`, modify the first configuration section:

```awk
    ###################
    #  Configuration  #
    ###################

    OPENER = ( ENVIRON["FMAWK_OPENER"] == "" ? ( ENVIRON["OSTYPE"] ~ /darwin.*/ ? "open" : "xdg-open" ) : ENVIRON["FMAWK_OPENER"] )
    LASTPATH = ( ENVIRON["LASTPATH"] == "" ? ( ENVIRON["HOME"] "/.cache/lastpath" ) : ENVIRON["LASTPATH"] )
    HISTORY = ( ENVIRON["HISTORY"] == "" ? ( ENVIRON["HOME"] "/.cache/history" ) : ENVIRON["HISTORY"] )
    CMDHIST = ( ENVIRON["CMDHIST"] == "" ? ( ENVIRON["HOME"] "/.cache/cmdhist" ) : ENVIRON["CMDHIST"] )
    CACHE = ( ENVIRON["CACHE"] == "" ? ( ENVIRON["HOME"] "/.cache/imagecache" ) : ENVIRON["CACHE"] )
    FIFO_UEBERZUG = ENVIRON["FIFO_UEBERZUG"]
    FMAWK_PREVIEWER = ENVIRON["FMAWK_PREVIEWER"]
    PREVIEW = 0
    HIDDEN = 0
    RATIO = 0.35
    HIST_MAX = 5000
    SUBSEP = ","
```

- `OPENER` is the default file opener. External opener script can be set by environmental variable `FMAWK_OPENER`.
- `LASTPATH` is path which `fm.awk` were last time.
- `HISTORY` is the history for directory visited.
- `CMDHIST` is the command line history, which only the unique command will be left.
- `CACHE` is the cache file path for image file generated by preview.
- `FIFO_UEBERZUG` and `FMAWK_PREVIEWER` will be automatically set by shell wrapper `fmawk`.
- `PREVIEW` is indicator for review or not, boolean.
- `RATIO` is the ratio for directory / preview.
- `HIST_MAX` is the maximum number of `HISTORY`.

## cmd mode

- `:cd /path/to/destination`
    - can be relative: `:cd ../../` goes to parents two tiers
- `:cmd ` on each selected item.
    - e.g., After selection, `:chmod +x` to give execution permission on selected entries.
- `:cmd {} destination` to replace `{}` with each selected item and execute the whole command.
    - e.g., After selection, `:mv {} ~` will move selected item to `$HOME` directory.
- File manipulation is done by this process:
    - Select file/dir => go to destination by browsing => type `:cmd {} ./` to execute `cmd` on selected file to destination
    - e.g. select files, go to destination and type `:mv {} ./`.
- `cmd` can be shell alias (`bash` and `zsh` confirmed. `fish` not sure).
- tab completion on `:cd ` and search (`/`)
- tab completion on path:
    - press tab or shift-tab for path completion => press Enter to confirm current completion, and go the either of the following two path:
        - => press tab / shift-tab for next-level path completion.
        - => press Enter again to confirm current path and exit cmd mode.
- tab completion on command line mode based on command line history.
- left / right arrow to move cursor; up / down arrow to access command line history.

### `scripts`

`scripts` stores the shell scripts that serve some purposes that I think is better to be done externally. They are

- `decompressall`: go through all compression files in current directory and decompress all of them.
- `renameall`: rename all files and directories in current directory. The list of all files/directories will open in default text editor using `xdg-open` files/directories will be renamed line by line.

## TODO

- [x] Image preview (start using ueberzug)
- [x] Make preview script be independent
- [x] Able to redraw by `SIGWINCH`.
- [x] Tab completion on path
- [ ] Make cmd bottom line can be scrollable horizontally even when the string is over the dimension
- [ ] Eliminate action menu by implementing all of those in cmd mode
