// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-11-28/models"
)

// NewLockProjectParams creates a new LockProjectParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewLockProjectParams() *LockProjectParams {
	return &LockProjectParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewLockProjectParamsWithTimeout creates a new LockProjectParams object
// with the ability to set a timeout on a request.
func NewLockProjectParamsWithTimeout(timeout time.Duration) *LockProjectParams {
	return &LockProjectParams{
		timeout: timeout,
	}
}

// NewLockProjectParamsWithContext creates a new LockProjectParams object
// with the ability to set a context for a request.
func NewLockProjectParamsWithContext(ctx context.Context) *LockProjectParams {
	return &LockProjectParams{
		Context: ctx,
	}
}

// NewLockProjectParamsWithHTTPClient creates a new LockProjectParams object
// with the ability to set a custom HTTPClient for a request.
func NewLockProjectParamsWithHTTPClient(client *http.Client) *LockProjectParams {
	return &LockProjectParams{
		HTTPClient: client,
	}
}

/*
LockProjectParams contains all the parameters to send to the API endpoint

	for the lock project operation.

	Typically these are written to a http.Request.
*/
type LockProjectParams struct {

	// Body.
	Body *models.SecretServiceLockProjectBody

	// OrganizationID.
	OrganizationID string

	// ProjectID.
	ProjectID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the lock project params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *LockProjectParams) WithDefaults() *LockProjectParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the lock project params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *LockProjectParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the lock project params
func (o *LockProjectParams) WithTimeout(timeout time.Duration) *LockProjectParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the lock project params
func (o *LockProjectParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the lock project params
func (o *LockProjectParams) WithContext(ctx context.Context) *LockProjectParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the lock project params
func (o *LockProjectParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the lock project params
func (o *LockProjectParams) WithHTTPClient(client *http.Client) *LockProjectParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the lock project params
func (o *LockProjectParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the lock project params
func (o *LockProjectParams) WithBody(body *models.SecretServiceLockProjectBody) *LockProjectParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the lock project params
func (o *LockProjectParams) SetBody(body *models.SecretServiceLockProjectBody) {
	o.Body = body
}

// WithOrganizationID adds the organizationID to the lock project params
func (o *LockProjectParams) WithOrganizationID(organizationID string) *LockProjectParams {
	o.SetOrganizationID(organizationID)
	return o
}

// SetOrganizationID adds the organizationId to the lock project params
func (o *LockProjectParams) SetOrganizationID(organizationID string) {
	o.OrganizationID = organizationID
}

// WithProjectID adds the projectID to the lock project params
func (o *LockProjectParams) WithProjectID(projectID string) *LockProjectParams {
	o.SetProjectID(projectID)
	return o
}

// SetProjectID adds the projectId to the lock project params
func (o *LockProjectParams) SetProjectID(projectID string) {
	o.ProjectID = projectID
}

// WriteToRequest writes these params to a swagger request
func (o *LockProjectParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param organization_id
	if err := r.SetPathParam("organization_id", o.OrganizationID); err != nil {
		return err
	}

	// path param project_id
	if err := r.SetPathParam("project_id", o.ProjectID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
