// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-11-28/models"
)

// NewCreateTwilioIntegrationParams creates a new CreateTwilioIntegrationParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewCreateTwilioIntegrationParams() *CreateTwilioIntegrationParams {
	return &CreateTwilioIntegrationParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewCreateTwilioIntegrationParamsWithTimeout creates a new CreateTwilioIntegrationParams object
// with the ability to set a timeout on a request.
func NewCreateTwilioIntegrationParamsWithTimeout(timeout time.Duration) *CreateTwilioIntegrationParams {
	return &CreateTwilioIntegrationParams{
		timeout: timeout,
	}
}

// NewCreateTwilioIntegrationParamsWithContext creates a new CreateTwilioIntegrationParams object
// with the ability to set a context for a request.
func NewCreateTwilioIntegrationParamsWithContext(ctx context.Context) *CreateTwilioIntegrationParams {
	return &CreateTwilioIntegrationParams{
		Context: ctx,
	}
}

// NewCreateTwilioIntegrationParamsWithHTTPClient creates a new CreateTwilioIntegrationParams object
// with the ability to set a custom HTTPClient for a request.
func NewCreateTwilioIntegrationParamsWithHTTPClient(client *http.Client) *CreateTwilioIntegrationParams {
	return &CreateTwilioIntegrationParams{
		HTTPClient: client,
	}
}

/*
CreateTwilioIntegrationParams contains all the parameters to send to the API endpoint

	for the create twilio integration operation.

	Typically these are written to a http.Request.
*/
type CreateTwilioIntegrationParams struct {

	// Body.
	Body *models.SecretServiceCreateTwilioIntegrationBody

	// OrganizationID.
	OrganizationID string

	// ProjectID.
	ProjectID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the create twilio integration params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CreateTwilioIntegrationParams) WithDefaults() *CreateTwilioIntegrationParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the create twilio integration params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CreateTwilioIntegrationParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the create twilio integration params
func (o *CreateTwilioIntegrationParams) WithTimeout(timeout time.Duration) *CreateTwilioIntegrationParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the create twilio integration params
func (o *CreateTwilioIntegrationParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the create twilio integration params
func (o *CreateTwilioIntegrationParams) WithContext(ctx context.Context) *CreateTwilioIntegrationParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the create twilio integration params
func (o *CreateTwilioIntegrationParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the create twilio integration params
func (o *CreateTwilioIntegrationParams) WithHTTPClient(client *http.Client) *CreateTwilioIntegrationParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the create twilio integration params
func (o *CreateTwilioIntegrationParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the create twilio integration params
func (o *CreateTwilioIntegrationParams) WithBody(body *models.SecretServiceCreateTwilioIntegrationBody) *CreateTwilioIntegrationParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the create twilio integration params
func (o *CreateTwilioIntegrationParams) SetBody(body *models.SecretServiceCreateTwilioIntegrationBody) {
	o.Body = body
}

// WithOrganizationID adds the organizationID to the create twilio integration params
func (o *CreateTwilioIntegrationParams) WithOrganizationID(organizationID string) *CreateTwilioIntegrationParams {
	o.SetOrganizationID(organizationID)
	return o
}

// SetOrganizationID adds the organizationId to the create twilio integration params
func (o *CreateTwilioIntegrationParams) SetOrganizationID(organizationID string) {
	o.OrganizationID = organizationID
}

// WithProjectID adds the projectID to the create twilio integration params
func (o *CreateTwilioIntegrationParams) WithProjectID(projectID string) *CreateTwilioIntegrationParams {
	o.SetProjectID(projectID)
	return o
}

// SetProjectID adds the projectId to the create twilio integration params
func (o *CreateTwilioIntegrationParams) SetProjectID(projectID string) {
	o.ProjectID = projectID
}

// WriteToRequest writes these params to a swagger request
func (o *CreateTwilioIntegrationParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param organization_id
	if err := r.SetPathParam("organization_id", o.OrganizationID); err != nil {
		return err
	}

	// path param project_id
	if err := r.SetPathParam("project_id", o.ProjectID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
