// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// LogService20210330StreamingDestination StreamingDestination represents a destination to which to stream log events to.
//
// swagger:model log_service_20210330StreamingDestination
type LogService20210330StreamingDestination struct {

	// cloudwatch logs provider
	CloudwatchLogsProvider *LogService20210330StreamingCloudwatchLogsProvider `json:"cloudwatch_logs_provider,omitempty"`

	// datadog provider
	DatadogProvider *LogService20210330StreamingDatadogProvider `json:"datadog_provider,omitempty"`

	// filter is the filter attached to the destination.
	Filter *LogService20210330StreamingFilter `json:"filter,omitempty"`

	// id is the destination's ID.
	ID string `json:"id,omitempty"`

	// last_error_message is the error message from the last streaming attempt.
	// It's an empty string if the last attempt succeeded.
	LastErrorMessage string `json:"last_error_message,omitempty"`

	// name represents the human readable name of a destination
	Name string `json:"name,omitempty"`

	// organization_id is the ID of the organization holding the destination.
	OrganizationID string `json:"organization_id,omitempty"`

	// source
	Source *LogService20210330DestinationSource `json:"source,omitempty"`

	// splunk cloud provider
	SplunkCloudProvider *LogService20210330StreamingSplunkCloudProvider `json:"splunk_cloud_provider,omitempty"`

	// status destination status field error/pending/success
	Status string `json:"status,omitempty"`
}

// Validate validates this log service 20210330 streaming destination
func (m *LogService20210330StreamingDestination) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCloudwatchLogsProvider(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDatadogProvider(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFilter(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSource(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSplunkCloudProvider(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LogService20210330StreamingDestination) validateCloudwatchLogsProvider(formats strfmt.Registry) error {
	if swag.IsZero(m.CloudwatchLogsProvider) { // not required
		return nil
	}

	if m.CloudwatchLogsProvider != nil {
		if err := m.CloudwatchLogsProvider.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cloudwatch_logs_provider")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("cloudwatch_logs_provider")
			}
			return err
		}
	}

	return nil
}

func (m *LogService20210330StreamingDestination) validateDatadogProvider(formats strfmt.Registry) error {
	if swag.IsZero(m.DatadogProvider) { // not required
		return nil
	}

	if m.DatadogProvider != nil {
		if err := m.DatadogProvider.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("datadog_provider")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("datadog_provider")
			}
			return err
		}
	}

	return nil
}

func (m *LogService20210330StreamingDestination) validateFilter(formats strfmt.Registry) error {
	if swag.IsZero(m.Filter) { // not required
		return nil
	}

	if m.Filter != nil {
		if err := m.Filter.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("filter")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("filter")
			}
			return err
		}
	}

	return nil
}

func (m *LogService20210330StreamingDestination) validateSource(formats strfmt.Registry) error {
	if swag.IsZero(m.Source) { // not required
		return nil
	}

	if m.Source != nil {
		if err := m.Source.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("source")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("source")
			}
			return err
		}
	}

	return nil
}

func (m *LogService20210330StreamingDestination) validateSplunkCloudProvider(formats strfmt.Registry) error {
	if swag.IsZero(m.SplunkCloudProvider) { // not required
		return nil
	}

	if m.SplunkCloudProvider != nil {
		if err := m.SplunkCloudProvider.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("splunk_cloud_provider")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("splunk_cloud_provider")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this log service 20210330 streaming destination based on the context it is used
func (m *LogService20210330StreamingDestination) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCloudwatchLogsProvider(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDatadogProvider(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFilter(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSource(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSplunkCloudProvider(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LogService20210330StreamingDestination) contextValidateCloudwatchLogsProvider(ctx context.Context, formats strfmt.Registry) error {

	if m.CloudwatchLogsProvider != nil {

		if swag.IsZero(m.CloudwatchLogsProvider) { // not required
			return nil
		}

		if err := m.CloudwatchLogsProvider.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cloudwatch_logs_provider")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("cloudwatch_logs_provider")
			}
			return err
		}
	}

	return nil
}

func (m *LogService20210330StreamingDestination) contextValidateDatadogProvider(ctx context.Context, formats strfmt.Registry) error {

	if m.DatadogProvider != nil {

		if swag.IsZero(m.DatadogProvider) { // not required
			return nil
		}

		if err := m.DatadogProvider.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("datadog_provider")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("datadog_provider")
			}
			return err
		}
	}

	return nil
}

func (m *LogService20210330StreamingDestination) contextValidateFilter(ctx context.Context, formats strfmt.Registry) error {

	if m.Filter != nil {

		if swag.IsZero(m.Filter) { // not required
			return nil
		}

		if err := m.Filter.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("filter")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("filter")
			}
			return err
		}
	}

	return nil
}

func (m *LogService20210330StreamingDestination) contextValidateSource(ctx context.Context, formats strfmt.Registry) error {

	if m.Source != nil {

		if swag.IsZero(m.Source) { // not required
			return nil
		}

		if err := m.Source.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("source")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("source")
			}
			return err
		}
	}

	return nil
}

func (m *LogService20210330StreamingDestination) contextValidateSplunkCloudProvider(ctx context.Context, formats strfmt.Registry) error {

	if m.SplunkCloudProvider != nil {

		if swag.IsZero(m.SplunkCloudProvider) { // not required
			return nil
		}

		if err := m.SplunkCloudProvider.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("splunk_cloud_provider")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("splunk_cloud_provider")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LogService20210330StreamingDestination) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LogService20210330StreamingDestination) UnmarshalBinary(b []byte) error {
	var res LogService20210330StreamingDestination
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
