// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// LogService20210330StoreRequest log service 20210330 store request
//
// swagger:model log_service_20210330StoreRequest
type LogService20210330StoreRequest struct {

	// entries is the batch of log entries to store.
	Entries []*LogService20210330LogEntry `json:"entries"`

	// stream identifies the log stream this request's batch of log entries is a
	// part of.
	Stream *LogService20210330LogStream `json:"stream,omitempty"`
}

// Validate validates this log service 20210330 store request
func (m *LogService20210330StoreRequest) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateEntries(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStream(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LogService20210330StoreRequest) validateEntries(formats strfmt.Registry) error {
	if swag.IsZero(m.Entries) { // not required
		return nil
	}

	for i := 0; i < len(m.Entries); i++ {
		if swag.IsZero(m.Entries[i]) { // not required
			continue
		}

		if m.Entries[i] != nil {
			if err := m.Entries[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("entries" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("entries" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *LogService20210330StoreRequest) validateStream(formats strfmt.Registry) error {
	if swag.IsZero(m.Stream) { // not required
		return nil
	}

	if m.Stream != nil {
		if err := m.Stream.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("stream")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("stream")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this log service 20210330 store request based on the context it is used
func (m *LogService20210330StoreRequest) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateEntries(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStream(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LogService20210330StoreRequest) contextValidateEntries(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Entries); i++ {

		if m.Entries[i] != nil {

			if swag.IsZero(m.Entries[i]) { // not required
				return nil
			}

			if err := m.Entries[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("entries" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("entries" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *LogService20210330StoreRequest) contextValidateStream(ctx context.Context, formats strfmt.Registry) error {

	if m.Stream != nil {

		if swag.IsZero(m.Stream) { // not required
			return nil
		}

		if err := m.Stream.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("stream")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("stream")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LogService20210330StoreRequest) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LogService20210330StoreRequest) UnmarshalBinary(b []byte) error {
	var res LogService20210330StoreRequest
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
