// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-waypoint-service/preview/2024-11-22/models"
)

// WaypointServiceDeleteApplicationTemplate4Reader is a Reader for the WaypointServiceDeleteApplicationTemplate4 structure.
type WaypointServiceDeleteApplicationTemplate4Reader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointServiceDeleteApplicationTemplate4Reader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointServiceDeleteApplicationTemplate4OK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointServiceDeleteApplicationTemplate4Default(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointServiceDeleteApplicationTemplate4OK creates a WaypointServiceDeleteApplicationTemplate4OK with default headers values
func NewWaypointServiceDeleteApplicationTemplate4OK() *WaypointServiceDeleteApplicationTemplate4OK {
	return &WaypointServiceDeleteApplicationTemplate4OK{}
}

/*
WaypointServiceDeleteApplicationTemplate4OK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointServiceDeleteApplicationTemplate4OK struct {
	Payload models.HashicorpCloudWaypointDeleteApplicationTemplateResponse
}

// IsSuccess returns true when this waypoint service delete application template4 o k response has a 2xx status code
func (o *WaypointServiceDeleteApplicationTemplate4OK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint service delete application template4 o k response has a 3xx status code
func (o *WaypointServiceDeleteApplicationTemplate4OK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint service delete application template4 o k response has a 4xx status code
func (o *WaypointServiceDeleteApplicationTemplate4OK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint service delete application template4 o k response has a 5xx status code
func (o *WaypointServiceDeleteApplicationTemplate4OK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint service delete application template4 o k response a status code equal to that given
func (o *WaypointServiceDeleteApplicationTemplate4OK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the waypoint service delete application template4 o k response
func (o *WaypointServiceDeleteApplicationTemplate4OK) Code() int {
	return 200
}

func (o *WaypointServiceDeleteApplicationTemplate4OK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /waypoint/2024-11-22/organizations/{namespace.location.organization_id}/projects/{namespace.location.project_id}/templates/by-name/{application_template.name}][%d] waypointServiceDeleteApplicationTemplate4OK %s", 200, payload)
}

func (o *WaypointServiceDeleteApplicationTemplate4OK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /waypoint/2024-11-22/organizations/{namespace.location.organization_id}/projects/{namespace.location.project_id}/templates/by-name/{application_template.name}][%d] waypointServiceDeleteApplicationTemplate4OK %s", 200, payload)
}

func (o *WaypointServiceDeleteApplicationTemplate4OK) GetPayload() models.HashicorpCloudWaypointDeleteApplicationTemplateResponse {
	return o.Payload
}

func (o *WaypointServiceDeleteApplicationTemplate4OK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointServiceDeleteApplicationTemplate4Default creates a WaypointServiceDeleteApplicationTemplate4Default with default headers values
func NewWaypointServiceDeleteApplicationTemplate4Default(code int) *WaypointServiceDeleteApplicationTemplate4Default {
	return &WaypointServiceDeleteApplicationTemplate4Default{
		_statusCode: code,
	}
}

/*
WaypointServiceDeleteApplicationTemplate4Default describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointServiceDeleteApplicationTemplate4Default struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this waypoint service delete application template4 default response has a 2xx status code
func (o *WaypointServiceDeleteApplicationTemplate4Default) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint service delete application template4 default response has a 3xx status code
func (o *WaypointServiceDeleteApplicationTemplate4Default) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint service delete application template4 default response has a 4xx status code
func (o *WaypointServiceDeleteApplicationTemplate4Default) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint service delete application template4 default response has a 5xx status code
func (o *WaypointServiceDeleteApplicationTemplate4Default) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint service delete application template4 default response a status code equal to that given
func (o *WaypointServiceDeleteApplicationTemplate4Default) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the waypoint service delete application template4 default response
func (o *WaypointServiceDeleteApplicationTemplate4Default) Code() int {
	return o._statusCode
}

func (o *WaypointServiceDeleteApplicationTemplate4Default) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /waypoint/2024-11-22/organizations/{namespace.location.organization_id}/projects/{namespace.location.project_id}/templates/by-name/{application_template.name}][%d] WaypointService_DeleteApplicationTemplate4 default %s", o._statusCode, payload)
}

func (o *WaypointServiceDeleteApplicationTemplate4Default) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /waypoint/2024-11-22/organizations/{namespace.location.organization_id}/projects/{namespace.location.project_id}/templates/by-name/{application_template.name}][%d] WaypointService_DeleteApplicationTemplate4 default %s", o._statusCode, payload)
}

func (o *WaypointServiceDeleteApplicationTemplate4Default) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *WaypointServiceDeleteApplicationTemplate4Default) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
