// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-11-28/models"
)

// ListRandomIntegrationsReader is a Reader for the ListRandomIntegrations structure.
type ListRandomIntegrationsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ListRandomIntegrationsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewListRandomIntegrationsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewListRandomIntegrationsDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewListRandomIntegrationsOK creates a ListRandomIntegrationsOK with default headers values
func NewListRandomIntegrationsOK() *ListRandomIntegrationsOK {
	return &ListRandomIntegrationsOK{}
}

/*
ListRandomIntegrationsOK describes a response with status code 200, with default header values.

A successful response.
*/
type ListRandomIntegrationsOK struct {
	Payload *models.Secrets20231128ListRandomIntegrationsResponse
}

// IsSuccess returns true when this list random integrations o k response has a 2xx status code
func (o *ListRandomIntegrationsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this list random integrations o k response has a 3xx status code
func (o *ListRandomIntegrationsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this list random integrations o k response has a 4xx status code
func (o *ListRandomIntegrationsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this list random integrations o k response has a 5xx status code
func (o *ListRandomIntegrationsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this list random integrations o k response a status code equal to that given
func (o *ListRandomIntegrationsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the list random integrations o k response
func (o *ListRandomIntegrationsOK) Code() int {
	return 200
}

func (o *ListRandomIntegrationsOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/random/config][%d] listRandomIntegrationsOK %s", 200, payload)
}

func (o *ListRandomIntegrationsOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/random/config][%d] listRandomIntegrationsOK %s", 200, payload)
}

func (o *ListRandomIntegrationsOK) GetPayload() *models.Secrets20231128ListRandomIntegrationsResponse {
	return o.Payload
}

func (o *ListRandomIntegrationsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Secrets20231128ListRandomIntegrationsResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewListRandomIntegrationsDefault creates a ListRandomIntegrationsDefault with default headers values
func NewListRandomIntegrationsDefault(code int) *ListRandomIntegrationsDefault {
	return &ListRandomIntegrationsDefault{
		_statusCode: code,
	}
}

/*
ListRandomIntegrationsDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type ListRandomIntegrationsDefault struct {
	_statusCode int

	Payload *models.GooglerpcStatus
}

// IsSuccess returns true when this list random integrations default response has a 2xx status code
func (o *ListRandomIntegrationsDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this list random integrations default response has a 3xx status code
func (o *ListRandomIntegrationsDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this list random integrations default response has a 4xx status code
func (o *ListRandomIntegrationsDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this list random integrations default response has a 5xx status code
func (o *ListRandomIntegrationsDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this list random integrations default response a status code equal to that given
func (o *ListRandomIntegrationsDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the list random integrations default response
func (o *ListRandomIntegrationsDefault) Code() int {
	return o._statusCode
}

func (o *ListRandomIntegrationsDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/random/config][%d] ListRandomIntegrations default %s", o._statusCode, payload)
}

func (o *ListRandomIntegrationsDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/random/config][%d] ListRandomIntegrations default %s", o._statusCode, payload)
}

func (o *ListRandomIntegrationsDefault) GetPayload() *models.GooglerpcStatus {
	return o.Payload
}

func (o *ListRandomIntegrationsDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GooglerpcStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
