// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-11-28/models"
)

// DeleteConfluentIntegrationReader is a Reader for the DeleteConfluentIntegration structure.
type DeleteConfluentIntegrationReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DeleteConfluentIntegrationReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDeleteConfluentIntegrationOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDeleteConfluentIntegrationDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDeleteConfluentIntegrationOK creates a DeleteConfluentIntegrationOK with default headers values
func NewDeleteConfluentIntegrationOK() *DeleteConfluentIntegrationOK {
	return &DeleteConfluentIntegrationOK{}
}

/*
DeleteConfluentIntegrationOK describes a response with status code 200, with default header values.

A successful response.
*/
type DeleteConfluentIntegrationOK struct {
	Payload models.Secrets20231128DeleteConfluentIntegrationResponse
}

// IsSuccess returns true when this delete confluent integration o k response has a 2xx status code
func (o *DeleteConfluentIntegrationOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this delete confluent integration o k response has a 3xx status code
func (o *DeleteConfluentIntegrationOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete confluent integration o k response has a 4xx status code
func (o *DeleteConfluentIntegrationOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete confluent integration o k response has a 5xx status code
func (o *DeleteConfluentIntegrationOK) IsServerError() bool {
	return false
}

// IsCode returns true when this delete confluent integration o k response a status code equal to that given
func (o *DeleteConfluentIntegrationOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the delete confluent integration o k response
func (o *DeleteConfluentIntegrationOK) Code() int {
	return 200
}

func (o *DeleteConfluentIntegrationOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/confluent/config/{name}][%d] deleteConfluentIntegrationOK %s", 200, payload)
}

func (o *DeleteConfluentIntegrationOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/confluent/config/{name}][%d] deleteConfluentIntegrationOK %s", 200, payload)
}

func (o *DeleteConfluentIntegrationOK) GetPayload() models.Secrets20231128DeleteConfluentIntegrationResponse {
	return o.Payload
}

func (o *DeleteConfluentIntegrationOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteConfluentIntegrationDefault creates a DeleteConfluentIntegrationDefault with default headers values
func NewDeleteConfluentIntegrationDefault(code int) *DeleteConfluentIntegrationDefault {
	return &DeleteConfluentIntegrationDefault{
		_statusCode: code,
	}
}

/*
DeleteConfluentIntegrationDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type DeleteConfluentIntegrationDefault struct {
	_statusCode int

	Payload *models.GooglerpcStatus
}

// IsSuccess returns true when this delete confluent integration default response has a 2xx status code
func (o *DeleteConfluentIntegrationDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this delete confluent integration default response has a 3xx status code
func (o *DeleteConfluentIntegrationDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this delete confluent integration default response has a 4xx status code
func (o *DeleteConfluentIntegrationDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this delete confluent integration default response has a 5xx status code
func (o *DeleteConfluentIntegrationDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this delete confluent integration default response a status code equal to that given
func (o *DeleteConfluentIntegrationDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the delete confluent integration default response
func (o *DeleteConfluentIntegrationDefault) Code() int {
	return o._statusCode
}

func (o *DeleteConfluentIntegrationDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/confluent/config/{name}][%d] DeleteConfluentIntegration default %s", o._statusCode, payload)
}

func (o *DeleteConfluentIntegrationDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/confluent/config/{name}][%d] DeleteConfluentIntegration default %s", o._statusCode, payload)
}

func (o *DeleteConfluentIntegrationDefault) GetPayload() *models.GooglerpcStatus {
	return o.Payload
}

func (o *DeleteConfluentIntegrationDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GooglerpcStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
