// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-11-28/models"
)

// CreateSyncReader is a Reader for the CreateSync structure.
type CreateSyncReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CreateSyncReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewCreateSyncOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewCreateSyncDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewCreateSyncOK creates a CreateSyncOK with default headers values
func NewCreateSyncOK() *CreateSyncOK {
	return &CreateSyncOK{}
}

/*
CreateSyncOK describes a response with status code 200, with default header values.

A successful response.
*/
type CreateSyncOK struct {
	Payload *models.Secrets20231128CreateSyncResponse
}

// IsSuccess returns true when this create sync o k response has a 2xx status code
func (o *CreateSyncOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this create sync o k response has a 3xx status code
func (o *CreateSyncOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create sync o k response has a 4xx status code
func (o *CreateSyncOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this create sync o k response has a 5xx status code
func (o *CreateSyncOK) IsServerError() bool {
	return false
}

// IsCode returns true when this create sync o k response a status code equal to that given
func (o *CreateSyncOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the create sync o k response
func (o *CreateSyncOK) Code() int {
	return 200
}

func (o *CreateSyncOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/syncs][%d] createSyncOK %s", 200, payload)
}

func (o *CreateSyncOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/syncs][%d] createSyncOK %s", 200, payload)
}

func (o *CreateSyncOK) GetPayload() *models.Secrets20231128CreateSyncResponse {
	return o.Payload
}

func (o *CreateSyncOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Secrets20231128CreateSyncResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateSyncDefault creates a CreateSyncDefault with default headers values
func NewCreateSyncDefault(code int) *CreateSyncDefault {
	return &CreateSyncDefault{
		_statusCode: code,
	}
}

/*
CreateSyncDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type CreateSyncDefault struct {
	_statusCode int

	Payload *models.GooglerpcStatus
}

// IsSuccess returns true when this create sync default response has a 2xx status code
func (o *CreateSyncDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this create sync default response has a 3xx status code
func (o *CreateSyncDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this create sync default response has a 4xx status code
func (o *CreateSyncDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this create sync default response has a 5xx status code
func (o *CreateSyncDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this create sync default response a status code equal to that given
func (o *CreateSyncDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the create sync default response
func (o *CreateSyncDefault) Code() int {
	return o._statusCode
}

func (o *CreateSyncDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/syncs][%d] CreateSync default %s", o._statusCode, payload)
}

func (o *CreateSyncDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/syncs][%d] CreateSync default %s", o._statusCode, payload)
}

func (o *CreateSyncDefault) GetPayload() *models.GooglerpcStatus {
	return o.Payload
}

func (o *CreateSyncDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GooglerpcStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
