// Code generated by go-swagger; DO NOT EDIT.

package packer_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-packer-service/stable/2023-01-01/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// PackerServiceGetVersionReader is a Reader for the PackerServiceGetVersion structure.
type PackerServiceGetVersionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PackerServiceGetVersionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewPackerServiceGetVersionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewPackerServiceGetVersionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewPackerServiceGetVersionOK creates a PackerServiceGetVersionOK with default headers values
func NewPackerServiceGetVersionOK() *PackerServiceGetVersionOK {
	return &PackerServiceGetVersionOK{}
}

/*
PackerServiceGetVersionOK describes a response with status code 200, with default header values.

A successful response.
*/
type PackerServiceGetVersionOK struct {
	Payload *models.HashicorpCloudPacker20230101GetVersionResponse
}

// IsSuccess returns true when this packer service get version o k response has a 2xx status code
func (o *PackerServiceGetVersionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this packer service get version o k response has a 3xx status code
func (o *PackerServiceGetVersionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this packer service get version o k response has a 4xx status code
func (o *PackerServiceGetVersionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this packer service get version o k response has a 5xx status code
func (o *PackerServiceGetVersionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this packer service get version o k response a status code equal to that given
func (o *PackerServiceGetVersionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the packer service get version o k response
func (o *PackerServiceGetVersionOK) Code() int {
	return 200
}

func (o *PackerServiceGetVersionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}/versions/{fingerprint}][%d] packerServiceGetVersionOK %s", 200, payload)
}

func (o *PackerServiceGetVersionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}/versions/{fingerprint}][%d] packerServiceGetVersionOK %s", 200, payload)
}

func (o *PackerServiceGetVersionOK) GetPayload() *models.HashicorpCloudPacker20230101GetVersionResponse {
	return o.Payload
}

func (o *PackerServiceGetVersionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudPacker20230101GetVersionResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPackerServiceGetVersionDefault creates a PackerServiceGetVersionDefault with default headers values
func NewPackerServiceGetVersionDefault(code int) *PackerServiceGetVersionDefault {
	return &PackerServiceGetVersionDefault{
		_statusCode: code,
	}
}

/*
PackerServiceGetVersionDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type PackerServiceGetVersionDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this packer service get version default response has a 2xx status code
func (o *PackerServiceGetVersionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this packer service get version default response has a 3xx status code
func (o *PackerServiceGetVersionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this packer service get version default response has a 4xx status code
func (o *PackerServiceGetVersionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this packer service get version default response has a 5xx status code
func (o *PackerServiceGetVersionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this packer service get version default response a status code equal to that given
func (o *PackerServiceGetVersionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the packer service get version default response
func (o *PackerServiceGetVersionDefault) Code() int {
	return o._statusCode
}

func (o *PackerServiceGetVersionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}/versions/{fingerprint}][%d] PackerService_GetVersion default %s", o._statusCode, payload)
}

func (o *PackerServiceGetVersionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}/versions/{fingerprint}][%d] PackerService_GetVersion default %s", o._statusCode, payload)
}

func (o *PackerServiceGetVersionDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *PackerServiceGetVersionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
