import { BoxProps, MantineColor, MantineGradient, MantineRadius, MantineSize, PolymorphicFactory, StylesApiProps } from '../../core';
import { AvatarGroup } from './AvatarGroup/AvatarGroup';
export type AvatarStylesNames = 'root' | 'placeholder' | 'image';
export type AvatarVariant = 'filled' | 'light' | 'gradient' | 'outline' | 'transparent' | 'default' | 'white';
export type AvatarCssVariables = {
    root: '--avatar-size' | '--avatar-radius' | '--avatar-bg' | '--avatar-color' | '--avatar-bd';
};
export interface AvatarProps extends BoxProps, StylesApiProps<AvatarFactory> {
    /** Width and height of the avatar, numbers are converted to rem, `'md'` by default */
    size?: MantineSize | (string & {}) | number;
    /** Key of `theme.radius` or any valid CSS value to set border-radius, `'100%'` by default */
    radius?: MantineRadius;
    /** Key of `theme.colors` or any valid CSS color, default value is `'gray'`  */
    color?: MantineColor | 'initials';
    /** Gradient configuration used when `variant="gradient"`, default value is `theme.defaultGradient` */
    gradient?: MantineGradient;
    /** Image url, if the image cannot be loaded or `src={null}`, then placeholder is displayed instead */
    src?: string | null;
    /** Image `alt` attribute, also used as `title` attribute for placeholder */
    alt?: string;
    /** `img` tag attributes */
    imageProps?: React.ComponentPropsWithoutRef<'img'>;
    /** Avatar placeholder, displayed when `src={null}` or when the image cannot be loaded */
    children?: React.ReactNode;
    /** Determines whether text color with filled variant should depend on `background-color`. If luminosity of the `color` prop is less than `theme.luminosityThreshold`, then `theme.white` will be used for text color, otherwise `theme.black`. Overrides `theme.autoContrast`. */
    autoContrast?: boolean;
    /** Name of the user. When `src` is not set, used to display initials and to generate color when `color="initials"` is set. */
    name?: string;
    /** An array of colors that can be used for autogenerated initials. By default, all default Mantine colors can be used except gray and dark. */
    allowedInitialsColors?: MantineColor[];
}
export type AvatarFactory = PolymorphicFactory<{
    props: AvatarProps;
    defaultRef: HTMLDivElement;
    defaultComponent: 'div';
    stylesNames: AvatarStylesNames;
    vars: AvatarCssVariables;
    variant: AvatarVariant;
    staticComponents: {
        Group: typeof AvatarGroup;
    };
}>;
export declare const Avatar: (<C = "div">(props: import("../../core").PolymorphicComponentProps<C, AvatarProps>) => React.ReactElement) & Omit<import("react").FunctionComponent<(AvatarProps & {
    component?: any;
} & Omit<Omit<any, "ref">, "component" | keyof AvatarProps> & {
    ref?: any;
    renderRoot?: (props: any) => any;
}) | (AvatarProps & {
    component: React.ElementType;
    renderRoot?: (props: Record<string, any>) => any;
})>, never> & import("../../core/factory/factory").ThemeExtend<{
    props: AvatarProps;
    defaultRef: HTMLDivElement;
    defaultComponent: "div";
    stylesNames: AvatarStylesNames;
    vars: AvatarCssVariables;
    variant: AvatarVariant;
    staticComponents: {
        Group: typeof AvatarGroup;
    };
}> & import("../../core/factory/factory").ComponentClasses<{
    props: AvatarProps;
    defaultRef: HTMLDivElement;
    defaultComponent: "div";
    stylesNames: AvatarStylesNames;
    vars: AvatarCssVariables;
    variant: AvatarVariant;
    staticComponents: {
        Group: typeof AvatarGroup;
    };
}> & import("../../core/factory/polymorphic-factory").PolymorphicComponentWithProps<{
    props: AvatarProps;
    defaultRef: HTMLDivElement;
    defaultComponent: "div";
    stylesNames: AvatarStylesNames;
    vars: AvatarCssVariables;
    variant: AvatarVariant;
    staticComponents: {
        Group: typeof AvatarGroup;
    };
}> & {
    Group: typeof AvatarGroup;
};
