# cache2k version 0.20 release notes

## Possible breakages

  * JMX support was removed from `cache2k-core` module. For JMX support add 
    the dependency `cache2k-ee` instead.
  * An expiry time span of 0 (e.g. CacheConfig.setExpirySeconds) switches off caching.
    It is not possible to override this with and entry specific time calculation.
  * Interface MutableEntry removed. This was currently unused anyways.
  * Interface CacheBulkSource removed. This was currently unused anyways.

## New and Noteworthy

  * no more external dependencies
  * android support: cache2k-api and cache2k-core is compatible with Java 1.6 and android.
    Extra features needed in enterprise environments separated to module cache2k-ee.
  * Revised interface to control entry specific expiry (EntryExpiryCalculator)
  * Configuration / tunable properties
  * Support sharp timing/expiry
  * Bulk API fixes and defined exception handling
  * General infrastructure for off heap caching and persistence (alpha state)  
  * Provide a iterator for all cache entries. Iterator supports full concurrency
  * Simple logging infrastructure
  * Optimized cache configuration. The builder can now build the cache or just a configuration object

## Fixes and Improvements

  * Reorganized and improved locking scheme

## API Changes and new methods

  * add: CacheConfig.setEternal() / CacheBuilder.eternal()
  * add: Cache.iterator()
  * add: Cache.peekEntry()
  * add: Cache.getEntry()
  * add: Cache.putIfAbsent()
  * add: CacheConfig.setExpiryMillis()
  * add: CacheBuilder.setExpiryDuration()
  * new: EntryExpiryCalculator, replaces EntryRefreshController
  * new: ValueWithExpiryTime
  * new: BulkCacheSource configurable via CacheBuilder, replaces ExperimentalBulkCacheSource
  * Annotations javax.annotation.Nonnull and javax.annotation.NotNull removed. 
    Dependency on JSR305 removed. This is not a final standard.
 
Deprecated:

  * EntryRefreshController
  * AutoEntryRefreshController
  * CacheConfig.setExpirySeconds
  * CacheBuilder.expirySecs
  * CacheBuilder.expiryMillis
  
Deprecated methods and interfaces will be removed with release 0.22 or later.   
