// Copyright (c) 2025 Marshall A. Greenblatt. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
//    * Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
//    * Redistributions in binary form must reproduce the above
// copyright notice, this list of conditions and the following disclaimer
// in the documentation and/or other materials provided with the
// distribution.
//    * Neither the name of Google Inc. nor the name Chromium Embedded
// Framework nor the names of its contributors may be used to endorse
// or promote products derived from this software without specific prior
// written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// ---------------------------------------------------------------------------
//
// This file is generated by the make_pack_header.py tool.
//

#ifndef CEF_INCLUDE_CEF_PACK_STRINGS_H_
#define CEF_INCLUDE_CEF_PACK_STRINGS_H_
#pragma once

// ---------------------------------------------------------------------------
// From blink_accessibility_strings.h:

#define IDS_AX_UNLABELED_IMAGE_ROLE_DESCRIPTION 46500
#define IDS_AX_IMAGE_ELIGIBLE_FOR_ANNOTATION 46503
#define IDS_AX_IMAGE_ANNOTATION_PENDING 46504
#define IDS_AX_IMAGE_ANNOTATION_ADULT 46505
#define IDS_AX_IMAGE_ANNOTATION_NO_DESCRIPTION 46506
#define IDS_AX_IMAGE_ANNOTATION_OCR_CONTEXT 46507
#define IDS_AX_IMAGE_ANNOTATION_DESCRIPTION_CONTEXT 46508
#define IDS_AX_IMAGE_ANNOTATION_ICON_PLUS 46509
#define IDS_AX_IMAGE_ANNOTATION_ICON_ARROW_BACKWARD 46510
#define IDS_AX_IMAGE_ANNOTATION_ICON_ARROW_FORWARD 46511
#define IDS_AX_IMAGE_ANNOTATION_ICON_CALL 46512
#define IDS_AX_IMAGE_ANNOTATION_ICON_CHAT 46513
#define IDS_AX_IMAGE_ANNOTATION_ICON_CHECK 46514
#define IDS_AX_IMAGE_ANNOTATION_ICON_X 46515
#define IDS_AX_IMAGE_ANNOTATION_ICON_DELETE 46516
#define IDS_AX_IMAGE_ANNOTATION_ICON_EDIT 46517
#define IDS_AX_IMAGE_ANNOTATION_ICON_EMOJI 46518
#define IDS_AX_IMAGE_ANNOTATION_ICON_END_CALL 46519
#define IDS_AX_IMAGE_ANNOTATION_ICON_V_DOWNWARD 46520
#define IDS_AX_IMAGE_ANNOTATION_ICON_HEART 46521
#define IDS_AX_IMAGE_ANNOTATION_ICON_HOME 46522
#define IDS_AX_IMAGE_ANNOTATION_ICON_INFO 46523
#define IDS_AX_IMAGE_ANNOTATION_ICON_LAUNCH_APPS 46524
#define IDS_AX_IMAGE_ANNOTATION_ICON_THUMBS_UP 46525
#define IDS_AX_IMAGE_ANNOTATION_ICON_THREE_BARS 46526
#define IDS_AX_IMAGE_ANNOTATION_ICON_THREE_DOTS 46527
#define IDS_AX_IMAGE_ANNOTATION_ICON_NOTIFICATIONS 46528
#define IDS_AX_IMAGE_ANNOTATION_ICON_PAUSE 46529
#define IDS_AX_IMAGE_ANNOTATION_ICON_PLAY 46530
#define IDS_AX_IMAGE_ANNOTATION_ICON_REFRESH 46531
#define IDS_AX_IMAGE_ANNOTATION_ICON_MAGNIFYING_GLASS 46532
#define IDS_AX_IMAGE_ANNOTATION_ICON_SEND 46533
#define IDS_AX_IMAGE_ANNOTATION_ICON_SETTINGS 46534
#define IDS_AX_IMAGE_ANNOTATION_ICON_SHARE 46535
#define IDS_AX_IMAGE_ANNOTATION_ICON_STAR 46536
#define IDS_AX_IMAGE_ANNOTATION_ICON_TAKE_PHOTO 46537
#define IDS_AX_IMAGE_ANNOTATION_ICON_TIME 46538
#define IDS_AX_IMAGE_ANNOTATION_ICON_VIDEOCAM 46539
#define IDS_AX_IMAGE_ANNOTATION_ICON_EXPAND 46540
#define IDS_AX_IMAGE_ANNOTATION_ICON_CONTRACT 46541
#define IDS_AX_IMAGE_ANNOTATION_ICON_GOOGLE 46542
#define IDS_AX_IMAGE_ANNOTATION_ICON_TWITTER 46543
#define IDS_AX_IMAGE_ANNOTATION_ICON_FACEBOOK 46544
#define IDS_AX_IMAGE_ANNOTATION_ICON_ASSISTANT 46545
#define IDS_AX_IMAGE_ANNOTATION_ICON_WEATHER 46546
#define IDS_AX_IMAGE_ANNOTATION_ICON_SHOPPING_CART 46547
#define IDS_AX_IMAGE_ANNOTATION_ICON_UPLOAD 46548
#define IDS_AX_IMAGE_ANNOTATION_ICON_QUESTION 46549
#define IDS_AX_IMAGE_ANNOTATION_ICON_MIC 46550
#define IDS_AX_IMAGE_ANNOTATION_ICON_MIC_MUTE 46551
#define IDS_AX_IMAGE_ANNOTATION_ICON_GALLERY 46552
#define IDS_AX_IMAGE_ANNOTATION_ICON_COMPASS 46553
#define IDS_AX_IMAGE_ANNOTATION_ICON_PEOPLE 46554
#define IDS_AX_IMAGE_ANNOTATION_ICON_ARROW_UPWARD 46555
#define IDS_AX_IMAGE_ANNOTATION_ICON_ENVELOPE 46556
#define IDS_AX_IMAGE_ANNOTATION_ICON_EMOJI_FACE 46557
#define IDS_AX_IMAGE_ANNOTATION_ICON_PAPERCLIP 46558
#define IDS_AX_IMAGE_ANNOTATION_ICON_CAST 46559
#define IDS_AX_IMAGE_ANNOTATION_ICON_VOLUME_UP 46560
#define IDS_AX_IMAGE_ANNOTATION_ICON_VOLUME_DOWN 46561
#define IDS_AX_IMAGE_ANNOTATION_ICON_VOLUME_STATE 46562
#define IDS_AX_IMAGE_ANNOTATION_ICON_VOLUME_MUTE 46563
#define IDS_AX_IMAGE_ANNOTATION_ICON_STOP 46564
#define IDS_AX_IMAGE_ANNOTATION_ICON_SHOPPING_BAG 46565
#define IDS_AX_IMAGE_ANNOTATION_ICON_LIST 46566
#define IDS_AX_IMAGE_ANNOTATION_ICON_LOCATION 46567
#define IDS_AX_IMAGE_ANNOTATION_ICON_CALENDAR 46568
#define IDS_AX_IMAGE_ANNOTATION_ICON_THUMBS_DOWN 46569
#define IDS_AX_IMAGE_ANNOTATION_ICON_HEADSET 46570
#define IDS_AX_IMAGE_ANNOTATION_ICON_REDO 46571
#define IDS_AX_IMAGE_ANNOTATION_ICON_UNDO 46572
#define IDS_AX_IMAGE_ANNOTATION_ICON_DOWNLOAD 46573
#define IDS_AX_IMAGE_ANNOTATION_ICON_ARROW_DOWNWARD 46574
#define IDS_AX_IMAGE_ANNOTATION_ICON_V_UPWARD 46575
#define IDS_AX_IMAGE_ANNOTATION_ICON_V_FORWARD 46576
#define IDS_AX_IMAGE_ANNOTATION_ICON_V_BACKWARD 46577
#define IDS_AX_IMAGE_ANNOTATION_ICON_HISTORY 46578
#define IDS_AX_IMAGE_ANNOTATION_ICON_PERSON 46579
#define IDS_AX_IMAGE_ANNOTATION_ICON_HAPPY_FACE 46580
#define IDS_AX_IMAGE_ANNOTATION_ICON_SAD_FACE 46581
#define IDS_AX_IMAGE_ANNOTATION_ICON_MOON 46582
#define IDS_AX_IMAGE_ANNOTATION_ICON_CLOUD 46583
#define IDS_AX_IMAGE_ANNOTATION_ICON_SUN 46584

// ---------------------------------------------------------------------------
// From blink_strings.h:

#define IDS_DETAILS_WITHOUT_SUMMARY_LABEL 46600
#define IDS_FORM_CALENDAR_CLEAR 46601
#define IDS_FORM_CALENDAR_TODAY 46602
#define IDS_FORM_SUBMIT_LABEL 46603
#define IDS_FORM_INPUT_ALT 46604
#define IDS_FORM_RESET_LABEL 46605
#define IDS_FORM_FILE_BUTTON_LABEL 46606
#define IDS_FORM_MULTIPLE_FILES_BUTTON_LABEL 46607
#define IDS_FORM_FILE_NO_FILE_LABEL 46608
#define IDS_FORM_FILE_MULTIPLE_UPLOAD 46609
#define IDS_FORM_OTHER_COLOR_LABEL 46610
#define IDS_FORM_OTHER_DATE_LABEL 46611
#define IDS_FORM_OTHER_MONTH_LABEL 46612
#define IDS_FORM_OTHER_WEEK_LABEL 46613
#define IDS_FORM_PLACEHOLDER_FOR_DAY_OF_MONTH_FIELD 46614
#define IDS_FORM_PLACEHOLDER_FOR_MONTH_FIELD 46615
#define IDS_FORM_PLACEHOLDER_FOR_YEAR_FIELD 46616
#define IDS_FORM_SELECT_MENU_LIST_TEXT 46617
#define IDS_FORM_THIS_MONTH_LABEL 46618
#define IDS_FORM_THIS_WEEK_LABEL 46619
#define IDS_FORM_WEEK_NUMBER_LABEL 46620
#define IDS_AX_CALENDAR_SHOW_DATE_PICKER 46621
#define IDS_AX_CALENDAR_SHOW_DATE_TIME_LOCAL_PICKER 46622
#define IDS_AX_CALENDAR_SHOW_MONTH_PICKER 46623
#define IDS_AX_CALENDAR_SHOW_TIME_PICKER 46624
#define IDS_AX_CALENDAR_SHOW_WEEK_PICKER 46625
#define IDS_AX_CALENDAR_SHOW_MONTH_SELECTOR 46626
#define IDS_AX_CALENDAR_SHOW_NEXT_MONTH 46627
#define IDS_AX_CALENDAR_SHOW_PREVIOUS_MONTH 46628
#define IDS_AX_CALENDAR_WEEK_DESCRIPTION 46629
#define IDS_AX_COLOR_EDIT_BLUE 46630
#define IDS_AX_COLOR_EDIT_GREEN 46631
#define IDS_AX_COLOR_EDIT_HEXADECIMAL 46632
#define IDS_AX_COLOR_EDIT_HUE 46633
#define IDS_AX_COLOR_EDIT_LIGHTNESS 46634
#define IDS_AX_COLOR_EDIT_RED 46635
#define IDS_AX_COLOR_EDIT_SATURATION 46636
#define IDS_AX_COLOR_EYEDROPPER 46637
#define IDS_AX_COLOR_FORMAT_TOGGLER 46638
#define IDS_AX_COLOR_HUE_SLIDER 46639
#define IDS_AX_COLOR_WELL 46640
#define IDS_AX_COLOR_WELL_ROLEDESCRIPTION 46641
#define IDS_AX_AM_PM_FIELD_TEXT 46662
#define IDS_AX_DAY_OF_MONTH_FIELD_TEXT 46663
#define IDS_AX_HOUR_FIELD_TEXT 46664
#define IDS_AX_MEDIA_DEFAULT 46665
#define IDS_AX_MEDIA_AUDIO_ELEMENT 46666
#define IDS_AX_MEDIA_VIDEO_ELEMENT 46667
#define IDS_AX_MEDIA_MUTE_BUTTON 46668
#define IDS_AX_MEDIA_UNMUTE_BUTTON 46669
#define IDS_AX_MEDIA_PLAY_BUTTON 46670
#define IDS_AX_MEDIA_PAUSE_BUTTON 46671
#define IDS_AX_MEDIA_CURRENT_TIME_DISPLAY 46672
#define IDS_AX_MEDIA_TIME_REMAINING_DISPLAY 46673
#define IDS_AX_MEDIA_ENTER_FULL_SCREEN_BUTTON 46674
#define IDS_AX_MEDIA_EXIT_FULL_SCREEN_BUTTON 46675
#define IDS_AX_MEDIA_DISPLAY_CUT_OUT_FULL_SCREEN_BUTTON 46676
#define IDS_AX_MEDIA_ENTER_PICTURE_IN_PICTURE_BUTTON 46677
#define IDS_AX_MEDIA_EXIT_PICTURE_IN_PICTURE_BUTTON 46678
#define IDS_AX_MEDIA_LOADING_PANEL 46679
#define IDS_AX_MEDIA_SHOW_CLOSED_CAPTIONS_MENU_BUTTON 46680
#define IDS_AX_MEDIA_SHOW_AUDIO_DESCRIPTIONS_MENU_BUTTON 46681
#define IDS_AX_MEDIA_SHOW_PLAYBACK_SPEED_MENU_BUTTON 46682
#define IDS_AX_MEDIA_BACK_TO_OPTIONS_BUTTON 46683
#define IDS_AX_MEDIA_CAST_OFF_BUTTON 46684
#define IDS_AX_MEDIA_CAST_ON_BUTTON 46685
#define IDS_AX_MEDIA_DOWNLOAD_BUTTON 46686
#define IDS_AX_MEDIA_OVERFLOW_BUTTON 46687
#define IDS_AX_MEDIA_AUDIO_ELEMENT_HELP 46688
#define IDS_AX_MEDIA_VIDEO_ELEMENT_HELP 46689
#define IDS_AX_MEDIA_AUDIO_SLIDER_HELP 46690
#define IDS_AX_MEDIA_VIDEO_SLIDER_HELP 46691
#define IDS_AX_MEDIA_VOLUME_SLIDER_HELP 46692
#define IDS_AX_MEDIA_CURRENT_TIME_DISPLAY_HELP 46693
#define IDS_AX_MEDIA_TIME_REMAINING_DISPLAY_HELP 46694
#define IDS_AX_MEDIA_OVERFLOW_BUTTON_HELP 46695
#define IDS_AX_MILLISECOND_FIELD_TEXT 46696
#define IDS_AX_MINUTE_FIELD_TEXT 46697
#define IDS_AX_MONTH_FIELD_TEXT 46698
#define IDS_AX_SECOND_FIELD_TEXT 46699
#define IDS_AX_WEEK_OF_YEAR_FIELD_TEXT 46700
#define IDS_AX_YEAR_FIELD_TEXT 46701
#define IDS_AX_OBJECT_SELECTED 46702
#define IDS_AX_OBJECT_NOT_SELECTED 46703
#define IDS_DEBUGGER_PAUSED_IN_ANOTHER_TAB 46704
#define IDS_VIEW_SOURCE_LINE_WRAP 46705
#define IDS_FORM_INPUT_WEEK_TEMPLATE 46706
#define IDS_FORM_VALIDATION_VALUE_MISSING_MULTIPLE_FILE 46707
#define IDS_FORM_VALIDATION_TYPE_MISMATCH 46708
#define IDS_FORM_VALIDATION_TYPE_MISMATCH_EMAIL_EMPTY 46709
#define IDS_FORM_VALIDATION_TYPE_MISMATCH_EMAIL_EMPTY_DOMAIN 46710
#define IDS_FORM_VALIDATION_TYPE_MISMATCH_EMAIL_EMPTY_LOCAL 46711
#define IDS_FORM_VALIDATION_TYPE_MISMATCH_EMAIL_INVALID_DOMAIN 46712
#define IDS_FORM_VALIDATION_TYPE_MISMATCH_EMAIL_INVALID_DOTS 46713
#define IDS_FORM_VALIDATION_TYPE_MISMATCH_EMAIL_INVALID_LOCAL 46714
#define IDS_FORM_VALIDATION_TYPE_MISMATCH_EMAIL_NO_AT_SIGN 46715
#define IDS_FORM_VALIDATION_TYPE_MISMATCH_MULTIPLE_EMAIL 46716
#define IDS_FORM_VALIDATION_VALUE_NOT_EQUAL 46717
#define IDS_FORM_VALIDATION_VALUE_NOT_EQUAL_DATETIME 46718
#define IDS_FORM_VALIDATION_RANGE_UNDERFLOW 46719
#define IDS_FORM_VALIDATION_RANGE_UNDERFLOW_DATETIME 46720
#define IDS_FORM_VALIDATION_RANGE_OVERFLOW 46721
#define IDS_FORM_VALIDATION_RANGE_OVERFLOW_DATETIME 46722
#define IDS_FORM_VALIDATION_REVERSED_RANGE_OUT_OF_RANGE_TIME 46723
#define IDS_FORM_VALIDATION_RANGE_REVERSED 46724
#define IDS_FORM_VALIDATION_RANGE_INVALID_DATETIME 46725
#define IDS_FORM_VALIDATION_BAD_INPUT_DATETIME 46726
#define IDS_FORM_VALIDATION_BAD_INPUT_NUMBER 46727
#define IDS_PRETTY_PRINT_JSON 46728
#define IDS_PERMISSION_REQUEST_CAMERA 46729
#define IDS_PERMISSION_REQUEST_MICROPHONE 46730
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE 46731
#define IDS_PERMISSION_REQUEST_GEOLOCATION 46732
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED 46733
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED 46734
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED 46735
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED 46736
#define IDS_STRONG_PASSWORD_LABEL 46737
#define IDS_FORM_VALIDATION_VALUE_MISSING 46738
#define IDS_FORM_VALIDATION_VALUE_MISSING_CHECKBOX 46739
#define IDS_FORM_VALIDATION_VALUE_MISSING_FILE 46740
#define IDS_FORM_VALIDATION_VALUE_MISSING_RADIO 46741
#define IDS_FORM_VALIDATION_VALUE_MISSING_SELECT 46742
#define IDS_FORM_VALIDATION_TYPE_MISMATCH_EMAIL 46743
#define IDS_FORM_VALIDATION_TYPE_MISMATCH_URL 46744
#define IDS_FORM_VALIDATION_PATTERN_MISMATCH 46745
#define IDS_FORM_VALIDATION_STEP_MISMATCH 46746
#define IDS_FORM_VALIDATION_STEP_MISMATCH_CLOSE_TO_LIMIT 46747
#define IDS_FORM_VALIDATION_TOO_LONG 46748
#define IDS_FORM_VALIDATION_TOO_SHORT 46749
#define IDS_FORM_VALIDATION_TOO_SHORT_PLURAL 46750
#define IDS_MEDIA_SESSION_FILE_SOURCE 46751
#define IDS_MEDIA_OVERFLOW_MENU_CLOSED_CAPTIONS 46752
#define IDS_MEDIA_OVERFLOW_MENU_CLOSED_CAPTIONS_SUBMENU_TITLE 46753
#define IDS_MEDIA_OVERFLOW_MENU_PLAYBACK_SPEED 46754
#define IDS_MEDIA_OVERFLOW_MENU_PLAYBACK_SPEED_SUBMENU_TITLE 46755
#define IDS_MEDIA_OVERFLOW_MENU_PLAYBACK_SPEED_0_25X_TITLE 46756
#define IDS_MEDIA_OVERFLOW_MENU_PLAYBACK_SPEED_0_5X_TITLE 46757
#define IDS_MEDIA_OVERFLOW_MENU_PLAYBACK_SPEED_0_75X_TITLE 46758
#define IDS_MEDIA_OVERFLOW_MENU_PLAYBACK_SPEED_NORMAL_TITLE 46759
#define IDS_MEDIA_OVERFLOW_MENU_PLAYBACK_SPEED_1_25X_TITLE 46760
#define IDS_MEDIA_OVERFLOW_MENU_PLAYBACK_SPEED_1_5X_TITLE 46761
#define IDS_MEDIA_OVERFLOW_MENU_PLAYBACK_SPEED_1_75X_TITLE 46762
#define IDS_MEDIA_OVERFLOW_MENU_PLAYBACK_SPEED_2X_TITLE 46763
#define IDS_MEDIA_OVERFLOW_MENU_CAST 46764
#define IDS_MEDIA_OVERFLOW_MENU_ENTER_FULLSCREEN 46765
#define IDS_MEDIA_OVERFLOW_MENU_EXIT_FULLSCREEN 46766
#define IDS_MEDIA_OVERFLOW_MENU_MUTE 46767
#define IDS_MEDIA_OVERFLOW_MENU_UNMUTE 46768
#define IDS_MEDIA_OVERFLOW_MENU_PLAY 46769
#define IDS_MEDIA_OVERFLOW_MENU_PAUSE 46770
#define IDS_MEDIA_OVERFLOW_MENU_DOWNLOAD 46771
#define IDS_MEDIA_OVERFLOW_MENU_ENTER_PICTURE_IN_PICTURE 46772
#define IDS_MEDIA_OVERFLOW_MENU_EXIT_PICTURE_IN_PICTURE 46773
#define IDS_MEDIA_PICTURE_IN_PICTURE_INTERSTITIAL_TEXT 46774
#define IDS_MEDIA_REMOTING_CAST_TEXT 46775
#define IDS_MEDIA_REMOTING_CAST_TO_UNKNOWN_DEVICE_TEXT 46776
#define IDS_MEDIA_REMOTING_STOP_TEXT 46777
#define IDS_MEDIA_REMOTING_STOP_BY_PLAYBACK_QUALITY_TEXT 46778
#define IDS_MEDIA_REMOTING_STOP_BY_ERROR_TEXT 46779
#define IDS_MEDIA_SCRUBBING_MESSAGE_TEXT 46780
#define IDS_MEDIA_TRACKS_NO_LABEL 46781
#define IDS_MEDIA_TRACKS_OFF 46782
#define IDS_PLUGIN_INITIALIZATION_ERROR 46783
#define IDS_MEDIA_PLAYBACK_ERROR 46784
#define IDS_UNITS_KIBIBYTES 46785
#define IDS_UNITS_MEBIBYTES 46786
#define IDS_UNITS_GIBIBYTES 46787
#define IDS_UNITS_TEBIBYTES 46788
#define IDS_UNITS_PEBIBYTES 46789
#define CONTENT_INVALID_TRUE 46790
#define CONTENT_INVALID_SPELLING 46791
#define CONTENT_INVALID_GRAMMAR 46792

// ---------------------------------------------------------------------------
// From branded_strings.h:

#define IDS_RELAUNCH_CONFIRMATION_DIALOG_TITLE 800
#define IDS_SETTINGS_ABOUT_PROGRAM 801
#define IDS_SETTINGS_GET_HELP_USING_CHROME 802
#define IDS_SETTINGS_UPGRADE_UPDATING 803
#define IDS_SETTINGS_UPGRADE_UPDATING_PERCENT 804
#define IDS_SETTINGS_UPGRADE_SUCCESSFUL_RELAUNCH 805
#define IDS_SETTINGS_UPGRADE_UP_TO_DATE 806
#define IDS_SETTINGS_CHECK_PASSWORDS_ERROR_OFFLINE 810
#define IDS_SETTINGS_CHECK_PASSWORDS_ERROR_SIGNED_OUT 811
#define IDS_SETTINGS_CHECK_PASSWORDS_ERROR_NO_PASSWORDS 812
#define IDS_SETTINGS_CHECK_PASSWORDS_ERROR_QUOTA_LIMIT_GOOGLE_ACCOUNT 813
#define IDS_SETTINGS_CHECK_PASSWORDS_ERROR_QUOTA_LIMIT 814
#define IDS_SETTINGS_CHECK_PASSWORDS_ERROR_GENERIC 815
#define IDS_SETTINGS_NO_COMPROMISED_CREDENTIALS_LABEL 816
#define IDS_SETTINGS_SIGNED_OUT_USER_LABEL 817
#define IDS_SETTINGS_SIGNED_OUT_USER_HAS_COMPROMISED_CREDENTIALS_LABEL 818
#define IDS_SETTINGS_WEAK_PASSWORDS_DESCRIPTION_GENERATION 819
#define IDS_SETTINGS_COMPROMISED_EDIT_DISCLAIMER_DESCRIPTION 820
#define IDS_SETTINGS_DEFAULT_BROWSER_DEFAULT 821
#define IDS_SETTINGS_DEFAULT_BROWSER_MAKE_DEFAULT 822
#define IDS_SETTINGS_DEFAULT_BROWSER_ERROR 823
#define IDS_SETTINGS_DEFAULT_BROWSER_SECONDARY 824
#define IDS_SETTINGS_PRELOAD_PAGES_STANDARD_PRELOADING_WHEN_ON_BULLET_TWO 825
#define IDS_SETTINGS_PRELOAD_PAGES_EXTENDED_PRELOADING_WHEN_ON_BULLET_TWO 826
#define IDS_SETTINGS_PRELOAD_PAGES_EXTENDED_PRELOADING_THINGS_TO_CONSIDER_BULLET_TWO 827
#define IDS_SETTINGS_PRELOAD_PAGES_THINGS_TO_CONSIDER_BULLET_ONE 828
#define IDS_SETTINGS_SPELLING_PREF_DESC 829
#define IDS_SETTINGS_RESTART_TO_APPLY_CHANGES 830
#define IDS_SETTINGS_SIGNIN_ALLOWED 831
#define IDS_SETTINGS_SIGNIN_ALLOWED_DESC 832
#define IDS_SETTINGS_SITE_SETTINGS_PDFS_BLOCKED 833
#define IDS_SETTINGS_SITE_DATA_PAGE_CLEAR_ON_EXIT_RADIO_SUBLABEL 834
#define IDS_SETTINGS_SITE_DATA_PAGE_CLEAR_ON_EXIT_WITH_EXCEPTION_RADIO_SUBLABEL 835
#define IDS_SETTINGS_SITE_DATA_PAGE_DELETE_ON_EXIT_EXCEPTIONS_SUB_HEADING 836
#define IDS_SETTINGS_PRIVACY_GUIDE_PROMO_BODY 837
#define IDS_SETTINGS_PRIVACY_GUIDE_SAFE_BROWSING_CARD_STANDARD_PROTECTION_FEATURE_DESCRIPTION2 838
#define IDS_SETTINGS_PRIVACY_GUIDE_SAFE_BROWSING_CARD_STANDARD_PROTECTION_PRIVACY_DESCRIPTION1 839
#define IDS_SETTINGS_PRIVACY_GUIDE_COMPLETION_CARD_PRIVACY_SANDBOX_SUB_LABEL 840
#define IDS_SETTINGS_PRIVACY_GUIDE_COMPLETION_CARD_WAA_SUB_LABEL 841
#define IDS_SETTINGS_PRIVACY_GUIDE_MSBB_FEATURE_DESCRIPTION3 842
#define IDS_SETTINGS_PRIVACY_GUIDE_MSBB_PRIVACY_DESCRIPTION2 843
#define IDS_SETTINGS_PRIVACY_SANDBOX_LEARN_MORE_DIALOG_TOPICS_TITLE 844
#define IDS_SETTINGS_PRIVACY_SANDBOX_LEARN_MORE_DIALOG_TOPICS_DATA_TYPES 845
#define IDS_SETTINGS_PRIVACY_SANDBOX_LEARN_MORE_DIALOG_TOPICS_DATA_USAGE 846
#define IDS_SETTINGS_PRIVACY_SANDBOX_LEARN_MORE_DIALOG_TOPICS_DATA_MANAGEMENT 847
#define IDS_SETTINGS_PRIVACY_SANDBOX_LEARN_MORE_DIALOG_FLEDGE_DATA_TYPES 848
#define IDS_SETTINGS_PRIVACY_SANDBOX_LEARN_MORE_DIALOG_FLEDGE_DATA_USAGE 849
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_PERSONALIZATION_DIALOG_DESCRIPTION 850
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_PERSONALIZATION_DIALOG_DESCRIPTION_TRIALS_OFF 851
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_PERSONALIZATION_DIALOG_DESCRIPTION_LISTS_EMPTY 852
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_PERSONALIZATION_DIALOG_TOPICS_TITLE 853
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_PERSONALIZATION_DIALOG_TOPICS_LEARN_MORE_1 854
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_PERSONALIZATION_DIALOG_TOPICS_LEARN_MORE_2 855
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_PERSONALIZATION_DIALOG_TOPICS_LEARN_MORE_3 856
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_PERSONALIZATION_DIALOG_FLEDGE_LEARN_MORE_1 857
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_MEASUREMENT_DIALOG_DESCRIPTION 858
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_MEASUREMENT_DIALOG_DESCRIPTION_TRIALS_OFF 859
#define IDS_SETTINGS_SAFETY_CHECK_PARENT_PRIMARY_LABEL_BEFORE 860
#define IDS_SETTINGS_SAFETY_CHECK_UPDATES_FAILED_OFFLINE 861
#define IDS_SETTINGS_SAFETY_CHECK_UPDATES_FAILED 862
#define IDS_SETTINGS_SAFETY_CHECK_UPDATES_UNKNOWN 863
#define IDS_SETTINGS_SAFETY_CHECK_PASSWORDS_SIGNED_OUT 864
#define IDS_SETTINGS_SAFETY_CHECK_SAFE_BROWSING_DISABLED 865
#define IDS_SETTINGS_SAFETY_CHECK_UNUSED_SITE_PERMISSIONS_SETTING_SUBLABEL 866
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_BULLET_TWO 867
#define IDS_SETTINGS_SAFEBROWSING_STANDARD_BULLET_TWO 868
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_WHEN_ON_BULLET_ONE 869
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_LEARN_MORE_LABEL 870
#define IDS_SETTINGS_SECURE_DNS_DESCRIPTION 871
#define IDS_SETTINGS_SYNC_DISCONNECT_DELETE_PROFILE_WARNING_WITH_COUNTS_SINGULAR 872
#define IDS_SETTINGS_SYNC_DISCONNECT_DELETE_PROFILE_WARNING_WITH_COUNTS_PLURAL 873
#define IDS_SETTINGS_SYNC_DISCONNECT_DELETE_PROFILE_WARNING_WITHOUT_COUNTS 874
#define IDS_SETTINGS_CUSTOMIZE_YOUR_CHROME_PROFILE 875
#define IDS_SETTING_NAME_YOUR_PROFILE 876
#define IDS_SETTINGS_PEOPLE_SIGN_IN_PROMPT_SECONDARY_WITH_ACCOUNT 877
#define IDS_SETTINGS_SIGNIN_CHROME_SIGNIN_OPTIONS_TITLE 879
#define IDS_SETTINGS_SIGNIN_CHROME_SIGNIN_OPTIONS_DESC 880
#define IDS_SETTINGS_SYNC_DATA_ENCRYPTED_TEXT 881
#define IDS_SETTINGS_SYNC_DISCONNECT_TITLE 882
#define IDS_SETTINGS_SUGGEST_PREF_DESC 883
#define IDS_SETTINGS_DRIVE_SUGGEST_PREF_DESC 884
#define IDS_SETTINGS_SYNC_SIGN_IN_PROMPT_WITH_NO_ACCOUNT 885
#define IDS_SETTINGS_PERSONALIZE_GOOGLE_SERVICES_DESC 886
#define IDS_SETTINGS_PERSONALIZE_GOOGLE_SERVICES_DESC_WITH_LINKED_SERVICES 887
#define IDS_SETTINGS_PERSONALIZE_GOOGLE_SERVICES_LINKED_SERVICES_DESC 888
#define IDS_SETTINGS_PAGE_CONTENT_THINGS_TO_CONSIDER_BULLET_TWO 889
#define IDS_SETTINGS_PERFORMANCE_MEMORY_SAVER_MODE_SETTING_DESCRIPTION 890
#define IDS_SETTINGS_PERFORMANCE_BATTERY_SAVER_MODE_SETTING_DESCRIPTION 891
#define IDS_SETTINGS_PERFORMANCE_PRELOAD_TOGGLE_SUMMARY 892
#define IDS_SETTINGS_SYSTEM_BACKGROUND_APPS_LABEL 895
#define IDS_SETTINGS_RESET_PROFILE_FEEDBACK 896
#define IDS_SETTINGS_CHROME_CERTIFICATES 897
#define IDS_SETTINGS_CHROME_CERTIFICATES_DESCRIPTION 898
#define IDS_SETTINGS_SAFETY_HUB_ENTRY_POINT_NOTHING_TO_DO 899
#define IDS_SETTINGS_SAFETY_HUB_ENTRY_POINT_HEADER 900
#define IDS_SETTINGS_SAFETY_HUB_EMPTY_STATE_MODULE_SUBHEADER 901
#define IDS_SETTINGS_SAFETY_HUB_VERSION_MODULE_UPPERCASE_NAME 902
#define IDS_SETTINGS_SAFETY_HUB_VERSION_MODULE_LOWERCASE_NAME 903
#define IDS_SETTINGS_SAFETY_HUB_PASSWORD_CHECK_SUBHEADER_NO_PASSWORDS 904
#define IDS_SETTINGS_SAFETY_HUB_USER_EDU_MODULE_HEADER 905
#define IDS_SETTINGS_SAFETY_HUB_USER_EDU_DATA_HEADER 906
#define IDS_SETTINGS_SAFETY_HUB_USER_EDU_DATA_SUBHEADER 907
#define IDS_SETTINGS_SAFETY_HUB_USER_EDU_INCOGNITO_HEADER 908
#define IDS_SETTINGS_SAFETY_HUB_USER_EDU_SAFE_BROWSING_SUBHEADER 909
#define IDS_SETTINGS_SAFETY_HUB_VERSION_CARD_HEADER_RESTART 910
#define IDS_SETTINGS_SAFETY_HUB_VERSION_CARD_HEADER_UPDATED 911
#define IDS_SETTINGS_SAFETY_HUB_VERSION_NAVIGATION_ARIA_LABEL 912
#define IDS_SETTINGS_SAFETY_HUB_VERSION_RELAUNCH_ARIA_LABEL 913
#define IDS_SETTINGS_SAFETY_HUB_UNUSED_SITE_PERMISSIONS_REMOVED_ONE_PERMISSION_LABEL 914
#define IDS_SETTINGS_SAFETY_HUB_UNUSED_SITE_PERMISSIONS_REMOVED_TWO_PERMISSIONS_LABEL 915
#define IDS_SETTINGS_SAFETY_HUB_UNUSED_SITE_PERMISSIONS_REMOVED_THREE_PERMISSIONS_LABEL 916
#define IDS_SETTINGS_SAFETY_HUB_UNUSED_SITE_PERMISSIONS_REMOVED_FOUR_OR_MORE_PERMISSIONS_LABEL 917
#define IDS_SETTINGS_SAFETY_HUB_ABUSIVE_NOTIFICATION_PERMISSIONS_SETTING_SUBLABEL 918
#define IDS_SETTINGS_HTTPS_FIRST_MODE_SUBTITLE 919
#define IDS_SETTINGS_HTTPS_FIRST_MODE_ENABLED_FULL_SUBLABEL 920
#define IDS_SETTINGS_HTTPS_FIRST_MODE_ENABLED_INCOGNITO_SUBLABEL 921
#define IDS_SETTINGS_HTTPS_FIRST_MODE_DISABLED_SUBLABEL 922
#define IDS_PRODUCT_NAME 923
#define IDS_SHORT_PRODUCT_NAME 924
#define IDS_FIRST_RUN_DIALOG_WINDOW_TITLE 930
#define IDS_PRODUCT_LOGO_ENTERPRISE_ALT_TEXT 934
#define IDS_TASK_MANAGER_TITLE 936
#define IDS_SESSION_CRASHED_VIEW_UMA_OPTIN 937
#define IDS_BROWSER_WINDOW_TITLE_FORMAT 938
#define IDS_CAPTIVE_PORTAL_BROWSER_WINDOW_TITLE_FORMAT 939
#define IDS_ACCESSIBLE_BROWSER_WINDOW_TITLE_FORMAT 940
#define IDS_ACCESSIBLE_BETA_BROWSER_WINDOW_TITLE_FORMAT 941
#define IDS_ACCESSIBLE_DEV_BROWSER_WINDOW_TITLE_FORMAT 942
#define IDS_ACCESSIBLE_CANARY_BROWSER_WINDOW_TITLE_FORMAT 943
#define IDS_ABOUT_VERSION_COMPANY_NAME 944
#define IDS_ABOUT_VERSION_COPYRIGHT 945
#define IDS_ABOUT_TERMS_OF_SERVICE 949
#define IDS_LINUX_OBSOLETE 955
#define IDS_ACCNAME_APP 956
#define IDS_BROWSER_SHARING_CLICK_TO_CALL_DIALOG_HELP_TEXT_NO_DEVICES 958
#define IDS_BROWSER_SHARING_CLICK_TO_CALL_DIALOG_HELP_TEXT_NO_DEVICES_ORIGIN 959
#define IDS_BROWSER_SHARING_ERROR_DIALOG_TEXT_DEVICE_NOT_FOUND 960
#define IDS_FR_CUSTOMIZE_DEFAULT_BROWSER 964
#define IDS_STATUS_TRAY_KEEP_CHROME_RUNNING_IN_BACKGROUND 965
#define IDS_CANT_WRITE_USER_DIRECTORY_SUMMARY 966
#define IDS_PROFILE_TOO_NEW_ERROR 968
#define IDS_PREFERENCES_UNREADABLE_ERROR 969
#define IDS_PREFERENCES_CORRUPT_ERROR 970
#define IDS_DESKTOP_SHORTCUT_COMMENT 972
#define IDS_CRASH_RECOVERY_TITLE 973
#define IDS_PASSWORD_GENERATION_PROMPT 975
#define IDS_PASSWORD_MANAGER_ONBOARDING_DETAILS_C 976
#define IDS_PASSWORD_MANAGER_TITLE_BRAND 977
#define IDS_PASSWORD_BUBBLES_PASSWORD_MANAGER_LINK_TEXT_SAVING_ON_DEVICE 978
#define IDS_PASSWORD_MANAGER_SAVE_PASSWORD_SIGNED_OUT_MESSAGE_DESCRIPTION 979
#define IDS_PASSWORD_MANAGER_UPDATE_PASSWORD_SIGNED_OUT_MESSAGE_DESCRIPTION 980
#define IDS_DEFAULT_BROWSER_INFOBAR_TEXT 1003
#define IDS_DEFAULT_BROWSER_INFOBAR_REFRESH_TEXT 1004
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_UNKNOWN_SOURCE 1010
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_WARNING_BLOCKED_LEARN_MORE_LINK 1011
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_DEEP_SCANNING_PROMPT_LOCAL_DECRYPTION 1012
#define IDS_DOWNLOAD_STATUS_CRX_INSTALL_RUNNING 1013
#define IDS_PROMPT_DOWNLOAD_CHANGES_SETTINGS 1014
#define IDS_PROMPT_MALICIOUS_DOWNLOAD_URL 1015
#define IDS_PROMPT_MALICIOUS_DOWNLOAD_CONTENT 1016
#define IDS_BLOCK_REASON_DANGEROUS_DOWNLOAD 1017
#define IDS_BLOCK_REASON_UNWANTED_DOWNLOAD 1018
#define IDS_BLOCK_REASON_PROMPT_FOR_SCANNING 1019
#define IDS_BLOCK_DOWNLOAD_REASON_DANGEROUS_FILETYPE 1020
#define IDS_BLOCK_DOWNLOAD_REASON_DANGEROUS 1021
#define IDS_BLOCK_DOWNLOAD_REASON_DANGEROUS_COOKIE_THEFT 1022
#define IDS_BLOCK_DOWNLOAD_REASON_DANGEROUS_COOKIE_THEFT_AND_ACCOUNT 1023
#define IDS_BLOCK_DOWNLOAD_REASON_UNCOMMON 1024
#define IDS_BLOCK_DOWNLOAD_REASON_UNCOMMON_SUSPICIOUS_ARCHIVE 1025
#define IDS_BLOCK_DOWNLOAD_REASON_POTENTIALLY_UNWANTED 1026
#define IDS_BLOCK_DOWNLOAD_REASON_INSECURE 1027
#define IDS_BLOCK_DOWNLOAD_REASON_UNVERIFIED_NO_SAFE_BROWSING 1028
#define IDS_DOWNLOAD_WARNING_BYPASS_DIALOG_LEARN_MORE_LINK 1029
#define IDS_ABANDON_DOWNLOAD_DIALOG_BROWSER_MESSAGE 1030
#define IDS_MISSING_GOOGLE_API_KEYS 1032
#define IDS_EXTENSION_INSTALLED_HEADING 1033
#define IDS_EXTENSION_UNINSTALL_PROMPT_REMOVE_DATA_CHECKBOX 1034
#define IDS_EXTENSION_ALERT_ITEM_BLOCKLISTED_MALWARE 1035
#define IDS_EXTENSIONS_ALERT_ITEM_BLOCKLISTED_MALWARE_TITLE 1036
#define IDS_SAFETY_CHECK_EXTENSIONS_MALWARE 1037
#define IDS_SAFETY_CHECK_EXTENSIONS_POLICY_VIOLATION 1038
#define IDS_SAFETY_CHECK_EXTENSIONS_UNPUBLISHED 1039
#define IDS_EXTENSIONS_SAFETY_CHECK_PRIMARY_LABEL 1040
#define IDS_EXTENSIONS_SAFETY_CHECK_OFFSTORE 1041
#define IDS_EXTENSIONS_SAFETY_CHECK_OFFSTORE_ON 1042
#define IDS_EXTENSIONS_SAFETY_CHECK_OFFSTORE_OFF 1043
#define IDS_EXTENSIONS_SAFETY_CHECK_NO_PRIVACY_PRACTICES 1044
#define IDS_EXTENSIONS_SC_DESCRIPTION 1045
#define IDS_EXTENSIONS_ITEM_SHOW_ACCESS_REQUESTS_IN_TOOLBAR 1046
#define IDS_EXTENSIONS_INCOGNITO_WARNING 1047
#define IDS_EXTENSIONS_UNINSTALL 1048
#define IDS_EXTENSIONS_SHORTCUT_SCOPE_IN_CHROME 1049
#define IDS_EXTENSIONS_MULTIPLE_UNSUPPORTED_DISABLED_BODY 1050
#define IDS_EXTENSIONS_SINGLE_UNSUPPORTED_DISABLED_BODY 1051
#define IDS_APPMENU_TOOLTIP 1052
#define IDS_APPMENU_TOOLTIP_UPDATE_AVAILABLE 1053
#define IDS_APPMENU_TOOLTIP_ALERT 1054
#define IDS_OPEN_IN_CHROME 1055
#define IDS_ABOUT 1056
#define IDS_RELAUNCH_TO_UPDATE 1057
#define IDS_VIEW_PASSWORDS 1061
#define IDS_CHROME_SIGNIN_TITLE 1062
#define IDS_PROFILES_DICE_SYNC_PROMO 1063
#define IDS_SYNC_WRONG_EMAIL 1064
#define IDS_SYNC_USED_PROFILE_ERROR 1065
#define IDS_ENTERPRISE_SIGNIN_TITLE 1066
#define IDS_ENTERPRISE_SIGNIN_EXPLANATION_WITHOUT_PROFILE_CREATION 1067
#define IDS_ENTERPRISE_SIGNIN_EXPLANATION_WITH_PROFILE_CREATION 1068
#define IDS_ENTERPRISE_SIGNIN_WORK_PROFILE_TITLE 1069
#define IDS_ENTERPRISE_SIGNIN_WORK_PROFILE_CREATION 1070
#define IDS_ENTERPRISE_SIGNIN_WORK_PROFILE_ISOLATION_NOTICE 1071
#define IDS_ENTERPRISE_SIGNIN_WORK_PROFILE_EXPLANATION 1072
#define IDS_ENTERPRISE_WELCOME_PROFILE_INFORMATION_DETAILS 1073
#define IDS_ONE_CLICK_SIGNIN_DIALOG_TITLE_NEW 1074
#define IDS_ONE_CLICK_SIGNIN_DIALOG_MESSAGE_NEW 1075
#define IDS_EXTENSION_ASKS_IDENTITY_WHILE_SIGNED_IN_WEB_ONLY_TITLE 1076
#define IDS_EXTENSION_ASKS_IDENTITY_WHILE_SIGNED_IN_WEB_ONLY_BODY 1077
#define IDS_EXTENSION_ASKS_IDENTITY_WHILE_SIGNED_IN_WEB_ONLY_TITLE_FALLBACK 1078
#define IDS_ABOUT_BROWSER_SWITCH_DESCRIPTION_UNKNOWN_BROWSER 1079
#define IDS_ABOUT_BROWSER_SWITCH_DESCRIPTION_KNOWN_BROWSER 1080
#define IDS_NTP_CUSTOMIZE_BUTTON_LABEL 1081
#define IDS_SIGNIN_EMAIL_CONFIRMATION_TITLE 1082
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_CREATE_BUBBLE_TITLE 1083
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_CREATE_BUBBLE_TITLE_V2 1084
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_SWITCH_BUBBLE_TITLE 1085
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_SWITCH_BUBBLE_DESC 1086
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_SWITCH_BUBBLE_DESC_V2 1087
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_CONSUMER_BUBBLE_DESC 1088
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_CREATE_BUBBLE_DESC 1089
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_CONSUMER_BUBBLE_DESC_MANAGED_DEVICE 1090
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_ENTERPRISE_BUBBLE_DESC_MANAGED_DEVICE 1091
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_BUBBLE_CHROME_SIGNIN_SUBTITLE 1092
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_BUBBLE_CHROME_SIGNIN_IPH_TEXT_SIGNIN_REMINDER 1093
#define IDS_CHROME_SIGNOUT_CONFIRMATION_PROMPT_VERIFY_BODY 1094
#define IDS_CHROME_SIGNOUT_CONFIRMATION_PROMPT_UNSYNCED_BODY 1095
#define IDS_CLOSE_WARNING_FOR_CLEAR_COOKIES_ON_EXIT_TEXT 1096
#define IDS_AVATAR_BUTTON_INTERCEPT_BUBBLE_CHROME_SIGNIN_TEXT 1097
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_BUBBLE_CHROME_SIGNIN_TITLE 1098
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_BUBBLE_CHROME_SIGNIN_DECLINE_TEXT 1099
#define IDS_AUTOFILL_SIGNIN_PROMO_SUBTITLE_PASSWORD 1100
#define IDS_PROFILE_CUSTOMIZATION_TEXT 1101
#define IDS_PROFILE_CUSTOMIZATION_TITLE_V2 1102
#define IDS_PROFILE_MENU_SIGNIN_PROMO_BUTTON 1107
#define IDS_PROFILE_MENU_PROFILES_LIST_TITLE 1108
#define IDS_PROFILE_MENU_MANAGE_PROFILES 1109
#define IDS_PROFILE_MENU_SIGN_OUT 1110
#define IDS_APP_SHORTCUTS_SUBDIR_NAME 1112
#define IDS_APP_SHORTCUTS_SUBDIR_NAME_CANARY 1113
#define IDS_MEDIA_STREAM_STATUS_TRAY_TEXT_AUDIO_AND_VIDEO 1117
#define IDS_MEDIA_STREAM_STATUS_TRAY_TEXT_AUDIO_ONLY 1118
#define IDS_MEDIA_STREAM_STATUS_TRAY_TEXT_VIDEO_ONLY 1119
#define IDS_WEBHID_SYSTEM_TRAY_ICON_TITLE 1120
#define IDS_WEBUSB_SYSTEM_TRAY_ICON_TITLE 1121
#define IDS_PROFILE_IN_USE_POSIX 1122
#define IDS_LOGIN_POD_USER_REMOVE_WARNING_SYNC 1124
#define IDS_USER_MANAGER_TUTORIAL_SLIDE_INTRO_TITLE 1125
#define IDS_USER_MANAGER_TUTORIAL_SLIDE_INTRO_TEXT 1126
#define IDS_USER_MANAGER_TUTORIAL_SLIDE_YOUR_CHROME_TITLE 1127
#define IDS_USER_MANAGER_TUTORIAL_SLIDE_YOUR_CHROME_TEXT 1128
#define IDS_USER_MANAGER_TUTORIAL_SLIDE_GUEST_TEXT 1129
#define IDS_USER_MANAGER_TUTORIAL_SLIDE_FRIENDS_TEXT 1130
#define IDS_USER_MANAGER_TUTORIAL_SLIDE_OUTRO_TEXT 1131
#define IDS_USER_MANAGER_TUTORIAL_SLIDE_OUTRO_ADD_USER 1132
#define IDS_TUTORIAL_PASSWORD_MANAGER_OPEN_APP_MENU 1133
#define IDS_TUTORIAL_PASSWORD_MANAGER_CLICK_PASSWORD_MANAGER 1134
#define IDS_TUTORIAL_PASSWORD_MANAGER_SUCCESS_BODY 1135
#define IDS_PASSWORD_MANAGER_IPH_CREATE_SHORTCUT_BODY 1136
#define IDS_SIDE_PANEL_GENERIC_MENU_IPH 1137
#define IDS_SIDE_PANEL_GENERIC_MENU_IPH_SCREENREADER 1138
#define IDS_EXTENSIONS_SETTINGS_API_SECOND_LINE_START_PAGES 1139
#define IDS_EXTENSIONS_SETTINGS_API_SECOND_LINE_START_AND_SEARCH 1140
#define IDS_WEBSTORE_APP_DESCRIPTION 1141
#define IDS_CONTENT_CONTEXT_ACCESSIBILITY_LABELS_BUBBLE_TEXT 1150
#define IDS_CONTENT_CONTEXT_ACCESSIBILITY_LABELS_BUBBLE_TEXT_ONCE 1151
#define IDS_CONTENT_CONTEXT_SPELLING_BUBBLE_TEXT 1152
#define IDS_CONTENT_CONTEXT_OPENLINKNEWTAB_INAPP 1153
#define IDS_CONTENT_CONTEXT_OPENLINKOFFTHERECORD_INAPP 1154
#define IDS_UPDATE_RECOMMENDED_DIALOG_TITLE 1155
#define IDS_UPDATE_RECOMMENDED 1156
#define IDS_RELAUNCH_AND_UPDATE 1157
#define IDS_UPDATE_RECOMMENDED_DIALOG_TITLE_ALT 1158
#define IDS_UPDATE_RECOMMENDED_ALT 1159
#define IDS_REINSTALL_APP 1160
#define IDS_UPGRADE_BUBBLE_MENU_ITEM 1161
#define IDS_UPGRADE_BUBBLE_TITLE 1162
#define IDS_UPGRADE_BUBBLE_TEXT 1163
#define IDS_SYNC_ERROR_USER_MENU_UPGRADE_BUTTON 1164
#define IDS_SYNC_UPGRADE_CLIENT 1165
#define IDS_SYNC_UPGRADE_CLIENT_BUTTON 1166
#define IDS_RECOVERY_BUBBLE_TITLE 1167
#define IDS_RUN_RECOVERY 1168
#define IDS_RECOVERY_BUBBLE_TEXT 1169
#define IDS_CRITICAL_NOTIFICATION_TITLE 1170
#define IDS_CRITICAL_NOTIFICATION_TITLE_ALTERNATE 1171
#define IDS_CRITICAL_NOTIFICATION_TEXT 1172
#define IDS_DESKTOP_MEDIA_PICKER_SOURCE_TYPE_TAB 1173
#define IDS_DESKTOP_MEDIA_PICKER_SCREEN_PERMISSION_TEXT_MAC 1174
#define IDS_DESKTOP_MEDIA_PICKER_SCREEN_PERMISSION_TEXT_PERIOD_MAC 1175
#define IDS_DESKTOP_MEDIA_PICKER_WINDOW_PERMISSION_TEXT_MAC 1176
#define IDS_DESKTOP_MEDIA_PICKER_WINDOW_PERMISSION_TEXT_PERIOD_MAC 1177
#define IDS_DESKTOP_MEDIA_PICKER_PERMISSION_RESTART_TEXT_MAC 1178
#define IDS_WELCOME_HEADER 1195
#define IDS_RELAUNCH_RECOMMENDED_TITLE 1197
#define IDS_RELAUNCH_RECOMMENDED_BODY 1198
#define IDS_RELAUNCH_REQUIRED_TITLE_DAYS 1199
#define IDS_RELAUNCH_REQUIRED_TITLE_HOURS 1200
#define IDS_RELAUNCH_REQUIRED_TITLE_MINUTES 1201
#define IDS_RELAUNCH_REQUIRED_TITLE_SECONDS 1202
#define IDS_RELAUNCH_REQUIRED_BODY 1203
#define IDS_ENTERPRISE_STARTUP_CLOUD_POLICY_ENROLLMENT_TOOLTIP 1204
#define IDS_ENTERPRISE_STARTUP_CLOUD_POLICY_ENROLLMENT_ERROR 1205
#define IDS_ENTERPRISE_STARTUP_RELAUNCH_BUTTON 1206
#define IDS_DESKTOP_MEDIA_PICKER_TITLE_WEB_CONTENTS_ONLY 1207
#define IDS_IDLE_BUBBLE_TITLE_CLOSE 1208
#define IDS_IDLE_BUBBLE_BODY_CLOSE_AND_CLEAR 1209
#define IDS_IDLE_BUBBLE_BODY_CLEAR 1210
#define IDS_IDLE_BUBBLE_BODY_CLOSE 1211
#define IDS_IDLE_TIMEOUT_CLOSE_TITLE 1212
#define IDS_IDLE_TIMEOUT_CLEAR_TITLE 1213
#define IDS_IDLE_TIMEOUT_CLOSE_AND_CLEAR_TITLE 1214
#define IDS_IDLE_TIMEOUT_CLOSE_BODY 1215
#define IDS_IDLE_TIMEOUT_CLEAR_BODY 1216
#define IDS_IDLE_TIMEOUT_CLOSE_AND_CLEAR_BODY 1217
#define IDS_IDLE_DISMISS_BUTTON 1218
#define IDS_HATS_BUBBLE_TITLE 1219
#define IDS_EXTENSION_PERMISSIONS_BLOCKED_BY_PARENT_PROMPT_MESSAGE 1220
#define IDS_PROFILE_PICKER_MAIN_VIEW_TITLE 1225
#define IDS_PROFILE_PICKER_MAIN_VIEW_TITLE_V2 1226
#define IDS_PROFILE_PICKER_MAIN_VIEW_SUBTITLE 1227
#define IDS_PROFILE_PICKER_PROFILE_CREATION_FLOW_PROFILE_TYPE_CHOICE_SUBTITLE 1228
#define IDS_PROFILE_PICKER_PROFILE_CREATION_FLOW_PROFILE_TYPE_CHOICE_TITLE 1229
#define IDS_PROFILE_PICKER_IPH_FOR_PROFILES_TEXT 1230
#define IDS_PROFILE_PICKER_IPH_FOR_ADD_PROFILE_TEXT 1231
#define IDS_PROFILE_PICKER_PROFILE_SWITCH_TITLE 1232
#define IDS_PROFILE_PICKER_PROFILE_SWITCH_SUBTITLE 1233
#define IDS_FRE_SIGN_IN_TITLE_0 1238
#define IDS_FRE_DEFAULT_BROWSER_TITLE 1239
#define IDS_FRE_DEFAULT_BROWSER_SUBTITLE_NEW 1240
#define IDS_FRE_DEFAULT_BROWSER_ILLUSTRATION_ALT_TEXT 1241
#define IDS_APP_MENU_TOOLTIP_DEFAULT_PROMPT 1242
#define IDS_APP_MENU_BUTTON_DEFAULT_PROMPT 1243
#define IDS_SET_BROWSER_AS_DEFAULT_MENU_ITEM 1244
#define IDS_PROFILE_SWITCH_PROMO 1245
#define IDS_PROFILE_SWITCH_PROMO_SCREENREADER 1246
#define IDS_PASSWORD_MANAGER_IPH_BODY_WEB_APP_PROFILE_SWITCH 1247
#define IDS_SIGNOUT_DICE_WEB_INTERCEPT_BUBBLE_CHROME_SIGNOUT_IPH_TEXT 1248
#define IDS_SIGNOUT_DICE_WEB_INTERCEPT_BUBBLE_CHROME_SIGNOUT_IPH_TEXT_SCREENREADER 1249
#define IDS_CHROMELABS_RELAUNCH_FOOTER_MESSAGE 1251
#define IDS_BLUETOOTH_DEVICE_CHOOSER_AUTHORIZE_BLUETOOTH 1252
#define IDS_TAILORED_SECURITY_UNCONSENTED_PROMOTION_NOTIFICATION_TITLE 1253
#define IDS_TAILORED_SECURITY_UNCONSENTED_PROMOTION_MESSAGE_TITLE 1254
#define IDS_TAILORED_SECURITY_UNCONSENTED_PROMOTION_MESSAGE_DESCRIPTION 1255
#define IDS_TAILORED_SECURITY_UNCONSENTED_PROMOTION_MESSAGE_DESCRIPTION_UPDATED 1256
#define IDS_TAILORED_SECURITY_UNCONSENTED_PROMOTION_MESSAGE_ACCEPT 1257
#define IDS_PRIVACY_SANDBOX_DIALOG_CONSENT_SUBTITLE 1258
#define IDS_PRIVACY_SANDBOX_DIALOG_CONSENT_BODY_DESCRIPTION_2 1259
#define IDS_PRIVACY_SANDBOX_DIALOG_CONSENT_LEARN_MORE_LABEL 1260
#define IDS_PRIVACY_SANDBOX_DIALOG_CONSENT_LEARN_MORE_SECTION_1_HEADER 1261
#define IDS_PRIVACY_SANDBOX_DIALOG_CONSENT_LEARN_MORE_SECTION_1_BULLET_POINT_1 1262
#define IDS_PRIVACY_SANDBOX_DIALOG_CONSENT_LEARN_MORE_SECTION_1_BULLET_POINT_2 1263
#define IDS_PRIVACY_SANDBOX_DIALOG_CONSENT_LEARN_MORE_SECTION_1_BULLET_POINT_3 1264
#define IDS_PRIVACY_SANDBOX_DIALOG_CONSENT_LEARN_MORE_SECTION_2_BULLET_POINT_1 1265
#define IDS_PRIVACY_SANDBOX_DIALOG_CONSENT_LEARN_MORE_SECTION_2_BULLET_POINT_2 1266
#define IDS_PRIVACY_SANDBOX_DIALOG_CONSENT_BOTTOM_SUMMARY 1267
#define IDS_PRIVACY_SANDBOX_DIALOG_NOTICE_SUBTITLE 1268
#define IDS_PRIVACY_SANDBOX_DIALOG_NOTICE_BODY_DESCRIPTION_2 1269
#define IDS_PRIVACY_SANDBOX_DIALOG_NOTICE_BOTTOM_SUMMARY 1270
#define IDS_SETTINGS_SECURITY_V8_LINK_DESCRIPTION 1271
#define IDS_SETTINGS_SITE_SETTINGS_JAVASCRIPT_JIT_DESCRIPTION 1272
#define IDS_SETTINGS_SITE_SETTINGS_JAVASCRIPT_JIT_ALLOWED_SUB_LABEL 1273
#define IDS_MEMORY_SAVER_DIALOG_BODY 1326
#define IDS_MEMORY_SAVER_MODE_PROMO_TITLE 1327
#define IDS_PERFORMANCE_INTERVENTION_DIALOG_BODY 1328
#define IDS_SETTINGS_CLEAR_BROWSING_DATA_SIGNED_IN 1329
#define IDS_CREATE_SHORTCUT_NOT_APPS_DIALOG_SUBTITLE 1330

// ---------------------------------------------------------------------------
// From cef_strings.h:

#define IDS_TEXT_FILES 64000
#define IDS_CONTENT_CONTEXT_NO_SPELLING_SUGGESTIONS 64001

// ---------------------------------------------------------------------------
// From components_branded_strings.h:

#define IDS_ERRORPAGES_SUGGESTION_NETWORK_PREDICTION_BODY 36050
#define IDS_ERRORPAGES_SUGGESTION_FIREWALL_CONFIG_HEADER 36051
#define IDS_ERRORPAGES_SUMMARY_BLOCKED_BY_CLIENT 36052
#define IDS_ERRORPAGES_SUGGESTION_PROXY_DISABLE_PLATFORM 36053
#define IDS_FLAGS_UI_RELAUNCH_NOTICE 36056
#define IDS_CRASH_DISABLED_MESSAGE 36057
#define IDS_SHORT_PRODUCT_LOGO_ALT_TEXT 36058
#define IDS_VERSION_UI_LICENSE 36059
#define IDS_PAGE_INFO_INTERNAL_PAGE 36062
#define IDS_SESSION_CRASHED_VIEW_MESSAGE 36063

// ---------------------------------------------------------------------------
// From components_strings.h:

#define IDS_ASH_ARC_APP_COMPAT_DISABLED_COMPAT_MODE_BUTTON_TOOLTIP_PHONE 36090
#define IDS_ASH_ARC_APP_COMPAT_RESIZE_CONFIRM_TITLE 36091
#define IDS_ASH_ARC_APP_COMPAT_RESIZE_CONFIRM_BODY 36092
#define IDS_ASH_ARC_APP_COMPAT_RESIZE_CONFIRM_ACCEPT 36093
#define IDS_ASH_ARC_APP_COMPAT_RESIZE_CONFIRM_DONT_ASK_ME 36094
#define IDS_ASH_ARC_NEARBY_SHARE_FILE_PREPARATION_PROGRESS 36095
#define IDS_ASH_ARC_NEARBY_SHARE_FILES_PREPARATION_PROGRESS 36096
#define IDS_ASH_ARC_NEARBY_SHARE_ERROR_DIALOG_MESSAGE 36097
#define IDS_ASH_ARC_NEARBY_SHARE_ERROR_DIALOG_MESSAGE_PH 36098
#define IDS_ASH_ARC_NEARBY_SHARE_LOW_DISK_SPACE_DIALOG_TITLE 36099
#define IDS_ASH_ARC_NEARBY_SHARE_LOW_DISK_SPACE_DIALOG_MESSAGE 36100
#define IDS_ASH_ARC_NEARBY_SHARE_LOW_DISK_SPACE_DIALOG_MESSAGE_PH 36101
#define IDS_ASH_ARC_NEARBY_SHARE_LOW_DISK_SPACE_DIALOG_STORAGE_BUTTON 36102
#define IDS_ARC_COMPAT_MODE_RESIZE_TOGGLE_MENU_RESIZE_SETTINGS 36103
#define IDS_ARC_COMPAT_MODE_RESIZE_TOGGLE_MENU_TITLE 36104
#define IDS_ARC_COMPAT_MODE_SPLASH_SCREEN_TITLE 36105
#define IDS_ARC_COMPAT_MODE_SPLASH_SCREEN_BODY 36106
#define IDS_ARC_COMPAT_MODE_SPLASH_SCREEN_BODY_UNRESIZABLE 36107
#define IDS_ARC_COMPAT_MODE_SPLASH_SCREEN_CLOSE 36108
#define IDS_ARC_COMPAT_MODE_SPLASH_SCREEN_LINK 36109
#define IDS_ARC_COMPAT_MODE_DISABLE_RESIZE_LOCK_TOAST 36110
#define IDS_ARC_GHOST_WINDOW_APP_LAUNCHING_ICON 36111
#define IDS_ARC_GHOST_WINDOW_APP_LAUNCHING_THROBBER 36112
#define IDS_ARC_GHOST_WINDOW_APP_LAUNCHING_MESSAGE 36113
#define IDS_ARC_GHOST_WINDOW_APP_LAUNCHING_AOD_MESSAGE 36114
#define IDS_ARC_GHOST_WINDOW_APP_FIXUP_MESSAGE 36115
#define IDS_ASH_ARC_PASSPOINT_APP_APPROVAL_TITLE 36116
#define IDS_ASH_ARC_PASSPOINT_APP_APPROVAL_BODY 36117
#define IDS_ASH_ARC_PASSPOINT_APP_APPROVAL_BODY_WITH_LEARN_MORE 36118
#define IDS_ASH_ARC_PASSPOINT_APP_APPROVAL_SUBSCRIPTION_BODY_WITH_LEARN_MORE 36119
#define IDS_ASH_ARC_PASSPOINT_APP_APPROVAL_LEARN_MORE_LABEL 36120
#define IDS_ASH_ARC_PASSPOINT_APP_APPROVAL_ALLOW_BUTTON 36121
#define IDS_ASH_ARC_PASSPOINT_APP_APPROVAL_DONT_ALLOW_BUTTON 36122
#define IDS_ARC_VM_DATA_MIGRATION_NOTIFICATION_TITLE 36123
#define IDS_ARC_VM_DATA_MIGRATION_NOTIFICATION_DAYS_UNTIL_DEADLINE 36124
#define IDS_ARC_VM_DATA_MIGRATION_NOTIFICATION_ACCEPT_BUTTON_LABEL 36125
#define IDS_ARC_VM_DATA_MIGRATION_DIALOG_TITLE 36126
#define IDS_ARC_VM_DATA_MIGRATION_DIALOG_SAVE_WORK_MESSAGE 36127
#define IDS_ARC_VM_DATA_MIGRATION_DIALOG_DAYS_UNTIL_DEADLINE 36128
#define IDS_ARC_VM_DATA_MIGRATION_DIALOG_UPDATE_NOW_BUTTON_LABEL 36129
#define IDS_ARC_VM_DATA_MIGRATION_DIALOG_SKIP_BUTTON_LABEL 36130
#define IDS_ARC_VM_DATA_MIGRATION_DIALOG_UPDATE_BUTTON_LABEL 36131
#define IDS_ARC_VM_DATA_MIGRATION_LOADING_SCREEN_MESSAGE 36132
#define IDS_ARC_VM_DATA_MIGRATION_WELCOME_SCREEN_TITLE 36133
#define IDS_ARC_VM_DATA_MIGRATION_WHAT_TO_EXPECT_TITLE 36134
#define IDS_ARC_VM_DATA_MIGRATION_UPDATE_DESCRIPTION 36135
#define IDS_ARC_VM_DATA_MIGRATION_BLOCKING_BEHAVIOR_DESCRIPTION 36136
#define IDS_ARC_VM_DATA_MIGRATION_CONNECT_TO_CHARGER_MESSAGE 36137
#define IDS_ARC_VM_DATA_MIGRATION_NOT_ENOUGH_FREE_DISK_SPACE_MESSAGE 36138
#define IDS_ARC_VM_DATA_MIGRATION_NOT_ENOUGH_BATTERY_MESSAGE 36139
#define IDS_ARC_VM_DATA_MIGRATION_SCREEN_UPDATE_BUTTON_LABEL 36140
#define IDS_ARC_VM_DATA_MIGRATION_SCREEN_SKIP_BUTTON_LABEL 36141
#define IDS_ARC_VM_DATA_MIGRATION_RESUME_SCREEN_TITLE 36142
#define IDS_ARC_VM_DATA_MIGRATION_RESUME_DESCRIPTION 36143
#define IDS_ARC_VM_DATA_MIGRATION_SCREEN_RESUME_BUTTON_LABEL 36144
#define IDS_ARC_VM_DATA_MIGRATION_PROGRESS_SCREEN_TITLE 36145
#define IDS_ARC_VM_DATA_MIGRATION_PROGRESS_DESCRIPTION 36146
#define IDS_ARC_VM_DATA_MIGRATION_SUCCESS_SCREEN_TITLE 36147
#define IDS_ARC_VM_DATA_MIGRATION_SCREEN_FINISH_BUTTON_LABEL 36148
#define IDS_ARC_VM_DATA_MIGRATION_FAILURE_SCREEN_TITLE 36149
#define IDS_ARC_VM_DATA_MIGRATION_FAILURE_DESCRIPTION 36150
#define IDS_ARC_VM_DATA_MIGRATION_SEND_FEEDBACK_MESSAGE 36151
#define IDS_ARC_VM_DATA_MIGRATION_SCREEN_REPORT_BUTTON_LABEL 36152
#define IDS_AUTOFILL_NO_THANKS_DESKTOP_LOCAL_SAVE 36153
#define IDS_AUTOFILL_NO_THANKS_DESKTOP_UPLOAD_SAVE 36154
#define IDS_AUTOFILL_SAVE_IBAN_BUBBLE_SAVE_NO_THANKS 36155
#define IDS_AUTOFILL_MANDATORY_REAUTH_OPT_IN_NO_THANKS 36156
#define IDS_AUTOFILL_MANDATORY_REAUTH_OPT_IN_ACCEPT 36157
#define IDS_AUTOFILL_GOOGLE_PAY_LOGO_ACCESSIBLE_NAME 36160
#define IDS_AUTOFILL_FIELD_LABEL_PHONE 36161
#define IDS_AUTOFILL_FIELD_LABEL_BILLING_ADDRESS 36162
#define IDS_AUTOFILL_SAVE_CARD_BUBBLE_LOCAL_SAVE_ACCEPT 36164
#define IDS_AUTOFILL_SAVE_CARD_BUBBLE_UPLOAD_SAVE_ACCEPT 36165
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_CONTINUE 36167
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_TITLE_LOCAL 36168
#define IDS_AUTOFILL_SAVE_CARD_ONLY_PROMPT_EXPLANATION_LOCAL 36169
#define IDS_AUTOFILL_SAVE_CARD_WITH_CVC_PROMPT_EXPLANATION_LOCAL 36170
#define IDS_AUTOFILL_SAVE_CVC_PROMPT_TITLE_LOCAL 36171
#define IDS_AUTOFILL_SAVE_CVC_PROMPT_EXPLANATION_LOCAL 36172
#define IDS_AUTOFILL_FIX_FLOW_PROMPT_SAVE_CARD_LABEL 36173
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_TITLE_TO_CLOUD 36174
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_TITLE_TO_CLOUD_V3 36175
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_TITLE_TO_CLOUD_V4 36176
#define IDS_AUTOFILL_SAVE_CVC_PROMPT_TITLE_TO_CLOUD 36177
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_CARD_DESCRIPTION 36178
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_CARD_DESCRIPTION_WITH_NICKNAME 36179
#define IDS_AUTOFILL_CARD_SAVED 36183
#define IDS_AUTOFILL_CVC_SAVED 36184
#define IDS_AUTOFILL_DONE 36185
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_UPLOAD_EXPLANATION 36186
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_UPLOAD_EXPLANATION_V3 36187
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_UPLOAD_EXPLANATION_V3_WITH_NAME 36188
#define IDS_AUTOFILL_SAVE_CVC_PROMPT_EXPLANATION_UPLOAD 36189
#define IDS_AUTOFILL_SAVE_CARD_WITH_CVC_PROMPT_EXPLANATION_UPLOAD 36190
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_CARDHOLDER_NAME 36192
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_CARDHOLDER_NAME_TOOLTIP 36193
#define IDS_AUTOFILL_SAVE_CARD_CARDHOLDER_NAME_FIX_FLOW_HEADER 36194
#define IDS_AUTOFILL_SAVE_CARD_UPDATE_EXPIRATION_DATE_TITLE 36195
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_UPLOAD_EXPLANATION_TOOLTIP 36198
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_UPLOAD_EXPLANATION_AND_CARDHOLDER_NAME_TOOLTIP 36199
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_LOADING_THROBBER_ACCESSIBLE_NAME 36200
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_ANIMATION_LABEL 36201
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_BUBBLE_TITLE 36202
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_BUBBLE_BUTTON_LABEL 36203
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_BUBBLE_BODY_TEXT 36204
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_DIALOG_TITLE_OFFER 36205
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_DIALOG_TITLE_DONE 36206
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_DIALOG_TITLE_FIX 36207
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_DIALOG_CHECKBOX_UNCHECK_WARNING 36208
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_DIALOG_MESSAGE_OFFER 36209
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_DIALOG_MESSAGE_DONE 36210
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_DIALOG_MESSAGE_ERROR 36211
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_DIALOG_MESSAGE_FIX 36212
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_DIALOG_MESSAGE_INVALID_CARD_REMOVED 36213
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_DIALOG_BUTTON_LABEL_SAVE 36214
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_DIALOG_BUTTON_LABEL_CANCEL 36215
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_DIALOG_BUTTON_LABEL_DONE 36216
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_DIALOG_BUTTON_LABEL_VIEW_CARDS 36217
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_DIALOG_LABEL_INVALID_CARDS 36218
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_DIALOG_TRASH_CAN_BUTTON_TOOLTIP 36219
#define IDS_AUTOFILL_MASKED_SERVER_CARD_RISK_BASED_UNMASKING_ERROR_TITLE 36220
#define IDS_AUTOFILL_VIRTUAL_CARD_TEMPORARY_ERROR_TITLE 36221
#define IDS_AUTOFILL_VIRTUAL_CARD_PERMANENT_ERROR_TITLE 36222
#define IDS_AUTOFILL_VIRTUAL_CARD_TEMPORARY_ERROR_DESCRIPTION 36223
#define IDS_AUTOFILL_VIRTUAL_CARD_PERMANENT_ERROR_DESCRIPTION 36224
#define IDS_AUTOFILL_VIRTUAL_CARD_NOT_ELIGIBLE_ERROR_TITLE 36225
#define IDS_AUTOFILL_VIRTUAL_CARD_NOT_ELIGIBLE_ERROR_DESCRIPTION 36226
#define IDS_AUTOFILL_ERROR_DIALOG_NEGATIVE_BUTTON_LABEL 36227
#define IDS_AUTOFILL_CARD_UNMASK_PROMPT_ERROR_TRY_AGAIN_CVC 36228
#define IDS_AUTOFILL_CARD_UNMASK_PROMPT_ERROR_TRY_AGAIN_SECURITY_CODE 36229
#define IDS_AUTOFILL_CARD_UNMASK_PROMPT_ERROR_PERMANENT 36230
#define IDS_AUTOFILL_CARD_UNMASK_PROMPT_ERROR_NETWORK 36231
#define IDS_AUTOFILL_CARD_UNMASK_PROMPT_SECURITY_CODE_POSITION_BACK_OF_CARD 36232
#define IDS_AUTOFILL_CARD_UNMASK_PROMPT_SECURITY_CODE_POSITION_FRONT_OF_CARD 36233
#define IDS_AUTOFILL_CARD_UNMASK_CVC_IMAGE_DESCRIPTION 36234
#define IDS_AUTOFILL_CARD_UNMASK_CVC_IMAGE_DESCRIPTION_FOR_AMEX 36235
#define IDS_AUTOFILL_CARD_UNMASK_PROMPT_INSTRUCTIONS_DEFAULT 36236
#define IDS_AUTOFILL_CARD_UNMASK_PROMPT_INSTRUCTIONS_EXPIRED_CARD 36237
#define IDS_AUTOFILL_CARD_UNMASK_PROMPT_INSTRUCTIONS_VIRTUAL_CARD 36238
#define IDS_AUTOFILL_CARD_UNMASK_VERIFICATION_TITLE 36239
#define IDS_AUTOFILL_CARD_UNMASK_PROMPT_TITLE 36243
#define IDS_AUTOFILL_CARD_UNMASK_PROMPT_TITLE_SECURITY_CODE 36244
#define IDS_AUTOFILL_CARD_UNMASK_PROMPT_EXPIRED_TITLE 36245
#define IDS_AUTOFILL_CARD_UNMASK_CONFIRM_BUTTON 36263
#define IDS_AUTOFILL_CARD_UNMASK_VERIFY_BUTTON 36264
#define IDS_AUTOFILL_CARD_UNMASK_EXPIRATION_MONTH 36265
#define IDS_AUTOFILL_CARD_UNMASK_EXPIRATION_YEAR 36266
#define IDS_AUTOFILL_CARD_UNMASK_VERIFICATION_IN_PROGRESS 36267
#define IDS_AUTOFILL_CARD_UNMASK_VERIFICATION_SUCCESS 36268
#define IDS_AUTOFILL_CARD_UNMASK_INVALID_EXPIRATION_DATE 36269
#define IDS_AUTOFILL_EXPIRATION_DATE_SEPARATOR 36270
#define IDS_AUTOFILL_CARD_UNMASK_NEW_CARD_LINK 36271
#define IDS_AUTOFILL_DIALOG_PLACEHOLDER_CVC 36272
#define IDS_AUTOFILL_DIALOG_ACCESSIBLE_NAME_SECURITY_CODE 36273
#define IDS_AUTOFILL_CARD_UNMASK_PROGRESS_BAR_MESSAGE 36274
#define IDS_AUTOFILL_MASKED_SERVER_CARD_RISK_BASED_UNMASK_PROGRESS_BAR_MESSAGE 36275
#define IDS_AUTOFILL_CARD_UNMASK_PROGRESS_DIALOG_TITLE 36276
#define IDS_AUTOFILL_IBAN_UNMASK_PROGRESS_DIALOG_TITLE 36277
#define IDS_AUTOFILL_IBAN_UNMASK_PROGRESS_BAR_MESSAGE 36278
#define IDS_AUTOFILL_CARD_UNMASK_CONFIRMATION_DIALOG_TITLE 36279
#define IDS_AUTOFILL_CARD_UNMASK_CANCEL_BUTTON_LABEL 36280
#define IDS_AUTOFILL_CARD_UNMASK_CONFIRMATION_MESSAGE 36281
#define IDS_AUTOFILL_FIDO_AUTHENTICATION_PROMPT_TITLE 36282
#define IDS_AUTOFILL_IBAN_UNMASK_ERROR_DIALOG_TITLE 36283
#define IDS_AUTOFILL_IBAN_UNMASK_ERROR_DIALOG_MESSAGE 36284
#define IDS_AUTOFILL_WEBAUTHN_OPT_IN_DIALOG_TITLE 36292
#define IDS_AUTOFILL_WEBAUTHN_OPT_IN_DIALOG_TITLE_ERROR 36293
#define IDS_AUTOFILL_WEBAUTHN_OPT_IN_DIALOG_INSTRUCTION 36294
#define IDS_AUTOFILL_WEBAUTHN_OPT_IN_DIALOG_OK_BUTTON_LABEL 36295
#define IDS_AUTOFILL_WEBAUTHN_OPT_IN_DIALOG_INSTRUCTION_ERROR 36296
#define IDS_AUTOFILL_WEBAUTHN_OPT_IN_DIALOG_CANCEL_BUTTON_LABEL 36297
#define IDS_AUTOFILL_WEBAUTHN_OPT_IN_DIALOG_CANCEL_BUTTON_LABEL_ERROR 36298
#define IDS_AUTOFILL_WEBAUTHN_VERIFY_PENDING_DIALOG_TITLE 36299
#define IDS_AUTOFILL_WEBAUTHN_VERIFY_PENDING_DIALOG_CANCEL_BUTTON_LABEL 36300
#define IDS_AUTOFILL_WALLET_MANAGEMENT_LINK_TEXT 36301
#define IDS_AUTOFILL_FROM_GOOGLE_ACCOUNT_LONG 36302
#define IDS_AUTOFILL_SAVE_IBAN_PROMPT_TITLE_LOCAL 36303
#define IDS_AUTOFILL_SAVE_IBAN_LABEL 36304
#define IDS_AUTOFILL_SAVE_IBAN_BUBBLE_SAVE_ACCEPT 36305
#define IDS_AUTOFILL_SAVE_IBAN_PROMPT_NICKNAME 36306
#define IDS_AUTOFILL_SAVE_IBAN_PLACEHOLDER 36307
#define IDS_IBAN_NICKNAME_COUNT_BY 36308
#define IDS_AUTOFILL_IBAN_SAVED 36309
#define IDS_AUTOFILL_MANAGE_SAVED_PAYMENT_METHODS 36310
#define IDS_AUTOFILL_SAVE_IBAN_PROMPT_TITLE_SERVER 36311
#define IDS_AUTOFILL_UPLOAD_IBAN_PROMPT_EXPLANATION 36312
#define IDS_AUTOFILL_MANDATORY_REAUTH_OPT_IN_TITLE 36313
#define IDS_AUTOFILL_MANDATORY_REAUTH_OPT_IN_EXPLANATION 36314
#define IDS_AUTOFILL_MANDATORY_REAUTH_ICON_TOOLTIP 36315
#define IDS_AUTOFILL_MANDATORY_REAUTH_CONFIRMATION_TITLE 36316
#define IDS_AUTOFILL_MANDATORY_REAUTH_CONFIRMATION_EXPLANATION 36317
#define IDS_AUTOFILL_MANDATORY_REAUTH_CONFIRMATION_SETTINGS_LINK 36318
#define IDS_AUTOFILL_VIRTUAL_CARD_ENTRY_PREFIX 36322
#define IDS_AUTOFILL_VIRTUAL_CARD_ENROLLMENT_FALLBACK_ICON_TOOLTIP 36323
#define IDS_AUTOFILL_VIRTUAL_CARD_MANUAL_FALLBACK_BUBBLE_TITLE 36324
#define IDS_AUTOFILL_VIRTUAL_CARD_MANUAL_FALLBACK_BUBBLE_EDUCATIONAL_BODY_LABEL 36325
#define IDS_AUTOFILL_VIRTUAL_CARD_MANUAL_FALLBACK_BUBBLE_LEARN_MORE_LINK_LABEL 36326
#define IDS_AUTOFILL_VIRTUAL_CARD_MANUAL_FALLBACK_BUBBLE_CARD_NUMBER_LABEL 36327
#define IDS_AUTOFILL_VIRTUAL_CARD_MANUAL_FALLBACK_BUBBLE_EXP_DATE_LABEL 36328
#define IDS_AUTOFILL_VIRTUAL_CARD_MANUAL_FALLBACK_BUBBLE_CARDHOLDER_NAME_LABEL 36329
#define IDS_AUTOFILL_VIRTUAL_CARD_MANUAL_FALLBACK_BUBBLE_CVC_LABEL 36330
#define IDS_AUTOFILL_VIRTUAL_CARD_MANUAL_FALLBACK_BUBBLE_VIRTUAL_CARD_LABEL 36331
#define IDS_AUTOFILL_VIRTUAL_CARD_MANUAL_FALLBACK_ICON_TOOLTIP 36332
#define IDS_AUTOFILL_VIRTUAL_CARD_MANUAL_FALLBACK_BUBBLE_BUTTON_TOOLTIP_NORMAL 36333
#define IDS_AUTOFILL_VIRTUAL_CARD_MANUAL_FALLBACK_BUBBLE_BUTTON_TOOLTIP_CLICKED 36334
#define IDS_AUTOFILL_PAYMENTS_MANUAL_FALLBACK_AUTOFILL_POPUP_CC_NUMBER_SUGGESTION_LABEL 36335
#define IDS_AUTOFILL_PAYMENTS_MANUAL_FALLBACK_AUTOFILL_POPUP_CC_EXPIRY_DATE_SUGGESTION_LABEL 36336
#define IDS_AUTOFILL_PAYMENTS_MANUAL_FALLBACK_AUTOFILL_POPUP_CC_EXPIRY_YEAR_SUGGESTION_LABEL 36337
#define IDS_AUTOFILL_PAYMENTS_MANUAL_FALLBACK_AUTOFILL_POPUP_CC_EXPIRY_MONTH_SUGGESTION_LABEL 36338
#define IDS_AUTOFILL_VIRTUAL_CARD_SUGGESTION_IPH_BUBBLE_LABEL 36339
#define IDS_AUTOFILL_VIRTUAL_CARD_ENROLLMENT_ACCEPT_BUTTON_LABEL 36340
#define IDS_AUTOFILL_VIRTUAL_CARD_ENROLLMENT_DIALOG_TITLE_LABEL 36341
#define IDS_AUTOFILL_VIRTUAL_CARD_ENROLLMENT_DIALOG_CONTENT_LABEL 36342
#define IDS_AUTOFILL_VIRTUAL_CARD_ENROLLMENT_DECLINE_BUTTON_LABEL_SKIP 36343
#define IDS_AUTOFILL_VIRTUAL_CARD_ENROLLMENT_DECLINE_BUTTON_LABEL_NO_THANKS 36344
#define IDS_AUTOFILL_VIRTUAL_CARD_ENROLLMENT_LEARN_MORE_LINK_LABEL 36345
#define IDS_AUTOFILL_VIRTUAL_CARD_ENROLLMENT_CARD_IMAGE_TOOLTIP 36346
#define IDS_AUTOFILL_VIRTUAL_CARD_SUGGESTION_OPTION_VALUE 36347
#define IDS_AUTOFILL_VIRTUAL_CARD_NUMBER_SWITCH_LABEL 36348
#define IDS_AUTOFILL_VIRTUAL_CARD_ENROLL_LOADING_THROBBER_ACCESSIBLE_NAME 36349
#define IDS_AUTOFILL_VIRTUAL_CARD_STANDALONE_CVC_SUGGESTION_IPH_BUBBLE_LABEL 36358
#define IDS_AUTOFILL_VIRTUAL_CARD_STANDALONE_CVC_SUGGESTION_IPH_BUBBLE_LABEL_SCREENREADER 36359
#define IDS_AUTOFILL_VIRTUAL_CARD_STANDALONE_CVC_SUGGESTION_TITLE 36360
#define IDS_AUTOFILL_VIRTUAL_CARD_MANUAL_FALLBACK_BUBBLE_CARD_NUMBER_LABEL_IOS 36361
#define IDS_AUTOFILL_VIRTUAL_CARD_MANUAL_FALLBACK_BUBBLE_EXP_DATE_LABEL_IOS 36362
#define IDS_AUTOFILL_VIRTUAL_CARD_MANUAL_FALLBACK_BUBBLE_NAME_ON_CARD_LABEL_IOS 36363
#define IDS_AUTOFILL_VIRTUAL_CARD_DISABLED_SUGGESTION_OPTION_VALUE 36364
#define IDS_AUTOFILL_CARD_AUTH_SELECTION_DIALOG_TITLE_MULTIPLE_OPTIONS 36365
#define IDS_AUTOFILL_CARD_UNMASK_AUTHENTICATION_SELECTION_DIALOG_ISSUER_CONFIRMATION_TEXT 36366
#define IDS_AUTOFILL_AUTHENTICATION_MODE_SECURITY_CODE 36367
#define IDS_AUTOFILL_AUTHENTICATION_MODE_GET_TEXT_MESSAGE 36368
#define IDS_AUTOFILL_AUTHENTICATION_MODE_TEXT_MESSAGE 36369
#define IDS_AUTOFILL_AUTHENTICATION_MODE_GET_EMAIL 36370
#define IDS_AUTOFILL_AUTHENTICATION_MODE_THREE_DOMAIN_SECURE 36371
#define IDS_AUTOFILL_CARD_UNMASK_AUTHENTICATION_SELECTION_DIALOG_CURRENT_INFO_NOT_SEEN_TEXT 36372
#define IDS_AUTOFILL_CARD_UNMASK_AUTHENTICATION_SELECTION_DIALOG_OK_BUTTON_LABEL_CONTINUE 36373
#define IDS_AUTOFILL_CARD_UNMASK_AUTHENTICATION_SELECTION_DIALOG_OK_BUTTON_LABEL_SEND 36374
#define IDS_AUTOFILL_CARD_UNMASK_AUTHENTICATION_SELECTION_DIALOG_CVC_CHALLENGE_INFO 36375
#define IDS_AUTOFILL_CARD_UNMASK_AUTHENTICATION_SELECTION_DIALOG_THREE_DOMAIN_SECURE_CHALLENGE_INFO 36376
#define IDS_AUTOFILL_CARD_UNMASK_OTP_INPUT_DIALOG_TITLE 36377
#define IDS_AUTOFILL_CARD_UNMASK_OTP_INPUT_DIALOG_FOOTER_MESSAGE 36378
#define IDS_AUTOFILL_CARD_UNMASK_OTP_INPUT_DIALOG_NEW_CODE_MESSAGE 36379
#define IDS_AUTOFILL_CARD_UNMASK_OTP_INPUT_DIALOG_TEXTFIELD_PLACEHOLDER_MESSAGE 36380
#define IDS_AUTOFILL_CARD_UNMASK_OTP_INPUT_DIALOG_PENDING_MESSAGE 36381
#define IDS_AUTOFILL_CARD_UNMASK_OTP_INPUT_DIALOG_VERIFICATION_CODE_EXPIRED_LABEL 36382
#define IDS_AUTOFILL_CARD_UNMASK_OTP_INPUT_DIALOG_ENTER_CORRECT_CODE_LABEL 36383
#define IDS_AUTOFILL_PAYMENTS_WINDOW_USER_CONSENT_DIALOG_TITLE_VCN_3DS 36384
#define IDS_AUTOFILL_PAYMENTS_WINDOW_USER_CONSENT_DIALOG_DESCRIPTION_VCN_3DS 36385
#define IDS_AUTOFILL_PAYMENTS_WINDOW_USER_CONSENT_DIALOG_OK_BUTTON_LABEL_VCN_3DS 36386
#define IDS_AUTOFILL_REGULAR_CARD_MANUAL_FALLBACK_BUBBLE_CARD_NUMBER_LABEL_IOS 36387
#define IDS_AUTOFILL_CREDIT_CARD_BENEFIT_TEXT_FOR_SUGGESTIONS 36388
#define IDS_AUTOFILL_CREDIT_CARD_BENEFIT_IPH_BUBBLE_LABEL 36389
#define IDS_AUTOFILL_CREDIT_CARD_BENEFIT_IPH_BUBBLE_LABEL_SCREENREADER 36390
#define IDS_AUTOFILL_OFFERS_CASHBACK 36391
#define IDS_AUTOFILL_CARD_LINKED_OFFER_REMINDER_TITLE 36392
#define IDS_AUTOFILL_OFFERS_REMINDER_POSITIVE_BUTTON_LABEL 36393
#define IDS_AUTOFILL_PROMO_CODE_SUGGESTIONS_FOOTER_TEXT 36394
#define IDS_AUTOFILL_OFFERS_REMINDER_ICON_TOOLTIP_TEXT 36395
#define IDS_AUTOFILL_OFFERS_REMINDER_DESCRIPTION_TEXT 36396
#define IDS_AUTOFILL_PROMO_CODE_OFFERS_REMINDER_TITLE 36399
#define IDS_AUTOFILL_GPAY_PROMO_CODE_OFFERS_REMINDER_TITLE 36400
#define IDS_AUTOFILL_PROMO_CODE_OFFER_BUTTON_TOOLTIP_NORMAL 36401
#define IDS_AUTOFILL_PROMO_CODE_OFFER_BUTTON_TOOLTIP_CLICKED 36402
#define IDS_AUTOFILL_GPAY_PROMO_CODE_OFFERS_REMINDER_VALUE_PROP_TEXT 36403
#define IDS_AUTOFILL_PROMO_CODE_OFFERS_USE_THIS_CODE_TEXT 36404
#define IDS_AUTOFILL_PAYMENTS_OTP_VERIFICATION_DIALOG_CANT_FIND_CODE_MESSAGE 36405
#define IDS_AUTOFILL_PAYMENTS_OTP_VERIFICATION_DIALOG_OTP_INPUT_HINT 36406
#define IDS_AUTOFILL_PAYMENTS_OTP_VERIFICATION_DIALOG_POSITIVE_BUTTON_LABEL 36407
#define IDS_AUTOFILL_PAYMENTS_OTP_VERIFICATION_DIALOG_NEGATIVE_BUTTON_LABEL 36408
#define IDS_AUTOFILL_SETTINGS_PAGE_ENABLE_PAYMENT_METHOD_MANDATORY_REAUTH_LABEL 36424
#define IDS_AUTOFILL_SETTINGS_PAGE_ENABLE_PAYMENT_METHOD_MANDATORY_REAUTH_SUBLABEL 36425
#define IDS_AUTOFILL_SETTINGS_PAGE_ENABLE_CVC_STORAGE_LABEL 36428
#define IDS_AUTOFILL_SETTINGS_PAGE_ENABLE_CVC_STORAGE_ARIA_LABEL_FOR_NO_CVC_SAVED 36429
#define IDS_AUTOFILL_SETTINGS_PAGE_ENABLE_CVC_STORAGE_SUBLABEL 36430
#define IDS_AUTOFILL_SETTINGS_PAGE_ENABLE_CVC_STORAGE_WITH_DELETE_LINK_SUBLABEL 36431
#define IDS_AUTOFILL_SETTINGS_PAGE_CARD_BENEFITS_TOGGLE_LABEL 36432
#define IDS_AUTOFILL_SETTINGS_PAGE_CARD_BENEFITS_TOGGLE_SUBLABEL_WITH_LEARN_LINK 36433
#define IDS_AUTOFILL_SETTINGS_PAGE_BULK_REMOVE_CVC_TITLE 36434
#define IDS_AUTOFILL_SETTINGS_PAGE_BULK_REMOVE_CVC_DESCRIPTION 36435
#define IDS_AUTOFILL_SETTINGS_PAGE_CVC_TAG_FOR_CREDIT_CARD_LIST_ENTRY 36436
#define IDS_AUTOFILL_SETTINGS_PAGE_BENEFITS_TERMS_TAG_FOR_CREDIT_CARD_LIST_ENTRY 36437
#define IDS_AUTOFILL_SETTINGS_PAGE_BENEFITS_TERMS_ARIA_LABEL 36438
#define IDS_AUTOFILL_CVC_SUGGESTION_MAIN_TEXT 36440
#define IDS_AUTOFILL_SETTINGS_PAGE_CVC_SAVED_LABEL 36441
#define IDS_AUTOFILL_SETTINGS_PAGE_SUMMARY_SEPARATED_BY_PIPE 36442
#define IDS_AUTOFILL_SAVE_CARD_CONFIRMATION_SUCCESS_TITLE_TEXT 36443
#define IDS_AUTOFILL_SAVE_CARD_CONFIRMATION_FAILURE_TITLE_TEXT 36444
#define IDS_AUTOFILL_VIRTUAL_CARD_ENROLL_CONFIRMATION_SUCCESS_TITLE_TEXT 36445
#define IDS_AUTOFILL_VIRTUAL_CARD_ENROLL_CONFIRMATION_FAILURE_TITLE_TEXT 36446
#define IDS_AUTOFILL_SAVE_CARD_CONFIRMATION_SUCCESS_DESCRIPTION_TEXT 36447
#define IDS_AUTOFILL_SAVE_CARD_CONFIRMATION_FAILURE_DESCRIPTION_TEXT 36448
#define IDS_AUTOFILL_VIRTUAL_CARD_ENROLL_CONFIRMATION_SUCCESS_DESCRIPTION_TEXT 36449
#define IDS_AUTOFILL_VIRTUAL_CARD_ENROLL_CONFIRMATION_FAILURE_DESCRIPTION_TEXT 36450
#define IDS_AUTOFILL_SAVE_CARD_AND_VIRTUAL_CARD_ENROLL_CONFIRMATION_FAILURE_OK_BUTTON_TEXT 36451
#define IDS_AUTOFILL_SAVE_CARD_CONFIRMATION_FAILURE_OK_BUTTON_ACCESSIBLE_NAME 36452
#define IDS_AUTOFILL_VIRTUAL_CARD_ENROLL_CONFIRMATION_FAILURE_OK_BUTTON_ACCESSIBLE_NAME 36453
#define IDS_AUTOFILL_CLEAR_FORM_MENU_ITEM 36454
#define IDS_AUTOFILL_UNDO_MENU_ITEM 36455
#define IDS_AUTOFILL_WARNING_INSECURE_CONNECTION 36456
#define IDS_AUTOFILL_WARNING_MIXED_FORM 36457
#define IDS_AUTOFILL_DELETE_AUTOCOMPLETE_SUGGESTION_CONFIRMATION_BODY 36458
#define IDS_AUTOFILL_DELETE_CREDIT_CARD_SUGGESTION_CONFIRMATION_BODY 36459
#define IDS_AUTOFILL_DELETE_PROFILE_SUGGESTION_CONFIRMATION_BODY 36460
#define IDS_AUTOFILL_DELETE_AUTOCOMPLETE_SUGGESTION_TOOLTIP 36461
#define IDS_AUTOFILL_AUTOCOMPLETE_ENTRY_DELETED_A11Y_HINT 36462
#define IDS_AUTOFILL_DELETE_AUTOCOMPLETE_SUGGESTION_A11Y_HINT 36463
#define IDS_AUTOFILL_CC_AMEX 36464
#define IDS_AUTOFILL_CC_AMEX_SHORT 36465
#define IDS_AUTOFILL_CC_DINERS 36466
#define IDS_AUTOFILL_CC_DISCOVER 36467
#define IDS_AUTOFILL_CC_ELO 36468
#define IDS_AUTOFILL_CC_GOOGLE_PAY 36469
#define IDS_AUTOFILL_CC_JCB 36470
#define IDS_AUTOFILL_CC_MASTERCARD 36471
#define IDS_AUTOFILL_CC_MIR 36472
#define IDS_AUTOFILL_CC_TROY 36473
#define IDS_AUTOFILL_CC_UNION_PAY 36474
#define IDS_AUTOFILL_CC_VERVE 36475
#define IDS_AUTOFILL_CC_VISA 36476
#define IDS_AUTOFILL_CC_GENERIC 36477
#define IDS_AUTOFILL_ADDRESS_SUMMARY_SEPARATOR 36478
#define IDS_AUTOFILL_ADDRESS_TEST_DATA 36479
#define IDS_AUTOFILL_TEST_ADDRESS_SELECTED_A11Y_HINT 36480
#define IDS_AUTOFILL_A11Y_ANNOUNCE_FILLED_FORM 36481
#define IDS_AUTOFILL_A11Y_ANNOUNCE_EXPANDABLE_ONLY_ENTRY 36482
#define IDS_AUTOFILL_A11Y_ANNOUNCE_VIRTUAL_CARD_MANUAL_FALLBACK_ENTRY 36483
#define IDS_AUTOFILL_A11Y_ANNOUNCE_EDIT_ADDRESS_PROFILE_POPUP_OPTION_SELECTED 36484
#define IDS_AUTOFILL_A11Y_ANNOUNCE_DELETE_ADDRESS_PROFILE_POPUP_OPTION_SELECTED 36485
#define IDS_AUTOFILL_A11Y_ANNOUNCE_CLEARED_FORM 36486
#define IDS_AUTOFILL_A11Y_ANNOUNCE_FILL_ADDRESS_GROUP_POPUP_OPTION_SELECTED 36487
#define IDS_AUTOFILL_FILL_ADDRESS_GROUP_POPUP_OPTION_SELECTED 36488
#define IDS_AUTOFILL_A11Y_ANNOUNCE_FILL_NAME_GROUP_POPUP_OPTION_SELECTED 36489
#define IDS_AUTOFILL_FILL_NAME_GROUP_POPUP_OPTION_SELECTED 36490
#define IDS_AUTOFILL_A11Y_ANNOUNCE_FILL_EVERYTHING_FROM_ADDRESS_PROFILE_POPUP_OPTION_SELECTED 36491
#define IDS_AUTOFILL_HIDE_SUGGESTIONS 36492
#define IDS_AUTOFILL_EDIT_ADDRESS_PROFILE_POPUP_OPTION_SELECTED 36493
#define IDS_AUTOFILL_DELETE_ADDRESS_PROFILE_POPUP_OPTION_SELECTED 36494
#define IDS_AUTOFILL_HOUSE_NUMBER_SUGGESTION_SECONDARY_TEXT_OPTION_SELECTED 36495
#define IDS_AUTOFILL_STREET_NAME_SUGGESTION_SECONDARY_TEXT_OPTION_SELECTED 36496
#define IDS_AUTOFILL_HOUSE_NUMBER_SUGGESTION_SECONDARY_TEXT 36497
#define IDS_AUTOFILL_STREET_NAME_SUGGESTION_SECONDARY_TEXT 36498
#define IDS_AUTOFILL_FILL_EVERYTHING_FROM_ADDRESS_PROFILE_POPUP_OPTION_SELECTED 36499
#define IDS_AUTOFILL_MANAGE_ADDRESSES 36500
#define IDS_AUTOFILL_MANAGE_PAYMENT_METHODS 36501
#define IDS_AUTOFILL_MANAGE_PASSWORDS 36502
#define IDS_AUTOFILL_SCAN_CREDIT_CARD 36503
#define IDS_AUTOFILL_SHOW_ALL_SAVED_FALLBACK 36504
#define IDS_AUTOFILL_SHOW_ACCOUNT_CARDS 36505
#define IDS_AUTOFILL_POPUP_ACCESSIBLE_NODE_DATA 36506
#define IDS_AUTOFILL_IPH_EXTERNAL_ACCOUNT_PROFILE_SUGGESTION 36507
#define IDS_AUTOFILL_IPH_MANUAL_FALLBACK 36508
#define IDS_AUTOFILL_IPH_MANUAL_FALLBACK_SCREENREADER 36509
#define IDS_AUTOFILL_SUGGESTION_LABEL_SEPARATOR 36510
#define IDS_AUTOFILL_CREDIT_CARD_EXPIRATION_DATE_ABBR 36511
#define IDS_AUTOFILL_CREDIT_CARD_EXPIRATION_DATE_ABBR_V2 36512
#define IDS_AUTOFILL_CREDIT_CARD_TWO_LINE_LABEL_FROM_NAME 36513
#define IDS_AUTOFILL_CREDIT_CARD_TWO_LINE_LABEL_FROM_CARD_NUMBER 36514
#define IDS_AUTOFILL_LOADING_REGIONS 36515
#define IDS_AUTOFILL_SELECT 36516
#define IDS_AUTOFILL_NO_SAVED_ADDRESS 36517
#define IDS_AUTOFILL_ADDRESSES 36518
#define IDS_AUTOFILL_ADDRESSES_TABLE_ARIA_LABEL 36519
#define IDS_AUTOFILL_ENABLE_PROFILES_TOGGLE_SUBLABEL 36520
#define IDS_AUTOFILL_LOCAL_PROFILE_ACCESSIBILITY_LABEL 36521
#define IDS_AUTOFILL_ENABLE_CREDIT_CARDS_TOGGLE_SUBLABEL 36522
#define IDS_AUTOFILL_DELETE_ACCOUNT_ADDRESS_SOURCE_NOTICE 36523
#define IDS_AUTOFILL_DELETE_SYNC_ADDRESS_SOURCE_NOTICE 36524
#define IDS_AUTOFILL_DELETE_LOCAL_ADDRESS_SOURCE_NOTICE 36525
#define IDS_AUTOFILL_SAVE_IN_ACCOUNT_MESSAGE_ADDRESS_SOURCE_NOTICE 36526
#define IDS_AUTOFILL_SAVE_IN_ACCOUNT_MESSAGE_ADDRESS_MIGRATION_SOURCE_NOTICE 36527
#define IDS_AUTOFILL_ADDRESS_ALREADY_SAVED_IN_ACCOUNT_SOURCE_NOTICE 36528
#define IDS_AUTOFILL_ADDRESS_WILL_BE_SAVED_IN_ACCOUNT_SOURCE_NOTICE 36529
#define IDS_AUTOFILL_EDIT_ADDRESS_REQUIRED_FIELD_FORM_ERROR 36530
#define IDS_AUTOFILL_EDIT_ADDRESS_REQUIRED_FIELDS_FORM_ERROR 36531
#define IDS_AUTOFILL_LOCAL_ADDRESS_ICON_A11Y_LABEL 36532
#define IDS_AUTOFILL_SYNC_TOGGLE_LABEL 36533
#define IDS_AUTOFILL_ADDRESSES_SETTINGS_TITLE 36534
#define IDS_AUTOFILL_PAYMENT_METHODS 36535
#define IDS_AUTOFILL_PAYMENT_METHODS_TABLE_ARIA_LABEL 36536
#define IDS_AUTOFILL_ENABLE_PROFILES_TOGGLE_LABEL 36537
#define IDS_AUTOFILL_ENABLE_CREDIT_CARDS_TOGGLE_LABEL 36538
#define IDS_AUTOFILL_DELETE_ADDRESS_CONFIRMATION_DIALOG_TITLE 36539
#define IDS_SYNC_DATATYPE_PAYMENTS 36545
#define IDS_AUTOFILL_SAVE_ADDRESS_PROMPT_OK_BUTTON_LABEL 36551
#define IDS_AUTOFILL_SAVE_ADDRESS_PROMPT_MIGRATION_OK_BUTTON_LABEL 36552
#define IDS_AUTOFILL_ACCOUNT_MIGRATE_ADDRESS_PROMPT_TITLE 36553
#define IDS_AUTOFILL_UPDATE_ADDRESS_PROMPT_OK_BUTTON_LABEL 36554
#define IDS_AUTOFILL_ADDRESS_MIGRATION_TO_ACCOUNT_PROMPT_OK_BUTTON_LABEL 36555
#define IDS_AUTOFILL_ADDRESS_MIGRATION_TO_ACCOUNT_PROMPT_CANCEL_BUTTON_LABEL 36556
#define IDS_AUTOFILL_UPDATE_ADDRESS_PROMPT_NEW_VALUES_SECTION_LABEL 36557
#define IDS_AUTOFILL_UPDATE_ADDRESS_PROMPT_OLD_VALUES_SECTION_LABEL 36558
#define IDS_AUTOFILL_MIGRATE_ADDRESS_PROMPT_CANCEL_BUTTON_LABEL 36559
#define IDS_AUTOFILL_SAVE_IN_ACCOUNT_PROMPT_ADDRESS_SOURCE_NOTICE 36560
#define IDS_AUTOFILL_UPDATE_PROMPT_ACCOUNT_ADDRESS_SOURCE_NOTICE 36561
#define IDS_AUTOFILL_SYNCABLE_PROFILE_MIGRATION_PROMPT_NOTICE 36562
#define IDS_AUTOFILL_LOCAL_PROFILE_MIGRATION_PROMPT_NOTICE 36563
#define IDS_AUTOFILL_SAVE_PROMPT_ADDRESS_SECTION_A11Y_LABEL 36564
#define IDS_AUTOFILL_SAVE_PROMPT_PHONE_SECTION_A11Y_LABEL 36565
#define IDS_AUTOFILL_SAVE_PROMPT_EMAIL_SECTION_A11Y_LABEL 36566
#define IDS_AUTOFILL_SAVE_ADDRESS_PROMPT_TITLE 36567
#define IDS_AUTOFILL_SAVE_ADDRESS_PROMPT_CANCEL_BUTTON_LABEL 36585
#define IDS_AUTOFILL_SAVE_ADDRESS_PROMPT_EDIT_BUTTON_TOOLTIP 36571
#define IDS_AUTOFILL_UPDATE_ADDRESS_PROMPT_TITLE 36569
#define IDS_AUTOFILL_ADD_NEW_ADDRESS_PROMPT_TITLE 36586
#define IDS_AUTOFILL_ADD_NEW_ADDRESS_EDITOR_TITLE 36587
#define IDS_AUTOFILL_ADD_NEW_ADDRESS_INTO_CHROME_PROMPT_BODY_TEXT 36588
#define IDS_AUTOFILL_ADD_NEW_ADDRESS_INTO_ACCOUNT_PROMPT_BODY_TEXT 36589
#define IDS_AUTOFILL_UPDATE_ADDRESS_PROMPT_CANCEL_BUTTON_LABEL 36590
#define IDS_AUTOFILL_EDIT_ADDRESS_DIALOG_TITLE 36572
#define IDS_AUTOFILL_EDIT_ADDRESS_DIALOG_OK_BUTTON_LABEL_SAVE 36591
#define IDS_AUTOFILL_MIGRATE_ADDRESS_DIALOG_OK_BUTTON_LABEL_SAVE 36592
#define IDS_AUTOFILL_EDIT_ADDRESS_DIALOG_OK_BUTTON_LABEL_UPDATE 36593
#define IDS_AUTOFILL_ADD_NEW_ADDRESS_DIALOG_OK_BUTTON_LABEL 36594
#define IDS_AUTOFILL_EDIT_ADDRESS_DIALOG_CANCEL_BUTTON_LABEL 36595
#define IDS_AUTOFILL_EXPANDABLE_SUGGESTION_FILL_ADDRESS_A11Y_ADDON 36596
#define IDS_AUTOFILL_EXPANDABLE_SUGGESTION_EXPAND_SHORTCUT 36597
#define IDS_AUTOFILL_EXPANDABLE_SUGGESTION_EXPAND_SHORTCUT_RTL 36598
#define IDS_AUTOFILL_EXPANDABLE_SUGGESTION_SUBMENU_HINT 36599
#define IDS_AUTOFILL_SIGNIN_PROMO_TITLE_PASSWORD 36600
#define IDS_AUTOFILL_VERIFY_PROMO_SUBTITLE_PASSWORD 36601
#define IDS_AUTOFILL_ADDRESS_EDIT_DIALOG_HISPANIC_MUNICIPIO 36602
#define IDS_BOOKMARK_BAR_FOLDER_NAME 36603
#define IDS_BOOKMARK_BAR_MOBILE_FOLDER_NAME 36604
#define IDS_BOOKMARK_BAR_OTHER_FOLDER_NAME 36605
#define IDS_BOOKMARK_BAR_MANAGED_FOLDER_DOMAIN_NAME 36606
#define IDS_BOOKMARK_BAR_MANAGED_FOLDER_DEFAULT_NAME 36607
#define IDS_BOOKMARK_EDITOR_TITLE 36608
#define IDS_BOOKMARK_EDITOR_NEW_FOLDER_NAME 36609
#define IDS_BOOKMARK_BUBBLE_REMOVE_BOOKMARK 36610
#define IDS_BOOKMARK_MANAGER_NAME_INPUT_PLACE_HOLDER 36611
#define IDS_BOOKMARK_MANAGER_URL_INPUT_PLACE_HOLDER 36612
#define IDS_TOOLTIP_STAR 36614
#define IDS_CLEAR_BROWSING_DATA_CALCULATING 36617
#define IDS_DEL_BROWSING_HISTORY_COUNTER 36618
#define IDS_DEL_BROWSING_HISTORY_COUNTER_SYNCED 36619
#define IDS_DEL_CACHE_COUNTER_UPPER_ESTIMATE 36620
#define IDS_DEL_CACHE_COUNTER_ALMOST_EMPTY 36621
#define IDS_DEL_CACHE_COUNTER_BASIC 36622
#define IDS_DEL_CACHE_COUNTER_UPPER_ESTIMATE_BASIC 36623
#define IDS_DEL_CACHE_COUNTER_ALMOST_EMPTY_BASIC 36624
#define IDS_ANDROID_DEL_CACHE_COUNTER_ADVANCED 36625
#define IDS_ANDROID_DEL_CACHE_COUNTER_ADVANCED_UPPER_ESTIMATE 36626
#define IDS_ANDROID_DEL_CACHE_COUNTER_ADVANCED_ALMOST_EMPTY 36627
#define IDS_DEL_PASSWORDS_COUNTER 36628
#define IDS_DEL_PASSWORDS_COUNTER_SYNCED 36629
#define IDS_DEL_ACCOUNT_PASSWORDS_COUNTER 36630
#define IDS_DEL_PASSWORDS_DOMAINS_DISPLAY 36631
#define IDS_DEL_PASSWORDS_COUNTER_AND_X_MORE 36632
#define IDS_DEL_SIGNIN_DATA_COUNTER 36633
#define IDS_DEL_PASSWORDS_AND_SIGNIN_DATA_COUNTER_NONE 36634
#define IDS_DEL_PASSWORDS_AND_SIGNIN_DATA_COUNTER_COMBINATION 36635
#define IDS_DEL_SITE_SETTINGS_COUNTER 36636
#define IDS_DEL_AUTOFILL_COUNTER_EMPTY 36637
#define IDS_DEL_AUTOFILL_COUNTER_CREDIT_CARDS 36638
#define IDS_DEL_AUTOFILL_COUNTER_ADDRESSES 36639
#define IDS_DEL_AUTOFILL_COUNTER_SUGGESTIONS 36640
#define IDS_DEL_AUTOFILL_COUNTER_SUGGESTIONS_LONG 36641
#define IDS_DEL_AUTOFILL_COUNTER_SUGGESTIONS_SHORT 36642
#define IDS_DEL_AUTOFILL_COUNTER_ONE_TYPE_SYNCED 36643
#define IDS_DEL_AUTOFILL_COUNTER_TWO_TYPES 36644
#define IDS_DEL_AUTOFILL_COUNTER_TWO_TYPES_SYNCED 36645
#define IDS_DEL_AUTOFILL_COUNTER_THREE_TYPES 36646
#define IDS_DEL_AUTOFILL_COUNTER_THREE_TYPES_SYNCED 36647
#define IDS_DEL_COOKIES_COUNTER 36648
#define IDS_DEL_COOKIES_COUNTER_ADVANCED 36649
#define IDS_DEL_COOKIES_COUNTER_ADVANCED_WITH_SIGNED_IN_EXCEPTION 36650
#define IDS_ANDROID_DEL_COOKIES_COUNTER_ADVANCED 36651
#define IDS_DEL_DOWNLOADS_COUNTER 36652
#define IDS_DEL_HOSTED_APPS_COUNTER 36653
#define IDS_DEL_HOSTED_APPS_COUNTER_AND_X_MORE 36654
#define IDS_DEL_TABS_COUNTER 36655
#define IDS_TABS_COUNT 36656
#define IDS_WINDOWS_COUNT 36657
#define IDS_DEL_TABS_MULTIWINDOW_COUNTER 36658
#define IDS_DISCOUNT_CONTEXTUAL_CONSENT_TITLE 36659
#define IDS_DISCOUNT_CONTEXTUAL_CONSENT_CONTENT 36660
#define IDS_DISCOUNT_CONTEXTUAL_CONSENT_NO_THANKS 36661
#define IDS_DISCOUNT_CONTEXTUAL_CONSENT_GET_DISCOUNTS 36662
#define IDS_DISCOUNT_CONTEXTUAL_CONSENT_ACCEPTED_CONFIRMATION_TITLE 36663
#define IDS_DISCOUNT_CONTEXTUAL_CONSENT_ACCEPTED_CONFIRMATION_CONTENT 36664
#define IDS_DISCOUNT_CONTEXTUAL_CONSENT_ACCEPTED_CONFIRMATION_DONE 36665
#define IDS_NATIVE_NTP_CART_DISCOUNT_CONSENT_ACCEPT_BUTTON 36666
#define IDS_NATIVE_NTP_CART_DISCOUNT_CONSENT_TITLE 36667
#define IDS_NATIVE_NTP_CART_DISCOUNT_CONSENT_BODY 36668
#define IDS_NTP_CART_DISCOUNT_STEP_ONE_CONTENT 36669
#define IDS_OMNIBOX_TRACK_PRICE 36670
#define IDS_OMNIBOX_TRACK_PRICE_DIALOG_TITLE 36671
#define IDS_OMNIBOX_TRACK_PRICE_DIALOG_DESCRIPTION 36672
#define IDS_OMNIBOX_TRACK_PRICE_DIALOG_EMAIL_DESCRIPTION 36673
#define IDS_OMNIBOX_TRACK_PRICE_DIALOG_ACTION_BUTTON 36674
#define IDS_OMNIBOX_TRACK_PRICE_DIALOG_ERROR_DESCRIPTION 36675
#define IDS_OMNIBOX_TRACK_PRICE_DIALOG_ERROR_BUTTON 36676
#define IDS_OMNIBOX_TRACK_PRICE_DIALOG_TITLE_FIRST_RUN 36677
#define IDS_OMNIBOX_TRACK_PRICE_DIALOG_DESCRIPTION_FIRST_RUN 36678
#define IDS_OMNIBOX_TRACK_PRICE_DIALOG_CANCEL_BUTTON 36679
#define IDS_PRICE_TRACKING_SAVE_DESCRIPTION 36680
#define IDS_PRICE_TRACKING_SAVE_LOCATION 36681
#define IDS_PRICE_TRACKING_EMAIL_CONSENT_BODY 36682
#define IDS_PRICE_TRACKING_EMAIL_CONSENT_TITLE 36683
#define IDS_PRICE_TRACKING_EMAIL_CONSENT_LEARN_MORE_LINK_TEXT 36684
#define IDS_PRICE_TRACKING_NOT_NOW 36685
#define IDS_PRICE_TRACKING_YES_IM_IN 36686
#define IDS_OMNIBOX_TRACKING_PRICE 36687
#define IDS_OMNIBOX_TRACKING_PRICE_DIALOG_TITLE 36688
#define IDS_OMNIBOX_TRACKING_PRICE_DIALOG_ACTION_BUTTON 36689
#define IDS_OMNIBOX_TRACKING_PRICE_DIALOG_UNTRACK_BUTTON 36690
#define IDS_OMNIBOX_PRICE_TRACKING_OFF_DIALOG_TITLE 36691
#define IDS_OMNIBOX_PRICE_TRACKING_OFF_DIALOG_DESCRIPTION 36692
#define IDS_OMNIBOX_PRICE_TRACKING_OFF_DIALOG_DESCRIPTION_BOOKMARK_REMOVED 36693
#define IDS_OMNIBOX_PRICE_TRACKING_OFF_DIALOG_ACTION_BUTTON 36694
#define IDS_BOOKMARK_STAR_DIALOG_TRACK_PRICE_DESCRIPTION 36695
#define IDS_BOOKMARK_STAR_DIALOG_TRACK_PRICE_DESCRIPTION_EMAIL_OFF 36696
#define IDS_BOOKMARKS_MANAGER_TRACKED_PRODUCTS 36697
#define IDS_BOOKMARKS_MANAGER_UNTRACK_BUTTON 36698
#define IDS_PRICE_TRACKING_SIDE_PANEL_IPH 36699
#define IDS_SIDE_PANEL_TRACKED_PRODUCTS 36700
#define IDS_PRICE_TRACKING_CHIP_IPH 36701
#define IDS_SIDE_PANEL_UNTRACK_BUTTON 36702
#define IDS_SIDE_PANEL_TRACK_BUTTON 36703
#define IDS_BOOKMARKS_MENU_UNTRACK_PRICE 36704
#define IDS_BOOKMARKS_MENU_TRACK_PRICE 36705
#define IDS_PRICE_TRACKING_UNTRACK_PRODUCT_ACCESSIBILITY 36706
#define IDS_PRICE_TRACKING_TRACK_PRODUCT_ACCESSIBILITY 36707
#define IDS_PRICE_TRACKING_SIDE_PANEL_ERROR_BUTTON 36708
#define IDS_PRICE_TRACKING_SETTINGS_TITLE 36709
#define IDS_PRICE_TRACKING_SETTINGS_EMAIL_DESCRIPTION 36710
#define IDS_PRICE_TRACKING_SETTINGS_POPUP_DESCRIPTION 36711
#define IDS_PRICE_TRACKING_SIDE_PANEL_ERROR_MESSAGE 36712
#define IDS_SHOPPING_COLLECTION_IPH_TITLE 36713
#define IDS_SHOPPING_COLLECTION_IPH_BODY 36714
#define IDS_SHOPPING_INSIGHTS_SIDE_PANEL_TITLE 36715
#define IDS_PRICE_HISTORY_TITLE 36716
#define IDS_PRICE_HISTORY_TITLE_MULTIPLE_OPTIONS 36717
#define IDS_PRICE_HISTORY_MULTIPLE_OPTIONS_LOW_PRICE 36718
#define IDS_PRICE_HISTORY_MULTIPLE_OPTIONS_HIGH_PRICE 36719
#define IDS_PRICE_HISTORY_MULTIPLE_OPTIONS_TYPICAL_PRICE 36720
#define IDS_SHOPPING_INSIGHTS_SIDE_PANEL_TRACK_PRICE_TITLE 36721
#define IDS_SHOPPING_INSIGHTS_ICON_TOOLTIP_TEXT 36722
#define IDS_SHOPPING_INSIGHTS_BUYING_OPTIONS 36723
#define IDS_PRICE_HISTORY_TODAY_PRICE 36724
#define IDS_PRICE_HISTORY_YESTERDAY_PRICE 36725
#define IDS_PRICE_HISTORY_DESCRIPTION 36726
#define IDS_PRICE_HISTORY_GRAPH_ACCESSIBILITY 36727
#define IDS_SHOPPING_INSIGHTS_COLLECT_FEEDBACK 36728
#define IDS_SHOPPING_INSIGHTS_FEEDBACK_FORM_TITLE 36729
#define IDS_PRICE_HISTORY_SINGLE_OPTION_LOW_PRICE 36730
#define IDS_PRICE_HISTORY_SINGLE_OPTION_HIGH_PRICE 36731
#define IDS_PRICE_HISTORY_SINGLE_OPTION_TYPICAL_PRICE 36732
#define IDS_SHOPPING_INSIGHTS_SIDE_PANEL_TRACK_PRICE_DESCRIPTION 36733
#define IDS_SHOPPING_INSIGHTS_SIDE_PANEL_TRACK_PRICE_ERROR 36734
#define IDS_DISCOUNT_USE_THIS_CODE_AT_CHECKOUT 36735
#define IDS_DISCOUNT_EXPIRATION_DATE 36736
#define IDS_DISCOUNT_CODE_COPY_BUTTON_TEXT 36737
#define IDS_TWO_STRINGS_CONNECTOR 36738
#define IDS_TWO_STRINGS_CONNECTOR_WITH_SPACE 36739
#define IDS_SELLER_TERMS_AND_CONDITIONS_DIALOG_TITLE 36740
#define IDS_SELLER_TERMS_AND_CONDITIONS_DIALOG_FOOTER 36741
#define IDS_SEE_SELLER_TERMS_AND_CONDITIONS 36742
#define IDS_DISCOUNT_ICON_EXPANDED_TEXT 36743
#define IDS_PRICE_DROP_POPUP_CONTENT_TITLE 36756
#define IDS_PRICE_DROP_POPUP_CONTENT_TEXT 36757
#define IDS_PRICE_DROP_POPUP_ACTION_BUTTON 36758
#define IDS_PRICE_DROP_POPUP_UNTRACK_BUTTON 36759
#define IDS_PRICE_RANGE_ALL_OPTIONS 36760
#define IDS_PRICE_RANGE_ALL_OPTIONS_ONE_TYPICAL_PRICE 36761
#define IDS_PRICE_RANGE_SINGLE_OPTION 36762
#define IDS_PRICE_RANGE_SINGLE_OPTION_ONE_TYPICAL_PRICE 36763
#define IDS_PRICE_TRACKING_DESCRIPTION 36764
#define IDS_PRICE_INSIGHTS_BUYING_OPTIONS_TITLE 36765
#define IDS_PRICE_INSIGHTS_BUYING_OPTIONS_SUBTITLE 36766
#define IDS_PRICE_INSIGHTS_TRACK_BUTTON_TITLE 36767
#define IDS_PRICE_INSIGHTS_TRACKING_BUTTON_TITLE 36768
#define IDS_INSIGHTS_ICON_EXPANDED_TEXT_GOOD_DEAL 36769
#define IDS_INSIGHTS_ICON_PRICE_HIGH_EXPANDED_TEXT 36770
#define IDS_INSIGHTS_ICON_EXPANDED_TEXT_PRICE_HISTORY 36771
#define IDS_PRICE_INSIGHTS_ACCESSIBILITY 36772
#define IDS_PRICE_HISTORY_TITLE_SINGLE_OPTION 36773
#define IDS_SHOPPING_INSIGHTS_ICON_EXPANDED_TEXT_LOW_PRICE 36774
#define IDS_SHOPPING_INSIGHTS_ICON_EXPANDED_TEXT_HIGH_PRICE 36775
#define IDS_PRICE_INSIGHTS_PRICE_RANGE_TITLE 36776
#define IDS_SHOPPING_COLLECTION_FOLDER_NAME 36777
#define IDS_PRODUCT_SPECIFICATIONS_EMPTY_STATE_TITLE_DESCRIPTION 36778
#define IDS_PRODUCT_SPECIFICATIONS_EMPTY_STATE_TITLE 36779
#define IDS_PRODUCT_SPECIFICATIONS_ENTRY_POINT_DEFAULT 36780
#define IDS_PRODUCT_SPECIFICATIONS_ENTRY_POINT 36781
#define IDS_PRODUCT_SPECIFICATIONS_HISTORY_MENU_ITEM 36782
#define IDS_PRODUCT_SPECIFICATIONS_OPEN_TABS_SECTION 36783
#define IDS_PRODUCT_SPECIFICATIONS_RECENTLY_VIEWED_TABS_SECTION 36784
#define IDS_TOOLTIP_PRODUCT_SPECIFICATIONS_ENTRY_POINT_CLOSE 36785
#define IDS_PRODUCT_SPECIFICATIONS_EMPTY_PRODUCT_SELECTOR 36786
#define IDS_PRODUCT_SPECIFICATIONS_EMPTY_SELECTION_MENU 36787
#define IDS_PRODUCT_SPECIFICATIONS_PAGE_ACTION_ADD_DEFAULT 36788
#define IDS_PRODUCT_SPECIFICATIONS_PAGE_ACTION_ADDED_DEFAULT 36789
#define IDS_PRODUCT_SPECIFICATIONS_PAGE_ACTION_ADD 36790
#define IDS_PRODUCT_SPECIFICATIONS_PAGE_ACTION_ADDED 36791
#define IDS_PRODUCT_SPECIFICATIONS_RENAME_GROUP 36792
#define IDS_PRODUCT_SPECIFICATIONS_ADD_TO_NEW_GROUP 36793
#define IDS_PRODUCT_SPECIFICATIONS_SEE_ALL 36794
#define IDS_PRODUCT_SPECIFICATIONS_DELETE 36795
#define IDS_PRODUCT_SPECIFICATIONS_REMOVE_COLUMN 36796
#define IDS_COMPOSE_SUGGESTION_MAIN_TEXT 36797
#define IDS_COMPOSE_CONTEXT_MENU_TEXT 36798
#define IDS_COMPOSE_SUGGESTION_LABEL 36799
#define IDS_COMPOSE_SUGGESTION_SAVED_TEXT 36800
#define IDS_COMPOSE_SUGGESTION_SAVED_LABEL 36801
#define IDS_COMPOSE_SUGGESTION_AX_MESSAGE_ON_SHOW_PROACTIVE 36802
#define IDS_COMPOSE_SUGGESTION_AX_MESSAGE_ON_SHOW_RESUME 36803
#define IDS_COMPOSE_DONT_SHOW_ON_THIS_SITE_CHILD_SUGGESTION_TEXT 36804
#define IDS_COMPOSE_DISABLE_HELP_ME_WRITE_CHILD_SUGGESTION_TEXT 36805
#define IDS_COMPOSE_GO_TO_SETTINGS_CHILD_SUGGESTION_TEXT 36806
#define IDS_COMPOSE_FRE_TITLE 36807
#define IDS_COMPOSE_FRE_MAIN_TOP 36808
#define IDS_COMPOSE_FRE_MAIN_MID 36809
#define IDS_COMPOSE_FRE_OK_BUTTON 36810
#define IDS_COMPOSE_FRE_MSBB_TITLE 36811
#define IDS_COMPOSE_FRE_MSBB_MAIN 36812
#define IDS_COMPOSE_FRE_MSBB_SETTINGS_BUTTON 36813
#define IDS_COMPOSE_MSBB_IPH_BUBBLE_TEXT 36814
#define IDS_COMPOSE_MSBB_IPH_BUBBLE_TEXT_SCREENREADER 36815
#define IDS_COMPOSE_MSBB_IPH_BUBBLE_CLOSE_BUTTON_LABEL_TEXT 36816
#define IDS_COMPOSE_DIALOG_TITLE 36817
#define IDS_COMPOSE_INPUT_PLACEHOLDER_TITLE 36818
#define IDS_COMPOSE_INPUT_PLACEHOLDER_LINE_1 36819
#define IDS_COMPOSE_INPUT_PLACEHOLDER_LINE_2 36820
#define IDS_COMPOSE_INPUT_PLACEHOLDER_LINE_3 36821
#define IDS_COMPOSE_INPUT_FOOTER 36822
#define IDS_COMPOSE_SUBMIT_BUTTON 36823
#define IDS_COMPOSE_EDIT_UPDATE_BUTTON 36824
#define IDS_COMPOSE_EDIT 36825
#define IDS_COMPOSE_MODIFIERS_MENU_TITLE 36826
#define IDS_COMPOSE_MODIFIERS_MENU_LABEL 36827
#define IDS_COMPOSE_MENU_RETRY_OPTION 36828
#define IDS_COMPOSE_MENU_LENGTH_TITLE 36829
#define IDS_COMPOSE_MENU_SHORTER_OPTION 36830
#define IDS_COMPOSE_MENU_LONGER_OPTION 36831
#define IDS_COMPOSE_MENU_TONE_TITLE 36832
#define IDS_COMPOSE_MENU_CASUAL_OPTION 36833
#define IDS_COMPOSE_MENU_FORMAL_OPTION 36834
#define IDS_COMPOSE_UNDO_BUTTON_TEXT 36835
#define IDS_COMPOSE_UNDO_LABEL 36836
#define IDS_COMPOSE_REDO_BUTTON_TEXT 36837
#define IDS_COMPOSE_REDO_LABEL 36838
#define IDS_COMPOSE_RESUBMIT 36839
#define IDS_COMPOSE_INSERT_BUTTON 36840
#define IDS_COMPOSE_REPLACE_BUTTON 36841
#define IDS_COMPOSE_THUMBS_DOWN 36842
#define IDS_COMPOSE_THUMBS_UP 36843
#define IDS_COMPOSE_RESULT_TEXT_LABEL 36844
#define IDS_COMPOSE_RESULT_LOADING_A11Y_MESSAGE 36845
#define IDS_COMPOSE_RESULT_UPDATED_A11Y_MESSAGE 36846
#define IDS_COMPOSE_UNDO_RESULT_A11Y_MESSAGE 36847
#define IDS_COMPOSE_REDO_RESULT_A11Y_MESSAGE 36848
#define IDS_COMPOSE_ERROR_TOO_SHORT 36849
#define IDS_COMPOSE_ERROR_TOO_LONG 36850
#define IDS_COMPOSE_ERROR_TRY_AGAIN 36851
#define IDS_COMPOSE_ERROR_TRY_AGAIN_LATER 36852
#define IDS_COMPOSE_ERROR_FILTERED 36853
#define IDS_COMPOSE_ERROR_FILTERED_BACK_BUTTON 36854
#define IDS_COMPOSE_ERROR_UNSUPPORTED_LANGUAGE 36855
#define IDS_COMPOSE_ERROR_PERMISSION_DENIED 36856
#define IDS_COMPOSE_ERROR_REQUEST_THROTTLED 36857
#define IDS_COMPOSE_ERROR_OFFLINE 36858
#define IDS_COMPOSE_FOOTER_FISHFOOD 36859
#define IDS_COMPOSE_EXPERIMENTAL_DISCLAIMER_FOOTER 36860
#define IDS_COMPOSE_REFINEMENTS_EXPERIMENTAL_DISCLAIMER_FOOTER 36861
#define IDS_COMPOSE_FOOTER_FISHFOOD_ON_DEVICE_USED 36862
#define IDS_COMPOSE_FEEDBACK_PLACEHOLDER 36863
#define IDS_LIVE_CAPTION_BUBBLE_TITLE 36864
#define IDS_LIVE_CAPTION_BUBBLE_CLOSE 36865
#define IDS_LIVE_CAPTION_BUBBLE_EXPAND 36866
#define IDS_LIVE_CAPTION_BUBBLE_COLLAPSE 36867
#define IDS_LIVE_CAPTION_BUBBLE_BACK_TO_TAB 36868
#define IDS_LIVE_CAPTION_BUBBLE_PIN 36869
#define IDS_LIVE_CAPTION_BUBBLE_UNPIN 36870
#define IDS_LIVE_CAPTION_BUBBLE_ERROR 36871
#define IDS_LIVE_CAPTION_BUBBLE_CONTENT_SETTINGS 36872
#define IDS_LIVE_CAPTION_BUBBLE_MEDIA_FOUNDATION_RENDERER_ERROR 36873
#define IDS_LIVE_CAPTION_BUBBLE_MEDIA_FOUNDATION_RENDERER_ERROR_CHECKBOX 36874
#define IDS_LIVE_CAPTION_BUBBLE_APPEAR_SCREENREADER_ANNOUNCEMENT 36875
#define IDS_LIVE_CAPTION_CAPTION_LANGUAGE_AUTODETECTED 36876
#define IDS_LIVE_CAPTION_TRANSLATED_CAPTION_LANGUAGE 36877
#define IDS_LIVE_CAPTION_TRANSLATED_CAPTION_LANGUAGE_AUTODETECTED 36878
#define IDS_LIVE_CAPTION_BUBBLE_CAPTION_SETTINGS 36879
#define IDS_LIVE_CAPTION_DOWNLOAD_PROGRESS 36880
#define IDS_LIVE_CAPTION_LANGUAGE_DOWNLOAD_FAILED 36881
#define IDS_SETTINGS_TITLE 36882
#define IDS_SETTINGS_HIDE_ADVANCED_SETTINGS 36883
#define IDS_SETTINGS_SHOW_ADVANCED_SETTINGS 36884
#define IDS_NETWORK_PREDICTION_ENABLED_DESCRIPTION 36885
#define IDS_OPTIONS_PROXIES_CONFIGURE_BUTTON 36886
#define IDS_CRASH_TITLE 36887
#define IDS_CRASH_CRASH_COUNT_BANNER_FORMAT 36888
#define IDS_CRASH_SHOW_DEVELOPER_DETAILS 36889
#define IDS_CRASH_CAPTURE_TIME_FORMAT 36890
#define IDS_CRASH_REPORT_STATUS 36891
#define IDS_CRASH_REPORT_STATUS_NOT_UPLOADED 36892
#define IDS_CRASH_REPORT_STATUS_PENDING 36893
#define IDS_CRASH_REPORT_STATUS_PENDING_USER_REQUESTED 36894
#define IDS_CRASH_REPORT_STATUS_UPLOADED 36895
#define IDS_CRASH_REPORT_UPLOADED_ID 36896
#define IDS_CRASH_REPORT_UPLOADED_TIME 36897
#define IDS_CRASH_REPORT_LOCAL_ID 36898
#define IDS_CRASH_REPORT_FILE_SIZE 36899
#define IDS_CRASH_BUG_LINK_LABEL 36900
#define IDS_CRASH_NO_CRASHES_MESSAGE 36901
#define IDS_CRASH_DISABLED_HEADER 36902
#define IDS_CRASH_UPLOAD_MESSAGE 36903
#define IDS_CRASH_UPLOAD_NOW_LINK_TEXT 36904
#define IDS_HTTP_POST_WARNING_TITLE 36905
#define IDS_HTTP_POST_WARNING 36906
#define IDS_HTTP_POST_WARNING_RESEND 36907
#define IDS_DOM_DISTILLER_JAVASCRIPT_DISABLED_CONTENT 36908
#define IDS_DOM_DISTILLER_WEBUI_ENTRY_URL 36909
#define IDS_DOM_DISTILLER_WEBUI_ENTRY_ADD 36910
#define IDS_DOM_DISTILLER_WEBUI_ENTRY_ADD_FAILED 36911
#define IDS_DOM_DISTILLER_WEBUI_VIEW_URL 36912
#define IDS_DOM_DISTILLER_WEBUI_VIEW_URL_FAILED 36913
#define IDS_DOM_DISTILLER_WEBUI_REFRESH 36914
#define IDS_DOM_DISTILLER_WEBUI_FETCHING_ENTRIES 36915
#define IDS_DOM_DISTILLER_VIEWER_FAILED_TO_FIND_ARTICLE_TITLE 36916
#define IDS_DOM_DISTILLER_VIEWER_FAILED_TO_FIND_ARTICLE_CONTENT 36917
#define IDS_DOM_DISTILLER_VIEWER_LOADING_TITLE 36918
#define IDS_DOM_DISTILLER_VIEWER_CUSTOMIZE_APPEARANCE 36919
#define IDS_DOM_DISTILLER_VIEWER_FONT_STYLE 36920
#define IDS_DOM_DISTILLER_VIEWER_SANS_SERIF_FONT 36921
#define IDS_DOM_DISTILLER_VIEWER_SERIF_FONT 36922
#define IDS_DOM_DISTILLER_VIEWER_MONOSPACE_FONT 36923
#define IDS_DOM_DISTILLER_VIEWER_PAGE_COLOR 36924
#define IDS_DOM_DISTILLER_VIEWER_PAGE_COLOR_LIGHT 36925
#define IDS_DOM_DISTILLER_VIEWER_PAGE_COLOR_SEPIA 36926
#define IDS_DOM_DISTILLER_VIEWER_PAGE_COLOR_DARK 36927
#define IDS_DOM_DISTILLER_VIEWER_FONT_SIZE 36928
#define IDS_DOM_DISTILLER_VIEWER_FONT_SIZE_SMALL 36929
#define IDS_DOM_DISTILLER_VIEWER_FONT_SIZE_LARGE 36930
#define IDS_DOM_DISTILLER_VIEWER_CLOSE 36931
#define IDS_DOM_DISTILLER_VIEWER_NO_DATA_CONTENT 36932
#define IDS_DOM_DISTILLER_WEBUI_TITLE 36933
#define IDS_DOM_DISTILLER_VIEWER_TITLE_SUFFIX 36934
#define IDS_ENTERPRISE_COPY_PREVENTION_MISSING_LIST_ERROR 36935
#define IDS_ENTERPRISE_COPY_PREVENTION_DISABLE_CONTAINS_WILDCARD_ERROR 36936
#define IDS_ENTERPRISE_COPY_PREVENTION_WARNING_MESSAGE 36937
#define IDS_ENTERPRISE_DATA_CONTROLS_COPY_PREVENTION_WARNING_MESSAGE 36938
#define IDS_ERRORPAGE_NET_BUTTON_DETAILS 36939
#define IDS_ERRORPAGE_NET_BUTTON_HIDE_DETAILS 36940
#define IDS_ERRORPAGES_BUTTON_RELOAD 36941
#define IDS_ERRORPAGES_BUTTON_SHOW_SAVED_COPY 36942
#define IDS_ERRORPAGE_FUN_DISABLED 36943
#define IDS_ERRORPAGES_SUGGESTION_RELOAD_REPOST_SUMMARY 36953
#define IDS_ERRORPAGES_SUGGESTION_RELOAD_PRIVATE_NETWORK_ACCESS 36954
#define IDS_ERRORPAGES_SUGGESTION_CHECK_CONNECTION_HEADER 36955
#define IDS_ERRORPAGES_SUGGESTION_CHECK_CONNECTION_BODY 36956
#define IDS_ERRORPAGES_SUGGESTION_SECURE_DNS_CONFIG_HEADER 36957
#define IDS_ERRORPAGES_SUGGESTION_SECURE_DNS_CONFIG_BODY 36958
#define IDS_ERRORPAGES_SUGGESTION_DNS_CONFIG_HEADER 36959
#define IDS_ERRORPAGES_SUGGESTION_DNS_CONFIG_BODY 36960
#define IDS_ERRORPAGES_SUGGESTION_NETWORK_PREDICTION_HEADER 36961
#define IDS_ERRORPAGES_SUGGESTION_FIREWALL_CONFIG_BODY 36962
#define IDS_ERRORPAGES_SUGGESTION_PROXY_CONFIG_HEADER 36963
#define IDS_ERRORPAGES_SUGGESTION_PROXY_CONFIG_BODY 36964
#define IDS_ERRORPAGES_SUGGESTION_CAPTIVE_PORTAL_SIGNIN 36965
#define IDS_ERRORPAGES_SUGGESTION_VIEW_POLICIES_HEADER 36967
#define IDS_ERRORPAGES_SUGGESTION_VIEW_POLICIES_BODY 36968
#define IDS_ERRORPAGES_SUGGESTION_UNSUPPORTED_CIPHER_HEADER 36969
#define IDS_ERRORPAGES_SUGGESTION_UNSUPPORTED_CIPHER_BODY 36970
#define IDS_ERRORPAGES_SUGGESTION_NAVIGATE_TO_ORIGIN 36971
#define IDS_ERRORPAGES_HEADING_NOT_AVAILABLE 36972
#define IDS_ERRORPAGES_HEADING_NETWORK_ACCESS_DENIED 36973
#define IDS_ERRORPAGES_HEADING_INTERNET_DISCONNECTED 36974
#define IDS_ERRORPAGES_HEADING_YOU_ARE_OFFLINE 36975
#define IDS_ERRORPAGES_MESSAGE_IWA_INVALID_WEB_BUNDLE 36976
#define IDS_ERRORPAGES_MESSAGE_IWA_CONNECTION_REFUSED 36977
#define IDS_ERRORPAGES_HEADING_CACHE_READ_FAILURE 36978
#define IDS_ERRORPAGES_HEADING_CONNECTION_INTERRUPTED 36979
#define IDS_ERRORPAGES_HEADING_NOT_FOUND 36980
#define IDS_ERRORPAGES_HEADING_FILE_NOT_FOUND 36981
#define IDS_ERRORPAGES_HEADING_BLOCKED 36982
#define IDS_ERRORPAGES_HEADING_BLOCKED_SCHEME 36983
#define IDS_ERRORPAGES_SUMMARY_NOT_AVAILABLE 36984
#define IDS_ERRORPAGES_SUMMARY_TIMED_OUT 36985
#define IDS_ERRORPAGES_SUMMARY_CONNECTION_RESET 36986
#define IDS_ERRORPAGES_SUMMARY_CONNECTION_CLOSED 36987
#define IDS_ERRORPAGES_SUMMARY_CONNECTION_FAILED 36988
#define IDS_ERRORPAGES_SUMMARY_NETWORK_CHANGED 36989
#define IDS_ERRORPAGES_SUMMARY_CONNECTION_REFUSED 36990
#define IDS_ERRORPAGES_SUMMARY_NAME_NOT_RESOLVED 36991
#define IDS_ERRORPAGES_SUMMARY_ICANN_NAME_COLLISION 36992
#define IDS_ERRORPAGES_SUMMARY_ADDRESS_UNREACHABLE 36993
#define IDS_ERRORPAGES_SUMMARY_FILE_ACCESS_DENIED 36994
#define IDS_ERRORPAGES_SUMMARY_NETWORK_ACCESS_DENIED 36995
#define IDS_ERRORPAGES_SUMMARY_PROXY_CONNECTION_FAILED 36996
#define IDS_ERRORPAGES_SUMMARY_CACHE_READ_FAILURE 36997
#define IDS_ERRORPAGES_SUMMARY_NETWORK_IO_SUSPENDED 36998
#define IDS_ERRORPAGES_SUMMARY_NOT_FOUND 36999
#define IDS_ERRORPAGES_SUMMARY_FILE_NOT_FOUND 37000
#define IDS_ERRORPAGES_SUMMARY_TOO_MANY_REDIRECTS 37001
#define IDS_ERRORPAGES_SUMMARY_EMPTY_RESPONSE 37002
#define IDS_ERRORPAGES_SUMMARY_INVALID_RESPONSE 37003
#define IDS_ERRORPAGES_SUMMARY_DNS_PROBE_RUNNING 37004
#define IDS_ERRORPAGES_HEADING_ACCESS_DENIED 37005
#define IDS_ERRORPAGES_HEADING_FILE_ACCESS_DENIED 37006
#define IDS_ERRORPAGES_SUMMARY_FORBIDDEN 37007
#define IDS_ERRORPAGES_SUMMARY_GONE 37008
#define IDS_ERRORPAGES_HEADING_PAGE_NOT_WORKING 37009
#define IDS_ERRORPAGES_SUMMARY_CONTACT_SITE_OWNER 37010
#define IDS_ERRORPAGES_SUMMARY_WEBSITE_CANNOT_HANDLE_REQUEST 37011
#define IDS_ERRORPAGES_SUMMARY_GATEWAY_TIMEOUT 37012
#define IDS_ERRORPAGES_SUMMARY_SSL_SECURITY_ERROR 37013
#define IDS_ERRORPAGES_SUMMARY_SSL_VERSION_OR_CIPHER_MISMATCH 37014
#define IDS_ERRORPAGES_HEADING_INSECURE_CONNECTION 37015
#define IDS_ERRORPAGES_SUMMARY_BAD_SSL_CLIENT_AUTH_CERT 37016
#define IDS_ERRORPAGES_SUMMARY_BLOCKED_BY_EXTENSION 37017
#define IDS_ERRORPAGES_SUMMARY_BLOCKED_BY_ADMINISTRATOR 37018
#define IDS_ERRORPAGES_SUMMARY_BLOCKED_BY_SECURITY 37019
#define IDS_ERRORPAGES_SUMMARY_BLOCKED_BY_PRIVATE_NETWORK_ACCESS_CHECKS 37020
#define IDS_ERRORPAGES_HTTP_POST_WARNING 37021
#define IDS_ERRORPAGES_HEADING_LINKPREVIEW_NON_HTTPS_FORBIDDEN 37022
#define IDS_ERRORPAGES_SUMMARY_LINKPREVIEW_NON_HTTPS_FORBIDDEN 37023
#define IDS_ERRORPAGES_SUGGESTION_LIST_HEADER 37024
#define IDS_ERRORPAGES_SUGGESTION_CHECK_CONNECTION_SUMMARY 37025
#define IDS_ERRORPAGES_SUGGESTION_CHECK_PROXY_FIREWALL_DNS_SUMMARY 37027
#define IDS_ERRORPAGES_SUGGESTION_CHECK_PROXY_FIREWALL_SECURE_DNS_SUMMARY 37028
#define IDS_ERRORPAGES_SUGGESTION_CHECK_FIREWALL_ANTIVIRUS_SUMMARY 37029
#define IDS_ERRORPAGES_SUGGESTION_CHECK_PROXY_FIREWALL_SUMMARY 37030
#define IDS_ERRORPAGES_SUGGESTION_CHECK_PROXY_ADDRESS_SUMMARY 37031
#define IDS_ERRORPAGES_SUGGESTION_CONTACT_ADMIN_SUMMARY 37032
#define IDS_ERRORPAGES_SUGGESTION_CONTACT_ADMIN_SUMMARY_STANDALONE 37033
#define IDS_ERRORPAGES_SUGGESTION_LEARNMORE_SUMMARY 37034
#define IDS_ERRORPAGES_SUGGESTION_LEARNMORE_SUMMARY_STANDALONE 37035
#define IDS_ERRORPAGES_SUGGESTION_DELETE_COOKIES_SUMMARY 37036
#define IDS_ERRORPAGES_SUGGESTION_CHECK_HARDWARE_SUMMARY 37040
#define IDS_ERRORPAGES_SUGGESTION_CHECK_WIFI_SUMMARY 37041
#define IDS_ERRORPAGES_SUGGESTION_DISABLE_EXTENSION_SUMMARY 37042
#define IDS_ERRORPAGES_CHECK_TYPO_SUMMARY 37043
#define IDS_ERRORPAGES_GAME_INSTRUCTIONS 37047
#define IDS_ERRORPAGE_DINO_GAME_DESCRIPTION 37048
#define IDS_ERRORPAGE_DINO_ARIA_LABEL 37049
#define IDS_ERRORPAGE_DINO_GAME_START 37050
#define IDS_ERRORPAGE_DINO_GAME_OVER 37051
#define IDS_ERRORPAGE_DINO_HIGH_SCORE 37052
#define IDS_ERRORPAGE_DINO_JUMP 37053
#define IDS_ERRORPAGE_DINO_SLOW_SPEED_TOGGLE 37054
#define IDS_FIND_IN_PAGE_ACCESSIBLE_TITLE 37055
#define IDS_FIND_IN_PAGE_COUNT 37056
#define IDS_ACCESSIBLE_FIND_IN_PAGE_COUNT 37057
#define IDS_ACCESSIBLE_FIND_IN_PAGE_NO_RESULTS 37058
#define IDS_FIND_IN_PAGE_PREVIOUS_TOOLTIP 37059
#define IDS_FIND_IN_PAGE_NEXT_TOOLTIP 37060
#define IDS_FIND_IN_PAGE_CLOSE_TOOLTIP 37061
#define IDS_FLAGS_UI_SEARCH_PLACEHOLDER 37062
#define IDS_FLAGS_UI_SEARCH_LABEL 37063
#define IDS_FLAGS_UI_TITLE 37064
#define IDS_FLAGS_UI_PAGE_RESET 37065
#define IDS_FLAGS_UI_PAGE_WARNING 37066
#define IDS_FLAGS_UI_PAGE_WARNING_EXPLANATION 37067
#define IDS_FLAGS_UI_OWNER_WARNING 37068
#define IDS_FLAGS_UI_AVAILABLE_FEATURE 37069
#define IDS_FLAGS_UI_UNAVAILABLE_FEATURE 37070
#define IDS_FLAGS_UI_ENABLED_FEATURE 37071
#define IDS_FLAGS_UI_DISABLED_FEATURE 37072
#define IDS_FLAGS_UI_NO_RESULTS 37073
#define IDS_FLAGS_UI_NOT_AVAILABLE_ON_PLATFORM 37074
#define IDS_FLAGS_UI_RELAUNCH 37075
#define IDS_FLAGS_UI_CLEAR_SEARCH 37079
#define IDS_FLAGS_UI_RESET_ACKNOWLEDGED 37080
#define IDS_FLAGS_UI_EXPERIMENT_ENABLED 37081
#define IDS_FLAGS_UI_SEARCH_RESULTS_SINGULAR 37082
#define IDS_FLAGS_UI_SEARCH_RESULTS_PLURAL 37083
#define IDS_DEPRECATED_FEATURES_OWNER_WARNING 37084
#define IDS_DEPRECATED_FEATURES_SEARCH_PLACEHOLDER 37085
#define IDS_DEPRECATED_FEATURES_TITLE 37086
#define IDS_DEPRECATED_FEATURES_HEADING 37087
#define IDS_DEPRECATED_FEATURES_PAGE_WARNING_EXPLANATION 37088
#define IDS_DEPRECATED_FEATURES_NO_RESULTS 37089
#define IDS_EXIT_FULLSCREEN_MODE 37090
#define IDS_FULLSCREEN_HOLD_TO_EXIT_FULLSCREEN 37091
#define IDS_FULLSCREEN_PRESS_TO_EXIT_FULLSCREEN 37092
#define IDS_FULLSCREEN_PRESS_TO_EXIT_FULLSCREEN_TWO_KEYS 37093
#define IDS_PRESS_TO_EXIT_MOUSELOCK 37094
#define IDS_PRESS_TO_EXIT_MOUSELOCK_TWO_KEYS 37095
#define IDS_FULLSCREEN_HOLD_TO_SEE_DOWNLOADS 37096
#define IDS_FULLSCREEN_PRESS_TO_SEE_DOWNLOADS 37097
#define IDS_FULLSCREEN_PRESS_TO_SEE_DOWNLOADS_AND_EXIT 37098
#define IDS_FULLSCREEN_HOLD_TO_SEE_DOWNLOADS_AND_EXIT 37099
#define IDS_GLOBAL_MEDIA_CONTROLS_BACK_TO_TAB 37100
#define IDS_GLOBAL_MEDIA_CONTROLS_DISMISS_ICON_TOOLTIP_TEXT 37101
#define IDS_GLOBAL_MEDIA_CONTROLS_CAST_TO_TEXT 37102
#define IDS_GLOBAL_MEDIA_CONTROLS_CLOSE_DEVICE_LIST_TEXT 37103
#define IDS_GLOBAL_MEDIA_CONTROLS_UNKNOWN_SOURCE_TEXT 37104
#define IDS_GLOBAL_MEDIA_CONTROLS_UNKNOWN_DEVICE_TEXT 37105
#define IDS_HEAVY_AD_INTERVENTION_BUTTON_DETAILS 37106
#define IDS_HEAVY_AD_INTERVENTION_HEADING 37107
#define IDS_HEAVY_AD_INTERVENTION_SUMMARY 37108
#define IDS_HEAVY_AD_INTERVENTION_BUTTON_RELOAD 37109
#define IDS_HISTORY_ACTION_MENU_DESCRIPTION 37110
#define IDS_HISTORY_ARIA_ROLE_DESCRIPTION 37111
#define IDS_HISTORY_CANCEL_EDITING_BUTTON 37112
#define IDS_HISTORY_DATE_WITH_RELATIVE_TIME 37113
#define IDS_HISTORY_DELETE_PRIOR_VISITS_CONFIRM_BUTTON 37114
#define IDS_HISTORY_DELETE_PRIOR_VISITS_WARNING 37115
#define IDS_HISTORY_DELETE_SELECTED_ENTRIES_BUTTON 37116
#define IDS_HISTORY_ENTRY_ACCESSIBILITY_DELETE 37117
#define IDS_HISTORY_ENTRY_ACCESSIBILITY_LABEL 37118
#define IDS_HISTORY_ENTRY_BOOKMARKED 37119
#define IDS_HISTORY_ENTRY_SUMMARY 37120
#define IDS_HISTORY_FOUND_SEARCH_RESULTS 37121
#define IDS_HISTORY_OTHER_FORMS_OF_HISTORY 37122
#define IDS_HISTORY_LOADING 37123
#define IDS_HISTORY_MORE_FROM_SITE 37124
#define IDS_HISTORY_NO_RESULTS 37125
#define IDS_HISTORY_NO_SEARCH_RESULTS 37126
#define IDS_HISTORY_OPEN_CLEAR_BROWSING_DATA_DIALOG 37127
#define IDS_HISTORY_OTHER_SESSIONS_COLLAPSE_SESSION 37128
#define IDS_HISTORY_OTHER_SESSIONS_EXPAND_SESSION 37129
#define IDS_HISTORY_OTHER_SESSIONS_HIDE_FOR_NOW 37130
#define IDS_HISTORY_OTHER_SESSIONS_OPEN_ALL 37131
#define IDS_HISTORY_REMOVE_BOOKMARK 37132
#define IDS_HISTORY_REMOVE_PAGE 37133
#define IDS_HISTORY_REMOVE_PAGE_SUCCESS 37134
#define IDS_HISTORY_REMOVE_SELECTED_ITEMS 37135
#define IDS_HISTORY_SEARCH_BUTTON 37136
#define IDS_HISTORY_SEARCH_RESULT 37137
#define IDS_HISTORY_SEARCH_RESULTS 37138
#define IDS_HISTORY_SHOW_HISTORY 37139
#define IDS_HISTORY_SHOWFULLHISTORY_LINK 37140
#define IDS_HISTORY_START_EDITING_BUTTON 37141
#define IDS_HISTORY_TITLE 37142
#define IDS_HISTORY_UNKNOWN_DEVICE 37143
#define IDS_HISTORY_EMBEDDINGS_DISCLAIMER 37144
#define IDS_HISTORY_EMBEDDINGS_PROMO_HEADING 37145
#define IDS_HISTORY_EMBEDDINGS_PROMO_BODY 37146
#define IDS_HISTORY_EMBEDDINGS_SHOW_BY_DATE 37147
#define IDS_HISTORY_EMBEDDINGS_SHOW_BY_GROUP 37148
#define IDS_HISTORY_EMBEDDINGS_SUGGESTION_1 37149
#define IDS_HISTORY_EMBEDDINGS_SUGGESTION_2 37150
#define IDS_HISTORY_EMBEDDINGS_SUGGESTION_3 37151
#define IDS_HISTORY_EMBEDDINGS_SUGGESTION_1_ARIA_LABEL 37152
#define IDS_HISTORY_EMBEDDINGS_SUGGESTION_2_ARIA_LABEL 37153
#define IDS_HISTORY_EMBEDDINGS_SUGGESTION_3_ARIA_LABEL 37154
#define IDS_HISTORY_EMBEDDINGS_HEADING 37155
#define IDS_HISTORY_EMBEDDINGS_HEADING_LOADING 37156
#define IDS_HISTORY_EMBEDDINGS_FOOTER 37157
#define IDS_HISTORY_EMBEDDINGS_THUMBS_UP 37158
#define IDS_HISTORY_EMBEDDINGS_THUMBS_DOWN 37159
#define IDS_JAVASCRIPT_MESSAGEBOX_TITLE 37160
#define IDS_JAVASCRIPT_MESSAGEBOX_TITLE_IFRAME 37161
#define IDS_JAVASCRIPT_MESSAGEBOX_TITLE_NONSTANDARD_URL 37162
#define IDS_JAVASCRIPT_MESSAGEBOX_TITLE_NONSTANDARD_URL_IFRAME 37163
#define IDS_JAVASCRIPT_MESSAGEBOX_SUPPRESS_OPTION 37164
#define IDS_BEFOREUNLOAD_MESSAGEBOX_TITLE 37165
#define IDS_BEFOREUNLOAD_APP_MESSAGEBOX_TITLE 37166
#define IDS_BEFOREUNLOAD_MESSAGEBOX_OK_BUTTON_LABEL 37167
#define IDS_BEFOREUNLOAD_MESSAGEBOX_MESSAGE 37168
#define IDS_BEFORERELOAD_MESSAGEBOX_TITLE 37169
#define IDS_BEFORERELOAD_APP_MESSAGEBOX_TITLE 37170
#define IDS_BEFORERELOAD_MESSAGEBOX_OK_BUTTON_LABEL 37171
#define IDS_LOGIN_DIALOG_TITLE 37172
#define IDS_LOGIN_DIALOG_OK_BUTTON_LABEL 37173
#define IDS_LOGIN_DIALOG_AUTHORITY 37174
#define IDS_LOGIN_DIALOG_PROXY_AUTHORITY 37175
#define IDS_LOGIN_DIALOG_NOT_PRIVATE 37176
#define IDS_LOGIN_DIALOG_USERNAME_FIELD 37177
#define IDS_LOGIN_DIALOG_PASSWORD_FIELD 37178
#define IDS_MANAGEMENT_TITLE 37179
#define IDS_MANAGEMENT_TOOLBAR_TITLE 37180
#define IDS_MANAGEMENT_SUBTITLE 37184
#define IDS_MANAGEMENT_SUBTITLE_MANAGED_BY 37182
#define IDS_MANAGEMENT_NOT_MANAGED_SUBTITLE 37183
#define IDS_MANAGEMENT_SUBTITLE_BROWSER_AND_PROFILE_DIFFERENT_MANAGED_BY 37185
#define IDS_MANAGEMENT_SUBTITLE_BROWSER_MANAGED_AND_PROFILE_MANAGED_BY 37186
#define IDS_MANAGEMENT_SUBTITLE_BROWSER_AND_PROFILE_SAME_MANAGED_BY 37187
#define IDS_MANAGEMENT_SUBTITLE_PROFILE_MANAGED_BY 37188
#define IDS_MANAGEMENT_BROWSER_NOTICE 37189
#define IDS_MANAGEMENT_NOT_MANAGED_NOTICE 37190
#define IDS_MANAGEMENT_PROFILE_NOTICE 37191
#define IDS_MANAGEMENT_LEARN_MORE_ACCCESSIBILITY_TEXT 37192
#define IDS_MANAGEMENT_EXTENSION_REPORTING 37235
#define IDS_MANAGEMENT_EXTENSIONS_INSTALLED 37236
#define IDS_MANAGEMENT_EXTENSIONS_INSTALLED_BY 37237
#define IDS_MANAGEMENT_EXTENSIONS_NAME 37238
#define IDS_MANAGEMENT_EXTENSIONS_PERMISSIONS 37239
#define IDS_MANAGEMENT_APPLICATION_REPORTING 37240
#define IDS_MANAGEMENT_APPLICATIONS_INSTALLED 37241
#define IDS_MANAGEMENT_APPLICATIONS_INSTALLED_BY 37242
#define IDS_MANAGEMENT_APPLICATIONS_NAME 37243
#define IDS_MANAGEMENT_APPLICATIONS_PERMISSIONS 37244
#define IDS_MANAGEMENT_APPLICATIONS_RUN_ON_OS_LOGIN 37245
#define IDS_MANAGEMENT_MANAGED_WEBSITES 37246
#define IDS_MANAGEMENT_MANAGED_WEBSITES_EXPLANATION 37247
#define IDS_MANAGEMENT_MANAGED_WEBSITES_BY_EXPLANATION 37248
#define IDS_MANAGEMENT_BROWSER_REPORTING 37249
#define IDS_MANAGEMENT_BROWSER_REPORTING_EXPLANATION 37250
#define IDS_MANAGEMENT_EXTENSION_REPORT_MACHINE_NAME 37251
#define IDS_MANAGEMENT_EXTENSION_REPORT_MACHINE_NAME_ADDRESS 37252
#define IDS_MANAGEMENT_EXTENSION_REPORT_USERNAME 37253
#define IDS_MANAGEMENT_EXTENSION_REPORT_VERSION 37254
#define IDS_MANAGEMENT_EXTENSION_REPORT_EXTENSIONS_PLUGINS 37255
#define IDS_MANAGEMENT_EXTENSION_REPORT_USER_BROWSING_DATA 37256
#define IDS_MANAGEMENT_EXTENSION_REPORT_PERF_CRASH 37257
#define IDS_MANAGEMENT_LEGACY_TECH_REPORT 37258
#define IDS_MANAGEMENT_PROFILE_REPORTING_EXPLANATION 37259
#define IDS_MANAGEMENT_PROFILE_REPORTING_OVERVIEW 37260
#define IDS_MANAGEMENT_PROFILE_REPORTING_USERNAME 37261
#define IDS_MANAGEMENT_PROFILE_REPORTING_BROWSER 37262
#define IDS_MANAGEMENT_PROFILE_REPORTING_EXTENSION 37263
#define IDS_MANAGEMENT_PROFILE_REPORTING_POLICY 37264
#define IDS_MANAGEMENT_THREAT_PROTECTION 37265
#define IDS_MANAGEMENT_THREAT_PROTECTION_DESCRIPTION 37266
#define IDS_MANAGEMENT_THREAT_PROTECTION_DESCRIPTION_BY 37267
#define IDS_MANAGEMENT_CONNECTORS_EVENT 37268
#define IDS_MANAGEMENT_CONNECTORS_VISIBLE_DATA 37269
#define IDS_MANAGEMENT_FILE_ATTACHED_EVENT 37270
#define IDS_MANAGEMENT_FILE_DOWNLOADED_EVENT 37271
#define IDS_MANAGEMENT_TEXT_ENTERED_EVENT 37272
#define IDS_MANAGEMENT_PAGE_PRINTED_EVENT 37273
#define IDS_MANAGEMENT_FILE_TRANSFER_EVENT 37274
#define IDS_MANAGEMENT_ENTERPRISE_REPORTING_EVENT 37275
#define IDS_MANAGEMENT_PAGE_VISITED_EVENT 37276
#define IDS_MANAGEMENT_SCREEN_CAPTURE_EVENT 37277
#define IDS_MANAGEMENT_FILE_ATTACHED_VISIBLE_DATA 37278
#define IDS_MANAGEMENT_FILE_DOWNLOADED_VISIBLE_DATA 37279
#define IDS_MANAGEMENT_TEXT_ENTERED_VISIBLE_DATA 37280
#define IDS_MANAGEMENT_PAGE_PRINTED_VISIBLE_DATA 37281
#define IDS_MANAGEMENT_FILE_TRANSFER_VISIBLE_DATA 37282
#define IDS_MANAGEMENT_SCREEN_CAPTURE_DATA 37283
#define IDS_MANAGEMENT_ENTERPRISE_REPORTING_VISIBLE_DATA 37284
#define IDS_MANAGEMENT_PAGE_VISITED_VISIBLE_DATA 37285
#define IDS_MANAGEMENT_DEVICE_SIGNALS_DISCLOSURE 37286
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_ACTION_PREVIOUS_TRACK 37287
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_ACTION_SEEK_BACKWARD 37288
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_ACTION_REPLAY_10 37289
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_ACTION_PLAY 37290
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_ACTION_PAUSE 37291
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_ACTION_FORWARD_10 37292
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_ACTION_SEEK_FORWARD 37293
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_ACTION_NEXT_TRACK 37294
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_ACTION_ENTER_PIP 37295
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_ACTION_EXIT_PIP 37296
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_ACTION_MUTE 37297
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_ACTION_UNMUTE 37298
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_ACTION_SHOW_DEVICE_LIST 37299
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_ACTION_HIDE_DEVICE_LIST 37300
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_ACTION_STOP_CASTING 37301
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_TIME_SCRUBBER 37302
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_ACCESSIBLE_NAME 37303
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_LABEL 37304
#define IDS_DEFAULT_TAB_TITLE 37305
#define IDS_DOWNLOAD_TAB_TITLE 37306
#define IDS_SAD_TAB_TITLE 37307
#define IDS_SAD_TAB_MESSAGE 37308
#define IDS_SAD_TAB_HELP_MESSAGE 37309
#define IDS_SAD_TAB_HELP_LINK 37310
#define IDS_SAD_TAB_RELOAD_LABEL 37311
#define IDS_SAD_TAB_RELOAD_TITLE 37314
#define IDS_SAD_TAB_OOM_MESSAGE_TABS 37315
#define IDS_SAD_TAB_OOM_MESSAGE_NOTABS 37316
#define IDS_SAD_TAB_RELOAD_TRY 37317
#define IDS_SAD_TAB_RELOAD_INCOGNITO 37318
#define IDS_SAD_TAB_RELOAD_CLOSE_TABS 37319
#define IDS_SAD_TAB_RELOAD_CLOSE_NOTABS 37320
#define IDS_SAD_TAB_RELOAD_RESTART_BROWSER 37321
#define IDS_SAD_TAB_RELOAD_RESTART_DEVICE 37322
#define IDS_SAD_TAB_ERROR_CODE 37324
#define IDS_NEW_TAB_TITLE 37325
#define IDS_NEW_INCOGNITO_TAB_TITLE 37326
#define IDS_INCOGNITO_TAB_LEARN_MORE_ACCESSIBILITY_LABEL 37327
#define IDS_NEW_TAB_OTR_HEADING 37328
#define IDS_NEW_TAB_OTR_DESCRIPTION 37329
#define IDS_NEW_TAB_OTR_LEARN_MORE_LINK 37330
#define IDS_NEW_TAB_OTR_MESSAGE_WARNING 37331
#define IDS_NEW_TAB_UNDO_THUMBNAIL_REMOVE 37332
#define IDS_NEW_TAB_OTR_TITLE 37333
#define IDS_NEW_TAB_OTR_SUBTITLE 37334
#define IDS_NEW_TAB_OTR_SUBTITLE_WITH_READING_LIST 37335
#define IDS_NEW_TAB_OTR_NOT_SAVED 37336
#define IDS_NEW_TAB_OTR_VISIBLE 37337
#define IDS_NEW_TAB_OTR_COOKIE_CONTROLS_CONTROLLED_TOOLTIP_TEXT 37338
#define IDS_NEW_TAB_OTR_THIRD_PARTY_COOKIE 37339
#define IDS_NEW_TAB_OTR_THIRD_PARTY_COOKIE_SUBLABEL 37340
#define IDS_NEW_TAB_OTR_THIRD_PARTY_BLOCKED_COOKIE 37341
#define IDS_NEW_TAB_OTR_THIRD_PARTY_BLOCKED_COOKIE_SUBLABEL 37342
#define IDS_OMNIBOX_PEDAL_CLEAR_BROWSING_DATA_HINT 37345
#define IDS_OMNIBOX_PEDAL_CLEAR_BROWSING_DATA_SUGGESTION_CONTENTS 37346
#define IDS_ACC_OMNIBOX_PEDAL_CLEAR_BROWSING_DATA_SUFFIX 37347
#define IDS_ACC_OMNIBOX_PEDAL_CLEAR_BROWSING_DATA 37348
#define IDS_OMNIBOX_PEDAL_MANAGE_PASSWORDS_HINT 37349
#define IDS_OMNIBOX_PEDAL_MANAGE_PASSWORDS_SUGGESTION_CONTENTS 37350
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_PASSWORDS_SUFFIX 37351
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_PASSWORDS 37352
#define IDS_OMNIBOX_PEDAL_UPDATE_CREDIT_CARD_HINT 37353
#define IDS_OMNIBOX_PEDAL_UPDATE_CREDIT_CARD_SUGGESTION_CONTENTS 37354
#define IDS_ACC_OMNIBOX_PEDAL_UPDATE_CREDIT_CARD_SUFFIX 37355
#define IDS_ACC_OMNIBOX_PEDAL_UPDATE_CREDIT_CARD 37356
#define IDS_OMNIBOX_PEDAL_LAUNCH_INCOGNITO_HINT 37357
#define IDS_OMNIBOX_PEDAL_LAUNCH_INCOGNITO_SUGGESTION_CONTENTS 37358
#define IDS_ACC_OMNIBOX_PEDAL_LAUNCH_INCOGNITO_SUFFIX 37359
#define IDS_ACC_OMNIBOX_PEDAL_LAUNCH_INCOGNITO 37360
#define IDS_OMNIBOX_PEDAL_TRANSLATE_HINT 37361
#define IDS_OMNIBOX_PEDAL_TRANSLATE_SUGGESTION_CONTENTS 37362
#define IDS_ACC_OMNIBOX_PEDAL_TRANSLATE_SUFFIX 37363
#define IDS_ACC_OMNIBOX_PEDAL_TRANSLATE 37364
#define IDS_OMNIBOX_PEDAL_UPDATE_CHROME_HINT 37365
#define IDS_OMNIBOX_PEDAL_UPDATE_CHROME_SUGGESTION_CONTENTS 37366
#define IDS_ACC_OMNIBOX_PEDAL_UPDATE_CHROME_SUFFIX 37367
#define IDS_ACC_OMNIBOX_PEDAL_UPDATE_CHROME 37368
#define IDS_OMNIBOX_PEDAL_RUN_CHROME_SAFETY_CHECK_HINT 37369
#define IDS_OMNIBOX_PEDAL_RUN_CHROME_SAFETY_CHECK_SUGGESTION_CONTENTS 37370
#define IDS_ACC_OMNIBOX_PEDAL_RUN_CHROME_SAFETY_CHECK_SUFFIX 37371
#define IDS_ACC_OMNIBOX_PEDAL_RUN_CHROME_SAFETY_CHECK 37372
#define IDS_OMNIBOX_PEDAL_RUN_CHROME_SAFETY_CHECK_V2_HINT 37373
#define IDS_OMNIBOX_PEDAL_RUN_CHROME_SAFETY_CHECK_V2_SUGGESTION_CONTENTS 37374
#define IDS_ACC_OMNIBOX_PEDAL_RUN_CHROME_SAFETY_CHECK_V2_SUFFIX 37375
#define IDS_ACC_OMNIBOX_PEDAL_RUN_CHROME_SAFETY_CHECK_V2 37376
#define IDS_OMNIBOX_PEDAL_MANAGE_SECURITY_SETTINGS_HINT 37377
#define IDS_OMNIBOX_PEDAL_MANAGE_SECURITY_SETTINGS_SUGGESTION_CONTENTS 37378
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_SECURITY_SETTINGS_SUFFIX 37379
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_SECURITY_SETTINGS 37380
#define IDS_OMNIBOX_PEDAL_MANAGE_COOKIES_HINT 37381
#define IDS_OMNIBOX_PEDAL_MANAGE_COOKIES_SUGGESTION_CONTENTS 37382
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_COOKIES_SUFFIX 37383
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_COOKIES 37384
#define IDS_OMNIBOX_PEDAL_MANAGE_ADDRESSES_HINT 37385
#define IDS_OMNIBOX_PEDAL_MANAGE_ADDRESSES_SUGGESTION_CONTENTS 37386
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_ADDRESSES_SUFFIX 37387
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_ADDRESSES 37388
#define IDS_OMNIBOX_PEDAL_MANAGE_SYNC_HINT 37389
#define IDS_OMNIBOX_PEDAL_MANAGE_SYNC_SUGGESTION_CONTENTS 37390
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_SYNC_SUFFIX 37391
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_SYNC 37392
#define IDS_OMNIBOX_PEDAL_MANAGE_SITE_SETTINGS_HINT 37393
#define IDS_OMNIBOX_PEDAL_MANAGE_SITE_SETTINGS_SUGGESTION_CONTENTS 37394
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_SITE_SETTINGS_SUFFIX 37395
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_SITE_SETTINGS 37396
#define IDS_OMNIBOX_PEDAL_CREATE_GOOGLE_DOC_HINT 37397
#define IDS_OMNIBOX_PEDAL_CREATE_GOOGLE_DOC_SUGGESTION_CONTENTS 37398
#define IDS_ACC_OMNIBOX_PEDAL_CREATE_GOOGLE_DOC_SUFFIX 37399
#define IDS_ACC_OMNIBOX_PEDAL_CREATE_GOOGLE_DOC 37400
#define IDS_OMNIBOX_PEDAL_CREATE_GOOGLE_SHEET_HINT 37401
#define IDS_OMNIBOX_PEDAL_CREATE_GOOGLE_SHEET_SUGGESTION_CONTENTS 37402
#define IDS_ACC_OMNIBOX_PEDAL_CREATE_GOOGLE_SHEET_SUFFIX 37403
#define IDS_ACC_OMNIBOX_PEDAL_CREATE_GOOGLE_SHEET 37404
#define IDS_OMNIBOX_PEDAL_CREATE_GOOGLE_SLIDE_HINT 37405
#define IDS_OMNIBOX_PEDAL_CREATE_GOOGLE_SLIDE_SUGGESTION_CONTENTS 37406
#define IDS_ACC_OMNIBOX_PEDAL_CREATE_GOOGLE_SLIDE_SUFFIX 37407
#define IDS_ACC_OMNIBOX_PEDAL_CREATE_GOOGLE_SLIDE 37408
#define IDS_OMNIBOX_PEDAL_CREATE_GOOGLE_CALENDAR_EVENT_HINT 37409
#define IDS_OMNIBOX_PEDAL_CREATE_GOOGLE_CALENDAR_EVENT_SUGGESTION_CONTENTS 37410
#define IDS_ACC_OMNIBOX_PEDAL_CREATE_GOOGLE_CALENDAR_EVENT_SUFFIX 37411
#define IDS_ACC_OMNIBOX_PEDAL_CREATE_GOOGLE_CALENDAR_EVENT 37412
#define IDS_OMNIBOX_PEDAL_CREATE_GOOGLE_SITE_HINT 37413
#define IDS_OMNIBOX_PEDAL_CREATE_GOOGLE_SITE_SUGGESTION_CONTENTS 37414
#define IDS_ACC_OMNIBOX_PEDAL_CREATE_GOOGLE_SITE_SUFFIX 37415
#define IDS_ACC_OMNIBOX_PEDAL_CREATE_GOOGLE_SITE 37416
#define IDS_OMNIBOX_PEDAL_CREATE_GOOGLE_KEEP_NOTE_HINT 37417
#define IDS_OMNIBOX_PEDAL_CREATE_GOOGLE_KEEP_NOTE_SUGGESTION_CONTENTS 37418
#define IDS_ACC_OMNIBOX_PEDAL_CREATE_GOOGLE_KEEP_NOTE_SUFFIX 37419
#define IDS_ACC_OMNIBOX_PEDAL_CREATE_GOOGLE_KEEP_NOTE 37420
#define IDS_OMNIBOX_PEDAL_CREATE_GOOGLE_FORM_HINT 37421
#define IDS_OMNIBOX_PEDAL_CREATE_GOOGLE_FORM_SUGGESTION_CONTENTS 37422
#define IDS_ACC_OMNIBOX_PEDAL_CREATE_GOOGLE_FORM_SUFFIX 37423
#define IDS_ACC_OMNIBOX_PEDAL_CREATE_GOOGLE_FORM 37424
#define IDS_OMNIBOX_PEDAL_SEE_CHROME_TIPS_HINT 37425
#define IDS_OMNIBOX_PEDAL_SEE_CHROME_TIPS_SUGGESTION_CONTENTS 37426
#define IDS_ACC_OMNIBOX_PEDAL_SEE_CHROME_TIPS_SUFFIX 37427
#define IDS_ACC_OMNIBOX_PEDAL_SEE_CHROME_TIPS 37428
#define IDS_OMNIBOX_PEDAL_MANAGE_GOOGLE_ACCOUNT_HINT 37429
#define IDS_OMNIBOX_PEDAL_MANAGE_GOOGLE_ACCOUNT_SUGGESTION_CONTENTS 37430
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_GOOGLE_ACCOUNT_SUFFIX 37431
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_GOOGLE_ACCOUNT 37432
#define IDS_OMNIBOX_PEDAL_CHANGE_GOOGLE_PASSWORD_HINT 37433
#define IDS_OMNIBOX_PEDAL_CHANGE_GOOGLE_PASSWORD_SUGGESTION_CONTENTS 37434
#define IDS_ACC_OMNIBOX_PEDAL_CHANGE_GOOGLE_PASSWORD_SUFFIX 37435
#define IDS_ACC_OMNIBOX_PEDAL_CHANGE_GOOGLE_PASSWORD 37436
#define IDS_OMNIBOX_PEDAL_CLOSE_INCOGNITO_WINDOWS_HINT 37437
#define IDS_OMNIBOX_PEDAL_CLOSE_INCOGNITO_WINDOWS_SUGGESTION_CONTENTS 37438
#define IDS_ACC_OMNIBOX_PEDAL_CLOSE_INCOGNITO_WINDOWS_SUFFIX 37439
#define IDS_ACC_OMNIBOX_PEDAL_CLOSE_INCOGNITO_WINDOWS 37440
#define IDS_OMNIBOX_PEDAL_PLAY_CHROME_DINO_GAME_HINT 37441
#define IDS_OMNIBOX_PEDAL_PLAY_CHROME_DINO_GAME_SUGGESTION_CONTENTS 37442
#define IDS_ACC_OMNIBOX_PEDAL_PLAY_CHROME_DINO_GAME_SUFFIX 37443
#define IDS_ACC_OMNIBOX_PEDAL_PLAY_CHROME_DINO_GAME 37444
#define IDS_OMNIBOX_PEDAL_FIND_MY_PHONE_HINT 37445
#define IDS_OMNIBOX_PEDAL_FIND_MY_PHONE_SUGGESTION_CONTENTS 37446
#define IDS_ACC_OMNIBOX_PEDAL_FIND_MY_PHONE_SUFFIX 37447
#define IDS_ACC_OMNIBOX_PEDAL_FIND_MY_PHONE 37448
#define IDS_OMNIBOX_PEDAL_MANAGE_GOOGLE_PRIVACY_HINT 37449
#define IDS_OMNIBOX_PEDAL_MANAGE_GOOGLE_PRIVACY_SUGGESTION_CONTENTS 37450
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_GOOGLE_PRIVACY_SUFFIX 37451
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_GOOGLE_PRIVACY 37452
#define IDS_OMNIBOX_PEDAL_MANAGE_CHROME_SETTINGS_HINT 37453
#define IDS_OMNIBOX_PEDAL_MANAGE_CHROME_SETTINGS_SUGGESTION_CONTENTS 37454
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_CHROME_SETTINGS_SUFFIX 37455
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_CHROME_SETTINGS 37456
#define IDS_OMNIBOX_PEDAL_MANAGE_CHROME_DOWNLOADS_HINT 37457
#define IDS_OMNIBOX_PEDAL_MANAGE_CHROME_DOWNLOADS_SUGGESTION_CONTENTS 37458
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_CHROME_DOWNLOADS_SUFFIX 37459
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_CHROME_DOWNLOADS 37460
#define IDS_OMNIBOX_PEDAL_VIEW_CHROME_HISTORY_HINT 37461
#define IDS_OMNIBOX_PEDAL_VIEW_CHROME_HISTORY_SUGGESTION_CONTENTS 37462
#define IDS_ACC_OMNIBOX_PEDAL_VIEW_CHROME_HISTORY_SUFFIX 37463
#define IDS_ACC_OMNIBOX_PEDAL_VIEW_CHROME_HISTORY 37464
#define IDS_OMNIBOX_PEDAL_SHARE_THIS_PAGE_HINT 37465
#define IDS_OMNIBOX_PEDAL_SHARE_THIS_PAGE_SUGGESTION_CONTENTS 37466
#define IDS_ACC_OMNIBOX_PEDAL_SHARE_THIS_PAGE_SUFFIX 37467
#define IDS_ACC_OMNIBOX_PEDAL_SHARE_THIS_PAGE 37468
#define IDS_OMNIBOX_PEDAL_MANAGE_CHROME_ACCESSIBILITY_HINT 37469
#define IDS_OMNIBOX_PEDAL_MANAGE_CHROME_ACCESSIBILITY_SUGGESTION_CONTENTS 37470
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_CHROME_ACCESSIBILITY_SUFFIX 37471
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_CHROME_ACCESSIBILITY 37472
#define IDS_OMNIBOX_PEDAL_CUSTOMIZE_CHROME_FONTS_HINT 37473
#define IDS_OMNIBOX_PEDAL_CUSTOMIZE_CHROME_FONTS_SUGGESTION_CONTENTS 37474
#define IDS_ACC_OMNIBOX_PEDAL_CUSTOMIZE_CHROME_FONTS_SUFFIX 37475
#define IDS_ACC_OMNIBOX_PEDAL_CUSTOMIZE_CHROME_FONTS 37476
#define IDS_OMNIBOX_PEDAL_MANAGE_CHROME_THEMES_HINT 37477
#define IDS_OMNIBOX_PEDAL_MANAGE_CHROME_THEMES_SUGGESTION_CONTENTS 37478
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_CHROME_THEMES_SUFFIX 37479
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_CHROME_THEMES 37480
#define IDS_OMNIBOX_PEDAL_CUSTOMIZE_SEARCH_ENGINES_HINT 37481
#define IDS_OMNIBOX_PEDAL_CUSTOMIZE_SEARCH_ENGINES_SUGGESTION_CONTENTS 37482
#define IDS_ACC_OMNIBOX_PEDAL_CUSTOMIZE_SEARCH_ENGINES_SUFFIX 37483
#define IDS_ACC_OMNIBOX_PEDAL_CUSTOMIZE_SEARCH_ENGINES 37484
#define IDS_OMNIBOX_PEDAL_MANAGE_CHROMEOS_ACCESSIBILITY_HINT 37485
#define IDS_OMNIBOX_PEDAL_MANAGE_CHROMEOS_ACCESSIBILITY_SUGGESTION_CONTENTS 37486
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_CHROMEOS_ACCESSIBILITY_SUFFIX 37487
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_CHROMEOS_ACCESSIBILITY 37488
#define IDS_OMNIBOX_PEDAL_SET_CHROME_AS_DEFAULT_BROWSER_HINT 37489
#define IDS_OMNIBOX_PEDAL_SET_CHROME_AS_DEFAULT_BROWSER_SUGGESTION_CONTENTS 37490
#define IDS_ACC_OMNIBOX_PEDAL_SET_CHROME_AS_DEFAULT_BROWSER_SUFFIX 37491
#define IDS_ACC_OMNIBOX_PEDAL_SET_CHROME_AS_DEFAULT_BROWSER 37492
#define IDS_ANDROID_OMNIBOX_PEDAL_RUN_CHROME_SAFETY_CHECK_HINT 37493
#define IDS_ANDROID_OMNIBOX_PEDAL_LAUNCH_INCOGNITO_HINT 37494
#define IDS_ANDROID_OMNIBOX_PEDAL_LAUNCH_INCOGNITO_SUGGESTION_CONTENTS 37495
#define IDS_ANDROID_ACC_OMNIBOX_PEDAL_LAUNCH_INCOGNITO_SUFFIX 37496
#define IDS_ANDROID_ACC_OMNIBOX_PEDAL_LAUNCH_INCOGNITO 37497
#define IDS_IOS_OMNIBOX_PEDAL_CLEAR_BROWSING_DATA_HINT 37498
#define IDS_IOS_OMNIBOX_PEDAL_SET_CHROME_AS_DEFAULT_BROWSER_HINT 37499
#define IDS_IOS_OMNIBOX_PEDAL_SET_CHROME_AS_DEFAULT_BROWSER_SUGGESTION_CONTENTS 37500
#define IDS_IOS_ACC_OMNIBOX_PEDAL_SET_CHROME_AS_DEFAULT_BROWSER_SUFFIX 37501
#define IDS_IOS_ACC_OMNIBOX_PEDAL_SET_CHROME_AS_DEFAULT_BROWSER 37502
#define IDS_IOS_OMNIBOX_PEDAL_UPDATE_CREDIT_CARD_HINT 37503
#define IDS_IOS_OMNIBOX_PEDAL_LAUNCH_INCOGNITO_HINT 37504
#define IDS_IOS_OMNIBOX_PEDAL_RUN_CHROME_SAFETY_CHECK_HINT 37505
#define IDS_IOS_OMNIBOX_PEDAL_MANAGE_CHROME_SETTINGS_HINT 37506
#define IDS_IOS_OMNIBOX_PEDAL_VIEW_CHROME_HISTORY_HINT 37507
#define IDS_IOS_OMNIBOX_PEDAL_PLAY_CHROME_DINO_GAME_HINT 37508
#define IDS_IOS_OMNIBOX_PEDAL_LAUNCH_INCOGNITO_SUGGESTION_CONTENTS 37509
#define IDS_IOS_OMNIBOX_PEDAL_MANAGE_PASSWORDS_HINT 37510
#define IDS_AUTOCOMPLETE_SEARCH_DESCRIPTION 37511
#define IDS_EMPTY_KEYWORD_VALUE 37512
#define IDS_LINK_FROM_CLIPBOARD 37513
#define IDS_TEXT_FROM_CLIPBOARD 37514
#define IDS_IMAGE_FROM_CLIPBOARD 37515
#define IDS_SECURE_CONNECTION_EV 37516
#define IDS_SECURE_VERBOSE_STATE 37517
#define IDS_NOT_SECURE_VERBOSE_STATE 37518
#define IDS_DANGEROUS_VERBOSE_STATE 37519
#define IDS_OFFLINE_VERBOSE_STATE 37520
#define IDS_OMNIBOX_EMPTY_HINT 37521
#define IDS_OMNIBOX_ADDITIONAL_TEXT_DASH_TEMPLATE 37523
#define IDS_OMNIBOX_ADDITIONAL_TEXT_PARENTHESIS_TEMPLATE 37524
#define IDS_OMNIBOX_TAB_SUGGEST_HINT 37525
#define IDS_OMNIBOX_FILE 37526
#define IDS_OMNIBOX_READER_MODE 37527
#define IDS_DRIVE_SUGGESTION_DOCUMENT 37528
#define IDS_DRIVE_SUGGESTION_FORM 37529
#define IDS_DRIVE_SUGGESTION_SPREADSHEET 37530
#define IDS_DRIVE_SUGGESTION_PRESENTATION 37531
#define IDS_DRIVE_SUGGESTION_GENERAL 37532
#define IDS_DRIVE_SUGGESTION_DESCRIPTION_TEMPLATE 37533
#define IDS_DRIVE_SUGGESTION_DESCRIPTION_TEMPLATE_WITHOUT_DATE 37534
#define IDS_DRIVE_SUGGESTION_DESCRIPTION_TEMPLATE_WITHOUT_OWNER 37535
#define IDS_ACCURACY_CHECK_VERBOSE_STATE 37536
#define IDS_OMNIBOX_HISTORY_CLUSTERS_SEARCH_HINT 37537
#define IDS_OMNIBOX_ACTION_HISTORY_CLUSTERS_SEARCH_HINT 37538
#define IDS_OMNIBOX_ACTION_HISTORY_CLUSTERS_SEARCH_SUGGESTION_CONTENTS 37539
#define IDS_ACC_OMNIBOX_ACTION_HISTORY_CLUSTERS_SEARCH_SUFFIX 37540
#define IDS_ACC_OMNIBOX_ACTION_HISTORY_CLUSTERS_SEARCH 37541
#define IDS_ACC_OMNIBOX_ACTION_IN_SUGGEST_SUFFIX 37542
#define IDS_ACC_OMNIBOX_ACTION_IN_SUGGEST 37543
#define IDS_OMNIBOX_ACTION_IN_SUGGEST_CALL_HINT 37544
#define IDS_OMNIBOX_ACTION_IN_SUGGEST_CALL_CONTENTS 37545
#define IDS_OMNIBOX_ACTION_IN_SUGGEST_DIRECTIONS_HINT 37546
#define IDS_OMNIBOX_ACTION_IN_SUGGEST_DIRECTIONS_CONTENTS 37547
#define IDS_OMNIBOX_ACTION_IN_SUGGEST_REVIEWS_HINT 37548
#define IDS_OMNIBOX_ACTION_IN_SUGGEST_REVIEWS_CONTENTS 37549
#define IDS_OMNIBOX_ACTION_IN_SUGGEST_WEBSITE_HINT 37550
#define IDS_OMNIBOX_ACTION_IN_SUGGEST_WEBSITE_CONTENTS 37551
#define IDS_ACC_AUTOCOMPLETE_HISTORY 37552
#define IDS_ACC_AUTOCOMPLETE_SEARCH_HISTORY 37553
#define IDS_ACC_AUTOCOMPLETE_SEARCH 37554
#define IDS_ACC_AUTOCOMPLETE_SUGGESTED_SEARCH 37555
#define IDS_ACC_AUTOCOMPLETE_SUGGESTED_SEARCH_ENTITY 37556
#define IDS_ACC_AUTOCOMPLETE_QUICK_ANSWER 37557
#define IDS_ACC_AUTOCOMPLETE_BOOKMARK 37558
#define IDS_ACC_AUTOCOMPLETE_CLIPBOARD_IMAGE 37559
#define IDS_ACC_AUTOCOMPLETE_CLIPBOARD_TEXT 37560
#define IDS_ACC_AUTOCOMPLETE_CLIPBOARD_URL 37561
#define IDS_ACC_SEARCH_ICON 37562
#define IDS_ACC_AUTOCOMPLETE_N_OF_M 37563
#define IDS_ACC_TAB_SWITCH_SUFFIX 37564
#define IDS_ACC_TAB_SWITCH_BUTTON_FOCUSED_PREFIX 37565
#define IDS_ACC_TAB_SWITCH_BUTTON 37566
#define IDS_ACC_MULTIPLE_ACTIONS_SUFFIX 37567
#define IDS_ACC_KEYWORD_SUFFIX 37568
#define IDS_ACC_KEYWORD_MODE 37569
#define IDS_ACC_REMOVE_SUGGESTION_SUFFIX 37570
#define IDS_ACC_REMOVE_SUGGESTION_FOCUSED_PREFIX 37571
#define IDS_ACC_REMOVE_SUGGESTION_BUTTON 37572
#define IDS_TOOLTIP_HEADER_SHOW_SUGGESTIONS_BUTTON 37573
#define IDS_TOOLTIP_HEADER_HIDE_SUGGESTIONS_BUTTON 37574
#define IDS_ACC_HEADER_SHOW_SUGGESTIONS_BUTTON 37575
#define IDS_ACC_HEADER_HIDE_SUGGESTIONS_BUTTON 37576
#define IDS_ACC_HEADER_SECTION_SHOWN 37577
#define IDS_ACC_HEADER_SECTION_HIDDEN 37578
#define IDS_ACC_CHROME_TIP 37579
#define IDS_ACC_DISMISS_CHROME_TIP_SUFFIX 37580
#define IDS_ACC_DISMISS_CHROME_TIP_FOCUSED_PREFIX 37581
#define IDS_SEARCH_ENGINES_STARTER_PACK_BOOKMARKS_NAME 37582
#define IDS_SEARCH_ENGINES_STARTER_PACK_BOOKMARKS_KEYWORD 37583
#define IDS_SEARCH_ENGINES_STARTER_PACK_HISTORY_NAME 37584
#define IDS_SEARCH_ENGINES_STARTER_PACK_HISTORY_KEYWORD 37585
#define IDS_SEARCH_ENGINES_STARTER_PACK_TABS_NAME 37586
#define IDS_SEARCH_ENGINES_STARTER_PACK_TABS_KEYWORD 37587
#define IDS_SEARCH_ENGINES_STARTER_PACK_GEMINI_NAME 37588
#define IDS_SEARCH_ENGINES_STARTER_PACK_GEMINI_KEYWORD 37589
#define IDS_OMNIBOX_INSTANT_KEYWORD_CHAT_TEXT 37590
#define IDS_OMNIBOX_INSTANT_KEYWORD_SEARCH_TEXT 37591
#define IDS_OMNIBOX_SELECTED_KEYWORD_CHAT_TEXT 37592
#define IDS_OMNIBOX_TAB_SEARCH_NO_RESULTS_FOUND 37593
#define IDS_OMNIBOX_GEMINI_IPH 37594
#define IDS_OMNIBOX_FEATURED_ENTERPRISE_SITE_SEARCH_IPH 37595
#define IDS_OMNIBOX_ONE_LINE_CALCULATOR_SUGGESTION_TEMPLATE 37596
#define IDS_OMNIBOX_HEADER_POPULAR_TOPICS 37597
#define IDS_PAGE_INFO_SECURE_SUMMARY 37598
#define IDS_PAGE_INFO_MIXED_CONTENT_SUMMARY 37599
#define IDS_PAGE_INFO_MIXED_CONTENT_SUMMARY_SHORT 37600
#define IDS_PAGE_INFO_NOT_SECURE_SUMMARY 37601
#define IDS_PAGE_INFO_NOT_SECURE_SUMMARY_SHORT 37602
#define IDS_PAGE_INFO_MALWARE_SUMMARY 37603
#define IDS_PAGE_INFO_MALWARE_SUMMARY_NEW 37604
#define IDS_PAGE_INFO_SOCIAL_ENGINEERING_SUMMARY 37605
#define IDS_PAGE_INFO_SOCIAL_ENGINEERING_SUMMARY_NEW 37606
#define IDS_PAGE_INFO_UNWANTED_SOFTWARE_SUMMARY 37607
#define IDS_PAGE_INFO_UNWANTED_SOFTWARE_SUMMARY_NEW 37608
#define IDS_PAGE_INFO_EXTENSION_PAGE 37609
#define IDS_PAGE_INFO_VIEW_SOURCE_PAGE 37610
#define IDS_PAGE_INFO_DEVTOOLS_PAGE 37611
#define IDS_PAGE_INFO_READER_MODE_PAGE_SECURE 37612
#define IDS_PAGE_INFO_READER_MODE_PAGE 37613
#define IDS_PAGE_INFO_SAFETY_TIP_MORE_INFO_LINK 37614
#define IDS_PAGE_INFO_SAFETY_TIP_LOOKALIKE_LEAVE_BUTTON 37615
#define IDS_PAGE_INFO_SAFETY_TIP_LOOKALIKE_TITLE 37616
#define IDS_PAGE_INFO_SAFETY_TIP_DESCRIPTION 37617
#define IDS_PAGE_INFO_FILE_PAGE 37618
#define IDS_PAGE_INFO_SECURE_DETAILS 37619
#define IDS_PAGE_INFO_ADMIN_PROVIDED_CERT_DETAILS 37620
#define IDS_PAGE_INFO_MIXED_CONTENT_DETAILS 37621
#define IDS_PAGE_INFO_LEGACY_TLS_DETAILS 37622
#define IDS_PAGE_INFO_NOT_SECURE_DETAILS 37623
#define IDS_PAGE_INFO_MALWARE_DETAILS 37624
#define IDS_PAGE_INFO_MALWARE_DETAILS_NEW 37625
#define IDS_PAGE_INFO_SOCIAL_ENGINEERING_DETAILS 37626
#define IDS_PAGE_INFO_SOCIAL_ENGINEERING_DETAILS_NEW 37627
#define IDS_PAGE_INFO_UNWANTED_SOFTWARE_DETAILS 37628
#define IDS_PAGE_INFO_UNWANTED_SOFTWARE_DETAILS_NEW 37629
#define IDS_PAGE_INFO_SECURITY_TAB_INSECURE_IDENTITY 37630
#define IDS_PAGE_INFO_CHANGE_PASSWORD_SUMMARY 37631
#define IDS_PAGE_INFO_CHANGE_PASSWORD_SAVED_PASSWORD_SUMMARY 37632
#define IDS_PAGE_INFO_CHANGE_PASSWORD_DETAILS_SAVED 37633
#define IDS_PAGE_INFO_CHECK_PASSWORDS_BUTTON 37634
#define IDS_PAGE_INFO_INVALID_CERTIFICATE_DESCRIPTION 37635
#define IDS_PAGE_INFO_RESET_INVALID_CERTIFICATE_DECISIONS_BUTTON 37636
#define IDS_PAGE_INFO_HELP_CENTER_LINK 37637
#define IDS_PAGE_INFO_SECURITY_TAB_DEPRECATED_SIGNATURE_ALGORITHM 37638
#define IDS_PAGE_INFO_SECURITY_TAB_ENCRYPTED_CONNECTION_TEXT 37639
#define IDS_PAGE_INFO_SECURITY_TAB_ENCRYPTED_INSECURE_CONTENT_ERROR 37640
#define IDS_PAGE_INFO_SECURITY_TAB_ENCRYPTED_INSECURE_CONTENT_WARNING 37641
#define IDS_PAGE_INFO_SECURITY_TAB_ENCRYPTED_INSECURE_FORM_WARNING 37642
#define IDS_PAGE_INFO_SECURITY_TAB_ENCRYPTED_SENTENCE_LINK 37643
#define IDS_PAGE_INFO_SECURITY_TAB_ENCRYPTION_DETAILS 37644
#define IDS_PAGE_INFO_SECURITY_TAB_ENCRYPTION_DETAILS_AEAD 37645
#define IDS_PAGE_INFO_SECURITY_TAB_NOT_ENCRYPTED_CONNECTION_TEXT 37646
#define IDS_PAGE_INFO_SECURITY_TAB_SSL_VERSION 37647
#define IDS_PAGE_INFO_SECURITY_TAB_UNKNOWN_PARTY 37648
#define IDS_PAGE_INFO_SECURITY_TAB_WEAK_ENCRYPTION_CONNECTION_TEXT 37649
#define IDS_PAGE_INFO_CERT_INFO_BUTTON 37650
#define IDS_PAGE_INFO_ADDRESS 37651
#define IDS_PAGE_INFO_PARTIAL_ADDRESS 37652
#define IDS_PAGE_INFO_SECURITY_TAB_SECURE_IDENTITY_EV_VERIFIED 37653
#define IDS_PAGE_INFO_CERTIFICATE 37654
#define IDS_PAGE_INFO_CERTIFICATE_VALID_LINK 37655
#define IDS_PAGE_INFO_CERTIFICATE_INVALID_LINK 37656
#define IDS_PAGE_INFO_CERTIFICATE_BUTTON_TEXT 37657
#define IDS_PAGE_INFO_CERTIFICATE_VALID_PARENTHESIZED 37658
#define IDS_PAGE_INFO_CERTIFICATE_INVALID_PARENTHESIZED 37659
#define IDS_PAGE_INFO_CERTIFICATE_IS_VALID 37660
#define IDS_PAGE_INFO_CERTIFICATE_IS_NOT_VALID 37661
#define IDS_PAGE_INFO_CERTIFICATE_VALID_LINK_TOOLTIP 37662
#define IDS_PAGE_INFO_CERTIFICATE_INVALID_LINK_TOOLTIP 37663
#define IDS_PAGE_INFO_COOKIES 37665
#define IDS_PAGE_INFO_COOKIES_BUTTON_TEXT 37666
#define IDS_PAGE_INFO_NUM_COOKIES_PARENTHESIZED 37667
#define IDS_PAGE_INFO_NUM_COOKIES 37668
#define IDS_PAGE_INFO_COOKIES_TOOLTIP 37669
#define IDS_PAGE_INFO_TRACKING_PROTECTION_COOKIES_TOOLTIP 37670
#define IDS_PAGE_INFO_BUTTON_TEXT_ALLOWED_BY_USER 37671
#define IDS_PAGE_INFO_BUTTON_TEXT_ALLOWED_ONCE_BY_USER 37672
#define IDS_PAGE_INFO_BUTTON_TEXT_BLOCKED_BY_USER 37673
#define IDS_PAGE_INFO_BUTTON_TEXT_MUTED_BY_USER 37674
#define IDS_PAGE_INFO_BUTTON_TEXT_ASK_BY_USER 37675
#define IDS_PAGE_INFO_BUTTON_TEXT_DETECT_IMPORTANT_CONTENT_BY_USER 37676
#define IDS_PAGE_INFO_BUTTON_TEXT_ALLOWED_BY_DEFAULT 37677
#define IDS_PAGE_INFO_BUTTON_TEXT_BLOCKED_BY_DEFAULT 37678
#define IDS_PAGE_INFO_BUTTON_TEXT_ASK_BY_DEFAULT 37679
#define IDS_PAGE_INFO_BUTTON_TEXT_AUTOMATIC_BY_DEFAULT 37680
#define IDS_PAGE_INFO_BUTTON_TEXT_MUTED_BY_DEFAULT 37681
#define IDS_PAGE_INFO_BUTTON_TEXT_DETECT_IMPORTANT_CONTENT_BY_DEFAULT 37682
#define IDS_PAGE_INFO_MENU_ITEM_DEFAULT_ALLOW 37683
#define IDS_PAGE_INFO_MENU_ITEM_DEFAULT_BLOCK 37684
#define IDS_PAGE_INFO_MENU_ITEM_DEFAULT_ASK 37685
#define IDS_PAGE_INFO_MENU_ITEM_DEFAULT_DETECT_IMPORTANT_CONTENT 37686
#define IDS_PAGE_INFO_MENU_ITEM_ALLOW 37687
#define IDS_PAGE_INFO_MENU_ITEM_BLOCK 37688
#define IDS_PAGE_INFO_MENU_ITEM_ASK 37689
#define IDS_PAGE_INFO_MENU_ITEM_DETECT_IMPORTANT_CONTENT 37690
#define IDS_PAGE_INFO_MENU_ITEM_ADS_BLOCK 37691
#define IDS_PAGE_INFO_STATE_TEXT_ALLOWED 37692
#define IDS_PAGE_INFO_STATE_TEXT_ALLOWED_ONCE 37693
#define IDS_PAGE_INFO_STATE_TEXT_NOT_ALLOWED 37694
#define IDS_PAGE_INFO_STATE_TEXT_NOT_ALLOWED_IN_INCOGNITO 37695
#define IDS_PAGE_INFO_STATE_TEXT_NOT_ALLOWED_IN_GUEST 37696
#define IDS_PAGE_INFO_STATE_TEXT_NOT_ALLOWED_INSECURE 37697
#define IDS_PAGE_INFO_STATE_TEXT_MUTED 37698
#define IDS_PAGE_INFO_STATE_TEXT_ALLOWED_BY_DEFAULT 37699
#define IDS_PAGE_INFO_STATE_TEXT_NOT_ALLOWED_BY_DEFAULT 37700
#define IDS_PAGE_INFO_SELECTOR_TOOLTIP 37701
#define IDS_PAGE_INFO_SELECTOR_STORAGE_ACCESS_TOOLTIP 37702
#define IDS_PAGE_INFO_STATE_TEXT_AR_ASK 37703
#define IDS_PAGE_INFO_STATE_TEXT_AUTO_PICTURE_IN_PICTURE_ASK 37704
#define IDS_PAGE_INFO_STATE_TEXT_AUTOMATIC_DOWNLOADS_ASK 37705
#define IDS_PAGE_INFO_STATE_TEXT_BLUETOOTH_DEVICES_ASK 37706
#define IDS_PAGE_INFO_STATE_TEXT_CAMERA_ASK 37707
#define IDS_PAGE_INFO_STATE_TEXT_CAPTURED_SURFACE_CONTROL_ASK 37708
#define IDS_PAGE_INFO_STATE_TEXT_CAMERA_PAN_TILT_ZOOM_ASK 37709
#define IDS_PAGE_INFO_STATE_TEXT_CLIPBOARD_ASK 37710
#define IDS_PAGE_INFO_STATE_TEXT_FILE_SYSTEM_WRITE_ASK 37711
#define IDS_PAGE_INFO_STATE_TEXT_HID_DEVICES_ASK 37712
#define IDS_PAGE_INFO_STATE_TEXT_LOCATION_ASK 37713
#define IDS_PAGE_INFO_STATE_TEXT_MIC_ASK 37714
#define IDS_PAGE_INFO_STATE_TEXT_MIDI_SYSEX_ASK 37715
#define IDS_PAGE_INFO_STATE_TEXT_NOTIFICATIONS_ASK 37716
#define IDS_PAGE_INFO_STATE_TEXT_USB_ASK 37717
#define IDS_PAGE_INFO_STATE_TEXT_VR_ASK 37718
#define IDS_PAGE_INFO_STATE_TEXT_FONT_ACCESS_ASK 37719
#define IDS_PAGE_INFO_STATE_TEXT_SERIAL_ASK 37720
#define IDS_PAGE_INFO_STATE_TEXT_IDLE_DETECTION_ASK 37721
#define IDS_PAGE_INFO_STATE_TEXT_WINDOW_MANAGEMENT_ASK 37722
#define IDS_PAGE_INFO_STATE_TEXT_BLUETOOTH_SCANNING_ASK 37723
#define IDS_PAGE_INFO_STATE_TEXT_STORAGE_ACCESS_ASK 37724
#define IDS_PAGE_INFO_USB_DEVICE_SECONDARY_LABEL 37725
#define IDS_PAGE_INFO_USB_DEVICE_ALLOWED_BY_POLICY_LABEL 37726
#define IDS_PAGE_INFO_DELETE_USB_DEVICE_WITH_NAME 37727
#define IDS_PAGE_INFO_SERIAL_PORT_SECONDARY_LABEL 37728
#define IDS_PAGE_INFO_SERIAL_PORT_ALLOWED_BY_POLICY_LABEL 37729
#define IDS_PAGE_INFO_DELETE_SERIAL_PORT_WITH_NAME 37730
#define IDS_PAGE_INFO_BLUETOOTH_DEVICE_SECONDARY_LABEL 37731
#define IDS_PAGE_INFO_DELETE_BLUETOOTH_DEVICE_WITH_NAME 37732
#define IDS_PAGE_INFO_HID_DEVICE_SECONDARY_LABEL 37733
#define IDS_PAGE_INFO_HID_DEVICE_ALLOWED_BY_POLICY_LABEL 37734
#define IDS_PAGE_INFO_DELETE_HID_DEVICE_WITH_NAME 37735
#define IDS_PAGE_INFO_SITE_SETTINGS_LINK 37736
#define IDS_PAGE_INFO_SITE_SETTINGS_TOOLTIP 37737
#define IDS_PAGE_INFO_CAMERA_SYSTEM_SETTINGS_DESCRIPTION 37740
#define IDS_PAGE_INFO_MICROPHONE_SYSTEM_SETTINGS_DESCRIPTION 37741
#define IDS_PAGE_INFO_SETTINGS_OF_A_SYSTEM_LINK 37742
#define IDS_PAGE_INFO_PERMISSION_ALLOWED_BY_POLICY 37743
#define IDS_PAGE_INFO_PERMISSION_BLOCKED_BY_POLICY 37744
#define IDS_PAGE_INFO_PERMISSION_ASK_BY_POLICY 37745
#define IDS_PAGE_INFO_PERMISSION_ALLOWED_BY_EXTENSION 37746
#define IDS_PAGE_INFO_PERMISSION_BLOCKED_BY_EXTENSION 37747
#define IDS_PAGE_INFO_PERMISSION_ASK_BY_EXTENSION 37748
#define IDS_PAGE_INFO_PERMISSION_AUTOMATICALLY_BLOCKED 37749
#define IDS_PAGE_INFO_PERMISSION_ADS_SUBTITLE 37750
#define IDS_PAGE_INFO_PERMISSION_MANAGED_BY_POLICY 37751
#define IDS_PAGE_INFO_PERMISSION_MANAGED_BY_EXTENSION 37752
#define IDS_PAGE_INFO_INFOBAR_TEXT 37753
#define IDS_PAGE_INFO_INFOBAR_BUTTON 37754
#define IDS_PAGE_INFO_PERMISSION_USING_NOW 37755
#define IDS_PAGE_INFO_PERMISSION_RECENTLY_USED 37756
#define IDS_PAGE_INFO_PERMISSION_USED_TIME_AGO 37757
#define IDS_PAGE_INFO_CHANGE_PASSWORD_DETAILS 37758
#define IDS_PAGE_INFO_CHANGE_PASSWORD_DETAILS_SYNC 37759
#define IDS_PAGE_INFO_CHANGE_PASSWORD_DETAILS_SIGNED_IN_NON_SYNC 37760
#define IDS_PAGE_INFO_CHANGE_PASSWORD_DETAILS_ENTERPRISE 37761
#define IDS_PAGE_INFO_CHANGE_PASSWORD_DETAILS_ENTERPRISE_WITH_ORG_NAME 37762
#define IDS_PAGE_INFO_CHANGE_PASSWORD_BUTTON 37763
#define IDS_PAGE_INFO_PROTECT_ACCOUNT_BUTTON 37764
#define IDS_PAGE_INFO_IGNORE_PASSWORD_WARNING_BUTTON 37765
#define IDS_PAGE_INFO_ALLOWLIST_PASSWORD_REUSE_BUTTON 37766
#define IDS_PAGE_INFO_BILLING_SUMMARY 37767
#define IDS_PAGE_INFO_BILLING_DETAILS 37768
#define IDS_PAGE_INFO_VR_PRESENTING_TEXT 37769
#define IDS_PAGE_INFO_VR_TURN_OFF_BUTTON_TEXT 37770
#define IDS_CERT_INFO_SUBJECT_GROUP 37771
#define IDS_CERT_INFO_ISSUER_GROUP 37772
#define IDS_CERT_INFO_COMMON_NAME_LABEL 37773
#define IDS_CERT_INFO_ORGANIZATION_LABEL 37774
#define IDS_CERT_INFO_ORGANIZATIONAL_UNIT_LABEL 37775
#define IDS_CERT_INFO_SERIAL_NUMBER_LABEL 37776
#define IDS_CERT_INFO_VALIDITY_GROUP 37777
#define IDS_CERT_INFO_ISSUED_ON_LABEL 37778
#define IDS_CERT_INFO_EXPIRES_ON_LABEL 37779
#define IDS_CERT_INFO_FINGERPRINTS_GROUP 37780
#define IDS_CERT_INFO_SHA256_FINGERPRINT_LABEL 37781
#define IDS_CERT_INFO_SHA256_SPKI_FINGERPRINT_LABEL 37782
#define IDS_CERT_DETAILS_EXTENSIONS 37783
#define IDS_CERT_X509_SUBJECT_ALT_NAME 37784
#define IDS_PAGE_INFO_SECURITY_SUBPAGE_BUTTON 37785
#define IDS_PAGE_INFO_SECURITY_SUBPAGE_HEADER 37786
#define IDS_PAGE_INFO_PERMISSIONS_SUBPAGE_BUTTON_TOOLTIP 37787
#define IDS_PAGE_INFO_PERMISSIONS_SUBPAGE_MANAGE_BUTTON 37788
#define IDS_PAGE_INFO_PERMISSIONS_SUBPAGE_MANAGE_BUTTON_TOOLTIP 37789
#define IDS_PAGE_INFO_PERMISSIONS_SUBPAGE_REMEMBER_THIS_SETTING 37790
#define IDS_PAGE_INFO_RESET_PERMISSIONS 37791
#define IDS_PAGE_INFO_ABOUT_THIS_SITE_HEADER 37792
#define IDS_PAGE_INFO_ABOUT_THIS_PAGE_TITLE 37793
#define IDS_PAGE_INFO_ABOUT_THIS_PAGE_DESCRIPTION_PLACEHOLDER 37794
#define IDS_PAGE_INFO_ABOUT_THIS_SITE_TOOLTIP 37795
#define IDS_PAGE_INFO_ABOUT_THIS_PAGE_TOOLTIP 37796
#define IDS_PAGE_INFO_ABOUT_THIS_SITE_SUBPAGE_FROM_LABEL 37797
#define IDS_PAGE_INFO_COOKIES_HEADER 37798
#define IDS_PAGE_INFO_TRACKING_PROTECTION_SITE_INFO_BUTTON_NAME 37799
#define IDS_PAGE_INFO_TRACKING_PROTECTION_SITE_INFO_BUTTON_LABEL_ALLOWED 37800
#define IDS_PAGE_INFO_TRACKING_PROTECTION_SITE_INFO_BUTTON_LABEL_BLOCKED 37801
#define IDS_PAGE_INFO_TRACKING_PROTECTION_SITE_INFO_BUTTON_LABEL_LIMITED 37802
#define IDS_PAGE_INFO_SUB_PAGE_VIEW_TRACKING_PROTECTION_HEADER 37803
#define IDS_PAGE_INFO_COOKIES_DESCRIPTION 37804
#define IDS_PAGE_INFO_TRACKING_PROTECTION_SITE_GRANT_DESCRIPTION 37805
#define IDS_PAGE_INFO_TRACKING_PROTECTION_DESCRIPTION 37806
#define IDS_PAGE_INFO_TRACKING_PROTECTION_BLOCKED_COOKIES_DESCRIPTION 37807
#define IDS_PAGE_INFO_TRACKING_PROTECTION_INCOGNITO_BLOCKED_COOKIES_DESCRIPTION 37808
#define IDS_PAGE_INFO_COOKIES_SETTINGS_LINK 37809
#define IDS_PAGE_INFO_TRACKING_PROTECTION_SETTINGS_LINK 37810
#define IDS_PAGE_INFO_BLOCK_THIRD_PARTY_COOKIES_TITLE 37811
#define IDS_PAGE_INFO_BLOCK_THIRD_PARTY_COOKIES_TOGGLE_TOOLTIP 37812
#define IDS_PAGE_INFO_BLOCK_THIRD_PARTY_COOKIES_MANAGED_BY_SETTINGS_TOOLTIP 37813
#define IDS_PAGE_INFO_TRACKING_PROTECTION_COOKIES_ALLOWED 37814
#define IDS_PAGE_INFO_TRACKING_PROTECTION_COOKIES_LIMITED 37815
#define IDS_PAGE_INFO_TRACKING_PROTECTION_COOKIES_BLOCKED 37816
#define IDS_PAGE_INFO_COOKIES_ALLOWED_SITES_COUNT 37817
#define IDS_PAGE_INFO_COOKIES_DIALOG_BUTTON_TITLE 37818
#define IDS_PAGE_INFO_COOKIES_DIALOG_BUTTON_TOOLTIP 37819
#define IDS_PAGE_INFO_FPS_BUTTON_TOOLTIP 37820
#define IDS_PAGE_INFO_FPS_BUTTON_TITLE 37821
#define IDS_PAGE_INFO_FPS_BUTTON_SUBTITLE 37822
#define IDS_PAGE_INFO_HISTORY 37823
#define IDS_PAGE_INFO_HISTORY_LAST_VISIT_TODAY 37824
#define IDS_PAGE_INFO_HISTORY_LAST_VISIT_YESTERDAY 37825
#define IDS_PAGE_INFO_HISTORY_LAST_VISIT_DAYS 37826
#define IDS_PAGE_INFO_HISTORY_LAST_VISIT_DATE 37827
#define IDS_PAGE_INFO_ENTERPRISE_WARN_SUMMARY 37828
#define IDS_PAGE_INFO_ENTERPRISE_WARN_DETAILS 37829
#define IDS_PAGE_INFO_ENTERPRISE_BLOCK_SUMMARY 37830
#define IDS_PAGE_INFO_ENTERPRISE_BLOCK_DETAILS 37831
#define IDS_PAGE_INFO_AD_PRIVACY_HEADER 37832
#define IDS_PAGE_INFO_AD_PRIVACY_TOOLTIP 37833
#define IDS_PAGE_INFO_AD_PRIVACY_TOPICS_DESCRIPTION 37834
#define IDS_PAGE_INFO_AD_PRIVACY_FLEDGE_DESCRIPTION 37835
#define IDS_PAGE_INFO_AD_PRIVACY_TOPICS_AND_FLEDGE_DESCRIPTION 37836
#define IDS_PAGE_INFO_AD_PRIVACY_SUBPAGE_MANAGE_BUTTON 37837
#define IDS_PAGE_INFO_COOKIES_SITE_NOT_WORKING_TITLE 37838
#define IDS_PAGE_INFO_TRACKING_PROTECTION_SITE_NOT_WORKING_DESCRIPTION_TEMPORARY 37839
#define IDS_PAGE_INFO_COOKIES_THIRD_PARTY_COOKIES_LABEL 37840
#define IDS_PAGE_INFO_TRACKING_PROTECTION_COOKIES_LIMITED_RESTART_TITLE 37841
#define IDS_PAGE_INFO_TRACKING_PROTECTION_COOKIES_BLOCKED_RESTART_TITLE 37842
#define IDS_PAGE_INFO_TRACKING_PROTECTION_COOKIES_RESTART_DESCRIPTION 37843
#define IDS_PAGE_INFO_TRACKING_PROTECTION_PERMANENT_ALLOWED_TITLE 37844
#define IDS_PAGE_INFO_TRACKING_PROTECTION_COOKIES_PERMANENT_ALLOWED_DESCRIPTION 37845
#define IDS_PAINT_PREVIEW_COMPOSITOR_SERVICE_DISPLAY_NAME 37846
#define IDS_LEAK_CHECK_CREDENTIALS 37847
#define IDS_CREDENTIAL_LEAK_TITLE_CHANGE 37848
#define IDS_CREDENTIAL_LEAK_TITLE_CHECK_GPM 37849
#define IDS_CREDENTIAL_LEAK_CHECK_PASSWORDS_MESSAGE_GPM_BRANDED 37850
#define IDS_CREDENTIAL_LEAK_CHANGE_PASSWORD_MESSAGE_GPM_BRANDED 37851
#define IDS_CREDENTIAL_LEAK_CHANGE_AND_CHECK_PASSWORDS_MESSAGE_GPM_BRANDED 37852
#define IDS_CREDENTIAL_LEAK_CHECK_PASSWORDS_MESSAGE_GPM_NON_BRANDED 37853
#define IDS_CREDENTIAL_LEAK_CHANGE_PASSWORD_MESSAGE_GPM_NON_BRANDED 37854
#define IDS_CREDENTIAL_LEAK_CHANGE_AND_CHECK_PASSWORDS_MESSAGE_GPM_NON_BRANDED 37855
#define IDS_PASSWORD_MANAGER_LEAK_HELP_MESSAGE 37857
#define IDS_PASSWORD_MANAGER_LEAK_HELP_MESSAGE_UPDATED 37858
#define IDS_MANAGE_PASSWORDS_AUTO_SIGNIN_TITLE 37859
#define IDS_PASSWORD_MANAGER_EMPTY_LOGIN 37860
#define IDS_PASSWORD_MANAGER_OPT_INTO_ACCOUNT_STORE 37861
#define IDS_PASSWORD_MANAGER_OPT_INTO_ACCOUNT_STORE_WITH_PASSKEYS 37862
#define IDS_PASSWORD_MANAGER_RE_SIGNIN_ACCOUNT_STORE 37863
#define IDS_PASSWORD_MANAGER_NO_ACCOUNT_STORE_MATCHES 37864
#define IDS_PASSWORD_MANAGER_MANAGE_PASSWORDS 37865
#define IDS_PASSWORD_MANAGER_MANAGE_PASSWORDS_AND_PASSKEYS 37866
#define IDS_PASSWORD_MANAGER_GENERATE_PASSWORD 37867
#define IDS_PASSWORD_MANAGER_EXCEPTIONS_TAB_TITLE 37868
#define IDS_PASSWORD_MANAGER_SHOW_PASSWORDS_TAB_TITLE 37869
#define IDS_PASSWORD_MANAGER_SMART_LOCK 37870
#define IDS_PASSWORD_MANAGER_DEFAULT_EXPORT_FILENAME 37871
#define IDS_PASSWORD_MANAGER_PASSWORD_FOR_ACCOUNT 37872
#define IDS_PASSWORD_MANAGER_USE_TOUCH_ID 37873
#define IDS_PASSWORD_MANAGER_USE_SCREEN_LOCK 37874
#define IDS_PASSWORD_MANAGER_PASSKEY 37875
#define IDS_PASSWORD_MANAGER_USE_WINDOWS_HELLO 37876
#define IDS_PASSWORD_MANAGER_USE_GENERIC_DEVICE 37877
#define IDS_PASSWORD_MANAGER_PASSKEY_FROM_CHROME_PROFILE 37878
#define IDS_PASSWORD_MANAGER_PASSKEY_FROM_ICLOUD_KEYCHAIN 37879
#define IDS_PASSWORD_MANAGER_PASSKEY_FROM_GOOGLE_PASSWORD_MANAGER 37880
#define IDS_PASSWORD_MANAGER_PASSKEY_FROM_CUSTOM_VENDOR 37881
#define IDS_PASSWORD_MANAGER_PASSKEY_FROM_WINDOWS_HELLO 37882
#define IDS_PASSWORD_MANAGER_PASSKEY_FROM_PHONE 37883
#define IDS_PASSWORD_MANAGER_USE_DEVICE_PASSKEY 37884
#define IDS_PASSWORD_MANAGER_USE_DIFFERENT_PASSKEY 37885
#define IDS_PASSWORD_MANAGER_USE_PASSKEY 37886
#define IDS_PASSWORD_MANAGER_RELAUNCH_CHROME_BUBBLE_TITLE_LINUX_BRANDED 37904
#define IDS_PASSWORD_MANAGER_RELAUNCH_CHROME_BUBBLE_DESCRIPTION_LINUX_BRANDED 37905
#define IDS_PASSWORD_MANAGER_RELAUNCH_CHROME_BUBBLE_TITLE_LINUX_NON_BRANDED 37906
#define IDS_PASSWORD_MANAGER_RELAUNCH_CHROME_BUBBLE_DESCRIPTION_LINUX_NON_BRANDED 37907
#define IDS_PASSWORD_MANAGER_RELAUNCH_CHROME_BUBBLE_ACCEPT_BUTTON_BRANDED 37911
#define IDS_PASSWORD_MANAGER_RELAUNCH_CHROME_BUBBLE_ACCEPT_BUTTON_NON_BRANDED 37912
#define IDS_PASSWORD_MANAGER_RELAUNCH_CHROME_BUBBLE_CANCEL_BUTTON 37913
#define IDS_PASSWORD_MANAGER_RELAUNCH_CHROME_BUBBLE_NEVER_BUTTON 37914
#define IDS_PASSWORD_MANAGER_MANAGEMENT_BUBBLE_FOOTER_MOVE_PASSWORD 37915
#define IDS_PASSWORD_MANAGER_MANAGEMENT_BUBBLE_LINK_TEXT_MOVE_PASSWORD 37916
#define IDS_PASSWORD_MANAGER_MANUAL_FALLBACK_SUGGESTED_PASSWORDS_SECTION_TITLE 37917
#define IDS_PASSWORD_MANAGER_MANUAL_FALLBACK_ALL_PASSWORDS_SECTION_TITLE 37918
#define IDS_PASSWORD_MANAGER_MANUAL_FALLBACK_FILL_PASSWORD_ENTRY 37919
#define IDS_PASSWORD_MANAGER_MANUAL_FALLBACK_VIEW_DETAILS_ENTRY 37920
#define IDS_PAYMENTS_TITLE 37921
#define IDS_PAYMENTS_ERROR_MESSAGE_DIALOG_TITLE 37922
#define IDS_PAYMENTS_METHOD_OF_PAYMENT_LABEL 37923
#define IDS_PAYMENTS_CONTACT_DETAILS_LABEL 37924
#define IDS_PAYMENTS_ADD_CONTACT_DETAILS_LABEL 37925
#define IDS_PAYMENTS_EDIT_CONTACT_DETAILS_LABEL 37926
#define IDS_PAYMENTS_ADD_MORE_INFORMATION 37927
#define IDS_PAYMENTS_ADD_PHONE_NUMBER 37928
#define IDS_PAYMENTS_ADD_RECIPIENT 37929
#define IDS_PAYMENTS_ADD_VALID_ADDRESS 37930
#define IDS_PAYMENTS_ADD_EMAIL 37931
#define IDS_PAYMENTS_ADD_NAME 37932
#define IDS_PAYMENTS_ORDER_SUMMARY_LABEL 37933
#define IDS_PAYMENT_REQUEST_PAYMENT_METHOD_SECTION_NAME 37934
#define IDS_PAYMENT_REQUEST_CONTACT_INFO_SECTION_NAME 37935
#define IDS_PAYMENTS_SHIPPING_SUMMARY_LABEL 37936
#define IDS_PAYMENTS_SHIPPING_ADDRESS_LABEL 37937
#define IDS_PAYMENTS_SHIPPING_OPTION_LABEL 37938
#define IDS_PAYMENTS_DELIVERY_SUMMARY_LABEL 37939
#define IDS_PAYMENTS_DELIVERY_ADDRESS_LABEL 37940
#define IDS_PAYMENTS_DELIVERY_OPTION_LABEL 37941
#define IDS_PAYMENTS_PICKUP_SUMMARY_LABEL 37942
#define IDS_PAYMENTS_PICKUP_ADDRESS_LABEL 37943
#define IDS_PAYMENTS_PICKUP_OPTION_LABEL 37944
#define IDS_PAYMENTS_EDIT_BUTTON 37945
#define IDS_PAYMENTS_PAY_BUTTON 37946
#define IDS_PAYMENTS_CONTINUE_BUTTON 37947
#define IDS_PAYMENTS_ADD_CONTACT 37948
#define IDS_PAYMENTS_ADD_CARD 37949
#define IDS_PAYMENTS_ADD_ADDRESS 37950
#define IDS_PAYMENTS_EDIT_ADDRESS 37951
#define IDS_PAYMENTS_CANCEL_PAYMENT 37952
#define IDS_PAYMENTS_NAME_FIELD_IN_CONTACT_DETAILS 37953
#define IDS_PAYMENTS_PHONE_FIELD_IN_CONTACT_DETAILS 37954
#define IDS_PAYMENTS_EMAIL_FIELD_IN_CONTACT_DETAILS 37955
#define IDS_PAYMENTS_LOADING_MESSAGE 37956
#define IDS_PAYMENTS_PROCESSING_MESSAGE 37957
#define IDS_PAYMENTS_CHECKING_OPTION 37958
#define IDS_PAYMENTS_UPDATED_LABEL 37959
#define IDS_PAYMENTS_ERROR_MESSAGE 37960
#define IDS_PAYMENTS_CARD_AND_ADDRESS_SETTINGS 37961
#define IDS_PAYMENTS_CARD_AND_ADDRESS_SETTINGS_SIGNED_IN 37962
#define IDS_PAYMENTS_CARD_AND_ADDRESS_SETTINGS_SIGNED_OUT 37963
#define IDS_SETTINGS_CAN_MAKE_PAYMENT_TOGGLE_LABEL 37964
#define IDS_PAYMENTS_REQUIRED_FIELD_MESSAGE 37965
#define IDS_PAYMENTS_VALIDATION_INVALID_CREDIT_CARD_EXPIRED 37966
#define IDS_PAYMENTS_VALIDATION_UNSUPPORTED_CREDIT_CARD_TYPE 37967
#define IDS_PAYMENTS_PHONE_INVALID_VALIDATION_MESSAGE 37968
#define IDS_PAYMENTS_EMAIL_INVALID_VALIDATION_MESSAGE 37969
#define IDS_PAYMENTS_CARD_NUMBER_INVALID_VALIDATION_MESSAGE 37970
#define IDS_PAYMENTS_INVALID_ADDRESS 37971
#define IDS_PAYMENTS_BILLING_ADDRESS_REQUIRED 37972
#define IDS_PAYMENTS_MORE_INFORMATION_REQUIRED 37973
#define IDS_PAYMENTS_PHONE_NUMBER_REQUIRED 37974
#define IDS_PAYMENTS_RECIPIENT_REQUIRED 37975
#define IDS_PAYMENTS_EMAIL_REQUIRED 37976
#define IDS_PAYMENTS_NAME_REQUIRED 37977
#define IDS_PREF_EDIT_DIALOG_FIELD_REQUIRED_VALIDATION_MESSAGE 37978
#define IDS_PAYMENT_REQUEST_ORDER_SUMMARY_SECTION_TOTAL_FORMAT 37979
#define IDS_PAYMENT_REQUEST_ORDER_SUMMARY_SHEET_TOTAL_FORMAT 37980
#define IDS_PAYMENT_REQUEST_ORDER_SUMMARY_MORE_ITEMS 37981
#define IDS_PAYMENT_REQUEST_ORDER_SUMMARY_MULTIPLE_CURRENCY_INDICATOR 37982
#define IDS_PAYMENTS_SELECT_SHIPPING_ADDRESS_FOR_SHIPPING_METHODS 37983
#define IDS_PAYMENTS_UNSUPPORTED_SHIPPING_ADDRESS 37984
#define IDS_PAYMENTS_UNSUPPORTED_SHIPPING_OPTION 37985
#define IDS_PAYMENTS_SELECT_DELIVERY_ADDRESS_FOR_DELIVERY_METHODS 37986
#define IDS_PAYMENTS_UNSUPPORTED_DELIVERY_ADDRESS 37987
#define IDS_PAYMENTS_SELECT_PICKUP_ADDRESS_FOR_PICKUP_METHODS 37988
#define IDS_PAYMENTS_UNSUPPORTED_PICKUP_ADDRESS 37989
#define IDS_PAYMENTS_ANDROID_APP_ERROR 37990
#define IDS_PAYMENT_REQUEST_PAYMENT_METHODS_PREVIEW 37992
#define IDS_PAYMENT_REQUEST_SHIPPING_ADDRESSES_PREVIEW 37993
#define IDS_PAYMENT_REQUEST_SHIPPING_OPTIONS_PREVIEW 37994
#define IDS_PAYMENT_REQUEST_CONTACTS_PREVIEW 37995
#define IDS_PAYMENTS_BACK 37996
#define IDS_PAYMENTS_CLOSE 37997
#define IDS_PAYMENTS_EDIT 37998
#define IDS_PAYMENTS_ROW_ACCESSIBLE_NAME_FORMAT 37999
#define IDS_PAYMENTS_ROW_ACCESSIBLE_NAME_SELECTED_FORMAT 38000
#define IDS_PAYMENTS_PROFILE_LABELS_ACCESSIBLE_FORMAT 38001
#define IDS_PAYMENTS_ACCESSIBLE_LABEL_WITH_ERROR 38002
#define IDS_PAYMENTS_ORDER_SUMMARY_ACCESSIBLE_LABEL 38003
#define IDS_PAYMENT_HANDLER_SHEET_DESCRIPTION 38004
#define IDS_PAYMENT_HANDLER_SHEET_OPENED_HALF 38005
#define IDS_PAYMENT_HANDLER_SHEET_OPENED_FULL 38006
#define IDS_PAYMENT_HANDLER_SHEET_CLOSED 38007
#define IDS_PAYMENT_HANDLER_ICON 38008
#define IDS_SECURE_PAYMENT_CONFIRMATION_INLINE_TITLE 38009
#define IDS_SECURE_PAYMENT_CONFIRMATION_VERIFY_PURCHASE 38010
#define IDS_SECURE_PAYMENT_CONFIRMATION_INLINE_DESCRIPTION 38011
#define IDS_SECURE_PAYMENT_CONFIRMATION_OPT_OUT_LABEL 38012
#define IDS_SECURE_PAYMENT_CONFIRMATION_STORE_LABEL 38015
#define IDS_SECURE_PAYMENT_CONFIRMATION_TOTAL_LABEL 38016
#define IDS_SECURE_PAYMENT_CONFIRMATION_NETWORK_LABEL 38017
#define IDS_SECURE_PAYMENT_CONFIRMATION_ISSUER_LABEL 38018
#define IDS_SECURE_PAYMENT_CONFIRMATION_VERIFY_BUTTON_LABEL 38019
#define IDS_SECURE_PAYMENT_CONFIRMATION_OPT_OUT_LINK_LABEL 38020
#define IDS_NO_MATCHING_CREDENTIAL_DESCRIPTION 38021
#define IDS_PDF_DOWNLOAD_ORIGINAL 38028
#define IDS_PDF_DOWNLOAD_EDITED 38029
#define IDS_PDF_PRESENT 38030
#define IDS_PDF_NEED_PASSWORD 38031
#define IDS_PDF_PASSWORD_DIALOG_TITLE 38032
#define IDS_PDF_PASSWORD_SUBMIT 38033
#define IDS_PDF_PASSWORD_INVALID 38034
#define IDS_PDF_PAGE_LOADING 38035
#define IDS_PDF_ERROR_DIALOG_TITLE 38036
#define IDS_PDF_PAGE_LOAD_FAILED 38037
#define IDS_PDF_PAGE_RELOAD_BUTTON 38038
#define IDS_PDF_BOOKMARKS 38039
#define IDS_PDF_BOOKMARK_EXPAND_ICON_ARIA_LABEL 38040
#define IDS_PDF_PROPERTIES_DIALOG_TITLE 38041
#define IDS_PDF_PROPERTIES_FILE_NAME 38042
#define IDS_PDF_PROPERTIES_FILE_SIZE 38043
#define IDS_PDF_PROPERTIES_TITLE 38044
#define IDS_PDF_PROPERTIES_AUTHOR 38045
#define IDS_PDF_PROPERTIES_SUBJECT 38046
#define IDS_PDF_PROPERTIES_KEYWORDS 38047
#define IDS_PDF_PROPERTIES_CREATED 38048
#define IDS_PDF_PROPERTIES_MODIFIED 38049
#define IDS_PDF_PROPERTIES_APPLICATION 38050
#define IDS_PDF_PROPERTIES_PDF_PRODUCER 38051
#define IDS_PDF_PROPERTIES_PDF_VERSION 38052
#define IDS_PDF_PROPERTIES_PAGE_COUNT 38053
#define IDS_PDF_PROPERTIES_PAGE_SIZE 38054
#define IDS_PDF_PROPERTIES_PAGE_SIZE_VALUE_INCH 38055
#define IDS_PDF_PROPERTIES_PAGE_SIZE_VALUE_MM 38056
#define IDS_PDF_PROPERTIES_PAGE_SIZE_PORTRAIT 38057
#define IDS_PDF_PROPERTIES_PAGE_SIZE_LANDSCAPE 38058
#define IDS_PDF_PROPERTIES_PAGE_SIZE_SQUARE 38059
#define IDS_PDF_PROPERTIES_PAGE_SIZE_VARIABLE 38060
#define IDS_PDF_PROPERTIES_FAST_WEB_VIEW 38061
#define IDS_PDF_PROPERTIES_FAST_WEB_VIEW_NO 38062
#define IDS_PDF_PROPERTIES_FAST_WEB_VIEW_YES 38063
#define IDS_PDF_TOOLTIP_ROTATE_CCW 38064
#define IDS_PDF_ROTATION_STATE_LABEL_0 38065
#define IDS_PDF_ROTATION_STATE_LABEL_90 38066
#define IDS_PDF_ROTATION_STATE_LABEL_180 38067
#define IDS_PDF_ROTATION_STATE_LABEL_270 38068
#define IDS_PDF_TOOLTIP_DOWNLOAD 38069
#define IDS_PDF_TOOLTIP_PRINT 38070
#define IDS_PDF_TOOLTIP_FIT_PAGE 38071
#define IDS_PDF_TOOLTIP_FIT_WIDTH 38072
#define IDS_PDF_TWO_UP_VIEW_ENABLE 38073
#define IDS_PDF_ANNOTATIONS_SHOW_TOGGLE 38074
#define IDS_PDF_ZOOM_TEXT_INPUT_ARIA_LABEL 38075
#define IDS_PDF_TOOLTIP_ZOOM_IN 38076
#define IDS_PDF_TOOLTIP_ZOOM_OUT 38077
#define IDS_PDF_TOOLTIP_THUMBNAILS 38078
#define IDS_PDF_TOOLTIP_DOCUMENT_OUTLINE 38079
#define IDS_PDF_TOOLTIP_ATTACHMENTS 38080
#define IDS_PDF_TOOLTIP_DOWNLOAD_ATTACHMENT 38081
#define IDS_PDF_LABEL_PAGE_NUMBER 38082
#define IDS_PDF_LOADING_TO_A11Y_TREE 38083
#define IDS_PDF_LOADED_TO_A11Y_TREE 38084
#define IDS_PDF_OVERSIZE_ATTACHMENT_WARNING 38085
#define IDS_PDF_PAGE_INDEX 38086
#define IDS_PDF_DOCUMENT_PAGE_COUNT 38087
#define IDS_PDF_THUMBNAIL_PAGE_ARIA_LABEL 38088
#define IDS_PDF_ANNOTATION_ANNOTATE 38089
#define IDS_PDF_ANNOTATION_UNAVAILABLE 38090
#define IDS_PDF_ANNOTATION_EDIT_IN_DEFAULT_VIEW 38091
#define IDS_PDF_ANNOTATION_RESET_ROTATE 38092
#define IDS_PDF_ANNOTATION_RESET_TWO_PAGE_VIEW 38093
#define IDS_PDF_ANNOTATION_RESET_ROTATE_AND_TWO_PAGE_VIEW 38094
#define IDS_PDF_ANNOTATION_DOCUMENT_TOO_LARGE 38095
#define IDS_PDF_ANNOTATION_DOCUMENT_PROTECTED 38096
#define IDS_PDF_ANNOTATION_DOCUMENT_ROTATED 38097
#define IDS_PDF_ANNOTATION_PEN 38098
#define IDS_PDF_ANNOTATION_HIGHLIGHTER 38099
#define IDS_PDF_ANNOTATION_ERASER 38100
#define IDS_PDF_ANNOTATION_UNDO 38101
#define IDS_PDF_ANNOTATION_REDO 38102
#define IDS_PDF_ANNOTATION_EXPAND 38103
#define IDS_PDF_ANNOTATION_COLOR_BLACK 38104
#define IDS_PDF_ANNOTATION_COLOR_RED 38105
#define IDS_PDF_ANNOTATION_COLOR_YELLOW 38106
#define IDS_PDF_ANNOTATION_COLOR_GREEN 38107
#define IDS_PDF_ANNOTATION_COLOR_CYAN 38108
#define IDS_PDF_ANNOTATION_COLOR_PURPLE 38109
#define IDS_PDF_ANNOTATION_COLOR_BROWN 38110
#define IDS_PDF_ANNOTATION_COLOR_WHITE 38111
#define IDS_PDF_ANNOTATION_COLOR_CRIMSON 38112
#define IDS_PDF_ANNOTATION_COLOR_AMBER 38113
#define IDS_PDF_ANNOTATION_COLOR_AVOCADO_GREEN 38114
#define IDS_PDF_ANNOTATION_COLOR_COBALT_BLUE 38115
#define IDS_PDF_ANNOTATION_COLOR_DEEP_PURPLE 38116
#define IDS_PDF_ANNOTATION_COLOR_DARK_BROWN 38117
#define IDS_PDF_ANNOTATION_COLOR_DARK_GREY 38118
#define IDS_PDF_ANNOTATION_COLOR_HOT_PINK 38119
#define IDS_PDF_ANNOTATION_COLOR_ORANGE 38120
#define IDS_PDF_ANNOTATION_COLOR_LIME 38121
#define IDS_PDF_ANNOTATION_COLOR_BLUE 38122
#define IDS_PDF_ANNOTATION_COLOR_VIOLET 38123
#define IDS_PDF_ANNOTATION_COLOR_TEAL 38124
#define IDS_PDF_ANNOTATION_COLOR_LIGHT_GREY 38125
#define IDS_PDF_ANNOTATION_COLOR_LIGHT_PINK 38126
#define IDS_PDF_ANNOTATION_COLOR_LIGHT_ORANGE 38127
#define IDS_PDF_ANNOTATION_COLOR_LIGHT_GREEN 38128
#define IDS_PDF_ANNOTATION_COLOR_LIGHT_BLUE 38129
#define IDS_PDF_ANNOTATION_COLOR_LAVENDER 38130
#define IDS_PDF_ANNOTATION_COLOR_LIGHT_TEAL 38131
#define IDS_PDF_ANNOTATION_SIZE1 38132
#define IDS_PDF_ANNOTATION_SIZE2 38133
#define IDS_PDF_ANNOTATION_SIZE3 38134
#define IDS_PDF_ANNOTATION_SIZE4 38135
#define IDS_PDF_ANNOTATION_SIZE8 38136
#define IDS_PDF_ANNOTATION_SIZE12 38137
#define IDS_PDF_ANNOTATION_SIZE16 38138
#define IDS_PDF_ANNOTATION_SIZE20 38139
#define IDS_AX_ROLE_DESCRIPTION_PDF_HIGHLIGHT 38140
#define IDS_AX_ROLE_DESCRIPTION_PDF_POPUP_NOTE 38141
#define IDS_PDF_OCR_FEATURE_ALERT 38142
#define IDS_PDF_OCR_IN_PROGRESS 38143
#define IDS_PDF_OCR_COMPLETED 38144
#define IDS_PDF_OCR_NO_RESULT 38145
#define IDS_PDF_OCR_POSTAMBLE_PAGE 38146
#define IDS_GEOLOCATION_INFOBAR_TEXT 38147
#define IDS_GEOLOCATION_INFOBAR_PERMISSION_FRAGMENT 38176
#define IDS_NOTIFICATION_PERMISSIONS_FRAGMENT 38177
#define IDS_MIDI_SYSEX_PERMISSION_FRAGMENT 38178
#define IDS_MEDIA_CAPTURE_AUDIO_ONLY_PERMISSION_FRAGMENT 38179
#define IDS_MEDIA_CAPTURE_AUDIO_ONLY_PERMISSION_FRAGMENT_WITH_COUNT 38180
#define IDS_MEDIA_CAPTURE_VIDEO_ONLY_PERMISSION_FRAGMENT 38181
#define IDS_MEDIA_CAPTURE_VIDEO_ONLY_PERMISSION_FRAGMENT_WITH_COUNT 38182
#define IDS_MEDIA_CAPTURE_CAMERA_PAN_TILT_ZOOM_PERMISSION_FRAGMENT 38183
#define IDS_MEDIA_CAPTURE_CAMERA_PAN_TILT_ZOOM_PERMISSION_FRAGMENT_WITH_COUNT 38184
#define IDS_ACCESSIBILITY_EVENTS_PERMISSION_FRAGMENT 38185
#define IDS_CLIPBOARD_PERMISSION_FRAGMENT 38186
#define IDS_VR_PERMISSION_FRAGMENT 38187
#define IDS_AR_PERMISSION_FRAGMENT 38188
#define IDS_KEYBOARD_LOCK_PERMISSIONS_FRAGMENT 38189
#define IDS_POINTER_LOCK_PERMISSIONS_FRAGMENT 38190
#define IDS_STORAGE_ACCESS_PERMISSION_TWO_ORIGIN_PROMPT_TITLE 38191
#define IDS_STORAGE_ACCESS_PERMISSION_FRAGMENT 38192
#define IDS_STORAGE_ACCESS_PERMISSION_EXPLANATION 38193
#define IDS_STORAGE_ACCESS_PERMISSION_TWO_ORIGIN_EXPLANATION 38194
#define IDS_STORAGE_ACCESS_PERMISSION_TWO_ORIGIN_LINK 38195
#define IDS_WINDOW_MANAGEMENT_PERMISSION_FRAGMENT 38196
#define IDS_FONT_ACCESS_PERMISSION_FRAGMENT 38197
#define IDS_IDLE_DETECTION_PERMISSION_FRAGMENT 38198
#define IDS_IDENTITY_PROVIDER_PERMISSION_FRAGMENT 38199
#define IDS_MULTI_DOWNLOAD_PERMISSION_FRAGMENT 38200
#define IDS_CAPTURED_SURFACE_CONTROL_PERMISSION_FRAGMENT 38201
#define IDS_PERMISSION_ALLOW 38202
#define IDS_PERMISSION_DENY 38203
#define IDS_PERMISSION_ALLOW_THIS_TIME 38204
#define IDS_PERMISSION_ALLOW_EVERY_VISIT 38205
#define IDS_PERMISSION_ALLOW_WHILE_VISITING 38206
#define IDS_PERMISSION_DONT_ALLOW 38207
#define IDS_PERMISSION_NEVER_ALLOW 38208
#define IDS_BLUETOOTH_DEVICE_CHOOSER_PROMPT 38209
#define IDS_BLUETOOTH_DEVICE_CHOOSER_NO_DEVICES_FOUND_PROMPT 38210
#define IDS_BLUETOOTH_DEVICE_CHOOSER_PAIR_BUTTON_TEXT 38211
#define IDS_BLUETOOTH_DEVICE_CHOOSER_SCANNING_LABEL 38212
#define IDS_BLUETOOTH_DEVICE_CHOOSER_SCANNING_LABEL_TOOLTIP 38213
#define IDS_DEVICE_CHOOSER_DEVICE_NAME_WITH_ID 38214
#define IDS_BLUETOOTH_SCANNING_PROMPT 38215
#define IDS_BLUETOOTH_SCANNING_DEVICE_UNKNOWN 38216
#define IDS_BLUETOOTH_SCANNING_PROMPT_NO_DEVICES_FOUND_PROMPT 38217
#define IDS_BLUETOOTH_SCANNING_PROMPT_ALLOW_BUTTON_TEXT 38218
#define IDS_BLUETOOTH_SCANNING_PROMPT_BLOCK_BUTTON_TEXT 38219
#define IDS_DEVICE_CHOOSER_CANCEL_BUTTON_TEXT 38220
#define IDS_DEVICE_CHOOSER_NO_DEVICES_FOUND_PROMPT 38221
#define IDS_USB_DEVICE_CHOOSER_PROMPT 38222
#define IDS_USB_DEVICE_CHOOSER_CONNECT_BUTTON_TEXT 38223
#define IDS_USB_DEVICE_CHOOSER_LOADING_LABEL 38224
#define IDS_USB_DEVICE_CHOOSER_LOADING_LABEL_TOOLTIP 38225
#define IDS_PRIVATE_NETWORK_DEVICE_CHOOSER_PROMPT_ORIGIN 38226
#define IDS_PRIVATE_NETWORK_DEVICE_CHOOSER_CONNECT_BUTTON_TEXT 38227
#define IDS_GEOLOCATION_PERMISSION_CHIP 38228
#define IDS_NOTIFICATION_PERMISSIONS_CHIP 38229
#define IDS_MIDI_SYSEX_PERMISSION_CHIP 38230
#define IDS_MEDIA_CAPTURE_AUDIO_ONLY_PERMISSION_CHIP 38231
#define IDS_MEDIA_CAPTURE_VIDEO_ONLY_PERMISSION_CHIP 38232
#define IDS_MEDIA_CAPTURE_VIDEO_AND_AUDIO_PERMISSION_CHIP 38233
#define IDS_CLIPBOARD_PERMISSION_CHIP 38234
#define IDS_SAA_PERMISSION_CHIP 38235
#define IDS_VR_PERMISSION_CHIP 38236
#define IDS_AR_PERMISSION_CHIP 38237
#define IDS_IDLE_DETECTION_PERMISSION_CHIP 38238
#define IDS_GEOLOCATION_PERMISSION_BLOCKED_CHIP 38239
#define IDS_NOTIFICATION_PERMISSIONS_BLOCKED_CHIP 38240
#define IDS_CAPTURED_SURFACE_CONTROL_PERMISSION_CHIP 38241
#define IDS_CAPTURED_SURFACE_CONTROL_PERMISSION_BLOCKED_CHIP 38242
#define IDS_PERMISSIONS_CAPTURED_SURFACE_CONTROL_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 38243
#define IDS_PERMISSIONS_CAPTURED_SURFACE_CONTROL_NOT_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 38244
#define IDS_PERMISSIONS_PERMISSION_ALLOWED_CONFIRMATION 38245
#define IDS_PERMISSIONS_PERMISSION_ALLOWED_ONCE_CONFIRMATION 38246
#define IDS_PERMISSIONS_PERMISSION_NOT_ALLOWED_CONFIRMATION 38247
#define IDS_PERMISSIONS_NOTIFICATION_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 38248
#define IDS_PERMISSIONS_NOTIFICATION_NOT_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 38249
#define IDS_PERMISSIONS_GEOLOCATION_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 38250
#define IDS_PERMISSIONS_GEOLOCATION_ALLOWED_ONCE_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 38251
#define IDS_PERMISSIONS_GEOLOCATION_NOT_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 38252
#define IDS_PERMISSIONS_CAMERA_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 38253
#define IDS_PERMISSIONS_CAMERA_ALLOWED_ONCE_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 38254
#define IDS_PERMISSIONS_CAMERA_NOT_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 38255
#define IDS_PERMISSIONS_MICROPHONE_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 38256
#define IDS_PERMISSIONS_MICROPHONE_ALLOWED_ONCE_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 38257
#define IDS_PERMISSIONS_MICROPHONE_NOT_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 38258
#define IDS_PERMISSIONS_CAMERA_AND_MICROPHONE_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 38259
#define IDS_PERMISSIONS_CAMERA_AND_MICROPHONE_ALLOWED_ONCE_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 38260
#define IDS_PERMISSIONS_CAMERA_AND_MICROPHONE_NOT_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 38261
#define IDS_PERMISSIONS_SAA_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 38262
#define IDS_PERMISSIONS_SAA_NOT_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 38263
#define IDS_REQUEST_QUOTA_INFOBAR_TEXT 38267
#define IDS_REQUEST_LARGE_QUOTA_INFOBAR_TEXT 38268
#define IDS_REQUEST_QUOTA_PERMISSION_FRAGMENT 38269
#define IDS_EMBEDDED_PROMPT_ADMIN_BLOCKED 38270
#define IDS_EMBEDDED_PROMPT_ADMIN_ALLOWED 38271
#define IDS_EMBEDDED_PROMPT_PREVIOUSLY_ALLOWED 38272
#define IDS_EMBEDDED_PROMPT_PREVIOUSLY_NOT_ALLOWED 38273
#define IDS_PERMISSION_OFF_FOR_CHROME 38274
#define IDS_PERMISSION_CHROME_NEEDS_PERMISSION 38275
#define IDS_GEOLOCATION_NAME_FRAGMENT 38276
#define IDS_CAMERA_PERMISSION_NAME_FRAGMENT 38277
#define IDS_MICROPHONE_PERMISSION_NAME_FRAGMENT 38278
#define IDS_CAMERA_AND_MICROPHONE_PERMISSION_NAME_FRAGMENT 38279
#define IDS_CAMERA_PERMISSION_NAME_FRAGMENT_CAPITALIZED 38280
#define IDS_MICROPHONE_PERMISSION_NAME_FRAGMENT_CAPITALIZED 38281
#define IDS_CAMERA_AND_MICROPHONE_PERMISSION_NAME_FRAGMENT_CAPITALIZED 38282
#define IDS_MACOS_NAME_FRAGMENT 38283
#define IDS_EMBEDDED_PROMPT_OK_LABEL 38284
#define IDS_EMBEDDED_PROMPT_CONTINUE_ALLOWING 38285
#define IDS_EMBEDDED_PROMPT_STOP_ALLOWING 38286
#define IDS_EMBEDDED_PROMPT_OPEN_SYSTEM_SETTINGS 38287
#define IDS_EMBEDDED_PROMPT_CONTINUE_NOT_ALLOWING 38288
#define IDS_PERMISSION_PROMPT_SURVEY_CUSTOM_INVITATION 38289
#define IDS_PLUS_ADDRESS_FALLBACK_LABEL_CONTEXT_MENU 38290
#define IDS_PLUS_ADDRESS_MODAL_REPORT_ERROR_INSTRUCTION_V2 38291
#define IDS_PLUS_ADDRESS_MODAL_PLUS_ADDRESS_DESCRIPTION_V2 38292
#define IDS_PLUS_ADDRESS_MODAL_REPORT_ERROR_INSTRUCTION_IOS 38293
#define IDS_PLUS_ADDRESS_MODAL_PLUS_ADDRESS_DESCRIPTION_IOS 38294
#define IDS_PLUS_ADDRESS_BOTTOMSHEET_TITLE_ANDROID 38295
#define IDS_PLUS_ADDRESS_BOTTOMSHEET_DESCRIPTION_ANDROID 38296
#define IDS_PLUS_ADDRESS_BOTTOMSHEET_PROPOSED_PLUS_ADDRESS_PLACEHOLDER_ANDROID 38297
#define IDS_PLUS_ADDRESS_BOTTOMSHEET_CANCEL_TEXT_ANDROID 38298
#define IDS_PLUS_ADDRESS_BOTTOMSHEET_OK_TEXT_ANDROID 38299
#define IDS_PLUS_ADDRESS_BOTTOMSHEET_REPORT_ERROR_INSTRUCTION_ANDROID 38300
#define IDS_PLUS_ADDRESS_MODEL_REFRESH_BUTTON_ACCESSIBLE_NAME_ANDROID 38301
#define IDS_PLUS_ADDRESS_MODEL_REFRESH_TEMPORARY_LABEL_CONTENT_ANDROID 38302
#define IDS_PLUS_ADDRESS_BOTTOMSHEET_TITLE_IOS 38303
#define IDS_PLUS_ADDRESS_BOTTOMSHEET_DESCRIPTION_IOS 38304
#define IDS_PLUS_ADDRESS_BOTTOMSHEET_REPORT_ERROR_INSTRUCTION_IOS 38305
#define IDS_PLUS_ADDRESS_BOTTOMSHEET_CANCEL_TEXT_IOS 38306
#define IDS_PLUS_ADDRESS_BOTTOMSHEET_OK_TEXT_IOS 38307
#define IDS_PLUS_ADDRESS_BOTTOMSHEET_LOADING_TEMPORARY_LABEL_CONTENT_IOS 38308
#define IDS_PLUS_ADDRESS_BOTTOMSHEET_REFRESH_TEMPORARY_LABEL_CONTENT_IOS 38309
#define IDS_PLUS_ADDRESS_MODAL_TITLE 38310
#define IDS_PLUS_ADDRESS_MODAL_DESCRIPTION 38311
#define IDS_PLUS_ADDRESS_MODAL_PLUS_ADDRESS_LINK_TEXT 38312
#define IDS_PLUS_ADDRESS_MODAL_PLUS_ADDRESS_DESCRIPTION_START 38313
#define IDS_PLUS_ADDRESS_MODAL_PLUS_ADDRESS_DESCRIPTION_END 38314
#define IDS_PLUS_ADDRESS_MODAL_ERROR_REPORT_LINK_TEXT 38315
#define IDS_PLUS_ADDRESS_MODAL_REPORT_ERROR_INSTRUCTION_DESKTOP 38316
#define IDS_PLUS_ADDRESS_MODAL_PROPOSED_PLUS_ADDRESS_PLACEHOLDER 38317
#define IDS_PLUS_ADDRESS_MODAL_CANCEL_TEXT 38318
#define IDS_PLUS_ADDRESS_MODAL_OK_TEXT 38319
#define IDS_PLUS_ADDRESS_MODAL_REFRESH_BUTTON_ACCESSIBLE_NAME 38320
#define IDS_PLUS_ADDRESS_MODAL_REFRESH_TEMPORARY_LABEL_CONTENT 38321
#define IDS_PLUS_ADDRESS_SETTINGS_LABEL 38322
#define IDS_PLUS_ADDRESS_CREATE_SUGGESTION_MAIN_TEXT 38323
#define IDS_PLUS_ADDRESS_CREATE_SUGGESTION_SECONDARY_TEXT 38324
#define IDS_PLUS_ADDRESS_FILL_SUGGESTION_SECONDARY_TEXT 38325
#define IDS_PLUS_ADDRESS_MANAGE_PLUS_ADDRESSES_TEXT 38326
#define IDS_POLICY_DM_STATUS_SUCCESS 38327
#define IDS_POLICY_DM_STATUS_REQUEST_INVALID 38328
#define IDS_POLICY_DM_STATUS_REQUEST_FAILED 38329
#define IDS_POLICY_DM_STATUS_TEMPORARY_UNAVAILABLE 38330
#define IDS_POLICY_DM_STATUS_HTTP_STATUS_ERROR 38331
#define IDS_POLICY_DM_STATUS_RESPONSE_DECODING_ERROR 38332
#define IDS_POLICY_DM_STATUS_SERVICE_MANAGEMENT_NOT_SUPPORTED 38333
#define IDS_POLICY_DM_STATUS_SERVICE_DEVICE_NOT_FOUND 38334
#define IDS_POLICY_DM_STATUS_SERVICE_MANAGEMENT_TOKEN_INVALID 38335
#define IDS_POLICY_DM_STATUS_SERVICE_ACTIVATION_PENDING 38336
#define IDS_POLICY_DM_STATUS_SERVICE_INVALID_SERIAL_NUMBER 38337
#define IDS_POLICY_DM_STATUS_SERVICE_DEVICE_ID_CONFLICT 38338
#define IDS_POLICY_DM_STATUS_SERVICE_MISSING_LICENSES 38339
#define IDS_POLICY_DM_STATUS_SERVICE_DEPROVISIONED 38340
#define IDS_POLICY_DM_STATUS_SERVICE_POLICY_NOT_FOUND 38341
#define IDS_POLICY_DM_STATUS_UNKNOWN_ERROR 38342
#define IDS_POLICY_DM_STATUS_INVALID_PACKAGED_DEVICE_FOR_KIOSK 38343
#define IDS_POLICY_DM_STATUS_SERVICE_DOMAIN_MISMATCH 38344
#define IDS_POLICY_DM_STATUS_CANNOT_SIGN_REQUEST 38345
#define IDS_POLICY_DM_STATUS_REQUEST_TOO_LARGE 38346
#define IDS_POLICY_DM_STATUS_SERVICE_TOO_MANY_REQUESTS 38347
#define IDS_POLICY_DM_STATUS_SERVICE_DEVICE_NEEDS_RESET 38348
#define IDS_POLICY_DM_STATUS_CONSUMER_ACCOUNT_WITH_PACKAGED_LICENSE 38349
#define IDS_POLICY_DM_STATUS_ENTERPRISE_ACCOUNT_IS_NOT_ELIGIBLE_TO_ENROLL 38350
#define IDS_POLICY_VALIDATION_OK 38351
#define IDS_POLICY_VALIDATION_BAD_INITIAL_SIGNATURE 38352
#define IDS_POLICY_VALIDATION_BAD_SIGNATURE 38353
#define IDS_POLICY_VALIDATION_ERROR_CODE_PRESENT 38354
#define IDS_POLICY_VALIDATION_PAYLOAD_PARSE_ERROR 38355
#define IDS_POLICY_VALIDATION_WRONG_POLICY_TYPE 38356
#define IDS_POLICY_VALIDATION_WRONG_SETTINGS_ENTITY_ID 38357
#define IDS_POLICY_VALIDATION_BAD_TIMESTAMP 38358
#define IDS_POLICY_VALIDATION_BAD_DM_TOKEN 38359
#define IDS_POLICY_VALIDATION_BAD_DEVICE_ID 38360
#define IDS_POLICY_VALIDATION_BAD_USER 38361
#define IDS_POLICY_VALIDATION_POLICY_PARSE_ERROR 38362
#define IDS_POLICY_VALIDATION_BAD_KEY_VERIFICATION_SIGNATURE 38363
#define IDS_POLICY_VALIDATION_VALUE_WARNING 38364
#define IDS_POLICY_VALIDATION_VALUE_ERROR 38365
#define IDS_POLICY_VALIDATION_UNKNOWN_ERROR 38366
#define IDS_POLICY_STORE_STATUS_OK 38367
#define IDS_POLICY_STORE_STATUS_LOAD_ERROR 38368
#define IDS_POLICY_STORE_STATUS_STORE_ERROR 38369
#define IDS_POLICY_STORE_STATUS_PARSE_ERROR 38370
#define IDS_POLICY_STORE_STATUS_SERIALIZE_ERROR 38371
#define IDS_POLICY_STORE_STATUS_VALIDATION_ERROR 38372
#define IDS_POLICY_STORE_STATUS_BAD_STATE 38373
#define IDS_POLICY_STORE_STATUS_UNKNOWN_ERROR 38374
#define IDS_POLICY_ASSOCIATION_STATE_ACTIVE 38375
#define IDS_POLICY_ASSOCIATION_STATE_UNMANAGED 38376
#define IDS_POLICY_ASSOCIATION_STATE_DEPROVISIONED 38377
#define IDS_POLICY_TYPE_ERROR 38378
#define IDS_POLICY_OUT_OF_RANGE_ERROR 38379
#define IDS_POLICY_VALUE_FORMAT_ERROR 38380
#define IDS_POLICY_INVALID_FILE_EXTENSION_ERROR 38381
#define IDS_POLICY_INVALID_HASH_ERROR 38382
#define IDS_POLICY_INVALID_SELECTION_ERROR 38383
#define IDS_POLICY_PAPER_SIZE_CUSTOM_NO_SIZE_ERROR 38384
#define IDS_POLICY_PAPER_SIZE_NOT_CUSTOM_ERROR 38385
#define IDS_POLICY_INVALID_ACCOUNT_PATTERN_FORMAT_ERROR 38386
#define IDS_POLICY_INVALID_PROTOCOL_ERROR 38387
#define IDS_POLICY_INVALID_ORIGIN_ERROR 38388
#define IDS_POLICY_EMPTY_ORIGIN_LIST_ERROR 38389
#define IDS_POLICY_INVALID_EXTENSION_ID_ERROR 38391
#define IDS_POLICY_INVALID_UPDATE_URL_ERROR 38392
#define IDS_POLICY_URL_PATH_SPECIFIED_ERROR 38393
#define IDS_POLICY_MISSING_VENDOR_ID_ERROR 38394
#define IDS_POLICY_INVALID_NUMBER_OF_URLS_ERROR 38395
#define IDS_POLICY_BRUSCHETTA_UNINSTALLABLE_ERROR 38396
#define IDS_POLICY_CLOUD_SOURCE_ONLY_ERROR 38397
#define IDS_POLICY_CLOUD_USER_ONLY_ERROR 38398
#define IDS_POLICY_CLOUD_MANAGEMENT_ENROLLMENT_ONLY_ERROR 38399
#define IDS_POLICY_DEFAULT_SEARCH_DISABLED 38400
#define IDS_POLICY_NOT_SPECIFIED_ERROR 38401
#define IDS_POLICY_EXTENSION_SETTINGS_ORIGIN_LIMIT_WARNING 38402
#define IDS_POLICY_URL_ALLOW_BLOCK_LIST_MAX_FILTERS_LIMIT_WARNING 38403
#define IDS_POLICY_ERROR_WITH_PATH 38404
#define IDS_POLICY_SCHEMA_VALIDATION_ERROR 38405
#define IDS_POLICY_INVALID_JSON_ERROR 38406
#define IDS_POLICY_INVALID_URL_ERROR 38407
#define IDS_POLICY_URL_NOT_HTTPS_ERROR 38408
#define IDS_POLICY_INVALID_SEARCH_URL_ERROR 38409
#define IDS_POLICY_INVALID_SECURE_DNS_MODE_ERROR 38410
#define IDS_POLICY_SECURE_DNS_TEMPLATES_INVALID_ERROR 38411
#define IDS_POLICY_SECURE_DNS_SALT_INVALID_ERROR 38412
#define IDS_POLICY_SECURE_DNS_SALT_INVALID_SIZE_ERROR 38413
#define IDS_POLICY_SECURE_DNS_TEMPLATES_IRRELEVANT_MODE_ERROR 38414
#define IDS_POLICY_SECURE_DNS_TEMPLATES_INVALID_MODE_ERROR 38415
#define IDS_POLICY_SECURE_DNS_TEMPLATES_UNSET_MODE_ERROR 38416
#define IDS_POLICY_SECURE_DNS_TEMPLATES_NOT_SPECIFIED_ERROR 38417
#define IDS_POLICY_INVALID_PROXY_MODE_ERROR 38418
#define IDS_POLICY_OFF_CWS_URL_ERROR 38420
#define IDS_POLICY_HOMEPAGE_LOCATION_ERROR 38421
#define IDS_POLICY_PROXY_MODE_DISABLED_ERROR 38422
#define IDS_POLICY_PROXY_MODE_AUTO_DETECT_ERROR 38423
#define IDS_POLICY_PROXY_MODE_PAC_URL_ERROR 38424
#define IDS_POLICY_PROXY_MODE_FIXED_SERVERS_ERROR 38425
#define IDS_POLICY_PROXY_MODE_SYSTEM_ERROR 38426
#define IDS_POLICY_PROXY_BOTH_SPECIFIED_ERROR 38427
#define IDS_POLICY_PROXY_NEITHER_SPECIFIED_ERROR 38428
#define IDS_POLICY_OVERRIDDEN 38429
#define IDS_POLICY_VALUE_DEPRECATED 38430
#define IDS_POLICY_DEPENDENCY_ERROR 38431
#define IDS_POLICY_DEPENDENCY_ERROR_ANY_VALUE 38432
#define IDS_POLICY_IDLE_TIMEOUT_ACTIONS_DEPENDENCY_ERROR 38433
#define IDS_POLICY_USER_IS_NOT_AFFILIATED_ERROR 38434
#define IDS_POLICY_LEVEL_ERROR 38439
#define IDS_POLICY_OK 38440
#define IDS_POLICY_UNSET 38441
#define IDS_POLICY_UNKNOWN 38442
#define IDS_POLICY_PROTO_PARSING_ERROR 38443
#define IDS_POLICY_HEX_COLOR_ERROR 38444
#define IDS_POLICY_SITE_SEARCH_SETTINGS_MAX_PROVIDERS_LIMIT_ERROR 38445
#define IDS_POLICY_SITE_SEARCH_SETTINGS_MAX_FEATURED_PROVIDERS_LIMIT_ERROR 38446
#define IDS_POLICY_SITE_SEARCH_SETTINGS_DUPLICATED_SHORTCUT 38447
#define IDS_POLICY_SITE_SEARCH_SETTINGS_SHORTCUT_CONTAINS_SPACE 38448
#define IDS_POLICY_SITE_SEARCH_SETTINGS_SHORTCUT_STARTS_WITH_AT 38449
#define IDS_POLICY_SITE_SEARCH_SETTINGS_NO_VALID_PROVIDER 38450
#define IDS_POLICY_SITE_SEARCH_SETTINGS_SHORTCUT_IS_EMPTY 38451
#define IDS_POLICY_SITE_SEARCH_SETTINGS_NAME_IS_EMPTY 38452
#define IDS_POLICY_SITE_SEARCH_SETTINGS_URL_IS_EMPTY 38453
#define IDS_POLICY_SITE_SEARCH_SETTINGS_URL_DOESNT_SUPPORT_REPLACEMENT 38454
#define IDS_POLICY_SITE_SEARCH_SETTINGS_SHORTCUT_EQUALS_DSP_KEYWORD 38455
#define IDS_POLICY_SITE_SEARCH_SETTINGS_URL_NOT_HTTPS 38456
#define IDS_POLICY_DATA_CONTROLS_MUTUALLY_EXCLUSIVE_KEYS 38457
#define IDS_POLICY_DATA_CONTROLS_MUTUALLY_EXCLUSIVE_KEY_SETS 38458
#define IDS_POLICY_DATA_CONTROLS_UNSUPPORTED_CONDITION 38459
#define IDS_POLICY_DATA_CONTROLS_UNSUPPORTED_RESTRICTION 38460
#define IDS_POLICY_DATA_CONTROLS_UNSUPPORTED_LEVEL 38461
#define IDS_POLICY_TITLE 38462
#define IDS_POLICY_FILTER_PLACEHOLDER 38463
#define IDS_POLICY_RELOAD_POLICIES 38464
#define IDS_POLICY_RELOADING_POLICIES 38465
#define IDS_POLICY_RELOAD_POLICIES_DONE 38466
#define IDS_EXPORT_POLICIES_JSON 38467
#define IDS_EXPORT_POLICIES_JSON_DONE 38468
#define IDS_UPLOAD_REPORT 38469
#define IDS_REPORT_UPLOADING 38470
#define IDS_REPORT_UPLOADED 38471
#define IDS_POLICY_STATUS 38472
#define IDS_POLICY_STATUS_DEVICE 38473
#define IDS_POLICY_STATUS_USER 38474
#define IDS_POLICY_STATUS_MACHINE 38475
#define IDS_POLICY_STATUS_ERROR_MANAGED_NO_POLICY 38477
#define IDS_POLICY_STATUS_FLEX_ORG_NO_POLICY 38478
#define IDS_POLICY_LABEL_MACHINE_ENROLLMENT_DOMAIN 38479
#define IDS_POLICY_LABEL_MACHINE_ENROLLMENT_TOKEN 38480
#define IDS_POLICY_LABEL_MACHINE_ENROLLMENT_DEVICE_ID 38481
#define IDS_POLICY_LABEL_MACHINE_ENROLLMENT_MACHINE_NAME 38482
#define IDS_POLICY_LABEL_USERNAME 38483
#define IDS_POLICY_LABEL_GAIA_ID 38484
#define IDS_POLICY_LABEL_CLIENT_ID 38485
#define IDS_POLICY_LABEL_PROFILE_ID 38486
#define IDS_POLICY_LABEL_ASSET_ID 38487
#define IDS_POLICY_LABEL_LOCATION 38488
#define IDS_POLICY_LABEL_DIRECTORY_API_ID 38489
#define IDS_POLICY_LABEL_MANAGED_BY 38490
#define IDS_POLICY_LABEL_TIME_SINCE_LAST_FETCH_ATTEMPT 38491
#define IDS_POLICY_LABEL_TIME_SINCE_LAST_REFRESH 38492
#define IDS_POLICY_LABEL_LAST_CLOUD_REPORT_SENT_TIMESTAMP 38493
#define IDS_POLICY_NOT_SPECIFIED 38494
#define IDS_POLICY_LABEL_PUSH_POLICIES 38495
#define IDS_POLICY_PUSH_POLICIES_ON 38496
#define IDS_POLICY_PUSH_POLICIES_OFF 38497
#define IDS_POLICY_NEVER_FETCHED 38498
#define IDS_POLICY_LABEL_REFRESH_INTERVAL 38499
#define IDS_POLICY_LABEL_CONFLICT 38500
#define IDS_POLICY_LABEL_SUPERSEDING 38501
#define IDS_POLICY_LABEL_CONFLICT_VALUE 38502
#define IDS_POLICY_LABEL_SUPERSEDED_VALUE 38503
#define IDS_POLICY_LABEL_ERROR 38504
#define IDS_POLICY_LABEL_DEPRECATED 38505
#define IDS_POLICY_LABEL_FUTURE 38506
#define IDS_POLICY_LABEL_IGNORED 38507
#define IDS_POLICY_LABEL_VALUE 38508
#define IDS_POLICY_LABEL_VERSION 38509
#define IDS_POLICY_LABEL_STATUS 38510
#define IDS_POLICY_LABEL_INFO 38511
#define IDS_POLICY_LABEL_PRECEDENCE 38512
#define IDS_POLICY_SHOW_UNSET 38513
#define IDS_POLICY_NO_POLICIES_SET 38514
#define IDS_POLICY_HEADER_SCOPE 38515
#define IDS_POLICY_HEADER_LEVEL 38516
#define IDS_POLICY_HEADER_NAMESPACE 38517
#define IDS_POLICY_HEADER_NAME 38518
#define IDS_POLICY_HEADER_VALUE 38519
#define IDS_POLICY_HEADER_STATUS 38520
#define IDS_POLICY_HEADER_SOURCE 38521
#define IDS_POLICY_HEADER_WARNING 38522
#define IDS_POLICY_SHOW_MORE 38523
#define IDS_POLICY_SHOW_LESS 38524
#define IDS_POLICY_LEARN_MORE 38525
#define IDS_POLICY_SCOPE_USER 38526
#define IDS_POLICY_SCOPE_ALL_USERS 38527
#define IDS_POLICY_SCOPE_DEVICE 38528
#define IDS_POLICY_LEVEL_RECOMMENDED 38529
#define IDS_POLICY_LEVEL_MANDATORY 38530
#define IDS_POLICY_SOURCE_ENTERPRISE_DEFAULT 38531
#define IDS_POLICY_SOURCE_DEFAULT 38532
#define IDS_POLICY_SOURCE_COMMAND_LINE 38533
#define IDS_POLICY_SOURCE_CLOUD 38534
#define IDS_POLICY_SOURCE_MERGED 38535
#define IDS_POLICY_SOURCE_CLOUD_FROM_ASH 38536
#define IDS_POLICY_SOURCE_RESTRICTED_MANAGED_GUEST_SESSION_OVERRIDE 38537
#define IDS_POLICY_SOURCE_ACTIVE_DIRECTORY 38538
#define IDS_POLICY_SOURCE_PLATFORM 38539
#define IDS_POLICY_SOURCE_DEVICE_LOCAL_ACCOUNT_OVERRIDE 38540
#define IDS_POLICY_RISK_TAG_FULL_ADMIN_ACCESS 38541
#define IDS_POLICY_RISK_TAG_SYSTEM_SECURITY 38542
#define IDS_POLICY_RISK_TAG_WEBSITE_SHARING 38543
#define IDS_POLICY_RISK_TAG_ADMIN_SHARING 38544
#define IDS_POLICY_RISK_TAG_FILTERING 38545
#define IDS_POLICY_RISK_TAG_LOCAL_DATA_ACCESS 38546
#define IDS_POLICY_RISK_TAG_GOOGLE_SHARING 38547
#define IDS_POLICY_SHOW_EXPANDED_STATUS 38548
#define IDS_POLICY_HIDE_EXPANDED_STATUS 38549
#define IDS_POLICY_LIST_MERGING_WRONG_POLICY_TYPE_SPECIFIED 38550
#define IDS_POLICY_DICTIONARY_MERGING_WRONG_POLICY_TYPE_SPECIFIED 38551
#define IDS_POLICY_DICTIONARY_MERGING_POLICY_NOT_ALLOWED 38552
#define IDS_POLICY_CONFLICT_SAME_VALUE 38553
#define IDS_POLICY_CONFLICT_DIFF_VALUE 38554
#define IDS_POLICY_MIGRATED_OLD_POLICY 38555
#define IDS_POLICY_MIGRATED_NEW_POLICY 38556
#define IDS_POLICY_BLOCKED 38557
#define IDS_POLICY_INVALID 38558
#define IDS_POLICY_IGNORED_BY_GROUP_MERGING 38559
#define IDS_POLICY_INVALID_VALUE 38560
#define IDS_POLICY_IGNORED_MANDATORY_REPORTING_POLICY 38561
#define IDS_POLICY_IGNORED_CHROME_PROFILE 38562
#define IDS_POLICY_IGNORED_UNAFFILIATED 38563
#define IDS_POLICY_PRECEDENCE_PLATFORM_MACHINE 38564
#define IDS_POLICY_PRECEDENCE_PLATFORM_USER 38565
#define IDS_POLICY_PRECEDENCE_CLOUD_MACHINE 38566
#define IDS_POLICY_PRECEDENCE_CLOUD_USER 38567
#define IDS_POLICY_SPELLCHECK_UNKNOWN_LANGUAGE 38568
#define IDS_POLICY_SPELLCHECK_BLOCKLIST_IGNORE 38569
#define IDS_POLICY_DEFAULT_GEO_POLICY_ARC_CONFLICT 38570
#define IDS_POLICY_LABEL_IS_AFFILIATED 38571
#define IDS_POLICY_IS_AFFILIATED_YES 38572
#define IDS_POLICY_IS_AFFILIATED_NO 38573
#define IDS_POLICY_LABEL_IS_OFFHOURS_ACTIVE 38574
#define IDS_POLICY_OFFHOURS_ACTIVE 38575
#define IDS_POLICY_OFFHOURS_NOT_ACTIVE 38576
#define IDS_POLICY_SIGNIN_PROFILE 38577
#define IDS_POLICY_COPY_VALUE 38578
#define IDS_COPY_POLICIES_JSON 38579
#define IDS_COPY_POLICIES_DONE 38580
#define IDS_VIEW_POLICY_LOGS 38581
#define IDS_POLICY_MORE_ACTIONS 38582
#define IDS_POLICY_TABLE_COLUMN_SORT 38583
#define IDS_POLICY_TABLE_COLUMN_SORT_ASCENDING 38584
#define IDS_POLICY_TABLE_COLUMN_SORT_DESCENDING 38585
#define IDS_POLICY_LOGS_TITLE 38586
#define IDS_VERSION_INFO 38587
#define IDS_EXPORT_POLICY_LOGS_JSON 38588
#define IDS_REFRESH_POLICY_LOGS 38589
#define IDS_POLICY_TEST_TITLE 38590
#define IDS_POLICY_TEST_RESTART_AND_APPLY 38591
#define IDS_POLICY_TEST_APPLY 38592
#define IDS_POLICY_TEST_IMPORT 38593
#define IDS_POLICY_TEST_DESC 38594
#define IDS_POLICY_TEST_REVERT 38595
#define IDS_POLICY_TEST_TABLE_SCOPE 38596
#define IDS_POLICY_TEST_ADD 38597
#define IDS_POLICY_SELECT_NAME 38598
#define IDS_POLICY_TEST_TABLE_PRESET 38599
#define IDS_LOCAL_TEST_POLICIES_ENABLED 38600
#define IDS_POLICY_TEST_PRESET_CUSTOM 38601
#define IDS_POLICY_TEST_PRESET_LOCAL_MACHINE 38602
#define IDS_POLICY_TEST_PRESET_CLOUD_ACCOUNT 38603
#define IDS_POLICY_TEST_USER_AFFILIATED 38604
#define IDS_CHROME_URLS_DISABLED_PAGE_HEADER 38605
#define IDS_CHROME_URLS_DISABLED_PAGE_TITLE 38606
#define IDS_CHROME_URLS_DISABLED_PAGE_MESSAGE 38607
#define IDS_POLICY_DLP_CLIPBOARD_BLOCKED_ON_PASTE 38608
#define IDS_POLICY_DLP_CLIPBOARD_BLOCKED_ON_COPY_VM 38609
#define IDS_POLICY_DLP_CLIPBOARD_BLOCK_TOAST_BUTTON 38610
#define IDS_POLICY_DLP_ANDROID_APPS 38611
#define IDS_POLICY_DLP_CLIPBOARD_BLOCK_DISMISS_BUTTON 38612
#define IDS_POLICY_DLP_CLIPBOARD_WARN_ON_PASTE 38613
#define IDS_POLICY_DLP_CLIPBOARD_WARN_PROCEED_BUTTON 38614
#define IDS_POLICY_DLP_CLIPBOARD_WARN_ON_COPY_VM 38615
#define IDS_POLICY_DLP_PRINTING_BLOCKED_TITLE 38616
#define IDS_POLICY_DLP_PRINTING_BLOCKED_MESSAGE 38617
#define IDS_POLICY_DLP_PRINTING_WARN_TITLE 38618
#define IDS_POLICY_DLP_PRINTING_WARN_MESSAGE 38619
#define IDS_POLICY_DLP_PRINTING_WARN_CONTINUE_BUTTON 38620
#define IDS_POLICY_DLP_SCREEN_SHARE_BLOCKED_TITLE 38621
#define IDS_POLICY_DLP_SCREEN_SHARE_BLOCKED_MESSAGE 38622
#define IDS_POLICY_DLP_SCREEN_SHARE_PAUSED_TITLE 38623
#define IDS_POLICY_DLP_SCREEN_SHARE_PAUSED_MESSAGE 38624
#define IDS_POLICY_DLP_SCREEN_SHARE_RESUMED_TITLE 38625
#define IDS_POLICY_DLP_SCREEN_SHARE_RESUMED_MESSAGE 38626
#define IDS_POLICY_DLP_SCREEN_CAPTURE_DISABLED_TITLE 38627
#define IDS_POLICY_DLP_SCREEN_CAPTURE_DISABLED_MESSAGE 38628
#define IDS_POLICY_DLP_VIDEO_CAPTURE_STOPPED_TITLE 38629
#define IDS_POLICY_DLP_VIDEO_CAPTURE_STOPPED_MESSAGE 38630
#define IDS_POLICY_DLP_SCREEN_SHARE_WARN_TITLE 38631
#define IDS_POLICY_DLP_SCREEN_SHARE_WARN_MESSAGE 38632
#define IDS_POLICY_DLP_SCREEN_SHARE_WARN_CONTINUE_BUTTON 38633
#define IDS_POLICY_DLP_SCREEN_CAPTURE_WARN_TITLE 38634
#define IDS_POLICY_DLP_SCREEN_CAPTURE_WARN_MESSAGE 38635
#define IDS_POLICY_DLP_SCREEN_CAPTURE_WARN_CONTINUE_BUTTON 38636
#define IDS_POLICY_DLP_VIDEO_CAPTURE_WARN_TITLE 38637
#define IDS_POLICY_DLP_VIDEO_CAPTURE_WARN_MESSAGE 38638
#define IDS_POLICY_DLP_VIDEO_CAPTURE_WARN_CONTINUE_BUTTON 38639
#define IDS_POLICY_DLP_VIDEO_CAPTURE_WARN_CANCEL_BUTTON 38640
#define IDS_POLICY_DLP_FILES_DOWNLOAD_WARN_TITLE 38641
#define IDS_POLICY_DLP_FILES_TRANSFER_WARN_TITLE 38642
#define IDS_POLICY_DLP_FILES_UPLOAD_WARN_TITLE 38643
#define IDS_POLICY_DLP_FILES_MOVE_WARN_TITLE 38644
#define IDS_POLICY_DLP_FILES_COPY_WARN_TITLE 38645
#define IDS_POLICY_DLP_FILES_OPEN_WARN_TITLE 38646
#define IDS_POLICY_DLP_FILES_DOWNLOAD_REVIEW_TITLE 38647
#define IDS_POLICY_DLP_FILES_TRANSFER_REVIEW_TITLE 38648
#define IDS_POLICY_DLP_FILES_UPLOAD_REVIEW_TITLE 38649
#define IDS_POLICY_DLP_FILES_MOVE_REVIEW_TITLE 38650
#define IDS_POLICY_DLP_FILES_COPY_REVIEW_TITLE 38651
#define IDS_POLICY_DLP_FILES_OPEN_REVIEW_TITLE 38652
#define IDS_POLICY_DLP_FILES_DOWNLOAD_WARN_MESSAGE 38653
#define IDS_POLICY_DLP_FILES_TRANSFER_WARN_MESSAGE 38654
#define IDS_POLICY_DLP_FILES_UPLOAD_WARN_MESSAGE 38655
#define IDS_POLICY_DLP_FILES_MOVE_WARN_MESSAGE 38656
#define IDS_POLICY_DLP_FILES_COPY_WARN_MESSAGE 38657
#define IDS_POLICY_DLP_FILES_OPEN_WARN_MESSAGE 38658
#define IDS_POLICY_DLP_FILES_WARN_MESSAGE 38659
#define IDS_POLICY_DLP_FILES_DOWNLOAD_WARN_CONTINUE_BUTTON 38660
#define IDS_POLICY_DLP_FILES_TRANSFER_WARN_CONTINUE_BUTTON 38661
#define IDS_POLICY_DLP_FILES_UPLOAD_WARN_CONTINUE_BUTTON 38662
#define IDS_POLICY_DLP_FILES_MOVE_WARN_CONTINUE_BUTTON 38663
#define IDS_POLICY_DLP_FILES_COPY_WARN_CONTINUE_BUTTON 38664
#define IDS_POLICY_DLP_FILES_OPEN_WARN_CONTINUE_BUTTON 38665
#define IDS_POLICY_DLP_FILES_DESTINATION_REMOVABLE_STORAGE 38666
#define IDS_POLICY_DLP_FILES_REVIEW_BUTTON 38667
#define IDS_POLICY_DLP_FILES_DISMISS_BUTTON 38668
#define IDS_POLICY_DLP_FILES_OK_BUTTON 38669
#define IDS_POLICY_DLP_WARN_CANCEL_BUTTON 38670
#define IDS_POLICY_DLP_CLIPBOARD_BUBBLE_MESSAGE 38671
#define IDS_POLICY_DLP_FROM_YOUR_ADMIN_MESSAGE 38672
#define IDS_POLICY_DLP_FILES_DOWNLOAD_BLOCK_TITLE 38673
#define IDS_POLICY_DLP_FILES_DOWNLOAD_BLOCK_MESSAGE 38674
#define IDS_POLICY_DLP_FILES_UPLOAD_BLOCK_TITLE 38675
#define IDS_POLICY_DLP_FILES_UPLOAD_BLOCK_MESSAGE 38676
#define IDS_POLICY_DLP_FILES_OPEN_BLOCK_TITLE 38677
#define IDS_POLICY_DLP_FILES_OPEN_BLOCK_MESSAGE 38678
#define IDS_POLICY_DLP_FILES_DOWNLOAD_BLOCKED_TITLE 38679
#define IDS_POLICY_DLP_FILES_TRANSFER_BLOCKED_TITLE 38680
#define IDS_POLICY_DLP_FILES_UPLOAD_BLOCKED_TITLE 38681
#define IDS_POLICY_DLP_FILES_MOVE_BLOCKED_TITLE 38682
#define IDS_POLICY_DLP_FILES_COPY_BLOCKED_TITLE 38683
#define IDS_POLICY_DLP_FILES_OPEN_BLOCKED_TITLE 38684
#define IDS_POLICY_DLP_FILES_POLICY_BLOCK_SINGLE_FILE_MESSAGE 38685
#define IDS_POLICY_DLP_FILES_POLICY_BLOCK_MESSAGE 38686
#define IDS_POLICY_DLP_FILES_CONTENT_BLOCK_SINGLE_FILE_MESSAGE 38687
#define IDS_POLICY_DLP_FILES_CONTENT_BLOCK_MESSAGE 38688
#define IDS_POLICY_DLP_FILES_BLOCK_MESSAGE 38689
#define IDS_POLICY_DLP_FILES_DOWNLOAD_JUSTIFICATION_LABEL 38690
#define IDS_POLICY_DLP_FILES_UPLOAD_JUSTIFICATION_LABEL 38691
#define IDS_POLICY_DLP_FILES_COPY_JUSTIFICATION_LABEL 38692
#define IDS_POLICY_DLP_FILES_MOVE_JUSTIFICATION_LABEL 38693
#define IDS_POLICY_DLP_FILES_OPEN_JUSTIFICATION_LABEL 38694
#define IDS_POLICY_DLP_FILES_TRANSFER_JUSTIFICATION_LABEL 38695
#define IDS_POLICY_DLP_FILES_DOWNLOAD_TIMEOUT_TITLE 38696
#define IDS_POLICY_DLP_FILES_TRANSFER_TIMEOUT_TITLE 38697
#define IDS_POLICY_DLP_FILES_UPLOAD_TIMEOUT_TITLE 38698
#define IDS_POLICY_DLP_FILES_MOVE_TIMEOUT_TITLE 38699
#define IDS_POLICY_DLP_FILES_COPY_TIMEOUT_TITLE 38700
#define IDS_POLICY_DLP_FILES_OPEN_TIMEOUT_TITLE 38701
#define IDS_POLICY_DLP_FILES_DOWNLOAD_TIMEOUT_MESSAGE 38702
#define IDS_POLICY_DLP_FILES_TRANSFER_TIMEOUT_MESSAGE 38703
#define IDS_POLICY_DLP_FILES_UPLOAD_TIMEOUT_MESSAGE 38704
#define IDS_POLICY_DLP_FILES_MOVE_TIMEOUT_MESSAGE 38705
#define IDS_POLICY_DLP_FILES_COPY_TIMEOUT_MESSAGE 38706
#define IDS_POLICY_DLP_FILES_OPEN_TIMEOUT_MESSAGE 38707
#define IDS_POLICY_DLP_FILES_LEARN_MORE_ABOUT_DATA_CONTROLS_ACCESSIBLE_NAME 38708
#define IDS_POLICY_DLP_FILES_LEARN_MORE_ABOUT_MALWARE_PROTECTION_ACCESSIBLE_NAME 38709
#define IDS_POLICY_DLP_FILES_LEARN_MORE_ABOUT_SENSITIVE_DATA_PROTECTION_ACCESSIBLE_NAME 38710
#define IDS_POLICY_DLP_FILES_JUSTIFICATION_TEXTAREA_ACCESSIBLE_DESCRIPTION 38711
#define IDS_POLICY_DEVICE_SCHEDULED_REBOOT_TITLE 38712
#define IDS_POLICY_DEVICE_SCHEDULED_REBOOT_MESSAGE 38713
#define IDS_POLICY_REBOOT_BUTTON 38714
#define IDS_POLICY_DEVICE_SCHEDULED_REBOOT_DIALOG_MESSAGE 38715
#define IDS_REBOOT_SCHEDULED_TITLE_MINUTES 38716
#define IDS_REBOOT_SCHEDULED_TITLE_SECONDS 38717
#define IDS_POLICY_DEVICE_POST_REBOOT_TITLE 38718
#define IDS_POLICY_BROWSING_DATA_DEPENDENCY_APPLIED_INFO 38719
#define IDS_POLICY_NOT_SUPPORTED_AS_USER_POLICY_ON_IOS 38720
#define PRINT_PREVIEW_MEDIA_ASME_F_28X40IN 38721
#define PRINT_PREVIEW_MEDIA_ISO_2A0_1189X1682MM 38722
#define PRINT_PREVIEW_MEDIA_ISO_A0_841X1189MM 38723
#define PRINT_PREVIEW_MEDIA_ISO_A0X3_1189X2523MM 38724
#define PRINT_PREVIEW_MEDIA_ISO_A10_26X37MM 38725
#define PRINT_PREVIEW_MEDIA_ISO_A1_594X841MM 38726
#define PRINT_PREVIEW_MEDIA_ISO_A1X3_841X1783MM 38727
#define PRINT_PREVIEW_MEDIA_ISO_A1X4_841X2378MM 38728
#define PRINT_PREVIEW_MEDIA_ISO_A2_420X594MM 38729
#define PRINT_PREVIEW_MEDIA_ISO_A2X3_594X1261MM 38730
#define PRINT_PREVIEW_MEDIA_ISO_A2X4_594X1682MM 38731
#define PRINT_PREVIEW_MEDIA_ISO_A2X5_594X2102MM 38732
#define PRINT_PREVIEW_MEDIA_ISO_A3_297X420MM 38733
#define PRINT_PREVIEW_MEDIA_ISO_A3_EXTRA_322X445MM 38734
#define PRINT_PREVIEW_MEDIA_ISO_A3X3_420X891MM 38735
#define PRINT_PREVIEW_MEDIA_ISO_A3X4_420X1189MM 38736
#define PRINT_PREVIEW_MEDIA_ISO_A3X5_420X1486MM 38737
#define PRINT_PREVIEW_MEDIA_ISO_A3X6_420X1783MM 38738
#define PRINT_PREVIEW_MEDIA_ISO_A3X7_420X2080MM 38739
#define PRINT_PREVIEW_MEDIA_ISO_A4_210X297MM 38740
#define PRINT_PREVIEW_MEDIA_ISO_A4_EXTRA_235_5X322_3MM 38741
#define PRINT_PREVIEW_MEDIA_ISO_A4_TAB_225X297MM 38742
#define PRINT_PREVIEW_MEDIA_ISO_A4X3_297X630MM 38743
#define PRINT_PREVIEW_MEDIA_ISO_A4X4_297X841MM 38744
#define PRINT_PREVIEW_MEDIA_ISO_A4X5_297X1051MM 38745
#define PRINT_PREVIEW_MEDIA_ISO_A4X6_297X1261MM 38746
#define PRINT_PREVIEW_MEDIA_ISO_A4X7_297X1471MM 38747
#define PRINT_PREVIEW_MEDIA_ISO_A4X8_297X1682MM 38748
#define PRINT_PREVIEW_MEDIA_ISO_A4X9_297X1892MM 38749
#define PRINT_PREVIEW_MEDIA_ISO_A5_148X210MM 38750
#define PRINT_PREVIEW_MEDIA_ISO_A5_EXTRA_174X235MM 38751
#define PRINT_PREVIEW_MEDIA_ISO_A6_105X148MM 38752
#define PRINT_PREVIEW_MEDIA_ISO_A7_74X105MM 38753
#define PRINT_PREVIEW_MEDIA_ISO_A8_52X74MM 38754
#define PRINT_PREVIEW_MEDIA_ISO_A9_37X52MM 38755
#define PRINT_PREVIEW_MEDIA_ISO_B0_1000X1414MM 38756
#define PRINT_PREVIEW_MEDIA_ISO_B10_31X44MM 38757
#define PRINT_PREVIEW_MEDIA_ISO_B1_707X1000MM 38758
#define PRINT_PREVIEW_MEDIA_ISO_B2_500X707MM 38759
#define PRINT_PREVIEW_MEDIA_ISO_B3_353X500MM 38760
#define PRINT_PREVIEW_MEDIA_ISO_B4_250X353MM 38761
#define PRINT_PREVIEW_MEDIA_ISO_B5_176X250MM 38762
#define PRINT_PREVIEW_MEDIA_ISO_B5_EXTRA_201X276MM 38763
#define PRINT_PREVIEW_MEDIA_ISO_B6C4_125X324MM 38764
#define PRINT_PREVIEW_MEDIA_ISO_B6_125X176MM 38765
#define PRINT_PREVIEW_MEDIA_ISO_B7_88X125MM 38766
#define PRINT_PREVIEW_MEDIA_ISO_B8_62X88MM 38767
#define PRINT_PREVIEW_MEDIA_ISO_B9_44X62MM 38768
#define PRINT_PREVIEW_MEDIA_ISO_C0_917X1297MM 38769
#define PRINT_PREVIEW_MEDIA_ISO_C10_28X40MM 38770
#define PRINT_PREVIEW_MEDIA_ISO_C1_648X917MM 38771
#define PRINT_PREVIEW_MEDIA_ISO_C2_458X648MM 38772
#define PRINT_PREVIEW_MEDIA_ISO_C3_324X458MM 38773
#define PRINT_PREVIEW_MEDIA_ISO_C4_229X324MM 38774
#define PRINT_PREVIEW_MEDIA_ISO_C5_162X229MM 38775
#define PRINT_PREVIEW_MEDIA_ISO_C6C5_114X229MM 38776
#define PRINT_PREVIEW_MEDIA_ISO_C6_114X162MM 38777
#define PRINT_PREVIEW_MEDIA_ISO_C7C6_81X162MM 38778
#define PRINT_PREVIEW_MEDIA_ISO_C7_81X114MM 38779
#define PRINT_PREVIEW_MEDIA_ISO_C8_57X81MM 38780
#define PRINT_PREVIEW_MEDIA_ISO_C9_40X57MM 38781
#define PRINT_PREVIEW_MEDIA_ISO_DL_110X220MM 38782
#define PRINT_PREVIEW_MEDIA_ISO_ID_1_53_98X85_6MM 38783
#define PRINT_PREVIEW_MEDIA_ISO_RA0_860X1220MM 38784
#define PRINT_PREVIEW_MEDIA_ISO_RA1_610X860MM 38785
#define PRINT_PREVIEW_MEDIA_ISO_RA2_430X610MM 38786
#define PRINT_PREVIEW_MEDIA_ISO_RA3_305X430MM 38787
#define PRINT_PREVIEW_MEDIA_ISO_RA4_215X305MM 38788
#define PRINT_PREVIEW_MEDIA_ISO_SRA0_900X1280MM 38789
#define PRINT_PREVIEW_MEDIA_ISO_SRA1_640X900MM 38790
#define PRINT_PREVIEW_MEDIA_ISO_SRA2_450X640MM 38791
#define PRINT_PREVIEW_MEDIA_ISO_SRA3_320X450MM 38792
#define PRINT_PREVIEW_MEDIA_ISO_SRA4_225X320MM 38793
#define PRINT_PREVIEW_MEDIA_JIS_B0_1030X1456MM 38794
#define PRINT_PREVIEW_MEDIA_JIS_B1_728X1030MM 38795
#define PRINT_PREVIEW_MEDIA_JIS_B2_515X728MM 38796
#define PRINT_PREVIEW_MEDIA_JIS_B3_364X515MM 38797
#define PRINT_PREVIEW_MEDIA_JIS_B4_257X364MM 38798
#define PRINT_PREVIEW_MEDIA_JIS_B5_182X257MM 38799
#define PRINT_PREVIEW_MEDIA_JIS_B6_128X182MM 38800
#define PRINT_PREVIEW_MEDIA_JIS_B7_91X128MM 38801
#define PRINT_PREVIEW_MEDIA_JIS_B8_64X91MM 38802
#define PRINT_PREVIEW_MEDIA_JIS_B9_45X64MM 38803
#define PRINT_PREVIEW_MEDIA_JIS_B10_32X45MM 38804
#define PRINT_PREVIEW_MEDIA_JIS_EXEC_216X330MM 38805
#define PRINT_PREVIEW_MEDIA_JPN_CHOU2_111_1X146MM 38806
#define PRINT_PREVIEW_MEDIA_JPN_CHOU3_120X235MM 38807
#define PRINT_PREVIEW_MEDIA_JPN_CHOU4_90X205MM 38808
#define PRINT_PREVIEW_MEDIA_JPN_CHOU40_90X225MM 38809
#define PRINT_PREVIEW_MEDIA_JPN_HAGAKI_100X148MM 38810
#define PRINT_PREVIEW_MEDIA_JPN_KAHU_240X322_1MM 38811
#define PRINT_PREVIEW_MEDIA_JPN_KAKU1_270X382MM 38812
#define PRINT_PREVIEW_MEDIA_JPN_KAKU2_240X332MM 38813
#define PRINT_PREVIEW_MEDIA_JPN_KAKU3_216X277MM 38814
#define PRINT_PREVIEW_MEDIA_JPN_KAKU4_197X267MM 38815
#define PRINT_PREVIEW_MEDIA_JPN_KAKU5_190X240MM 38816
#define PRINT_PREVIEW_MEDIA_JPN_KAKU7_142X205MM 38817
#define PRINT_PREVIEW_MEDIA_JPN_KAKU8_119X197MM 38818
#define PRINT_PREVIEW_MEDIA_JPN_OUFUKU_148X200MM 38819
#define PRINT_PREVIEW_MEDIA_JPN_YOU4_105X235MM 38820
#define PRINT_PREVIEW_MEDIA_JPN_YOU6_98X190MM 38821
#define PRINT_PREVIEW_MEDIA_NA_10X11_10X11IN 38822
#define PRINT_PREVIEW_MEDIA_NA_10X13_10X13IN 38823
#define PRINT_PREVIEW_MEDIA_NA_10X14_10X14IN 38824
#define PRINT_PREVIEW_MEDIA_NA_10X15_10X15IN 38825
#define PRINT_PREVIEW_MEDIA_NA_11X12_11X12IN 38826
#define PRINT_PREVIEW_MEDIA_NA_11X15_11X15IN 38827
#define PRINT_PREVIEW_MEDIA_NA_12X19_12X19IN 38828
#define PRINT_PREVIEW_MEDIA_NA_5X7_5X7IN 38829
#define PRINT_PREVIEW_MEDIA_NA_6X9_6X9IN 38830
#define PRINT_PREVIEW_MEDIA_NA_7X9_7X9IN 38831
#define PRINT_PREVIEW_MEDIA_NA_9X11_9X11IN 38832
#define PRINT_PREVIEW_MEDIA_NA_A2_4_375X5_75IN 38833
#define PRINT_PREVIEW_MEDIA_NA_ARCH_A_9X12IN 38834
#define PRINT_PREVIEW_MEDIA_NA_ARCH_B_12X18IN 38835
#define PRINT_PREVIEW_MEDIA_NA_ARCH_C_18X24IN 38836
#define PRINT_PREVIEW_MEDIA_NA_ARCH_D_24X36IN 38837
#define PRINT_PREVIEW_MEDIA_NA_ARCH_E_36X48IN 38838
#define PRINT_PREVIEW_MEDIA_NA_ARCH_E2_26X38IN 38839
#define PRINT_PREVIEW_MEDIA_NA_ARCH_E3_27X39IN 38840
#define PRINT_PREVIEW_MEDIA_NA_B_PLUS_12X19_17IN 38841
#define PRINT_PREVIEW_MEDIA_NA_C5_6_5X9_5IN 38842
#define PRINT_PREVIEW_MEDIA_NA_C_17X22IN 38843
#define PRINT_PREVIEW_MEDIA_NA_D_22X34IN 38844
#define PRINT_PREVIEW_MEDIA_NA_EDP_11X14IN 38845
#define PRINT_PREVIEW_MEDIA_NA_EUR_EDP_12X14IN 38846
#define PRINT_PREVIEW_MEDIA_NA_E_34X44IN 38847
#define PRINT_PREVIEW_MEDIA_NA_EXECUTIVE_7_25X10_5IN 38848
#define PRINT_PREVIEW_MEDIA_NA_FANFOLD_EUR_8_5X12IN 38849
#define PRINT_PREVIEW_MEDIA_NA_FANFOLD_US_11X14_875IN 38850
#define PRINT_PREVIEW_MEDIA_NA_FOOLSCAP_8_5X13IN 38851
#define PRINT_PREVIEW_MEDIA_NA_F_44X68IN 38852
#define PRINT_PREVIEW_MEDIA_NA_GOVT_LEGAL_8X13IN 38853
#define PRINT_PREVIEW_MEDIA_NA_GOVT_LETTER_8X10IN 38854
#define PRINT_PREVIEW_MEDIA_NA_INDEX_3X5_3X5IN 38855
#define PRINT_PREVIEW_MEDIA_NA_INDEX_4X6_4X6IN 38856
#define PRINT_PREVIEW_MEDIA_NA_INDEX_4X6_EXT_6X8IN 38857
#define PRINT_PREVIEW_MEDIA_NA_INDEX_5X8_5X8IN 38858
#define PRINT_PREVIEW_MEDIA_NA_INVOICE_5_5X8_5IN 38859
#define PRINT_PREVIEW_MEDIA_NA_LEDGER_11X17IN 38860
#define PRINT_PREVIEW_MEDIA_NA_LEGAL_8_5X14IN 38861
#define PRINT_PREVIEW_MEDIA_NA_LEGAL_EXTRA_9_5X15IN 38862
#define PRINT_PREVIEW_MEDIA_NA_LETTER_8_5X11IN 38863
#define PRINT_PREVIEW_MEDIA_NA_LETTER_EXTRA_9_5X12IN 38864
#define PRINT_PREVIEW_MEDIA_NA_LETTER_PLUS_8_5X12_69IN 38865
#define PRINT_PREVIEW_MEDIA_NA_MONARCH_3_875X7_5IN 38866
#define PRINT_PREVIEW_MEDIA_NA_NUMBER_9_3_875X8_875IN 38867
#define PRINT_PREVIEW_MEDIA_NA_NUMBER_10_4_125X9_5IN 38868
#define PRINT_PREVIEW_MEDIA_NA_NUMBER_11_4_5X10_375IN 38869
#define PRINT_PREVIEW_MEDIA_NA_NUMBER_12_4_75X11IN 38870
#define PRINT_PREVIEW_MEDIA_NA_NUMBER_14_5X11_5IN 38871
#define PRINT_PREVIEW_MEDIA_NA_OFICIO_8_5X13_4IN 38872
#define PRINT_PREVIEW_MEDIA_NA_PERSONAL_3_625X6_5IN 38873
#define PRINT_PREVIEW_MEDIA_NA_QUARTO_8_5X10_83IN 38874
#define PRINT_PREVIEW_MEDIA_NA_SUPER_A_8_94X14IN 38875
#define PRINT_PREVIEW_MEDIA_NA_SUPER_B_13X19IN 38876
#define PRINT_PREVIEW_MEDIA_NA_WIDE_FORMAT_30X42IN 38877
#define PRINT_PREVIEW_MEDIA_OE_12X16_12X16IN 38878
#define PRINT_PREVIEW_MEDIA_OE_14X17_14X17IN 38879
#define PRINT_PREVIEW_MEDIA_OE_18X22_18X22IN 38880
#define PRINT_PREVIEW_MEDIA_OE_A2PLUS_17X24IN 38881
#define PRINT_PREVIEW_MEDIA_OE_BUSINESS_CARD_2X3_5IN 38882
#define PRINT_PREVIEW_MEDIA_OE_PHOTO_10R_10X12IN 38883
#define PRINT_PREVIEW_MEDIA_OE_PHOTO_12R_12X15IN 38884
#define PRINT_PREVIEW_MEDIA_OE_PHOTO_14X18_14X18IN 38885
#define PRINT_PREVIEW_MEDIA_OE_PHOTO_16R_16X20IN 38886
#define PRINT_PREVIEW_MEDIA_OE_PHOTO_20R_20X24IN 38887
#define PRINT_PREVIEW_MEDIA_OE_PHOTO_22R_22X29_5IN 38888
#define PRINT_PREVIEW_MEDIA_OE_PHOTO_22X28_22X28IN 38889
#define PRINT_PREVIEW_MEDIA_OE_PHOTO_24R_24X31_5IN 38890
#define PRINT_PREVIEW_MEDIA_OE_PHOTO_24X30_24X30IN 38891
#define PRINT_PREVIEW_MEDIA_OE_PHOTO_30R_30X40IN 38892
#define PRINT_PREVIEW_MEDIA_OE_PHOTO_L_3_5X5IN 38893
#define PRINT_PREVIEW_MEDIA_OE_PHOTO_S8R_8X12IN 38894
#define PRINT_PREVIEW_MEDIA_OE_SQUARE_PHOTO_4X4IN 38895
#define PRINT_PREVIEW_MEDIA_OE_SQUARE_PHOTO_5X5IN 38896
#define PRINT_PREVIEW_MEDIA_OM_16K_184X260MM 38897
#define PRINT_PREVIEW_MEDIA_OM_16K_195X270MM 38898
#define PRINT_PREVIEW_MEDIA_OM_BUSINESS_CARD_55X85MM 38899
#define PRINT_PREVIEW_MEDIA_OM_BUSINESS_CARD_55X91MM 38900
#define PRINT_PREVIEW_MEDIA_OM_CARD_54X86MM 38901
#define PRINT_PREVIEW_MEDIA_OM_DAI_PA_KAI_275X395MM 38902
#define PRINT_PREVIEW_MEDIA_OM_DSC_PHOTO_89X119MM 38903
#define PRINT_PREVIEW_MEDIA_OM_FOLIO_210X330MM 38904
#define PRINT_PREVIEW_MEDIA_OM_FOLIO_SP_215X315MM 38905
#define PRINT_PREVIEW_MEDIA_OM_INVITE_220X220MM 38906
#define PRINT_PREVIEW_MEDIA_OM_ITALIAN_110X230MM 38907
#define PRINT_PREVIEW_MEDIA_OM_JUURO_KU_KAI_198X275MM 38908
#define PRINT_PREVIEW_MEDIA_OM_LARGE_PHOTO_200X300 38909
#define PRINT_PREVIEW_MEDIA_OM_MEDIUM_PHOTO_130X180MM 38910
#define PRINT_PREVIEW_MEDIA_OM_PA_KAI_267X389MM 38911
#define PRINT_PREVIEW_MEDIA_OM_PHOTO_30X40_300X400MM 38912
#define PRINT_PREVIEW_MEDIA_OM_PHOTO_30X45_300X450MM 38913
#define PRINT_PREVIEW_MEDIA_OM_PHOTO_35X46_350X460MM 38914
#define PRINT_PREVIEW_MEDIA_OM_PHOTO_40X60_400X600MM 38915
#define PRINT_PREVIEW_MEDIA_OM_PHOTO_50X75_500X750MM 38916
#define PRINT_PREVIEW_MEDIA_OM_PHOTO_50X76_500X760MM 38917
#define PRINT_PREVIEW_MEDIA_OM_PHOTO_60X90_600X900MM 38918
#define PRINT_PREVIEW_MEDIA_OM_SQUARE_PHOTO_89X89MM 38919
#define PRINT_PREVIEW_MEDIA_OM_WIDE_PHOTO_100X200MM 38920
#define PRINT_PREVIEW_MEDIA_OM_SMALL_PHOTO_100X150MM 38921
#define PRINT_PREVIEW_MEDIA_PRC_16K_146X215MM 38922
#define PRINT_PREVIEW_MEDIA_PRC_1_102X165MM 38923
#define PRINT_PREVIEW_MEDIA_PRC_2_102X176MM 38924
#define PRINT_PREVIEW_MEDIA_PRC_32K_97X151MM 38925
#define PRINT_PREVIEW_MEDIA_PRC_4_110X208MM 38926
#define PRINT_PREVIEW_MEDIA_PRC_6_120X320MM 38927
#define PRINT_PREVIEW_MEDIA_PRC_7_160X230MM 38928
#define PRINT_PREVIEW_MEDIA_PRC_8_120X309MM 38929
#define PRINT_PREVIEW_MEDIA_ROC_16K_7_75X10_75IN 38930
#define PRINT_PREVIEW_MEDIA_ROC_8K_10_75X15_5IN 38931
#define PRINT_PREVIEW_MEDIA_DIMENSIONS_INCHES 38932
#define PRINT_PREVIEW_MEDIA_DIMENSIONS_MM 38933
#define PRINT_PREVIEW_MEDIA_NAME_WITH_DIMENSIONS_INCHES 38934
#define PRINT_PREVIEW_MEDIA_NAME_WITH_DIMENSIONS_MM 38935
#define IDS_PRINT_COMPOSITOR_SERVICE_DISPLAY_NAME 38937
#define IDS_PRIVACY_SANDBOX_M1_CONSENT_TITLE 39339
#define IDS_PRIVACY_SANDBOX_M1_CONSENT_DESCRIPTION_1 39340
#define IDS_PRIVACY_SANDBOX_M1_CONSENT_DESCRIPTION_2 39341
#define IDS_PRIVACY_SANDBOX_M1_CONSENT_DESCRIPTION_3 39342
#define IDS_PRIVACY_SANDBOX_M1_CONSENT_LEARN_MORE_EXPAND_LABEL 39343
#define IDS_PRIVACY_SANDBOX_M1_CONSENT_DESCRIPTION_4 39344
#define IDS_PRIVACY_SANDBOX_M1_CONSENT_DECLINE_BUTTON 39345
#define IDS_PRIVACY_SANDBOX_M1_CONSENT_ACCEPT_BUTTON 39346
#define IDS_PRIVACY_SANDBOX_M1_CONSENT_SAVING_LABEL 39347
#define IDS_PRIVACY_SANDBOX_M1_CONSENT_LEARN_MORE_BULLET_1 39348
#define IDS_PRIVACY_SANDBOX_M1_CONSENT_LEARN_MORE_BULLET_2 39349
#define IDS_PRIVACY_SANDBOX_M1_CONSENT_LEARN_MORE_BULLET_3 39350
#define IDS_PRIVACY_SANDBOX_M1_CONSENT_LEARN_MORE_LINK 39351
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_EEA_TITLE 39352
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_EEA_DESCRIPTION_1 39353
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_EEA_BULLET_1 39354
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_EEA_BULLET_2 39355
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_EEA_LEARN_MORE_EXPAND_LABEL 39356
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_EEA_DESCRIPTION_2 39357
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_EEA_ACK_BUTTON 39358
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_EEA_SETTINGS_BUTTON 39359
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_EEA_LEARN_MORE_HEADING_1 39360
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_EEA_LEARN_MORE_BULLET_1 39361
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_EEA_LEARN_MORE_BULLET_2 39362
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_EEA_LEARN_MORE_BULLET_3 39363
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_EEA_LEARN_MORE_HEADING_2 39364
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_EEA_LEARN_MORE_DESCRIPTION 39365
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_RESTRICTED_TITLE 39366
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_RESTRICTED_DESCRIPTION_1 39367
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_RESTRICTED_DESCRIPTION_2 39368
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_RESTRICTED_DESCRIPTION_3 39369
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_RESTRICTED_ACK_BUTTON 39370
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_RESTRICTED_SETTINGS_BUTTON 39371
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_ROW_TITLE 39372
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_ROW_DESCRIPTION_1 39373
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_ROW_DESCRIPTION_2 39374
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_ROW_DESCRIPTION_3 39375
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_ROW_LEARN_MORE_EXPAND_LABEL 39376
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_ROW_DESCRIPTION_4 39377
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_ROW_ACK_BUTTON 39378
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_ROW_SETTINGS_BUTTON 39379
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_ROW_LEARN_MORE_HEADING_1 39380
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_ROW_LEARN_MORE_DESCRIPTION_1 39381
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_ROW_LEARN_MORE_BULLET_1 39382
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_ROW_LEARN_MORE_BULLET_2 39383
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_ROW_LEARN_MORE_DESCRIPTION_2 39384
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_ROW_LEARN_MORE_DESCRIPTION_3 39385
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_ROW_LEARN_MORE_HEADING_2 39386
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_ROW_LEARN_MORE_DESCRIPTION_4 39387
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_ROW_LEARN_MORE_DESCRIPTION_5 39388
#define IDS_PRIVACY_SANDBOX_M1_DIALOG_MORE_BUTTON 39389
#define IDS_SETTINGS_TOPICS_PAGE_TITLE 39390
#define IDS_SETTINGS_TOPICS_PAGE_TOGGLE_LABEL 39391
#define IDS_SETTINGS_TOPICS_PAGE_TOGGLE_SUB_LABEL 39392
#define IDS_SETTINGS_TOPICS_PAGE_TOGGLE_SUB_LABEL_V2 39393
#define IDS_SETTINGS_TOPICS_PAGE_DISCLAIMER_DESKTOP 39394
#define IDS_SETTINGS_TOPICS_PAGE_CURRENT_TOPICS_HEADING 39395
#define IDS_SETTINGS_TOPICS_PAGE_CURRENT_TOPICS_DESCRIPTION_CANONICAL 39396
#define IDS_SETTINGS_TOPICS_PAGE_CURRENT_TOPICS_DESCRIPTION_DISABLED 39397
#define IDS_SETTINGS_TOPICS_PAGE_CURRENT_TOPICS_DESCRIPTION_EMPTY 39398
#define IDS_SETTINGS_TOPICS_PAGE_CURRENT_TOPICS_DESCRIPTION_EMPTY_TEXT_V2 39399
#define IDS_SETTINGS_TOPICS_PAGE_CURRENT_TOPICS_DESCRIPTION_EMPTY_TEXT_HEADING 39400
#define IDS_SETTINGS_TOPICS_PAGE_BLOCKED_TOPICS_DESCRIPTION_EMPTY_TEXT_V2 39401
#define IDS_SETTINGS_TOPICS_PAGE_BLOCKED_TOPICS_DESCRIPTION_EMPTY_TEXT_HEADING 39402
#define IDS_SETTINGS_TOPICS_PAGE_BLOCK_TOPIC 39403
#define IDS_SETTINGS_TOPICS_PAGE_BLOCK_TOPIC_A11Y_LABEL 39404
#define IDS_SETTINGS_TOPICS_PAGE_BLOCKED_TOPICS_HEADING 39405
#define IDS_SETTINGS_TOPICS_PAGE_BLOCKED_TOPICS_DESCRIPTION 39406
#define IDS_SETTINGS_TOPICS_PAGE_BLOCKED_TOPICS_DESCRIPTION_EMPTY 39407
#define IDS_SETTINGS_TOPICS_PAGE_ALLOW_TOPIC 39408
#define IDS_SETTINGS_TOPICS_PAGE_ALLOW_TOPIC_A11Y_LABEL 39409
#define IDS_SETTINGS_TOPICS_PAGE_UNBLOCK_TOPIC_A11Y_LABEL 39410
#define IDS_SETTINGS_TOPICS_PAGE_LEARN_MORE_HEADING 39411
#define IDS_SETTINGS_TOPICS_PAGE_LEARN_MORE_BULLET_1 39412
#define IDS_SETTINGS_TOPICS_PAGE_LEARN_MORE_BULLET_2 39413
#define IDS_SETTINGS_TOPICS_PAGE_LEARN_MORE_BULLET_3_CANONICAL 39414
#define IDS_SETTINGS_TOPICS_PAGE_FOOTER_CANONICAL 39415
#define IDS_SETTINGS_TOPICS_PAGE_FIRST_LEVEL_TOPIC_DESCRIPTOR 39416
#define IDS_SETTINGS_MANAGE_TOPICS_DIALOG_TITLE 39417
#define IDS_SETTINGS_MANAGE_TOPICS_DIALOG_BODY 39418
#define IDS_SETTINGS_MANAGE_TOPICS_DIALOG_CLANK_TITLE 39419
#define IDS_SETTINGS_MANAGE_TOPICS_DIALOG_CLANK_BODY 39420
#define IDS_SETTINGS_MANAGE_TOPICS_PAGE_DESCRIPTION 39421
#define IDS_SETTINGS_MANAGE_TOPICS_PAGE_LEARN_MORE_LINK 39422
#define IDS_SETTINGS_MANAGE_TOPICS_PAGE_DESCRIPTION_LEARN_MORE_ARIA_LABEL 39423
#define IDS_SETTINGS_UNBLOCK_TOPIC_TOAST_BODY 39424
#define IDS_SETTINGS_UNBLOCK_TOPIC_TOAST_BUTTON_TEXT 39425
#define IDS_SETTINGS_FLEDGE_PAGE_FOOTER_V2 39426
#define IDS_SETTINGS_UNBLOCK_TOPIC_BUTTON_TEXT_V2 39427
#define IDS_SETTINGS_TOPICS_PAGE_BLOCKED_TOPICS_HEADING_NEW 39428
#define IDS_SETTINGS_TOPICS_PAGE_BLOCKED_TOPICS_DESCRIPTION_NEW 39429
#define IDS_SETTINGS_TOPICS_PAGE_MANAGE_TOPICS_HEADING 39430
#define IDS_SETTINGS_TOPICS_PAGE_MANAGE_TOPICS_DESCRIPTION 39431
#define IDS_SETTINGS_TOPICS_PAGE_MANAGE_TOPICS_EXPLANATION 39432
#define IDS_SETTINGS_TOPICS_PAGE_ACTIVE_TOPICS_HEADING 39433
#define IDS_SETTINGS_TOPICS_PAGE_ACTIVE_TOPICS_DESCRIPTION 39434
#define IDS_SETTINGS_TOPICS_PAGE_FOOTER_NEW 39435
#define IDS_SETTINGS_FLEDGE_PAGE_FOOTER_NEW 39436
#define IDS_SETTINGS_FLEDGE_PAGE_EXPLANATION 39437
#define IDS_PRIVACY_SANDBOX_TOPICS_CONSENT_STATUS_LABEL 39438
#define IDS_PRIVACY_SANDBOX_TOPICS_CONSENT_LAST_UPDATE_TIME_LABEL 39439
#define IDS_PRIVACY_SANDBOX_TOPICS_CONSENT_LAST_UPDATE_SOURCE_LABEL 39440
#define IDS_PRIVACY_SANDBOX_TOPICS_CONSENT_LAST_UPDATE_TEXT_LABEL 39441
#define IDS_PRIVACY_SANDBOX_TOPICS_CONSENT_UPDATE_SOURCE_SETTINGS 39442
#define IDS_PRIVACY_SANDBOX_TOPICS_CONSENT_UPDATE_SOURCE_DEFAULT 39443
#define IDS_PRIVACY_SANDBOX_TOPICS_CONSENT_UPDATE_SOURCE_CONFIRMATION 39444
#define IDS_PRIVACY_SANDBOX_TOPICS_CONSENT_ACTIVE 39445
#define IDS_PRIVACY_SANDBOX_TOPICS_CONSENT_INACTIVE 39446
#define IDS_PRIVACY_SANDBOX_TOPICS_CONSENT_NOT_REQUIRED 39447
#define IDS_PRIVACY_SANDBOX_TOPICS_INVALID_TOPIC 39448
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_1 39449
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_2 39450
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_3 39451
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_4 39452
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_5 39453
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_6 39454
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_7 39455
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_8 39456
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_9 39457
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_10 39458
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_11 39459
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_12 39460
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_13 39461
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_14 39462
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_15 39463
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_16 39464
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_17 39465
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_18 39466
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_19 39467
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_20 39468
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_21 39469
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_22 39470
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_23 39471
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_24 39472
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_25 39473
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_26 39474
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_27 39475
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_28 39476
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_29 39477
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_30 39478
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_31 39479
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_32 39480
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_33 39481
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_34 39482
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_35 39483
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_36 39484
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_37 39485
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_38 39486
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_39 39487
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_40 39488
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_41 39489
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_42 39490
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_43 39491
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_44 39492
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_45 39493
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_46 39494
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_47 39495
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_48 39496
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_49 39497
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_50 39498
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_51 39499
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_52 39500
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_53 39501
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_54 39502
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_55 39503
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_56 39504
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_57 39505
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_58 39506
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_59 39507
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_60 39508
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_61 39509
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_62 39510
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_63 39511
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_64 39512
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_65 39513
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_66 39514
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_67 39515
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_68 39516
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_69 39517
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_70 39518
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_71 39519
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_72 39520
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_73 39521
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_74 39522
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_75 39523
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_76 39524
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_77 39525
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_78 39526
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_79 39527
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_80 39528
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_81 39529
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_82 39530
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_83 39531
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_84 39532
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_85 39533
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_86 39534
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_87 39535
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_88 39536
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_89 39537
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_90 39538
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_91 39539
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_92 39540
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_93 39541
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_94 39542
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_95 39543
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_96 39544
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_97 39545
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_98 39546
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_99 39547
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_100 39548
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_101 39549
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_102 39550
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_103 39551
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_104 39552
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_105 39553
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_106 39554
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_107 39555
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_108 39556
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_109 39557
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_110 39558
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_111 39559
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_112 39560
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_113 39561
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_114 39562
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_115 39563
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_116 39564
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_117 39565
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_118 39566
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_119 39567
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_120 39568
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_121 39569
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_122 39570
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_123 39571
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_124 39572
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_125 39573
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_126 39574
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_127 39575
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_128 39576
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_129 39577
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_130 39578
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_131 39579
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_132 39580
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_133 39581
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_134 39582
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_135 39583
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_136 39584
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_137 39585
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_138 39586
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_139 39587
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_140 39588
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_141 39589
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_142 39590
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_143 39591
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_144 39592
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_145 39593
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_146 39594
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_147 39595
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_148 39596
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_149 39597
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_150 39598
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_151 39599
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_152 39600
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_153 39601
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_154 39602
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_155 39603
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_156 39604
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_157 39605
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_158 39606
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_159 39607
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_160 39608
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_161 39609
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_162 39610
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_163 39611
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_164 39612
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_165 39613
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_166 39614
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_167 39615
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_168 39616
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_169 39617
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_170 39618
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_171 39619
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_172 39620
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_173 39621
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_174 39622
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_175 39623
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_176 39624
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_177 39625
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_178 39626
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_179 39627
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_180 39628
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_181 39629
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_182 39630
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_183 39631
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_184 39632
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_185 39633
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_186 39634
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_187 39635
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_188 39636
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_189 39637
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_190 39638
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_191 39639
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_192 39640
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_193 39641
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_194 39642
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_195 39643
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_196 39644
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_197 39645
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_198 39646
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_199 39647
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_200 39648
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_201 39649
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_202 39650
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_203 39651
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_204 39652
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_205 39653
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_206 39654
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_207 39655
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_208 39656
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_209 39657
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_210 39658
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_211 39659
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_212 39660
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_213 39661
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_214 39662
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_215 39663
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_216 39664
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_217 39665
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_218 39666
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_219 39667
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_220 39668
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_221 39669
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_222 39670
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_223 39671
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_224 39672
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_225 39673
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_226 39674
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_227 39675
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_228 39676
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_229 39677
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_230 39678
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_231 39679
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_232 39680
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_233 39681
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_234 39682
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_235 39683
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_236 39684
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_237 39685
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_238 39686
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_239 39687
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_240 39688
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_241 39689
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_242 39690
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_243 39691
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_244 39692
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_245 39693
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_246 39694
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_247 39695
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_248 39696
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_249 39697
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_250 39698
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_251 39699
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_252 39700
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_253 39701
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_254 39702
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_255 39703
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_256 39704
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_257 39705
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_258 39706
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_259 39707
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_260 39708
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_261 39709
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_262 39710
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_263 39711
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_264 39712
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_265 39713
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_266 39714
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_267 39715
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_268 39716
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_269 39717
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_270 39718
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_271 39719
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_272 39720
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_273 39721
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_274 39722
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_275 39723
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_276 39724
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_277 39725
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_278 39726
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_279 39727
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_280 39728
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_281 39729
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_282 39730
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_283 39731
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_284 39732
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_285 39733
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_286 39734
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_287 39735
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_288 39736
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_289 39737
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_290 39738
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_291 39739
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_292 39740
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_293 39741
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_294 39742
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_295 39743
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_296 39744
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_297 39745
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_298 39746
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_299 39747
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_300 39748
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_301 39749
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_302 39750
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_303 39751
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_304 39752
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_305 39753
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_306 39754
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_307 39755
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_308 39756
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_309 39757
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_310 39758
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_311 39759
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_312 39760
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_313 39761
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_314 39762
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_315 39763
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_316 39764
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_317 39765
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_318 39766
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_319 39767
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_320 39768
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_321 39769
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_322 39770
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_323 39771
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_324 39772
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_325 39773
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_326 39774
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_327 39775
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_328 39776
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_329 39777
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_330 39778
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_331 39779
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_332 39780
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_333 39781
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_334 39782
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_335 39783
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_336 39784
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_337 39785
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_338 39786
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_339 39787
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_340 39788
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_341 39789
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_342 39790
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_343 39791
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_344 39792
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_345 39793
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_346 39794
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_347 39795
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_348 39796
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_349 39797
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_350 39798
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_351 39799
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_352 39800
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_353 39801
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_354 39802
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_355 39803
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_356 39804
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_357 39805
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_358 39806
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_359 39807
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_360 39808
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_361 39809
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_362 39810
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_363 39811
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_364 39812
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_365 39813
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_366 39814
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_367 39815
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_368 39816
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_369 39817
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_370 39818
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_371 39819
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_372 39820
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_373 39821
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_374 39822
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_375 39823
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_376 39824
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_377 39825
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_378 39826
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_379 39827
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_380 39828
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_381 39829
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_382 39830
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_383 39831
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_384 39832
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_385 39833
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_386 39834
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_387 39835
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_388 39836
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_389 39837
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_390 39838
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_391 39839
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_392 39840
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_393 39841
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_394 39842
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_395 39843
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_396 39844
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_397 39845
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_398 39846
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_399 39847
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_400 39848
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_401 39849
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_402 39850
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_403 39851
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_404 39852
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_405 39853
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_406 39854
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_407 39855
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_408 39856
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_409 39857
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_410 39858
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_411 39859
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_412 39860
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_413 39861
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_414 39862
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_415 39863
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_416 39864
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_417 39865
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_418 39866
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_419 39867
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_420 39868
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_421 39869
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_422 39870
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_423 39871
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_424 39872
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_425 39873
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_426 39874
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_427 39875
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_428 39876
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_429 39877
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_430 39878
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_431 39879
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_432 39880
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_433 39881
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_434 39882
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_435 39883
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_436 39884
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_437 39885
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_438 39886
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_439 39887
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_440 39888
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_441 39889
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_442 39890
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_443 39891
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_444 39892
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_445 39893
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_446 39894
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_447 39895
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_448 39896
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_449 39897
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_450 39898
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_451 39899
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_452 39900
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_453 39901
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_454 39902
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_455 39903
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_456 39904
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_457 39905
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_458 39906
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_459 39907
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_460 39908
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_461 39909
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_462 39910
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_463 39911
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_464 39912
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_465 39913
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_466 39914
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_467 39915
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_468 39916
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_469 39917
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_470 39918
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_471 39919
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_472 39920
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_473 39921
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_474 39922
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_475 39923
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_476 39924
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_477 39925
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_478 39926
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_479 39927
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_480 39928
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_481 39929
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_482 39930
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_483 39931
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_484 39932
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_485 39933
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_486 39934
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_487 39935
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_488 39936
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_489 39937
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_490 39938
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_491 39939
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_492 39940
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_493 39941
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_494 39942
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_495 39943
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_496 39944
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_497 39945
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_498 39946
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_499 39947
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_500 39948
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_501 39949
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_502 39950
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_503 39951
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_504 39952
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_505 39953
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_506 39954
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_507 39955
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_508 39956
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_509 39957
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_510 39958
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_511 39959
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_512 39960
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_513 39961
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_514 39962
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_515 39963
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_516 39964
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_517 39965
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_518 39966
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_519 39967
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_520 39968
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_521 39969
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_522 39970
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_523 39971
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_524 39972
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_525 39973
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_526 39974
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_527 39975
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_528 39976
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_529 39977
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_530 39978
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_531 39979
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_532 39980
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_533 39981
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_534 39982
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_535 39983
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_536 39984
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_537 39985
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_538 39986
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_539 39987
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_540 39988
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_541 39989
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_542 39990
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_543 39991
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_544 39992
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_545 39993
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_546 39994
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_547 39995
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_548 39996
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_549 39997
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_550 39998
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_551 39999
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_552 40000
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_553 40001
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_554 40002
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_555 40003
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_556 40004
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_557 40005
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_558 40006
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_559 40007
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_560 40008
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_561 40009
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_562 40010
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_563 40011
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_564 40012
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_565 40013
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_566 40014
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_567 40015
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_568 40016
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_569 40017
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_570 40018
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_571 40019
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_572 40020
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_573 40021
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_574 40022
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_575 40023
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_576 40024
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_577 40025
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_578 40026
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_579 40027
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_580 40028
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_581 40029
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_582 40030
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_583 40031
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_584 40032
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_585 40033
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_586 40034
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_587 40035
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_588 40036
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_589 40037
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_590 40038
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_591 40039
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_592 40040
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_593 40041
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_594 40042
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_595 40043
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_596 40044
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_597 40045
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_598 40046
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_599 40047
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_600 40048
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_601 40049
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_602 40050
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_603 40051
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_604 40052
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_605 40053
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_606 40054
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_607 40055
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_608 40056
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_609 40057
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_610 40058
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_611 40059
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_612 40060
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_613 40061
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_614 40062
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_615 40063
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_616 40064
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_617 40065
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_618 40066
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_619 40067
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_620 40068
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_621 40069
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_622 40070
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_623 40071
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_624 40072
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_625 40073
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_626 40074
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_627 40075
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_628 40076
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_629 40077
#define IDS_PRIVACY_SANDBOX_IP_PROTECTION_TITLE 40078
#define IDS_PRIVACY_SANDBOX_IP_PROTECTION_SUMMARY 40079
#define IDS_PRIVACY_SANDBOX_TRACKING_PROTECTION_TITLE 40080
#define IDS_PRIVACY_SANDBOX_TRACKING_PROTECTION_DESCRIPTION 40081
#define IDS_TRACKING_PROTECTION_ONBOARDING_NOTICE_TITLE 40082
#define IDS_TRACKING_PROTECTION_ONBOARDING_NOTICE_BODY 40083
#define IDS_TRACKING_PROTECTION_ONBOARDING_NOTICE_SETTINGS_BUTTON_LABEL 40084
#define IDS_TRACKING_PROTECTION_ONBOARDING_NOTICE_ACK_BUTTON_LABEL 40085
#define IDS_TRACKING_PROTECTION_ONBOARDING_NOTICE_LEARN_MORE_BUTTON_LABEL 40086
#define IDS_TRACKING_PROTECTION_ONBOARDING_NOTICE_LEARN_MORE_BUTTON_A11Y_LABEL 40087
#define IDS_TRACKING_PROTECTION_OFFBOARDING_NOTICE_TITLE 40088
#define IDS_TRACKING_PROTECTION_OFFBOARDING_NOTICE_BODY 40089
#define IDS_TRACKING_PROTECTION_OFFBOARDING_NOTICE_SETTINGS_BUTTON_LABEL 40090
#define IDS_TRACKING_PROTECTION_OFFBOARDING_NOTICE_ACK_BUTTON_LABEL 40091
#define IDS_TRACKING_PROTECTION_OFFBOARDING_NOTICE_LEARN_MORE_BUTTON_LABEL 40092
#define IDS_TRACKING_PROTECTION_OFFBOARDING_NOTICE_LEARN_MORE_BUTTON_A11Y_LABEL 40093
#define IDS_TRACKING_PROTECTION_REMINDER_LABEL 40094
#define IDS_TRACKING_PROTECTION_REMINDER_A11Y_LABEL 40095
#define IDS_PRIVACY_SANDBOX_TRACKING_PROTECTION_BULLET_ONE_TITLE 40096
#define IDS_PRIVACY_SANDBOX_TRACKING_PROTECTION_BULLET_ONE_DESCRIPTION 40097
#define IDS_PRIVACY_SANDBOX_TRACKING_PROTECTION_BULLET_TWO_TITLE 40098
#define IDS_PRIVACY_SANDBOX_TRACKING_PROTECTION_BULLET_TWO_DESCRIPTION 40099
#define IDS_PRIVACY_SANDBOX_TRACKING_PROTECTION_ADVANCED_CATEGORY 40100
#define IDS_TRACKING_PROTECTION_BLOCK_COOKIES_TOGGLE_TITLE 40101
#define IDS_TRACKING_PROTECTION_BLOCK_COOKIES_TOGGLE_SUMMARY 40102
#define IDS_TRACKING_PROTECTION_DNT_TOGGLE_TITLE 40103
#define IDS_TRACKING_PROTECTION_DNT_TOGGLE_SUMMARY 40104
#define IDS_TRACKING_PROTECTION_ALLOWED_GROUP_TITLE 40105
#define IDS_TRACKING_PROTECTION_ALLOWED_GROUP_DESCRIPTION 40106
#define IDS_TRACKING_PROTECTION_NEVER_EXPIRES_LABEL 40107
#define IDS_TRACKING_PROTECTION_EXPIRES_TODAY_LABEL 40108
#define IDS_TRACKING_PROTECTION_EXPIRES_LABEL 40109
#define IDS_TRACKING_PROTECTION_DELETE_SITE_LABEL 40110
#define IDS_TRACKING_PROTECTION_SETTINGS_ROLLBACK_NOTICE 40111
#define IDS_REGISTER_PROTOCOL_HANDLER_TOOLTIP 40112
#define IDS_REGISTER_PROTOCOL_HANDLER_MAILTO_NAME 40113
#define IDS_REGISTER_PROTOCOL_HANDLER_WEBCAL_NAME 40114
#define IDS_REGISTER_PROTOCOL_HANDLER_CONFIRM 40115
#define IDS_REGISTER_PROTOCOL_HANDLER_CONFIRM_REPLACE 40116
#define IDS_REGISTER_PROTOCOL_HANDLER_CONFIRM_FRAGMENT 40117
#define IDS_REGISTER_PROTOCOL_HANDLER_CONFIRM_REPLACE_FRAGMENT 40118
#define IDS_REGISTER_PROTOCOL_HANDLER_ACCEPT 40119
#define IDS_REGISTER_PROTOCOL_HANDLER_DENY 40120
#define IDS_REGISTER_PROTOCOL_HANDLER_IGNORE 40121
#define IDS_RESET_PASSWORD_TITLE 40122
#define IDS_RESET_PASSWORD_WARNING_HEADING 40123
#define IDS_RESET_PASSWORD_HEADING 40124
#define IDS_RESET_PASSWORD_WARNING_EXPLANATION_PARAGRAPH 40125
#define IDS_RESET_PASSWORD_WARNING_EXPLANATION_PARAGRAPH_WITH_ORG_NAME 40126
#define IDS_RESET_PASSWORD_BUTTON 40127
#define IDS_RESET_PASSWORD_EXPLANATION_PARAGRAPH 40128
#define IDS_RESET_PASSWORD_EXPLANATION_PARAGRAPH_WITH_ORG_NAME 40129
#define IDS_SEARCH_ENGINE_CHOICE_PAGE_TITLE 40130
#define IDS_SEARCH_ENGINE_CHOICE_PAGE_SUBTITLE 40131
#define IDS_SEARCH_ENGINE_CHOICE_PAGE_SUBTITLE_INFO_LINK 40132
#define IDS_SEARCH_ENGINE_CHOICE_PAGE_SUBTITLE_INFO_LINK_A11Y_LABEL 40133
#define IDS_SEARCH_ENGINE_CHOICE_BUTTON_TITLE 40134
#define IDS_SEARCH_ENGINE_CHOICE_INFO_DIALOG_TITLE 40136
#define IDS_SEARCH_ENGINE_CHOICE_INFO_DIALOG_BODY_FIRST_PARAGRAPH 40138
#define IDS_SEARCH_ENGINE_CHOICE_INFO_DIALOG_BODY_SECOND_PARAGRAPH 40139
#define IDS_SEARCH_ENGINE_CHOICE_INFO_DIALOG_BODY_THIRD_PARAGRAPH 40140
#define IDS_SEARCH_ENGINE_CHOICE_SETTINGS_SUBTITLE 40141
#define IDS_SEARCH_ENGINE_CHOICE_SETTINGS_SUBTITLE_NON_EEA 40142
#define IDS_SEARCH_ENGINE_CHOICE_SETTINGS_ENTRY_POINT_SUBTITLE 40143
#define IDS_SEARCH_ENGINE_CHOICE_SETTINGS_CHANGE_DEFAULT_ENGINE 40144
#define IDS_SEARCH_ENGINE_FALLBACK_MARKETING_SNIPPET 40145
#define IDS_SEARCH_ENGINE_CHOICE_MORE_BUTTON 40146
#define IDS_SEARCH_ENGINE_CHOICE_CONTINUE_BUTTON 40147
#define IDS_SEARCH_ENGINE_CHOICE_CHEVRON_A11Y_LABEL 40148
#define IDS_SEARCH_ENGINE_CHOICE_SETTINGS_CONFIRMATION_TOAST_LABEL 40149
#define IDS_SEARCH_ENGINE_CHOICE_LIST_A11Y_LABEL 40150
#define IDS_SSL_OPEN_DETAILS_BUTTON 40151
#define IDS_SSL_CLOSE_DETAILS_BUTTON 40152
#define IDS_CAPTIVE_PORTAL_AUTHORIZATION_DIALOG_NAME 40153
#define IDS_CAPTIVE_PORTAL_HEADING_WIRED 40154
#define IDS_CAPTIVE_PORTAL_HEADING_WIFI 40155
#define IDS_CAPTIVE_PORTAL_PRIMARY_PARAGRAPH_WIRED 40156
#define IDS_CAPTIVE_PORTAL_PRIMARY_PARAGRAPH_WIFI 40157
#define IDS_CAPTIVE_PORTAL_PRIMARY_PARAGRAPH_WIFI_SSID 40158
#define IDS_CAPTIVE_PORTAL_PRIMARY_PARAGRAPH_NO_LOGIN_URL_WIRED 40159
#define IDS_CAPTIVE_PORTAL_PRIMARY_PARAGRAPH_NO_LOGIN_URL_WIFI 40160
#define IDS_CAPTIVE_PORTAL_PRIMARY_PARAGRAPH_NO_LOGIN_URL_WIFI_SSID 40161
#define IDS_CAPTIVE_PORTAL_BUTTON_OPEN_LOGIN_PAGE 40162
#define IDS_MITM_SOFTWARE_HEADING 40163
#define IDS_MITM_SOFTWARE_PRIMARY_PARAGRAPH_ENTERPRISE 40164
#define IDS_MITM_SOFTWARE_PRIMARY_PARAGRAPH_NONENTERPRISE 40165
#define IDS_MITM_SOFTWARE_EXPLANATION_ENTERPRISE 40166
#define IDS_MITM_SOFTWARE_EXPLANATION_NONENTERPRISE 40167
#define IDS_MITM_SOFTWARE_EXPLANATION 40168
#define IDS_LOOKALIKE_URL_TITLE 40169
#define IDS_LOOKALIKE_URL_HEADING 40170
#define IDS_LOOKALIKE_URL_IGNORE 40171
#define IDS_LOOKALIKE_URL_CONTINUE 40172
#define IDS_LOOKALIKE_URL_PRIMARY_PARAGRAPH 40173
#define IDS_LOOKALIKE_URL_HEADING_NO_SUGGESTED_URL 40174
#define IDS_LOOKALIKE_URL_PRIMARY_PARAGRAPH_NO_SUGGESTED_URL 40175
#define IDS_LOOKALIKE_URL_BACK_TO_SAFETY 40176
#define IDS_LOOKALIKE_URL_CLOSE_PAGE 40177
#define IDS_ENTERPRISE_BLOCK_TITLE 40178
#define IDS_ENTERPRISE_BLOCK_HEADING 40179
#define IDS_ENTERPRISE_BLOCK_PRIMARY_PARAGRAPH 40180
#define IDS_ENTERPRISE_BLOCK_PRIMARY_PARAGRAPH_CUSTOM_MESSAGE 40181
#define IDS_ENTERPRISE_BLOCK_GO_BACK 40182
#define IDS_ENTERPRISE_WARN_TITLE 40183
#define IDS_ENTERPRISE_WARN_HEADING 40184
#define IDS_ENTERPRISE_WARN_PRIMARY_PARAGRAPH 40185
#define IDS_ENTERPRISE_WARN_PRIMARY_PARAGRAPH_CUSTOM_MESSAGE 40186
#define IDS_ENTERPRISE_WARN_GO_BACK 40187
#define IDS_ENTERPRISE_WARN_CONTINUE_TO_SITE 40188
#define IDS_ENTERPRISE_INTERSTITIALS_LEARN_MORE_ACCCESSIBILITY_TEXT 40189
#define IDS_CLOCK_ERROR_TITLE 40190
#define IDS_CLOCK_ERROR_AHEAD_HEADING 40191
#define IDS_CLOCK_ERROR_BEHIND_HEADING 40192
#define IDS_CLOCK_ERROR_UPDATE_DATE_AND_TIME 40193
#define IDS_CLOCK_ERROR_PRIMARY_PARAGRAPH 40194
#define IDS_CLOCK_ERROR_EXPLANATION 40195
#define IDS_SSL_V2_TITLE 40196
#define IDS_SSL_V2_HEADING 40197
#define IDS_SSL_V2_PRIMARY_PARAGRAPH 40198
#define IDS_SSL_V2_RECURRENT_ERROR_PARAGRAPH 40199
#define IDS_SSL_OVERRIDABLE_SAFETY_BUTTON 40200
#define IDS_SSL_OVERRIDABLE_CLOSE_PAGE_BUTTON 40201
#define IDS_SSL_OVERRIDABLE_PROCEED_PARAGRAPH 40202
#define IDS_SSL_RELOAD 40203
#define IDS_SSL_NONOVERRIDABLE_PINNED 40204
#define IDS_SSL_NONOVERRIDABLE_HSTS 40205
#define IDS_SSL_NONOVERRIDABLE_REVOKED 40206
#define IDS_SSL_NONOVERRIDABLE_MORE 40207
#define IDS_SSL_NONOVERRIDABLE_INVALID 40208
#define IDS_SAFEBROWSING_V3_TITLE 40209
#define IDS_SAFEBROWSING_V3_OPEN_DETAILS_BUTTON 40210
#define IDS_SAFEBROWSING_V3_CLOSE_DETAILS_BUTTON 40211
#define IDS_SAFEBROWSING_OVERRIDABLE_SAFETY_BUTTON 40212
#define IDS_SAFEBROWSING_HEADING 40213
#define IDS_MALWARE_V3_PRIMARY_PARAGRAPH 40214
#define IDS_MALWARE_V3_EXPLANATION_PARAGRAPH 40215
#define IDS_MALWARE_V3_PROCEED_PARAGRAPH 40216
#define IDS_SAFE_BROWSING_SCOUT_REPORTING_AGREE 40217
#define IDS_SAFE_BROWSING_ENHANCED_PROTECTION_MESSAGE 40218
#define IDS_HARMFUL_V3_PRIMARY_PARAGRAPH 40219
#define IDS_HARMFUL_V3_EXPLANATION_PARAGRAPH 40220
#define IDS_HARMFUL_V3_PROCEED_PARAGRAPH 40221
#define IDS_PHISHING_V4_PRIMARY_PARAGRAPH 40222
#define IDS_PHISHING_V4_EXPLANATION_PARAGRAPH 40223
#define IDS_PHISHING_V4_PROCEED_PARAGRAPH 40224
#define IDS_MALWARE_WEBVIEW_HEADING 40225
#define IDS_MALWARE_WEBVIEW_EXPLANATION_PARAGRAPH 40226
#define IDS_PHISHING_WEBVIEW_HEADING 40227
#define IDS_PHISHING_WEBVIEW_EXPLANATION_PARAGRAPH 40228
#define IDS_HARMFUL_WEBVIEW_HEADING 40229
#define IDS_HARMFUL_WEBVIEW_EXPLANATION_PARAGRAPH 40230
#define IDS_BILLING_WEBVIEW_HEADING 40231
#define IDS_BILLING_WEBVIEW_EXPLANATION_PARAGRAPH 40232
#define IDS_CONNECTION_HELP_SHOW_MORE 40233
#define IDS_CONNECTION_HELP_SHOW_LESS 40234
#define IDS_CONNECTION_HELP_TITLE 40235
#define IDS_CONNECTION_HELP_HEADING 40236
#define IDS_CONNECTION_HELP_GENERAL_HELP 40237
#define IDS_CONNECTION_HELP_SPECIFIC_ERROR_HEADING 40238
#define IDS_CONNECTION_HELP_CONNECTION_NOT_PRIVATE_TITLE 40239
#define IDS_CONNECTION_HELP_CONNECT_TO_NETWORK_TITLE 40240
#define IDS_CONNECTION_HELP_INCORRECT_CLOCK_TITLE 40241
#define IDS_CONNECTION_HELP_CONNECTION_NOT_PRIVATE_DETAILS 40242
#define IDS_CONNECTION_HELP_CONNECT_TO_NETWORK_DETAILS 40243
#define IDS_CONNECTION_HELP_INCORRECT_CLOCK_DETAILS 40244
#define IDS_BILLING_TITLE 40247
#define IDS_BILLING_HEADING 40248
#define IDS_BILLING_PRIMARY_PARAGRAPH 40249
#define IDS_BILLING_PRIMARY_BUTTON 40250
#define IDS_BILLING_PROCEED_BUTTON 40251
#define IDS_BLOCKED_INTERCEPTION_HEADING 40252
#define IDS_KNOWN_INTERCEPTION_TITLE 40253
#define IDS_KNOWN_INTERCEPTION_HEADER 40254
#define IDS_KNOWN_INTERCEPTION_BODY1 40255
#define IDS_KNOWN_INTERCEPTION_BODY2 40256
#define IDS_KNOWN_INTERCEPTION_INFOBAR_HEADING 40257
#define IDS_KNOWN_INTERCEPTION_INFOBAR_BUTTON_TEXT 40258
#define IDS_LEGACY_TLS_HEADING 40259
#define IDS_LEGACY_TLS_PRIMARY_PARAGRAPH 40260
#define IDS_LEGACY_TLS_EXPLANATION 40261
#define IDS_INSECURE_FORM_TITLE 40262
#define IDS_INSECURE_FORM_HEADING 40263
#define IDS_INSECURE_FORM_PRIMARY_PARAGRAPH 40264
#define IDS_INSECURE_FORM_BACK_BUTTON 40265
#define IDS_INSECURE_FORM_SUBMIT_BUTTON 40266
#define IDS_HTTPS_ONLY_MODE_TITLE 40267
#define IDS_HTTPS_ONLY_MODE_HEADING 40268
#define IDS_HTTPS_ONLY_MODE_PRIMARY_PARAGRAPH 40269
#define IDS_HTTPS_ONLY_MODE_WITH_ADVANCED_PROTECTION_PRIMARY_PARAGRAPH 40270
#define IDS_HTTPS_ONLY_MODE_WITH_SITE_ENGAGEMENT_PRIMARY_PARAGRAPH 40271
#define IDS_HTTPS_ONLY_MODE_FOR_TYPICALLY_SECURE_BROWSING_PRIMARY_PARAGRAPH 40272
#define IDS_HTTPS_ONLY_MODE_FOR_INCOGNITO_PRIMARY_PARAGRAPH 40273
#define IDS_HTTPS_ONLY_MODE_BACK_BUTTON 40274
#define IDS_HTTPS_ONLY_MODE_SUBMIT_BUTTON 40275
#define IDS_SHARING_DEVICE_TYPE_COMPUTER 40276
#define IDS_SHARING_DEVICE_TYPE_DEVICE 40277
#define IDS_SHARING_DEVICE_TYPE_PHONE 40278
#define IDS_SHARING_DEVICE_TYPE_TABLET 40279
#define IDS_SITE_SETTINGS_TYPE_ADS 40280
#define IDS_SITE_SETTINGS_TYPE_ADS_MID_SENTENCE 40281
#define IDS_SITE_SETTINGS_TYPE_ANTI_ABUSE 40282
#define IDS_SITE_SETTINGS_TYPE_AR 40283
#define IDS_SITE_SETTINGS_TYPE_AR_MID_SENTENCE 40284
#define IDS_SITE_SETTINGS_TYPE_AUTOMATIC_DOWNLOADS 40285
#define IDS_SITE_SETTINGS_TYPE_AUTOMATIC_DOWNLOADS_MID_SENTENCE 40286
#define IDS_SITE_SETTINGS_TYPE_AUTOMATIC_FULLSCREEN 40287
#define IDS_SITE_SETTINGS_TYPE_AUTOMATIC_FULLSCREEN_MID_SENTENCE 40288
#define IDS_SITE_SETTINGS_TYPE_AUTO_PICTURE_IN_PICTURE 40289
#define IDS_SITE_SETTINGS_TYPE_AUTO_PICTURE_IN_PICTURE_MID_SENTENCE 40290
#define IDS_SITE_SETTINGS_TYPE_BACKGROUND_SYNC 40291
#define IDS_SITE_SETTINGS_TYPE_BACKGROUND_SYNC_MID_SENTENCE 40292
#define IDS_SITE_SETTINGS_TYPE_BLUETOOTH_DEVICES 40293
#define IDS_SITE_SETTINGS_TYPE_BLUETOOTH_DEVICES_MID_SENTENCE 40294
#define IDS_SITE_SETTINGS_TYPE_BLUETOOTH_SCANNING 40295
#define IDS_SITE_SETTINGS_TYPE_BLUETOOTH_SCANNING_MID_SENTENCE 40296
#define IDS_SITE_SETTINGS_TYPE_CAMERA 40297
#define IDS_SITE_SETTINGS_TYPE_CAMERA_MID_SENTENCE 40298
#define IDS_SITE_SETTINGS_TYPE_CAMERA_WITH_COUNT 40299
#define IDS_SITE_SETTINGS_TYPE_CAMERA_PAN_TILT_ZOOM 40300
#define IDS_SITE_SETTINGS_TYPE_CAMERA_PAN_TILT_ZOOM_MID_SENTENCE 40301
#define IDS_SITE_SETTINGS_TYPE_CAMERA_PAN_TILT_ZOOM_WITH_COUNT 40302
#define IDS_SITE_SETTINGS_TYPE_CAPTURED_SURFACE_CONTROL 40303
#define IDS_SITE_SETTINGS_TYPE_CAPTURED_SURFACE_CONTROL_MID_SENTENCE 40304
#define IDS_SITE_SETTINGS_TYPE_CLIPBOARD 40305
#define IDS_SITE_SETTINGS_TYPE_CLIPBOARD_MID_SENTENCE 40306
#define IDS_SITE_SETTINGS_TYPE_COOKIES 40307
#define IDS_SITE_SETTINGS_TYPE_COOKIES_MID_SENTENCE 40308
#define IDS_SITE_SETTINGS_TYPE_FEDERATED_IDENTITY_API 40309
#define IDS_SITE_SETTINGS_TYPE_FEDERATED_IDENTITY_API_MID_SENTENCE 40310
#define IDS_SITE_SETTINGS_TYPE_IDLE_DETECTION 40311
#define IDS_SITE_SETTINGS_TYPE_IDLE_DETECTION_MID_SENTENCE 40312
#define IDS_SITE_SETTINGS_TYPE_JAVASCRIPT 40313
#define IDS_SITE_SETTINGS_TYPE_JAVASCRIPT_MID_SENTENCE 40314
#define IDS_SITE_SETTINGS_TYPE_JAVASCRIPT_JIT 40315
#define IDS_SITE_SETTINGS_TYPE_LOCATION 40316
#define IDS_SITE_SETTINGS_TYPE_LOCATION_MID_SENTENCE 40317
#define IDS_SITE_SETTINGS_TYPE_MIC 40318
#define IDS_SITE_SETTINGS_TYPE_MIC_MID_SENTENCE 40319
#define IDS_SITE_SETTINGS_TYPE_MIC_WITH_COUNT 40320
#define IDS_SITE_SETTINGS_TYPE_MIDI_SYSEX 40321
#define IDS_SITE_SETTINGS_TYPE_MIDI_SYSEX_MID_SENTENCE 40322
#define IDS_SITE_SETTINGS_TYPE_MOTION_SENSORS 40323
#define IDS_SITE_SETTINGS_TYPE_MOTION_SENSORS_MID_SENTENCE 40324
#define IDS_SITE_SETTINGS_TYPE_NFC 40325
#define IDS_SITE_SETTINGS_TYPE_NFC_MID_SENTENCE 40326
#define IDS_SITE_SETTINGS_TYPE_NOTIFICATIONS 40327
#define IDS_SITE_SETTINGS_TYPE_NOTIFICATIONS_MID_SENTENCE 40328
#define IDS_SITE_SETTINGS_TYPE_POPUPS_REDIRECTS 40329
#define IDS_SITE_SETTINGS_TYPE_POPUPS_REDIRECTS_MID_SENTENCE 40330
#define IDS_SITE_SETTINGS_TYPE_PROTECTED_MEDIA_ID 40331
#define IDS_SITE_SETTINGS_TYPE_PROTECTED_MEDIA_ID_MID_SENTENCE 40332
#define IDS_SITE_SETTINGS_TYPE_SENSORS 40333
#define IDS_SITE_SETTINGS_TYPE_SENSORS_MID_SENTENCE 40334
#define IDS_SITE_SETTINGS_TYPE_SOUND 40335
#define IDS_SITE_SETTINGS_TYPE_SOUND_MID_SENTENCE 40336
#define IDS_SITE_SETTINGS_TYPE_USB_DEVICES 40337
#define IDS_SITE_SETTINGS_TYPE_USB_DEVICES_MID_SENTENCE 40338
#define IDS_SITE_SETTINGS_TYPE_VR 40339
#define IDS_SITE_SETTINGS_TYPE_VR_MID_SENTENCE 40340
#define IDS_SITE_SETTINGS_TYPE_STORAGE_ACCESS 40341
#define IDS_SITE_SETTINGS_TYPE_STORAGE_ACCESS_MID_SENTENCE 40342
#define IDS_SITE_SETTINGS_TYPE_FILE_SYSTEM_ACCESS_WRITE 40343
#define IDS_SITE_SETTINGS_TYPE_FILE_SYSTEM_ACCESS_WRITE_MID_SENTENCE 40344
#define IDS_SITE_SETTINGS_TYPE_FONT_ACCESS 40345
#define IDS_SITE_SETTINGS_TYPE_FONT_ACCESS_MID_SENTENCE 40346
#define IDS_SITE_SETTINGS_TYPE_HANDLERS 40347
#define IDS_SITE_SETTINGS_TYPE_HANDLERS_MID_SENTENCE 40348
#define IDS_SITE_SETTINGS_TYPE_HID_DEVICES 40349
#define IDS_SITE_SETTINGS_TYPE_HID_DEVICES_MID_SENTENCE 40350
#define IDS_SITE_SETTINGS_TYPE_IMAGES 40351
#define IDS_SITE_SETTINGS_TYPE_IMAGES_MID_SENTENCE 40352
#define IDS_SITE_SETTINGS_TYPE_INSECURE_CONTENT 40353
#define IDS_SITE_SETTINGS_TYPE_INSECURE_CONTENT_MID_SENTENCE 40354
#define IDS_SITE_SETTINGS_TYPE_KEYBOARD_LOCK 40355
#define IDS_SITE_SETTINGS_TYPE_KEYBOARD_LOCK_MID_SENTENCE 40356
#define IDS_SITE_SETTINGS_TYPE_PAYMENT_HANDLER 40357
#define IDS_SITE_SETTINGS_TYPE_PAYMENT_HANDLER_MID_SENTENCE 40358
#define IDS_SITE_SETTINGS_TYPE_PDF_DOCUMENTS 40359
#define IDS_SITE_SETTINGS_TYPE_POINTER_LOCK 40360
#define IDS_SITE_SETTINGS_TYPE_POINTER_LOCK_MID_SENTENCE 40361
#define IDS_SITE_SETTINGS_TYPE_SERIAL_PORTS 40362
#define IDS_SITE_SETTINGS_TYPE_SERIAL_PORTS_MID_SENTENCE 40363
#define IDS_SITE_SETTINGS_TYPE_ZOOM_LEVELS 40364
#define IDS_SITE_SETTINGS_TYPE_ZOOM_LEVELS_MID_SENTENCE 40365
#define IDS_SITE_SETTINGS_TYPE_WEB_PRINTING 40366
#define IDS_SITE_SETTINGS_TYPE_WEB_PRINTING_MID_SENTENCE 40367
#define IDS_SITE_SETTINGS_TYPE_WINDOW_MANAGEMENT 40368
#define IDS_SITE_SETTINGS_TYPE_WINDOW_MANAGEMENT_MID_SENTENCE 40369
#define IDS_SITE_SETTINGS_TYPE_PERFORMANCE 40370
#define IDS_SITE_SETTINGS_TYPE_PERFORMANCE_SUBLABEL 40371
#define IDS_SITE_SETTINGS_TYPE_OFFER_WRITING_HELP 40372
#define IDS_SMS_INFOBAR_TITLE 40373
#define IDS_SMS_INFOBAR_STATUS_SMS_RECEIVED 40374
#define IDS_SMS_INFOBAR_STATUS_SMS_RECEIVED_FROM_EMBEDDED_FRAME 40375
#define IDS_SMS_INFOBAR_BUTTON_OK 40376
#define IDS_CERT_ERROR_NO_SUBJECT_ALTERNATIVE_NAMES_DETAILS 40377
#define IDS_CERT_ERROR_COMMON_NAME_INVALID_DETAILS 40378
#define IDS_CERT_ERROR_COMMON_NAME_INVALID_DESCRIPTION 40379
#define IDS_CERT_ERROR_EXPIRED_DETAILS 40380
#define IDS_CERT_ERROR_EXPIRED_DESCRIPTION 40381
#define IDS_CERT_ERROR_NOT_YET_VALID_DETAILS 40382
#define IDS_CERT_ERROR_NOT_YET_VALID_DESCRIPTION 40383
#define IDS_CERT_ERROR_NOT_VALID_AT_THIS_TIME_DETAILS 40384
#define IDS_CERT_ERROR_NOT_VALID_AT_THIS_TIME_DESCRIPTION 40385
#define IDS_CERT_ERROR_AUTHORITY_INVALID_DESCRIPTION 40386
#define IDS_CERT_ERROR_CONTAINS_ERRORS_DETAILS 40387
#define IDS_CERT_ERROR_CONTAINS_ERRORS_DESCRIPTION 40388
#define IDS_CERT_ERROR_UNABLE_TO_CHECK_REVOCATION_DETAILS 40389
#define IDS_CERT_ERROR_UNABLE_TO_CHECK_REVOCATION_DESCRIPTION 40390
#define IDS_CERT_ERROR_NO_REVOCATION_MECHANISM_DETAILS 40391
#define IDS_CERT_ERROR_NO_REVOCATION_MECHANISM_DESCRIPTION 40392
#define IDS_CERT_ERROR_REVOKED_CERT_DETAILS 40393
#define IDS_CERT_ERROR_REVOKED_CERT_DESCRIPTION 40394
#define IDS_CERT_ERROR_INVALID_CERT_DETAILS 40395
#define IDS_CERT_ERROR_INVALID_CERT_DESCRIPTION 40396
#define IDS_CERT_ERROR_WEAK_SIGNATURE_ALGORITHM_DETAILS 40397
#define IDS_CERT_ERROR_WEAK_SIGNATURE_ALGORITHM_DESCRIPTION 40398
#define IDS_CERT_ERROR_WEAK_KEY_DETAILS 40399
#define IDS_CERT_ERROR_WEAK_KEY_DESCRIPTION 40400
#define IDS_CERT_ERROR_NAME_CONSTRAINT_VIOLATION_DETAILS 40401
#define IDS_CERT_ERROR_NAME_CONSTRAINT_VIOLATION_DESCRIPTION 40402
#define IDS_CERT_ERROR_VALIDITY_TOO_LONG_DETAILS 40403
#define IDS_CERT_ERROR_VALIDITY_TOO_LONG_DESCRIPTION 40404
#define IDS_CERT_ERROR_NON_UNIQUE_NAME_DETAILS 40405
#define IDS_CERT_ERROR_NON_UNIQUE_NAME_DESCRIPTION 40406
#define IDS_CERT_ERROR_UNKNOWN_ERROR_DETAILS 40407
#define IDS_CERT_ERROR_UNKNOWN_ERROR_DESCRIPTION 40408
#define IDS_CERT_ERROR_SUMMARY_PINNING_FAILURE_DETAILS 40409
#define IDS_CERT_ERROR_SUMMARY_PINNING_FAILURE_DESCRIPTION 40410
#define IDS_CERT_ERROR_CERTIFICATE_TRANSPARENCY_REQUIRED_DETAILS 40411
#define IDS_CERT_ERROR_CERTIFICATE_TRANSPARENCY_REQUIRED_DESCRIPTION 40412
#define IDS_SSL_ERROR_OBSOLETE_VERSION_DETAILS 40413
#define IDS_SSL_ERROR_OBSOLETE_VERSION_DESCRIPTION 40414
#define IDS_CERT_ERROR_AUTHORITY_INVALID_DETAILS 40415
#define IDS_ALWAYS_ALLOW_ADS 40416
#define IDS_BLOCKED_ADS_PROMPT_TITLE 40417
#define IDS_BLOCKED_ADS_PROMPT_EXPLANATION 40418
#define IDS_BLOCK_INTERSTITIAL_TITLE 40425
#define IDS_CHILD_BLOCK_INTERSTITIAL_HEADER 40426
#define IDS_BLOCK_INTERSTITIAL_HEADER_ACCESS_REQUESTS_DISABLED 40427
#define IDS_BLOCK_INTERSTITIAL_HEADER_NOT_SIGNED_IN 40428
#define IDS_CHILD_BLOCK_INTERSTITIAL_MESSAGE_V2 40429
#define IDS_REQUEST_SENT_OK 40430
#define IDS_BLOCK_INTERSTITIAL_ASK_IN_PERSON_BUTTON 40431
#define IDS_BLOCK_INTERSTITIAL_ASK_IN_PERSON_INSTEAD_BUTTON 40432
#define IDS_BLOCK_INTERSTITIAL_ASK_IN_A_MESSAGE_BUTTON 40433
#define IDS_CHILD_BLOCK_INTERSTITIAL_WAITING_APPROVAL_MESSAGE 40434
#define IDS_CHILD_BLOCK_INTERSTITIAL_WAITING_APPROVAL_DESCRIPTION_SINGLE_PARENT 40435
#define IDS_CHILD_BLOCK_INTERSTITIAL_WAITING_APPROVAL_DESCRIPTION_MULTI_PARENT 40436
#define IDS_CHILD_BLOCK_INTERSTITIAL_REQUEST_FAILED_MESSAGE_SINGLE_PARENT 40437
#define IDS_CHILD_BLOCK_INTERSTITIAL_REQUEST_FAILED_MESSAGE_MULTI_PARENT 40438
#define IDS_BLOCK_INTERSTITIAL_SHOW_DETAILS 40439
#define IDS_BLOCK_INTERSTITIAL_HIDE_DETAILS 40440
#define IDS_GENERIC_SITE_BLOCK_HEADER 40441
#define IDS_SUPERVISED_USER_BLOCK_HEADER 40442
#define IDS_CHILD_BLOCK_MESSAGE_DEFAULT_SINGLE_PARENT 40443
#define IDS_CHILD_BLOCK_MESSAGE_DEFAULT_MULTI_PARENT 40444
#define IDS_SUPERVISED_USER_BLOCK_MESSAGE_SAFE_SITES 40445
#define IDS_CHILD_BLOCK_MESSAGE_MANUAL_SINGLE_PARENT 40446
#define IDS_CHILD_BLOCK_MESSAGE_MANUAL_MULTI_PARENT 40447
#define IDS_SUPERVISED_USER_NOT_SIGNED_IN 40448
#define IDS_PARENT_BLOCKED_SITE_BANNER_TITLE 40449
#define IDS_PARENT_BLOCKED_SITE_BANNER_MESSAGE 40450
#define IDS_SYNC_BASIC_ENCRYPTION_DATA 40451
#define IDS_SYNC_DATATYPE_AUTOFILL 40452
#define IDS_SYNC_DATATYPE_BOOKMARKS 40453
#define IDS_SYNC_DATATYPE_PASSWORDS 40454
#define IDS_SYNC_DATATYPE_PREFERENCES 40455
#define IDS_SYNC_DATATYPE_TABS 40456
#define IDS_SYNC_DATATYPE_TYPED_URLS 40457
#define IDS_SYNC_DATATYPE_HISTORY_AND_TABS 40458
#define IDS_SYNC_DATATYPE_READING_LIST 40459
#define IDS_SYNC_EMPTY_PASSPHRASE_ERROR 40460
#define IDS_SYNC_ENCRYPTION_SECTION_TITLE 40461
#define IDS_SYNC_FULL_ENCRYPTION_DATA 40462
#define IDS_SYNC_LOGIN_SETTING_UP 40463
#define IDS_SYNC_PASSPHRASE_LABEL 40464
#define IDS_SYNC_PASSPHRASE_MISMATCH_ERROR 40465
#define IDS_SYNC_ENTER_PASSPHRASE_BODY_WITH_DATE 40466
#define IDS_SYNC_ENTER_PASSPHRASE_BODY 40467
#define IDS_TRANSLATE_INFOBAR_OPTIONS_MORE_LANGUAGE 40468
#define IDS_TRANSLATE_INFOBAR_OPTIONS_NOT_SOURCE_LANGUAGE 40469
#define IDS_TRANSLATE_INFOBAR_OPTIONS_NEVER_TRANSLATE_LANG 40470
#define IDS_TRANSLATE_INFOBAR_OPTIONS_NEVER_TRANSLATE_SITE 40471
#define IDS_TRANSLATE_INFOBAR_OPTIONS_ALWAYS 40472
#define IDS_TRANSLATE_INFOBAR_OPTIONS_REPORT_ERROR 40473
#define IDS_TRANSLATE_INFOBAR_OPTIONS_ABOUT 40474
#define IDS_TRANSLATE_INFOBAR_ACCEPT 40476
#define IDS_TRANSLATE_INFOBAR_DENY 40477
#define IDS_TRANSLATE_INFOBAR_NEVER_TRANSLATE 40478
#define IDS_TRANSLATE_INFOBAR_ALWAYS_TRANSLATE 40479
#define IDS_TRANSLATE_INFOBAR_AFTER_MESSAGE 40480
#define IDS_TRANSLATE_INFOBAR_AFTER_MESSAGE_AUTODETERMINED_SOURCE_LANGUAGE 40481
#define IDS_TRANSLATE_INFOBAR_REVERT 40482
#define IDS_TRANSLATE_INFOBAR_RETRY 40483
#define IDS_TRANSLATE_NOTIFICATION_ERROR 40507
#define IDS_TRANSLATE_NOTIFICATION_ALWAYS_TRANSLATE 40508
#define IDS_TRANSLATE_NOTIFICATION_LANGUAGE_NEVER 40509
#define IDS_TRANSLATE_NOTIFICATION_SITE_NEVER 40510
#define IDS_TRANSLATE_NOTIFICATION_UNDO 40511
#define IDS_TRANSLATE_DETECTED_LANGUAGE 40512
#define IDS_TAB_GROUP_COLOR_GREY 40513
#define IDS_TAB_GROUP_COLOR_BLUE 40514
#define IDS_TAB_GROUP_COLOR_RED 40515
#define IDS_TAB_GROUP_COLOR_YELLOW 40516
#define IDS_TAB_GROUP_COLOR_GREEN 40517
#define IDS_TAB_GROUP_COLOR_PINK 40518
#define IDS_TAB_GROUP_COLOR_PURPLE 40519
#define IDS_TAB_GROUP_COLOR_CYAN 40520
#define IDS_TAB_GROUP_COLOR_ORANGE 40521
#define IDS_BOOKMARK_BAR_UNDO 40522
#define IDS_BOOKMARK_BAR_REDO 40523
#define IDS_BOOKMARK_BAR_UNDO_ADD 40524
#define IDS_BOOKMARK_BAR_REDO_ADD 40525
#define IDS_BOOKMARK_BAR_UNDO_DELETE 40526
#define IDS_BOOKMARK_BAR_REDO_DELETE 40527
#define IDS_BOOKMARK_BAR_UNDO_EDIT 40528
#define IDS_BOOKMARK_BAR_REDO_EDIT 40529
#define IDS_BOOKMARK_BAR_UNDO_MOVE 40530
#define IDS_BOOKMARK_BAR_REDO_MOVE 40531
#define IDS_BOOKMARK_BAR_UNDO_REORDER 40532
#define IDS_BOOKMARK_BAR_REDO_REORDER 40533
#define IDS_CLOSE_TUTORIAL 40534
#define IDS_CLOSE_PROMO 40535
#define IDS_PROMO_DISMISS_BUTTON 40536
#define IDS_PROMO_SNOOZE_BUTTON 40537
#define IDS_PROMO_SHOW_TUTORIAL_BUTTON 40538
#define IDS_TUTORIAL_RESTART_TUTORIAL 40539
#define IDS_TUTORIAL_CLOSE_TUTORIAL 40540
#define IDS_TUTORIAL_NEXT_BUTTON 40541
#define IDS_VERSION_UI_TITLE 40542
#define IDS_VERSION_UI_OFFICIAL 40543
#define IDS_VERSION_UI_UNOFFICIAL 40544
#define IDS_VERSION_UI_32BIT 40545
#define IDS_VERSION_UI_64BIT 40546
#define IDS_VERSION_UI_REVISION 40551
#define IDS_VERSION_UI_OS 40552
#define IDS_VERSION_UI_USER_AGENT 40554
#define IDS_VERSION_UI_COMMAND_LINE 40555
#define IDS_VERSION_UI_COPY_LABEL 40559
#define IDS_VERSION_UI_COPY_NOTICE 40560
#define IDS_VERSION_UI_EXECUTABLE_PATH 40561
#define IDS_VERSION_UI_PROFILE_PATH 40562
#define IDS_VERSION_UI_PATH_NOTFOUND 40563
#define IDS_VERSION_UI_VARIATIONS 40564
#define IDS_VERSION_UI_VARIATIONS_SEED_NAME 40565
#define IDS_VERSION_UI_VARIATIONS_CMD 40566
#define IDS_HISTORY_CLUSTERS_ACTION_MENU_DESCRIPTION 40574
#define IDS_HISTORY_CLUSTERS_DELETE_PRIOR_VISITS_CONFIRM_BUTTON 40575
#define IDS_HISTORY_CLUSTERS_DELETE_PRIOR_VISITS_WARNING 40576
#define IDS_HISTORY_CLUSTERS_BY_GROUP_TAB_LABEL 40577
#define IDS_HISTORY_CLUSTERS_BY_DATE_TAB_LABEL 40578
#define IDS_HISTORY_CLUSTERS_CLUSTER_LABEL_SEARCH_TERMS 40579
#define IDS_HISTORY_CLUSTERS_CLUSTER_LABEL_MULTIPLE_HOSTNAMES 40580
#define IDS_HISTORY_CLUSTERS_CLUSTER_LABEL_OTHER_MATCHING_VISITS 40581
#define IDS_HISTORY_CLUSTERS_HIDE_PAGE 40582
#define IDS_HISTORY_CLUSTERS_HIDE_VISITS 40583
#define IDS_HISTORY_CLUSTERS_LOAD_MORE_BUTTON_LABEL 40584
#define IDS_HISTORY_CLUSTERS_NO_RESULTS 40585
#define IDS_HISTORY_CLUSTERS_NO_SEARCH_RESULTS 40586
#define IDS_HISTORY_CLUSTERS_SHOW_SIDE_PANEL 40587
#define IDS_HISTORY_CLUSTERS_OPEN_ALL_IN_TABGROUP 40588
#define IDS_HISTORY_CLUSTERS_OPEN_INCOGNITO 40589
#define IDS_HISTORY_CLUSTERS_OPEN_IN_NEW_TAB 40590
#define IDS_HISTORY_CLUSTERS_OPEN_IN_NEW_WINDOW 40591
#define IDS_HISTORY_CLUSTERS_RELATED_SEARCHES_HEADER 40592
#define IDS_HISTORY_CLUSTERS_REMOVE_ALL_ITEMS 40593
#define IDS_HISTORY_CLUSTERS_REMOVE_PAGE 40594
#define IDS_HISTORY_CLUSTERS_REMOVE_ITEM_TOAST 40595
#define IDS_HISTORY_CLUSTERS_REMOVE_SELECTED_ITEMS 40596
#define IDS_HISTORY_CLUSTERS_SAVED_IN_TABGROUP_LABEL 40597
#define IDS_HISTORY_CLUSTERS_CUT 40598
#define IDS_HISTORY_CLUSTERS_COPY 40599
#define IDS_HISTORY_CLUSTERS_PASTE 40600
#define IDS_HISTORY_CLUSTERS_COPY_LINK 40601
#define IDS_HISTORY_CLUSTERS_SHOW_LESS_BUTTON_LABEL 40602
#define IDS_HISTORY_CLUSTERS_SHOW_MORE_BUTTON_LABEL 40603
#define IDS_CARDBOARD_PRODUCT_SAFETY 40631
#define IDS_USE_ANOTHER_DEVICE 40632
#define IDS_VR_MENU 40633
#define IDS_CANCEL 40634
#define IDS_CLOSE 40635
#define IDS_CLEAR 40636
#define IDS_DONE 40637
#define IDS_LEARN_MORE 40638
#define IDS_OK 40639
#define IDS_RELOAD 40640
#define IDS_ADD 40641
#define IDS_REMOVE 40642
#define IDS_SAVE 40643
#define IDS_MENU 40644
#define IDS_INSTALL 40645
#define IDS_UPDATE 40646
#define IDS_NO_THANKS 40649
#define IDS_NOT_NOW 40650
#define IDS_TURN_OFF 40651
#define IDS_PLUGIN_NOT_SUPPORTED 40652
#define IDS_PRINT 40653
#define IDS_RECENT_TABS 40654
#define IDS_RECENTLY_CLOSED 40655
#define IDS_YOUR_DEVICES 40656
#define IDS_CHOOSE 40657
#define IDS_ACCNAME_BACK 40658
#define IDS_ACCNAME_FORWARD 40659
#define IDS_ACCNAME_OK 40660
#define IDS_ACCNAME_CANCEL 40661
#define IDS_ACCNAME_DONE 40662
#define IDS_ACCNAME_SAVE 40663
#define IDS_ACCNAME_CLOSE 40664
#define IDS_ACCNAME_OPEN 40665
#define IDS_ACCNAME_OPEN_IN_NEW_TAB 40666
#define IDS_ACCNAME_PREVIOUS 40667
#define IDS_ACCNAME_NEXT 40668
#define IDS_ACCNAME_LOCATION 40669
#define IDS_ACCNAME_TAB_LIST 40670
#define IDS_UTILITY_PROCESS_JSON_PARSER_NAME 40671
#define IDS_SESSION_CRASHED_VIEW_RESTORE_BUTTON 40672
#define IDS_SESSION_CRASHED_VIEW_STARTUP_PAGES_BUTTON 40673
#define IDS_OPTIONS_ADVANCED_SECTION_TITLE_PRIVACY 40674
#define IDS_OPTIONS_ADVANCED_SECTION_TITLE_SAFETY_CHECK 40675
#define IDS_PATCH_SERVICE_DISPLAY_NAME 40676
#define IDS_PASSWORD_MANAGER_CSV_PASSWORD_PARSER_SERVICE_DISPLAY_NAME 40677
#define IDS_UNZIP_SERVICE_DISPLAY_NAME 40678

// ---------------------------------------------------------------------------
// From extensions_strings.h:

#define IDS_EXTENSION_BAD_FILE_ENCODING 46080
#define IDS_EXTENSION_CANT_GET_ABSOLUTE_PATH 46081
#define IDS_EXTENSION_CONTAINS_PRIVATE_KEY 46082
#define IDS_EXTENSION_CRX_EXISTS 46083
#define IDS_EXTENSION_CONTENT_SCRIPT_FILE_TOO_LARGE 46084
#define IDS_EXTENSION_DIRECTORY_NO_EXISTS 46085
#define IDS_EXTENSION_ERROR_WHILE_SIGNING 46086
#define IDS_EXTENSION_FAILED_DURING_PACKAGING 46087
#define IDS_EXTENSION_LOAD_ABOUT_PAGE_FAILED 46088
#define IDS_EXTENSION_LOAD_BACKGROUND_SCRIPT_FAILED 46089
#define IDS_EXTENSION_LOAD_BACKGROUND_PAGE_FAILED 46090
#define IDS_EXTENSION_LOAD_CSS_FAILED 46091
#define IDS_EXTENSION_LOAD_JAVASCRIPT_FAILED 46092
#define IDS_EXTENSION_LOAD_OPTIONS_PAGE_FAILED 46093
#define IDS_EXTENSION_LOCALES_NO_DEFAULT_LOCALE_SPECIFIED 46094
#define IDS_EXTENSION_MANIFEST_UNREADABLE 46095
#define IDS_EXTENSION_MANIFEST_INVALID 46096
#define IDS_EXTENSION_PACKAGE_IMAGE_ERROR 46097
#define IDS_EXTENSION_PACKAGE_UNZIP_ERROR 46098
#define IDS_EXTENSION_PRIVATE_KEY_EXISTS 46099
#define IDS_EXTENSION_PRIVATE_KEY_FAILED_TO_READ 46100
#define IDS_EXTENSION_PRIVATE_KEY_FAILED_TO_EXPORT 46101
#define IDS_EXTENSION_PRIVATE_KEY_FAILED_TO_GENERATE 46102
#define IDS_EXTENSION_PRIVATE_KEY_FAILED_TO_OUTPUT 46103
#define IDS_EXTENSION_PRIVATE_KEY_INVALID 46104
#define IDS_EXTENSION_PRIVATE_KEY_NO_EXISTS 46105
#define IDS_EXTENSION_PRIVATE_KEY_INVALID_PATH 46106
#define IDS_EXTENSION_PRIVATE_KEY_INVALID_FORMAT 46107
#define IDS_EXTENSION_PUBLIC_KEY_FAILED_TO_EXPORT 46108
#define IDS_EXTENSION_SHARING_VIOLATION 46109
#define IDS_EXTENSION_CANT_INSTALL_POLICY_BLOCKED 46110
#define IDS_EXTENSION_CANT_MODIFY_POLICY_REQUIRED 46111
#define IDS_EXTENSION_CANT_UNINSTALL_POLICY_REQUIRED 46112
#define IDS_EXTENSION_DISABLED_UPDATE_REQUIRED_BY_POLICY 46113
#define IDS_EXTENSION_DISABLED_PUBLISHED_IN_STORE_REQUIRED_BY_POLICY 46114
#define IDS_EXTENSION_MANIFEST_VERSION_NOT_SUPPORTED 46115
#define IDS_DEVICE_NAME_WITH_PRODUCT_SERIAL 46116
#define IDS_DEVICE_NAME_WITH_PRODUCT_UNKNOWN_VENDOR 46117
#define IDS_DEVICE_NAME_WITH_PRODUCT_UNKNOWN_VENDOR_SERIAL 46118
#define IDS_DEVICE_NAME_WITH_PRODUCT_VENDOR 46119
#define IDS_DEVICE_NAME_WITH_PRODUCT_VENDOR_SERIAL 46120
#define IDS_DEVICE_NAME_WITH_UNKNOWN_PRODUCT_UNKNOWN_VENDOR 46121
#define IDS_DEVICE_NAME_WITH_UNKNOWN_PRODUCT_UNKNOWN_VENDOR_SERIAL 46122
#define IDS_DEVICE_NAME_WITH_UNKNOWN_PRODUCT_VENDOR 46123
#define IDS_DEVICE_NAME_WITH_UNKNOWN_PRODUCT_VENDOR_SERIAL 46124
#define IDS_DEVICE_PERMISSIONS_PROMPT_SINGLE_SELECTION 46125
#define IDS_DEVICE_PERMISSIONS_PROMPT_MULTIPLE_SELECTION 46126
#define IDS_CAMERA_FACING_USER 46127
#define IDS_CAMERA_FACING_ENVIRONMENT 46128
#define IDS_EXTENSION_USB_DEVICE_PRODUCT_NAME_AND_VENDOR 46129
#define IDS_EXTENSION_TASK_MANAGER_APPVIEW_TAG_PREFIX 46130
#define IDS_EXTENSION_TASK_MANAGER_EXTENSIONOPTIONS_TAG_PREFIX 46131
#define IDS_EXTENSION_TASK_MANAGER_MIMEHANDLERVIEW_TAG_PREFIX 46132
#define IDS_EXTENSION_TASK_MANAGER_WEBVIEW_TAG_PREFIX 46133
#define IDS_EXTENSION_WARNINGS_NETWORK_DELAY 46134
#define IDS_EXTENSION_WARNINGS_DOWNLOAD_FILENAME_CONFLICT 46135
#define IDS_EXTENSION_WARNING_RELOAD_TOO_FREQUENT 46136
#define IDS_EXTENSION_WARNING_RULESET_FAILED_TO_LOAD 46137
#define IDS_EXTENSION_WARNING_ENABLED_RULE_COUNT_EXCEEDED 46138
#define IDS_EXTENSION_INSTALL_PROCESS_CRASHED 46139
#define IDS_EXTENSION_PACKAGE_ERROR_CODE 46140
#define IDS_EXTENSION_PACKAGE_ERROR_MESSAGE 46141
#define IDS_EXTENSION_PACKAGE_INSTALL_ERROR 46142
#define IDS_EXTENSION_UNPACK_FAILED 46143
#define IDS_EXTENSION_WEBGL_NOT_SUPPORTED 46144

// ---------------------------------------------------------------------------
// From generated_resources.h:

#define IDS_ACCESS_CODE_CAST_ACCESS_CODE_MESSAGE 1600
#define IDS_ACCESS_CODE_CAST_BACK 1601
#define IDS_ACCESS_CODE_CAST_CAST 1602
#define IDS_ACCESS_CODE_CAST_CONNECT 1603
#define IDS_ACCESS_CODE_CAST_DIALOG_TITLE 1604
#define IDS_ACCESS_CODE_CAST_ENTER_CHARACTER 1605
#define IDS_ACCESS_CODE_CAST_ERROR_ACCESS_CODE 1606
#define IDS_ACCESS_CODE_CAST_ERROR_DIFFERENT_NETWORK 1607
#define IDS_ACCESS_CODE_CAST_ERROR_NETWORK 1608
#define IDS_ACCESS_CODE_CAST_ERROR_PERMISSION 1609
#define IDS_ACCESS_CODE_CAST_ERROR_TOO_MANY_REQUESTS 1610
#define IDS_ACCESS_CODE_CAST_ERROR_UNKNOWN 1611
#define IDS_ACCESS_CODE_CAST_ERROR_PROFILE_SYNC 1612
#define IDS_ACCESS_CODE_CAST_INPUT_ARIA_LABEL 1613
#define IDS_ACCESS_CODE_CAST_MANAGED_FOOTNOTE_DAYS 1614
#define IDS_ACCESS_CODE_CAST_MANAGED_FOOTNOTE_HOURS 1615
#define IDS_ACCESS_CODE_CAST_MANAGED_FOOTNOTE_MONTHS 1616
#define IDS_ACCESS_CODE_CAST_MANAGED_FOOTNOTE_YEARS 1617
#define IDS_ACCESS_CODE_CAST_SUBMIT 1618
#define IDS_ACCESS_CODE_CAST_USE_CAMERA 1619
#define IDS_BOOKMARK_GROUP_FROM_FIREFOX 1622
#define IDS_BOOKMARK_GROUP_FROM_SAFARI 1623
#define IDS_BOOKMARK_GROUP 1624
#define IDS_UNNAMED_BOOKMARK_BUTTON_ACCESSIBLE_NAME 1625
#define IDS_BOOKMARK_BAR_SHOW_APPS_SHORTCUT 1626
#define IDS_BOOKMARK_BAR_SHOW_TAB_GROUPS 1627
#define IDS_BOOKMARK_BAR_SHOW_READING_LIST 1628
#define IDS_BOOKMARK_BAR_SHOW_MANAGED_BOOKMARKS_DEFAULT_NAME 1629
#define IDS_BOOKMARK_BAR_SHOW_MANAGED_BOOKMARKS 1630
#define IDS_BOOKMARK_BAR_APPS_SHORTCUT_NAME 1631
#define IDS_BOOKMARK_BAR_APPS_SHORTCUT_TOOLTIP 1632
#define IDS_BOOKMARK_BAR_OVERFLOW_BUTTON_TOOLTIP 1633
#define IDS_BOOKMARK_BAR_OPEN_ALL 1634
#define IDS_BOOKMARK_BAR_OPEN_ALL_COUNT 1635
#define IDS_BOOKMARK_BAR_OPEN_ALL_COUNT_NEW_WINDOW 1636
#define IDS_BOOKMARK_BAR_OPEN_ALL_COUNT_INCOGNITO 1637
#define IDS_BOOKMARK_BAR_OPEN_ALL_COUNT_NEW_TAB_GROUP 1638
#define IDS_BOOKMARK_BAR_OPEN_IN_NEW_TAB 1639
#define IDS_BOOKMARK_BAR_OPEN_IN_NEW_WINDOW 1640
#define IDS_BOOKMARK_BAR_OPEN_INCOGNITO 1641
#define IDS_BOOKMARK_BAR_EDIT 1642
#define IDS_BOOKMARK_BAR_RENAME_FOLDER 1643
#define IDS_BOOKMARK_BAR_REMOVE 1644
#define IDS_BOOKMARK_BAR_ADD_NEW_BOOKMARK 1645
#define IDS_BOOKMARK_BAR_NEW_FOLDER 1646
#define IDS_SHOW_BOOKMARK_BAR 1647
#define IDS_HIDE_BOOKMARK_BAR 1648
#define IDS_BOOKMARK_BAR_SHOULD_OPEN_ALL 1649
#define IDS_BOOKMARK_BUBBLE_PAGE_BOOKMARKED 1650
#define IDS_BOOKMARK_BUBBLE_PAGE_BOOKMARK 1651
#define IDS_BOOKMARK_BUBBLE_EDIT_BOOKMARK 1652
#define IDS_BOOKMARK_BUBBLE_NAME_LABEL 1653
#define IDS_BOOKMARK_BUBBLE_SAVED_TO 1654
#define IDS_BOOKMARK_AX_BUBBLE_NAME_LABEL 1655
#define IDS_BOOKMARK_BUBBLE_FOLDER_LABEL 1656
#define IDS_BOOKMARK_AX_BUBBLE_FOLDER_LABEL 1657
#define IDS_BOOKMARK_BUBBLE_OPTIONS 1658
#define IDS_BOOKMARK_BUBBLE_CHOOSER_ANOTHER_FOLDER 1659
#define IDS_BOOKMARK_DICE_PROMO_SYNC_MESSAGE 1660
#define IDS_BOOKMARK_EDITOR_NAME_LABEL 1665
#define IDS_BOOKMARK_AX_EDITOR_NAME_LABEL 1666
#define IDS_BOOKMARK_AX_EDITOR_URL_LABEL 1668
#define IDS_BOOKMARK_EDITOR_URL_LABEL 1669
#define IDS_BOOKMARK_EDITOR_CONFIRM_DELETE 1670
#define IDS_BOOKMARK_EDITOR_NEW_FOLDER_BUTTON 1671
#define IDS_BOOKMARK_EDITOR_NEW_FOLDER_MENU_ITEM 1672
#define IDS_BOOKMARK_FOLDER_EDITOR_WINDOW_TITLE 1673
#define IDS_BOOKMARK_FOLDER_EDITOR_WINDOW_TITLE_NEW 1674
#define IDS_UNNAMED_BOOKMARK_FOLDER 1675
#define IDS_BOOKMARK_ALL_TABS_DIALOG_TITLE 1676
#define IDS_BOOKMARK_MANAGER_TITLE 1677
#define IDS_BOOKMARK_MANAGER_SEARCH_BUTTON 1678
#define IDS_BOOKMARK_MANAGER 1679
#define IDS_BOOKMARK_MANAGER_ORGANIZE_MENU 1680
#define IDS_BOOKMARK_MANAGER_INVALID_URL 1681
#define IDS_EXPORT_BOOKMARKS_DEFAULT_FILENAME 1682
#define IDS_BOOKMARK_MANAGER_ADD_BOOKMARK_TITLE 1683
#define IDS_BOOKMARK_MANAGER_ADD_FOLDER_TITLE 1684
#define IDS_BOOKMARK_MANAGER_CLEAR_SEARCH 1685
#define IDS_BOOKMARK_MANAGER_EMPTY_LIST 1686
#define IDS_BOOKMARK_MANAGER_EMPTY_UNMODIFIABLE_LIST 1687
#define IDS_BOOKMARK_MANAGER_FOLDER_LABEL 1688
#define IDS_BOOKMARK_MANAGER_FOLDER_RENAME_TITLE 1689
#define IDS_BOOKMARK_MANAGER_FOLDER_LIST_CHANGED 1690
#define IDS_BOOKMARK_MANAGER_LIST_AX_LABEL 1691
#define IDS_BOOKMARK_MANAGER_MENU_ADD_BOOKMARK 1692
#define IDS_BOOKMARK_MANAGER_MENU_ADD_FOLDER 1693
#define IDS_BOOKMARK_MANAGER_MENU_CUT 1694
#define IDS_BOOKMARK_MANAGER_MENU_COPY 1695
#define IDS_BOOKMARK_MANAGER_MENU_PASTE 1696
#define IDS_BOOKMARK_MANAGER_MENU_EXPORT 1697
#define IDS_BOOKMARK_MANAGER_MENU_HELP_CENTER 1698
#define IDS_BOOKMARK_MANAGER_MENU_IMPORT 1699
#define IDS_BOOKMARK_MANAGER_MENU_IMPORT_BEGAN 1700
#define IDS_BOOKMARK_MANAGER_MENU_IMPORT_ENDED 1701
#define IDS_BOOKMARK_MANAGER_MENU_OPEN_ALL 1702
#define IDS_BOOKMARK_MANAGER_MENU_OPEN_ALL_WITH_COUNT 1703
#define IDS_BOOKMARK_MANAGER_MENU_OPEN_ALL_NEW_WINDOW 1704
#define IDS_BOOKMARK_MANAGER_MENU_OPEN_ALL_NEW_WINDOW_WITH_COUNT 1705
#define IDS_BOOKMARK_MANAGER_MENU_OPEN_ALL_INCOGNITO 1706
#define IDS_BOOKMARK_MANAGER_MENU_OPEN_ALL_INCOGNITO_WITH_COUNT 1707
#define IDS_BOOKMARK_MANAGER_MENU_OPEN_ALL_NEW_TAB_GROUP_WITH_COUNT 1708
#define IDS_BOOKMARK_MANAGER_MENU_OPEN_IN_NEW_TAB 1709
#define IDS_BOOKMARK_MANAGER_MENU_OPEN_IN_NEW_WINDOW 1710
#define IDS_BOOKMARK_MANAGER_MENU_OPEN_INCOGNITO 1711
#define IDS_BOOKMARK_MANAGER_MENU_OPEN_IN_NEW_TAB_GROUP 1712
#define IDS_BOOKMARK_MANAGER_MENU_RENAME 1713
#define IDS_BOOKMARK_MANAGER_MENU_SHOW_IN_FOLDER 1714
#define IDS_BOOKMARK_MANAGER_MENU_SORT 1715
#define IDS_BOOKMARK_MANAGER_MORE_ACTIONS 1716
#define IDS_BOOKMARK_MANAGER_MORE_ACTIONS_AX_LABEL 1717
#define IDS_BOOKMARK_MANAGER_MORE_ACTIONS_MULTI_AX_LABEL 1718
#define IDS_BOOKMARK_MANAGER_OPEN_DIALOG_TITLE 1719
#define IDS_BOOKMARK_MANAGER_OPEN_DIALOG_CONFIRM 1720
#define IDS_BOOKMARK_MANAGER_ITEMS_SELECTED 1721
#define IDS_BOOKMARK_MANAGER_ITEMS_UNSELECTED 1722
#define IDS_BOOKMARK_MANAGER_SIDEBAR_AX_LABEL 1723
#define IDS_BOOKMARK_MANAGER_TOAST_FOLDER_SORTED 1724
#define IDS_BOOKMARK_MANAGER_TOAST_ITEM_DELETED 1725
#define IDS_BOOKMARK_MANAGER_TOAST_ITEMS_DELETED 1726
#define IDS_BOOKMARK_MANAGER_TOAST_ITEM_COPIED 1727
#define IDS_BOOKMARK_MANAGER_TOAST_ITEMS_COPIED 1728
#define IDS_BOOKMARKS_MENU 1729
#define IDS_BOOKMARKS_AND_LISTS_MENU 1730
#define IDS_SHOW_BOOKMARK_SIDE_PANEL 1731
#define IDS_BOOKMARK_THIS_TAB 1732
#define IDS_BOOKMARK_ALL_TABS 1733
#define IDS_BOOKMARKS_LIST_TITLE 1734
#define IDS_TOOLTIP_STARRED 1735
#define IDS_BOOKMARK_SCREEN_READER_CREATED 1736
#define IDS_BOOKMARK_SCREEN_READER_FOLDER_CREATED 1737
#define IDS_BOOKMARK_SCREEN_READER_REORDERED 1738
#define IDS_BOOKMARK_SCREEN_READER_MOVED 1739
#define IDS_APP_MANAGEMENT_CAMERA 1740
#define IDS_APP_MANAGEMENT_LOCATION 1741
#define IDS_APP_MANAGEMENT_MICROPHONE 1742
#define IDS_APP_MANAGEMENT_NO_APPS_FOUND 1743
#define IDS_APP_MANAGEMENT_NOTIFICATIONS 1744
#define IDS_APP_MANAGEMENT_PERMISSIONS 1746
#define IDS_APP_MANAGEMENT_PERMISSIONS_WITH_ORIGIN 1747
#define IDS_APP_MANAGEMENT_MORE_SETTINGS 1748
#define IDS_APP_MANAGEMENT_PIN_TO_SHELF 1749
#define IDS_APP_MANAGEMENT_PRESET_WINDOW_SIZES 1750
#define IDS_APP_MANAGEMENT_WINDOW 1751
#define IDS_APP_MANAGEMENT_PRESET_WINDOW_SIZES_TEXT 1752
#define IDS_APP_MANAGEMENT_PRINTING 1753
#define IDS_APP_MANAGEMENT_SEARCH_PROMPT 1754
#define IDS_APP_MANAGEMENT_UNINSTALL_APP 1755
#define IDS_APP_MANAGEMENT_CONTACTS 1756
#define IDS_APP_MANAGEMENT_STORAGE 1757
#define IDS_APP_MANAGEMENT_RUN_ON_OS_LOGIN 1758
#define IDS_APP_MANAGEMENT_POLICY_APP_POLICY_STRING 1759
#define IDS_APP_MANAGEMENT_INTENT_SETTINGS_TITLE 1760
#define IDS_APP_MANAGEMENT_INTENT_SHARING_APP_OPEN 1761
#define IDS_APP_MANAGEMENT_INTENT_SHARING_BROWSER_OPEN 1762
#define IDS_APP_MANAGEMENT_INTENT_SHARING_TAB_EXPLANATION 1763
#define IDS_APP_MANAGEMENT_INTENT_SETTINGS_DIALOG_TITLE 1764
#define IDS_APP_MANAGEMENT_INTENT_OVERLAP_CHANGE_BUTTON 1765
#define IDS_APP_MANAGEMENT_INTENT_OVERLAP_DIALOG_TITLE 1766
#define IDS_APP_MANAGEMENT_INTENT_OVERLAP_DIALOG_TEXT_1_APP 1767
#define IDS_APP_MANAGEMENT_INTENT_OVERLAP_DIALOG_TEXT_2_APPS 1768
#define IDS_APP_MANAGEMENT_INTENT_OVERLAP_DIALOG_TEXT_3_APPS 1769
#define IDS_APP_MANAGEMENT_INTENT_OVERLAP_DIALOG_TEXT_4_APPS 1770
#define IDS_APP_MANAGEMENT_INTENT_OVERLAP_DIALOG_TEXT_5_OR_MORE_APPS 1771
#define IDS_APP_MANAGEMENT_INTENT_OVERLAP_WARNING_TEXT_1_APP 1772
#define IDS_APP_MANAGEMENT_INTENT_OVERLAP_WARNING_TEXT_2_APPS 1773
#define IDS_APP_MANAGEMENT_INTENT_OVERLAP_WARNING_TEXT_3_APPS 1774
#define IDS_APP_MANAGEMENT_INTENT_OVERLAP_WARNING_TEXT_4_APPS 1775
#define IDS_APP_MANAGEMENT_INTENT_OVERLAP_WARNING_TEXT_5_OR_MORE_APPS 1776
#define IDS_APP_MANAGEMENT_APP_DETAILS_TITLE 1777
#define IDS_APP_MANAGEMENT_APP_DETAILS_TOOLTIP_WEB_A11Y 1778
#define IDS_APP_MANAGEMENT_APP_DETAILS_TYPE_ANDROID 1779
#define IDS_APP_MANAGEMENT_APP_DETAILS_TYPE_CHROME 1780
#define IDS_APP_MANAGEMENT_APP_DETAILS_TYPE_WEB 1781
#define IDS_APP_MANAGEMENT_APP_DETAILS_TYPE_CROS_SYSTEM 1782
#define IDS_APP_MANAGEMENT_APP_DETAILS_INSTALL_SOURCE_WEB_STORE 1783
#define IDS_APP_MANAGEMENT_APP_DETAILS_INSTALL_SOURCE_PLAY_STORE 1784
#define IDS_APP_MANAGEMENT_APP_DETAILS_INSTALL_SOURCE_BROWSER 1785
#define IDS_APP_MANAGEMENT_APP_DETAILS_TYPE_AND_SOURCE_COMBINED 1786
#define IDS_APP_MANAGEMENT_APP_DETAILS_TYPE_AND_SOURCE_PREINSTALLED_APP 1787
#define IDS_APP_MANAGEMENT_APP_DETAILS_VERSION 1788
#define IDS_APP_MANAGEMENT_APP_DETAILS_STORAGE_TITLE 1789
#define IDS_APP_MANAGEMENT_APP_DETAILS_APP_SIZE 1790
#define IDS_APP_MANAGEMENT_APP_DETAILS_DATA_SIZE 1791
#define IDS_APP_MANAGEMENT_APP_LANGUAGE_LABEL 1792
#define IDS_APP_MANAGEMENT_ARC_MANAGE_PERMISSIONS 1793
#define IDS_APP_MANAGEMENT_PERMISSION_ASK 1794
#define IDS_APP_MANAGEMENT_PERMISSION_ALLOWED 1795
#define IDS_APP_MANAGEMENT_PERMISSION_ALLOWED_WITH_DETAILS 1796
#define IDS_APP_MANAGEMENT_PERMISSION_DENIED 1797
#define IDS_APP_MANAGEMENT_PERMISSION_ALLOWED_TEXT_WITH_TURN_ON_SYSTEM_CAMERA_ACCESS_BUTTON 1798
#define IDS_APP_MANAGEMENT_PERMISSION_ALLOWED_TEXT_WITH_TURN_ON_SYSTEM_MICROPHONE_ACCESS_BUTTON 1799
#define IDS_APP_MANAGEMENT_PERMISSION_ALLOWED_TEXT_WITH_TURN_ON_SYSTEM_LOCATION_ACCESS_BUTTON 1800
#define IDS_APP_MANAGEMENT_PERMISSION_ALLOWED_TEXT_WITH_DETAILS_AND_TURN_ON_SYSTEM_CAMERA_ACCESS_BUTTON 1801
#define IDS_APP_MANAGEMENT_PERMISSION_ALLOWED_TEXT_WITH_DETAILS_AND_TURN_ON_SYSTEM_MICROPHONE_ACCESS_BUTTON 1802
#define IDS_APP_MANAGEMENT_PERMISSION_ALLOWED_TEXT_WITH_DETAILS_AND_TURN_ON_SYSTEM_LOCATION_ACCESS_BUTTON 1803
#define IDS_APP_MANAGEMENT_PERMISSION_ALLOWED_BUT_NO_CAMERA_CONNECTED_TEXT 1804
#define IDS_APP_MANAGEMENT_PERMISSION_ALLOWED_BUT_NO_MICROPHONE_CONNECTED_TEXT 1805
#define IDS_APP_MANAGEMENT_PERMISSION_ALLOWED_BUT_NO_CAMERA_CONNECTED_TEXT_WITH_DETAILS 1806
#define IDS_APP_MANAGEMENT_PERMISSION_ALLOWED_BUT_NO_MICROPHONE_CONNECTED_TEXT_WITH_DETAILS 1807
#define IDS_APP_MANAGEMENT_PERMISSION_ALLOWED_BUT_MICROPHONE_HW_SWITCH_ACTIVE_TEXT 1808
#define IDS_APP_MANAGEMENT_PERMISSION_ALLOWED_BUT_MICROPHONE_HW_SWITCH_ACTIVE_TEXT_WITH_DETAILS 1809
#define IDS_APP_MANAGEMENT_FILE_HANDLING_HEADER 1810
#define IDS_APP_MANAGEMENT_FILE_HANDLING_OVERFLOW_DIALOG_TITLE 1811
#define IDS_APP_MANAGEMENT_FILE_HANDLING_SET_DEFAULTS_LINK 1812
#define IDS_APP_MANAGEMENT_FILE_HANDLING_TYPES 1813
#define IDS_APP_MANAGEMENT_SUB_APPS_LIST_HEADING 1814
#define IDS_APP_MANAGEMENT_PARENT_APP_PERMISSION_EXPLANATION 1815
#define IDS_APP_MANAGEMENT_SUB_APP_PERMISSION_EXPLANATION 1816
#define IDS_APP_MANAGEMENT_APP_CONTENT_TITLE 1817
#define IDS_APP_MANAGEMENT_APP_CONTENT_SUBTITLE 1818
#define IDS_APP_MANAGEMENT_APP_CONTENT_DIALOG_SUBTITLE 1819
#define IDS_MEDIA_ROUTER_ICON_TOOLTIP_TEXT 1820
#define IDS_MEDIA_ROUTER_MENU_ITEM_TITLE 1821
#define IDS_MEDIA_ROUTER_PRESENTATION_CAST_MODE 1822
#define IDS_MEDIA_ROUTER_DESKTOP_MIRROR_CAST_MODE 1823
#define IDS_MEDIA_ROUTER_TAB_MIRROR_CAST_MODE 1824
#define IDS_MEDIA_ROUTER_ALTERNATIVE_SOURCES_BUTTON 1825
#define IDS_MEDIA_ROUTER_ABOUT 1826
#define IDS_MEDIA_ROUTER_HELP 1827
#define IDS_MEDIA_ROUTER_ALWAYS_SHOW_TOOLBAR_ACTION 1828
#define IDS_MEDIA_ROUTER_SHOWN_BY_POLICY 1829
#define IDS_MEDIA_ROUTER_TOGGLE_MEDIA_REMOTING 1830
#define IDS_MEDIA_ROUTER_ISSUE_CREATE_ROUTE_TIMEOUT_WITH_HOSTNAME 1831
#define IDS_MEDIA_ROUTER_ISSUE_CREATE_ROUTE_TIMEOUT 1832
#define IDS_MEDIA_ROUTER_ISSUE_CREATE_ROUTE_TIMEOUT_FOR_DESKTOP 1833
#define IDS_MEDIA_ROUTER_ISSUE_CREATE_ROUTE_TIMEOUT_FOR_TAB 1834
#define IDS_MEDIA_ROUTER_ISSUE_UNABLE_TO_CAST_DESKTOP 1835
#define IDS_MEDIA_ROUTER_ISSUE_TAB_AUDIO_NOT_SUPPORTED 1836
#define IDS_MEDIA_ROUTER_ISSUE_DESKTOP_AUDIO_NOT_SUPPORTED 1837
#define IDS_MEDIA_ROUTER_ISSUE_CREATE_ROUTE_USER_PENDING_AUTHORIZATION 1839
#define IDS_MEDIA_ROUTER_ISSUE_CREATE_ROUTE_USER_NOT_ALLOWED 1840
#define IDS_MEDIA_ROUTER_ISSUE_CREATE_ROUTE_NOTIFICATION_DISABLED 1841
#define IDS_MEDIA_ROUTER_ISSUE_FAILED_TO_CAST 1842
#define IDS_MEDIA_ROUTER_ISSUE_CANNOT_TERMINATE 1843
#define IDS_MEDIA_ROUTER_STATUS_LOOKING_FOR_DEVICES 1844
#define IDS_MEDIA_ROUTER_STATUS_NO_DEVICES_FOUND 1845
#define IDS_MEDIA_ROUTER_NO_DEVICES_FOUND_BUTTON 1846
#define IDS_MEDIA_ROUTER_DESTINATION_MISSING 1847
#define IDS_MEDIA_ROUTER_SINK_AVAILABLE 1848
#define IDS_MEDIA_ROUTER_SINK_CONNECTING 1849
#define IDS_MEDIA_ROUTER_SINK_DISCONNECTING 1850
#define IDS_MEDIA_ROUTER_SINK_PAUSED 1851
#define IDS_MEDIA_ROUTER_STOP_CASTING 1852
#define IDS_MEDIA_ROUTER_SOURCE_NOT_SUPPORTED 1853
#define IDS_MEDIA_ROUTER_AVAILABLE_SPECIFIC_SITES 1854
#define IDS_MEDIA_ROUTER_CASTING_DESKTOP 1855
#define IDS_MEDIA_ROUTER_CASTING_TAB 1856
#define IDS_MEDIA_ROUTER_PRESENTATION_ROUTE_DESCRIPTION 1857
#define IDS_MEDIA_ROUTER_SINK_VIEW_PAUSE 1858
#define IDS_MEDIA_ROUTER_SINK_VIEW_PAUSE_GENERIC_ACCESSIBLE_NAME 1859
#define IDS_MEDIA_ROUTER_SINK_VIEW_PAUSE_SCREEN_ACCESSIBLE_NAME 1860
#define IDS_MEDIA_ROUTER_SINK_VIEW_PAUSE_TAB_ACCESSIBLE_NAME 1861
#define IDS_MEDIA_ROUTER_SINK_VIEW_RESUME 1862
#define IDS_MEDIA_ROUTER_SINK_VIEW_RESUME_GENERIC_ACCESSIBLE_NAME 1863
#define IDS_MEDIA_ROUTER_SINK_VIEW_RESUME_SCREEN_ACCESSIBLE_NAME 1864
#define IDS_MEDIA_ROUTER_SINK_VIEW_RESUME_TAB_ACCESSIBLE_NAME 1865
#define IDS_MEDIA_ROUTER_SINK_VIEW_STOP 1866
#define IDS_MEDIA_ROUTER_SINK_VIEW_STOP_GENERIC_ACCESSIBLE_NAME 1867
#define IDS_MEDIA_ROUTER_SINK_VIEW_STOP_SCREEN_ACCESSIBLE_NAME 1868
#define IDS_MEDIA_ROUTER_SINK_VIEW_STOP_TAB_ACCESSIBLE_NAME 1869
#define IDS_MEDIA_ROUTER_REMOTING_DIALOG_TITLE 1870
#define IDS_MEDIA_ROUTER_REMOTING_DIALOG_BODY_TEXT 1871
#define IDS_MEDIA_ROUTER_REMOTING_DIALOG_CHECKBOX 1872
#define IDS_MEDIA_ROUTER_REMOTING_DIALOG_OPTIMIZE_BUTTON 1873
#define IDS_MEDIA_ROUTER_REMOTING_DIALOG_CANCEL_BUTTON 1874
#define IDS_MEDIA_ROUTER_REMOTING_DIALOG_CANCEL_BUTTON_MACOS 1875
#define IDS_MEDIA_ROUTER_CAST_TO_MEETING_DEPRECATED 1876
#define IDS_MEDIA_ROUTER_CAST_TO_MEETING_REMOVED 1877
#define IDS_MEDIA_ROUTER_WIRED_DISPLAY_SINK_NAME 1878
#define IDS_MEDIA_ROUTER_FEEDBACK_TITLE 1879
#define IDS_MEDIA_ROUTER_FEEDBACK_NA 1880
#define IDS_MEDIA_ROUTER_FEEDBACK_FORM_DESCRIPTION 1881
#define IDS_MEDIA_ROUTER_FEEDBACK_HEADER 1882
#define IDS_MEDIA_ROUTER_FEEDBACK_YOUR_ANSWER 1883
#define IDS_MEDIA_ROUTER_FEEDBACK_REQUIRED 1884
#define IDS_MEDIA_ROUTER_FEEDBACK_TYPE_QUESTION 1885
#define IDS_MEDIA_ROUTER_FEEDBACK_PROMPT 1886
#define IDS_MEDIA_ROUTER_FEEDBACK_MIRRORING_QUALITY_SUBHEADING 1887
#define IDS_MEDIA_ROUTER_FEEDBACK_VIDEO_SMOOTHNESS 1888
#define IDS_MEDIA_ROUTER_FEEDBACK_VIDEO_QUALITY 1889
#define IDS_MEDIA_ROUTER_FEEDBACK_AUDIO_QUALITY 1890
#define IDS_MEDIA_ROUTER_FEEDBACK_CONTENT_QUESTION 1891
#define IDS_MEDIA_ROUTER_FEEDBACK_ADDITIONAL_COMMENTS 1892
#define IDS_MEDIA_ROUTER_FEEDBACK_ALLOW_CONTACT_BY_EMAIL 1893
#define IDS_MEDIA_ROUTER_FEEDBACK_YOUR_EMAIL_ADDRESS 1894
#define IDS_MEDIA_ROUTER_FEEDBACK_EMAIL_FIELD 1895
#define IDS_MEDIA_ROUTER_FEEDBACK_SEND_BUTTON 1896
#define IDS_MEDIA_ROUTER_FEEDBACK_DISCARD_CONFIRMATION 1897
#define IDS_MEDIA_ROUTER_FEEDBACK_TYPE_BUG_OR_ERROR 1898
#define IDS_MEDIA_ROUTER_FEEDBACK_TYPE_FEATURE_REQUEST 1899
#define IDS_MEDIA_ROUTER_FEEDBACK_TYPE_PROJECTION_QUALITY 1900
#define IDS_MEDIA_ROUTER_FEEDBACK_TYPE_DISCOVERY 1901
#define IDS_MEDIA_ROUTER_FEEDBACK_TYPE_OTHER 1902
#define IDS_MEDIA_ROUTER_FEEDBACK_VIDEO_FREEZES 1903
#define IDS_MEDIA_ROUTER_FEEDBACK_VIDEO_JERKY 1904
#define IDS_MEDIA_ROUTER_FEEDBACK_VIDEO_STUTTER 1905
#define IDS_MEDIA_ROUTER_FEEDBACK_VIDEO_SMOOTH 1906
#define IDS_MEDIA_ROUTER_FEEDBACK_VIDEO_PERFECT 1907
#define IDS_MEDIA_ROUTER_FEEDBACK_VIDEO_UNWATCHABLE 1908
#define IDS_MEDIA_ROUTER_FEEDBACK_VIDEO_POOR 1909
#define IDS_MEDIA_ROUTER_FEEDBACK_VIDEO_ACCEPTABLE 1910
#define IDS_MEDIA_ROUTER_FEEDBACK_VIDEO_GOOD 1911
#define IDS_MEDIA_ROUTER_FEEDBACK_VIDEO_GREAT 1912
#define IDS_MEDIA_ROUTER_FEEDBACK_AUDIO_UNINTELLIGIBLE 1913
#define IDS_MEDIA_ROUTER_FEEDBACK_AUDIO_POOR 1914
#define IDS_MEDIA_ROUTER_FEEDBACK_AUDIO_ACCEPTABLE 1915
#define IDS_MEDIA_ROUTER_FEEDBACK_AUDIO_GOOD 1916
#define IDS_MEDIA_ROUTER_FEEDBACK_AUDIO_PERFECT 1917
#define IDS_MEDIA_ROUTER_FEEDBACK_SENDING 1918
#define IDS_MEDIA_ROUTER_FEEDBACK_SEND_FAIL 1919
#define IDS_MEDIA_ROUTER_FEEDBACK_SEND_SUCCESS 1920
#define IDS_MEDIA_ROUTER_FEEDBACK_RESENDING 1921
#define IDS_MEDIA_ROUTER_FEEDBACK_LOGS_HEADER 1922
#define IDS_MEDIA_ROUTER_FEEDBACK_FINE_LOGS_WARNING 1923
#define IDS_MEDIA_ROUTER_FEEDBACK_SEND_LOGS_HTML 1924
#define IDS_MEDIA_ROUTER_FEEDBACK_SEND_LOGS 1925
#define IDS_MEDIA_ROUTER_FEEDBACK_PRIVACY_DATA_USAGE 1926
#define IDS_MEDIA_ROUTER_FEEDBACK_SETUP_VISIBILITY_QUESTION 1927
#define IDS_MEDIA_ROUTER_FEEDBACK_YES 1928
#define IDS_MEDIA_ROUTER_FEEDBACK_NO 1929
#define IDS_MEDIA_ROUTER_FEEDBACK_DID_NOT_TRY 1930
#define IDS_MEDIA_ROUTER_FEEDBACK_SOFTWARE_QUESTION 1931
#define IDS_MEDIA_ROUTER_FEEDBACK_UNKNOWN 1932
#define IDS_MEDIA_ROUTER_FEEDBACK_NETWORK_QUESTION 1933
#define IDS_MEDIA_ROUTER_FEEDBACK_NETWORK_SAME_WIFI 1934
#define IDS_MEDIA_ROUTER_FEEDBACK_NETWORK_DIFFERENT_WIFI 1935
#define IDS_MEDIA_ROUTER_FEEDBACK_NETWORK_WIRED_PC 1936
#define IDS_MEDIA_ROUTER_NOTIFICATION_MESSAGE_CAST_SCREEN 1937
#define IDS_MEDIA_ROUTER_NOTIFICATION_MESSAGE_PAUSED 1938
#define IDS_MEDIA_ROUTER_NOTIFICATION_MESSAGE_SCREEN_CAN_PAUSE 1939
#define IDS_MEDIA_ROUTER_NOTIFICATION_MESSAGE_SCREEN_PAUSED 1940
#define IDS_MEDIA_ROUTER_NOTIFICATION_MESSAGE_TAB_CAN_PAUSE 1941
#define IDS_MEDIA_ROUTER_NOTIFICATION_TITLE 1942
#define IDS_MEDIA_ROUTER_NOTIFICATION_TITLE_UNKNOWN 1943
#define IDS_GLOBAL_MEDIA_CONTROLS_ICON_TOOLTIP_TEXT 1944
#define IDS_GLOBAL_MEDIA_CONTROLS_DEVICES_LABEL_WITH_COLON 1945
#define IDS_GLOBAL_MEDIA_CONTROLS_DEVICES_LABEL 1946
#define IDS_GLOBAL_MEDIA_CONTROLS_STOP_CASTING_BUTTON_LABEL 1947
#define IDS_GLOBAL_MEDIA_CONTROLS_LIVE_CAPTION_ENGLISH_ONLY 1948
#define IDS_GLOBAL_MEDIA_CONTROLS_LIVE_CAPTION 1949
#define IDS_GLOBAL_MEDIA_CONTROLS_LIVE_CAPTION_SHOW_LANGUAGE 1950
#define IDS_GLOBAL_MEDIA_CONTROLS_LIVE_CAPTION_DOWNLOAD_PROGRESS 1951
#define IDS_GLOBAL_MEDIA_CONTROLS_LIVE_CAPTION_DOWNLOAD_ERROR 1952
#define IDS_GLOBAL_MEDIA_CONTROLS_LIVE_CAPTION_DOWNLOAD_ERROR_REBOOT_REQUIRED 1953
#define IDS_GLOBAL_MEDIA_CONTROLS_CAPTION_SETTINGS 1954
#define IDS_GLOBAL_MEDIA_CONTROLS_LIVE_TRANSLATE_TARGET_LANGUAGE_ACCNAME 1955
#define IDS_GLOBAL_MEDIA_CONTROLS_DIALOG_NAME 1956
#define IDS_GLOBAL_MEDIA_CONTROLS_SHOW_DEVICE_LIST 1957
#define IDS_GLOBAL_MEDIA_CONTROLS_HIDE_DEVICE_LIST 1958
#define IDS_GLOBAL_MEDIA_CONTROLS_CONTROL_CAST_SESSIONS_PROMO 1959
#define IDS_GMC_LOCAL_MEDIA_CAST_SESSIONS_PROMO 1960
#define IDS_GMC_LOCAL_MEDIA_CAST_START_PROMO 1961
#define IDS_MEDIA_TOOLBAR_CONTEXT_REPORT_CAST_ISSUE 1962
#define IDS_MEDIA_TOOLBAR_CONTEXT_SHOW_OTHER_SESSIONS 1963
#define IDS_MEDIA_PREVIEW_CAMERA_ACCESSIBLE_NAME 1964
#define IDS_MEDIA_PREVIEW_VIDEO_STREAM_ACCESSIBLE_NAME 1965
#define IDS_MEDIA_PREVIEW_NO_CAMERAS_FOUND 1966
#define IDS_MEDIA_PREVIEW_NO_CAMERAS_FOUND_COMBOBOX 1967
#define IDS_MEDIA_PREVIEW_VIDEO_STREAM_PREVIEW_BADGE 1968
#define IDS_MEDIA_PREVIEW_MIC_ACCESSIBLE_NAME 1969
#define IDS_MEDIA_PREVIEW_AUDIO_STREAM_ACCESSIBLE_NAME 1970
#define IDS_MEDIA_PREVIEW_NO_MICS_FOUND 1971
#define IDS_MEDIA_PREVIEW_NO_MICS_FOUND_COMBOBOX 1972
#define IDS_MEDIA_PREVIEW_SYSTEM_DEFAULT_MIC 1973
#define IDS_MEDIA_PREVIEW_SYSTEM_DEFAULT_MIC_PARENTHETICAL 1974
#define IDS_MEDIA_PREVIEW_ANNOUNCE_SELECTED_DEVICE_CHANGE 1975
#define IDS_AVATAR_BUTTON_GUEST 1976
#define IDS_AVATAR_BUTTON_GUEST_TOOLTIP 1977
#define IDS_GUEST_BUBBLE_ACCESSIBLE_TITLE 1978
#define IDS_INCOGNITO_BUBBLE_ACCESSIBLE_TITLE 1979
#define IDS_AVATAR_BUTTON_INCOGNITO 1980
#define IDS_AVATAR_BUTTON_INCOGNITO_TOOLTIP 1981
#define IDS_AVATAR_BUTTON_SYNC_ERROR 1982
#define IDS_AVATAR_BUTTON_SYNC_ERROR_TOOLTIP 1983
#define IDS_AVATAR_BUTTON_SYNC_PAUSED 1984
#define IDS_AVATAR_BUTTON_SIGNIN_PAUSED 1985
#define IDS_AVATAR_BUTTON_WORK 1986
#define IDS_AVATAR_BUTTON_SCHOOL 1987
#define IDS_AVATAR_BUTTON_GREETING 1988
#define IDS_PROFILES_MENU_NAME 1989
#define IDS_PROFILES_ADD_PROFILE_LABEL 1991
#define IDS_PROFILES_PROFILE_BUBBLE_ACCESSIBLE_TITLE 1992
#define IDS_PROFILES_EXIT_PROFILE_BUTTON 1993
#define IDS_PROFILES_GAIA_SIGNIN_TITLE 1994
#define IDS_PROFILES_ACCOUNT_REMOVAL_TITLE 1995
#define IDS_PROFILES_SYNC_COMPLETE_TITLE 1996
#define IDS_PROFILES_DICE_SIGNIN_BUTTON 1997
#define IDS_PROFILES_DICE_WEB_ONLY_SIGNIN_BUTTON 1998
#define IDS_PROFILES_DICE_NOT_SYNCING_TITLE 1999
#define IDS_PROFILES_DICE_SIGNIN_FIRST_ACCOUNT_BUTTON 2000
#define IDS_PROFILES_DICE_SIGNIN_FIRST_ACCOUNT_BUTTON_NO_NAME 2001
#define IDS_PROFILES_DICE_SYNC_DISABLED_TITLE 2002
#define IDS_PROFILES_DICE_SYNC_PAUSED_TITLE 2003
#define IDS_PROFILES_CLOSE_X_WINDOWS_BUTTON 2004
#define IDS_PROFILES_SIGNIN_PROMO 2005
#define IDS_PROFILES_VERIFY_ACCOUNT_BUTTON 2006
#define IDS_PROFILES_CREDIT_CARDS_LINK 2007
#define IDS_PROFILES_ADDRESSES_LINK 2008
#define IDS_PROFILE_MENU_SIGNIN_PROMO_DESCRIPTION 2009
#define IDS_PROFILES_LIST_PROFILES_TITLE 2010
#define IDS_PROFILES_PROFILE_MANAGE_ACCOUNTS_BUTTON 2011
#define IDS_PROFILES_PROFILE_HIDE_MANAGE_ACCOUNTS_BUTTON 2012
#define IDS_PROFILE_MENU_OPEN_GUEST_PROFILE 2013
#define IDS_PROFILE_MENU_CLOSE_PROFILE_X_WINDOWS_BUTTON 2014
#define IDS_PROFILE_MENU_ADD_NEW_PROFILE 2015
#define IDS_PROFILES_OPEN_SYNC_SETTINGS_BUTTON 2016
#define IDS_PROFILE_MENU_CUSTOMIZE_PROFILE_BUTTON 2017
#define IDS_PROFILES_MANAGED_BY 2018
#define IDS_PROFILES_MANAGE_PROFILES_BUTTON_TOOLTIP 2019
#define IDS_PROFILES_MANAGE_PROFILES_MANAGED_TOOLTIP 2020
#define IDS_PROFILES_CUSTOMIZE_PROFILE_BUTTON_TOOLTIP 2021
#define IDS_PROFILES_GUEST_PROFILE_NAME 2022
#define IDS_DEFAULT_PROFILE_NAME 2023
#define IDS_LEGACY_DEFAULT_PROFILE_NAME 2024
#define IDS_NUMBERED_PROFILE_NAME 2025
#define IDS_NEW_NUMBERED_PROFILE_NAME 2026
#define IDS_SINGLE_PROFILE_DISPLAY_NAME 2027
#define IDS_GUEST_PROFILE_NAME 2028
#define IDS_DEFAULT_AVATAR_NAME_8 2029
#define IDS_DEFAULT_AVATAR_NAME_9 2030
#define IDS_DEFAULT_AVATAR_NAME_10 2031
#define IDS_DEFAULT_AVATAR_NAME_11 2032
#define IDS_DEFAULT_AVATAR_NAME_12 2033
#define IDS_DEFAULT_AVATAR_NAME_13 2034
#define IDS_DEFAULT_AVATAR_NAME_14 2035
#define IDS_DEFAULT_AVATAR_NAME_15 2036
#define IDS_DEFAULT_AVATAR_NAME_16 2037
#define IDS_DEFAULT_AVATAR_NAME_17 2038
#define IDS_DEFAULT_AVATAR_NAME_18 2039
#define IDS_DEFAULT_AVATAR_NAME_19 2040
#define IDS_DEFAULT_AVATAR_NAME_20 2041
#define IDS_DEFAULT_AVATAR_NAME_21 2042
#define IDS_DEFAULT_AVATAR_NAME_22 2043
#define IDS_DEFAULT_AVATAR_NAME_23 2044
#define IDS_DEFAULT_AVATAR_NAME_24 2045
#define IDS_DEFAULT_AVATAR_NAME_25 2046
#define IDS_DEFAULT_AVATAR_NAME_26 2047
#define IDS_DEFAULT_AVATAR_LABEL_0 2048
#define IDS_DEFAULT_AVATAR_LABEL_1 2049
#define IDS_DEFAULT_AVATAR_LABEL_2 2050
#define IDS_DEFAULT_AVATAR_LABEL_3 2051
#define IDS_DEFAULT_AVATAR_LABEL_4 2052
#define IDS_DEFAULT_AVATAR_LABEL_5 2053
#define IDS_DEFAULT_AVATAR_LABEL_6 2054
#define IDS_DEFAULT_AVATAR_LABEL_7 2055
#define IDS_DEFAULT_AVATAR_LABEL_8 2056
#define IDS_DEFAULT_AVATAR_LABEL_9 2057
#define IDS_DEFAULT_AVATAR_LABEL_10 2058
#define IDS_DEFAULT_AVATAR_LABEL_11 2059
#define IDS_DEFAULT_AVATAR_LABEL_12 2060
#define IDS_DEFAULT_AVATAR_LABEL_13 2061
#define IDS_DEFAULT_AVATAR_LABEL_14 2062
#define IDS_DEFAULT_AVATAR_LABEL_15 2063
#define IDS_DEFAULT_AVATAR_LABEL_16 2064
#define IDS_DEFAULT_AVATAR_LABEL_17 2065
#define IDS_DEFAULT_AVATAR_LABEL_18 2066
#define IDS_DEFAULT_AVATAR_LABEL_19 2067
#define IDS_DEFAULT_AVATAR_LABEL_20 2068
#define IDS_DEFAULT_AVATAR_LABEL_21 2069
#define IDS_DEFAULT_AVATAR_LABEL_22 2070
#define IDS_DEFAULT_AVATAR_LABEL_23 2071
#define IDS_DEFAULT_AVATAR_LABEL_24 2072
#define IDS_DEFAULT_AVATAR_LABEL_25 2073
#define IDS_DEFAULT_AVATAR_LABEL_26 2074
#define IDS_DEFAULT_AVATAR_LABEL_27 2075
#define IDS_DEFAULT_AVATAR_LABEL_28 2076
#define IDS_DEFAULT_AVATAR_LABEL_29 2077
#define IDS_DEFAULT_AVATAR_LABEL_30 2078
#define IDS_DEFAULT_AVATAR_LABEL_31 2079
#define IDS_DEFAULT_AVATAR_LABEL_32 2080
#define IDS_DEFAULT_AVATAR_LABEL_33 2081
#define IDS_DEFAULT_AVATAR_LABEL_34 2082
#define IDS_DEFAULT_AVATAR_LABEL_35 2083
#define IDS_DEFAULT_AVATAR_LABEL_36 2084
#define IDS_DEFAULT_AVATAR_LABEL_37 2085
#define IDS_DEFAULT_AVATAR_LABEL_38 2086
#define IDS_DEFAULT_AVATAR_LABEL_39 2087
#define IDS_DEFAULT_AVATAR_LABEL_40 2088
#define IDS_DEFAULT_AVATAR_LABEL_41 2089
#define IDS_DEFAULT_AVATAR_LABEL_42 2090
#define IDS_DEFAULT_AVATAR_LABEL_43 2091
#define IDS_DEFAULT_AVATAR_LABEL_44 2092
#define IDS_DEFAULT_AVATAR_LABEL_45 2093
#define IDS_DEFAULT_AVATAR_LABEL_46 2094
#define IDS_DEFAULT_AVATAR_LABEL_47 2095
#define IDS_DEFAULT_AVATAR_LABEL_48 2096
#define IDS_DEFAULT_AVATAR_LABEL_49 2097
#define IDS_DEFAULT_AVATAR_LABEL_50 2098
#define IDS_DEFAULT_AVATAR_LABEL_51 2099
#define IDS_DEFAULT_AVATAR_LABEL_52 2100
#define IDS_DEFAULT_AVATAR_LABEL_53 2101
#define IDS_DEFAULT_AVATAR_LABEL_54 2102
#define IDS_DEFAULT_AVATAR_LABEL_55 2103
#define IDS_PROFILES_LOCAL_PROFILE_STATE 2104
#define IDS_PROFILES_CREATE_BUTTON_LABEL 2105
#define IDS_PROFILES_MANAGE_BUTTON_LABEL 2106
#define IDS_PROFILES_DEFAULT_NAME 2107
#define IDS_SYNC_LOGIN_NAME_PROHIBITED 2108
#define IDS_SUPERVISED_USER_NOT_ALLOWED_BY_POLICY 2109
#define IDS_OLD_PROFILES_DISABLED_TITLE 2110
#define IDS_OLD_PROFILES_DISABLED_MESSAGE 2111
#define IDS_OLD_PROFILES_DISABLED_ADD_PERSON_SUGGESTION 2112
#define IDS_OLD_PROFILES_DISABLED_ADD_PERSON_SUGGESTION_WITH_DOMAIN 2113
#define IDS_OLD_PROFILES_DISABLED_REMOVED_OLD_PROFILE 2114
#define IDS_SYNC_USER_NAME_IN_USE_ERROR 2115
#define IDS_SYNC_USER_NAME_IN_USE_BY_ERROR 2116
#define IDS_SCREEN_LOCK_SIGN_OUT 2117
#define IDS_PROFILE_CUSTOMIZATION_DONE_BUTTON_LABEL 2123
#define IDS_PROFILE_CUSTOMIZATION_THEMES_CONTAINER_LABEL 2124
#define IDS_PROFILE_CUSTOMIZATION_WELCOME 2125
#define IDS_PROFILE_CUSTOMIZATION_INPUT_LABEL 2126
#define IDS_PROFILE_CUSTOMIZATION_INPUT_PLACEHOLDER 2127
#define IDS_PROFILE_CUSTOMIZATION_INPUT_ERROR_MESSAGE 2128
#define IDS_PROFILE_CUSTOMIZATION_SKIP_BUTTON_LABEL 2129
#define IDS_PROFILE_CUSTOMIZATION_DELETE_PROFILE_BUTTON_LABEL 2130
#define IDS_PROFILE_CUSTOMIZATION_LOCAL_PROFILE_CREATION_TITLE 2131
#define IDS_PROFILE_CUSTOMIZATION_AVATAR_SELECTION_BACK_BUTTON_LABEL 2132
#define IDS_ENTERPRISE_PROFILE_WELCOME_TITLE 2133
#define IDS_ENTERPRISE_PROFILE_WELCOME_ACCOUNT_MANAGED_BY 2134
#define IDS_ENTERPRISE_PROFILE_WELCOME_PROFILE_MANAGED_STRICT_SEPARATION 2135
#define IDS_ENTERPRISE_PROFILE_WELCOME_PROFILE_MANAGED_SEPARATION 2136
#define IDS_ENTERPRISE_PROFILE_WELCOME_PROFILE_SEPARATION_DEVICE_MANAGED 2137
#define IDS_ENTERPRISE_PROFILE_WELCOME_PROFILE_SEPARATION_ACCOUNT_MANAGED 2138
#define IDS_ENTERPRISE_PROFILE_WELCOME_PROFILE_SEPARATION_DEVICE_MANAGED_BY 2139
#define IDS_ENTERPRISE_PROFILE_WELCOME_ACCOUNT_EMAIL_MANAGED_BY 2140
#define IDS_ENTERPRISE_PROFILE_WELCOME_DEVICE_MANAGED_BY 2141
#define IDS_ENTERPRISE_PROFILE_WELCOME_DEVICE_MANAGED 2142
#define IDS_ENTERPRISE_PROFILE_WELCOME_MANAGED_DESCRIPTION_WITH_SYNC 2143
#define IDS_ENTERPRISE_PROFILE_WELCOME_MANAGED_DESCRIPTION_WITHOUT_SYNC 2144
#define IDS_ENTERPRISE_WELCOME_PROFILE_REQUIRED_TITLE 2145
#define IDS_ENTERPRISE_WELCOME_PROFILE_SETUP_TITLE 2146
#define IDS_ENTERPRISE_WELCOME_PROFILE_WILL_BE_MANAGED_TITLE 2147
#define IDS_ENTERPRISE_PROFILE_WELCOME_CREATE_PROFILE_BUTTON 2148
#define IDS_ENTERPRISE_PROFILE_WELCOME_LINK_DATA_CHECKBOX 2149
#define IDS_ENTERPRISE_WELCOME_PROFILE_INFORMATION_TITLE 2150
#define IDS_ENTERPRISE_WELCOME_DEVICE_INFORMATION_TITLE 2151
#define IDS_ENTERPRISE_WELCOME_DEVICE_INFORMATION_DETAILS 2152
#define IDS_ENTERPRISE_OIDC_WELCOME_PROCESSING_SUBTITLE 2153
#define IDS_ENTERPRISE_OIDC_WELCOME_SUCCESS_TITLE 2154
#define IDS_ENTERPRISE_OIDC_WELCOME_SUCCESS_SUBTITLE 2155
#define IDS_ENTERPRISE_OIDC_WELCOME_TIMEOUT_TITLE 2156
#define IDS_ENTERPRISE_OIDC_WELCOME_TIMEOUT_SUBTITLE 2157
#define IDS_ENTERPRISE_OIDC_WELCOME_ERROR_TITLE 2158
#define IDS_ENTERPRISE_OIDC_WELCOME_ERROR_SUBTITLE 2159
#define IDS_PROFILE_PICKER_ADD_SPACE_BUTTON 2160
#define IDS_PROFILE_PICKER_BROWSE_AS_GUEST_BUTTON 2161
#define IDS_PROFILE_PICKER_BACK_BUTTON_ARIA_LABEL 2162
#define IDS_PROFILE_PICKER_BACK_BUTTON_SIGN_IN_LABEL 2163
#define IDS_PROFILE_PICKER_PROFILE_CARD_NEEDS_SIGNIN_PROMPT 2164
#define IDS_PROFILE_PICKER_PROFILE_CARD_LABEL 2165
#define IDS_PROFILE_PICKER_PROFILE_CARD_INPUT_LABEL 2166
#define IDS_PROFILE_PICKER_PROFILE_MORE_ACTIONS_ARIA_LABEL 2167
#define IDS_PROFILE_PICKER_PROFILE_MENU_REMOVE_TEXT 2168
#define IDS_PROFILE_PICKER_PROFILE_MENU_REMOVE_CONFIRM 2169
#define IDS_PROFILE_PICKER_PROFILE_MENU_CUSTOMIZE_TEXT 2170
#define IDS_PROFILE_PICKER_PROFILE_MENU_INCOGNITO_TEXT 2171
#define IDS_PROFILE_PICKER_ASK_ON_STARTUP 2172
#define IDS_PROFILE_PICKER_REMOVE_WARNING_LOCAL_PROFILE_TITLE 2173
#define IDS_PROFILE_PICKER_FORCE_SIGN_IN_ERROR_DIALOG_NOT_ALLOWED_TITLE 2174
#define IDS_PROFILE_PICKER_FORCE_SIGN_IN_ERROR_DIALOG_NOT_ALLOWED_BODY 2175
#define IDS_PROFILE_PICKER_FORCE_SIGN_IN_ERROR_DIALOG_WRONG_ACCOUNT_TITLE 2176
#define IDS_PROFILE_PICKER_FORCE_SIGN_IN_ERROR_DIALOG_WRONG_ACCOUNT_BODY 2177
#define IDS_PROFILE_PICKER_FORCE_SIGN_IN_ERROR_TIMEOUT_TITLE 2178
#define IDS_PROFILE_PICKER_FORCE_SIGN_IN_ERROR_TIMEOUT_BODY 2179
#define IDS_PROFILE_PICKER_REMOVE_WARNING_HISTORY 2180
#define IDS_PROFILE_PICKER_REMOVE_WARNING_PASSWORDS 2181
#define IDS_PROFILE_PICKER_REMOVE_WARNING_BOOKMARKS 2182
#define IDS_PROFILE_PICKER_REMOVE_WARNING_AUTOFILL 2183
#define IDS_PROFILE_PICKER_REMOVE_WARNING_CALCULATING 2184
#define IDS_PROFILE_PICKER_PROFILE_CREATION_FLOW_SIGNIN_BUTTON_LABEL 2185
#define IDS_PROFILE_PICKER_PROFILE_CREATION_FLOW_NOT_NOW_BUTTON_LABEL 2186
#define IDS_PROFILE_PICKER_PROFILE_CREATION_FLOW_LOCAL_PROFILE_CREATION_CUSTOMIZE_AVATAR_BUTTON_LABEL 2187
#define IDS_PROFILE_PICKER_PROFILE_CREATION_FLOW_LOCAL_PROFILE_CREATION_AVATAR_TEXT 2188
#define IDS_PROFILE_PICKER_TAKE_A_TOUR_BUTTON_LABEL 2189
#define IDS_PROFILE_PICKER_IPH_NEXT_BUTTON_LABEL 2190
#define IDS_PROFILE_PICKER_IPH_DONE_BUTTON_LABEL 2191
#define IDS_PROFILE_PICKER_IPH_FOR_PROFILES_TITLE 2192
#define IDS_PROFILE_PICKER_IPH_FOR_ADD_PROFILE_TITLE 2193
#define IDS_PROFILE_PICKER_IPH_FOR_CUSTOMIZE_PROFILE_TITLE 2194
#define IDS_PROFILE_PICKER_IPH_FOR_CUSTOMIZE_PROFILE_TEXT 2195
#define IDS_PROFILE_PICKER_PROFILE_SWITCH_SWITCH_BUTTON_LABEL 2196
#define IDS_PROFILE_PICKER_PROFILE_CREATION_FLOW_DEVICE_MANAGED_BY_DESCRIPTION 2197
#define IDS_PROFILE_PICKER_PROFILE_CREATION_FLOW_DEVICE_MANAGED_DESCRIPTION 2198
#define IDS_PROFILE_PICKER_REMOVE_WARNING_LOCAL_PROFILE 2199
#define IDS_PROFILE_PICKER_REMOVE_WARNING_SIGNED_IN_PROFILE_TITLE 2200
#define IDS_PROFILE_PICKER_REMOVE_WARNING_SIGNED_IN_PROFILE 2201
#define IDS_PROFILE_PICKER_PROFILE_CREATION_FLOW_PROFILE_TYPE_CHOICE_SUBTITLE_UNO 2202
#define IDS_FRE_SIGN_IN_SUBTITLE_0 2214
#define IDS_FRE_SIGN_IN_SUBTITLE_1 2215
#define IDS_FRE_DEVICES_CARD_TITLE 2216
#define IDS_FRE_DEVICES_CARD_DESCRIPTION 2217
#define IDS_FRE_SECURITY_CARD_TITLE 2218
#define IDS_FRE_SECURITY_CARD_DESCRIPTION 2219
#define IDS_FRE_BACKUP_CARD_TITLE 2220
#define IDS_FRE_BACKUP_CARD_DESCRIPTION 2221
#define IDS_UNO_FRE_BACKUP_CARD_DESCRIPTION 2222
#define IDS_FRE_DECLINE_SIGN_IN_BUTTON_TITLE 2223
#define IDS_FRE_ACCEPT_SIGN_IN_BUTTON_TITLE 2224
#define IDS_FRE_MANAGED_DESCRIPTION 2225
#define IDS_FRE_MANAGED_BY_DESCRIPTION 2226
#define IDS_FRE_DEFAULT_BROWSER_TITLE_NEW 2227
#define IDS_FRE_DEFAULT_BROWSER_SUBTITLE 2228
#define IDS_FRE_DEFAULT_BROWSER_SET_AS_DEFAULT 2229
#define IDS_FRE_DEFAULT_BROWSER_SKIP 2230
#define IDS_SETTINGS_EMPTY_STRING 7345
#define IDS_SETTINGS_CONTINUE 7346
#define IDS_SETTINGS_GOT_IT 7347
#define IDS_SETTINGS_MORE_ACTIONS 7348
#define IDS_SETTINGS_OPENS_IN_NEW_TAB 7349
#define IDS_SETTINGS_SEND_FEEDBACK_ROLE_DESCRIPTION 7350
#define IDS_SETTINGS_COLUMN_HEADING_WHEN_ON 7351
#define IDS_SETTINGS_COLUMN_HEADING_CONSIDER 7352
#define IDS_RELAUNCH_CONFIRMATION_DIALOG_BODY 7353
#define IDS_SETTINGS_ABOUT_PAGE_BROWSER_VERSION 7354
#define IDS_SETTINGS_ABOUT_PAGE_LEARN_MORE_UPDATE_ERRORS 7355
#define IDS_SETTINGS_ABOUT_PAGE_LEARN_MORE_SYSTEM_REQUIREMENTS 7356
#define IDS_SETTINGS_ABOUT_PAGE_RELAUNCH 4576
#define IDS_SETTINGS_ACCESSIBILITY 7393
#define IDS_SETTINGS_ACCESSIBILITY_WEB_STORE 7394
#define IDS_SETTINGS_MORE_FEATURES_LINK 7395
#define IDS_SETTINGS_MORE_FEATURES_LINK_DESCRIPTION 7396
#define IDS_SETTINGS_ACCESSIBLE_IMAGE_LABELS_TITLE 7397
#define IDS_SETTINGS_ACCESSIBLE_IMAGE_LABELS_SUBTITLE 7398
#define IDS_SETTINGS_MAIN_NODE_ANNOTATIONS_DOWNLOAD_COMPLETE 7399
#define IDS_SETTINGS_MAIN_NODE_ANNOTATIONS_DOWNLOAD_ERROR 7400
#define IDS_SETTINGS_MAIN_NODE_ANNOTATIONS_DOWNLOAD_PROGRESS 7401
#define IDS_SETTINGS_MAIN_NODE_ANNOTATIONS_DOWNLOADING 7402
#define IDS_SETTINGS_MAIN_NODE_ANNOTATIONS_TITLE 7403
#define IDS_SETTINGS_MAIN_NODE_ANNOTATIONS_SUBTITLE 7404
#define IDS_SETTINGS_CAPTIONS_ENABLE_LIVE_CAPTION_TITLE 7405
#define IDS_SETTINGS_CAPTIONS_ENABLE_LIVE_TRANSLATE_TITLE 7406
#define IDS_SETTINGS_CAPTIONS_ENABLE_LIVE_TRANSLATE_SUBTITLE 7407
#define IDS_SETTINGS_CAPTIONS_ENABLE_LIVE_CAPTION_SUBTITLE_ENGLISH_ONLY 7410
#define IDS_SETTINGS_CAPTIONS_ENABLE_LIVE_CAPTION_SUBTITLE 7411
#define IDS_SETTINGS_CAPTIONS_LIVE_CAPTION_DOWNLOAD_PROGRESS 7412
#define IDS_SETTINGS_CAPTIONS_LIVE_CAPTION_DOWNLOAD_COMPLETE 7413
#define IDS_SETTINGS_CAPTIONS_LIVE_CAPTION_DOWNLOAD_ERROR 7414
#define IDS_SETTINGS_CAPTIONS_LIVE_CAPTION_DOWNLOAD_ERROR_REBOOT_REQUIRED 7415
#define IDS_SETTINGS_CAPTIONS_MASK_OFFENSIVE_WORDS_TITLE 7416
#define IDS_SETTINGS_ENABLE_CARET_BROWSING_TITLE 7417
#define IDS_SETTINGS_ENABLE_CARET_BROWSING_SUBTITLE 7418
#define IDS_SETTINGS_ACCESSIBILITY_FOCUS_HIGHLIGHT_DESCRIPTION 5172
#define IDS_SETTINGS_OVERSCROLL_HISTORY_NAVIGATION_TITLE 5126
#define IDS_SETTINGS_OVERSCROLL_HISTORY_NAVIGATION_SUBTITLE 7419
#define IDS_SETTINGS_APPEARANCE 7420
#define IDS_SETTINGS_CUSTOM_WEB_ADDRESS 7421
#define IDS_SETTINGS_ENTER_CUSTOM_WEB_ADDRESS 7422
#define IDS_SETTINGS_HOME_BUTTON_DISABLED 7423
#define IDS_SETTINGS_THEMES 7424
#define IDS_SETTINGS_GTK_THEME 7425
#define IDS_SETTINGS_USE_GTK_THEME 7426
#define IDS_SETTINGS_QT_THEME 7427
#define IDS_SETTINGS_USE_QT_THEME 7428
#define IDS_SETTINGS_CLASSIC_THEME 7429
#define IDS_SETTINGS_USE_CLASSIC_THEME 7430
#define IDS_SETTINGS_CHROME_COLORS 7432
#define IDS_SETTINGS_COLOR_SCHEME_MODE 7433
#define IDS_SETTINGS_SHOW_HOME_BUTTON 7434
#define IDS_SETTINGS_SHOW_BOOKMARKS_BAR 7435
#define IDS_SETTINGS_SHOW_TAB_GROUPS_IN_BOOKMARKS_BAR 7436
#define IDS_SETTINGS_AUTO_PIN_NEW_TAB_GROUPS 7437
#define IDS_SETTINGS_HOVER_CARD_TITLE 7438
#define IDS_SETTINGS_SHOW_HOVER_CARD_IMAGES 7439
#define IDS_SETTINGS_SHOW_HOVER_CARD_MEMORY_USAGE 7440
#define IDS_SETTINGS_SHOW_HOVER_CARD_MEMORY_USAGE_STANDALONE 7441
#define IDS_SETTINGS_SIDE_PANEL_POSITION 7442
#define IDS_SETTINGS_TAB_SEARCH_POSITION 7443
#define IDS_SETTINGS_UI_FEATURE_ALIGN_LEFT 7444
#define IDS_SETTINGS_UI_FEATURE_ALIGN_RIGHT 7445
#define IDS_SETTINGS_HOME_PAGE_NTP 7446
#define IDS_SETTINGS_CHANGE_HOME_PAGE 7447
#define IDS_SETTINGS_WEB_STORE 7448
#define IDS_SETTINGS_ADVANCED 7451
#define IDS_SETTINGS_BASIC 7452
#define IDS_SETTINGS_MENU_BUTTON_LABEL 7453
#define IDS_SETTINGS_MENU_EXTENSIONS_LINK_TOOLTIP 7454
#define IDS_SETTINGS_SEARCH_PROMPT 7455
#define IDS_SETTINGS_SEARCH_NO_RESULTS_HELP 7456
#define IDS_SETTINGS_SETTINGS 7457
#define IDS_SETTINGS_ALT_PAGE_TITLE 7458
#define IDS_SETTINGS_SUBPAGE_BUTTON 7459
#define IDS_SETTINGS_RESTART 7460
#define IDS_SETTINGS_CONTROLLED_BY_EXTENSION 7461
#define IDS_SETTINGS_CLEAR 7462
#define IDS_SETTINGS_CUSTOM 7463
#define IDS_SETTINGS_DELETE 7464
#define IDS_SETTINGS_EDIT 7465
#define IDS_SETTINGS_END_TIME 7466
#define IDS_SETTINGS_NOT_VALID 7467
#define IDS_SETTINGS_NOT_VALID_WEB_ADDRESS 7468
#define IDS_SETTINGS_NOT_VALID_WEB_ADDRESS_FOR_CONTENT_TYPE 7469
#define IDS_SETTINGS_RETRY 7470
#define IDS_SETTINGS_SLIDER_MIN_MAX_ARIA_ROLE_DESCRIPTION 7471
#define IDS_SETTINGS_START_TIME 7472
#define IDS_PASSWORDS_PAGE_AUTHENTICATION_PROMPT_BIOMETRIC_SUFFIX 7473
#define IDS_PASSWORDS_PAGE_COPY_AUTHENTICATION_PROMPT_BIOMETRIC_SUFFIX 7474
#define IDS_PASSWORDS_PAGE_EDIT_AUTHENTICATION_PROMPT_BIOMETRIC_SUFFIX 7475
#define IDS_PASSWORDS_PAGE_EXPORT_AUTHENTICATION_PROMPT_BIOMETRIC_SUFFIX 7476
#define IDS_SETTINGS_AUTOFILL_AND_PASSWORDS 7477
#define IDS_PASSWORDS_PAGE_IMPORT_AUTHENTICATION_PROMPT_BIOMETRIC_SUFFIX 7478
#define IDS_SETTINGS_GOOGLE_PAYMENTS 7479
#define IDS_SETTINGS_AUTOFILL_ADDRESSES_ADD_TITLE 7480
#define IDS_SETTINGS_AUTOFILL_ADDRESSES_EDIT_TITLE 7481
#define IDS_SETTINGS_AUTOFILL_ADDRESSES_COUNTRY 7482
#define IDS_SETTINGS_AUTOFILL_ADDRESSES_PHONE 7483
#define IDS_SETTINGS_AUTOFILL_ADDRESSES_EMAIL 7484
#define IDS_SETTINGS_AUTOFILL_DETAIL 7485
#define IDS_SETTINGS_AUTOFILL_CARD_DESCRIPTION 7486
#define IDS_SETTINGS_AUTOFILL_CARD_A11Y_LABELED 7487
#define IDS_SETTINGS_AUTOFILL_CARD_EXP_DATE_A11Y_LABELED 7488
#define IDS_SETTINGS_AUTOFILL_MORE_ACTIONS_FOR_ADDRESS 7489
#define IDS_SETTINGS_AUTOFILL_MORE_ACTIONS_FOR_CREDIT_CARD 7490
#define IDS_SETTINGS_AUTOFILL_MORE_ACTIONS_FOR_CREDIT_CARD_WITH_CVC 7491
#define IDS_AUTOFILL_ADD_VIRTUAL_CARD 7492
#define IDS_AUTOFILL_REMOVE_VIRTUAL_CARD 7493
#define IDS_AUTOFILL_EDIT_SERVER_CREDIT_CARD 7494
#define IDS_AUTOFILL_VIRTUAL_CARD_TURNED_ON_LABEL 7495
#define IDS_AUTOFILL_VIRTUAL_CARD_UNENROLL_DIALOG_TITLE 7496
#define IDS_AUTOFILL_VIRTUAL_CARD_UNENROLL_DIALOG_LABEL 7497
#define IDS_AUTOFILL_VIRTUAL_CARD_UNENROLL_DIALOG_CONFIRM_BUTTON_LABEL 7498
#define IDS_SETTINGS_ADDRESS_REMOVE 7499
#define IDS_SETTINGS_ADDRESS_REMOVE_CONFIRMATION_TITLE 7500
#define IDS_SETTINGS_ADDRESS_REMOVED_MESSAGE 7501
#define IDS_SETTINGS_EDIT_CREDIT_CARD_TITLE 7502
#define IDS_SETTINGS_LOCAL_CARD_REMOVE_CONFIRMATION_TITLE 7503
#define IDS_SETTINGS_LOCAL_PAYMENT_METHOD_REMOVE_CONFIRMATION_DESCRIPTION 7504
#define IDS_SETTINGS_PAYMENTS_MANAGE_CREDIT_CARDS 7505
#define IDS_SETTINGS_PAYMENTS_SAVED_TO_THIS_DEVICE_ONLY 7506
#define IDS_SETTINGS_ADD_CREDIT_CARD_TITLE 7507
#define IDS_SETTINGS_MIGRATABLE_CARDS_LABEL 7508
#define IDS_SETTINGS_SINGLE_MIGRATABLE_CARD_INFO 7509
#define IDS_SETTINGS_MULTIPLE_MIGRATABLE_CARDS_INFO 7510
#define IDS_SETTINGS_REMOTE_PAYMENT_METHODS_LINK_LABEL 7511
#define IDS_SETTINGS_NAME_ON_CREDIT_CARD 7512
#define IDS_SETTINGS_CREDIT_CARD_NUMBER 7513
#define IDS_SETTINGS_CREDIT_CARD_EXPIRATION_DATE 7514
#define IDS_SETTINGS_CREDIT_CARD_EXPIRATION_MONTH 7515
#define IDS_SETTINGS_CREDIT_CARD_EXPIRATION_YEAR 7516
#define IDS_SETTINGS_CREDIT_CARD_EXPIRED 7517
#define IDS_SETTINGS_CREDIT_CARD_NICKNAME 7518
#define IDS_SETTINGS_CREDIT_CARD_NICKNAME_INVALID 7519
#define IDS_SETTINGS_CREDIT_CARD_CVC_TITLE 7520
#define IDS_SETTINGS_CREDIT_CARD_CVC_IMAGE_TITLE 7521
#define IDS_SETTINGS_CREDIT_CARD_CVC_IMAGE_TITLE_AMEX 7522
#define IDS_SETTINGS_CREDIT_CARD_CVC_PLACEHOLDER 7523
#define IDS_SETTINGS_ADD_PAYMENT_METHODS 7524
#define IDS_SETTINGS_ADD_PAYMENT_METHOD_CREDIT_OR_DEBIT_CARD 7525
#define IDS_SETTINGS_ADD_PAYMENT_METHOD_IBAN 7526
#define IDS_SETTINGS_IBAN_SAVED_TO_THIS_DEVICE_ONLY 7527
#define IDS_IBAN_NICKNAME 7528
#define IDS_SETTINGS_AUTOFILL_MORE_ACTIONS_FOR_IBAN 7529
#define IDS_SETTINGS_AUTOFILL_A11Y_IBAN_DESCRIPTION 7530
#define IDS_SETTINGS_ADD_IBAN_TITLE 7531
#define IDS_SETTINGS_EDIT_IBAN_TITLE 7532
#define IDS_SETTINGS_IBAN_EDIT 7533
#define IDS_SETTINGS_LOCAL_IBAN_REMOVE_CONFIRMATION_TITLE 7534
#define IDS_SETTINGS_PASSWORD_MANAGER 7535
#define IDS_SETTINGS_PASSWORD_MANAGER_DESCRIPTION 7536
#define IDS_SETTINGS_PAYMENT_METHODS_NONE 7537
#define IDS_SETTINGS_PASSKEYS_LENGTH_ERROR 7538
#define IDS_SETTINGS_PASSKEYS_SITE_LABEL 7539
#define IDS_SETTINGS_PASSKEYS_DIALOG_TITLE 7540
#define IDS_SETTINGS_PASSKEYS_EDIT_DIALOG_FOOTNOTE 7541
#define IDS_SETTINGS_ADDRESS_NONE 7542
#define IDS_SETTINGS_PASSWORDS_LEAK_DETECTION_LABEL 7543
#define IDS_SETTINGS_PASSWORDS_LEAK_DETECTION_LABEL_UPDATED 7544
#define IDS_SETTINGS_PASSWORDS_LEAK_DETECTION_SIGNED_OUT_ENABLED_DESC 7545
#define IDS_SETTINGS_CHECK_PASSWORDS_PROGRESS 7546
#define IDS_SETTINGS_COMPROMISED_PASSWORDS_COUNT 7547
#define IDS_SETTINGS_COMPROMISED_PASSWORDS_COUNT_SHORT 7548
#define IDS_SETTINGS_WEAK_PASSWORDS_COUNT_SHORT 7549
#define IDS_SETTINGS_REUSED_PASSWORDS_COUNT_SHORT 7550
#define IDS_SETTINGS_PASSWORD_SHOW_PASSWORD_A11Y 7562
#define IDS_SETTINGS_PASSWORD_HIDE_PASSWORD_A11Y 7563
#define IDS_SETTINGS_DEFAULT_BROWSER 7566
#define IDS_SETTINGS_DEFAULT_BROWSER_MAKE_DEFAULT_BUTTON 7567
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_CLIENT_CERTIFICATES 7568
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_LOCAL_CERTIFICATES 7569
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_CRS_CERTIFICATES 7570
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_HASH_COPIED_TOAST 7571
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_ADMIN_CERTS_SINGULAR 7572
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_ADMIN_CERTS_PLURAL 7573
#define IDS_SETTINGS_CERTIFICATE_MANAGER_YOUR_CERTIFICATES 7574
#define IDS_SETTINGS_CERTIFICATE_MANAGER_EXPAND_ACCESSIBILITY_LABEL 7575
#define IDS_SETTINGS_CERTIFICATE_MANAGER_YOUR_CERTIFICATES_DESCRIPTION 7576
#define IDS_SETTINGS_CERTIFICATE_MANAGER_SERVERS 7577
#define IDS_SETTINGS_CERTIFICATE_MANAGER_SERVERS_DESCRIPTION 7578
#define IDS_SETTINGS_CERTIFICATE_MANAGER_NO_CERTIFICATES 7579
#define IDS_SETTINGS_CERTIFICATE_MANAGER_AUTHORITIES 7580
#define IDS_SETTINGS_CERTIFICATE_MANAGER_AUTHORITIES_DESCRIPTION 7581
#define IDS_SETTINGS_CERTIFICATE_MANAGER_VIEW 7582
#define IDS_SETTINGS_CERTIFICATE_MANAGER_IMPORT 7583
#define IDS_SETTINGS_CERTIFICATE_MANAGER_IMPORT_AND_BIND 7584
#define IDS_SETTINGS_CERTIFICATE_MANAGER_EXPORT 7585
#define IDS_SETTINGS_CERTIFICATE_MANAGER_OTHERS 7586
#define IDS_SETTINGS_CERTIFICATE_MANAGER_OTHERS_DESCRIPTION 7587
#define IDS_SETTINGS_CERTIFICATE_MANAGER_USAGE_SSL_CLIENT 7588
#define IDS_SETTINGS_CERTIFICATE_MANAGER_UNTRUSTED 7589
#define IDS_SETTINGS_CERTIFICATE_MANAGER_CA_TRUST_EDIT_DIALOG_TITLE 7590
#define IDS_SETTINGS_CERTIFICATE_MANAGER_CA_TRUST_EDIT_DIALOG_DESCRIPTION 7591
#define IDS_SETTINGS_CERTIFICATE_MANAGER_CA_TRUST_EDIT_DIALOG_EXPLANATION 7592
#define IDS_SETTINGS_CERTIFICATE_MANAGER_CA_TRUST_EDIT_DIALOG_SSL 7593
#define IDS_SETTINGS_CERTIFICATE_MANAGER_CA_TRUST_EDIT_DIALOG_EMAIL 7594
#define IDS_SETTINGS_CERTIFICATE_MANAGER_CA_TRUST_EDIT_DIALOG_OBJ_SIGN 7595
#define IDS_SETTINGS_CERTIFICATE_MANAGER_DELETE_USER_TITLE 7596
#define IDS_SETTINGS_CERTIFICATE_MANAGER_DELETE_USER_DESCRIPTION 7597
#define IDS_SETTINGS_CERTIFICATE_MANAGER_DELETE_SERVER_TITLE 7598
#define IDS_SETTINGS_CERTIFICATE_MANAGER_DELETE_SERVER_DESCRIPTION 7599
#define IDS_SETTINGS_CERTIFICATE_MANAGER_DELETE_CA_TITLE 7600
#define IDS_SETTINGS_CERTIFICATE_MANAGER_DELETE_CA_DESCRIPTION 7601
#define IDS_SETTINGS_CERTIFICATE_MANAGER_DELETE_OTHER_TITLE 7602
#define IDS_SETTINGS_CERTIFICATE_MANAGER_ENCRYPT_PASSWORD_TITLE 7603
#define IDS_SETTINGS_CERTIFICATE_MANAGER_DECRYPT_PASSWORD_TITLE 7604
#define IDS_SETTINGS_CERTIFICATE_MANAGER_ENCRYPT_PASSWORD_DESCRIPTION 7605
#define IDS_SETTINGS_CERTIFICATE_MANAGER_PASSWORD 7606
#define IDS_SETTINGS_CERTIFICATE_MANAGER_CONFIRM_PASSWORD 7607
#define IDS_SETTINGS_CERTIFICATE_MANAGER_BAD_PASSWORD 7608
#define IDS_SETTINGS_CERTIFICATE_MANAGER_CA_IMPORT_ERROR_TITLE 7609
#define IDS_SETTINGS_CERTIFICATE_MANAGER_CERT_PARSE_ERROR 7610
#define IDS_SETTINGS_CERTIFICATE_MANAGER_DELETE_CERT_ERROR_TITLE 7611
#define IDS_SETTINGS_CERTIFICATE_MANAGER_ERROR_CERT_ALREADY_EXISTS 7612
#define IDS_SETTINGS_CERTIFICATE_MANAGER_ERROR_NOT_CA 7613
#define IDS_SETTINGS_CERTIFICATE_MANAGER_IMPORT_ALL_NOT_IMPORTED 7614
#define IDS_SETTINGS_CERTIFICATE_MANAGER_IMPORT_ERROR_TITLE 7615
#define IDS_SETTINGS_CERTIFICATE_MANAGER_IMPORT_INVALID_FILE 7616
#define IDS_SETTINGS_CERTIFICATE_MANAGER_IMPORT_INVALID_MAC 7617
#define IDS_SETTINGS_CERTIFICATE_MANAGER_IMPORT_MISSING_KEY 7618
#define IDS_SETTINGS_CERTIFICATE_MANAGER_IMPORT_SINGLE_NOT_IMPORTED 7619
#define IDS_SETTINGS_CERTIFICATE_MANAGER_IMPORT_SOME_NOT_IMPORTED 7620
#define IDS_SETTINGS_CERTIFICATE_MANAGER_IMPORT_UNSUPPORTED 7621
#define IDS_SETTINGS_CERTIFICATE_MANAGER_PKCS12_EXPORT_ERROR_TITLE 7622
#define IDS_SETTINGS_CERTIFICATE_MANAGER_PKCS12_FILES 7623
#define IDS_SETTINGS_CERTIFICATE_MANAGER_READ_ERROR_FORMAT 7624
#define IDS_SETTINGS_CERTIFICATE_MANAGER_IMPORT_ERROR_FORMAT 7625
#define IDS_SETTINGS_CERTIFICATE_MANAGER_SERVER_IMPORT_ERROR_TITLE 7626
#define IDS_SETTINGS_CERTIFICATE_MANAGER_SET_TRUST_ERROR_TITLE 7627
#define IDS_SETTINGS_CERTIFICATE_MANAGER_ERROR_NOT_ALLOWED 7628
#define IDS_SETTINGS_CERTIFICATE_MANAGER_UNKNOWN_ERROR 7629
#define IDS_SETTINGS_CERTIFICATE_MANAGER_WRITE_ERROR_FORMAT 7630
#define IDS_SETTINGS_CLEAR_PERIOD_TITLE 7653
#define IDS_SETTINGS_CLEAR_BROWSING_DATA_WITH_SYNC 7654
#define IDS_SETTINGS_CLEAR_BROWSING_DATA_WITH_SYNC_ERROR 7655
#define IDS_SETTINGS_CLEAR_BROWSING_DATA_WITH_SYNC_PASSPHRASE_ERROR 7656
#define IDS_SETTINGS_CLEAR_BROWSING_DATA_WITH_SYNC_PAUSED 7657
#define IDS_SETTINGS_CLEAR_BROWSING_HISTORY 7658
#define IDS_SETTINGS_CLEAR_COOKIES_AND_SITE_DATA_SUMMARY_BASIC 7659
#define IDS_SETTINGS_CLEAR_COOKIES_AND_SITE_DATA_SUMMARY_BASIC_WITH_EXCEPTION 7660
#define IDS_SETTINGS_CLEAR_COOKIES_AND_SITE_DATA_SUMMARY_BASIC_MAIN_PROFILE 7661
#define IDS_SETTINGS_CLEAR_COOKIES_AND_SITE_DATA_SUMMARY_BASIC_SUPERVISED_PROFILE 7662
#define IDS_SETTINGS_CLEAR_COOKIES_AND_SITE_DATA_SUMMARY_BASIC_SIGNED_IN_PROFILE 7663
#define IDS_SETTINGS_CLEAR_BROWSING_HISTORY_SUMMARY 7664
#define IDS_SETTINGS_CLEAR_BROWSING_HISTORY_SUMMARY_SIGNED_IN_NO_LINK 7665
#define IDS_SETTINGS_CLEAR_GOOGLE_SEARCH_HISTORY_GOOGLE_DSE 7666
#define IDS_SETTINGS_CLEAR_GOOGLE_SEARCH_HISTORY_NON_GOOGLE_DSE 7667
#define IDS_SETTINGS_CLEAR_NON_GOOGLE_SEARCH_HISTORY_PREPOPULATED_DSE 7668
#define IDS_SETTINGS_CLEAR_NON_GOOGLE_SEARCH_HISTORY_NON_PREPOPULATED_DSE 7669
#define IDS_SETTINGS_CLEAR_DOWNLOAD_HISTORY 7670
#define IDS_SETTINGS_CLEAR_CACHE 7671
#define IDS_SETTINGS_CLEAR_COOKIES 7672
#define IDS_SETTINGS_CLEAR_PASSWORDS 7673
#define IDS_SETTINGS_CLEAR_FORM_DATA 7674
#define IDS_SETTINGS_CLEAR_HOSTED_APP_DATA 7675
#define IDS_SETTINGS_CLEAR_PERIOD_HOUR 7676
#define IDS_SETTINGS_CLEAR_PERIOD_24_HOURS 7677
#define IDS_SETTINGS_CLEAR_PERIOD_7_DAYS 7678
#define IDS_SETTINGS_CLEAR_PERIOD_FOUR_WEEKS 7679
#define IDS_SETTINGS_CLEAR_PERIOD_EVERYTHING 7680
#define IDS_SETTINGS_CLEAR_PERIOD_15_MINUTES 7681
#define IDS_SETTINGS_CLEAR_PERIOD_NOT_SELECTED 7682
#define IDS_SETTINGS_NOTIFICATION_WARNING 7683
#define IDS_SETTINGS_DOWNLOADS 7684
#define IDS_SETTINGS_DOWNLOAD_LOCATION 7685
#define IDS_SETTINGS_CHANGE_DOWNLOAD_LOCATION 7686
#define IDS_SETTINGS_PROMPT_FOR_DOWNLOAD 7687
#define IDS_SETTINGS_OPEN_FILE_TYPES_AUTOMATICALLY 7688
#define IDS_SETTINGS_DOWNLOADS_SHOW_WHEN_FINISHED 7689
#define IDS_SETTINGS_ON_STARTUP 7690
#define IDS_SETTINGS_ON_STARTUP_OPEN_NEW_TAB 7691
#define IDS_SETTINGS_ON_STARTUP_CONTINUE 7692
#define IDS_SETTINGS_ON_STARTUP_OPEN_SPECIFIC 7693
#define IDS_SETTINGS_ON_STARTUP_CONTINUE_AND_OPEN_SPECIFIC 7694
#define IDS_SETTINGS_ON_STARTUP_USE_CURRENT 7695
#define IDS_SETTINGS_ON_STARTUP_ADD_NEW_PAGE 7696
#define IDS_SETTINGS_ON_STARTUP_EDIT_PAGE 7697
#define IDS_SETTINGS_ON_STARTUP_SITE_URL 7698
#define IDS_SETTINGS_ON_STARTUP_REMOVE 7699
#define IDS_SETTINGS_ON_STARTUP_PAGE_TOOLTIP 7700
#define IDS_SETTINGS_INVALID_URL 7701
#define IDS_SETTINGS_URL_TOOL_LONG 7702
#define IDS_SETTINGS_PERFORMANCE_PAGE_TITLE 7703
#define IDS_SETTINGS_MEMORY_PAGE_TITLE 7704
#define IDS_SETTINGS_SPEED_PAGE_TITLE 7705
#define IDS_SETTINGS_PERFORMANCE_MEMORY_SAVER_MODE_SETTING 7706
#define IDS_SETTINGS_PERFORMANCE_MEMORY_SAVER_MODE_HEURISTICS_LABEL 7707
#define IDS_SETTINGS_PERFORMANCE_MEMORY_SAVER_MODE_RECOMMENDED_BADGE 7708
#define IDS_SETTINGS_PERFORMANCE_MEMORY_SAVER_MODE_ON_TIMER_LABEL 7709
#define IDS_SETTINGS_PERFORMANCE_MEMORY_SAVER_MODE_RADIO_GROUP_ARIA_LABEL 7710
#define IDS_SETTINGS_PERFORMANCE_MEMORY_SAVER_MODE_CHOOSE_DISCARD_TIME_ARIA_LABEL 7711
#define IDS_SETTINGS_PERFORMANCE_MEMORY_SAVER_MODE_CONSERVATIVE_LABEL 7712
#define IDS_SETTINGS_PERFORMANCE_MEMORY_SAVER_MODE_MEDIUM_LABEL 7713
#define IDS_SETTINGS_PERFORMANCE_MEMORY_SAVER_MODE_AGGRESSIVE_LABEL 7714
#define IDS_SETTINGS_PERFORMANCE_MEMORY_SAVER_MODE_CONSERVATIVE_DESCRIPTION 7715
#define IDS_SETTINGS_PERFORMANCE_MEMORY_SAVER_MODE_MEDIUM_DESCRIPTION 7716
#define IDS_SETTINGS_PERFORMANCE_MEMORY_SAVER_MODE_AGGRESSIVE_DESCRIPTION 7717
#define IDS_SETTINGS_PERFORMANCE_TAB_DISCARDING_EXCEPTIONS_ADD_BUTTON_ARIA_LABEL 7718
#define IDS_SETTINGS_PERFORMANCE_TAB_DISCARDING_EXCEPTIONS_SAVE_BUTTON_ARIA_LABEL 7719
#define IDS_SETTINGS_PERFORMANCE_TAB_DISCARDING_EXCEPTIONS_HEADER 7720
#define IDS_SETTINGS_PERFORMANCE_TAB_DISCARDING_EXCEPTIONS_DESCRIPTION 7721
#define IDS_SETTINGS_PERFORMANCE_TAB_DISCARDING_EXCEPTIONS_ADDITIONAL_SITES 7722
#define IDS_SETTINGS_PERFORMANCE_TAB_DISCARDING_EXCEPTIONS_ADD_DIALOG_CURRENT_TABS 7723
#define IDS_SETTINGS_PERFORMANCE_TAB_DISCARDING_EXCEPTIONS_ADD_DIALOG_CURRENT_TABS_EMPTY 7724
#define IDS_SETTINGS_PERFORMANCE_TAB_DISCARDING_EXCEPTIONS_ADD_DIALOG_MANUAL 7725
#define IDS_SETTINGS_PERFORMANCE_TAB_DISCARDING_EXCEPTIONS_ACTIVE_SITE_ARIA_DESCRIPTION 7726
#define IDS_SETTINGS_PERFORMANCE_TAB_DISCARDING_EXCEPTIONS_ADD_DIALOG_HELP 7727
#define IDS_SETTINGS_BATTERY_PAGE_TITLE 7728
#define IDS_SETTINGS_PERFORMANCE_BATTERY_SAVER_MODE_SETTING 7729
#define IDS_SETTINGS_PERFORMANCE_BATTERY_SAVER_MODE_ON_BATTERY_LABEL 7730
#define IDS_SETTINGS_PERFORMANCE_BATTERY_SAVER_MODE_BELOW_THRESHOLD_LABEL 7731
#define IDS_SETTINGS_PERFORMANCE_BATTERY_SAVER_MODE_RADIO_GROUP_ARIA_LABEL 7732
#define IDS_SETTINGS_PERFORMANCE_BATTERY_SAVER_MODE_LINK_OS_SETTING_DESCRIPTION 7733
#define IDS_SETTINGS_PERFORMANCE_DISCARD_RING_TREATMENT_ENABLED_LABEL 7734
#define IDS_SETTINGS_PERFORMANCE_DISCARD_RING_TREATMENT_ENABLED_DESCRIPTION 7735
#define IDS_SETTINGS_LANGUAGES_PAGE_TITLE 7736
#define IDS_SETTINGS_LANGUAGES_CARD_TITLE 7737
#define IDS_SETTINGS_LANGUAGE_SEARCH 7738
#define IDS_SETTINGS_LANGUAGES_LANGUAGES_LIST_MOVE_TO_TOP 7739
#define IDS_SETTINGS_LANGUAGES_LANGUAGES_LIST_MOVE_UP 7740
#define IDS_SETTINGS_LANGUAGES_LANGUAGES_LIST_MOVE_DOWN 7741
#define IDS_SETTINGS_LANGUAGES_LANGUAGES_LIST_REMOVE 7742
#define IDS_SETTINGS_LANGUAGES_LANGUAGES_ADD 7743
#define IDS_SETTINGS_LANGUAGES_MANAGE_LANGUAGES_TITLE 7744
#define IDS_SETTINGS_LANGUAGES_NO_LANGUAGES_ADDED 7745
#define IDS_SETTINGS_LANGUAGES_EXPAND_ACCESSIBILITY_LABEL 7746
#define IDS_SETTINGS_LANGUAGES_PREFERRED_LANGUAGES_HEADER 7747
#define IDS_SETTINGS_LANGUAGES_PREFERRED_LANGUAGES_DESC 7748
#define IDS_SETTINGS_LANGUAGES_OFFER_TO_ENABLE_TRANSLATE 7749
#define IDS_SETTINGS_LANGUAGES_OFFER_TO_ENABLE_TRANSLATE_SUBLABEL 7750
#define IDS_SETTINGS_LANGUAGES_TRANSLATE_TARGET 7751
#define IDS_SETTINGS_LANGUAGES_MANAGED_DIALOG_TITLE 7752
#define IDS_SETTINGS_LANGUAGES_MANAGED_DIALOG_BODY 7753
#define IDS_SETTINGS_LANGUAGES_ADD_ARIA_LABEL 7754
#define IDS_SETTINGS_LANGUAGES_REMOVE_AUTOMATIC_ARIA_LABEL 7755
#define IDS_SETTINGS_LANGUAGES_REMOVE_NEVER_ARIA_LABEL 7756
#define IDS_SETTINGS_TRANSLATE_PAGE_TITLE 7757
#define IDS_SETTINGS_TARGET_TRANSLATE_LABEL 7758
#define IDS_SETTINGS_LANGUAGES_AUTOMATIC_TRANSLATE 7759
#define IDS_SETTINGS_LANGUAGES_AUTOMATIC_TRANSLATE_ADD_ARIA_LABEL 7760
#define IDS_SETTINGS_LANGUAGES_NEVER_LANGUAGES 7761
#define IDS_SETTINGS_LANGUAGES_NEVER_TRANSLATE_ADD_ARIA_LABEL 7762
#define IDS_SETTINGS_LANGUAGES_SPELL_CHECK_TITLE 7763
#define IDS_SETTINGS_LANGUAGES_SPELL_CHECK_BASIC_LABEL 7764
#define IDS_SETTINGS_LANGUAGES_SPELL_CHECK_ENHANCED_LABEL 7765
#define IDS_SETTINGS_LANGUAGES_SPELL_CHECK_ENHANCED_DESCRIPTION 7766
#define IDS_SETTINGS_LANGUAGES_OFFER_TO_ENABLE_SPELL_CHECK 7767
#define IDS_SETTING_LANGUAGES_SPELL_CHECK_DISABLED_REASON 7768
#define IDS_SETTINGS_LANGUAGES_SPELL_CHECK_LANGUAGES_LIST_TITLE 7769
#define IDS_SETTINGS_LANGUAGES_SPELL_CHECK_MANAGE 7770
#define IDS_SETTINGS_LANGUAGES_EDIT_DICTIONARY_TITLE 7771
#define IDS_SETTINGS_LANGUAGES_ADD_DICTIONARY_WORD 7772
#define IDS_SETTINGS_LANGUAGES_ADD_DICTIONARY_WORD_BUTTON 7773
#define IDS_SETTINGS_LANGUAGES_ADD_DICTIONARY_WORD_DUPLICATE_ERROR 7774
#define IDS_SETTINGS_LANGUAGES_ADD_DICTIONARY_WORD_LENGTH_ERROR 7775
#define IDS_SETTINGS_LANGUAGES_DELETE_DICTIONARY_WORD_BUTTON 7776
#define IDS_SETTINGS_LANGUAGES_DICTIONARY_WORDS 7777
#define IDS_SETTINGS_LANGUAGES_DICTIONARY_WORDS_NONE 7778
#define IDS_SETTINGS_LANGUAGES_DICTIONARY_DOWNLOAD_FAILED 7779
#define IDS_SETTINGS_LANGUAGES_DICTIONARY_DOWNLOAD_FAILED_HELP 7780
#define IDS_SETTINGS_PRELOAD_PAGES_TITLE 7783
#define IDS_SETTINGS_PRELOAD_PAGES_STANDARD_PRELOADING_TITLE 7784
#define IDS_SETTINGS_PRELOAD_PAGES_STANDARD_PRELOADING_EXPAND_A11Y_LABEL 7785
#define IDS_SETTINGS_PRELOAD_PAGES_STANDARD_PRELOADING_SUMMARY 7786
#define IDS_SETTINGS_PRELOAD_PAGES_STANDARD_PRELOADING_WHEN_ON_BULLET_ONE 7787
#define IDS_SETTINGS_PRELOAD_PAGES_EXTENDED_PRELOADING_TITLE 7788
#define IDS_SETTINGS_PRELOAD_PAGES_EXTENDED_PRELOADING_SUMMARY 7789
#define IDS_SETTINGS_PRELOAD_PAGES_EXTENDED_PRELOADING_EXPAND_A11Y_LABEL 7790
#define IDS_SETTINGS_PRELOAD_PAGES_EXTENDED_PRELOADING_WHEN_ON_BULLET_ONE 7791
#define IDS_SETTINGS_PRIVACY 7792
#define IDS_SETTINGS_PRIVACY_V2 7793
#define IDS_SETTINGS_PRIVACY_MORE 7794
#define IDS_SETTINGS_OFFER_WRITING_HELP_TOGGLE_LABEL 7796
#define IDS_SETTINGS_OFFER_WRITING_HELP_TOGGLE_SUB_LABEL 7797
#define IDS_SETTINGS_OFFER_WRITING_HELP_ENABLED_SUB_LABEL 7798
#define IDS_SETTINGS_OFFER_WRITING_HELP_DISABLED_SUB_LABEL 7799
#define IDS_SETTINGS_OFFER_WRITING_HELP_DISABLED_SITES_LABEL 7800
#define IDS_SETTINGS_OFFER_WRITING_HELP_NO_DISABLED_SITES 7801
#define IDS_SETTINGS_OFFER_WRITING_HELP_REMOVE_SITE_ARIA_LABEL 7802
#define IDS_SETTINGS_ANTI_ABUSE_ENABLED_SUB_LABEL 7803
#define IDS_SETTINGS_ANTI_ABUSE_DISABLED_SUB_LABEL 7804
#define IDS_SETTINGS_ANTI_ABUSE_DESCRIPTION 7805
#define IDS_SETTINGS_ANTI_ABUSE_WHEN_ON_SECTION_ONE 7806
#define IDS_SETTINGS_ANTI_ABUSE_WHEN_ON_SECTION_TWO 7807
#define IDS_SETTINGS_ANTI_ABUSE_WHEN_ON_SECTION_THREE 7808
#define IDS_SETTINGS_ANTI_ABUSE_THINGS_TO_CONSIDER_SECTION_ONE 7809
#define IDS_SETTINGS_PRIVACY_SANDBOX_TITLE 7810
#define IDS_SETTINGS_PRIVACY_SANDBOX_COOKIES_DIALOG 7811
#define IDS_SETTINGS_PRIVACY_SANDBOX_COOKIES_DIALOG_MORE 7812
#define IDS_SETTINGS_AD_PRIVACY_LINK_ROW_LABEL 7813
#define IDS_SETTINGS_AD_PRIVACY_LINK_ROW_SUB_LABEL 7814
#define IDS_SETTINGS_AD_PRIVACY_RESTRICTED_LINK_ROW_SUB_LABEL 7815
#define IDS_SETTINGS_AD_PRIVACY_PAGE_TITLE 7816
#define IDS_SETTINGS_AD_PRIVACY_PAGE_TOPICS_LINK_ROW_LABEL 7817
#define IDS_SETTINGS_AD_PRIVACY_PAGE_TOPICS_LINK_ROW_SUB_LABEL_ENABLED 7818
#define IDS_SETTINGS_AD_PRIVACY_PAGE_TOPICS_LINK_ROW_SUB_LABEL_DISABLED 7819
#define IDS_SETTINGS_AD_PRIVACY_PAGE_FLEDGE_LINK_ROW_LABEL 7820
#define IDS_SETTINGS_AD_PRIVACY_PAGE_FLEDGE_LINK_ROW_SUB_LABEL_ENABLED 7821
#define IDS_SETTINGS_AD_PRIVACY_PAGE_FLEDGE_LINK_ROW_SUB_LABEL_DISABLED 7822
#define IDS_SETTINGS_AD_PRIVACY_PAGE_AD_MEASUREMENT_LINK_ROW_LABEL 7823
#define IDS_SETTINGS_AD_PRIVACY_PAGE_AD_MEASUREMENT_LINK_ROW_SUB_LABEL_ENABLED 7824
#define IDS_SETTINGS_AD_PRIVACY_PAGE_AD_MEASUREMENT_LINK_ROW_SUB_LABEL_DISABLED 7825
#define IDS_SETTINGS_TOPICS_PAGE_CURRENT_TOPICS_DESCRIPTION 7826
#define IDS_SETTINGS_TOPICS_PAGE_CURRENT_TOPICS_DESCRIPTION_LEARN_MORE_A11Y_LABEL 7827
#define IDS_SETTINGS_TOPICS_PAGE_CURRENT_TOPICS_DESCRIPTION_LEARN_MORE_LINK 7828
#define IDS_SETTINGS_TOPICS_PAGE_CURRENT_TOPICS_REGION_A11Y_DESCRIPTION 7829
#define IDS_SETTINGS_TOPICS_PAGE_BLOCKED_TOPICS_REGION_A11Y_DESCRIPTION 7830
#define IDS_SETTINGS_TOPICS_PAGE_LEARN_MORE_BULLET_3 7831
#define IDS_SETTINGS_TOPICS_PAGE_FOOTER 7832
#define IDS_SETTINGS_TOPICS_PAGE_FOOTER_V2 7833
#define IDS_SETTINGS_FLEDGE_PAGE_TITLE 7834
#define IDS_SETTINGS_FLEDGE_PAGE_TOGGLE_LABEL 7835
#define IDS_SETTINGS_FLEDGE_PAGE_TOGGLE_SUB_LABEL 7836
#define IDS_SETTINGS_FLEDGE_PAGE_CURRENT_SITES_HEADING 7837
#define IDS_SETTINGS_FLEDGE_PAGE_CURRENT_SITES_DESCRIPTION 7838
#define IDS_SETTINGS_FLEDGE_PAGE_CURRENT_SITES_DESCRIPTION_LEARN_MORE 7839
#define IDS_SETTINGS_FLEDGE_PAGE_CURRENT_SITES_DESCRIPTION_DISABLED 7840
#define IDS_SETTINGS_FLEDGE_PAGE_CURRENT_SITES_DESCRIPTION_EMPTY 7841
#define IDS_SETTINGS_FLEDGE_PAGE_CURRENT_SITES_REGION_A11Y_DESCRIPTION 7842
#define IDS_SETTINGS_FLEDGE_PAGE_SEE_ALL_SITES_LABEL 7843
#define IDS_SETTINGS_FLEDGE_PAGE_BLOCK_SITE 7844
#define IDS_SETTINGS_FLEDGE_PAGE_BLOCK_SITE_A11Y_LABEL 7845
#define IDS_SETTINGS_FLEDGE_PAGE_BLOCKED_SITES_HEADING 7846
#define IDS_SETTINGS_FLEDGE_PAGE_BLOCKED_SITES_DESCRIPTION 7847
#define IDS_SETTINGS_FLEDGE_PAGE_BLOCKED_SITES_DESCRIPTION_EMPTY 7848
#define IDS_SETTINGS_FLEDGE_PAGE_BLOCKED_SITES_REGION_A11Y_DESCRIPTION 7849
#define IDS_SETTINGS_FLEDGE_PAGE_ALLOW_SITE 7850
#define IDS_SETTINGS_FLEDGE_PAGE_ALLOW_SITE_A11Y_LABEL 7851
#define IDS_SETTINGS_FLEDGE_PAGE_FOOTER 7852
#define IDS_SETTINGS_FLEDGE_PAGE_LEARN_MORE_HEADING 7853
#define IDS_SETTINGS_FLEDGE_PAGE_LEARN_MORE_BULLET_1 7854
#define IDS_SETTINGS_FLEDGE_PAGE_LEARN_MORE_BULLET_2 7855
#define IDS_SETTINGS_FLEDGE_PAGE_LEARN_MORE_BULLET_3 7856
#define IDS_SETTINGS_FLEDGE_PAGE_CURRENT_SITES_DESCRIPTION_LEARN_MORE_A11Y_LABEL 7857
#define IDS_SETTINGS_AD_MEASUREMENT_PAGE_TITLE 7858
#define IDS_SETTINGS_AD_MEASUREMENT_PAGE_TOGGLE_LABEL 7859
#define IDS_SETTINGS_AD_MEASUREMENT_PAGE_TOGGLE_SUB_LABEL 7860
#define IDS_SETTINGS_AD_MEASUREMENT_PAGE_ENABLED_BULLET_1 7861
#define IDS_SETTINGS_AD_MEASUREMENT_PAGE_ENABLED_BULLET_2 7862
#define IDS_SETTINGS_AD_MEASUREMENT_PAGE_ENABLED_BULLET_3 7863
#define IDS_SETTINGS_AD_MEASUREMENT_PAGE_CONSIDER_BULLET_1 7864
#define IDS_SETTINGS_AD_MEASUREMENT_PAGE_CONSIDER_BULLET_2 7865
#define IDS_SETTINGS_PRIVACY_GUIDE_LABEL 7866
#define IDS_SETTINGS_PRIVACY_GUIDE_SUBLABEL 7867
#define IDS_SETTINGS_PRIVACY_GUIDE_PROMO_HEADER 7868
#define IDS_SETTINGS_PRIVACY_GUIDE_PROMO_START_BUTTON 7869
#define IDS_SETTINGS_PRIVACY_GUIDE_BACK_TO_SETTINGS_ARIA_LABEL 7870
#define IDS_SETTINGS_PRIVACY_GUIDE_BACK_TO_SETTINGS_ARIA_ROLE_DESC 7871
#define IDS_SETTINGS_PRIVACY_GUIDE_BACK_BUTTON 7872
#define IDS_SETTINGS_PRIVACY_GUIDE_STEPS 7873
#define IDS_SETTINGS_PRIVACY_GUIDE_NEXT_BUTTON 7874
#define IDS_SETTINGS_PRIVACY_GUIDE_FEATURE_DESCRIPTION_HEADER 7875
#define IDS_SETTINGS_PRIVACY_GUIDE_THINGS_TO_CONSIDER 7876
#define IDS_SETTINGS_PRIVACY_GUIDE_WELCOME_CARD_HEADER 7877
#define IDS_SETTINGS_PRIVACY_GUIDE_WELCOME_CARD_SUB_HEADER 7878
#define IDS_SETTINGS_PRIVACY_GUIDE_COMPLETION_CARD_HEADER 7879
#define IDS_SETTINGS_PRIVACY_GUIDE_COMPLETION_CARD_SUB_HEADER 7880
#define IDS_SETTINGS_PRIVACY_GUIDE_COMPLETION_CARD_SUB_HEADER_NO_LINKS 7881
#define IDS_SETTINGS_PRIVACY_GUIDE_COMPLETION_CARD_LEAVE_BUTTON 7882
#define IDS_SETTINGS_PRIVACY_GUIDE_COMPLETION_CARD_PRIVACY_SANDBOX_LABEL 7883
#define IDS_SETTINGS_PRIVACY_GUIDE_COMPLETION_CARD_WAA_LABEL 7884
#define IDS_SETTINGS_PRIVACY_GUIDE_MSBB_CARD_HEADER 7885
#define IDS_SETTINGS_PRIVACY_GUIDE_MSBB_FEATURE_DESCRIPTION1 7886
#define IDS_SETTINGS_PRIVACY_GUIDE_MSBB_FEATURE_DESCRIPTION2 7887
#define IDS_SETTINGS_PRIVACY_GUIDE_MSBB_PRIVACY_DESCRIPTION1 7888
#define IDS_SETTINGS_PRIVACY_GUIDE_HISTORY_SYNC_CARD_HEADER 7889
#define IDS_SETTINGS_PRIVACY_GUIDE_HISTORY_SYNC_SETTING_LABEL 7890
#define IDS_SETTINGS_PRIVACY_GUIDE_HISTORY_SYNC_FEATURE_DESCRIPTION1 7891
#define IDS_SETTINGS_PRIVACY_GUIDE_HISTORY_SYNC_FEATURE_DESCRIPTION2 7892
#define IDS_SETTINGS_PRIVACY_GUIDE_HISTORY_SYNC_PRIVACY_DESCRIPTION1 7893
#define IDS_SETTINGS_PRIVACY_GUIDE_COOKIES_CARD_HEADER 7894
#define IDS_SETTINGS_PRIVACY_GUIDE_COOKIES_CARD_BLOCK_TPC_INCOGNITO_SUBHEADER 7895
#define IDS_SETTINGS_PRIVACY_GUIDE_COOKIES_CARD_BLOCK_TPC_INCOGNITO_FEATURE_DESCRIPTION1 7896
#define IDS_SETTINGS_PRIVACY_GUIDE_COOKIES_CARD_BLOCK_TPC_INCOGNITO_FEATURE_DESCRIPTION2 7897
#define IDS_SETTINGS_PRIVACY_GUIDE_COOKIES_CARD_BLOCK_TPC_INCOGNITO_PRIVACY_DESCRIPTION1 7898
#define IDS_SETTINGS_PRIVACY_GUIDE_COOKIES_CARD_BLOCK_TPC_INCOGNITO_PRIVACY_DESCRIPTION2 7899
#define IDS_SETTINGS_PRIVACY_GUIDE_COOKIES_CARD_BLOCK_TPC_SUBHEADER 7900
#define IDS_SETTINGS_PRIVACY_GUIDE_COOKIES_CARD_BLOCK_TPC_FEATURE_DESCRIPTION1 7901
#define IDS_SETTINGS_PRIVACY_GUIDE_COOKIES_CARD_BLOCK_TPC_FEATURE_DESCRIPTION2 7902
#define IDS_SETTINGS_PRIVACY_GUIDE_COOKIES_CARD_BLOCK_TPC_PRIVACY_DESCRIPTION1 7903
#define IDS_SETTINGS_PRIVACY_GUIDE_SAFE_BROWSING_CARD_HEADER 7904
#define IDS_SETTINGS_PRIVACY_GUIDE_SAFE_BROWSING_CARD_ENHANCED_PROTECTION_PRIVACY_DESCRIPTION1 7905
#define IDS_SETTINGS_PRIVACY_GUIDE_SAFE_BROWSING_CARD_ENHANCED_PROTECTION_PRIVACY_DESCRIPTION2 7906
#define IDS_SETTINGS_PRIVACY_GUIDE_SAFE_BROWSING_CARD_ENHANCED_PROTECTION_PRIVACY_DESCRIPTION3 7907
#define IDS_SETTINGS_PRIVACY_GUIDE_SAFE_BROWSING_CARD_STANDARD_PROTECTION_FEATURE_DESCRIPTION1 7908
#define IDS_SETTINGS_SAFETY_CHECK_SECTION_TITLE 7911
#define IDS_SETTINGS_SAFETY_CHECK_RUNNING 7912
#define IDS_SETTINGS_SAFETY_CHECK_PARENT_PRIMARY_LABEL_AFTER 7913
#define IDS_SETTINGS_SAFETY_CHECK_PARENT_PRIMARY_LABEL_AFTER_MINS 7914
#define IDS_SETTINGS_SAFETY_CHECK_PARENT_PRIMARY_LABEL_AFTER_HOURS 7915
#define IDS_SETTINGS_SAFETY_CHECK_PARENT_PRIMARY_LABEL_AFTER_TIME 7916
#define IDS_SETTINGS_SAFETY_CHECK_PARENT_PRIMARY_LABEL_AFTER_TODAY 7917
#define IDS_SETTINGS_SAFETY_CHECK_PARENT_PRIMARY_LABEL_AFTER_YESTERDAY 7918
#define IDS_SETTINGS_SAFETY_CHECK_PARENT_PRIMARY_LABEL_AFTER_DAYS 7919
#define IDS_SETTINGS_SAFETY_CHECK_PARENT_PRIMARY_LABEL_AFTER_DATE 7920
#define IDS_SETTINGS_SAFETY_CHECK_ARIA_LIVE_RUNNING 7921
#define IDS_SETTINGS_SAFETY_CHECK_ARIA_LIVE_AFTER 7922
#define IDS_SETTINGS_SAFETY_CHECK_PARENT_BUTTON 7923
#define IDS_SETTINGS_SAFETY_CHECK_PARENT_BUTTON_ARIA_LABEL 7924
#define IDS_SETTINGS_SAFETY_CHECK_PARENT_RUN_AGAIN_BUTTON_ARIA_LABEL 7925
#define IDS_SETTINGS_SAFETY_CHECK_ICON_RUNNING_ARIA_LABEL 7926
#define IDS_SETTINGS_SAFETY_CHECK_ICON_SAFE_ARIA_LABEL 7927
#define IDS_SETTINGS_SAFETY_CHECK_ICON_INFO_ARIA_LABEL 7928
#define IDS_SETTINGS_SAFETY_CHECK_ICON_WARNING_ARIA_LABEL 7929
#define IDS_SETTINGS_SAFETY_CHECK_REVIEW 7930
#define IDS_SETTINGS_SAFETY_CHECK_UNUSED_SITE_PERMISSIONS_ALLOW_AGAIN_ARIA_LABEL 7931
#define IDS_SETTINGS_SAFETY_CHECK_UNUSED_SITE_PERMISSIONS_ALLOW_AGAIN_LABEL 7932
#define IDS_SETTINGS_SAFETY_CHECK_UNUSED_SITE_PERMISSIONS_HEADER_ARIA_LABEL 7933
#define IDS_SETTINGS_SAFETY_CHECK_UNUSED_SITE_PERMISSIONS_HEADER_LABEL 7934
#define IDS_SETTINGS_SAFETY_CHECK_UNUSED_SITE_PERMISSIONS_REMOVED_ONE_PERMISSION_LABEL 7935
#define IDS_SETTINGS_SAFETY_CHECK_UNUSED_SITE_PERMISSIONS_REMOVED_TWO_PERMISSIONS_LABEL 7936
#define IDS_SETTINGS_SAFETY_CHECK_UNUSED_SITE_PERMISSIONS_REMOVED_THREE_PERMISSIONS_LABEL 7937
#define IDS_SETTINGS_SAFETY_CHECK_UNUSED_SITE_PERMISSIONS_REMOVED_FOUR_OR_MORE_PERMISSIONS_LABEL 7938
#define IDS_SETTINGS_SAFETY_CHECK_UNUSED_SITE_PERMISSIONS_PRIMARY_LABEL 7939
#define IDS_SETTINGS_SAFETY_CHECK_UNUSED_SITE_PERMISSIONS_SECONDARY_LABEL 7940
#define IDS_SETTINGS_SAFETY_HUB_REVOKED_PERMISSIONS_SECONDARY_LABEL 7941
#define IDS_SETTINGS_SAFETY_CHECK_UNUSED_SITE_PERMISSIONS_TOAST_BULK_LABEL 7942
#define IDS_SETTINGS_SAFETY_CHECK_UNUSED_SITE_PERMISSIONS_TOAST_LABEL 7943
#define IDS_SETTINGS_SAFETY_CHECK_UNUSED_SITE_PERMISSIONS_SETTING_LABEL 7944
#define IDS_SETTINGS_SAFETY_CHECK_UPDATES_PRIMARY_LABEL 7945
#define IDS_SETTINGS_SAFETY_CHECK_UPDATES_DISABLED_BY_ADMIN 7946
#define IDS_SETTINGS_SAFETY_CHECK_PASSWORDS_PRIMARY_LABEL 7947
#define IDS_SETTINGS_SAFETY_CHECK_PASSWORDS_FEATURE_UNAVAILABLE 7948
#define IDS_SETTINGS_SAFETY_CHECK_PASSWORDS_BUTTON_ARIA_LABEL 7949
#define IDS_SETTINGS_SAFETY_CHECK_SAFE_BROWSING_ENABLED 7950
#define IDS_SETTINGS_SAFETY_CHECK_SAFE_BROWSING_ENABLED_STANDARD 7951
#define IDS_SETTINGS_SAFETY_CHECK_SAFE_BROWSING_ENABLED_STANDARD_AVAILABLE_ENHANCED 7952
#define IDS_SETTINGS_SAFETY_CHECK_SAFE_BROWSING_ENABLED_ENHANCED 7953
#define IDS_SETTINGS_SAFETY_CHECK_SAFE_BROWSING_DISABLED_BY_ADMIN 7954
#define IDS_SETTINGS_SAFETY_CHECK_SAFE_BROWSING_DISABLED_BY_EXTENSION 7955
#define IDS_SETTINGS_SAFETY_CHECK_SAFE_BROWSING_BUTTON 7956
#define IDS_SETTINGS_SAFETY_CHECK_SAFE_BROWSING_BUTTON_ARIA_LABEL 7957
#define IDS_SETTINGS_SAFETY_CHECK_EXTENSIONS_PRIMARY_LABEL 7958
#define IDS_SETTINGS_SAFETY_CHECK_EXTENSIONS_SAFE 7959
#define IDS_SETTINGS_SAFETY_CHECK_EXTENSIONS_BLOCKLISTED_OFF 7960
#define IDS_SETTINGS_SAFETY_CHECK_EXTENSIONS_BLOCKLISTED_ON_USER 7961
#define IDS_SETTINGS_SAFETY_CHECK_EXTENSIONS_BLOCKLISTED_ON_ADMIN 7962
#define IDS_SETTINGS_SAFETY_CHECK_EXTENSIONS_BUTTON_ARIA_LABEL 7963
#define IDS_SETTINGS_SAFETY_CHECK_REVIEW_EXTENSIONS 7964
#define IDS_SETTINGS_SAFETY_CHECK_REVIEW_NOTIFICATION_PERMISSIONS_PRIMARY_LABEL 7965
#define IDS_SETTINGS_SAFETY_CHECK_NOTIFICATION_PERMISSIONS_REVIEW_BUTTON_ARIA_LABEL 7966
#define IDS_SETTINGS_SAFETY_CHECK_REVIEW_NOTIFICATION_PERMISSIONS_SECONDARY_LABEL 7967
#define IDS_SETTINGS_SAFETY_CHECK_NOTIFICATION_PERMISSION_REVIEW_IGNORED_TOAST_LABEL 7968
#define IDS_SETTINGS_SAFETY_CHECK_NOTIFICATION_PERMISSION_REVIEW_BLOCKED_TOAST_LABEL 7969
#define IDS_SETTINGS_SAFETY_CHECK_NOTIFICATION_PERMISSION_REVIEW_RESET_TOAST_LABEL 7970
#define IDS_SETTINGS_SAFETY_CHECK_REVIEW_NOTIFICATION_PERMISSIONS_COUNT_LABEL 7971
#define IDS_SETTINGS_SAFETY_CHECK_REVIEW_NOTIFICATION_PERMISSIONS_DONT_ALLOW_LABEL 7972
#define IDS_SETTINGS_SAFETY_CHECK_REVIEW_NOTIFICATION_PERMISSIONS_DONT_ALLOW_ARIA_LABEL 7973
#define IDS_SETTINGS_SAFETY_CHECK_REVIEW_NOTIFICATION_PERMISSIONS_IGNORE_LABEL 7974
#define IDS_SETTINGS_SAFETY_CHECK_REVIEW_NOTIFICATION_PERMISSIONS_IGNORE_ARIA_LABEL 7975
#define IDS_SETTINGS_SAFETY_CHECK_REVIEW_NOTIFICATION_PERMISSIONS_RESET_LABEL 7976
#define IDS_SETTINGS_SAFETY_CHECK_REVIEW_NOTIFICATION_PERMISSIONS_RESET_ARIA_LABEL 7977
#define IDS_SETTINGS_SAFETY_CHECK_REVIEW_NOTIFICATION_PERMISSIONS_MORE_ACTIONS_ARIA_LABEL 7978
#define IDS_SETTINGS_SAFETY_CHECK_REVIEW_NOTIFICATION_PERMISSIONS_HEADER_LABEL 7979
#define IDS_SETTINGS_SAFETY_CHECK_NOTIFICATION_PERMISSION_REVIEW_BLOCK_ALL_LABEL 7980
#define IDS_SETTINGS_SAFETY_CHECK_NOTIFICATION_PERMISSION_REVIEW_BLOCK_ALL_TOAST_LABEL 7981
#define IDS_SETTINGS_SAFETY_CHECK_SITE_PERMISSIONS_REVIEW_DONE_LABEL 7982
#define IDS_SETTINGS_SAFETY_CHECK_TOAST_UNDO_BUTTON_LABEL 7983
#define IDS_SETTINGS_NETWORK_PREDICTION_ENABLED_DESC 7984
#define IDS_SETTINGS_SAFEBROWSING_ENABLEPROTECTION 7985
#define IDS_SETTINGS_SAFEBROWSING_ENABLEPROTECTION_DESC 7986
#define IDS_SETTINGS_SAFEBROWSING_ENABLE_REPORTING_DESC 7987
#define IDS_SETTINGS_SAFEBROWSING_SECTION_LABEL 7988
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED 7989
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_DESC 7990
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_DESC_UPDATED 7991
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_EXPAND_ACCESSIBILITY_LABEL 7992
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_BULLET_ONE 7993
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_BULLET_THREE 7994
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_BULLET_FOUR 7995
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_BULLET_FIVE 7996
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_WHEN_ON_BULLET_TWO 7997
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_WHEN_ON_BULLET_THREE 7998
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_WHEN_ON_BULLET_FOUR 7999
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_WHEN_ON_BULLET_FIVE 8000
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_THINGS_TO_CONSIDER_BULLET_ONE 8001
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_THINGS_TO_CONSIDER_BULLET_TWO 8002
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_THINGS_TO_CONSIDER_BULLET_THREE 8003
#define IDS_SETTINGS_SAFEBROWSING_STANDARD 8004
#define IDS_SETTINGS_SAFEBROWSING_STANDARD_DESC 8005
#define IDS_SETTINGS_SAFEBROWSING_STANDARD_DESC_UPDATED 8006
#define IDS_SETTINGS_SAFEBROWSING_STANDARD_EXPAND_ACCESSIBILITY_LABEL 8009
#define IDS_SETTINGS_SAFEBROWSING_STANDARD_BULLET_ONE 8010
#define IDS_SETTINGS_SAFEBROWSING_STANDARD_HELP_IMPROVE 8011
#define IDS_SETTINGS_SAFEBROWSING_NONE 8012
#define IDS_SETTINGS_SAFEBROWSING_NONE_DESC 8013
#define IDS_SETTINGS_SAFEBROWSING_NONE_DESC_UPDATED 8014
#define IDS_SETTINGS_SAFEBROWSING_DISABLE_DIALOG_TITLE 8015
#define IDS_SETTINGS_SAFEBROWSING_DISABLE_DIALOG_DESC 8016
#define IDS_SETTINGS_SAFEBROWSING_DISABLE_DIALOG_CONFIRM 8017
#define IDS_SETTINGS_ENABLE_DO_NOT_TRACK 8018
#define IDS_SETTINGS_ENABLE_DO_NOT_TRACK_DIALOG_TITLE 8019
#define IDS_SETTINGS_ENABLE_DO_NOT_TRACK_DIALOG_TEXT 8020
#define IDS_SETTINGS_ENABLE_DO_NOT_TRACK_DIALOG_LEARN_MORE_ACCESSIBILITY_LABEL 8021
#define IDS_SETTINGS_PERMISSIONS 8022
#define IDS_SETTINGS_PERMISSIONS_DESCRIPTION 8023
#define IDS_SETTINGS_SECURITY 8024
#define IDS_SETTINGS_SECURITY_DESCRIPTION 8025
#define IDS_SETTINGS_ADVANCED_PROTECTION_PROGRAM 8026
#define IDS_SETTINGS_ADVANCED_PROTECTION_PROGRAM_DESC 8027
#define IDS_SETTINGS_HTTPS_ONLY_MODE 8028
#define IDS_SETTINGS_HTTPS_ONLY_MODE_DESCRIPTION 8029
#define IDS_SETTINGS_HTTPS_ONLY_MODE_DESCRIPTION_ADVANCED_PROTECTION 8030
#define IDS_SETTINGS_HTTPS_FIRST_MODE_TITLE 8031
#define IDS_SETTINGS_HTTPS_FIRST_MODE_ENABLED_FULL_LABEL 8032
#define IDS_SETTINGS_HTTPS_FIRST_MODE_ENABLED_INCOGNITO_LABEL 8033
#define IDS_SETTINGS_HTTPS_FIRST_MODE_DISABLED_LABEL 8034
#define IDS_SETTINGS_MANAGE_CERTIFICATES 8035
#define IDS_SETTINGS_MANAGE_CERTIFICATES_DESCRIPTION 8036
#define IDS_SETTINGS_MANAGE_DEVICE_CERTIFICATES 8037
#define IDS_SETTINGS_MANAGE_DEVICE_CERTIFICATES_DESCRIPTION 8038
#define IDS_SETTINGS_MANAGE 8039
#define IDS_SETTINGS_SECURE_DNS 8040
#define IDS_SETTINGS_AUTOMATIC_MODE_DESCRIPTION 8042
#define IDS_SETTINGS_SECURE_DNS_DROPDOWN_ACCESSIBILITY_LABEL 8043
#define IDS_SETTINGS_SECURE_DROPDOWN_MODE_DESCRIPTION 8044
#define IDS_SETTINGS_SECURE_DROPDOWN_MODE_PRIVACY_POLICY 8045
#define IDS_SETTINGS_SECURE_DNS_DISABLED_FOR_MANAGED_ENVIRONMENT 8046
#define IDS_SETTINGS_SECURE_DNS_DISABLED_FOR_PARENTAL_CONTROL 8047
#define IDS_SETTINGS_SECURE_DNS_CUSTOM_DESCRIPTION 8048
#define IDS_SETTINGS_SECURE_DNS_CUSTOM_PLACEHOLDER 8049
#define IDS_SETTINGS_SECURE_DNS_CUSTOM_FORMAT_ERROR 8050
#define IDS_SETTINGS_SECURE_DNS_CUSTOM_CONNECTION_ERROR 8051
#define IDS_SETTINGS_SECURITY_V8_LINK_TITLE 8052
#define IDS_SETTINGS_CONTENT_SETTINGS 8053
#define IDS_SETTINGS_SITE_SETTINGS 8054
#define IDS_SETTINGS_SITE_SETTINGS_DESCRIPTION 8055
#define IDS_SETTINGS_CLEAR_DATA 8056
#define IDS_SETTINGS_CLEARING_DATA 8057
#define IDS_SETTINGS_CLEARED_DATA 8058
#define IDS_SETTINGS_CLEAR_BROWSING_DATA 8059
#define IDS_SETTINGS_CLEAR_DATA_DESCRIPTION 8060
#define IDS_SETTINGS_TITLE_AND_COUNT 8061
#define IDS_SETTINGS_SYNC_AND_GOOGLE_SERVICES_PRIVACY_DESC_UNIFIED_CONSENT 8062
#define IDS_SETTINGS_RECENT_PERMISSIONS_NO_CHANGES 8063
#define IDS_SETTINGS_RECENT_PERMISSIONS_ALLOWED_ONE_ITEM 8064
#define IDS_SETTINGS_RECENT_PERMISSIONS_ALLOWED_TWO_ITEMS 8065
#define IDS_SETTINGS_RECENT_PERMISSIONS_ALLOWED_MORE_THAN_TWO_ITEMS 8066
#define IDS_SETTINGS_RECENT_PERMISSIONS_AUTOMATICALLY_BLOCKED_ONE_ITEM 8067
#define IDS_SETTINGS_RECENT_PERMISSIONS_AUTOMATICALLY_BLOCKED_TWO_ITEMS 8068
#define IDS_SETTINGS_RECENT_PERMISSIONS_AUTOMATICALLY_BLOCKED_MORE_THAN_TWO_ITEMS 8069
#define IDS_SETTINGS_RECENT_PERMISSIONS_BLOCKED_ONE_ITEM 8070
#define IDS_SETTINGS_RECENT_PERMISSIONS_BLOCKED_TWO_ITEMS 8071
#define IDS_SETTINGS_RECENT_PERMISSIONS_BLOCKED_MORE_THAN_TWO_ITEMS 8072
#define IDS_SETTINGS_RESET_PROMPT_TITLE 8073
#define IDS_SETTINGS_RESET 8074
#define IDS_SETTINGS_RESET_SETTINGS_TRIGGER 8075
#define IDS_SETTINGS_RESET_AUTOMATED_DIALOG_TITLE 8076
#define IDS_SETTINGS_RESET_BANNER_TEXT 8077
#define IDS_SETTINGS_RESET_BANNER_RESET_BUTTON_TEXT 8078
#define IDS_SETTINGS_RESET_LEARN_MORE_ACCESSIBILITY_TEXT 8079
#define IDS_SETTINGS_SEARCH 8082
#define IDS_SETTINGS_SEARCH_EXPLANATION 8083
#define IDS_SETTINGS_SEARCH_EXPLANATION_ACCESSIBILITY_LABEL 8085
#define IDS_SETTINGS_SEARCH_MANAGE_SEARCH_ENGINES 8086
#define IDS_SETTINGS_SEARCH_MANAGE_SEARCH_ENGINES_AND_SITE_SEARCH 8087
#define IDS_SETTINGS_SEARCH_MANAGE_SEARCH_ENGINES_EXPLANATION 8088
#define IDS_SETTINGS_SEARCH_ENGINES 8089
#define IDS_SETTINGS_SEARCH_ENGINES_PAGE_EXPLANATION 8090
#define IDS_SETTINGS_SEARCH_ENGINES_SEARCH 8091
#define IDS_SETTINGS_SEARCH_ENGINES_ADD_SITE_SEARCH 8092
#define IDS_SETTINGS_SEARCH_ENGINES_EDIT_SEARCH_ENGINE 8093
#define IDS_SETTINGS_SEARCH_ENGINES_EDIT_SITE_SEARCH 8094
#define IDS_SETTINGS_SEARCH_ENGINES_VIEW_SITE_SEARCH 8095
#define IDS_SETTINGS_SEARCH_ENGINES_DELETE_CONFIRMATION_TITLE 8096
#define IDS_SETTINGS_SEARCH_ENGINES_DELETE_CONFIRMATION_DESCRIPTION 8097
#define IDS_SETTINGS_SEARCH_ENGINES_SEARCH_ENGINES 8098
#define IDS_SETTINGS_SEARCH_ENGINES_SEARCH_ENGINES_EXPLANATION 8099
#define IDS_SETTINGS_SEARCH_ENGINES_SITE_SEARCH 8100
#define IDS_SETTINGS_SEARCH_ENGINES_SITE_SEARCH_EXPLANATION 8101
#define IDS_SETTINGS_SEARCH_ENGINES_SITE_SEARCH_EXPLANATION_STARTER_PACK 8102
#define IDS_SETTINGS_SEARCH_ENGINES_NO_SITES_ADDED 8103
#define IDS_SETTINGS_SEARCH_ENGINES_INACTIVE_SHORTCUTS 8104
#define IDS_SETTINGS_SEARCH_ENGINES_NO_OTHER_ENGINES 8105
#define IDS_SETTINGS_SEARCH_ENGINES_EXTENSION_ENGINES 8106
#define IDS_SETTINGS_SEARCH_ENGINES_EXTENSION_ENGINES_EXPLANATION 8107
#define IDS_SETTINGS_SEARCH_ENGINES_NAME 8108
#define IDS_SETTINGS_SEARCH_ENGINES_SHORTCUT 8109
#define IDS_SETTINGS_SEARCH_ENGINES_QUERY_URL 8110
#define IDS_SETTINGS_SEARCH_ENGINES_QUERY_URL_EXPLANATION 8111
#define IDS_SETTINGS_SEARCH_ENGINES_MAKE_DEFAULT 8112
#define IDS_SETTINGS_SEARCH_ENGINES_ACTIVATE 8113
#define IDS_SETTINGS_SEARCH_ENGINES_DEACTIVATE 8114
#define IDS_SETTINGS_SEARCH_ENGINES_VIEW_DETAILS 8115
#define IDS_SETTINGS_SEARCH_ENGINES_MANAGE_EXTENSION 8116
#define IDS_SETTINGS_SEARCH_ENGINES_KEYBOARD_SHORTCUTS_TITLE 8117
#define IDS_SETTINGS_SEARCH_ENGINES_KEYBOARD_SHORTCUTS_DESCRIPTION 8118
#define IDS_SETTINGS_SEARCH_ENGINES_KEYBOARD_SHORTCUTS_DESCRIPTION_STARTER_PACK 8119
#define IDS_SETTINGS_SEARCH_ENGINES_KEYBOARD_SHORTCUTS_SPACE_OR_TAB 8120
#define IDS_SETTINGS_SEARCH_ENGINES_KEYBOARD_SHORTCUTS_TAB 8121
#define IDS_SETTINGS_SEARCH_ENGINES_ADDITIONAL_SITES 8122
#define IDS_SETTINGS_SEARCH_ENGINES_ADDITIONAL_INACTIVE_SITES 8123
#define IDS_SETTINGS_EXCEPTIONS_EMBEDDED_ON_HOST 8124
#define IDS_SETTINGS_EXCEPTIONS_EMBEDDED_ON_ANY_HOST 8125
#define IDS_SETTINGS_SITE_SETTINGS_ALL_SITES 8126
#define IDS_SETTINGS_SITE_SETTINGS_ALL_SITES_DESCRIPTION 8127
#define IDS_SETTINGS_SITE_SETTINGS_ALL_SITES_SEARCH 8128
#define IDS_SETTINGS_SITE_SETTINGS_ALL_SITES_SORT 8129
#define IDS_SETTINGS_SITE_SETTINGS_ALL_SITES_SORT_METHOD_MOST_VISITED 8130
#define IDS_SETTINGS_SITE_SETTINGS_ALL_SITES_SORT_METHOD_STORAGE 8131
#define IDS_SETTINGS_SITE_SETTINGS_ALL_SITES_SORT_METHOD_NAME 8132
#define IDS_SETTINGS_SITE_SETTINGS_FILE_SYSTEM_SITE_LIST_HEADER 8133
#define IDS_SETTINGS_SITE_SETTINGS_FILE_SYSTEM_SITE_LIST_EDIT_HEADER 8134
#define IDS_SETTINGS_SITE_SETTINGS_FILE_SYSTEM_SITE_LIST_REMOVE_GRANT_LABEL 8135
#define IDS_SETTINGS_SITE_SETTINGS_FILE_SYSTEM_SITE_LIST_REMOVE_GRANTS 8136
#define IDS_SETTINGS_SITE_SETTINGS_FILE_SYSTEM_SITE_LIST_VIEW_HEADER 8137
#define IDS_SETTINGS_SITE_SETTINGS_FILE_SYSTEM_SITE_LIST_VIEW_SITE_DETAILS 8138
#define IDS_SETTINGS_SITE_SETTINGS_SITE_ENTRY_PARTITIONED_LABEL 8139
#define IDS_SETTINGS_SITE_SETTINGS_SITE_REPRESENTATION_SEPARATOR 8140
#define IDS_SETTINGS_SITE_SETTINGS_DEFAULT_BEHAVIOR 8141
#define IDS_SETTINGS_SITE_SETTINGS_DEFAULT_BEHAVIOR_DESCRIPTION 8142
#define IDS_SETTINGS_SITE_SETTINGS_NOTIFICATIONS_DEFAULT_BEHAVIOR_DESC 8143
#define IDS_SETTINGS_SITE_SETTINGS_CUSTOMIZED_BEHAVIORS 8144
#define IDS_SETTINGS_SITE_SETTINGS_CUSTOMIZED_BEHAVIORS_DESCRIPTION 8145
#define IDS_SETTINGS_SITE_SETTINGS_CUSTOMIZED_BEHAVIORS_DESCRIPTION_SHORT 8146
#define IDS_SETTINGS_SITE_SETTINGS_ADS_DESCRIPTION 8147
#define IDS_SETTINGS_SITE_SETTINGS_ADS_ALLOWED 8148
#define IDS_SETTINGS_SITE_SETTINGS_ADS_BLOCKED 8149
#define IDS_SETTINGS_SITE_SETTINGS_ADS_ALLOWED_EXCEPTIONS 8150
#define IDS_SETTINGS_SITE_SETTINGS_ADS_BLOCKED_EXCEPTIONS 8151
#define IDS_SETTINGS_SITE_SETTINGS_AR_DESCRIPTION 8152
#define IDS_SETTINGS_SITE_SETTINGS_AR_ALLOWED 8153
#define IDS_SETTINGS_SITE_SETTINGS_AR_BLOCKED 8154
#define IDS_SETTINGS_SITE_SETTINGS_AR_ALLOWED_EXCEPTIONS 8155
#define IDS_SETTINGS_SITE_SETTINGS_AR_BLOCKED_EXCEPTIONS 8156
#define IDS_SETTINGS_SITE_SETTINGS_AUTOMATIC_DOWNLOADS_DESCRIPTION 8157
#define IDS_SETTINGS_SITE_SETTINGS_AUTOMATIC_DOWNLOADS_ALLOWED 8158
#define IDS_SETTINGS_SITE_SETTINGS_AUTOMATIC_DOWNLOADS_BLOCKED 8159
#define IDS_SETTINGS_SITE_SETTINGS_AUTOMATIC_DOWNLOADS_ALLOWED_EXCEPTIONS 8160
#define IDS_SETTINGS_SITE_SETTINGS_AUTOMATIC_DOWNLOADS_BLOCKED_EXCEPTIONS 8161
#define IDS_SETTINGS_SITE_SETTINGS_AUTO_PICTURE_IN_PICTURE_DESCRIPTION 8162
#define IDS_SETTINGS_SITE_SETTINGS_AUTO_PICTURE_IN_PICTURE_ALLOWED 8163
#define IDS_SETTINGS_SITE_SETTINGS_AUTO_PICTURE_IN_PICTURE_BLOCKED 8164
#define IDS_SETTINGS_SITE_SETTINGS_AUTO_PICTURE_IN_PICTURE_ALLOWED_EXCEPTIONS 8165
#define IDS_SETTINGS_SITE_SETTINGS_AUTO_PICTURE_IN_PICTURE_BLOCKED_EXCEPTIONS 8166
#define IDS_SETTINGS_SITE_SETTINGS_BACKGROUND_SYNC_DESCRIPTION 8167
#define IDS_SETTINGS_SITE_SETTINGS_BACKGROUND_SYNC_ALLOWED 8168
#define IDS_SETTINGS_SITE_SETTINGS_BACKGROUND_SYNC_BLOCKED 8169
#define IDS_SETTINGS_SITE_SETTINGS_BACKGROUND_SYNC_BLOCKED_SUB_LABEL 8170
#define IDS_SETTINGS_SITE_SETTINGS_BACKGROUND_SYNC_ALLOWED_EXCEPTIONS 8171
#define IDS_SETTINGS_SITE_SETTINGS_BACKGROUND_SYNC_BLOCKED_EXCEPTIONS 8172
#define IDS_SETTINGS_SITE_SETTINGS_BLUETOOTH_DEVICES_DESCRIPTION 8173
#define IDS_SETTINGS_SITE_SETTINGS_BLUETOOTH_DEVICES_ALLOWED 8174
#define IDS_SETTINGS_SITE_SETTINGS_BLUETOOTH_DEVICES_BLOCKED 8175
#define IDS_SETTINGS_SITE_SETTINGS_CAPTURED_SURFACE_CONTROL_DESCRIPTION 8176
#define IDS_SETTINGS_SITE_SETTINGS_CAPTURED_SURFACE_CONTROL_ALLOWED 8177
#define IDS_SETTINGS_SITE_SETTINGS_CAPTURED_SURFACE_CONTROL_BLOCKED 8178
#define IDS_SETTINGS_SITE_SETTINGS_CAPTURED_SURFACE_CONTROL_ALLOWED_EXCEPTIONS 8179
#define IDS_SETTINGS_SITE_SETTINGS_CAPTURED_SURFACE_CONTROL_BLOCKED_EXCEPTIONS 8180
#define IDS_SETTINGS_SITE_SETTINGS_CAMERA_DESCRIPTION 8181
#define IDS_SETTINGS_SITE_SETTINGS_CAMERA_ALLOWED 8182
#define IDS_SETTINGS_SITE_SETTINGS_CAMERA_BLOCKED 8183
#define IDS_SETTINGS_SITE_SETTINGS_CAMERA_BLOCKED_SUB_LABEL 8184
#define IDS_SETTINGS_SITE_SETTINGS_CAMERA_ALLOWED_EXCEPTIONS 8185
#define IDS_SETTINGS_SITE_SETTINGS_CAMERA_BLOCKED_EXCEPTIONS 8186
#define IDS_SETTINGS_SITE_SETTINGS_CLIPBOARD_DESCRIPTION 8187
#define IDS_SETTINGS_SITE_SETTINGS_CLIPBOARD_ALLOWED 8188
#define IDS_SETTINGS_SITE_SETTINGS_CLIPBOARD_BLOCKED 8189
#define IDS_SETTINGS_SITE_SETTINGS_CLIPBOARD_ALLOWED_EXCEPTIONS 8190
#define IDS_SETTINGS_SITE_SETTINGS_CLIPBOARD_BLOCKED_EXCEPTIONS 8191
#define IDS_SETTINGS_SITE_SETTINGS_DEVICE_USE_DESCRIPTION 8192
#define IDS_SETTINGS_SITE_SETTINGS_DEVICE_USE_ALLOWED 8193
#define IDS_SETTINGS_SITE_SETTINGS_DEVICE_USE_BLOCKED 8194
#define IDS_SETTINGS_SITE_SETTINGS_DEVICE_USE_ALLOWED_EXCEPTIONS 8195
#define IDS_SETTINGS_SITE_SETTINGS_DEVICE_USE_BLOCKED_EXCEPTIONS 8196
#define IDS_SETTINGS_SITE_SETTINGS_FEDERATED_IDENTITY_API_DESCRIPTION 8197
#define IDS_SETTINGS_SITE_SETTINGS_FEDERATED_IDENTITY_API_ALLOWED 8198
#define IDS_SETTINGS_SITE_SETTINGS_FEDERATED_IDENTITY_API_BLOCKED 8199
#define IDS_SETTINGS_SITE_SETTINGS_FEDERATED_IDENTITY_API_ALLOWED_EXCEPTIONS 8200
#define IDS_SETTINGS_SITE_SETTINGS_FEDERATED_IDENTITY_API_BLOCKED_EXCEPTIONS 8201
#define IDS_SETTINGS_SITE_SETTINGS_FILE_SYSTEM_WRITE_DESCRIPTION 8202
#define IDS_SETTINGS_SITE_SETTINGS_FILE_SYSTEM_WRITE_ALLOWED 8203
#define IDS_SETTINGS_SITE_SETTINGS_FILE_SYSTEM_WRITE_BLOCKED 8204
#define IDS_SETTINGS_SITE_SETTINGS_FILE_SYSTEM_WRITE_BLOCKED_EXCEPTIONS 8205
#define IDS_SETTINGS_SITE_SETTINGS_FONTS_DESCRIPTION 8206
#define IDS_SETTINGS_SITE_SETTINGS_FONTS_ALLOWED 8207
#define IDS_SETTINGS_SITE_SETTINGS_FONTS_BLOCKED 8208
#define IDS_SETTINGS_SITE_SETTINGS_FONTS_ALLOWED_EXCEPTIONS 8209
#define IDS_SETTINGS_SITE_SETTINGS_FONTS_BLOCKED_EXCEPTIONS 8210
#define IDS_SETTINGS_SITE_SETTINGS_AUTOMATIC_FULLSCREEN_DESCRIPTION 8211
#define IDS_SETTINGS_SITE_SETTINGS_AUTOMATIC_FULLSCREEN_ALLOWED_EXCEPTIONS 8212
#define IDS_SETTINGS_SITE_SETTINGS_AUTOMATIC_FULLSCREEN_BLOCKED_EXCEPTIONS 8213
#define IDS_SETTINGS_SITE_SETTINGS_HID_DEVICES_DESCRIPTION 8214
#define IDS_SETTINGS_SITE_SETTINGS_HID_DEVICES_ALLOWED 8215
#define IDS_SETTINGS_SITE_SETTINGS_HID_DEVICES_BLOCKED 8216
#define IDS_SETTINGS_SITE_SETTINGS_IMAGES_DESCRIPTION 8217
#define IDS_SETTINGS_SITE_SETTINGS_IMAGES_ALLOWED 8218
#define IDS_SETTINGS_SITE_SETTINGS_IMAGES_BLOCKED 8219
#define IDS_SETTINGS_SITE_SETTINGS_IMAGES_BLOCKED_SUB_LABEL 8220
#define IDS_SETTINGS_SITE_SETTINGS_IMAGES_ALLOWED_EXCEPTIONS 8221
#define IDS_SETTINGS_SITE_SETTINGS_IMAGES_BLOCKED_EXCEPTIONS 8222
#define IDS_SETTINGS_SITE_SETTINGS_INSECURE_CONTENT_DESCRIPTION 8223
#define IDS_SETTINGS_SITE_SETTINGS_INSECURE_CONTENT_ALLOWED_EXCEPTIONS 8224
#define IDS_SETTINGS_SITE_SETTINGS_INSECURE_CONTENT_BLOCKED_EXCEPTIONS 8225
#define IDS_SETTINGS_SITE_SETTINGS_JAVASCRIPT_DESCRIPTION 8226
#define IDS_SETTINGS_SITE_SETTINGS_JAVASCRIPT_ALLOWED 8227
#define IDS_SETTINGS_SITE_SETTINGS_JAVASCRIPT_BLOCKED 8228
#define IDS_SETTINGS_SITE_SETTINGS_JAVASCRIPT_ALLOWED_EXCEPTIONS 8229
#define IDS_SETTINGS_SITE_SETTINGS_JAVASCRIPT_BLOCKED_EXCEPTIONS 8230
#define IDS_SETTINGS_SITE_SETTINGS_JAVASCRIPT_JIT_ALLOWED 8231
#define IDS_SETTINGS_SITE_SETTINGS_JAVASCRIPT_JIT_BLOCKED 8232
#define IDS_SETTINGS_SITE_SETTINGS_JAVASCRIPT_JIT_BLOCKED_SUB_LABEL 8233
#define IDS_SETTINGS_SITE_SETTINGS_JAVASCRIPT_JIT_ALLOWED_EXCEPTIONS 8234
#define IDS_SETTINGS_SITE_SETTINGS_JAVASCRIPT_JIT_BLOCKED_EXCEPTIONS 8235
#define IDS_SETTINGS_SITE_SETTINGS_KEYBOARD_LOCK_DESCRIPTION 8236
#define IDS_SETTINGS_SITE_SETTINGS_KEYBOARD_LOCK_ALLOWED 8237
#define IDS_SETTINGS_SITE_SETTINGS_KEYBOARD_LOCK_BLOCKED 8238
#define IDS_SETTINGS_SITE_SETTINGS_KEYBOARD_LOCK_ALLOWED_EXCEPTIONS 8239
#define IDS_SETTINGS_SITE_SETTINGS_KEYBOARD_LOCK_BLOCKED_EXCEPTIONS 8240
#define IDS_SETTINGS_SITE_SETTINGS_LOCATION_DESCRIPTION 8241
#define IDS_SETTINGS_SITE_SETTINGS_LOCATION_ALLOWED 8242
#define IDS_SETTINGS_SITE_SETTINGS_LOCATION_BLOCKED 8243
#define IDS_SETTINGS_SITE_SETTINGS_LOCATION_BLOCKED_SUB_LABEL 8244
#define IDS_SETTINGS_SITE_SETTINGS_LOCATION_ALLOWED_EXCEPTIONS 8245
#define IDS_SETTINGS_SITE_SETTINGS_LOCATION_BLOCKED_EXCEPTIONS 8246
#define IDS_SETTINGS_SITE_SETTINGS_MIC_DESCRIPTION 8247
#define IDS_SETTINGS_SITE_SETTINGS_MIC_ALLOWED 8248
#define IDS_SETTINGS_SITE_SETTINGS_MIC_BLOCKED 8249
#define IDS_SETTINGS_SITE_SETTINGS_MIC_BLOCKED_SUB_LABEL 8250
#define IDS_SETTINGS_SITE_SETTINGS_MIC_ALLOWED_EXCEPTIONS 8251
#define IDS_SETTINGS_SITE_SETTINGS_MIC_BLOCKED_EXCEPTIONS 8252
#define IDS_SETTINGS_SITE_SETTINGS_MIDI_DESCRIPTION 8253
#define IDS_SETTINGS_SITE_SETTINGS_MIDI_ALLOWED 8254
#define IDS_SETTINGS_SITE_SETTINGS_MIDI_BLOCKED 8255
#define IDS_SETTINGS_SITE_SETTINGS_MIDI_ALLOWED_EXCEPTIONS 8256
#define IDS_SETTINGS_SITE_SETTINGS_MIDI_BLOCKED_EXCEPTIONS 8257
#define IDS_SETTINGS_SITE_SETTINGS_MOTION_SENSORS_DESCRIPTION 8258
#define IDS_SETTINGS_SITE_SETTINGS_MOTION_SENSORS_ALLOWED 8259
#define IDS_SETTINGS_SITE_SETTINGS_MOTION_SENSORS_BLOCKED 8260
#define IDS_SETTINGS_SITE_SETTINGS_MOTION_SENSORS_BLOCKED_SUB_LABEL 8261
#define IDS_SETTINGS_SITE_SETTINGS_MOTION_SENSORS_ALLOWED_EXCEPTIONS 8262
#define IDS_SETTINGS_SITE_SETTINGS_MOTION_SENSORS_BLOCKED_EXCEPTIONS 8263
#define IDS_SETTINGS_SITE_SETTINGS_NOTIFICATIONS_DESCRIPTION 8264
#define IDS_SETTINGS_SITE_SETTINGS_NOTIFICATIONS_ALLOWED 8265
#define IDS_SETTINGS_SITE_SETTINGS_NOTIFICATIONS_PARTIAL 8266
#define IDS_SETTINGS_SITE_SETTINGS_NOTIFICATIONS_PARTIAL_SUB_LABEL 8267
#define IDS_SETTINGS_SITE_SETTINGS_NOTIFICATIONS_ASK_STATE 8268
#define IDS_SETTINGS_SITE_SETTINGS_PERMISSION_QUIET 8269
#define IDS_SETTINGS_SITE_SETTINGS_PERMISSION_CPSS 8270
#define IDS_SETTINGS_SITE_SETTINGS_PERMISSION_LOUD 8271
#define IDS_SETTINGS_SITE_SETTINGS_NOTIFICATIONS_BLOCKED 8272
#define IDS_SETTINGS_SITE_SETTINGS_NOTIFICATIONS_BLOCKED_SUB_LABEL 8273
#define IDS_SETTINGS_SITE_SETTINGS_NOTIFICATIONS_ALLOWED_EXCEPTIONS 8274
#define IDS_SETTINGS_SITE_SETTINGS_NOTIFICATIONS_BLOCKED_EXCEPTIONS 8275
#define IDS_SETTINGS_SITE_SETTINGS_PAYMENT_HANDLERS_DESCRIPTION 8276
#define IDS_SETTINGS_SITE_SETTINGS_PAYMENT_HANDLERS_ALLOWED 8277
#define IDS_SETTINGS_SITE_SETTINGS_PAYMENT_HANDLERS_BLOCKED 8278
#define IDS_SETTINGS_SITE_SETTINGS_PAYMENT_HANDLERS_ALLOWED_EXCEPTIONS 8279
#define IDS_SETTINGS_SITE_SETTINGS_PAYMENT_HANDLERS_BLOCKED_EXCEPTIONS 8280
#define IDS_SETTINGS_SITE_SETTINGS_PDFS_DESCRIPTION 8281
#define IDS_SETTINGS_SITE_SETTINGS_PDFS_ALLOWED 8282
#define IDS_SETTINGS_SITE_SETTINGS_POINTER_LOCK_DESCRIPTION 8283
#define IDS_SETTINGS_SITE_SETTINGS_POINTER_LOCK_ALLOWED 8284
#define IDS_SETTINGS_SITE_SETTINGS_POINTER_LOCK_BLOCKED 8285
#define IDS_SETTINGS_SITE_SETTINGS_POINTER_LOCK_ALLOWED_EXCEPTIONS 8286
#define IDS_SETTINGS_SITE_SETTINGS_POINTER_LOCK_BLOCKED_EXCEPTIONS 8287
#define IDS_SETTINGS_SITE_SETTINGS_POPUPS_DESCRIPTION 8288
#define IDS_SETTINGS_SITE_SETTINGS_POPUPS_ALLOWED 8289
#define IDS_SETTINGS_SITE_SETTINGS_POPUPS_BLOCKED 8290
#define IDS_SETTINGS_SITE_SETTINGS_POPUPS_ALLOWED_EXCEPTIONS 8291
#define IDS_SETTINGS_SITE_SETTINGS_POPUPS_BLOCKED_EXCEPTIONS 8292
#define IDS_SETTINGS_SITE_SETTINGS_PROTECTED_CONTENT_DESCRIPTION 8293
#define IDS_SETTINGS_SITE_SETTINGS_PROTECTED_CONTENT_ALLOWED 8294
#define IDS_SETTINGS_SITE_SETTINGS_PROTECTED_CONTENT_BLOCKED 8295
#define IDS_SETTINGS_SITE_SETTINGS_PROTECTED_CONTENT_BLOCKED_SUB_LABEL 8296
#define IDS_SETTINGS_SITE_SETTINGS_PROTOCOL_HANDLERS_DESCRIPTION 8304
#define IDS_SETTINGS_SITE_SETTINGS_PROTOCOL_HANDLERS_ALLOWED 8305
#define IDS_SETTINGS_SITE_SETTINGS_PROTOCOL_HANDLERS_BLOCKED 8306
#define IDS_SETTINGS_SITE_SETTINGS_PROTOCOL_HANDLERS_BLOCKED_EXCEPTIONS 8307
#define IDS_SETTINGS_SITE_SETTINGS_SERIAL_PORTS_DESCRIPTION 8308
#define IDS_SETTINGS_SITE_SETTINGS_SERIAL_PORTS_ALLOWED 8309
#define IDS_SETTINGS_SITE_SETTINGS_SERIAL_PORTS_BLOCKED 8310
#define IDS_SETTINGS_SITE_SETTINGS_SOUND_DESCRIPTION 8311
#define IDS_SETTINGS_SITE_SETTINGS_SOUND_ALLOWED 8312
#define IDS_SETTINGS_SITE_SETTINGS_SOUND_BLOCKED 8313
#define IDS_SETTINGS_SITE_SETTINGS_SOUND_BLOCKED_SUB_LABEL 8314
#define IDS_SETTINGS_SITE_SETTINGS_SOUND_ALLOWED_EXCEPTIONS 8315
#define IDS_SETTINGS_SITE_SETTINGS_SOUND_BLOCKED_EXCEPTIONS 8316
#define IDS_SETTINGS_SITE_SETTINGS_USB_DESCRIPTION 8317
#define IDS_SETTINGS_SITE_SETTINGS_USB_ALLOWED 8318
#define IDS_SETTINGS_SITE_SETTINGS_USB_BLOCKED 8319
#define IDS_SETTINGS_SITE_SETTINGS_VR_DESCRIPTION 8320
#define IDS_SETTINGS_SITE_SETTINGS_VR_ALLOWED 8321
#define IDS_SETTINGS_SITE_SETTINGS_VR_BLOCKED 8322
#define IDS_SETTINGS_SITE_SETTINGS_VR_ALLOWED_EXCEPTIONS 8323
#define IDS_SETTINGS_SITE_SETTINGS_VR_BLOCKED_EXCEPTIONS 8324
#define IDS_SETTINGS_SITE_SETTINGS_WEB_PRINTING_DESCRIPTION 8325
#define IDS_SETTINGS_SITE_SETTINGS_WEB_PRINTING_ASK 8326
#define IDS_SETTINGS_SITE_SETTINGS_WEB_PRINTING_BLOCK 8327
#define IDS_SETTINGS_SITE_SETTINGS_WEB_PRINTING_ALLOWED_EXCEPTIONS 8328
#define IDS_SETTINGS_SITE_SETTINGS_WEB_PRINTING_BLOCKED_EXCEPTIONS 8329
#define IDS_SETTINGS_SITE_SETTINGS_ZOOM_LEVELS_DESCRIPTION 8330
#define IDS_SETTINGS_SITE_SETTINGS_AR_ASK 8331
#define IDS_SETTINGS_SITE_SETTINGS_AR_BLOCK 8332
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_PAGE_DESCRIPTION 8333
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_PAGE_DEFAULT_BEHAVIOR_HEADING 8334
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_ALIGNED_PAGE_DESCRIPTION 8335
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_PAGE_DEFAULT_BEHAVIOR_DESCRIPTION 8336
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_PAGE_CUSTOMIZED_BEHAVIOR_HEADING 8337
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_PAGE_CUSTOMIZED_BEHAVIOR_DESCRIPTION 8338
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_PAGE_ALLOW_EXCEPTIONS_SUB_HEADING 8339
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_PAGE_TITLE 8340
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_LINK_ROW_LABEL 8341
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_LINK_ROW_SUB_LABEL_ENABLED 8342
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_LINK_ROW_SUB_LABEL_DISABLED_INCOGNITO 8343
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_LINK_ROW_SUB_LABEL_DISABLED 8344
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_PAGE_ALLOW_RADIO_LABEL 8345
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_PAGE_ALLOW_EXPAND_A11Y_LABEL 8346
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_PAGE_ALLOW_BULLET_1 8347
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_PAGE_ALLOW_BULLET_2 8348
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_PAGE_BLOCK_INCOGNITO_RADIO_LABEL 8349
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_PAGE_BLOCK_INCOGNITO_EXPAND_A11Y_LABEL 8350
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_PAGE_BLOCK_INCOGNITO_BULLET_1 8351
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_PAGE_BLOCK_INCOGNITO_BULLET_2 8352
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_PAGE_BLOCK_RADIO_LABEL 8353
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_PAGE_BLOCK_EXPAND_A11Y_LABEL 8354
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_PAGE_BLOCK_BULLET_1 8355
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_PAGE_BLOCK_BULLET_2 8356
#define IDS_SETTINGS_COOKIES_BLOCK_THIRD_PARTY_INCOGNITO_BULLET_TWO_FPS 8357
#define IDS_SETTINGS_COOKIES_FIRST_PARTY_SETS_TOGGLE_LABEL 8358
#define IDS_SETTINGS_COOKIES_FIRST_PARTY_SETS_TOGGLE_SUB_LABEL 8359
#define IDS_SETTINGS_COOKIES_ALL_SITES_LINK 8360
#define IDS_SETTINGS_TRACKING_PROTECTION_LINK_ROW_LABEL 8361
#define IDS_SETTINGS_TRACKING_PROTECTION_LINK_ROW_SUB_LABEL 8362
#define IDS_SETTINGS_TRACKING_PROTECTION_PAGE_TITLE 8363
#define IDS_SETTINGS_TRACKING_PROTECTION_PAGE_DESCRIPTION 8364
#define IDS_SETTINGS_TRACKING_PROTECTION_BULLET_ONE 8365
#define IDS_SETTINGS_TRACKING_PROTECTION_BULLET_ONE_DESCRIPTION 8366
#define IDS_SETTINGS_TRACKING_PROTECTION_BULLET_TWO 8367
#define IDS_SETTINGS_TRACKING_PROTECTION_BULLET_TWO_DESCRIPTION 8368
#define IDS_SETTINGS_TRACKING_PROTECTION_BULLET_TWO_LEARN_MORE_ARIA_LABEL 8369
#define IDS_SETTINGS_TRACKING_PROTECTION_ADVANCED_LABEL 8370
#define IDS_SETTINGS_TRACKING_PROTECTION_THIRD_PARTY_COOKIES_TOGGLE_LABEL 8371
#define IDS_SETTINGS_TRACKING_PROTECTION_THIRD_PARTY_COOKIES_TOGGLE_SUB_LABEL 8372
#define IDS_SETTINGS_TRACKING_PROTECTION_THIRD_PARTY_COOKIES_LEARN_MORE_ARIA_LABEL 8373
#define IDS_SETTINGS_TRACKING_PROTECTION_DO_NOT_TRACK_TOGGLE_SUB_LABEL 8374
#define IDS_SETTINGS_TRACKING_PROTECTION_SITES_ALLOWED_COOKIES_TITLE 8375
#define IDS_SETTINGS_TRACKING_PROTECTION_SITES_ALLOWED_COOKIES_DESCRIPTION 8376
#define IDS_SETTINGS_SITE_SETTINGS_APP_PROTOCOL_HANDLERS 8377
#define IDS_SETTINGS_SITE_SETTINGS_APP_ALLOWED_PROTOCOL_HANDLERS_DESCRIPTION 8378
#define IDS_SETTINGS_SITE_SETTINGS_APP_DISALLOWED_PROTOCOL_HANDLERS_DESCRIPTION 8379
#define IDS_SETTINGS_SITE_SETTINGS_HID_DEVICES_ASK 8380
#define IDS_SETTINGS_SITE_SETTINGS_HID_DEVICES_BLOCK 8381
#define IDS_SETTINGS_SITE_SETTINGS_INSECURE_CONTENT_BLOCK 8382
#define IDS_SETTINGS_SITE_SETTINGS_PDF_DOWNLOAD_PDFS 8383
#define IDS_SETTINGS_SITE_SETTINGS_RECENT_ACTIVITY 8384
#define IDS_SETTINGS_SITE_SETTINGS_SERIAL_PORTS_ASK_RECOMMENDED 8385
#define IDS_SETTINGS_SITE_SETTINGS_REMOVE_ZOOM_LEVEL 8386
#define IDS_SETTINGS_SITE_SETTINGS_ASK_BEFORE_SENDING 8387
#define IDS_SETTINGS_SITE_SETTINGS_AUTOMATICALLY_BLOCKED_NOTIFICATIONS 8388
#define IDS_SETTINGS_SITE_SETTINGS_SHOW_BLOCKED_NOTIFICATIONS_INDICATOR 8389
#define IDS_SETTINGS_SITE_SETTINGS_COOKIES_ALLOW 8390
#define IDS_SETTINGS_SITE_SETTINGS_COOKIES_BLOCK 8391
#define IDS_SETTINGS_SITE_SETTINGS_COOKIES_BLOCK_THIRD_PARTY 8392
#define IDS_SETTINGS_SITE_SETTINGS_COOKIES_BLOCK_THIRD_PARTY_INCOGNITO 8393
#define IDS_SETTINGS_SITE_SETTINGS_COOKIES_ALLOW_SITES 8394
#define IDS_SETTINGS_SITE_SETTINGS_HANDLERS_ASK_RECOMMENDED 8395
#define IDS_SETTINGS_SITE_SETTINGS_HANDLERS_BLOCKED 8396
#define IDS_SETTINGS_SITE_SETTINGS_WINDOW_MANAGEMENT_DESCRIPTION 8397
#define IDS_SETTINGS_SITE_SETTINGS_WINDOW_MANAGEMENT_ASK 8398
#define IDS_SETTINGS_SITE_SETTINGS_WINDOW_MANAGEMENT_BLOCKED 8399
#define IDS_SETTINGS_SITE_SETTINGS_WINDOW_MANAGEMENT_ASK_EXCEPTIONS 8400
#define IDS_SETTINGS_SITE_SETTINGS_WINDOW_MANAGEMENT_BLOCKED_EXCEPTIONS 8401
#define IDS_SETTINGS_SITE_SETTINGS_BLOCKED 8402
#define IDS_SETTINGS_SITE_SETTINGS_ALLOW 8403
#define IDS_SETTINGS_SITE_SETTINGS_BLOCK 8404
#define IDS_SETTINGS_SITE_SETTINGS_SESSION_ONLY 8405
#define IDS_SETTINGS_SITE_SETTINGS_ASK_DEFAULT_MENU 8406
#define IDS_SETTINGS_SITE_SETTINGS_ALLOW_DEFAULT_MENU 8407
#define IDS_SETTINGS_SITE_SETTINGS_AUTOMATIC_DEFAULT_MENU 8408
#define IDS_SETTINGS_SITE_SETTINGS_BLOCK_DEFAULT_MENU 8409
#define IDS_SETTINGS_SITE_SETTINGS_MUTE_DEFAULT_MENU 8410
#define IDS_SETTINGS_SITE_SETTINGS_ALLOW_MENU 8411
#define IDS_SETTINGS_SITE_SETTINGS_BLOCK_MENU 8412
#define IDS_SETTINGS_SITE_SETTINGS_ASK_MENU 8413
#define IDS_SETTINGS_SITE_SETTINGS_MUTE_MENU 8414
#define IDS_SETTINGS_SITE_SETTINGS_RESET_MENU 8415
#define IDS_SETTINGS_SITE_SETTINGS_SESSION_ONLY_MENU 8416
#define IDS_SETTINGS_SITE_SETTINGS_USAGE 8417
#define IDS_SETTINGS_SITE_SETTINGS_USAGE_NONE 8418
#define IDS_SETTINGS_SITE_SETTINGS_PERMISSIONS 8419
#define IDS_SETTINGS_SITE_SETTINGS_PERMISSIONS_MORE 8420
#define IDS_SETTINGS_SITE_SETTINGS_CONTENT 8421
#define IDS_SETTINGS_SITE_SETTINGS_CONTENT_MORE 8422
#define IDS_SETTINGS_SITE_SETTINGS_ALLOWLISTED 8423
#define IDS_SETTINGS_SITE_SETTINGS_ADS_BLOCK_BLOCKLISTED_SINGULAR 8424
#define IDS_SETTINGS_SITE_SETTINGS_ADS_BLOCK_NOT_BLOCKLISTED_SINGULAR 8425
#define IDS_SETTINGS_SITE_SETTINGS_SOURCE_KILL_SWITCH 8426
#define IDS_SETTINGS_SITE_SETTINGS_SOURCE_INSECURE_ORIGIN 8427
#define IDS_SETTINGS_SITE_SETTINGS_RESET_BUTTON 8428
#define IDS_SETTINGS_SITE_SETTINGS_DELETE 8429
#define IDS_SETTINGS_SITE_SETTINGS_THIRD_PARTY_COOKIES_EXCEPTION_LABEL 8430
#define IDS_SETTINGS_SITE_SETTINGS_DELETE_ALL_STORAGE_DIALOG_TITLE 8431
#define IDS_SETTINGS_SITE_SETTINGS_DELETE_DISPLAYED_STORAGE_DIALOG_TITLE 8432
#define IDS_SETTINGS_SITE_SETTINGS_FIRST_PARTY_SETS_LEARN_MORE 8433
#define IDS_SETTINGS_SITE_SETTINGS_FIRST_PARTY_SETS_LEARN_MORE_ACCESSIBILITY 8434
#define IDS_SETTINGS_SITE_SETTINGS_CLEAR_ALL_STORAGE_DESCRIPTION 8435
#define IDS_SETTINGS_SITE_SETTINGS_CLEAR_DISPLAYED_STORAGE_DESCRIPTION 8436
#define IDS_SETTINGS_SITE_SETTINGS_DELETE_ALL_STORAGE_LABEL 8437
#define IDS_SETTINGS_SITE_SETTINGS_DELETE_DISPLAYED_STORAGE_LABEL 8438
#define IDS_SETTINGS_SITE_SETTINGS_SITE_DETAILS_SUBPAGE_ACCESSIBILITY_LABEL 8439
#define IDS_SETTINGS_SITE_SETTINGS_FIRST_PARTY_SETS_MEMBERSHIP_LABEL 8440
#define IDS_SETTINGS_SITE_SETTINGS_FIRST_PARTY_SETS_MORE_ACTIONS_TITLE 8441
#define IDS_SETTINGS_SITE_SETTINGS_FIRST_PARTY_SETS_SHOW_RELATED_SITES_BUTTON 8442
#define IDS_SETTINGS_SITE_SETTINGS_FIRST_PARTY_SETS_SITE_DELETE_STORAGE_BUTTON 8443
#define IDS_SETTINGS_SITE_SETTINGS_DELETE_ALL_STORAGE_CONFIRMATION 8444
#define IDS_SETTINGS_SITE_SETTINGS_DELETE_DISPLAYED_STORAGE_CONFIRMATION 8445
#define IDS_SETTINGS_SITE_SETTINGS_DELETE_ALL_STORAGE_CONFIRMATION_INSTALLED 8446
#define IDS_SETTINGS_SITE_SETTINGS_DELETE_DISPLAYED_STORAGE_CONFIRMATION_INSTALLED 8447
#define IDS_SETTINGS_SITE_SETTINGS_CLEAR_ALL_STORAGE_SIGN_OUT 8448
#define IDS_SETTINGS_SITE_SETTINGS_CLEAR_DISPLAYED_STORAGE_SIGN_OUT 8449
#define IDS_SETTINGS_SITE_SETTINGS_SITE_RESET_CONFIRMATION 8450
#define IDS_SETTINGS_SITE_SETTINGS_SITE_DELETE_STORAGE_DIALOG_TITLE 8451
#define IDS_SETTINGS_SITE_SETTINGS_SITE_CLEAR_STORAGE_CONFIRMATION 8452
#define IDS_SETTINGS_SITE_SETTINGS_SITE_CLEAR_STORAGE_CONFIRMATION_NEW 8453
#define IDS_SETTINGS_SITE_SETTINGS_SITE_CLEAR_STORAGE_SIGN_OUT 8454
#define IDS_SETTINGS_SITE_SETTINGS_SITE_DELETE_STORAGE_OFFLINE_DATA 8455
#define IDS_SETTINGS_SITE_SETTINGS_REMOVE_SITE_AD_PERSONALIZATION 8456
#define IDS_SETTINGS_SITE_SETTINGS_SITE_GROUP_DELETE_OFFLINE_DATA 8457
#define IDS_SETTINGS_SITE_SETTINGS_REMOVE_SITE_ORIGIN_DIALOG_TITLE 8458
#define IDS_SETTINGS_SITE_SETTINGS_REMOVE_SITE_ORIGIN_APP_DIALOG_TITLE 8459
#define IDS_SETTINGS_SITE_SETTINGS_REMOVE_SITE_ORIGIN_PARTITIONED_DIALOG_TITLE 8460
#define IDS_SETTINGS_SITE_SETTINGS_REMOVE_SITE_GROUP_DIALOG_TITLE 8461
#define IDS_SETTINGS_SITE_SETTINGS_REMOVE_SITE_GROUP_APP_DIALOG_TITLE 8462
#define IDS_SETTINGS_SITE_SETTINGS_REMOVE_SITE_GROUP_APP_PLURAL_DIALOG_TITLE 8463
#define IDS_SETTINGS_SITE_SETTINGS_REMOVE_SITE_ORIGIN_LOGOUT 8464
#define IDS_SETTINGS_SITE_SETTINGS_REMOVE_SITE_GROUP_LOGOUT 8465
#define IDS_SETTINGS_SITE_SETTINGS_REMOVE_SITE_OFFLINE_DATA 8466
#define IDS_SETTINGS_SITE_SETTINGS_REMOVE_SITE_PERMISSIONS 8467
#define IDS_SETTINGS_SITE_SETTINGS_REMOVE_SITE_CONFIRM 8468
#define IDS_SETTINGS_SITE_SETTINGS_COOKIE_REMOVE_SITE 8469
#define IDS_SETTINGS_SITE_SETTINGS_SITE_RESET_ALL 8470
#define IDS_SETTINGS_SITE_SETTINGS_SITE_CLEAR_STORAGE 8471
#define IDS_SETTINGS_SITE_SETTINGS_HANDLER_IS_DEFAULT 8472
#define IDS_SETTINGS_SITE_SETTINGS_HANDLER_SET_DEFAULT 8473
#define IDS_SETTINGS_SITE_SETTINGS_REMOVE 8474
#define IDS_SETTINGS_SITE_SETTINGS_INCOGNITO_ONLY 8475
#define IDS_SETTINGS_SITE_SETTINGS_INCOGNITO_SITE_EXCEPTION_DESC 8476
#define IDS_SETTINGS_SITE_SETTINGS_NO_ZOOMED_SITES 8477
#define IDS_SETTINGS_SITE_NO_SITES_ADDED 8478
#define IDS_SETTINGS_SITE_SETTINGS_BLOCK_AUTOPLAY 8479
#define IDS_SETTINGS_SITE_SETTINGS_EMPTY_ALL_SITES_PAGE 8480
#define IDS_SETTINGS_SITE_SETTINGS_NO_SITES_FOUND 8481
#define IDS_SETTINGS_SITE_SETTINGS_BLUETOOTH_SCANNING_DESCRIPTION 8482
#define IDS_SETTINGS_SITE_SETTINGS_BLUETOOTH_SCANNING_ASK 8483
#define IDS_SETTINGS_SITE_SETTINGS_BLUETOOTH_SCANNING_BLOCK 8484
#define IDS_SETTINGS_SITE_SETTINGS_BLUETOOTH_SCANNING_ALLOWED_EXCEPTIONS 8485
#define IDS_SETTINGS_SITE_SETTINGS_BLUETOOTH_SCANNING_BLOCKED_EXCEPTIONS 8486
#define IDS_SETTINGS_SITE_SETTINGS_EXTENSION_ID_DESCRIPTION 8487
#define IDS_SETTINGS_SITE_SETTINGS_PAGE_SITE_DATA_ALLOWED_SUB_LABEL 8488
#define IDS_SETTINGS_SITE_SETTINGS_PAGE_SITE_DATA_BLOCKED_SUB_LABEL 8489
#define IDS_SETTINGS_SITE_SETTINGS_PAGE_SITE_DATA_DELETE_ON_EXIT_SUB_LABEL 8490
#define IDS_SETTINGS_EXPIRES_AFTER_TIME_LABEL 8491
#define IDS_SETTINGS_SITE_DATA_PAGE_TITLE 8492
#define IDS_SETTINGS_SITE_DATA_PAGE_DESCRIPTION 8493
#define IDS_SETTINGS_SITE_DATA_PAGE_DEFAULT_BEHAVIOR_HEADING 8494
#define IDS_SETTINGS_SITE_DATA_PAGE_DEFAULT_BEHAVIOR_DESCRIPTION 8495
#define IDS_SETTINGS_SITE_DATA_PAGE_ALLOW_RADIO_LABEL 8496
#define IDS_SETTINGS_SITE_DATA_PAGE_ALLOW_RADIO_SUB_LABEL 8497
#define IDS_SETTINGS_SITE_DATA_PAGE_CLEAR_ON_EXIT_RADIO_LABEL 8498
#define IDS_SETTINGS_SITE_DATA_PAGE_BLOCK_RADIO_LABEL 8499
#define IDS_SETTINGS_SITE_DATA_PAGE_BLOCK_RADIO_SUB_LABEL 8500
#define IDS_SETTINGS_SITE_DATA_PAGE_CUSTOMIZED_BEHAVIOR_HEADING 8501
#define IDS_SETTINGS_SITE_DATA_PAGE_CUSTOMIZED_BEHAVIOR_DESCRIPTION 8502
#define IDS_SETTINGS_SITE_DATA_PAGE_ALLOW_EXCEPTIONS_SUB_HEADING 8503
#define IDS_SETTINGS_SITE_DATA_PAGE_BLOCK_EXCEPTIONS_SUB_HEADING 8504
#define IDS_SETTINGS_SITE_DATA_PAGE_BLOCK_CONFIRM_DIALOG_TITLE 8505
#define IDS_SETTINGS_SITE_DATA_PAGE_BLOCK_CONFIRM_DIALOG_DESCRIPTION 8506
#define IDS_SETTINGS_SITE_DATA_PAGE_BLOCK_CONFIRM_DIALOG_CONFIRM_BUTTON 8507
#define IDS_SETTINGS_SITE_DATA_PAGE_BLOCK_CONFIRM_DIALOG_CANCEL_BUTTON 8508
#define IDS_SETTINGS_STORAGE_ACCESS_DESCRIPTION 8509
#define IDS_SETTINGS_STORAGE_ACCESS_ALLOWED 8510
#define IDS_SETTINGS_STORAGE_ACCESS_BLOCKED 8511
#define IDS_SETTINGS_STORAGE_ACCESS_ALLOWED_EXCEPTIONS 8512
#define IDS_SETTINGS_STORAGE_ACCESS_BLOCKED_EXCEPTIONS 8513
#define IDS_SETTINGS_STORAGE_ACCESS_RESET_ALL 8514
#define IDS_SETTINGS_STORAGE_ACCESS_RESET_SITE 8515
#define IDS_SETTINGS_STORAGE_ACCESS_OPEN_EXPAND 8516
#define IDS_SETTINGS_STORAGE_ACCESS_CLOSE_EXPAND 8517
#define IDS_SETTINGS_STORAGE_ACCESS_ALLOWED_SITE_LABEL 8518
#define IDS_SETTINGS_STORAGE_ACCESS_BLOCKED_SITE_LABEL 8519
#define IDS_SETTINGS_NO_BLUETOOTH_DEVICES_FOUND 8520
#define IDS_SETTINGS_NO_USB_DEVICES_FOUND 8521
#define IDS_SETTINGS_NO_SERIAL_PORTS_FOUND 8522
#define IDS_SETTINGS_NO_HID_DEVICES_FOUND 8523
#define IDS_SETTINGS_RESET_BLUETOOTH_CONFIRMATION 8524
#define IDS_SETTINGS_RESET_HID_CONFIRMATION 8525
#define IDS_SETTINGS_RESET_SERIAL_PORTS_CONFIRMATION 8526
#define IDS_SETTINGS_RESET_USB_CONFIRMATION 8527
#define IDS_SETTINGS_ADD_SITE_TITLE 8528
#define IDS_SETTINGS_ADD_SITES_TITLE 8529
#define IDS_SETTINGS_EDIT_SITE_TITLE 8530
#define IDS_SETTINGS_ADD_SITE 8531
#define IDS_SETTINGS_SITE_SETTINGS_NUM_COOKIES 8532
#define IDS_SETTINGS_PEOPLE 8533
#define IDS_SETTINGS_CHANGE_PICTURE_PROFILE_PHOTO 8534
#define IDS_SETTINGS_PEOPLE_SIGN_IN 8535
#define IDS_SETTINGS_PEOPLE_VERIFY_ACCOUNT_BUTTON 8536
#define IDS_SETTINGS_SYNC_DISCONNECT_MANAGED_PROFILE_EXPLANATION 8537
#define IDS_SETTINGS_TURN_OFF_SYNC_MANAGED_PROFILE_EXPLANATION 8538
#define IDS_SETTINGS_TURN_OFF_SYNC_DIALOG_TITLE 8539
#define IDS_SETTINGS_TURN_OFF_SYNC_AND_SIGN_OUT_DIALOG_TITLE 8540
#define IDS_SETTINGS_TURN_OFF_SYNC_DIALOG_MANAGED_CONFIRM 8541
#define IDS_SETTINGS_TURN_OFF_SYNC_DIALOG_CHECKBOX 8542
#define IDS_SETTINGS_SYNC_SETTINGS_SAVED_TOAST_LABEL 8543
#define IDS_SETTINGS_PROFILE_NAME_INPUT_LABEL 8544
#define IDS_SETTINGS_PROFILE_SHORTCUT_TOGGLE_LABEL 8545
#define IDS_SETTINGS_CUSTOMIZE_PROFILE 8546
#define IDS_SETTINGS_PICK_A_THEME_COLOR 8547
#define IDS_SETTINGS_PICK_AN_AVATAR 8548
#define IDS_SETTINGS_CREATE_SHORTCUT 8549
#define IDS_SETTINGS_CREATE_SHORTCUT_SUBTITLE 8550
#define IDS_SETTINGS_SYNC_DISCONNECT_EXPLANATION 8551
#define IDS_SETTINGS_SYNC_DISCONNECT_MAIN_PROFILE_EXPLANATION 8552
#define IDS_SETTINGS_SYNC_DISCONNECT_AND_SIGN_OUT_EXPLANATION 8553
#define IDS_SETTINGS_SYNC_DISCONNECT_EXPAND_ACCESSIBILITY_LABEL 8554
#define IDS_SETTINGS_SYNC_WILL_START 8555
#define IDS_SETTINGS_USER_EVENTS_CHECKBOX_LABEL 8556
#define IDS_SETTINGS_USER_EVENTS_CHECKBOX_TEXT 8557
#define IDS_SETTINGS_ENCRYPT_WITH_SYNC_PASSPHRASE_LABEL 8558
#define IDS_SETTINGS_PASSPHRASE_EXPLANATION_TEXT 8559
#define IDS_SETTINGS_PASSPHRASE_RESET_HINT_ENCRYPTION 8560
#define IDS_SETTINGS_PASSPHRASE_RESET_HINT_TOGGLE 8561
#define IDS_SETTINGS_PASSPHRASE_RECOVER 8562
#define IDS_SETTINGS_PERSONALIZE_GOOGLE_SERVICES_TITLE 8563
#define IDS_SETTINGS_PERSONALIZE_GOOGLE_SERVICES_TITLE_V2 8564
#define IDS_SETTINGS_PERSONALIZE_GOOGLE_SERVICES_WAA_TITLE 8565
#define IDS_SETTINGS_PERSONALIZE_GOOGLE_SERVICES_LINKED_SERVICES_TITLE 8566
#define IDS_SETTINGS_SIGNIN_CHROME_SIGNIN_OPTION_PLACEHOLDER 8567
#define IDS_SETTINGS_SIGNIN_CHROME_SIGNIN_OPTION_SIGNIN 8568
#define IDS_SETTINGS_SIGNIN_CHROME_SIGNIN_OPTION_DO_NOT_SIGNIN 8569
#define IDS_SETTINGS_SIGNIN_CHROME_SIGNIN_OPTION_ALWAYS_ASK 8570
#define IDS_SETTINGS_MANAGE_GOOGLE_ACCOUNT 8571
#define IDS_SETTINGS_IMPORT_SETTINGS_TITLE 8572
#define IDS_SETTINGS_IMPORT_FROM_LABEL 8573
#define IDS_SETTINGS_IMPORT_ITEMS_LABEL 8574
#define IDS_SETTINGS_IMPORT_LOADING_PROFILES 8575
#define IDS_SETTINGS_IMPORT_HISTORY_CHECKBOX 8576
#define IDS_SETTINGS_IMPORT_FAVORITES_CHECKBOX 8577
#define IDS_SETTINGS_IMPORT_PASSWORDS_CHECKBOX 8578
#define IDS_SETTINGS_IMPORT_SEARCH_ENGINES_CHECKBOX 8579
#define IDS_SETTINGS_IMPORT_AUTOFILL_FORM_DATA_CHECKBOX 8580
#define IDS_SETTINGS_IMPORT_CHOOSE_FILE 8581
#define IDS_SETTINGS_IMPORT_COMMIT 8582
#define IDS_SETTINGS_IMPORT_SUCCESS 8583
#define IDS_SETTINGS_IMPORT_NO_PROFILE_FOUND 8584
#define IDS_SETTINGS_PAGE_CONTENT_LINK_ROW_SUBLABEL_ON 8585
#define IDS_SETTINGS_PAGE_CONTENT_LINK_ROW_SUBLABEL_OFF 8586
#define IDS_SETTINGS_PAGE_CONTENT_PAGE_TITLE 8587
#define IDS_SETTINGS_PAGE_CONTENT_TOGGLE_LABEL 8588
#define IDS_SETTINGS_PAGE_CONTENT_TOGGLE_SUBLABEL 8589
#define IDS_SETTINGS_PAGE_CONTENT_WHEN_ON_BULLET_ONE 8590
#define IDS_SETTINGS_PAGE_CONTENT_THINGS_TO_CONSIDER_BULLET_ONE 8591
#define IDS_SETTINGS_PAGE_CONTENT_THINGS_TO_CONSIDER_BULLET_THREE 8592
#define IDS_SETTINGS_HISTORY_SEARCH_SETTING_LABEL 8593
#define IDS_SETTINGS_HISTORY_SEARCH_SETTING_SUBLABEL 8594
#define IDS_SETTINGS_HISTORY_SEARCH_WHEN_ON_BULLET_ONE 8595
#define IDS_SETTINGS_HISTORY_SEARCH_CONSIDER_BULLET_ONE 8596
#define IDS_SETTINGS_HISTORY_SEARCH_CONSIDER_BULLET_TWO 8597
#define IDS_SETTINGS_HISTORY_SEARCH_LEARN_MORE 8598
#define IDS_SETTINGS_HISTORY_SEARCH_LEARN_MORE_A11Y_LABEL 8599
#define IDS_SETTINGS_PAGE_ZOOM_LABEL 8600
#define IDS_SETTINGS_FONT_SIZE_LABEL 8601
#define IDS_SETTINGS_VERY_SMALL_FONT 8602
#define IDS_SETTINGS_SMALL_FONT 8603
#define IDS_SETTINGS_MEDIUM_FONT 8604
#define IDS_SETTINGS_LARGE_FONT 8605
#define IDS_SETTINGS_VERY_LARGE_FONT 8606
#define IDS_SETTINGS_CUSTOMIZE_FONTS 8607
#define IDS_SETTINGS_FONTS 8608
#define IDS_SETTINGS_STANDARD_FONT_LABEL 8609
#define IDS_SETTINGS_SERIF_FONT_LABEL 8610
#define IDS_SETTINGS_SANS_SERIF_FONT_LABEL 8611
#define IDS_SETTINGS_FIXED_WIDTH_FONT_LABEL 8612
#define IDS_SETTINGS_MATH_FONT_LABEL 8613
#define IDS_SETTINGS_MINIMUM_FONT_SIZE_LABEL 8614
#define IDS_SETTINGS_TINY_FONT_SIZE 8615
#define IDS_SETTINGS_HUGE_FONT_SIZE 8616
#define IDS_SETTINGS_QUICK_BROWN_FOX 8617
#define IDS_SETTINGS_SYSTEM 8618
#define IDS_SETTINGS_SYSTEM_HARDWARE_ACCELERATION_LABEL 8619
#define IDS_SETTINGS_SYSTEM_PROXY_SETTINGS_LABEL 8620
#define IDS_SETTINGS_SYSTEM_PROXY_SETTINGS_EXTENSION_LABEL 8621
#define IDS_SETTINGS_SYSTEM_PROXY_SETTINGS_POLICY_LABEL 8622
#define IDS_PAGE_NOT_AVAILABLE_FOR_GUEST_HEADING 8633
#define IDS_SETTINGS_SECURITY_KEYS_TITLE 8634
#define IDS_SETTINGS_SECURITY_KEYS_DESC 8635
#define IDS_SETTINGS_SECURITY_KEYS_SET_PIN 8636
#define IDS_SETTINGS_SECURITY_KEYS_SET_PIN_BUTTON 8637
#define IDS_SETTINGS_SECURITY_KEYS_SET_PIN_DESC 8638
#define IDS_SETTINGS_SECURITY_KEYS_SET_PIN_INITIAL_TITLE 8639
#define IDS_SETTINGS_SECURITY_KEYS_SET_PIN_CREATE_TITLE 8640
#define IDS_SETTINGS_SECURITY_KEYS_SET_PIN_CHANGE_TITLE 8641
#define IDS_SETTINGS_SECURITY_KEYS_RESET 8642
#define IDS_SETTINGS_SECURITY_KEYS_RESET_DESC 8643
#define IDS_SETTINGS_SECURITY_KEYS_RESET_TITLE 8644
#define IDS_SETTINGS_SECURITY_KEYS_RESET_CONFIRM_TITLE 8645
#define IDS_SETTINGS_SECURITY_KEYS_RESET_STEP1 8646
#define IDS_SETTINGS_SECURITY_KEYS_RESET_STEP2 8647
#define IDS_SETTINGS_SECURITY_KEYS_NO_RESET 8648
#define IDS_SETTINGS_SECURITY_KEYS_RESET_ERROR 8649
#define IDS_SETTINGS_SECURITY_KEYS_RESET_SUCCESS 8650
#define IDS_SETTINGS_SECURITY_KEYS_RESET_NOTALLOWED 8651
#define IDS_SETTINGS_SECURITY_KEYS_NO_PIN 8652
#define IDS_SETTINGS_SECURITY_KEYS_CURRENT_PIN_INTRO 8653
#define IDS_SETTINGS_SECURITY_KEYS_PIN_INCORRECT 8654
#define IDS_SETTINGS_SECURITY_KEYS_PIN_INCORRECT_RETRIES_SIN 8655
#define IDS_SETTINGS_SECURITY_KEYS_PIN_INCORRECT_RETRIES_PL 8656
#define IDS_SETTINGS_SECURITY_KEYS_SAME_PIN_AS_CURRENT 8657
#define IDS_SETTINGS_SECURITY_KEYS_NEW_PIN 8658
#define IDS_SETTINGS_SECURITY_KEYS_SET_PIN_CONFIRM 8659
#define IDS_SETTINGS_SECURITY_KEYS_CURRENT_PIN 8660
#define IDS_SETTINGS_SECURITY_KEYS_PIN 8661
#define IDS_SETTINGS_SECURITY_KEYS_PIN_ERROR_TOO_SHORT_SMALL 8662
#define IDS_SETTINGS_SECURITY_KEYS_PIN_ERROR_TOO_LONG 8663
#define IDS_SETTINGS_SECURITY_KEYS_PIN_ERROR_INVALID 8664
#define IDS_SETTINGS_SECURITY_KEYS_PIN_ERROR_MISMATCH 8665
#define IDS_SETTINGS_SECURITY_KEYS_CONFIRM_PIN 8666
#define IDS_SETTINGS_SECURITY_KEYS_PIN_SUCCESS 8667
#define IDS_SETTINGS_SECURITY_KEYS_PIN_ERROR 8668
#define IDS_SETTINGS_SECURITY_KEYS_PIN_HARD_LOCK 8669
#define IDS_SETTINGS_SECURITY_KEYS_PIN_SOFT_LOCK 8670
#define IDS_SETTINGS_SECURITY_KEYS_SHOW_PINS 8671
#define IDS_SETTINGS_SECURITY_KEYS_HIDE_PINS 8672
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_MANAGEMENT_LABEL 8673
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_USERNAME_LABEL 8674
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_DISPLAYNAME_LABEL 8675
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_WEBSITE_LABEL 8676
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_MANAGEMENT_DESC 8677
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_MANAGEMENT_DIALOG_TITLE 8678
#define IDS_SETTINGS_SECURITY_KEYS_UPDATE_CREDENTIAL_DIALOG_TITLE 8679
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_MANAGEMENT_CONFIRM_DELETE_TITLE 8680
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_MANAGEMENT_CONFIRM_DELETE_CREDENTIAL 8681
#define IDS_SETTINGS_SECURITY_KEYS_INPUT_ERROR_TOO_LONG 8682
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_MANAGEMENT_NO_CREDENTIALS 8683
#define IDS_SETTINGS_SECURITY_KEYS_NO_CREDENTIAL_MANAGEMENT 8684
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_MANAGEMENT_REMOVED 8685
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_MANAGEMENT_NO_PIN 8686
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_MANAGEMENT_ERROR 8687
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_MANAGEMENT_DELETE_SUCCESS 8688
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_MANAGEMENT_DELETE_FAILED 8689
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_MANAGEMENT_UPDATE_SUCCESS 8690
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_MANAGEMENT_UPDATE_FAILED 8691
#define IDS_SETTINGS_SECURITY_KEYS_BIO_ENROLLMENT_SUBPAGE_LABEL 8692
#define IDS_SETTINGS_SECURITY_KEYS_BIO_ENROLLMENT_SUBPAGE_DESCRIPTION 8693
#define IDS_SETTINGS_SECURITY_KEYS_BIO_ENROLLMENT_DIALOG_TITLE 8694
#define IDS_SETTINGS_SECURITY_KEYS_BIO_ENROLLMENT_ADD_TITLE 8695
#define IDS_SETTINGS_SECURITY_KEYS_BIO_CHOOSE_NAME 8696
#define IDS_SETTINGS_SECURITY_KEYS_BIO_NAME_LABEL 8697
#define IDS_SETTINGS_SECURITY_KEYS_BIO_NAME_LABEL_TOO_LONG 8698
#define IDS_SETTINGS_SECURITY_KEYS_BIO_ENROLLMENT_NO_ENROLLMENTS_LABEL 8699
#define IDS_SETTINGS_SECURITY_KEYS_BIO_ENROLLMENT_ENROLLMENTS_LABEL 8700
#define IDS_SETTINGS_SECURITY_KEYS_BIO_ENROLLMENT_ENROLLING_LABEL 8701
#define IDS_SETTINGS_SECURITY_KEYS_BIO_ENROLLMENT_TRY_AGAIN_LABEL 8702
#define IDS_SETTINGS_SECURITY_KEYS_BIO_ENROLLMENT_FAILED_LABEL 8703
#define IDS_SETTINGS_SECURITY_KEYS_BIO_ENROLLMENT_ENROLLING_COMPLETE_LABEL 8704
#define IDS_SETTINGS_SECURITY_KEYS_NO_BIOMETRIC_ENROLLMENT 8705
#define IDS_SETTINGS_SECURITY_KEYS_BIO_ENROLLMENT_DELETE 8706
#define IDS_SETTINGS_SECURITY_KEYS_BIO_NO_PIN 8707
#define IDS_SETTINGS_SECURITY_KEYS_BIO_ENROLLMENT_STORAGE_FULL 8708
#define IDS_SETTINGS_SECURITY_KEYS_TOUCH_TO_CONTINUE 8709
#define IDS_SETTINGS_SECURITY_KEYS_PIN_PROMPT 8710
#define IDS_SETTINGS_SECURITY_KEYS_FORCE_PIN_CHANGE 8711
#define IDS_SETTINGS_SECURITY_KEYS_PHONE_EDIT_DIALOG_TITLE 8712
#define IDS_SETTINGS_SECURITY_KEYS_PHONES_YOUR_DEVICES 8713
#define IDS_SETTINGS_SECURITY_KEYS_PHONES_SYNCED_DESC 8714
#define IDS_SETTINGS_SECURITY_KEYS_PHONES_LINKED_DEVICES 8715
#define IDS_SETTINGS_SECURITY_KEYS_PHONES_LINKED_DESC 8716
#define IDS_SETTINGS_SECURITY_KEYS_PHONES_MANAGE 8717
#define IDS_SETTINGS_SECURITY_KEYS_PHONES_MANAGE_DESC 8718
#define IDS_SETTINGS_EXTENSION_OR_APP_DISPLAY_NAME 8719
#define IDS_SETTINGS_SAFETY_HUB 8720
#define IDS_SETTINGS_SAFETY_HUB_ENTRY_POINT_BUTTON 8721
#define IDS_SETTINGS_SAFETY_HUB_PAGE_CARD_SECTION_HEADER 8722
#define IDS_SETTINGS_SAFETY_HUB_PAGE_MODULE_SECTION_HEADER 8723
#define IDS_SETTINGS_SAFETY_HUB_EMPTY_STATE_MODULE_HEADER 8724
#define IDS_SETTINGS_SAFETY_HUB_PASSWORD_CHECK_SUBHEADER_RECENTLY 8725
#define IDS_SETTINGS_SAFETY_HUB_PASSWORD_CHECK_SUBHEADER_SOME_TIME_AGO 8726
#define IDS_SETTINGS_SAFETY_HUB_PASSWORD_CHECK_HEADER_NO_WEAK_OR_REUSED 8727
#define IDS_SETTINGS_SAFETY_HUB_PASSWORD_CHECK_SUBHEADER_SIGN_IN 8728
#define IDS_SETTINGS_SAFETY_HUB_PASSWORD_CHECK_SUBHEADER_GO_TO_PASSWORD_MANAGER 8729
#define IDS_SETTINGS_SAFETY_HUB_PASSWORD_CHECK_HEADER_NO_PASSWORDS 8730
#define IDS_SETTINGS_SAFETY_HUB_PASSWORD_CHECK_SUBHEADER_NO_PASSWORDS_POLICY 8731
#define IDS_SETTINGS_SAFETY_HUB_PASSWORD_NAVIGATION_ARIA_LABEL 8732
#define IDS_SETTINGS_SAFETY_HUB_SB_ON_ENHANCED_HEADER 8733
#define IDS_SETTINGS_SAFETY_HUB_SB_ON_ENHANCED_SUBHEADER 8734
#define IDS_SETTINGS_SAFETY_HUB_SB_ON_STANDARD_HEADER 8735
#define IDS_SETTINGS_SAFETY_HUB_SB_ON_STANDARD_SUBHEADER 8736
#define IDS_SETTINGS_SAFETY_HUB_SB_OFF_HEADER 8737
#define IDS_SETTINGS_SAFETY_HUB_SB_OFF_MANAGED_SUBHEADER 8738
#define IDS_SETTINGS_SAFETY_HUB_SB_OFF_EXTENSION_SUBHEADER 8739
#define IDS_SETTINGS_SAFETY_HUB_SB_OFF_USER_SUBHEADER 8740
#define IDS_SETTINGS_SAFETY_HUB_SB_NAVIGATION_ARIA_LABEL 8741
#define IDS_SETTINGS_SAFETY_HUB_GO_SITE_SETTINGS_ITEM 8742
#define IDS_SETTINGS_SAFETY_HUB_GO_NOTIFICATION_SETTINGS_ITEM 8743
#define IDS_SETTINGS_SAFETY_HUB_USER_EDU_INCOGNITO_SUBHEADER 8744
#define IDS_SETTINGS_SAFETY_HUB_USER_EDU_SAFE_BROWSING_HEADER 8745
#define IDS_SETTINGS_SAFETY_HUB_VERSION_CARD_SUBHEADER_RESTART 8746
#define IDS_SETTINGS_SAFETY_HUB_NOTIFICATION_PERMISSIONS_PRIMARY_LABEL 8747
#define IDS_SETTINGS_SAFETY_HUB_NOTIFICATION_PERMISSIONS_SECONDARY_LABEL 8748
#define IDS_SETTINGS_SAFETY_HUB_UNUSED_SITE_PERMISSIONS_MENU_NOTIFICATION 8749
#define IDS_SETTINGS_SAFETY_HUB_REVOKED_PERMISSIONS_MENU_NOTIFICATION 8750
#define IDS_SETTINGS_SAFETY_HUB_REVIEW_NOTIFICATION_PERMISSIONS_MENU_NOTIFICATION 8751
#define IDS_SETTINGS_SAFETY_HUB_COMPROMISED_PASSWORDS_MENU_NOTIFICATION 8752
#define IDS_SETTINGS_SAFETY_HUB_EXTENSIONS_MENU_NOTIFICATION 8753
#define IDS_SETTINGS_SAFETY_HUB_SAFE_BROWSING_MENU_NOTIFICATION 8754
#define IDS_SETTINGS_SAFETY_HUB_PASSWORDS_MODULE_NAME 8755
#define IDS_SETTINGS_SAFETY_HUB_SAFE_BROWSING_MODULE_NAME 8756
#define IDS_SETTINGS_SAFETY_HUB_EXTENSIONS_MODULE_UPPERCASE_NAME 8757
#define IDS_SETTINGS_SAFETY_HUB_EXTENSIONS_MODULE_LOWERCASE_NAME 8758
#define IDS_SETTINGS_SAFETY_HUB_NOTIFICATIONS_MODULE_UPPERCASE_NAME 8759
#define IDS_SETTINGS_SAFETY_HUB_NOTIFICATIONS_MODULE_LOWERCASE_NAME 8760
#define IDS_SETTINGS_SAFETY_HUB_PERMISSIONS_MODULE_UPPERCASE_NAME 8761
#define IDS_SETTINGS_SAFETY_HUB_PERMISSIONS_MODULE_LOWERCASE_NAME 8762
#define IDS_SETTINGS_SAFETY_HUB_MODULE_NAME_SEPARATOR 8763
#define IDS_SETTINGS_AI_PAGE_TITLE 8764
#define IDS_SETTINGS_AI_PAGE_MAIN_LABEL 8765
#define IDS_SETTINGS_AI_PAGE_MAIN_SUBLABEL 8766
#define IDS_SETTINGS_AI_COMPOSE_LABEL 8767
#define IDS_SETTINGS_AI_COMPOSE_SUBLABEL 8768
#define IDS_SETTINGS_EXPERIMENTAL_ADVANCED_FEATURE2_LABEL 8769
#define IDS_SETTINGS_EXPERIMENTAL_ADVANCED_FEATURE2_SUBLABEL 8770
#define IDS_SETTINGS_EXPERIMENTAL_ADVANCED_FEATURE3_LABEL 8771
#define IDS_SETTINGS_EXPERIMENTAL_ADVANCED_FEATURE3_SUBLABEL 8772
#define IDS_SETTINGS_SUBPAGE_BACK_BUTTON_ARIA_LABEL 8773
#define IDS_SETTINGS_SUBPAGE_BACK_BUTTON_ARIA_ROLE_DESCRIPTION 8774
#define IDS_SETTINGS_SUBPAGE_LEARN_MORE_ARIA_LABEL 8775
#define IDS_SETTINGS_CAPTIONS 8776
#define IDS_SETTINGS_CAPTIONS_PREFERENCES_TITLE 8777
#define IDS_SETTINGS_CAPTIONS_PREFERENCES_SUBTITLE 8778
#define IDS_SETTINGS_CAPTIONS_TEXT_SIZE 8779
#define IDS_SETTINGS_CAPTIONS_TEXT_FONT 8780
#define IDS_SETTINGS_CAPTIONS_TEXT_COLOR 8781
#define IDS_SETTINGS_CAPTIONS_TEXT_OPACITY 8782
#define IDS_SETTINGS_CAPTIONS_BACKGROUND_OPACITY 8783
#define IDS_SETTINGS_CAPTIONS_OPACITY_OPAQUE 8784
#define IDS_SETTINGS_CAPTIONS_OPACITY_SEMI_TRANSPARENT 8785
#define IDS_SETTINGS_CAPTIONS_OPACITY_TRANSPARENT 8786
#define IDS_SETTINGS_CAPTIONS_TEXT_SHADOW 8787
#define IDS_SETTINGS_CAPTIONS_TEXT_SHADOW_NONE 8788
#define IDS_SETTINGS_CAPTIONS_TEXT_SHADOW_RAISED 8789
#define IDS_SETTINGS_CAPTIONS_TEXT_SHADOW_DEPRESSED 8790
#define IDS_SETTINGS_CAPTIONS_TEXT_SHADOW_UNIFORM 8791
#define IDS_SETTINGS_CAPTIONS_TEXT_SHADOW_DROP_SHADOW 8792
#define IDS_SETTINGS_CAPTIONS_BACKGROUND_COLOR 8793
#define IDS_SETTINGS_CAPTIONS_COLOR_BLACK 8794
#define IDS_SETTINGS_CAPTIONS_COLOR_WHITE 8795
#define IDS_SETTINGS_CAPTIONS_COLOR_RED 8796
#define IDS_SETTINGS_CAPTIONS_COLOR_GREEN 8797
#define IDS_SETTINGS_CAPTIONS_COLOR_BLUE 8798
#define IDS_SETTINGS_CAPTIONS_COLOR_YELLOW 8799
#define IDS_SETTINGS_CAPTIONS_COLOR_CYAN 8800
#define IDS_SETTINGS_CAPTIONS_COLOR_MAGENTA 8801
#define IDS_SETTINGS_CAPTIONS_DEFAULT_SETTING 8802
#define IDS_SETTINGS_CAPTIONS_LANGUAGE 8803
#define IDS_SETTINGS_CAPTIONS_MANAGE_LANGUAGES_TITLE 8804
#define IDS_SETTINGS_CAPTIONS_MANAGE_LANGUAGES_SUBTITLE 8805
#define IDS_SETTINGS_CAPTIONS_LIVE_TRANSLATE_TARGET_LANGUAGE 8806
#define IDS_SETTINGS_CAPTIONS_REMOVE_LANGUAGE_ARIA_LABEL 8807
#define IDS_SETTINGS_NEARBY_SHARE_TITLE 8808
#define IDS_SETTINGS_NEARBY_SHARE_TITLE_PH 8809
#define IDS_SETTINGS_NEARBY_SHARE_SET_UP_BUTTON_TITLE 8810
#define IDS_SETTINGS_NEARBY_SHARE_DEVICE_NAME_ROW_TITLE 8811
#define IDS_SETTINGS_NEARBY_SHARE_DEVICE_NAME_DIALOG_TITLE 8812
#define IDS_SETTINGS_NEARBY_SHARE_DEVICE_NAME_FIELD_LABEL 8813
#define IDS_SETTINGS_NEARBY_SHARE_EDIT_DEVICE_NAME 8814
#define IDS_SETTINGS_NEARBY_SHARE_FAST_INITIATION_NOTIFICATION_TOGGLE_TITLE 8815
#define IDS_SETTINGS_NEARBY_SHARE_FAST_INITIATION_NOTIFICATION_TOGGLE_DESCRIPTION 8816
#define IDS_SETTINGS_NEARBY_SHARE_FAST_INITIATION_NOTIFICATION_TOGGLE_ARIA_LABEL 8817
#define IDS_SETTINGS_NEARBY_SHARE_DEVICE_NAME_ARIA_DESCRIPTION 8818
#define IDS_SETTINGS_NEARBY_SHARE_CONFIRM_DEVICE_NAME 8819
#define IDS_SETTINGS_NEARBY_SHARE_MANAGE_CONTACTS_LABEL 8820
#define IDS_SETTINGS_NEARBY_SHARE_MANAGE_CONTACTS_ROW_TITLE 8821
#define IDS_SETTINGS_NEARBY_SHARE_EDIT_DATA_USAGE 8822
#define IDS_SETTINGS_NEARBY_SHARE_UPDATE_DATA_USAGE 8823
#define IDS_SETTINGS_NEARBY_SHARE_DATA_USAGE_DIALOG_TITLE 8824
#define IDS_SETTINGS_NEARBY_SHARE_DATA_USAGE_WIFI_ONLY_LABEL 8825
#define IDS_SETTINGS_NEARBY_SHARE_DATA_USAGE_WIFI_ONLY_DESCRIPTION 8826
#define IDS_SETTINGS_NEARBY_SHARE_DATA_USAGE_MOBILE_DATA_LABEL 8827
#define IDS_SETTINGS_NEARBY_SHARE_DATA_USAGE_MOBILE_DATA_DESCRIPTION 8828
#define IDS_SETTINGS_NEARBY_SHARE_DATA_USAGE_MOBILE_DATA_TOOLTIP 8829
#define IDS_SETTINGS_NEARBY_SHARE_DATA_USAGE_OFFLINE_LABEL 8830
#define IDS_SETTINGS_NEARBY_SHARE_DATA_USAGE_OFFLINE_DESCRIPTION 8831
#define IDS_SETTINGS_NEARBY_SHARE_DATA_USAGE_EDIT_BUTTON_DATA_DESCRIPTION 8832
#define IDS_SETTINGS_NEARBY_SHARE_DATA_USAGE_EDIT_BUTTON_WIFI_ONLY_DESCRIPTION 8833
#define IDS_SETTINGS_NEARBY_SHARE_DATA_USAGE_EDIT_BUTTON_OFFLINE_DESCRIPTION 8834
#define IDS_SETTINGS_NEARBY_SHARE_CONTACT_VISIBILITY_ROW_TITLE 8835
#define IDS_SETTINGS_NEARBY_SHARE_EDIT_VISIBILITY 8836
#define IDS_SETTINGS_NEARBY_SHARE_VISIBILITY_DIALOG_TITLE 8837
#define IDS_SETTINGS_NEARBY_SHARE_VISIBILITY_DIALOG_SAVE 8838
#define IDS_SETTINGS_NEARBY_SHARE_DESCRIPTION 8839
#define IDS_SETTINGS_NEARBY_SHARE_HIGH_VISIBILITY_TITLE 8840
#define IDS_SETTINGS_NEARBY_SHARE_HIGH_VISIBILITY_ON 8841
#define IDS_SETTINGS_NEARBY_SHARE_HIGH_VISIBILITY_OFF 8842
#define IDS_SETTINGS_ENABLE_URL_KEYED_ANONYMIZED_DATA_COLLECTION 8843
#define IDS_SETTINGS_ENABLE_URL_KEYED_ANONYMIZED_DATA_COLLECTION_DESC 8844
#define IDS_SETTINGS_SPELLING_PREF 8845
#define IDS_SETTINGS_ENABLE_LOGGING_PREF 8846
#define IDS_SETTINGS_ENABLE_LOGGING_PREF_DESC 8847
#define IDS_SETTINGS_LINKDOCTOR_PREF 8848
#define IDS_SETTINGS_LINKDOCTOR_PREF_DESC 8849
#define IDS_SETTINGS_SUGGEST_PREF 8850
#define IDS_SETTINGS_DRIVE_SUGGEST_PREF 8851
#define IDS_SETTINGS_PEOPLE_SIGNED_IN_TO_ACCOUNT 8852
#define IDS_SETTINGS_PEOPLE_SYNCING_TO_ACCOUNT 8853
#define IDS_SETTINGS_PEOPLE_SYNC_PAUSED 8854
#define IDS_SETTINGS_PEOPLE_SIGN_IN_PROMPT 8855
#define IDS_SETTINGS_PEOPLE_SYNC_TURN_OFF 8856
#define IDS_SETTINGS_SETTINGS_CHECKBOX_LABEL 8857
#define IDS_SETTINGS_PEOPLE_SYNC_NOT_WORKING 8858
#define IDS_SETTINGS_PEOPLE_SYNC_PASSWORDS_NOT_WORKING 8859
#define IDS_SETTINGS_SYNC_ADVANCED_PAGE_TITLE 8860
#define IDS_SETTINGS_NEW_SYNC_ADVANCED_PAGE_TITLE 8861
#define IDS_SETTINGS_PEOPLE_SYNC_ANOTHER_ACCOUNT 8862
#define IDS_SETTINGS_SYNC_DISCONNECT_CONFIRM 8863
#define IDS_SETTINGS_PEOPLE_SIGN_OUT 8864
#define IDS_SETTINGS_AUTOFILL_CHECKBOX_LABEL 8865
#define IDS_SETTINGS_HISTORY_CHECKBOX_LABEL 8866
#define IDS_SETTINGS_EXTENSIONS_CHECKBOX_LABEL 8867
#define IDS_SETTINGS_OPEN_TABS_CHECKBOX_LABEL 8868
#define IDS_SETTINGS_SAVED_TAB_GROUPS_CHECKBOX_LABEL 8869
#define IDS_SETTINGS_WIFI_CONFIGURATIONS_CHECKBOX_LABEL 8870
#define IDS_SETTINGS_SYNC_EVERYTHING_CHECKBOX_LABEL 8871
#define IDS_SETTINGS_APPS_CHECKBOX_LABEL 8872
#define IDS_SETTINGS_APPS_CHECKBOX_SUBLABEL 8873
#define IDS_SETTINGS_NON_PERSONALIZED_SERVICES_SECTION_LABEL 8874
#define IDS_SETTINGS_CUSTOMIZE_SYNC 8875
#define IDS_SETTINGS_SYNC_DATA 8876
#define IDS_SETTINGS_PASSWORDS_CHECKBOX_LABEL 8877
#define IDS_SETTINGS_PASSWORDS_AND_PASSKEYS_CHECKBOX_LABEL 8878
#define IDS_SETTINGS_PASSPHRASE_PLACEHOLDER 8879
#define IDS_SETTINGS_EXISTING_PASSPHRASE_TITLE 8880
#define IDS_SETTINGS_SUBMIT_PASSPHRASE 8881
#define IDS_SETTINGS_ENCRYPT_WITH_GOOGLE_CREDENTIALS_LABEL 8882
#define IDS_SETTINGS_BOOKMARKS_CHECKBOX_LABEL 8883
#define IDS_SETTINGS_READING_LIST_CHECKBOX_LABEL 8884
#define IDS_SETTINGS_ENCRYPTION_OPTIONS 8885
#define IDS_SETTINGS_MISMATCHED_PASSPHRASE_ERROR 8886
#define IDS_SETTINGS_EMPTY_PASSPHRASE_ERROR 8887
#define IDS_SETTINGS_INCORRECT_PASSPHRASE_ERROR 8888
#define IDS_SETTINGS_NEW_MANAGE_SYNCED_DATA_TITLE_UNIFIED_CONSENT 8889
#define IDS_SETTINGS_NEW_SYNC_ADVANCED_DEVICE_PAGE_TITLE 8890
#define IDS_SETTINGS_NEW_SYNC_ADVANCED_BROWSER_PAGE_TITLE 8891
#define IDS_SETTINGS_NEW_MANAGE_SYNCED_DATA_SUBTITLE_UNIFIED_CONSENT 8892
#define IDS_SETTINGS_NEW_MANAGE_BROWSER_SYNCED_DATA_TITLE 8893
#define IDS_SETTINGS_SYNC_SYNC_AND_NON_PERSONALIZED_SERVICES 8894
#define IDS_SETTINGS_PASSPHRASE_CONFIRMATION_PLACEHOLDER 8895
#define IDS_SETTINGS_SYNC_LOADING 8896
#define IDS_SETTINGS_SYNC_TIMEOUT 8897
#define IDS_SETTINGS_SYNC 8898
#define IDS_SETTINGS_SYNC_SETTINGS_CANCEL_SYNC 8899
#define IDS_SETTINGS_SYNC_SETUP_CANCEL_DIALOG_TITLE 8900
#define IDS_SETTINGS_SYNC_SETUP_CANCEL_DIALOG_BODY 8901
#define IDS_SETTINGS_ABOUT_UPGRADE_CHECK_STARTED 8903
#define IDS_SETTINGS_UPDATE_TO_ROLLBACK_VERSION_DISALLOWED 8904
#define IDS_SETTINGS_THEME_CHECKBOX_LABEL 8906
#define IDS_SUPPORT_TOOL_ISSUE_DETAILS_PAGE_TITLE 8910
#define IDS_SUPPORT_TOOL_DATA_SELECTION_PAGE_TITLE 8911
#define IDS_SUPPORT_TOOL_REVIEW_PII_PAGE_TITLE 8912
#define IDS_SUPPORT_TOOL_DATA_EXPORT_DONE_PAGE_TITLE 8913
#define IDS_SUPPORT_TOOL_DATA_EXPORTED_TEXT 8914
#define IDS_SUPPORT_TOOL_SUPPORT_CASE_ID 8915
#define IDS_SUPPORT_TOOL_EMAIL 8916
#define IDS_SUPPORT_TOOL_DESCRIBE_ISSUE_TEXT 8917
#define IDS_SUPPORT_TOOL_ISSUE_DESCRIPTION_PLACEHOLDER 8918
#define IDS_SUPPORT_TOOL_PII_WARNING_TEXT 8919
#define IDS_SUPPORT_TOOL_INCLUDE_ALL_PII_RADIO_BUTTON 8920
#define IDS_SUPPORT_TOOL_REMOVE_PII_RADIO_BUTTON 8921
#define IDS_SUPPORT_TOOL_PII_REMOVAL_DISCLAIMER 8922
#define IDS_SUPPORT_TOOL_MANUALLY_SELECT_PII_RADIO_BUTTON 8923
#define IDS_SUPPORT_TOOL_CANCEL_BUTTON_TEXT 8924
#define IDS_SUPPORT_TOOL_EXPORT_BUTTON_TEXT 8925
#define IDS_SUPPORT_TOOL_BACK_BUTTON_TEXT 8926
#define IDS_SUPPORT_TOOL_DISMISS_BUTTON_TEXT 8927
#define IDS_SUPPORT_TOOL_CONTINUE_BUTTON_TEXT 8928
#define IDS_SUPPORT_TOOL_DATA_COLLECTION_SPINNER 8929
#define IDS_SUPPORT_TOOL_DATA_EXPORT_SPINNER 8930
#define IDS_SUPPORT_TOOL_TAB_TITLE 8931
#define IDS_SUPPORT_TOOL_URL_GENERATOR_PAGE_TITLE 8932
#define IDS_SUPPORT_TOOL_DATA_COLLECTOR_LIST_TITLE 8933
#define IDS_SUPPORT_TOOL_GET_LINK_TEXT 8934
#define IDS_SUPPORT_TOOL_COPY_LINK_DESCRIPTION 8935
#define IDS_SUPPORT_TOOL_COPY_LINK_BUTTON_TEXT 8936
#define IDS_SUPPORT_TOOL_COPY_TOKEN_BUTTON_TEXT 8937
#define IDS_SUPPORT_TOOL_DONT_INCLUDE_EMAIL 8938
#define IDS_SUPPORT_TOOL_LINK_COPIED_TEXT 8939
#define IDS_SUPPORT_TOOL_TOKEN_COPIED_TEXT 8940
#define IDS_SUPPORT_TOOL_SELECT_DATA_COLLECTOR_ERROR 8941
#define IDS_SUPPORT_TOOL_SELECT_ALL 8942
#define IDS_SUPPORT_TOOL_CHROME_SYSTEM_INFO 8943
#define IDS_SUPPORT_TOOL_CRASH_IDS 8944
#define IDS_SUPPORT_TOOL_MEMORY_DETAILS 8945
#define IDS_SUPPORT_TOOL_UI_HIEARCHY 8946
#define IDS_SUPPORT_TOOL_ADDITIONAL_CROS_PLATFROM_LOGS 8947
#define IDS_SUPPORT_TOOL_DEVICE_EVENT 8948
#define IDS_SUPPORT_TOOL_INTEL_WIFI_DEBUG_DUMP 8949
#define IDS_SUPPORT_TOOL_TOUCH_EVENTS 8950
#define IDS_SUPPORT_TOOL_LACROS_SYSTEM_INFO 8951
#define IDS_SUPPORT_TOOL_LACROS 8952
#define IDS_SUPPORT_TOOL_CHROMEOS_FLEX_LOGS 8953
#define IDS_SUPPORT_TOOL_DBUS_DETAILS 8954
#define IDS_SUPPORT_TOOL_CHROMEOS_NETWORK_ROUTES 8955
#define IDS_SUPPORT_TOOL_CHROMEOS_SHILL_LOGS 8956
#define IDS_SUPPORT_TOOL_POLICIES 8957
#define IDS_SUPPORT_TOOL_CHROMEOS_SYSTEM_STATE 8958
#define IDS_SUPPORT_TOOL_CHROMEOS_SYSTEM_LOGS 8959
#define IDS_SUPPORT_TOOL_CHROMEOS_CHROME_USER_LOGS 8960
#define IDS_SUPPORT_TOOL_CHROMEOS_BLUETOOTH_FLOSS 8961
#define IDS_SUPPORT_TOOL_CHROMEOS_CONNECTED_INPUT_DEVICES 8962
#define IDS_SUPPORT_TOOL_CHROMEOS_TRAFFIC_COUNTERS 8963
#define IDS_SUPPORT_TOOL_CHROMEOS_VIRTUAL_KEYBOARD 8964
#define IDS_SUPPORT_TOOL_CHROMEOS_NETWORK_HEALTH 8965
#define IDS_SUPPORT_TOOL_PERFORMANCE 8966
#define IDS_SUPPORT_TOOL_SIGN_IN 8967
#define IDS_SUPPORT_TOOL_CHROMEOS_APP_SERVICE 8968
#define IDS_SUPPORT_TOOL_ANDROID_APP_INFO 8969
#define IDS_SUPPORT_TOOL_WIFI_SSID 8970
#define IDS_SUPPORT_TOOL_CELLULAR_LOCATION_INFO 8971
#define IDS_SUPPORT_TOOL_EMAIL_ADDRESS 8972
#define IDS_SUPPORT_TOOL_GAIA_ID 8973
#define IDS_SUPPORT_TOOL_STABLE_IDENTIDIERS 8974
#define IDS_SUPPORT_TOOL_PRINTING_IPP_ADDRESS 8975
#define IDS_SUPPORT_TOOL_IP_ADDRESS 8976
#define IDS_SUPPORT_TOOL_MAC_ADDRESS 8977
#define IDS_SUPPORT_TOOL_WINDOW_TITLES 8978
#define IDS_SUPPORT_TOOL_URLS 8979
#define IDS_SUPPORT_TOOL_SERIAL_NUMBERS 8980
#define IDS_SUPPORT_TOOL_REMOVABLE_STORAGE_NAMES 8981
#define IDS_SUPPORT_TOOL_EAP 8982
#define IDS_EXTENSIONS_ALLOW_FILE_ACCESS 8983
#define IDS_EXTENSIONS_ALLOW_ON_ALL_URLS 8984
#define IDS_EXTENSIONS_ALLOW_ON_FOLLOWING_SITES 8985
#define IDS_EXTENSIONS_VIEW_ACTIVITY_LOG 8986
#define IDS_EXTENSIONS_BACKGROUND_PAGE 8987
#define IDS_EXTENSIONS_SERVICE_WORKER_BACKGROUND 8988
#define IDS_EXTENSIONS_CORRUPTED_EXTENSION 8989
#define IDS_EXTENSIONS_ENABLE_ERROR_COLLECTION 8990
#define IDS_EXTENSIONS_ENABLE_TOGGLE_TOOLTIP_DISABLED 8991
#define IDS_EXTENSIONS_ENABLE_TOGGLE_TOOLTIP_ENABLED 8992
#define IDS_EXTENSIONS_ENABLE_TOGGLE_TOOLTIP_ENABLED_WITH_SITE_ACCESS 8993
#define IDS_EXTENSIONS_ERROR_NO_ERRORS_CODE_MESSAGE 8994
#define IDS_EXTENSIONS_INSTALL_DROP_TARGET 8995
#define IDS_EXTENSIONS_INSTALL_WARNINGS 8996
#define IDS_EXTENSIONS_LOG_LEVEL_ERROR 8997
#define IDS_EXTENSIONS_LOG_LEVEL_INFO 8998
#define IDS_EXTENSIONS_LOG_LEVEL_WARN 8999
#define IDS_EXTENSIONS_PATH 9000
#define IDS_EXTENSIONS_PERMISSIONS_OFF 9001
#define IDS_EXTENSIONS_RELOAD_TERMINATED 9002
#define IDS_EXTENSIONS_REPAIR_CORRUPTED 9003
#define IDS_EXTENSIONS_VIEW_IFRAME 9004
#define IDS_EXTENSIONS_VIEW_INACTIVE 9005
#define IDS_EXTENSIONS_VIEW_INCOGNITO 9006
#define IDS_EXTENSIONS_DEVELOPER_MODE 9007
#define IDS_EXTENSIONS_DISABLED_UPDATE_REQUIRED_BY_POLICY 9008
#define IDS_EXTENSIONS_DISABLED_PUBLISHED_IN_STORE_REQUIRED_BY_POLICY 9009
#define IDS_EXTENSIONS_MATCHING_RESTRICTED_SITES_ALLOW 9010
#define IDS_EXTENSIONS_MATCHING_RESTRICTED_SITES_TITLE 9011
#define IDS_EXTENSIONS_MATCHING_RESTRICTED_SITES_WARNING 9012
#define IDS_EXTENSIONS_MENU_BUTTON_LABEL 9013
#define IDS_EXTENSIONS_ERROR_PAGE_HEADING 9014
#define IDS_EXTENSIONS_EDIT_SITE_PERMISSIONS_ALLOW_ALL_EXTENSIONS 9015
#define IDS_EXTENSIONS_EDIT_SITE_PERMISSIONS_CUSTOMIZE_PER_EXTENSION 9016
#define IDS_EXTENSIONS_EDIT_SITE_PERMISSIONS_RESTRICT_EXTENSIONS 9017
#define IDS_EXTENSIONS_ERROR_ANONYMOUS_FUNCTION 9018
#define IDS_EXTENSIONS_ERROR_CONTEXT 9019
#define IDS_EXTENSIONS_ERROR_CONTEXT_UNKNOWN 9020
#define IDS_EXTENSIONS_CLEAR_ACTIVITIES 9021
#define IDS_EXTENSIONS_ERROR_CLEAR_ALL 9022
#define IDS_EXTENSIONS_A11Y_CLEAR_ENTRY 9023
#define IDS_EXTENSIONS_ERROR_STACK_TRACE 9024
#define IDS_EXTENSIONS_ERROR_LINES_NOT_SHOWN 9025
#define IDS_EXTENSIONS_HOST_PERMISSIONS_DESCRIPTION 9026
#define IDS_EXTENSIONS_PERMISSIONS_LEARN_MORE_A11Y_LABEL 9027
#define IDS_EXTENSIONS_HOST_PERMISSIONS_EDIT 9028
#define IDS_EXTENSIONS_ITEM_ERRORS 9029
#define IDS_EXTENSIONS_ITEM_HOST_PERMISSIONS_HEADING 9030
#define IDS_EXTENSIONS_NEW_HOST_PERMISSIONS_HEADING 9031
#define IDS_EXTENSIONS_HOST_PERMISSIONS_SUB_HEADING 9032
#define IDS_EXTENSIONS_HOST_ACCESS_ON_CLICK 9033
#define IDS_EXTENSIONS_HOST_ACCESS_ASK_ON_EVERY_VISIT 9034
#define IDS_EXTENSIONS_HOST_ACCESS_ON_SPECIFIC_SITES 9035
#define IDS_EXTENSIONS_HOST_ACCESS_ALLOW_ON_SPECIFIC_SITES 9036
#define IDS_EXTENSIONS_HOST_ACCESS_ON_ALL_SITES 9037
#define IDS_EXTENSIONS_HOST_ACCESS_ALLOW_ON_ALL_SITES 9038
#define IDS_EXTENSIONS_ITEM_ALLOWED_HOSTS 9039
#define IDS_EXTENSIONS_ACCESSIBILITY_ERROR_LINE 9040
#define IDS_EXTENSIONS_ACCESSIBILITY_ERROR_MULTI_LINE 9041
#define IDS_EXTENSIONS_ACTIVITY_LOG_PAGE_HEADING 9042
#define IDS_EXTENSIONS_ACTIVITY_LOG_SEARCH_LABEL 9043
#define IDS_EXTENSIONS_ACTIVITY_LOG_TYPE_COLUMN 9044
#define IDS_EXTENSIONS_ACTIVITY_LOG_NAME_COLUMN 9045
#define IDS_EXTENSIONS_ACTIVITY_LOG_COUNT_COLUMN 9046
#define IDS_EXTENSIONS_ACTIVITY_LOG_TIME_COLUMN 9047
#define IDS_EXTENSIONS_ACTIVITY_LOG_HISTORY_TAB_HEADING 9048
#define IDS_EXTENSIONS_ACTIVITY_LOG_STREAM_TAB_HEADING 9049
#define IDS_EXTENSIONS_START_ACTIVITY_STREAM 9050
#define IDS_EXTENSIONS_STOP_ACTIVITY_STREAM 9051
#define IDS_EXTENSIONS_EMPTY_STREAM_STARTED 9052
#define IDS_EXTENSIONS_EMPTY_STREAM_STOPPED 9053
#define IDS_EXTENSIONS_ACTIVITY_ARGUMENTS_HEADING 9054
#define IDS_EXTENSIONS_WEB_REQUEST_INFO_HEADING 9055
#define IDS_EXTENSIONS_ACTIVITY_LOG_MORE_ACTIONS_LABEL 9056
#define IDS_EXTENSIONS_ACTIVITY_LOG_EXPAND_ALL 9057
#define IDS_EXTENSIONS_ACTIVITY_LOG_COLLAPSE_ALL 9058
#define IDS_EXTENSIONS_ACTIVITY_LOG_EXPORT_HISTORY 9059
#define IDS_EXTENSIONS_ITEM_ID 9060
#define IDS_EXTENSIONS_ITEM_INSPECT_VIEWS 9061
#define IDS_EXTENSIONS_ITEM_INSPECT_VIEWS_EXTRA 9062
#define IDS_EXTENSIONS_ITEM_NO_ACTIVE_VIEWS 9063
#define IDS_EXTENSIONS_ITEM_ALLOW_INCOGNITO 9064
#define IDS_EXTENSIONS_ITEM_DEPENDENCIES 9065
#define IDS_EXTENSIONS_DEPENDENT_ENTRY 9066
#define IDS_EXTENSIONS_ITEM_DESCRIPTION 9067
#define IDS_EXTENSIONS_ITEM_DETAILS 9068
#define IDS_EXTENSIONS_DETAILS_BACK_BUTTON_ARIA_LABEL 9069
#define IDS_EXTENSIONS_DETAILS_BACK_BUTTON_ARIA_ROLE_DESCRIPTION 9070
#define IDS_EXTENSIONS_EXTENSION_A11Y_ASSOCIATION 9071
#define IDS_EXTENSIONS_APP_ICON 9072
#define IDS_EXTENSIONS_EXTENSION_ICON 9073
#define IDS_EXTENSIONS_ITEM_ID_HEADING 9074
#define IDS_EXTENSIONS_EXTENSION_ENABLED 9075
#define IDS_EXTENSIONS_APP_ENABLED 9076
#define IDS_EXTENSIONS_ITEM_OFF 9077
#define IDS_EXTENSIONS_ITEM_ON 9078
#define IDS_EXTENSIONS_ITEM_EXTENSION_WEBSITE 9079
#define IDS_EXTENSIONS_ITEM_CHROME_WEB_STORE 9080
#define IDS_EXTENSIONS_ITEM_OPTIONS 9081
#define IDS_EXTENSIONS_ITEM_PERMISSIONS 9082
#define IDS_EXTENSIONS_ITEM_PERMISSIONS_EMPTY 9083
#define IDS_EXTENSIONS_ITEM_PERMISSIONS_AND_SITE_ACCESS_EMPTY 9084
#define IDS_EXTENSIONS_ITEM_PIN_TO_TOOLBAR 9085
#define IDS_EXTENSIONS_ITEM_REMOVE_EXTENSION 9086
#define IDS_EXTENSIONS_ITEM_SITE_ACCESS 9087
#define IDS_EXTENSIONS_ITEM_SITE_ACCESS_ADD_HOST 9088
#define IDS_EXTENSIONS_ITEM_SITE_ACCESS_EMPTY 9089
#define IDS_EXTENSIONS_REMOVE_SITES_DIALOG_TITLE 9090
#define IDS_EXTENSIONS_ITEM_SOURCE 9091
#define IDS_EXTENSIONS_ITEM_SOURCE_INSTALLED_BY_DEFAULT 9092
#define IDS_EXTENSIONS_ITEM_SOURCE_POLICY 9093
#define IDS_EXTENSIONS_ITEM_SOURCE_SIDELOADED 9094
#define IDS_EXTENSIONS_ITEM_SOURCE_UNPACKED 9095
#define IDS_EXTENSIONS_ITEM_SOURCE_WEBSTORE 9096
#define IDS_EXTENSIONS_ITEM_VERSION 9097
#define IDS_EXTENSIONS_ITEM_RELOADED 9098
#define IDS_EXTENSIONS_ITEM_RELOADING 9099
#define IDS_EXTENSIONS_LOAD_ERROR_HEADING 9100
#define IDS_EXTENSIONS_LOAD_ERROR_ERROR_LABEL 9101
#define IDS_EXTENSIONS_LOAD_ERROR_FILE_LABEL 9102
#define IDS_EXTENSIONS_LOAD_ERROR_COULD_NOT_LOAD_MANIFEST 9103
#define IDS_EXTENSIONS_LOAD_ERROR_RETRY 9104
#define IDS_EXTENSIONS_LOADING_ACTIVITIES 9105
#define IDS_MISSING_OR_UNINSTALLED_EXTENSION 9106
#define IDS_EXTENSIONS_NO_ACTIVITIES 9107
#define IDS_EXTENSIONS_NO_INSTALLED_ITEMS 9108
#define IDS_EXTENSIONS_NO_DESCRIPTION 9109
#define IDS_EXTENSIONS_OPENS_IN_NEW_TAB 9110
#define IDS_EXTENSIONS_PACK_DIALOG_TITLE 9111
#define IDS_EXTENSIONS_PACK_DIALOG_WARNING_TITLE 9112
#define IDS_EXTENSIONS_PACK_DIALOG_ERROR_TITLE 9113
#define IDS_EXTENSIONS_PACK_DIALOG_PROCEED_ANYWAY 9114
#define IDS_EXTENSIONS_PACK_DIALOG_BROWSE_BUTTON 9115
#define IDS_EXTENSIONS_PACK_DIALOG_EXTENSION_ROOT_LABEL 9116
#define IDS_EXTENSIONS_PACK_DIALOG_KEY_FILE_LABEL 9117
#define IDS_EXTENSIONS_PACK_DIALOG_CONFIRM_BUTTON 9118
#define IDS_EXTENSIONS_TOOLBAR_TITLE 9119
#define IDS_EXTENSIONS_SEARCH 9120
#define IDS_EXTENSIONS_SITE_PERMISSIONS 9121
#define IDS_EXTENSIONS_SITE_PERMISSIONS_PAGE_TITLE 9122
#define IDS_EXTENSIONS_SITE_PERMISSIONS_VIEW_ALL_SITES 9123
#define IDS_EXTENSIONS_SITE_PERMISSIONS_ALL_SITES_PAGE_TITLE 9124
#define IDS_EXTENSIONS_SITE_PERMISSIONS_ALL_SITES_ONE_EXTENSION 9125
#define IDS_EXTENSIONS_SITE_PERMISSIONS_ALL_SITES_EXTENSION_COUNT 9126
#define IDS_EXTENSIONS_SITE_PERMISSIONS_ALWAYS_ON_ALL_SITES 9127
#define IDS_EXTENSIONS_SITE_PERMISSIONS_ALWAYS_ON_THIS_SITE 9128
#define IDS_EXTENSIONS_SITE_SETTINGS 9129
#define IDS_EXTENSIONS_PERMITTED_SITES 9130
#define IDS_EXTENSIONS_RESTRICTED_SITES 9131
#define IDS_EXTENSIONS_NO_SITES_ADDED 9132
#define IDS_EXTENSIONS_SITE_PERMISSIONS_ADD_SITE_DIALOG_TITLE 9133
#define IDS_EXTENSIONS_SITE_PERMISSIONS_EDIT_SITE_DIALOG_TITLE 9134
#define IDS_EXTENSIONS_SITE_PERMISSIONS_EDIT_URL 9135
#define IDS_EXTENSIONS_SITE_PERMISSIONS_EDIT_PERMISSIONS_DIALOG_TITLE 9136
#define IDS_EXTENSIONS_SITE_PERMISSIONS_EDIT_PERMISSIONS 9137
#define IDS_EXTENSIONS_SITE_PERMISSIONS_ASK_ON_EVERY_VISIT 9138
#define IDS_EXTENSIONS_SITE_PERMISSIONS_DIALOG_INPUT_ERROR 9139
#define IDS_EXTENSIONS_SITE_PERMISSIONS_DIALOG_INPUT_LABEL 9140
#define IDS_EXTENSIONS_SITE_PERMISSIONS_INCLUDES_SUBDOMAINS 9141
#define IDS_EXTENSIONS_EDIT_SHORTCUT_INPUT_LABEL 9142
#define IDS_EXTENSIONS_EDIT_SHORTCUT_BUTTON_LABEL 9143
#define IDS_EXTENSIONS_SHORTCUT_NOT_SET 9144
#define IDS_EXTENSIONS_SHORTCUT_SCOPE_LABEL 9145
#define IDS_EXTENSIONS_SHORTCUT_SCOPE_GLOBAL 9146
#define IDS_EXTENSIONS_APPS_TITLE 9147
#define IDS_EXTENSIONS_REMOVE 9148
#define IDS_EXTENSIONS_RUNTIME_HOSTS_DIALOG_TITLE 9149
#define IDS_EXTENSIONS_RUNTIME_HOSTS_DIALOG_INPUT_ERROR 9150
#define IDS_EXTENSIONS_RUNTIME_HOSTS_DIALOG_INPUT_LABEL 9151
#define IDS_EXTENSIONS_SIDEBAR_EXTENSIONS 9152
#define IDS_EXTENSIONS_SIDEBAR_DISCOVER_MORE 9153
#define IDS_EXTENSIONS_SIDEBAR_KEYBOARD_SHORTCUTS 9154
#define IDS_EXTENSIONS_TOOLBAR_LOAD_UNPACKED 9155
#define IDS_EXTENSIONS_TOOLBAR_LOAD_UNPACKED_DONE 9156
#define IDS_EXTENSIONS_TOOLBAR_PACK 9157
#define IDS_EXTENSIONS_TOOLBAR_UPDATE_NOW 9158
#define IDS_EXTENSIONS_TOOLBAR_UPDATE_NOW_TOOLTIP 9159
#define IDS_EXTENSIONS_TOOLBAR_UPDATE_DONE 9160
#define IDS_EXTENSIONS_TOOLBAR_UPDATING_TOAST 9161
#define IDS_EXTENSIONS_SHORTCUT_SET 9162
#define IDS_EXTENSIONS_TYPE_A_SHORTCUT 9163
#define IDS_EXTENSIONS_SUBPAGE_BUTTON 9164
#define IDS_EXTENSIONS_SECTION_HEADER 9165
#define IDS_EXTENSIONS_SC_MALWARE 9166
#define IDS_EXTENSIONS_SC_POLICY_VIOLATION_OFF 9167
#define IDS_EXTENSIONS_SC_POLICY_VIOLATION_ON 9168
#define IDS_EXTENSIONS_SC_UNPUBLISHED_OFF 9169
#define IDS_EXTENSIONS_SC_UNPUBLISHED_ON 9170
#define IDS_EXTENSIONS_SAFETY_CHECK_NO_PRIVACY_PRACTICES_ON 9171
#define IDS_EXTENSIONS_SAFETY_CHECK_NO_PRIVACY_PRACTICES_OFF 9172
#define IDS_EXTENSIONS_SC_TITLE 9173
#define IDS_EXTENSIONS_SC_KEEP_EXT 9174
#define IDS_EXTENSIONS_SC_REMOVE_ALL 9175
#define IDS_EXTENSIONS_SC_ALL_DONE_FOR_NOW 9176
#define IDS_EXTENSIONS_SC_REMOVE_BUTTON_A11Y_LABEL 9177
#define IDS_EXTENSIONS_SC_OPTION_MENU_A11Y_LABEL 9178
#define IDS_EXTENSIONS_MV2_DEPRECATION_PANEL_TITLE 9179
#define IDS_EXTENSIONS_MV2_DEPRECATION_PANEL_WARNING_HEADER 9180
#define IDS_EXTENSIONS_MV2_DEPRECATION_PANEL_WARNING_SUBTITLE 9181
#define IDS_EXTENSIONS_MV2_DEPRECATION_MESSAGE_WARNING_HEADER 9182
#define IDS_EXTENSIONS_MV2_DEPRECATION_MESSAGE_WARNING_SUBTITLE 9183
#define IDS_EXTENSIONS_MV2_DEPRECATION_PANEL_DISMISS_BUTTON 9184
#define IDS_EXTENSIONS_MV2_DEPRECATION_PANEL_FIND_ALTERNATIVE_BUTTON 9185
#define IDS_EXTENSIONS_MV2_DEPRECATION_PANEL_KEEP_FOR_NOW_BUTTON 9186
#define IDS_EXTENSIONS_INCLUDE_START_MODIFIER 9187
#define IDS_EXTENSIONS_TOO_MANY_MODIFIERS 9189
#define IDS_EXTENSIONS_NEED_CHARACTER 9190
#define IDS_NEARBY_CONFIRMATION_PAGE_ADD_CONTACT_SUBTITLE 9201
#define IDS_NEARBY_CONFIRMATION_PAGE_ADD_CONTACT_TITLE 9202
#define IDS_NEARBY_CONFIRMATION_PAGE_TITLE 9203
#define IDS_NEARBY_CONTACT_VISIBILITY_DOWNLOAD_FAILED 9204
#define IDS_NEARBY_CONTACT_VISIBILITY_DOWNLOADING 9205
#define IDS_NEARBY_CONTACT_VISIBILITY_NO_CONTACTS_SUBTITLE 9206
#define IDS_NEARBY_CONTACT_VISIBILITY_NO_CONTACTS_SUBTITLE_PH 9207
#define IDS_NEARBY_CONTACT_VISIBILITY_NO_CONTACTS_TITLE 9208
#define IDS_NEARBY_CONTACT_VISIBILITY_NUM_UNREACHABLE 9209
#define IDS_NEARBY_CONTACT_VISIBILITY_NUM_UNREACHABLE_PH 9210
#define IDS_NEARBY_CONTACT_VISIBILITY_OWN_ALL 9211
#define IDS_NEARBY_CONTACT_VISIBILITY_OWN_ALL_SELF_SHARE 9212
#define IDS_NEARBY_CONTACT_VISIBILITY_OWN_NONE 9213
#define IDS_NEARBY_CONTACT_VISIBILITY_OWN_SOME 9214
#define IDS_NEARBY_CONTACT_VISIBILITY_OWN_SOME_SELF_SHARE 9215
#define IDS_NEARBY_CONTACT_VISIBILITY_ZERO_STATE_TEXT 9216
#define IDS_NEARBY_CONTACT_VISIBILITY_OWN_YOUR_DEVICES 9217
#define IDS_NEARBY_DEVICE_NAME_EMPTY_ERROR 9218
#define IDS_NEARBY_DEVICE_NAME_TOO_LONG_ERROR 9219
#define IDS_NEARBY_DEVICE_NAME_INVALID_CHARACTERS_ERROR 9220
#define IDS_NEARBY_DISCOVERY_PAGE_INFO 9221
#define IDS_NEARBY_DISCOVERY_PAGE_SUBTITLE 9222
#define IDS_NEARBY_DISCOVERY_PAGE_TITLE 9223
#define IDS_NEARBY_DISCOVERY_PAGE_TITLE_PH 9224
#define IDS_NEARBY_DISCOVERY_PAGE_PLACEHOLDER 9225
#define IDS_NEARBY_ONBOARDING_PAGE_DEVICE_NAME 9226
#define IDS_NEARBY_ONBOARDING_PAGE_DEVICE_NAME_HELP 9227
#define IDS_NEARBY_ONBOARDING_PAGE_SUBTITLE 9228
#define IDS_NEARBY_ONBOARDING_PAGE_TITLE 9229
#define IDS_NEARBY_ONBOARDING_PAGE_TITLE_PH 9230
#define IDS_NEARBY_ONBOARDING_PAGE_DEVICE_VISIBILITY 9231
#define IDS_NEARBY_ONBOARDING_PAGE_DEVICE_VISIBILITY_HELP_ALL_CONTACTS 9232
#define IDS_NEARBY_VISIBILITY_PAGE_MANAGE_CONTACTS 9233
#define IDS_NEARBY_VISIBILITY_PAGE_SUBTITLE 9234
#define IDS_NEARBY_VISIBILITY_PAGE_TITLE 9235
#define IDS_NEARBY_SHARE_FEATURE_NAME 9236
#define IDS_NEARBY_SHARE_FEATURE_NAME_PH 9237
#define IDS_NEARBY_ACTIONS_ACCEPT 9238
#define IDS_NEARBY_ACTIONS_CANCEL 9239
#define IDS_NEARBY_ACTIONS_CLOSE 9240
#define IDS_NEARBY_ACTIONS_CONFIRM 9241
#define IDS_NEARBY_ACTIONS_DECLINE 9242
#define IDS_NEARBY_ACTIONS_NEXT 9243
#define IDS_NEARBY_ACTIONS_REJECT 9244
#define IDS_NEARBY_DEFAULT_DEVICE_NAME 9245
#define IDS_NEARBY_ERROR_CANCELLED 9246
#define IDS_NEARBY_ERROR_CANT_RECEIVE 9247
#define IDS_NEARBY_ERROR_CANT_SHARE 9248
#define IDS_NEARBY_ERROR_NO_RESPONSE 9249
#define IDS_NEARBY_ERROR_TRANSFER_IN_PROGRESS 9250
#define IDS_NEARBY_ERROR_NOT_ENOUGH_SPACE 9251
#define IDS_NEARBY_ERROR_REJECTED 9252
#define IDS_NEARBY_ERROR_SOMETHING_WRONG 9253
#define IDS_NEARBY_ERROR_TIME_OUT 9254
#define IDS_NEARBY_ERROR_TRY_AGAIN 9255
#define IDS_NEARBY_ERROR_UNSUPPORTED_FILE_TYPE 9256
#define IDS_NEARBY_FILE_ATTACHMENTS_CAPITALIZED_APPS 9257
#define IDS_NEARBY_FILE_ATTACHMENTS_NOT_CAPITALIZED_APPS 9258
#define IDS_NEARBY_FILE_ATTACHMENTS_CAPITALIZED_IMAGES 9259
#define IDS_NEARBY_FILE_ATTACHMENTS_NOT_CAPITALIZED_IMAGES 9260
#define IDS_NEARBY_FILE_ATTACHMENTS_CAPITALIZED_UNKNOWN 9261
#define IDS_NEARBY_FILE_ATTACHMENTS_NOT_CAPITALIZED_UNKNOWN 9262
#define IDS_NEARBY_FILE_ATTACHMENTS_CAPITALIZED_VIDEOS 9263
#define IDS_NEARBY_FILE_ATTACHMENTS_NOT_CAPITALIZED_VIDEOS 9264
#define IDS_NEARBY_SECURE_CONNECTION_ID 9265
#define IDS_NEARBY_TEXT_ATTACHMENTS_CAPITALIZED_ADDRESSES 9266
#define IDS_NEARBY_TEXT_ATTACHMENTS_NOT_CAPITALIZED_ADDRESSES 9267
#define IDS_NEARBY_TEXT_ATTACHMENTS_CAPITALIZED_LINKS 9268
#define IDS_NEARBY_TEXT_ATTACHMENTS_NOT_CAPITALIZED_LINKS 9269
#define IDS_NEARBY_TEXT_ATTACHMENTS_CAPITALIZED_PHONE_NUMBERS 9270
#define IDS_NEARBY_TEXT_ATTACHMENTS_NOT_CAPITALIZED_PHONE_NUMBERS 9271
#define IDS_NEARBY_TEXT_ATTACHMENTS_CAPITALIZED_UNKNOWN 9272
#define IDS_NEARBY_TEXT_ATTACHMENTS_NOT_CAPITALIZED_UNKNOWN 9273
#define IDS_NEARBY_CAPITALIZED_UNKNOWN_ATTACHMENTS 9274
#define IDS_NEARBY_NOT_CAPITALIZED_UNKNOWN_ATTACHMENTS 9275
#define IDS_NEARBY_HIGH_VISIBILITY_SUB_TITLE 9276
#define IDS_NEARBY_HIGH_VISIBILITY_SUB_TITLE_MINUTES 9277
#define IDS_NEARBY_HIGH_VISIBILITY_SUB_TITLE_SECONDS 9278
#define IDS_NEARBY_HIGH_VISIBILITY_HELP_TEXT 9279
#define IDS_NEARBY_HIGH_VISIBILITY_TIMEOUT_TEXT 9280
#define IDS_NEARBY_HIGH_VISIBILITY_TRANSFER_IN_PROGRESS_ERROR 9281
#define IDS_NEARBY_HIGH_VISIBILITY_TRANSFER_IN_PROGRESS_DESCRIPTION 9282
#define IDS_NEARBY_HIGH_VISIBILITY_CONNECTION_MEDIUM_ERROR 9283
#define IDS_NEARBY_HIGH_VISIBILITY_CONNECTION_MEDIUM_DESCRIPTION 9284
#define IDS_NEARBY_HIGH_VISIBILITY_CONNECTION_MEDIUM_DESCRIPTION_PH 9285
#define IDS_NEARBY_RECEIVE_CONFIRM_PAGE_TITLE 9286
#define IDS_NEARBY_RECEIVE_CONFIRM_PAGE_CONNECTION_ID 9287
#define IDS_NEARBY_PREVIEW_TITLE_MULTIPLE_FILE 9288
#define IDS_NEARBY_ACCOUNT_ROW_LABEL 9289
#define IDS_NEARBY_ACCOUNT_ROW_LABEL_PH 9290
#define IDS_NEARBY_SETTINGS_HELP_CAPTION_TOP 9291
#define IDS_NEARBY_SETTINGS_HELP_CAPTION_TOP_PH 9292
#define IDS_NEARBY_SETTINGS_HELP_CAPTION_BOTTOM 9293
#define IDS_NEARBY_VISIBLITY_ALL_CONTACTS 9294
#define IDS_NEARBY_VISIBLITY_ALL_CONTACTS_DESCRIPTION 9295
#define IDS_NEARBY_VISIBILITY_CONTACTS_BUTTON 9296
#define IDS_NEARBY_VISIBLITY_SOME_CONTACTS 9297
#define IDS_NEARBY_VISIBLITY_SOME_CONTACTS_DESCRIPTION 9298
#define IDS_NEARBY_VISIBILITY_YOUR_DEVICES 9299
#define IDS_NEARBY_VISIBILITY_YOUR_DEVICES_DESCRIPTION 9300
#define IDS_NEARBY_VISIBILITY_ALL_CONTACTS_TOGGLE 9301
#define IDS_NEARBY_VISIBLITY_HIDDEN 9302
#define IDS_NEARBY_VISIBLITY_HIDDEN_DESCRIPTION 9303
#define IDS_NEARBY_VISIBLITY_UNKNOWN 9304
#define IDS_NEARBY_VISIBLITY_UNKNOWN_DESCRIPTION 9305
#define IDS_NEARBY_NOTIFICATION_ACTION_COPY_TO_CLIPBOARD 9306
#define IDS_NEARBY_NOTIFICATION_ACTION_OPEN_FOLDER 9307
#define IDS_NEARBY_NOTIFICATION_ACTION_OPEN_NETWORK_LIST 9308
#define IDS_NEARBY_NOTIFICATION_ACTION_OPEN_URL 9309
#define IDS_NEARBY_NOTIFICATION_ACCEPT_ACTION 9310
#define IDS_NEARBY_NOTIFICATION_CONNECTION_REQUEST_MESSAGE 9311
#define IDS_NEARBY_NOTIFICATION_CONNECTION_REQUEST_MESSAGE_WIFI_CREDENTIALS 9312
#define IDS_NEARBY_NOTIFICATION_CONNECTION_REQUEST_TITLE 9313
#define IDS_NEARBY_NOTIFICATION_CONNECTION_REQUEST_TITLE_PH 9314
#define IDS_NEARBY_NOTIFICATION_DECLINE_ACTION 9315
#define IDS_NEARBY_NOTIFICATION_ONBOARDING_MESSAGE 9316
#define IDS_NEARBY_NOTIFICATION_ONBOARDING_MESSAGE_PH 9317
#define IDS_NEARBY_NOTIFICATION_GO_VISIBLE_MESSAGE 9318
#define IDS_NEARBY_NOTIFICATION_ONBOARDING_TITLE 9319
#define IDS_NEARBY_NOTIFICATION_SET_UP_ACTION 9320
#define IDS_NEARBY_NOTIFICATION_GO_VISIBLE_ACTION 9321
#define IDS_NEARBY_NOTIFICATION_VISIBILITY_REMINDER_TITLE 9322
#define IDS_NEARBY_NOTIFICATION_VISIBILITY_REMINDER_MESSAGE 9323
#define IDS_NEARBY_NOTIFICATION_GO_TO_SETTINGS_ACTION 9324
#define IDS_NEARBY_NOTIFICATION_DISMISS_ACTION 9325
#define IDS_NEARBY_NOTIFICATION_RECEIVE_FAILURE_TITLE 9326
#define IDS_NEARBY_NOTIFICATION_RECEIVE_FAILURE_TITLE_WIFI_CREDENTIALS 9327
#define IDS_NEARBY_NOTIFICATION_RECEIVE_PROGRESS_TITLE 9328
#define IDS_NEARBY_NOTIFICATION_RECEIVE_PROGRESS_TITLE_WIFI_CREDENTIALS 9329
#define IDS_NEARBY_NOTIFICATION_RECEIVE_SUCCESS_TITLE 9330
#define IDS_NEARBY_NOTIFICATION_RECEIVE_SUCCESS_TITLE_WIFI_CREDENTIALS 9331
#define IDS_NEARBY_NOTIFICATION_SEND_FAILURE_TITLE 9332
#define IDS_NEARBY_NOTIFICATION_SEND_PROGRESS_TITLE 9333
#define IDS_NEARBY_NOTIFICATION_SEND_SUCCESS_TITLE 9334
#define IDS_NEARBY_NOTIFICATION_SOURCE 9335
#define IDS_NEARBY_NOTIFICATION_SOURCE_PH 9336
#define IDS_NEARBY_NOTIFICATION_SENDER_CANCELLED 9337
#define IDS_WELCOME_NEXT 9338
#define IDS_WELCOME_SKIP 9339
#define IDS_WELCOME_STEPS 9340
#define IDS_WELCOME_BOOKMARK_ADDED 9341
#define IDS_WELCOME_BOOKMARKS_ADDED 9342
#define IDS_WELCOME_BOOKMARK_REMOVED 9343
#define IDS_WELCOME_BOOKMARKS_REMOVED 9344
#define IDS_DEFAULT_BROWSER_CHANGED 9345
#define IDS_WELCOME_GOOGLE_APPS_DESCRIPTION 9346
#define IDS_WELCOME_GOOGLE_GMAIL 9348
#define IDS_WELCOME_GOOGLE_APPS_MAPS 9349
#define IDS_WELCOME_GOOGLE_APPS_NEWS 9350
#define IDS_WELCOME_GOOGLE_APPS_TRANSLATE 9351
#define IDS_WELCOME_GOOGLE_APPS_YOUTUBE 9352
#define IDS_WELCOME_NTP_BACKGROUND_DESCRIPTION 9353
#define IDS_WELCOME_NTP_BACKGROUND_DEFAULT_TITLE 9354
#define IDS_WELCOME_NTP_BACKGROUND_ART_TITLE 9355
#define IDS_WELCOME_NTP_BACKGROUND_LANDSCAPE_TITLE 9356
#define IDS_WELCOME_NTP_BACKGROUND_CITYSCAPE_TITLE 9357
#define IDS_WELCOME_NTP_BACKGROUND_EARTH_TITLE 9358
#define IDS_WELCOME_NTP_BACKGROUND_GEOMETRIC_SHAPES_TITLE 9359
#define IDS_WELCOME_NTP_BACKGROUND_PHOTO_BY_LABEL 9360
#define IDS_WELCOME_NTP_BACKGROUND_PREVIEW_UPDATED 9361
#define IDS_WELCOME_NTP_BACKGROUND_RESET 9362
#define IDS_WELCOME_SET_AS_DEFAULT_HEADER 9363
#define IDS_WELCOME_SET_AS_DEFAULT_SUB_HEADER 9364
#define IDS_WELCOME_SET_AS_DEFAULT_SET_AS_DEFAULT 9365
#define IDS_WELCOME_LANDING_TITLE 9366
#define IDS_WELCOME_LANDING_DESCRIPTION 9367
#define IDS_WELCOME_LANDING_NEW_USER 9368
#define IDS_WELCOME_LANDING_EXISTING_USER 9369
#define IDS_WELCOME_LANDING_PAUSE_ANIMATIONS 9370
#define IDS_WELCOME_LANDING_PLAY_ANIMATIONS 9371
#define IDS_WELCOME_SIGNIN_VIEW_HEADER 9372
#define IDS_WELCOME_SIGNIN_VIEW_SUB_HEADER 9373
#define IDS_WELCOME_SIGNIN_VIEW_SIGNIN 9374
#define IDS_WHATS_NEW_TITLE 9375
#define IDS_PASSWORD_MANAGER_UI_TITLE 9376
#define IDS_PASSWORD_MANAGER_UI_SEARCH_PROMPT 9377
#define IDS_PASSWORD_MANAGER_UI_CHECKUP 9378
#define IDS_PASSWORD_MANAGER_UI_PASSWORDS 9379
#define IDS_PASSWORD_MANAGER_UI_SETTINGS 9380
#define IDS_PASSWORD_MANAGER_UI_SAVE_PASSWORDS_TOGGLE_LABEL 9381
#define IDS_PASSWORD_MANAGER_UI_AUTOSIGNIN_TOGGLE_LABEL 9382
#define IDS_PASSWORD_MANAGER_UI_AUTOSIGNIN_TOGGLE_DESC 9383
#define IDS_PASSWORD_MANAGER_UI_PASSWORDS_DESCRIPTION 9384
#define IDS_PASSWORD_MANAGER_UI_ADD_PASSWORD_BUTTON 9385
#define IDS_PASSWORD_MANAGER_UI_ADD_SHORTCUT_TITLE 9386
#define IDS_PASSWORD_MANAGER_UI_ADD_SHORTCUT_DESCRIPTION 9387
#define IDS_PASSWORD_MANAGER_UI_TRUSTED_VAULT_OPT_IN_TITLE 9388
#define IDS_PASSWORD_MANAGER_UI_TRUSTED_VAULT_OPT_IN_DESCRIPTION 9389
#define IDS_PASSWORD_MANAGER_UI_TRUSTED_VAULT_OPTED_IN_TITLE 9390
#define IDS_PASSWORD_MANAGER_UI_TRUSTED_VAULT_OPTED_IN_DESCRIPTION 9391
#define IDS_PASSWORD_MANAGER_UI_SHARE 9392
#define IDS_PASSWORD_MANAGER_UI_SHARE_PASSWORD_ERROR_DESCRIPTION 9393
#define IDS_PASSWORD_MANAGER_UI_SHARE_PASSWORD_ERROR_TITLE 9394
#define IDS_PASSWORD_MANAGER_UI_SHARE_PASSWORD_LOADING_TITLE 9395
#define IDS_PASSWORD_MANAGER_UI_SHARE_PASSWORD_SUCCESS_TITLE 9396
#define IDS_PASSWORD_MANAGER_UI_SHARE_PASSWORD_CANCELED_TITLE 9397
#define IDS_PASSWORD_MANAGER_UI_SHARE_PASSWORD_NOT_FAMILY_MEMBER 9398
#define IDS_PASSWORD_MANAGER_UI_SHARE_PASSWORD_NO_OTHER_FAMILY_MEMBERS 9399
#define IDS_PASSWORD_MANAGER_UI_SHARE_PASSWORD_FAMILY_PICKER_DESCRIPTION 9400
#define IDS_PASSWORD_MANAGER_UI_SHARE_PASSWORD_CONFIRMATION_DESCRIPTION_SINGLE 9401
#define IDS_PASSWORD_MANAGER_UI_SHARE_PASSWORD_CONFIRMATION_DESCRIPTION_MULTIPLE 9402
#define IDS_PASSWORD_MANAGER_UI_SHARE_PASSWORD_CONFIRMATION_FOOTER_WEBSITE 9403
#define IDS_PASSWORD_MANAGER_UI_SHARE_PASSWORD_CONFIRMATION_FOOTER_ANDROID_APP 9404
#define IDS_PASSWORD_MANAGER_UI_SHARE_PASSWORD_VIEW_FAMILY 9405
#define IDS_PASSWORD_MANAGER_UI_SHARE_PASSWORD_MEMBER_UNAVAILABLE 9406
#define IDS_PASSWORD_MANAGER_UI_SHARING_IS_MANAGED_BY_ADMIN 9407
#define IDS_PASSWORD_MANAGER_UI_SHARE_PASSWORD_NOT_AVAILABLE 9408
#define IDS_PASSWORD_MANAGER_UI_SHARE_PASSWORD_TRY_AGAIN 9409
#define IDS_PASSWORD_MANAGER_UI_SHARE_PASSWORD_GOT_IT 9410
#define IDS_PASSWORD_MANAGER_UI_SHARE_DIALOG_TITLE 9411
#define IDS_PASSWORD_MANAGER_UI_IMPORT_BANNER_TITLE 9412
#define IDS_PASSWORD_MANAGER_UI_IMPORT_DESCRIPTION_ACCOUNT_STORE_USERS 9413
#define IDS_PASSWORD_MANAGER_UI_IMPORT_DESCRIPTION_SYNCING_USERS 9414
#define IDS_PASSWORD_MANAGER_UI_IMPORT_DESCRIPTION_SIGNEDOUT_USERS 9415
#define IDS_PASSWORD_MANAGER_UI_STORE_PICKER_OPTION_DEVICE 9416
#define IDS_PASSWORD_MANAGER_UI_STORE_PICKER_OPTION_ACCOUNT 9417
#define IDS_PASSWORD_MANAGER_UI_IMPORT_STORE_PICKER_ACCESSIBLE_NAME 9418
#define IDS_PASSWORD_MANAGER_UI_IMPORT_SELECT_FILE_DESCRIPTION 9419
#define IDS_PASSWORD_MANAGER_UI_SELECT_FILE 9420
#define IDS_PASSWORD_MANAGER_UI_IMPORT_MISSING_PASSWORD 9421
#define IDS_PASSWORD_MANAGER_UI_IMPORT_MISSING_URL 9422
#define IDS_PASSWORD_MANAGER_UI_IMPORT_INVALID_URL 9423
#define IDS_PASSWORD_MANAGER_UI_IMPORT_LONG_URL 9424
#define IDS_PASSWORD_MANAGER_UI_IMPORT_LONG_USERNAME 9425
#define IDS_PASSWORD_MANAGER_UI_IMPORT_LONG_PASSWORD 9426
#define IDS_PASSWORD_MANAGER_UI_IMPORT_LONG_NOTE 9427
#define IDS_PASSWORD_MANAGER_UI_IMPORT_CONFLICT_ACCOUNT 9428
#define IDS_PASSWORD_MANAGER_UI_IMPORT_CONFLICT_DEVICE 9429
#define IDS_PASSWORD_MANAGER_UI_IMPORT_ERROR_UNKNOWN 9430
#define IDS_PASSWORD_MANAGER_UI_IMPORT_ERROR_BAD_FORMAT 9431
#define IDS_PASSWORD_MANAGER_UI_IMPORT_FILE_SIZE_EXCEEDED 9432
#define IDS_PASSWORD_MANAGER_UI_IMPORT_ERROR_LIMIT_EXCEEDED 9433
#define IDS_PASSWORD_MANAGER_UI_IMPORT_ERROR_TITLE 9434
#define IDS_PASSWORD_MANAGER_UI_IMPORT_SUCCESS_TITLE 9435
#define IDS_PASSWORD_MANAGER_UI_IMPORT_COMPLETE_TITLE 9436
#define IDS_PASSWORD_MANAGER_UI_IMPORT_DELETE_FILE_OPTION 9437
#define IDS_PASSWORD_MANAGER_UI_IMPORT_VIEW_PASSWORDS 9438
#define IDS_PASSWORD_MANAGER_UI_IMPORT_ALREADY_ACTIVE 9439
#define IDS_PASSWORD_MANAGER_UI_IMPORT_SUCCESS_TIP 9440
#define IDS_PASSWORD_MANAGER_UI_IMPORT_FAILURES_SUMMARY 9441
#define IDS_PASSWORD_MANAGER_UI_IMPORT_BAD_ROWS_FORMAT 9442
#define IDS_PASSWORD_MANAGER_UI_IMPORT_SUCCESS_SUMMARY_ACCOUNT 9443
#define IDS_PASSWORD_MANAGER_UI_IMPORT_SUCCESS_SUMMARY_DEVICE 9444
#define IDS_PASSWORD_MANAGER_UI_IMPORT_CONFLICTS_TITLE 9445
#define IDS_PASSWORD_MANAGER_UI_IMPORT_CONFLICTS_DESCRIPTION 9446
#define IDS_PASSWORD_MANAGER_UI_IMPORT_CANCEL 9447
#define IDS_PASSWORD_MANAGER_UI_IMPORT_SKIP 9448
#define IDS_PASSWORD_MANAGER_UI_IMPORT_REPLACE 9449
#define IDS_PASSWORD_MANAGER_UI_EXPORT_TITLE 9450
#define IDS_PASSWORD_MANAGER_UI_DOWNLOAD_FILE 9451
#define IDS_PASSWORD_MANAGER_UI_EXPORT_BANNER_DESCRIPTION 9452
#define IDS_PASSWORD_MANAGER_UI_EXPORT_SUCCESSFUL 9453
#define IDS_PASSWORD_MANAGER_UI_EXPORT_TRY_AGAIN 9454
#define IDS_PASSWORD_MANAGER_UI_EXPORTING_FAILURE_TITLE 9455
#define IDS_PASSWORD_MANAGER_UI_EXPORTING_FAILURE_TIPS 9456
#define IDS_PASSWORD_MANAGER_UI_EXPORTING_FAILURE_TIP_ENOUGH_SPACE 9457
#define IDS_PASSWORD_MANAGER_UI_EXPORTING_FAILURE_TIP_ANOTHER_FOLDER 9458
#define IDS_PASSWORD_MANAGER_UI_CHECKUP_TITLE 9459
#define IDS_PASSWORD_MANAGER_UI_CHECKUP_RESULT 9460
#define IDS_PASSWORD_MANAGER_UI_JUST_NOW 9461
#define IDS_PASSWORD_MANAGER_UI_COMPROMISED_PASSWORDS_COUNT 9462
#define IDS_PASSWORD_MANAGER_UI_NO_COMPROMISED_PASSWORDS 9463
#define IDS_PASSWORD_MANAGER_UI_HAS_COMPROMISED_PASSWORDS 9464
#define IDS_PASSWORD_MANAGER_UI_REUSED_PASSWORDS_COUNT 9465
#define IDS_PASSWORD_MANAGER_UI_NO_REUSED_PASSWORDS 9466
#define IDS_PASSWORD_MANAGER_UI_HAS_REUSED_PASSWORDS 9467
#define IDS_PASSWORD_MANAGER_UI_WEAK_PASSWORDS_COUNT 9468
#define IDS_PASSWORD_MANAGER_UI_CHECKUP_GREEN_STATE_A11Y 9469
#define IDS_PASSWORD_MANAGER_UI_CHECKUP_YELLOW_STATE_A11Y 9470
#define IDS_PASSWORD_MANAGER_UI_CHECKUP_RED_STATE_A11Y 9471
#define IDS_PASSWORD_MANAGER_UI_NO_WEAK_PASSWORDS 9472
#define IDS_PASSWORD_MANAGER_UI_HAS_WEAK_PASSWORDS 9473
#define IDS_PASSWORD_MANAGER_UI_CHECK_PASSWORDS_AFTER_ERROR 9474
#define IDS_PASSWORD_MANAGER_UI_BLOCKED_SITES_TITLE 9475
#define IDS_PASSWORD_MANAGER_UI_BLOCKED_SITES_DESCRIPTION 9476
#define IDS_PASSWORD_MANAGER_UI_NUMBER_OF_ACCOUNTS 9477
#define IDS_PASSWORD_MANAGER_UI_USERNAME_LABEL 9478
#define IDS_PASSWORD_MANAGER_UI_SITES_LABEL 9479
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_LABEL 9480
#define IDS_PASSWORD_MANAGER_UI_NOTE_LABEL 9481
#define IDS_PASSWORD_MANAGER_UI_NO_NOTE_ADDED 9482
#define IDS_PASSWORD_MANAGER_UI_COPY_PASSWORD 9483
#define IDS_PASSWORD_MANAGER_UI_COPY_USERNAME 9484
#define IDS_PASSWORD_MANAGER_UI_SHOW_PASSWORD 9485
#define IDS_PASSWORD_MANAGER_UI_HIDE_PASSWORD 9486
#define IDS_PASSWORD_MANAGER_UI_SHOW_PASSWORD_A11Y 9487
#define IDS_PASSWORD_MANAGER_UI_HIDE_PASSWORD_A11Y 9488
#define IDS_PASSWORD_MANAGER_UI_FEDERATION_LABEL 9489
#define IDS_PASSWORD_MANAGER_UI_USERNAME_COPIED_TO_CLIPBOARD 9490
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_COPIED_TO_CLIPBOARD 9491
#define IDS_PASSWORD_MANAGER_UI_ADD_PASSWORD 9492
#define IDS_PASSWORD_MANAGER_UI_WEBSITE_LABEL 9493
#define IDS_PASSWORD_MANAGER_UI_ADD_PASSWORD_FOOTNOTE 9494
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_LEAKED 9495
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_PHISHED 9496
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_PHISHED_AND_LEAKED 9497
#define IDS_PASSWORD_MANAGER_UI_CHANGE_PASSWORD_BUTTON 9498
#define IDS_PASSWORD_MANAGER_UI_CHANGE_PASSWORD_BUTTON_ARIA_DESCRIPTION 9499
#define IDS_PASSWORD_MANAGER_UI_MORE_ACTIONS 9500
#define IDS_PASSWORD_MANAGER_UI_MORE_ACTIONS_ARIA_DESCRIPTION 9501
#define IDS_PASSWORD_MANAGER_UI_COMPROMISED_PASSWORDS_DESCRIPTION 9502
#define IDS_PASSWORD_MANAGER_UI_REUSED_PASSWORDS_DESCRIPTION 9503
#define IDS_PASSWORD_MANAGER_UI_WEAK_PASSWORDS_DESCRIPTION 9504
#define IDS_PASSWORD_MANAGER_UI_CHECKUP_SIGNED_OUT 9505
#define IDS_PASSWORD_MANAGER_UI_CHECKUP_OFFLINE 9506
#define IDS_PASSWORD_MANAGER_UI_CHECKUP_COMPROMISED_SECTION 9507
#define IDS_PASSWORD_MANAGER_UI_CHECKUP_NO_PASSWORDS 9508
#define IDS_PASSWORD_MANAGER_UI_CHECKUP_QUOTA_LIMIT 9509
#define IDS_PASSWORD_MANAGER_UI_CHECKUP_OTHER_ERROR 9510
#define IDS_PASSWORD_MANAGER_UI_CHECKUP_RUNNING_LABEL 9511
#define IDS_PASSWORD_MANAGER_UI_CHECKUP_PROGRESS 9512
#define IDS_PASSWORD_MANAGER_UI_CHECKUP_CANCELED 9513
#define IDS_PASSWORD_MANAGER_UI_MUTED_COMPROMISED_PASSWORDS 9514
#define IDS_PASSWORD_MANAGER_UI_MUTE_ISSUE 9515
#define IDS_PASSWORD_MANAGER_UI_UNMUTE_ISSUE 9516
#define IDS_PASSWORD_MANAGER_UI_NUMBER_OF_CREDENTIALS_WITH_REUSED_PASSWORD 9517
#define IDS_PASSWORD_MANAGER_UI_HELP 9518
#define IDS_PASSWORD_MANAGER_UI_EDIT_PASSWORD 9523
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_EDIT_FOOTNOTE 9524
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_DELETED 9525
#define IDS_PASSWORD_MANAGER_UI_UNDO 9526
#define IDS_PASSWORD_MANAGER_UI_SEARCH_RESULT 9527
#define IDS_PASSWORD_MANAGER_UI_CHANGE_PASSWORD_IN_APP 9528
#define IDS_PASSWORD_MANAGER_UI_CHANGE_PASSWORD_MANAGER_PIN 9529
#define IDS_PASSWORD_MANAGER_UI_ALREADY_CHANGED_PASSWORD 9530
#define IDS_PASSWORD_MANAGER_UI_EDIT_DISCLAIMER_DESCRIPTION 9531
#define IDS_PASSWORD_MANAGER_UI_EDIT_DISCLAIMER_TITLE 9532
#define IDS_PASSWORD_MANAGER_UI_DELETE_PASSWORD_CONFIRMATION_TITLE 9533
#define IDS_PASSWORD_MANAGER_UI_DELETE_PASSWORD_CONFIRMATION_DESCRIPTION 9534
#define IDS_PASSWORD_MANAGER_UI_SHOW_MORE 9535
#define IDS_PASSWORD_MANAGER_UI_NOT_VALID_WEB_ADDRESS 9536
#define IDS_PASSWORD_MANAGER_UI_MISSING_TLD 9537
#define IDS_PASSWORD_MANAGER_UI_USERNAME_ALREADY_USED 9538
#define IDS_PASSWORD_MANAGER_UI_NOTE_CHARACTER_COUNT 9539
#define IDS_PASSWORD_MANAGER_UI_NOTE_CHARACTER_COUNT_WARNING 9540
#define IDS_PASSWORD_MANAGER_UI_AUTH_TIMED_OUT 9541
#define IDS_PASSWORD_MANAGER_UI_AUTH_TIMED_OUT_DESCRIPTION 9542
#define IDS_PASSWORD_MANAGER_UI_VIEW_EXISTING_PASSWORD 9543
#define IDS_PASSWORD_MANAGER_UI_VIEW_EXISTING_PASSWORD_ARIA_DESCRIPTION 9544
#define IDS_PASSWORD_MANAGER_UI_MOVE_PASSWORDS_TO_ACCOUNT 9545
#define IDS_PASSWORD_MANAGER_UI_OPENS_IN_NEW_TAB 9546
#define IDS_PASSWORD_MANAGER_UI_VIEW_PASSWORD_ARIA_DESCRIPTION 9547
#define IDS_PASSWORD_MANAGER_UI_RUN_CHECKUP_ARIA_DESCRIPTION 9548
#define IDS_PASSWORD_MANAGER_UI_REMOVE_BLOCKED_SITE_ARIA_DESCRIPTION 9549
#define IDS_PASSWORD_MANAGER_UI_EMPTY_STATE_ACCOUNT_STORE_USERS 9550
#define IDS_PASSWORD_MANAGER_UI_EMPTY_STATE_SYNCING_USERS 9551
#define IDS_PASSWORD_MANAGER_UI_EMPTY_STATE_SIGNEDOUT_USERS 9552
#define IDS_PASSWORD_MANAGER_UI_CHECKUP_PROMO_CARD_TITLE 9553
#define IDS_PASSWORD_MANAGER_UI_CHECKUP_PROMO_CARD_DESCRIPTION 9554
#define IDS_PASSWORD_MANAGER_UI_CHECKUP_PROMO_CARD_ACTION 9555
#define IDS_PASSWORD_MANAGER_UI_WEB_PROMO_CARD_TITLE 9556
#define IDS_PASSWORD_MANAGER_UI_WEB_PROMO_CARD_DESCRIPTION 9557
#define IDS_PASSWORD_MANAGER_UI_SHORTCUT_PROMO_CARD_TITLE 9558
#define IDS_PASSWORD_MANAGER_UI_SHORTCUT_PROMO_CARD_DESCRIPTION 9559
#define IDS_PASSWORD_MANAGER_UI_ANY_DEVICE_PROMO_CARD_TITLE 9560
#define IDS_PASSWORD_MANAGER_UI_ANY_DEVICE_PROMO_CARD_DESCRIPTION 9561
#define IDS_PASSWORD_MANAGER_UI_ACCOUNT_STORAGE_TOGGLE_LABEL 9562
#define IDS_PASSWORD_MANAGER_UI_ACCOUNT_STORAGE_TOGGLE_SUB_LABEL 9563
#define IDS_PASSWORD_MANAGER_UI_ACCOUNT_STORAGE_WITH_PASSKEYS_TOGGLE_LABEL 9564
#define IDS_PASSWORD_MANAGER_UI_DELETE_DIALOG_TITLE 9565
#define IDS_PASSWORD_MANAGER_UI_DELETE_DIALOG_BODY 9566
#define IDS_PASSWORD_MANAGER_UI_DELETE_DIALOG_FROM_ACCOUNT_CHECKBOX_LABEL 9567
#define IDS_PASSWORD_MANAGER_UI_DELETE_DIALOG_FROM_DEVICE_CHECKBOX_LABEL 9568
#define IDS_PASSWORD_MANAGER_UI_APPS_LABEL 9569
#define IDS_PASSWORD_MANAGER_UI_SITES_AND_APPS_LABEL 9570
#define IDS_PASSWORD_MANAGER_UI_BACK_TO_CHECKUP_ARIA_DESCRIPTION 9571
#define IDS_PASSWORD_MANAGER_UI_BACK_TO_PASSWORDS_ARIA_DESCRIPTION 9572
#define IDS_PASSWORD_MANAGER_UI_MOVE_PASSWORDS_TITLE 9573
#define IDS_PASSWORD_MANAGER_UI_MOVE_PASSWORDS_DESCRIPTION 9574
#define IDS_PASSWORD_MANAGER_UI_MOVE_PASSWORDS_BUTTON 9575
#define IDS_PASSWORD_MANAGER_UI_NO_PASSWORDS_FOUND 9578
#define IDS_PASSWORD_MANAGER_UI_EDIT_PASSKEY 9579
#define IDS_PASSWORD_MANAGER_UI_DISPLAY_NAME_LABEL 9580
#define IDS_PASSWORD_MANAGER_UI_DISPLAY_NAME_PLACEHOLDER 9581
#define IDS_PASSWORD_MANAGER_UI_USERNAME_PLACEHOLDER 9582
#define IDS_PASSWORD_MANAGER_UI_DELETE_PASSKEY_CONFIRMATION_TITLE 9583
#define IDS_PASSWORD_MANAGER_UI_DELETE_PASSKEY_CONFIRMATION_DESCRIPTION 9584
#define IDS_PASSWORD_MANAGER_UI_PASSKEY_MANAGEMENT_INFO_LABEL 9585
#define IDS_PASSKEYS_MANAGER_UI_UNENROLL_TITLE 9586
#define IDS_PASSKEYS_MANAGER_UI_UNENROLL_DESCRIPTION 9587
#define IDS_PASSKEYS_MANAGER_UI_UNENROLL_BUTTON 9588
#define IDS_PASSKEYS_MANAGER_UI_UNENROLL_TOAST_MESSAGE 9589
#define IDS_PASSWORD_MANAGER_UI_COPY_DISPLAY_NAME_LABEL 9590
#define IDS_PASSWORD_MANAGER_UI_DISPLAY_NAME_COPIED_TO_CLIPBOARD 9591
#define IDS_PASSWORD_MANAGER_UI_PASSKEY_DELETED 9592
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_LIST_ARIA_LABEL 9593
#define IDS_PASSWORD_MANAGER_UI_DEVICE_ONLY_PASSWORDS_ICON_TOOLTIP 9594
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_DETAILS_CARD_ARIA_LABEL 9595
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_DETAILS_CARD_EDIT_BUTTON_ARIA_LABEL 9596
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_DETAILS_CARD_EDIT_BUTTON_NO_USERNAME_ARIA_LABEL 9597
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_DETAILS_CARD_DELETE_BUTTON_ARIA_LABEL 9598
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_DETAILS_CARD_DELETE_BUTTON_NO_USERNAME_ARIA_LABEL 9599
#define IDS_PASSWORD_MANAGER_UI_PASSKEY_DETAILS_CARD_NO_USERNAME_ARIA_LABEL 9600
#define IDS_PASSWORD_MANAGER_UI_PASSKEY_DETAILS_CARD_ARIA_LABEL 9601
#define IDS_PASSWORD_MANAGER_UI_PASSKEY_DETAILS_CARD_EDIT_BUTTON_ARIA_LABEL 9602
#define IDS_PASSWORD_MANAGER_UI_PASSKEY_DETAILS_CARD_EDIT_BUTTON_NO_USERNAME_ARIA_LABEL 9603
#define IDS_PASSWORD_MANAGER_UI_PASSKEY_DETAILS_CARD_DELETE_BUTTON_ARIA_LABEL 9604
#define IDS_PASSWORD_MANAGER_UI_PASSKEY_DETAILS_CARD_DELETE_BUTTON_NO_USERNAME_ARIA_LABEL 9605
#define IDS_PASSWORD_MANAGER_UI_FEDERATED_CREDENTIAL_ARIA_LABEL 9606
#define IDS_PASSWORD_MANAGER_UI_MOVE_SINGLE_PASSWORD_TO_ACCOUNT 9607
#define IDS_PASSWORD_MANAGER_UI_MOVE_SINGLE_PASSWORD_TITLE 9608
#define IDS_PASSWORD_MANAGER_UI_MOVE_SINGLE_PASSWORD_DESCRIPTION 9609
#define IDS_PASSWORD_MANAGER_UI_MOVE_SINGLE_PASSWORD_ACTION_BUTTON 9610
#define IDS_PASSWORD_MANAGER_UI_MOVE_PASSWORDS_IN_SETTINGS_SUB_LABEL 9611
#define IDS_PASSWORD_MANAGER_UI_RELAUNCH_CHROME_PROMO_CARD_TITLE_LINUX 9614
#define IDS_PASSWORD_MANAGER_UI_RELAUNCH_CHROME_PROMO_CARD_DESCRIPTION_LINUX 9615
#define IDS_PASSWORD_MANAGER_UI_RELAUNCH_CHROME_PROMO_CARD_ACTION 9616
#define IDS_PASSWORD_MANAGER_UI_NO_USERNAME 9617
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_MOVED_TOAST_MESSAGE 9618
#define IDS_PASSWORD_MANAGER_UI_MOVE_PASSWORDS_PROMO_CARD_TITLE 9619
#define IDS_PASSWORD_MANAGER_UI_MOVE_PASSWORDS_PROMO_CARD_DESCRIPTION 9620
#define IDS_PASSWORD_MANAGER_UI_MOVE_PASSWORDS_PROMO_CARD_ACTION_BUTTON 9621
#define IDS_PASSWORD_MANAGER_SAVE_IN_ACCOUNT_BUBBLE_DESCRIPTION 9622
#define IDS_PASSWORD_MANAGER_SAVE_IN_ACCOUNT_BUBBLE_TITLE 9623
#define IDS_PASSWORD_MANAGER_SAVE_IN_ACCOUNT_BUBBLE_SAVE_BUTTON 9624
#define IDS_PASSWORD_MANAGER_DEFAULT_STORE_CHANGED_BUBBLE_TITLE 9625
#define IDS_PASSWORD_MANAGER_DEFAULT_STORE_CHANGED_BUBBLE_DESCRIPTION 9626
#define IDS_PASSWORD_MANAGER_DEFAULT_STORE_CHANGED_BUBBLE_SETTINGS_BUTTON 9627
#define IDS_PASSWORD_MANAGER_DEFAULT_STORE_CHANGED_BUBBLE_CONTINUE_BUTTON 9628
#define IDS_PASSWORD_MANAGER_MANAGEMENT_BUBBLE_LIST_ITEM_DEVICE_ONLY_ACCESSIBLE_TEXT 9629
#define IDS_PASSWORD_MANAGER_MANAGEMENT_BUBBLE_LIST_ITEM_ACCESSIBLE_TEXT 9630
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_LIST_ITEM_ARIA_LABEL 9631
#define IDS_PASSWORD_MANAGER_UI_PROMO_CARD_ARIA_LABEL 9632
#define IDS_PASSWORD_MANAGER_UI_CLOSE_PROMO_CARD_BUTTON_ARIA_LABEL 9633
#define IDS_PASSWORD_MANAGER_PIN_CHANGED 9634
#define IDS_PASSWORD_MANAGER_UI_CONFIRM 9635
#define IDS_PASSWORD_MANAGER_UI_DISCONNECT_CLOUD_AUTHENTICATOR_DIALOG_TITLE 9636
#define IDS_PASSWORD_MANAGER_UI_DISCONNECT_CLOUD_AUTHENTICATOR_DIALOG_DESCRIPTION 9637
#define IDS_UTILITY_PROCESS_PRINTING_SERVICE_NAME 9638
#define IDS_UTILITY_PROCESS_PRINT_BACKEND_SERVICE_NAME 9639
#define IDS_PRINT_INVALID_PRINTER_SETTINGS 9640
#define IDS_PRINT_PREVIEW_TITLE 9641
#define IDS_PRINT_PREVIEW_DESCRIPTION 9642
#define IDS_PRINT_PREVIEW_LOADING 9643
#define IDS_PRINT_PREVIEW_FAILED 9644
#define IDS_PRINT_PREVIEW_INVALID_PRINTER_SETTINGS 9645
#define IDS_PRINT_PREVIEW_PRINT_BUTTON 9646
#define IDS_PRINT_PREVIEW_SAVE_BUTTON 9647
#define IDS_PRINT_PREVIEW_PRINTING 9648
#define IDS_PRINT_PREVIEW_SAVING 9649
#define IDS_PRINT_PREVIEW_OPTION_ALL_PAGES 9650
#define IDS_PRINT_PREVIEW_OPTION_ODD_PAGES 9651
#define IDS_PRINT_PREVIEW_OPTION_EVEN_PAGES 9652
#define IDS_PRINT_PREVIEW_OPTION_CUSTOM_PAGES 9653
#define IDS_PRINT_PREVIEW_DESTINATION_LABEL 9654
#define IDS_PRINT_PREVIEW_OPTION_BW 9655
#define IDS_PRINT_PREVIEW_OPTION_COLLATE 9656
#define IDS_PRINT_PREVIEW_OPTION_COLOR 9657
#define IDS_PRINT_PREVIEW_OPTION_LANDSCAPE 9658
#define IDS_PRINT_PREVIEW_OPTION_PORTRAIT 9659
#define IDS_PRINT_PREVIEW_OPTION_TWO_SIDED 9660
#define IDS_PRINT_PREVIEW_PRINT_ON_BOTH_SIDES_LABEL 9661
#define IDS_PRINT_PREVIEW_OPTION_LONG_EDGE 9662
#define IDS_PRINT_PREVIEW_OPTION_SHORT_EDGE 9663
#define IDS_PRINT_PREVIEW_BORDERLESS_LABEL 9664
#define IDS_PRINT_PREVIEW_PAGES_LABEL 9665
#define IDS_PRINT_PREVIEW_LAYOUT_LABEL 9666
#define IDS_PRINT_PREVIEW_COPIES_LABEL 9667
#define IDS_PRINT_PREVIEW_SCALING_LABEL 9668
#define IDS_PRINT_PREVIEW_OPTION_DEFAULT_SCALING 9669
#define IDS_PRINT_PREVIEW_OPTION_CUSTOM_SCALING 9670
#define IDS_PRINT_PREVIEW_PAGES_PER_SHEET_LABEL 9671
#define IDS_PRINT_PREVIEW_EXAMPLE_PAGE_RANGE_TEXT 9672
#define IDS_PRINT_PREVIEW_PRINT_TO_PDF 9673
#define IDS_PRINT_PREVIEW_SHEET_SUMMARY_LABEL 9674
#define IDS_PRINT_PREVIEW_PAGE_SUMMARY_LABEL 9675
#define IDS_PRINT_PREVIEW_PAGE_RANGE_SYNTAX_INSTRUCTION 9676
#define IDS_PRINT_PREVIEW_PAGE_RANGE_LIMIT_INSTRUCTION_WITH_VALUE 9677
#define IDS_PRINT_PREVIEW_COPIES_INSTRUCTION 9678
#define IDS_PRINT_PREVIEW_SCALING_INSTRUCTION 9679
#define IDS_PRINT_PREVIEW_PRINT_PAGES_LABEL 9680
#define IDS_PRINT_PREVIEW_OPTIONS_LABEL 9681
#define IDS_PRINT_PREVIEW_OPTION_HEADER_FOOTER 9682
#define IDS_PRINT_PREVIEW_OPTION_FIT_TO_PAGE 9683
#define IDS_PRINT_PREVIEW_OPTION_FIT_TO_PAPER 9684
#define IDS_PRINT_PREVIEW_OPTION_BACKGROUND_COLORS_AND_IMAGES 9685
#define IDS_PRINT_PREVIEW_OPTION_SELECTION_ONLY 9686
#define IDS_PRINT_PREVIEW_OPTION_RASTERIZE 9687
#define IDS_PRINT_PREVIEW_MARGINS_LABEL 9688
#define IDS_PRINT_PREVIEW_DEFAULT_MARGINS 9689
#define IDS_PRINT_PREVIEW_NO_MARGINS 9690
#define IDS_PRINT_PREVIEW_CUSTOM_MARGINS 9691
#define IDS_PRINT_PREVIEW_MINIMUM_MARGINS 9692
#define IDS_PRINT_PREVIEW_TOP_MARGIN_LABEL 9693
#define IDS_PRINT_PREVIEW_BOTTOM_MARGIN_LABEL 9694
#define IDS_PRINT_PREVIEW_LEFT_MARGIN_LABEL 9695
#define IDS_PRINT_PREVIEW_RIGHT_MARGIN_LABEL 9696
#define IDS_PRINT_PREVIEW_MEDIA_SIZE_LABEL 9697
#define IDS_PRINT_PREVIEW_MEDIA_TYPE_LABEL 9698
#define IDS_PRINT_PREVIEW_DPI_LABEL 9699
#define IDS_PRINT_PREVIEW_NON_ISOTROPIC_DPI_ITEM_LABEL 9700
#define IDS_PRINT_PREVIEW_DPI_ITEM_LABEL 9701
#define IDS_PRINT_PREVIEW_DESTINATION_SEARCH_TITLE 9702
#define IDS_PRINT_PREVIEW_SEARCH_BOX_PLACEHOLDER 9703
#define IDS_PRINT_PREVIEW_NO_DESTINATIONS_MESSAGE 9704
#define IDS_PRINT_PREVIEW_PRINT_DESTINATIONS_TITLE 9705
#define IDS_PRINT_PREVIEW_MANAGE 9706
#define IDS_PRINT_PREVIEW_SEE_MORE 9707
#define IDS_PRINT_PREVIEW_SEE_MORE_DESTINATIONS_LABEL 9708
#define IDS_PRINT_PREVIEW_EXTENSION_DESTINATION_ICON_TOOLTIP 9709
#define IDS_MORE_OPTIONS_LABEL 9710
#define IDS_PRINT_PREVIEW_COULD_NOT_PRINT 9711
#define IDS_PRINT_PREVIEW_ADVANCED_SETTINGS_SEARCH_BOX_PLACEHOLDER 9712
#define IDS_PRINT_PREVIEW_ADVANCED_SETTINGS_DIALOG_TITLE 9713
#define IDS_PRINT_PREVIEW_NO_ADVANCED_SETTINGS_MATCH_SEARCH_HINT 9714
#define IDS_PRINT_PREVIEW_ADVANCED_SETTINGS_DIALOG_CONFIRM 9715
#define IDS_PRINT_PREVIEW_NEW_SHOW_ADVANCED_OPTIONS 9716
#define IDS_PRINT_PREVIEW_BUTTON_SELECT 9717
#define IDS_PRINT_PREVIEW_BUTTON_GO_BACK 9718
#define IDS_PRINT_PREVIEW_RESOLVE_EXTENSION_USB_DIALOG_TITLE 9719
#define IDS_PRINT_PREVIEW_RESOLVE_EXTENSION_USB_PERMISSION_MESSAGE 9720
#define IDS_PRINT_PREVIEW_RESOLVE_EXTENSION_USB_ERROR_MESSAGE 9721
#define IDS_PRINT_PREVIEW_MANAGED_SETTINGS_TEXT 9722
#define IDS_PRINT_PREVIEW_SYSTEM_DIALOG_OPTION 9751
#define IDS_DEFAULT_PRINT_DOCUMENT_TITLE 9754
#define IDS_PRINT_SPOOL_FAILED_TITLE_TEXT 9755
#define IDS_PRINT_SPOOL_FAILED_ERROR_TEXT 9756
#define IDS_VR_SHELL_SITE_IS_TRACKING_LOCATION 9757
#define IDS_VR_SHELL_SITE_IS_USING_MICROPHONE 9758
#define IDS_VR_SHELL_SITE_IS_USING_CAMERA 9759
#define IDS_VR_SHELL_SITE_IS_SHARING_SCREEN 9760
#define IDS_VR_SHELL_BG_IS_USING_MICROPHONE 9761
#define IDS_VR_SHELL_BG_IS_USING_CAMERA 9762
#define IDS_VR_SHELL_BG_IS_SHARING_SCREEN 9763
#define IDS_VR_SHELL_SITE_CAN_TRACK_LOCATION 9764
#define IDS_VR_SHELL_SITE_CAN_USE_MICROPHONE 9765
#define IDS_VR_SHELL_SITE_CAN_USE_CAMERA 9766
#define IDS_VR_SHELL_SITE_CAN_SHARE_SCREEN 9767
#define IDS_VR_SHELL_SITE_IS_USING_BLUETOOTH 9768
#define IDS_VR_SHELL_SITE_CAN_USE_BLUETOOTH 9770
#define IDS_DESKTOP_PROMPT_DOFF_HEADSET 9771
#define IDS_VR_DESKTOP_GENERIC_PERMISSION_PROMPT 9772
#define IDS_VR_SHELL_SITE_IS_USING_USB 9773
#define IDS_VR_SHELL_SITE_IS_USING_MIDI 9774
#define IDS_VR_SHELL_SITE_CAN_USE_MIDI 9775
#define IDS_VR_WEB_VR_TIMEOUT_MESSAGE 9776
#define IDS_WILDCARD 9777
#define IDS_BACKGROUND_CRASHED_APP_BALLOON_MESSAGE 9780
#define IDS_BACKGROUND_CRASHED_EXTENSION_BALLOON_MESSAGE 9781
#define IDS_BACKGROUND_APP_NOT_INSTALLED 9782
#define IDS_PERMISSIONS_REQUESTED_SCREENREADER_ANNOUNCEMENT 9783
#define IDS_PERMISSIONS_EXPIRED_SCREENREADER_ANNOUNCEMENT 9784
#define IDS_PERMISSIONS_BUBBLE_PROMPT 9785
#define IDS_PERMISSIONS_BUBBLE_PROMPT_ACCESSIBLE_TITLE_ONE_PERM 9786
#define IDS_PERMISSIONS_BUBBLE_PROMPT_ACCESSIBLE_TITLE_TWO_PERMS 9787
#define IDS_PERMISSIONS_BUBBLE_PROMPT_ACCESSIBLE_TITLE_TWO_PERMS_MORE 9788
#define IDS_PERMISSIONS_BUBBLE_PROMPT_THIS_FILE 9789
#define IDS_PERMISSION_CUSTOMIZE 9790
#define IDS_ALTERNATE_NAV_URL_VIEW_LABEL 9791
#define IDS_DOWNLOAD_HISTORY_TITLE 9792
#define IDS_TAB_LOADING_TITLE 9793
#define IDS_HOVER_CARD_FILE_URL_SOURCE 9794
#define IDS_HOVER_CARD_BLOB_URL_SOURCE 9795
#define IDS_HOVER_CARD_CRASHED_TITLE 9796
#define IDS_HISTORY_SEARCH_PROMPT 9797
#define IDS_HISTORY_DELETE 9798
#define IDS_HISTORY_ITEMS_SELECTED 9799
#define IDS_HISTORY_ITEMS_UNSELECTED 9800
#define IDS_HISTORY_HISTORY_MENU_DESCRIPTION 9801
#define IDS_HISTORY_HISTORY_MENU_ITEM 9802
#define IDS_HISTORY_NO_SYNCED_RESULTS 9803
#define IDS_HISTORY_OPEN_TABS_MENU_ITEM 9804
#define IDS_HISTORY_TURN_ON_SYNC_BUTTON 9805
#define IDS_HISTORY_TURN_ON_SYNC_PROMO 9806
#define IDS_HISTORY_TURN_ON_SYNC_PROMO_DESC 9807
#define IDS_EDIT 9808
#define IDS_CLEAR_SEARCH 9809
#define IDS_CONFIRM 9810
#define IDS_DISABLE 9811
#define IDS_SEARCH_CLEARED 9812
#define IDS_SEARCH_RESULTS 9813
#define IDS_SEARCH_RESULTS_SINGULAR 9814
#define IDS_SEARCH_RESULTS_PLURAL 9815
#define IDS_SEARCH_RESULT_BUBBLE_TEXT 9816
#define IDS_SEARCH_RESULTS_BUBBLE_TEXT 9817
#define IDS_SEARCH_NO_RESULTS 9818
#define IDS_SHOW_BUBBLE_INACTIVE_DESCRIPTION 9819
#define IDS_FOCUS_HELP_BUBBLE_DESCRIPTION 9820
#define IDS_FOCUS_HELP_BUBBLE_TOGGLE_DESCRIPTION 9821
#define IDS_FOCUS_HELP_BUBBLE_TUTORIAL_DESCRIPTION 9822
#define IDS_CONTENT_CONTEXT_INSPECTELEMENT 9823
#define IDS_CONTENT_CONTEXT_ACCESSIBILITY_LABELS_DIALOG_TITLE 9824
#define IDS_CONTENT_CONTEXT_ACCESSIBILITY_LABELS_BUBBLE_ENABLE 9825
#define IDS_CONTENT_CONTEXT_ACCESSIBILITY_LABELS_BUBBLE_DISABLE 9826
#define IDS_CONTENT_CONTEXT_LIVE_CAPTION_ENABLE 9827
#define IDS_CONTENT_CONTEXT_LIVE_CAPTION_DISABLE 9828
#define IDS_CONTENT_CONTEXT_AUTOFILL_FALLBACK_PASSWORDS 9829
#define IDS_CONTENT_CONTEXT_BACK 9830
#define IDS_CONTENT_CONTEXT_FORWARD 9831
#define IDS_CONTENT_CONTEXT_SAVEPAGEAS 9832
#define IDS_CONTENT_CONTEXT_PRINT 9833
#define IDS_CONTENT_CONTEXT_VIEWPAGESOURCE 9834
#define IDS_CONTENT_CONTEXT_OPENLINKWITH 9835
#define IDS_CONTENT_CONTEXT_OPENLINKWITH_CONFIGURE 9836
#define IDS_CONTENT_CONTEXT_INSPECTBACKGROUNDPAGE 9837
#define IDS_CONTENT_CONTEXT_READING_MODE 9838
#define IDS_CONTENT_CONTEXT_RELOAD 9839
#define IDS_CONTENT_CONTEXT_RESTART_APP 9840
#define IDS_CONTENT_CONTEXT_RELOAD_PACKAGED_APP 9841
#define IDS_CONTENT_CONTEXT_TRANSLATE 9842
#define IDS_CONTENT_CONTEXT_EXIT_FULLSCREEN 9843
#define IDS_CONTENT_CONTEXT_RELOADFRAME 9844
#define IDS_CONTENT_CONTEXT_VIEWFRAMESOURCE 9845
#define IDS_CONTENT_CONTEXT_OPENLINKNEWTAB 9846
#define IDS_CONTENT_CONTEXT_OPENLINKNEWWINDOW 9847
#define IDS_CONTENT_CONTEXT_OPENLINKOFFTHERECORD 9848
#define IDS_CONTENT_CONTEXT_OPENLINKINPROFILES 9849
#define IDS_CONTENT_CONTEXT_OPENLINKINPROFILE 9850
#define IDS_CONTENT_CONTEXT_OPENLINKBOOKMARKAPP 9851
#define IDS_CONTENT_CONTEXT_OPENLINKBOOKMARKAPP_SAMEAPP 9852
#define IDS_CONTENT_CONTEXT_OPENLINKWEBAPP_NEWTAB 9853
#define IDS_CONTENT_CONTEXT_OPENLINKPREVIEW 9854
#define IDS_CONTENT_CONTEXT_OPENLINKPREVIEW_TRIGGER_ALTCLICK 9855
#define IDS_CONTENT_CONTEXT_OPENLINKPREVIEW_TRIGGER_ALTHOVER 9856
#define IDS_CONTENT_CONTEXT_OPENLINKPREVIEW_TRIGGER_LONGPRESS 9857
#define IDS_CONTENT_CONTEXT_SAVELINKAS 9858
#define IDS_CONTENT_CONTEXT_COPYLINKLOCATION 9859
#define IDS_CONTENT_CONTEXT_COPYEMAILADDRESS 9860
#define IDS_CONTENT_CONTEXT_COPYLINKTEXT 9861
#define IDS_CONTENT_CONTEXT_COPYLINKTOTEXT 9862
#define IDS_CONTENT_CONTEXT_ADD_A_NOTE 9863
#define IDS_CONTENT_CONTEXT_REMOVELINKTOTEXT 9864
#define IDS_CONTENT_CONTEXT_RESHARELINKTOTEXT 9865
#define IDS_CONTENT_CONTEXT_SAVEIMAGEAS 9866
#define IDS_CONTENT_CONTEXT_COPYIMAGELOCATION 9867
#define IDS_CONTENT_CONTEXT_COPYIMAGE 9868
#define IDS_CONTENT_CONTEXT_OPENIMAGENEWTAB 9869
#define IDS_CONTENT_CONTEXT_OPEN_ORIGINAL_IMAGE_NEW_TAB 9870
#define IDS_CONTENT_CONTEXT_LOAD_IMAGE 9871
#define IDS_CONTENT_CONTEXT_LOOP 9872
#define IDS_CONTENT_CONTEXT_CONTROLS 9873
#define IDS_CONTENT_CONTEXT_ROTATECW 9874
#define IDS_CONTENT_CONTEXT_ROTATECCW 9875
#define IDS_CONTENT_CONTEXT_SAVEVIDEOFRAMEAS 9876
#define IDS_CONTENT_CONTEXT_SAVEVIDEOAS 9877
#define IDS_CONTENT_CONTEXT_COPYVIDEOLOCATION 9878
#define IDS_CONTENT_CONTEXT_COPYVIDEOFRAME 9879
#define IDS_CONTENT_CONTEXT_SEARCHFORVIDEOFRAME 9880
#define IDS_CONTENT_CONTEXT_OPENVIDEONEWTAB 9881
#define IDS_CONTENT_CONTEXT_SAVEAUDIOAS 9882
#define IDS_CONTENT_CONTEXT_COPYAUDIOLOCATION 9883
#define IDS_CONTENT_CONTEXT_OPENAUDIONEWTAB 9884
#define IDS_CONTENT_CONTEXT_PICTUREINPICTURE 9885
#define IDS_CONTENT_CONTEXT_UNDO 9886
#define IDS_CONTENT_CONTEXT_REDO 9887
#define IDS_CONTENT_CONTEXT_CUT 9888
#define IDS_CONTENT_CONTEXT_COPY 9889
#define IDS_CONTENT_CONTEXT_PASTE 9890
#define IDS_CONTENT_CONTEXT_PASTE_AND_MATCH_STYLE 9891
#define IDS_CONTENT_CONTEXT_ADD_TO_DICTIONARY 9892
#define IDS_CONTENT_CONTEXT_ACCESSIBILITY_LABELS_MENU_OPTION 9893
#define IDS_CONTENT_CONTEXT_ACCESSIBILITY_LABELS_SEND 9894
#define IDS_CONTENT_CONTEXT_ACCESSIBILITY_LABELS_SEND_ONCE 9895
#define IDS_CONTENT_CONTEXT_RUN_LAYOUT_EXTRACTION 9896
#define IDS_CONTENT_CONTEXT_SPELLING_ASK_GOOGLE 9897
#define IDS_CONTENT_CONTEXT_SPELLING_BUBBLE_TITLE 9898
#define IDS_CONTENT_CONTEXT_SPELLING_BUBBLE_ENABLE 9899
#define IDS_CONTENT_CONTEXT_SPELLING_BUBBLE_DISABLE 9900
#define IDS_CONTENT_CONTEXT_SPELLING_CHECKING 9901
#define IDS_CONTENT_CONTEXT_SPELLING_NO_SUGGESTIONS_FROM_GOOGLE 9902
#define IDS_CONTENT_CONTEXT_SELECTALL 9903
#define IDS_CONTENT_CONTEXT_PARTIAL_TRANSLATE 9904
#define IDS_CONTENT_CONTEXT_SEARCHWEBFOR 9905
#define IDS_CONTENT_CONTEXT_SEARCHWEBFORNEWTAB 9906
#define IDS_CONTENT_CONTEXT_SEARCHWEBFORIMAGE 9907
#define IDS_CONTENT_CONTEXT_SEARCHLENSFORIMAGE 9908
#define IDS_CONTENT_CONTEXT_TRANSLATEIMAGE 9909
#define IDS_CONTENT_CONTEXT_LENS_OVERLAY 9910
#define IDS_CONTENT_LENS_OVERLAY_ENTRYPOINT_LABEL 9911
#define IDS_CONTENT_CONTEXT_LENS_REGION_SEARCH_ALT1 9912
#define IDS_CONTENT_CONTEXT_LENS_REGION_SEARCH 9913
#define IDS_CONTENT_CONTEXT_GOTOURL 9914
#define IDS_CONTENT_CONTEXT_GENERATEPASSWORD 9915
#define IDS_CONTENT_CONTEXT_MORE_APPS 9916
#define IDS_CONTENT_CONTEXT_OPEN_WITH_APP 9917
#define IDS_CONTENT_CONTEXT_AUTOFILL_FEEDBACK 9918
#define IDS_CONTENT_CONTEXT_AUTOFILL_FALLBACK_TITLE 9919
#define IDS_CONTENT_CONTEXT_AUTOFILL_FALLBACK_ADDRESS 9920
#define IDS_CONTENT_CONTEXT_AUTOFILL_FALLBACK_PAYMENTS 9921
#define IDS_CONTENT_CONTEXT_AUTOFILL_FALLBACK_PASSWORDS_SELECT_PASSWORD 9922
#define IDS_CONTENT_CONTEXT_AUTOFILL_FALLBACK_PASSWORDS_IMPORT_PASSWORDS 9923
#define IDS_CONTENT_CONTEXT_AUTOFILL_FALLBACK_PASSWORDS_SUGGEST_PASSWORD 9924
#define IDS_SHARE_MENU_TITLE 9926
#define IDS_CONTENT_CONTEXT_PLUGIN_RUN 9927
#define IDS_CONTENT_CONTEXT_PLUGIN_HIDE 9928
#define IDS_CONTENT_CONTEXT_ENABLE_FLASH 9929
#define IDS_CONTENT_CONTEXT_SPELLCHECK_MENU 9931
#define IDS_CONTENT_CONTEXT_LANGUAGE_SETTINGS 9930
#define IDS_CONTENT_CONTEXT_SPELLCHECK_MULTI_LINGUAL 9932
#define IDS_CONTENT_CONTEXT_CHECK_SPELLING_WHILE_TYPING 9933
#define IDS_ADDRESSES_AND_MORE_SUBMENU_OPTION 9934
#define IDS_PASSWORDS_AND_AUTOFILL_MENU 9935
#define IDS_RELAUNCH_TO_UPDATE_ALT 9936
#define IDS_RELAUNCH_TO_UPDATE_ALT_MINOR_TEXT 9937
#define IDS_NEW_TAB 9938
#define IDS_NEW_INCOGNITO_TAB 9939
#define IDS_SHOW_AS_TAB 9940
#define IDS_NEW_WINDOW 9941
#define IDS_NEW_INCOGNITO_WINDOW 9942
#define IDS_PROFILE_ROW_SIGNED_IN_MESSAGE_WITH_EMAIL 9943
#define IDS_PROFILE_ROW_SIGNED_IN_MESSAGE 9944
#define IDS_PROFILE_ROW_SYNC_IS_ON 9945
#define IDS_PROFILE_ROW_TURN_ON_SYNC 9946
#define IDS_PROFILE_ROW_SYNC_ERROR_MESSAGE 9947
#define IDS_PROFILE_ROW_SIGN_IN_AGAIN 9948
#define IDS_EDIT2 9949
#define IDS_CUT 9950
#define IDS_COPY 9951
#define IDS_PASTE 9952
#define IDS_DELETE 9953
#define IDS_FIND 9954
#define IDS_FIND_AND_EDIT_MENU 9955
#define IDS_PAYMENT_METHOD_SUBMENU_OPTION 9956
#define IDS_SAVE_AND_SHARE_MENU 9957
#define IDS_SAVE_SHARE_AND_CAST_MENU 9958
#define IDS_CAST_SAVE_AND_SHARE_MENU 9959
#define IDS_SAVE_AND_SHARE_MENU_CAST 9960
#define IDS_SAVE_AND_SHARE_MENU_SAVE 9961
#define IDS_SAVE_AND_SHARE_MENU_SHARE 9962
#define IDS_SAVE_PAGE 9963
#define IDS_MORE_TOOLS_MENU 9964
#define IDS_ZOOM_MENU 9965
#define IDS_ZOOM_MENU2 9966
#define IDS_ZOOM_PLUS 9967
#define IDS_ZOOM_PLUS2 9968
#define IDS_ZOOM_NORMAL 9969
#define IDS_ZOOM_MINUS 9970
#define IDS_ZOOM_MINUS2 9971
#define IDS_COPY_URL 9972
#define IDS_OPEN_IN_APP_WINDOW 9973
#define IDS_MOVE_TAB_TO_NEW_WINDOW 9974
#define IDS_SEARCH_TABS 9975
#define IDS_CUSTOMIZE_CHROME 9976
#define IDS_CLOSE_PROFILE 9977
#define IDS_MANAGE_GOOGLE_ACCOUNT 9978
#define IDS_OTHER_CHROME_PROFILES_TITLE 9979
#define IDS_OPEN_GUEST_PROFILE 9980
#define IDS_ADD_NEW_PROFILE 9981
#define IDS_MANAGE_CHROME_PROFILES 9982
#define IDS_ACCNAME_ZOOM_PLUS2 9984
#define IDS_ACCNAME_ZOOM_MINUS2 9985
#define IDS_VIEW_SOURCE 9986
#define IDS_FEEDBACK 9987
#define IDS_DEV_TOOLS 9988
#define IDS_DEV_TOOLS_ELEMENTS 9989
#define IDS_DEV_TOOLS_CONSOLE 9990
#define IDS_DEV_TOOLS_DEVICES 9991
#define IDS_TASK_MANAGER 9992
#define IDS_TAKE_SCREENSHOT 9993
#define IDS_RESTORE_ALL_TABS 9994
#define IDS_RESTORE_TAB 9995
#define IDS_REOPEN_WINDOW 9996
#define IDS_REOPEN_GROUP 9997
#define IDS_RESTORE_WINDOW 9998
#define IDS_RESTORE_GROUP 9999
#define IDS_NAME_WINDOW 10000
#define IDS_CHROMELABS 10001
#define IDS_PREFERENCES 10002
#define IDS_TOS_NOTIFICATION_TITLE 10004
#define IDS_TOS_NOTIFICATION_BODY_TEXT 10005
#define IDS_TOS_NOTIFICATION_ACK_BUTTON_TEXT 10006
#define IDS_TOS_NOTIFICATION_REVIEW_BUTTON_TEXT 10007
#define IDS_TOS_NOTIFICATION_LINK 10008
#define IDS_HELP_MENU 10009
#define IDS_MANAGED 10010
#define IDS_MANAGED_BY 10011
#define IDS_MANAGED_BY_PARENT 10012
#define IDS_PROFILE_MANAGED_BY 10013
#define IDS_BROWSER_PROFILE_MANAGED 10014
#define IDS_CHROME_TIPS 10015
#define IDS_CHROME_WHATS_NEW 10016
#define IDS_IMPORT_SETTINGS_MENU_LABEL 10017
#define IDS_PROFILING_ENABLED 10018
#define IDS_FULLSCREEN 10019
#define IDS_CLEAR_BROWSING_DATA 10020
#define IDS_SHOW_DOWNLOADS 10021
#define IDS_SHOW_EXTENSIONS 10022
#define IDS_EXTENSIONS_SUBMENU 10023
#define IDS_EXTENSIONS_SUBMENU_MANAGE_EXTENSIONS_ITEM 10024
#define IDS_EXTENSIONS_SUBMENU_CHROME_WEBSTORE_ITEM 10025
#define IDS_SHOW_PERFORMANCE 10026
#define IDS_SHOW_LENS_OVERLAY 10027
#define IDS_SHOW_SEARCH_COMPANION 10028
#define IDS_SHOW_TRANSLATE 10029
#define IDS_SETTINGS 10030
#define IDS_OPTIONS 10031
#define IDS_HELP_PAGE 10032
#define IDS_BETA_FORUM 10033
#define IDS_GET_HELP 10034
#define IDS_EXIT 10035
#define IDS_AUTOCOMPLETE_MATCH_DESCRIPTION_SEPARATOR 10036
#define IDS_MANAGE_SEARCH_ENGINES 10037
#define IDS_MANAGE_SEARCH_ENGINES_AND_SITE_SEARCH 10038
#define IDS_SEARCH_ENGINES_EDITOR_KEYWORD_COLUMN 10039
#define IDS_SEARCH_ENGINES_EDITOR_DESCRIPTION_COLUMN 10040
#define IDS_SEARCH_ENGINES_EDITOR_DEFAULT_ENGINE 10041
#define IDS_ACCNAME_DOWNLOADS_BAR 10042
#define IDS_HIDE_DOWNLOADS 10043
#define IDS_SHOW_ALL_DOWNLOADS 10044
#define IDS_DOWNLOAD_STARTED 10045
#define IDS_DOWNLOAD_INTERRUPTED_STATUS 10046
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_ACCESS_DENIED 10047
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_ACCESS_DENIED 10048
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_PATH_TOO_LONG 10049
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_PATH_TOO_LONG 10050
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_DISK_FULL 10051
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_DISK_FULL 10052
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_FILE_TOO_LARGE 10053
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_FILE_TOO_LARGE 10054
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_TEMPORARY_PROBLEM 10055
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_TEMPORARY_PROBLEM 10056
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_VIRUS 10057
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_VIRUS 10058
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_BLOCKED 10059
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_BLOCKED 10060
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_CONTENT_LENGTH_MISMATCH 10061
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_CONTENT_LENGTH_MISMATCH 10062
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_SECURITY_CHECK_FAILED 10063
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_SECURITY_CHECK_FAILED 10064
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_FILE_TOO_SHORT 10065
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_FILE_TOO_SHORT 10066
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_FILE_SAME_AS_SOURCE 10067
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_FILE_SAME_AS_SOURCE 10068
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_NETWORK_TIMEOUT 10069
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_NETWORK_TIMEOUT 10070
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_NETWORK_DISCONNECTED 10071
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_NETWORK_DISCONNECTED 10072
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_SERVER_DOWN 10073
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_SERVER_DOWN 10074
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_NETWORK_ERROR 10075
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_NETWORK_ERROR 10076
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_NO_FILE 10077
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_NO_FILE 10078
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_SERVER_PROBLEM 10079
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_SERVER_PROBLEM 10080
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_WEB_DRIVE_ERROR 10081
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_SHUTDOWN 10082
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_SHUTDOWN 10083
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_CRASH 10084
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_CRASH 10085
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_UNAUTHORIZED 10086
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_UNAUTHORIZED 10087
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_SERVER_CERT_PROBLEM 10088
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_SERVER_CERT_PROBLEM 10089
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_FORBIDDEN 10090
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_FORBIDDEN 10091
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_UNREACHABLE 10092
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_UNREACHABLE 10093
#define IDS_DOWNLOAD_NOTIFICATION_LABEL_OPEN_WHEN_COMPLETE 10094
#define IDS_DOWNLOAD_NOTIFICATION_LABEL_OPEN 10095
#define IDS_DOWNLOAD_STATUS_STARTING 10096
#define IDS_DOWNLOAD_STATUS_IN_PROGRESS 10107
#define IDS_DOWNLOAD_STATUS_SIZES 10108
#define IDS_DOWNLOAD_STATUS_OPEN_IN 10109
#define IDS_DOWNLOAD_STATUS_OPEN_WHEN_COMPLETE 10110
#define IDS_DOWNLOAD_STATUS_OPENING 10111
#define IDS_DOWNLOAD_STATUS_IN_PROGRESS_SHORT 10112
#define IDS_DOWNLOAD_STATUS_CANCELLED 10113
#define IDS_DOWNLOAD_STATUS_REMOVED 10114
#define IDS_DOWNLOAD_STATUS_UPLOADING 10115
#define IDS_DOWNLOAD_STATUS_UPLOADED 10116
#define IDS_DOWNLOAD_STATUS_UPLOAD_INTERRUPTED 10117
#define IDS_DOWNLOAD_STATUS_INTERRUPTED 10118
#define IDS_DOWNLOAD_UNCONFIRMED_PREFIX 10119
#define IDS_PROMPT_DANGEROUS_DOWNLOAD 10120
#define IDS_PROMPT_DANGEROUS_DOWNLOAD_EXTENSION 10121
#define IDS_PROMPT_UNCOMMON_DOWNLOAD_CONTENT 10122
#define IDS_PROMPT_UNCOMMON_DOWNLOAD_CONTENT_IN_ADVANCED_PROTECTION 10123
#define IDS_PROMPT_DEEP_SCANNING_DOWNLOAD 10124
#define IDS_PROMPT_DEEP_SCANNING_DOWNLOAD_SHORT 10125
#define IDS_PROMPT_DEEP_SCANNING_APP_DOWNLOAD 10126
#define IDS_PROMPT_CONFIRM_INSECURE_DOWNLOAD 10127
#define IDS_PROMPT_DOWNLOAD_BLOCKED_TOO_LARGE 10128
#define IDS_PROMPT_DOWNLOAD_BLOCKED_PASSWORD_PROTECTED 10129
#define IDS_PROMPT_DOWNLOAD_DEEP_SCANNED_SAFE 10130
#define IDS_PROMPT_DOWNLOAD_SENSITIVE_CONTENT_WARNING 10131
#define IDS_PROMPT_DOWNLOAD_SENSITIVE_CONTENT_BLOCKED 10132
#define IDS_PROMPT_DOWNLOAD_BLOCKED_SCAN_FAILED 10133
#define IDS_PROMPT_DOWNLOAD_DEEP_SCANNED_OPENED_DANGEROUS 10134
#define IDS_PROMPT_DOWNLOAD_INSECURE_WARNING 10135
#define IDS_PROMPT_DOWNLOAD_INSECURE_BLOCKED 10136
#define IDS_PROMPT_APP_DEEP_SCANNING 10137
#define IDS_PROMPT_DEEP_SCANNING 10138
#define IDS_BLOCK_REASON_UNCOMMON_DOWNLOAD 10139
#define IDS_BLOCK_REASON_UNCOMMON_DOWNLOAD_IN_ADVANCED_PROTECTION 10140
#define IDS_BLOCK_REASON_GENERIC_DOWNLOAD 10141
#define IDS_BLOCK_REASON_INSECURE_DOWNLOAD 10142
#define IDS_BLOCK_REASON_DEEP_SCANNING_UPDATED 10143
#define IDS_BLOCK_REASON_DEEP_SCANNING_SECOND_UPDATED 10144
#define IDS_BLOCK_REASON_PROMPT_FOR_SCANNING_UPDATED 10145
#define IDS_BLOCK_REASON_PROMPT_FOR_LOCAL_PASSWORD_SCANNING 10146
#define IDS_DEEP_SCANNED_OPENED_DANGEROUS_DESCRIPTION 10147
#define IDS_BLOCK_REASON_SENSITIVE_CONTENT_WARNING 10148
#define IDS_SENSITIVE_CONTENT_BLOCKED_DESCRIPTION 10149
#define IDS_BLOCKED_TOO_LARGE_DESCRIPTION 10150
#define IDS_BLOCKED_PASSWORD_PROTECTED_DESCRIPTION 10151
#define IDS_DEEP_SCANNED_FAILED_DESCRIPTION 10152
#define IDS_DOWNLOADS_TOAST_DELETED_FROM_HISTORY_STILL_ON_DEVICE 10153
#define IDS_DOWNLOADS_TOAST_DELETED_FROM_HISTORY 10154
#define IDS_CONFIRM_KEEP_DANGEROUS_DOWNLOAD_TITLE 10158
#define IDS_KEEP_DANGEROUS_DOWNLOAD_TITLE 10159
#define IDS_KEEP_UNCOMMON_DOWNLOAD_TITLE 10160
#define IDS_PROMPT_CONFIRM_KEEP_DANGEROUS_DOWNLOAD 10161
#define IDS_PROMPT_CONFIRM_KEEP_MALICIOUS_DOWNLOAD_BODY 10162
#define IDS_CONFIRM_DOWNLOAD_AGAIN 10163
#define IDS_CONFIRM_DOWNLOAD 10164
#define IDS_CONFIRM_DOWNLOAD_RESTORE 10165
#define IDS_CONTINUE_EXTENSION_DOWNLOAD 10166
#define IDS_DISCARD_DOWNLOAD 10167
#define IDS_OPEN_DOWNLOAD_NOW 10168
#define IDS_SCAN_DOWNLOAD 10169
#define IDS_REVIEW_DOWNLOAD 10170
#define IDS_OPEN_DOWNLOAD_ANYWAY 10171
#define IDS_DOWNLOAD_LINK_PAUSE 10172
#define IDS_DOWNLOAD_HISTORY_SEARCH 10173
#define IDS_DOWNLOAD_NO_DOWNLOADS 10174
#define IDS_DOWNLOAD_ITEM_DROPDOWN_BUTTON_ACCESSIBLE_TEXT 10175
#define IDS_DOWNLOAD_LINK_RESUME 10176
#define IDS_DOWNLOAD_LINK_REMOVE 10177
#define IDS_DOWNLOAD_LINK_REMOVE_ARIA_LABEL 10178
#define IDS_DOWNLOAD_LINK_CANCEL 10179
#define IDS_DOWNLOAD_LINK_RETRY 10180
#define IDS_DOWNLOAD_LINK_SHOW_IN_WEB_DRIVE 10181
#define IDS_DOWNLOAD_LINK_SHOW 10182
#define IDS_DOWNLOAD_TAB_CANCELLED 10183
#define IDS_DOWNLOAD_FILE_REMOVED 10184
#define IDS_DOWNLOAD_TAB_PROGRESS_STATUS_TIME_UNKNOWN 10185
#define IDS_DOWNLOAD_TAB_PROGRESS_STATUS 10186
#define IDS_DOWNLOAD_TAB_PROGRESS_SIZE 10187
#define IDS_DOWNLOAD_PROGRESS_PAUSED 10188
#define IDS_DOWNLOAD_LINK_CLEAR_ALL 10189
#define IDS_DOWNLOAD_LINK_OPEN_DOWNLOADS_FOLDER 10190
#define IDS_DOWNLOAD_MORE_ACTIONS 10191
#define IDS_DOWNLOAD_ACTION_MENU_DESCRIPTION 10192
#define IDS_DOWNLOAD_BY_EXTENSION_URL 10193
#define IDS_DOWNLOADS_PAGE_REFERRER_LINE 10194
#define IDS_DOWNLOAD_IN_INCOGNITO 10195
#define IDS_UNDO_DESCRIPTION 10196
#define IDS_DOWNLOAD_UNDO 10197
#define IDS_DOWNLOAD_TOAST_REMOVED_FROM_LIST 10198
#define IDS_DOWNLOAD_TOAST_CLEARED_ALL 10199
#define IDS_DOWNLOAD_DEEP_SCAN 10200
#define IDS_DOWNLOAD_DEEP_SCAN_UPDATED 10201
#define IDS_DOWNLOAD_BYPASS_DEEP_SCAN 10202
#define IDS_DOWNLOAD_BYPASS_DEEP_SCAN_UPDATED 10203
#define IDS_DOWNLOAD_LOCAL_PASSWORD_SCAN 10204
#define IDS_DOWNLOAD_KEEP_DANGEROUS_FILE 10205
#define IDS_DOWNLOAD_KEEP_SUSPICIOUS_FILE 10206
#define IDS_DOWNLOAD_KEEP_UNVERIFIED_FILE 10207
#define IDS_DOWNLOAD_KEEP_INSECURE_FILE 10208
#define IDS_DOWNLOAD_DELETE_FROM_HISTORY 10209
#define IDS_DOWNLOAD_DANGEROUS_ICON_ACCESSIBLE_LABEL 10210
#define IDS_DOWNLOAD_SUSPICIOUS_ICON_ACCESSIBLE_LABEL 10211
#define IDS_DOWNLOAD_INSECURE_ICON_ACCESSIBLE_LABEL 10212
#define IDS_DOWNLOAD_UNVERIFIED_ICON_ACCESSIBLE_LABEL 10213
#define IDS_DOWNLOAD_SCREENREADER_SAVED_DANGEROUS 10214
#define IDS_DOWNLOAD_SCREENREADER_SAVED_SUSPICIOUS 10215
#define IDS_DOWNLOAD_SCREENREADER_SAVED_INSECURE 10216
#define IDS_DOWNLOAD_SCREENREADER_SAVED_UNVERIFIED 10217
#define IDS_DOWNLOAD_SCREENREADER_PAUSED 10218
#define IDS_DOWNLOAD_SCREENREADER_RESUMED 10219
#define IDS_DOWNLOAD_SCREENREADER_CANCELED 10220
#define IDS_DOWNLOAD_WARNING_BYPASS_DIALOG_TITLE 10221
#define IDS_DOWNLOAD_WARNING_BYPASS_DIALOG_DESCRIPTION 10222
#define IDS_DOWNLOAD_STATUS_IN_PROGRESS_ACCESSIBLE_ALERT 10223
#define IDS_DOWNLOAD_STATUS_PERCENT_COMPLETE_ACCESSIBLE_ALERT 10224
#define IDS_DOWNLOAD_STATUS_TIME_REMAINING_ACCESSIBLE_ALERT 10225
#define IDS_DOWNLOAD_FAILED_ACCESSIBLE_ALERT 10226
#define IDS_DOWNLOAD_CANCELLED_ACCESSIBLE_ALERT 10227
#define IDS_DOWNLOAD_COMPLETE_ACCESSIBLE_ALERT 10228
#define IDS_DOWNLOAD_PAUSED_ACCESSIBLE_ALERT 10229
#define IDS_PROMPT_DEEP_SCANNING_ACCESSIBLE_ALERT 10230
#define IDS_DEEP_SCANNING_ACCESSIBLE_ALERT 10231
#define IDS_PROMPT_DOWNLOAD_INSECURE_BLOCKED_ACCESSIBLE_ALERT 10232
#define IDS_DOWNLOAD_NOTIFICATION_COPY_TO_CLIPBOARD 10233
#define IDS_DOWNLOAD_MENU_SHOW 10234
#define IDS_DOWNLOAD_MENU_OPEN_WHEN_COMPLETE 10235
#define IDS_DOWNLOAD_MENU_OPEN 10236
#define IDS_DOWNLOAD_MENU_ALWAYS_OPEN_TYPE 10237
#define IDS_DOWNLOAD_MENU_PLATFORM_OPEN 10238
#define IDS_DOWNLOAD_MENU_PLATFORM_OPEN_ALWAYS 10239
#define IDS_DOWNLOAD_MENU_CANCEL 10240
#define IDS_DOWNLOAD_MENU_PAUSE_ITEM 10241
#define IDS_DOWNLOAD_MENU_RESUME_ITEM 10242
#define IDS_DOWNLOAD_MENU_DISCARD 10243
#define IDS_DOWNLOAD_MENU_KEEP 10244
#define IDS_DOWNLOAD_MENU_LEARN_MORE_SCANNING 10245
#define IDS_DOWNLOAD_MENU_LEARN_MORE_INTERRUPTED 10246
#define IDS_DOWNLOAD_MENU_LEARN_MORE_INSECURE 10247
#define IDS_DOWNLOAD_MENU_DEEP_SCAN 10249
#define IDS_ABANDON_DOWNLOAD_DIALOG_TITLE 10260
#define IDS_ABANDON_DOWNLOAD_DIALOG_CONTINUE_BUTTON 10261
#define IDS_ABANDON_DOWNLOAD_DIALOG_INCOGNITO_MESSAGE 10262
#define IDS_ABANDON_DOWNLOAD_DIALOG_GUEST_MESSAGE 10263
#define IDS_ABANDON_DOWNLOAD_DIALOG_EXIT_BUTTON 10264
#define IDS_DOWNLOAD_BUBBLE_HEADER_LABEL 10265
#define IDS_DOWNLOAD_BUBBLE_FOOTER_LABEL 10266
#define IDS_DOWNLOAD_BUBBLE_FOOTER_TOOLTIP_LABEL 10267
#define IDS_DOWNLOAD_BUBBLE_ESB_PROMO 10268
#define IDS_DOWNLOAD_BUBBLE_ESB_PROMO_CUSTOM_ACTION 10269
#define IDS_DOWNLOAD_BUBBLE_ESB_PROMO_DISMISS 10270
#define IDS_DOWNLOAD_BUBBLE_ESB_PROMO_TITLE 10271
#define IDS_DOWNLOAD_BUBBLE_DOWNLOAD_STATUS_MESSAGE_WITH_SEPARATOR 10272
#define IDS_DOWNLOAD_BUBBLE_DOWNLOAD_STATUS_WITH_SYMBOL 10273
#define IDS_DOWNLOAD_BUBBLE_STATUS_RESUMING 10274
#define IDS_DOWNLOAD_BUBBLE_STATUS_DONE 10275
#define IDS_DOWNLOAD_BUBBLE_STATUS_DEEP_SCANNING_DONE_UPDATED 10276
#define IDS_DOWNLOAD_BUBBLE_STATUS_WARNING_INSECURE 10277
#define IDS_DOWNLOAD_BUBBLE_STATUS_WARNING_SUSPICIOUS 10278
#define IDS_DOWNLOAD_BUBBLE_STATUS_WARNING_DANGEROUS 10279
#define IDS_DOWNLOAD_BUBBLE_STATUS_WARNING_UNVERIFIED 10280
#define IDS_DOWNLOAD_BUBBLE_STATUS_BLOCKED 10281
#define IDS_DOWNLOAD_BUBBLE_STATUS_MALWARE 10282
#define IDS_DOWNLOAD_BUBBLE_STATUS_SUSPICIOUS 10283
#define IDS_DOWNLOAD_BUBBLE_STATUS_DEEP_SCANNED_FAILED_UPDATED 10284
#define IDS_DOWNLOAD_BUBBLE_CHECKBOX_BYPASS 10285
#define IDS_DOWNLOAD_BUBBLE_CONTINUE 10286
#define IDS_DOWNLOAD_BUBBLE_CONTINUE_INSECURE_FILE 10287
#define IDS_DOWNLOAD_BUBBLE_CONTINUE_SUSPICIOUS_FILE 10288
#define IDS_DOWNLOAD_BUBBLE_CONTINUE_UNVERIFIED_FILE 10289
#define IDS_DOWNLOAD_BUBBLE_DELETE 10290
#define IDS_DOWNLOAD_BUBBLE_DELETE_FROM_HISTORY 10291
#define IDS_DOWNLOAD_BUBBLE_MAIN_BUTTON_SUBPAGE 10292
#define IDS_DOWNLOAD_BUBBLE_RESUME 10293
#define IDS_DOWNLOAD_BUBBLE_SCAN 10294
#define IDS_DOWNLOAD_BUBBLE_OPEN 10295
#define IDS_DOWNLOAD_BUBBLE_SCAN_UPDATED 10296
#define IDS_DOWNLOAD_BUBBLE_OPEN_UPDATED 10297
#define IDS_DOWNLOAD_BUBBLE_OPEN_NOW 10298
#define IDS_DOWNLOAD_BUBBLE_REVIEW 10299
#define IDS_DOWNLOAD_BUBBLE_RETRY 10300
#define IDS_DOWNLOAD_BUBBLE_OPEN_ANYWAY 10301
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_STATUS_DISK_FULL 10302
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_SUBPAGE_SUMMARY_DISK_FULL 10303
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_STATUS_PATH_TOO_LONG 10304
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_SUBPAGE_SUMMARY_PATH_TOO_LONG 10305
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_STATUS_NEEDS_PERMISSION 10306
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_STATUS_FILE_TOO_LARGE 10307
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_SUBPAGE_SUMMARY_FILE_TOO_LARGE 10308
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_STATUS_UNFINISHED 10309
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_STATUS_BLOCKED_ORGANIZATION 10310
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_SUBPAGE_SUMMARY_BLOCKED_ORGANIZATION 10311
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_STATUS_WRONG 10312
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_STATUS_NETWORK_ERROR 10313
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_STATUS_SITE_UNAVAILABLE 10314
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_STATUS_FILE_UNAVAILABLE 10315
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_SUBPAGE_SUMMARY_FILE_UNAVAILABLE 10316
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_STATUS_FILE_UNFINISHED 10317
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_WARNING_INSECURE 10318
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_WARNING_DANGEROUS 10319
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_WARNING_DECEPTIVE 10320
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_WARNING_DANGEROUS_FILE_TYPE 10321
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_WARNING_UNCOMMON_FILE 10322
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_WARNING_NO_SAFE_BROWSING 10323
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_WARNING_SAFE_BROWSING_SETTING_LABEL 10324
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_WARNING_SAFE_BROWSING_SETTING_LINK 10325
#define IDS_DOWNLOAD_BUBBLE_STATUS_DANGEROUS 10326
#define IDS_DOWNLOAD_BUBBLE_STATUS_ENCRYPTED 10327
#define IDS_DOWNLOAD_BUBBLE_STATUS_TOO_BIG 10328
#define IDS_DOWNLOAD_BUBBLE_STATUS_ADVANCED_PROTECTION 10329
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_ADVANCED_PROTECTION 10330
#define IDS_DOWNLOAD_BUBBLE_STATUS_UNCOMMON_FILE 10331
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_UNCOMMON_FILE 10332
#define IDS_DOWNLOAD_BUBBLE_STATUS_UNKNOWN_SOURCE 10333
#define IDS_DOWNLOAD_BUBBLE_STATUS_SENSITIVE_CONTENT 10334
#define IDS_DOWNLOAD_BUBBLE_STATUS_SCAN_FAILED 10335
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_SENSITIVE_CONTENT_WARNING 10336
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_SENSITIVE_CONTENT_BLOCK 10337
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_ENCRYPTED 10338
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_TOO_BIG 10339
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_ASYNC_SCANNING 10340
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_ASYNC_SCANNING_SECONDARY 10341
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_ASYNC_SCANNING_ENTERPRISE_SECONDARY 10342
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_ASYNC_SCANNING_DISCARD 10343
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_ASYNC_SCANNING_CANCEL 10344
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_SCAN_FAILED 10345
#define IDS_DOWNLOAD_BUBBLE_TRY_AGAIN 10346
#define IDS_DOWNLOAD_BUBBLE_STATUS_ASYNC_SCANNING_ENTERPRISE 10347
#define IDS_DOWNLOAD_BUBBLE_INCOGNITO_INFORMATION_ROW 10348
#define IDS_DOWNLOAD_BUBBLE_RESUME_QUICK_ACTION 10349
#define IDS_DOWNLOAD_BUBBLE_RESUME_QUICK_ACTION_ACCESSIBILITY 10350
#define IDS_DOWNLOAD_BUBBLE_PAUSE_QUICK_ACTION 10351
#define IDS_DOWNLOAD_BUBBLE_PAUSE_QUICK_ACTION_ACCESSIBILITY 10352
#define IDS_DOWNLOAD_BUBBLE_CANCEL_QUICK_ACTION 10353
#define IDS_DOWNLOAD_BUBBLE_CANCEL_QUICK_ACTION_ACCESSIBILITY 10354
#define IDS_DOWNLOAD_BUBBLE_OPEN_QUICK_ACTION 10355
#define IDS_DOWNLOAD_BUBBLE_OPEN_QUICK_ACTION_ACCESSIBILITY 10356
#define IDS_DOWNLOAD_BUBBLE_SHOW_IN_FOLDER_QUICK_ACTION 10357
#define IDS_DOWNLOAD_BUBBLE_SHOW_IN_FOLDER_QUICK_ACTION_ACCESSIBILITY 10358
#define IDS_DOWNLOAD_BUBBLE_BACK_RECENT_DOWNLOADS 10359
#define IDS_DOWNLOAD_BUBBLE_CANCEL_MAIN_BUTTON_ACCESSIBILITY 10360
#define IDS_DOWNLOAD_BUBBLE_DELETE_MAIN_BUTTON_ACCESSIBILITY 10361
#define IDS_DOWNLOAD_BUBBLE_KEEP_MAIN_BUTTON_ACCESSIBILITY 10362
#define IDS_DOWNLOAD_BUBBLE_SCAN_MAIN_BUTTON_ACCESSIBILITY 10363
#define IDS_DOWNLOAD_BUBBLE_OPEN_NOW_MAIN_BUTTON_ACCESSIBILITY 10364
#define IDS_DOWNLOAD_BUBBLE_RESUME_MAIN_BUTTON_ACCESSIBILITY 10365
#define IDS_DOWNLOAD_BUBBLE_REVIEW_MAIN_BUTTON_ACCESSIBILITY 10366
#define IDS_DOWNLOAD_BUBBLE_RETRY_MAIN_BUTTON_ACCESSIBILITY 10367
#define IDS_DOWNLOAD_BUBBLE_OPEN_MAIN_BUTTON_ACCESSIBILITY 10368
#define IDS_DOWNLOAD_BUBBLE_SUPPRESS_PARTIAL_VIEW 10369
#define IDS_DOWNLOAD_BUBBLE_SUPPRESS_PARTIAL_VIEW_SETTINGS_REMINDER 10370
#define IDS_DOWNLOAD_BUBBLE_SUPPRESS_PARTIAL_VIEW_SETTINGS_LINK 10371
#define IDS_DOWNLOAD_BUBBLE_TOOLTIP_IN_PROGRESS_COUNT 10372
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_WARNING_COOKIE_THEFT 10375
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_WARNING_COOKIE_THEFT_AND_ACCOUNT 10376
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_WARNING_ARCHIVE_MALWARE 10377
#define IDS_DOWNLOAD_BUBBLE_STATUS_DEEP_SCANNING_PROMPT_UPDATED 10378
#define IDS_DOWNLOAD_BUBBLE_STATUS_ASYNC_SCANNING 10379
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_DEEP_SCANNING_PROMPT_UPDATED 10380
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_DEEP_SCANNING_PROMPT_ENCRYPTED_ARCHIVE 10381
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_DEEP_SCANNING_LINK 10382
#define IDS_DOWNLOAD_BUBBLE_PASSWORD_PROMPT 10383
#define IDS_DOWNLOAD_BUBBLE_PASSWORD_PROMPT_EMPTY 10384
#define IDS_DOWNLOAD_BUBBLE_PASSWORD_PROMPT_INVALID 10385
#define IDS_DOWNLOAD_BUBBLE_PASSWORD_PROMPT_ACCESSIBLE_ALERT 10386
#define IDS_DOWNLOAD_BUBBLE_PASSWORD_PROMPT_ACCESSIBLE_ALERT_EMPTY 10387
#define IDS_DOWNLOAD_BUBBLE_PASSWORD_PROMPT_ACCESSIBLE_ALERT_INVALID 10388
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_IMMEDIATE_DEEP_SCAN_IN_PROGRESS 10389
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_IMMEDIATE_DEEP_SCAN_CANCEL 10390
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_IMMEDIATE_DEEP_SCAN_BYPASS 10391
#define IDS_DEEP_SCANNING_PROMPT_REMOVAL_NOTICE 10392
#define IDS_DEEP_SCANNING_PROMPT_REMOVAL_NOTICE_LINK 10393
#define IDS_DOWNLOAD_BUBBLE_STATUS_LOCAL_DECRYPTION_STATUS 10394
#define IDS_DOWNLOAD_BUBBLE_STATUS_PASSWORD_NEEDED 10395
#define IDS_DOWNLOAD_BUBBLE_ACCEPT_LOCAL_DECRYPTION 10396
#define IDS_DOWNLOAD_BUBBLE_BYPASS_LOCAL_DECRYPTION 10397
#define IDS_DOWNLOAD_BUBBLE_LOCAL_DECRYPTION_CANCEL 10398
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_LOCAL_DECRYPTION_IN_PROGRESS 10399
#define IDS_DOWNLOAD_BUBBLE_STATUS_LOCAL_DECRYPTING 10400
#define IDS_DOWNLOAD_LOCAL_DECRYPTION_PROMPT_ALERT 10401
#define IDS_WEB_APP_WITH_APP_TITLE 10402
#define IDS_OMNIBOX_PWA_INSTALL_ICON_LABEL 10403
#define IDS_OMNIBOX_PWA_INSTALL_ICON_TOOLTIP 10404
#define IDS_ADD_TO_OS_LAUNCH_SURFACE_BUBBLE_TITLE 10405
#define IDS_CREATE_SHORTCUTS_BUTTON_LABEL 10406
#define IDS_CREATE_SHORTCUT_NOT_APPS_DIALOG_TITLE 10407
#define IDS_CREATE_SHORTCUT_NOT_APPS_AX_BUBBLE_LABEL 10408
#define IDS_INSTALL_TO_OS_LAUNCH_SURFACE_BUBBLE_TITLE 10409
#define IDS_INSTALL_PWA_BUTTON_LABEL 10410
#define IDS_INSTALL_PWA_DIALOG_TITLE 10411
#define IDS_WEB_APP_DETAILED_INSTALL_DIALOG_DESCRIPTION_TITLE 10412
#define IDS_DIY_APP_INSTALL_DIALOG_TITLE 10413
#define IDS_DIY_APP_INSTALL_DIALOG_SUBTITLE 10414
#define IDS_DIY_APP_AX_BUBBLE_NAME_LABEL 10415
#define IDS_BOOKMARK_APP_AX_BUBBLE_NAME_LABEL 10416
#define IDS_BOOKMARK_APP_BUBBLE_OPEN_AS_TAB 10417
#define IDS_BOOKMARK_APP_BUBBLE_OPEN_AS_WINDOW 10418
#define IDS_BOOKMARK_APP_BUBBLE_OPEN_AS_TABBED_WINDOW 10419
#define IDS_WEBAPP_UPDATE_DIALOG_TITLE_NAME 10420
#define IDS_WEBAPP_UPDATE_DIALOG_TITLE_ICON 10421
#define IDS_WEBAPP_UPDATE_DIALOG_TITLE_NAME_AND_ICON 10422
#define IDS_WEBAPP_UPDATE_EXPLANATION 10423
#define IDS_WEBAPP_UPDATE_CURRENT_ICON 10424
#define IDS_WEBAPP_UPDATE_NEW_ICON 10425
#define IDS_WEBAPP_UPDATE_NEGATIVE_BUTTON 10426
#define IDS_FINISH_POLICY_WEB_APP_INSTALLATION 10427
#define IDS_FINISH_POLICY_WEB_APP_INSTALATION_RESTART 10428
#define IDS_FINISH_POLICY_WEB_APP_INSTALLATION_NOT_NOW 10429
#define IDS_ADD_TO_OS_LAUNCH_SURFACE 10434
#define IDS_INSTALL_TO_OS_LAUNCH_SURFACE 10435
#define IDS_INSTALL_DIY_TO_OS_LAUNCH_SURFACE 10436
#define IDS_UNINSTALL_FROM_OS_LAUNCH_SURFACE 10437
#define IDS_APPLICATION_INFO_WEB_STORE_LINK 10438
#define IDS_APPLICATION_INFO_HOMEPAGE_LINK 10439
#define IDS_ARC_APPLICATION_INFO_MANAGE_LINK 10440
#define IDS_APPLICATION_INFO_APP_OVERVIEW_TITLE 10441
#define IDS_APPLICATION_INFO_APP_PERMISSIONS_TITLE 10442
#define IDS_APPLICATION_INFO_UNINSTALL_BUTTON_TEXT 10443
#define IDS_APPLICATION_INFO_LICENSES_BUTTON_TEXT 10444
#define IDS_APPLICATION_INFO_SIZE_LABEL 10445
#define IDS_APPLICATION_INFO_VERSION_LABEL 10446
#define IDS_APPLICATION_INFO_CREATE_SHORTCUTS_BUTTON_TEXT 10447
#define IDS_APPLICATION_INFO_LAUNCH_OPTIONS_ACCNAME 10448
#define IDS_APPLICATION_INFO_SIZE_LOADING_LABEL 10449
#define IDS_APPLICATION_INFO_SIZE_SMALL_LABEL 10450
#define IDS_APPLICATION_INFO_REVOKE_PERMISSION_ALT_TEXT 10451
#define IDS_APPLICATION_INFO_APP_NO_PERMISSIONS_TEXT 10452
#define IDS_APPLICATION_INFO_EXTENSION_NO_PERMISSIONS_TEXT 10453
#define IDS_APPLICATION_INFO_RETAINED_FILES 10454
#define IDS_APPLICATION_INFO_RETAINED_DEVICES 10455
#define IDS_CREATE_SHORTCUTS_TITLE 10456
#define IDS_CREATE_SHORTCUTS_LABEL 10457
#define IDS_CREATE_SHORTCUTS_DESKTOP_CHKBOX 10458
#define IDS_CREATE_SHORTCUTS_MENU_CHKBOX 10459
#define IDS_CREATE_SHORTCUTS_COMMIT 10460
#define IDS_BLUETOOTH_DEVICE_CREDENTIALS_TITLE 10463
#define IDS_BLUETOOTH_DEVICE_CREDENTIALS_LABEL 10464
#define IDS_BLUETOOTH_DEVICE_PAIR_CONFIRM_TITLE 10465
#define IDS_BLUETOOTH_DEVICE_PAIR_CONFIRM_LABEL 10466
#define IDS_BLUETOOTH_DEVICE_PASSKEY_CONFIRM_TITLE 10467
#define IDS_BLUETOOTH_DEVICE_PASSKEY_CONFIRM_LABEL 10468
#define IDS_MANAGE 10469
#define IDS_LIST_BULLET 10470
#define IDS_BLOCKED_DOWNLOAD_NO_ACTION 10471
#define IDS_BLOCKED_DOWNLOAD_UNBLOCK 10472
#define IDS_ALLOWED_DOWNLOAD_TITLE 10473
#define IDS_BLOCKED_DOWNLOAD_TITLE 10474
#define IDS_BLOCKED_DOWNLOADS_EXPLANATION 10475
#define IDS_ALLOWED_DOWNLOAD_NO_ACTION 10476
#define IDS_ALLOWED_DOWNLOAD_BLOCK 10477
#define IDS_BLOCKED_ON_DEVICE_SITE_DATA_TITLE 10478
#define IDS_ACCESSED_ON_DEVICE_SITE_DATA_TITLE 10479
#define IDS_BLOCKED_ON_DEVICE_SITE_DATA_MESSAGE 10480
#define IDS_ACCESSED_ON_DEVICE_SITE_DATA_MESSAGE 10481
#define IDS_BLOCKED_COOKIES_INFO 10482
#define IDS_BLOCKED_IMAGES_TITLE 10483
#define IDS_BLOCKED_IMAGES_MESSAGE 10484
#define IDS_BLOCKED_ON_DEVICE_SITE_DATA_UNBLOCK 10485
#define IDS_BLOCKED_IMAGES_UNBLOCK 10486
#define IDS_BLOCKED_ON_DEVICE_SITE_DATA_NO_ACTION 10487
#define IDS_ALLOWED_ON_DEVICE_SITE_DATA_NO_ACTION 10488
#define IDS_ALLOWED_ON_DEVICE_SITE_DATA_BLOCK 10489
#define IDS_BLOCKED_IMAGES_NO_ACTION 10490
#define IDS_BLOCKED_POPUPS_TOOLTIP 10491
#define IDS_BLOCKED_POPUPS_TITLE 10492
#define IDS_BLOCKED_POPUPS_REDIRECTS_UNBLOCK 10493
#define IDS_BLOCKED_POPUPS_REDIRECTS_NO_ACTION 10494
#define IDS_BLOCKED_MEDIASTREAM_MIC_AND_CAMERA_ALLOW 10495
#define IDS_BLOCKED_MEDIASTREAM_MIC_ALLOW 10496
#define IDS_BLOCKED_MEDIASTREAM_CAMERA_ALLOW 10497
#define IDS_BLOCKED_MEDIASTREAM_MIC_AND_CAMERA_ASK 10498
#define IDS_BLOCKED_MEDIASTREAM_MIC_ASK 10499
#define IDS_BLOCKED_MEDIASTREAM_CAMERA_ASK 10500
#define IDS_ALLOWED_MEDIASTREAM_MIC_AND_CAMERA_BLOCK 10501
#define IDS_ALLOWED_MEDIASTREAM_MIC_BLOCK 10502
#define IDS_ALLOWED_MEDIASTREAM_CAMERA_BLOCK 10503
#define IDS_BLOCKED_MEDIASTREAM_MIC_AND_CAMERA_NO_ACTION 10504
#define IDS_BLOCKED_MEDIASTREAM_MIC_NO_ACTION 10505
#define IDS_BLOCKED_MEDIASTREAM_CAMERA_NO_ACTION 10506
#define IDS_ALLOWED_MEDIASTREAM_MIC_AND_CAMERA_NO_ACTION 10507
#define IDS_ALLOWED_MEDIASTREAM_MIC_AND_CAMERA_PAN_TILT_ZOOM_NO_ACTION 10508
#define IDS_ALLOWED_MEDIASTREAM_MIC_NO_ACTION 10509
#define IDS_ALLOWED_MEDIASTREAM_CAMERA_NO_ACTION 10510
#define IDS_ALLOWED_CAMERA_PAN_TILT_ZOOM_NO_ACTION 10511
#define IDS_BLOCKED_POPUPS_EXPLANATORY_TEXT 10512
#define IDS_BLOCKED_JAVASCRIPT_TITLE 10513
#define IDS_BLOCKED_JAVASCRIPT_MESSAGE 10514
#define IDS_BLOCKED_JAVASCRIPT_UNBLOCK 10515
#define IDS_BLOCKED_JAVASCRIPT_NO_ACTION 10516
#define IDS_BLOCKED_SOUND_TITLE 10517
#define IDS_BLOCKED_SOUND_UNBLOCK 10518
#define IDS_BLOCKED_SOUND_NO_ACTION 10519
#define IDS_NOTIFICATIONS_OFF_EXPLANATORY_TEXT 10520
#define IDS_NOTIFICATIONS_QUIET_PERMISSION_BUBBLE_TITLE 10521
#define IDS_NOTIFICATIONS_QUIET_PERMISSION_BUBBLE_DESCRIPTION 10522
#define IDS_GEOLOCATION_QUIET_PERMISSION_BUBBLE_DESCRIPTION 10523
#define IDS_NOTIFICATIONS_QUIET_PERMISSION_BUBBLE_ALLOW_BUTTON 10524
#define IDS_NOTIFICATIONS_QUIET_PERMISSION_BUBBLE_COMPACT_ALLOW_BUTTON 10525
#define IDS_NOTIFICATIONS_QUIET_PERMISSION_BUBBLE_CONTINUE_BLOCKING_BUTTON 10526
#define IDS_NOTIFICATIONS_QUIET_PERMISSION_EARLY_PROMO 10527
#define IDS_NOTIFICATIONS_QUIET_PERMISSION_NEW_REQUEST_PROMO 10528
#define IDS_NOTIFICATIONS_QUIET_PERMISSION_BUBBLE_CROWD_DENY_DESCRIPTION 10529
#define IDS_NOTIFICATIONS_QUIET_PERMISSION_BUBBLE_ABUSIVE_DESCRIPTION 10530
#define IDS_NOTIFICATIONS_QUIET_PERMISSION_BUBBLE_DISRUPTIVE_DESCRIPTION 10531
#define IDS_NOTIFICATIONS_QUIET_PERMISSION_BUBBLE_PREDICTION_SERVICE_DESCRIPTION 10532
#define IDS_GEOLOCATION_OFF_EXPLANATORY_TEXT 10533
#define IDS_GEOLOCATION_QUIET_PERMISSION_BUBBLE_TITLE 10534
#define IDS_GEOLOCATION_QUIET_PERMISSION_BUBBLE_PREDICTION_SERVICE_DESCRIPTION 10535
#define IDS_GEOLOCATION_QUIET_PERMISSION_BUBBLE_ALLOW_BUTTON 10536
#define IDS_STORAGE_ACCESS_PERMISSION_BUBBLE_MESSAGE 10537
#define IDS_STORAGE_ACCESS_PERMISSION_ALLOWED_TOOLTIP 10538
#define IDS_STORAGE_ACCESS_PERMISSION_BLOCKED_TOOLTIP 10539
#define IDS_COOKIE_CONTROLS_BUBBLE_COOKIES_BLOCKED_TITLE 10540
#define IDS_TRACKING_PROTECTION_BUBBLE_TITLE 10541
#define IDS_COOKIE_CONTROLS_BUBBLE_COOKIES_ALLOWED_TITLE 10542
#define IDS_COOKIE_CONTROLS_BUBBLE_SITE_NOT_WORKING_TITLE 10543
#define IDS_TRACKING_PROTECTION_BUBBLE_SITE_NOT_WORKING_DESCRIPTION 10544
#define IDS_TRACKING_PROTECTION_BUBBLE_LIMITING_RESTART_TITLE 10545
#define IDS_TRACKING_PROTECTION_BUBBLE_BLOCKING_RESTART_TITLE 10546
#define IDS_TRACKING_PROTECTION_BUBBLE_BLOCKING_RESTART_DESCRIPTION 10547
#define IDS_TRACKING_PROTECTION_BUBBLE_PERMANENT_ALLOWED_TITLE 10548
#define IDS_TRACKING_PROTECTION_BUBBLE_PERMANENT_ALLOWED_DESCRIPTION 10549
#define IDS_COOKIE_CONTROLS_BUBBLE_SEND_FEEDBACK_BUTTON_TITLE 10550
#define IDS_COOKIE_CONTROLS_BUBBLE_SEND_FEEDBACK_BUTTON_DESCRIPTION 10551
#define IDS_COOKIE_CONTROLS_BUBBLE_RELOADING_LABEL 10552
#define IDS_COOKIE_CONTROLS_BUBBLE_THIRD_PARTY_COOKIES_LABEL 10553
#define IDS_COOKIE_CONTROLS_BUBBLE_SEND_FEEDBACK_FORM_PLACEHOLDER 10554
#define IDS_TRACKING_PROTECTION_BUBBLE_COOKIES_ALLOWED_LABEL 10555
#define IDS_TRACKING_PROTECTION_BUBBLE_COOKIES_BLOCKED_LABEL 10556
#define IDS_TRACKING_PROTECTION_BUBBLE_COOKIES_LIMITED_LABEL 10557
#define IDS_COOKIE_CONTROLS_PAGE_ACTION_COOKIES_ALLOWED_LABEL 10558
#define IDS_COOKIE_CONTROLS_PAGE_ACTION_COOKIES_BLOCKED_LABEL 10559
#define IDS_COOKIE_CONTROLS_PAGE_ACTION_COOKIES_LIMITED_LABEL 10560
#define IDS_TRACKING_PROTECTION_PAGE_ACTION_SITE_NOT_WORKING_LABEL 10561
#define IDS_TRACKING_PROTECTION_PAGE_ACTION_LABEL 10562
#define IDS_COOKIE_CONTROLS_PROMO_TITLE 10563
#define IDS_COOKIE_CONTROLS_PROMO_TEXT 10564
#define IDS_COOKIE_CONTROLS_PROMO_CLOSE_BUTTON_TEXT 10565
#define IDS_COOKIE_CONTROLS_PROMO_SEE_HOW_BUTTON_TEXT 10566
#define IDS_CERT_SELECTOR_SUBJECT_COLUMN 10567
#define IDS_CERT_SELECTOR_ISSUER_COLUMN 10568
#define IDS_CERT_SELECTOR_PROVIDER_COLUMN 10569
#define IDS_CERT_SELECTOR_SERIAL_COLUMN 10570
#define IDS_CERT_EXPORT_TYPE_BASE64_ALL 10571
#define IDS_CERT_EXPORT_TYPE_BASE64 10572
#define IDS_CERT_EXPORT_TYPE_BASE64_CHAIN 10573
#define IDS_CERT_EXPORT_TYPE_DER 10574
#define IDS_CERT_EXPORT_TYPE_PKCS7 10575
#define IDS_CERT_EXPORT_TYPE_PKCS7_CHAIN 10576
#define IDS_CERT_INFO_DIALOG_TITLE 10577
#define IDS_CERT_INFO_GENERAL_TAB_LABEL 10578
#define IDS_CERT_INFO_DETAILS_TAB_LABEL 10579
#define IDS_CERT_USAGE_SSL_CLIENT 10580
#define IDS_CERT_USAGE_SSL_SERVER 10581
#define IDS_CERT_USAGE_OBJECT_SIGNER 10582
#define IDS_CERT_USAGE_SSL_CA 10583
#define IDS_CERT_INFO_IDN_VALUE_FORMAT 10584
#define IDS_CERT_INFO_FIELD_NOT_PRESENT 10585
#define IDS_CERT_DETAILS_CERTIFICATE_HIERARCHY_LABEL 10586
#define IDS_CERT_DETAILS_CERTIFICATE_FIELDS_LABEL 10587
#define IDS_CERT_DETAILS_CERTIFICATE_FIELD_VALUE_LABEL 10588
#define IDS_CERT_DETAILS_CERTIFICATE 10589
#define IDS_CERT_DETAILS_VERSION 10590
#define IDS_CERT_DETAILS_VERSION_FORMAT 10591
#define IDS_CERT_DETAILS_SERIAL_NUMBER 10592
#define IDS_CERT_DETAILS_CERTIFICATE_SIG_ALG 10593
#define IDS_CERT_DETAILS_ISSUER 10594
#define IDS_CERT_DETAILS_VALIDITY 10595
#define IDS_CERT_DETAILS_NOT_BEFORE 10596
#define IDS_CERT_DETAILS_NOT_AFTER 10597
#define IDS_CERT_DETAILS_SUBJECT 10598
#define IDS_CERT_DETAILS_SUBJECT_KEY_INFO 10599
#define IDS_CERT_DETAILS_SUBJECT_KEY_ALG 10600
#define IDS_CERT_DETAILS_SUBJECT_KEY 10601
#define IDS_CERT_RSA_PUBLIC_KEY_DUMP_FORMAT 10602
#define IDS_CERT_DETAILS_CERTIFICATE_SIG_VALUE 10603
#define IDS_CERT_DETAILS_EXPORT_CERTIFICATE 10604
#define IDS_CERT_DETAILS_EXPORT_CERTIFICATE_A11Y_LABEL 10605
#define IDS_CERT_OID_AVA_COMMON_NAME 10606
#define IDS_CERT_OID_AVA_STATE_OR_PROVINCE 10607
#define IDS_CERT_OID_AVA_ORGANIZATION_NAME 10608
#define IDS_CERT_OID_AVA_ORGANIZATIONAL_UNIT_NAME 10609
#define IDS_CERT_OID_AVA_DN_QUALIFIER 10610
#define IDS_CERT_OID_AVA_COUNTRY_NAME 10611
#define IDS_CERT_OID_AVA_SERIAL_NUMBER 10612
#define IDS_CERT_OID_AVA_LOCALITY 10613
#define IDS_CERT_OID_AVA_DC 10614
#define IDS_CERT_OID_RFC1274_MAIL 10615
#define IDS_CERT_OID_RFC1274_UID 10616
#define IDS_CERT_OID_PKCS9_EMAIL_ADDRESS 10617
#define IDS_CERT_OID_BUSINESS_CATEGORY 10618
#define IDS_CERT_OID_EV_INCORPORATION_LOCALITY 10619
#define IDS_CERT_OID_EV_INCORPORATION_STATE 10620
#define IDS_CERT_OID_EV_INCORPORATION_COUNTRY 10621
#define IDS_CERT_OID_AVA_STREET_ADDRESS 10622
#define IDS_CERT_OID_AVA_POSTAL_CODE 10623
#define IDS_CERT_OID_PKCS1_RSA_ENCRYPTION 10624
#define IDS_CERT_OID_PKCS1_MD2_WITH_RSA_ENCRYPTION 10625
#define IDS_CERT_OID_PKCS1_MD4_WITH_RSA_ENCRYPTION 10626
#define IDS_CERT_OID_PKCS1_MD5_WITH_RSA_ENCRYPTION 10627
#define IDS_CERT_OID_PKCS1_SHA1_WITH_RSA_ENCRYPTION 10628
#define IDS_CERT_OID_PKCS1_SHA256_WITH_RSA_ENCRYPTION 10629
#define IDS_CERT_OID_PKCS1_SHA384_WITH_RSA_ENCRYPTION 10630
#define IDS_CERT_OID_PKCS1_SHA512_WITH_RSA_ENCRYPTION 10631
#define IDS_CERT_OID_ANSIX962_ECDSA_SHA1_SIGNATURE 10632
#define IDS_CERT_OID_ANSIX962_ECDSA_SHA256_SIGNATURE 10633
#define IDS_CERT_OID_ANSIX962_ECDSA_SHA384_SIGNATURE 10634
#define IDS_CERT_OID_ANSIX962_ECDSA_SHA512_SIGNATURE 10635
#define IDS_CERT_OID_ANSIX962_EC_PUBLIC_KEY 10636
#define IDS_CERT_OID_SECG_EC_SECP256R1 10637
#define IDS_CERT_OID_SECG_EC_SECP384R1 10638
#define IDS_CERT_OID_SECG_EC_SECP521R1 10639
#define IDS_CERT_EXT_NS_CERT_TYPE 10640
#define IDS_CERT_EXT_NS_CERT_TYPE_EMAIL 10641
#define IDS_CERT_EXT_NS_CERT_TYPE_EMAIL_CA 10642
#define IDS_CERT_EXT_NS_CERT_BASE_URL 10643
#define IDS_CERT_EXT_NS_CERT_REVOCATION_URL 10644
#define IDS_CERT_EXT_NS_CA_REVOCATION_URL 10645
#define IDS_CERT_EXT_NS_CERT_RENEWAL_URL 10646
#define IDS_CERT_EXT_NS_CA_POLICY_URL 10647
#define IDS_CERT_EXT_NS_SSL_SERVER_NAME 10648
#define IDS_CERT_EXT_NS_COMMENT 10649
#define IDS_CERT_EXT_NS_LOST_PASSWORD_URL 10650
#define IDS_CERT_EXT_NS_CERT_RENEWAL_TIME 10651
#define IDS_CERT_X509_SUBJECT_DIRECTORY_ATTR 10652
#define IDS_CERT_X509_SUBJECT_KEYID 10653
#define IDS_CERT_KEYID_FORMAT 10654
#define IDS_CERT_ISSUER_FORMAT 10655
#define IDS_CERT_SERIAL_NUMBER_FORMAT 10656
#define IDS_CERT_X509_KEY_USAGE 10657
#define IDS_CERT_X509_ISSUER_ALT_NAME 10658
#define IDS_CERT_X509_BASIC_CONSTRAINTS 10659
#define IDS_CERT_X509_NAME_CONSTRAINTS 10660
#define IDS_CERT_X509_CRL_DIST_POINTS 10661
#define IDS_CERT_X509_CERT_POLICIES 10662
#define IDS_CERT_X509_SCT_LIST 10663
#define IDS_CERT_X509_POLICY_MAPPINGS 10664
#define IDS_CERT_X509_POLICY_CONSTRAINTS 10665
#define IDS_CERT_X509_AUTH_KEYID 10666
#define IDS_CERT_X509_EXT_KEY_USAGE 10667
#define IDS_CERT_X509_AUTH_INFO_ACCESS 10668
#define IDS_CERT_X509_KEY_USAGE_SIGNING 10669
#define IDS_CERT_X509_KEY_USAGE_NONREP 10670
#define IDS_CERT_X509_KEY_USAGE_ENCIPHERMENT 10671
#define IDS_CERT_X509_KEY_USAGE_DATA_ENCIPHERMENT 10672
#define IDS_CERT_X509_KEY_USAGE_KEY_AGREEMENT 10673
#define IDS_CERT_X509_KEY_USAGE_CERT_SIGNER 10674
#define IDS_CERT_X509_KEY_USAGE_CRL_SIGNER 10675
#define IDS_CERT_X509_KEY_USAGE_ENCIPHER_ONLY 10676
#define IDS_CERT_X509_KEY_USAGE_DECIPHER_ONLY 10677
#define IDS_CERT_X509_BASIC_CONSTRAINT_IS_CA 10678
#define IDS_CERT_X509_BASIC_CONSTRAINT_IS_NOT_CA 10679
#define IDS_CERT_X509_BASIC_CONSTRAINT_PATH_LEN 10680
#define IDS_CERT_X509_BASIC_CONSTRAINT_PATH_LEN_UNLIMITED 10681
#define IDS_CERT_PKIX_CPS_POINTER_QUALIFIER 10682
#define IDS_CERT_PKIX_USER_NOTICE_QUALIFIER 10683
#define IDS_CERT_REVOCATION_REASON_UNUSED 10684
#define IDS_CERT_REVOCATION_REASON_KEY_COMPROMISE 10685
#define IDS_CERT_REVOCATION_REASON_CA_COMPROMISE 10686
#define IDS_CERT_REVOCATION_REASON_AFFILIATION_CHANGED 10687
#define IDS_CERT_REVOCATION_REASON_SUPERSEDED 10688
#define IDS_CERT_REVOCATION_REASON_CESSATION_OF_OPERATION 10689
#define IDS_CERT_REVOCATION_REASON_CERTIFICATE_HOLD 10690
#define IDS_CERT_OCSP_RESPONDER_FORMAT 10691
#define IDS_CERT_CA_ISSUERS_FORMAT 10692
#define IDS_CERT_UNKNOWN_OID_INFO_FORMAT 10693
#define IDS_CERT_EXT_KEY_USAGE_FORMAT 10694
#define IDS_CERT_MULTILINE_INFO_START_FORMAT 10695
#define IDS_CERT_GENERAL_NAME_RFC822_NAME 10696
#define IDS_CERT_GENERAL_NAME_DNS_NAME 10697
#define IDS_CERT_GENERAL_NAME_X400_ADDRESS 10698
#define IDS_CERT_GENERAL_NAME_DIRECTORY_NAME 10699
#define IDS_CERT_GENERAL_NAME_EDI_PARTY_NAME 10700
#define IDS_CERT_GENERAL_NAME_URI 10701
#define IDS_CERT_GENERAL_NAME_IP_ADDRESS 10702
#define IDS_CERT_GENERAL_NAME_REGISTERED_ID 10703
#define IDS_CERT_EXT_MS_APP_POLICIES 10704
#define IDS_CERT_EXT_MS_CERT_TEMPLATE 10705
#define IDS_CERT_EXT_MS_CERT_TYPE 10706
#define IDS_CERT_EXT_MS_CA_VERSION 10707
#define IDS_CERT_EXT_MS_NT_PRINCIPAL_NAME 10708
#define IDS_CERT_EXT_MS_NTDS_REPLICATION 10709
#define IDS_CERT_EKU_ANY_EKU 10710
#define IDS_CERT_EKU_TLS_WEB_SERVER_AUTHENTICATION 10711
#define IDS_CERT_EKU_TLS_WEB_CLIENT_AUTHENTICATION 10712
#define IDS_CERT_EKU_CODE_SIGNING 10713
#define IDS_CERT_EKU_EMAIL_PROTECTION 10714
#define IDS_CERT_EKU_TIME_STAMPING 10715
#define IDS_CERT_EKU_OCSP_SIGNING 10716
#define IDS_CERT_EKU_MS_INDIVIDUAL_CODE_SIGNING 10717
#define IDS_CERT_EKU_MS_COMMERCIAL_CODE_SIGNING 10718
#define IDS_CERT_EKU_MS_TRUST_LIST_SIGNING 10719
#define IDS_CERT_EKU_MS_TIME_STAMPING 10720
#define IDS_CERT_EKU_MS_SERVER_GATED_CRYPTO 10721
#define IDS_CERT_EKU_MS_ENCRYPTING_FILE_SYSTEM 10722
#define IDS_CERT_EKU_MS_FILE_RECOVERY 10723
#define IDS_CERT_EKU_MS_WINDOWS_HARDWARE_DRIVER_VERIFICATION 10724
#define IDS_CERT_EKU_MS_QUALIFIED_SUBORDINATION 10725
#define IDS_CERT_EKU_MS_KEY_RECOVERY 10726
#define IDS_CERT_EKU_MS_DOCUMENT_SIGNING 10727
#define IDS_CERT_EKU_MS_LIFETIME_SIGNING 10728
#define IDS_CERT_EKU_MS_SMART_CARD_LOGON 10729
#define IDS_CERT_EKU_MS_KEY_RECOVERY_AGENT 10730
#define IDS_CERT_EKU_NETSCAPE_INTERNATIONAL_STEP_UP 10731
#define IDS_CERT_EXTENSION_CRITICAL 10732
#define IDS_CERT_EXTENSION_NON_CRITICAL 10733
#define IDS_CERT_DUMP_ERROR 10734
#define IDS_CERT_EXTENSION_DUMP_ERROR 10735
#define IDS_CERTIFICATE_MANAGER_TITLE 10736
#define IDS_CERT_MANAGER_HARDWARE_BACKED_KEY_FORMAT 10737
#define IDS_CERT_MANAGER_HARDWARE_BACKED 10738
#define IDS_CERT_MANAGER_EXTENSION_PROVIDED_FORMAT 10739
#define IDS_DEV_TOOLS_SHARED_PROCESS_INFOBAR 10740
#define IDS_DEV_TOOLS_INFOBAR_LABEL 10741
#define IDS_DEV_TOOLS_CONFIRM_ADD_FILE_SYSTEM_MESSAGE 10742
#define IDS_DEV_TOOLS_CONFIRM_ALLOW_BUTTON 10743
#define IDS_DEV_TOOLS_CONFIRM_DENY_BUTTON 10744
#define IDS_RELOAD_MENU_NORMAL_RELOAD_ITEM 10745
#define IDS_RELOAD_MENU_HARD_RELOAD_ITEM 10746
#define IDS_RELOAD_MENU_EMPTY_AND_HARD_RELOAD_ITEM 10747
#define IDS_TAB_SHARING_INFOBAR_SHARING_CURRENT_TAB_LABEL 10748
#define IDS_TAB_SHARING_INFOBAR_SHARING_ANOTHER_UNTITLED_TAB_LABEL 10749
#define IDS_TAB_SHARING_INFOBAR_SHARING_ANOTHER_TAB_LABEL 10750
#define IDS_TAB_SHARING_INFOBAR_SHARE_BUTTON 10751
#define IDS_TAB_SHARING_INFOBAR_STOP_BUTTON 10752
#define IDS_TAB_SHARING_INFOBAR_SWITCH_TO_BUTTON 10753
#define IDS_TAB_SHARING_INFOBAR_SWITCH_TO_CAPTURER_BUTTON 10754
#define IDS_TAB_SHARING_INFOBAR_SWITCH_TO_CAPTURED_BUTTON 10755
#define IDS_TAB_SHARING_INFOBAR_CAPTURED_SURFACE_CONTROL_PERMISSION_BUTTON 10756
#define IDS_TAB_CASTING_INFOBAR_CASTING_CURRENT_TAB_LABEL 10757
#define IDS_TAB_CASTING_INFOBAR_CASTING_CURRENT_TAB_NO_DEVICE_NAME_LABEL 10758
#define IDS_TAB_CASTING_INFOBAR_CASTING_ANOTHER_UNTITLED_TAB_LABEL 10759
#define IDS_TAB_CASTING_INFOBAR_CASTING_ANOTHER_UNTITLED_TAB_NO_DEVICE_NAME_LABEL 10760
#define IDS_TAB_CASTING_INFOBAR_CASTING_ANOTHER_TAB_LABEL 10761
#define IDS_TAB_CASTING_INFOBAR_CASTING_ANOTHER_TAB_NO_DEVICE_NAME_LABEL 10762
#define IDS_TAB_CASTING_INFOBAR_CAST_BUTTON 10763
#define IDS_TAB_CASTING_INFOBAR_STOP_BUTTON 10764
#define IDS_TASK_MANAGER_KILL 10765
#define IDS_TASK_MANAGER_PROCESS_ID_COLUMN 10766
#define IDS_TASK_MANAGER_GDI_HANDLES_COLUMN 10767
#define IDS_TASK_MANAGER_USER_HANDLES_COLUMN 10768
#define IDS_TASK_MANAGER_TASK_COLUMN 10769
#define IDS_TASK_MANAGER_NACL_DEBUG_STUB_PORT_COLUMN 10770
#define IDS_TASK_MANAGER_NET_COLUMN 10771
#define IDS_TASK_MANAGER_CPU_COLUMN 10772
#define IDS_TASK_MANAGER_START_TIME_COLUMN 10773
#define IDS_TASK_MANAGER_CPU_TIME_COLUMN 10774
#define IDS_TASK_MANAGER_MEM_FOOTPRINT_COLUMN 10775
#define IDS_TASK_MANAGER_SWAPPED_MEM_COLUMN 10776
#define IDS_TASK_MANAGER_PROFILE_NAME_COLUMN 10777
#define IDS_TASK_MANAGER_IDLE_WAKEUPS_COLUMN 10778
#define IDS_TASK_MANAGER_HARD_FAULTS_COLUMN 10779
#define IDS_TASK_MANAGER_OPEN_FD_COUNT_COLUMN 10780
#define IDS_TASK_MANAGER_PROCESS_PRIORITY_COLUMN 10781
#define IDS_TASK_MANAGER_WEBCORE_IMAGE_CACHE_COLUMN 10782
#define IDS_TASK_MANAGER_WEBCORE_SCRIPTS_CACHE_COLUMN 10783
#define IDS_TASK_MANAGER_WEBCORE_CSS_CACHE_COLUMN 10784
#define IDS_TASK_MANAGER_VIDEO_MEMORY_COLUMN 10785
#define IDS_TASK_MANAGER_SQLITE_MEMORY_USED_COLUMN 10786
#define IDS_TASK_MANAGER_JAVASCRIPT_MEMORY_ALLOCATED_COLUMN 10787
#define IDS_TASK_MANAGER_KEEPALIVE_COUNT_COLUMN 10788
#define IDS_TASK_MANAGER_MEM_CELL_TEXT 10789
#define IDS_TASK_MANAGER_CACHE_SIZE_CELL_TEXT 10790
#define IDS_TASK_MANAGER_NA_CELL_TEXT 10791
#define IDS_TASK_MANAGER_BACKGROUNDED_TEXT 10792
#define IDS_TASK_MANAGER_FOREGROUNDED_TEXT 10793
#define IDS_TASK_MANAGER_UNKNOWN_VALUE_TEXT 10794
#define IDS_TASK_MANAGER_DISABLED_NACL_DBG_TEXT 10795
#define IDS_TASK_MANAGER_HANDLES_CELL_TEXT 10796
#define IDS_TASK_MANAGER_WEB_BROWSER_CELL_TEXT 10797
#define IDS_TASK_MANAGER_EXTENSION_PREFIX 10798
#define IDS_TASK_MANAGER_EXTENSION_INCOGNITO_PREFIX 10799
#define IDS_TASK_MANAGER_APP_PREFIX 10800
#define IDS_TASK_MANAGER_APP_INCOGNITO_PREFIX 10801
#define IDS_TASK_MANAGER_TAB_PREFIX 10802
#define IDS_TASK_MANAGER_TAB_INCOGNITO_PREFIX 10803
#define IDS_TASK_MANAGER_BACKGROUND_APP_PREFIX 10804
#define IDS_TASK_MANAGER_BACKGROUND_PREFIX 10805
#define IDS_TASK_MANAGER_BACK_FORWARD_CACHE_PREFIX 10806
#define IDS_TASK_MANAGER_BACK_FORWARD_CACHE_INCOGNITO_PREFIX 10807
#define IDS_TASK_MANAGER_PLUGIN_PREFIX 10808
#define IDS_TASK_MANAGER_PLUGIN_BROKER_PREFIX 10809
#define IDS_TASK_MANAGER_PRELOADED_RENDERER_FOR_UI 10810
#define IDS_TASK_MANAGER_NO_STATE_PREFETCH_PREFIX 10811
#define IDS_TASK_MANAGER_PRERENDER_PREFIX 10812
#define IDS_TASK_MANAGER_SPARE_RENDERER_PREFIX 10813
#define IDS_TASK_MANAGER_UNKNOWN_RENDERER_PREFIX 10814
#define IDS_TASK_MANAGER_DEDICATED_WORKER_PREFIX 10815
#define IDS_TASK_MANAGER_SHARED_WORKER_PREFIX 10816
#define IDS_TASK_MANAGER_SERVICE_WORKER_PREFIX 10817
#define IDS_TASK_MANAGER_UNKNOWN_PLUGIN_NAME 10818
#define IDS_TASK_MANAGER_UTILITY_PREFIX 10819
#define IDS_TASK_MANAGER_NACL_PREFIX 10820
#define IDS_TASK_MANAGER_NACL_BROKER_PREFIX 10821
#define IDS_TASK_MANAGER_GPU_PREFIX 10822
#define IDS_TASK_MANAGER_PRINT_PREFIX 10823
#define IDS_TASK_MANAGER_SUBFRAME_PREFIX 10824
#define IDS_TASK_MANAGER_SUBFRAME_INCOGNITO_PREFIX 10825
#define IDS_TASK_MANAGER_BACK_FORWARD_CACHE_SUBFRAME_PREFIX 10826
#define IDS_TASK_MANAGER_BACK_FORWARD_CACHE_INCOGNITO_SUBFRAME_PREFIX 10827
#define IDS_TASK_MANAGER_PORTAL_PREFIX 10828
#define IDS_TASK_MANAGER_PORTAL_INCOGNITO_PREFIX 10829
#define IDS_TASK_MANAGER_FENCED_FRAME_PREFIX 10830
#define IDS_TASK_MANAGER_FENCED_FRAME_INCOGNITO_PREFIX 10831
#define IDS_TASK_MANAGER_ARC_PREFIX 10832
#define IDS_TASK_MANAGER_TOOL_PREFIX 10833
#define IDS_TASK_MANAGER_ARC_PREFIX_BACKGROUND_SERVICE 10834
#define IDS_TASK_MANAGER_ARC_PREFIX_RECEIVER 10835
#define IDS_TASK_MANAGER_ARC_SYSTEM 10836
#define IDS_TASK_MANAGER_LINUX_VM_PREFIX 10837
#define IDS_TASK_MANAGER_PLUGIN_VM_PREFIX 10838
#define IDS_UTILITY_PROCESS_FILE_UTILITY_NAME 10840
#define IDS_UTILITY_PROCESS_PROFILE_IMPORTER_NAME 10841
#define IDS_UTILITY_PROCESS_QRCODE_GENERATOR_SERVICE_NAME 10842
#define IDS_UTILITY_PROCESS_IMAGE_WRITER_NAME 10844
#define IDS_UTILITY_PROCESS_MEDIA_GALLERY_UTILITY_NAME 10845
#define IDS_UTILITY_PROCESS_NOOP_SERVICE_NAME 10846
#define IDS_SERVICE_PROCESS_DOCUMENT_ANALYSIS_NAME 10847
#define IDS_THEME_INSTALL_INFOBAR_LABEL 10848
#define IDS_THEME_INSTALL_INFOBAR_UNDO_BUTTON 10849
#define IDS_CRITICAL_NOTIFICATION_RESTART 10850
#define IDS_EXTENSION_DISABLED_ERROR_LABEL 10851
#define IDS_EXTENSION_IS_BLOCKLISTED 10852
#define IDS_EXTENSION_DISABLED_REMOTE_INSTALL_ERROR_TITLE 10853
#define IDS_EXTENSION_DISABLED_ERROR_TITLE 10854
#define IDS_EXTENSION_SITE_RELOAD_PAGE_BUBBLE_HEADING 10855
#define IDS_EXTENSION_RELOAD_PAGE_BUBBLE_OK_BUTTON 10856
#define IDS_EXTENSION_RELOAD_PAGE_BUBBLE_ALLOW_SINGLE_EXTENSION_TITLE 10857
#define IDS_EXTENSION_RELOAD_PAGE_BUBBLE_ALLOW_MULTIPLE_EXTENSIONS_TITLE 10858
#define IDS_APP_UNINSTALL_PROMPT_TITLE 10859
#define IDS_ARC_APP_UNINSTALL_PROMPT_DATA_REMOVAL_WARNING 10860
#define IDS_EXTENSION_UNINSTALL_PROMPT_TITLE 10861
#define IDS_EXTENSION_CONFIRM_PERMISSIONS 10862
#define IDS_EXTENSION_DELEGATED_INSTALL_PROMPT_TITLE 10863
#define IDS_EXTENSION_INSTALL_PROMPT_TITLE 10864
#define IDS_EXTENSION_REQUEST_PROMPT_TITLE 10865
#define IDS_EXTENSION_PENDING_REQUEST_PROMPT_TITLE 10866
#define IDS_EXTENSION_BLOCKED_BY_POLICY_PROMPT_TITLE 10867
#define IDS_EXTENSION_RE_ENABLE_PROMPT_TITLE 10868
#define IDS_EXTENSION_PERMISSIONS_PROMPT_TITLE 10869
#define IDS_EXTENSION_REMOTE_INSTALL_PROMPT_TITLE 10870
#define IDS_EXTENSION_REPAIR_PROMPT_TITLE 10871
#define IDS_EXTENSION_EXTERNAL_INSTALL_PROMPT_TITLE_APP 10872
#define IDS_EXTENSION_EXTERNAL_INSTALL_PROMPT_TITLE_EXTENSION 10873
#define IDS_EXTENSION_EXTERNAL_INSTALL_PROMPT_TITLE_THEME 10874
#define IDS_EXTENSION_EXTERNAL_INSTALL_PROMPT_ACCEPT_BUTTON_EXTENSION 10875
#define IDS_EXTENSION_EXTERNAL_INSTALL_PROMPT_ACCEPT_BUTTON_APP 10876
#define IDS_EXTENSION_EXTERNAL_INSTALL_PROMPT_ACCEPT_BUTTON_THEME 10877
#define IDS_EXTENSION_EXTERNAL_INSTALL_PROMPT_ABORT_BUTTON 10878
#define IDS_EXTENSION_ALERT_TITLE 10879
#define IDS_APP_ALERT_TITLE 10880
#define IDS_EXTENSION_AND_APP_ALERT_TITLE 10881
#define IDS_POLICY_BLOCKED_EXTENSION_ALERT_TITLE 10882
#define IDS_POLICY_BLOCKED_EXTENSIONS_ALERT_ITEM_TITLE 10883
#define IDS_BLOCKLISTED_EXTENSIONS_ALERT_ITEM 10884
#define IDS_POLICY_BLOCKED_EXTENSION_ALERT_ITEM_DETAIL 10885
#define IDS_EXTENSION_ALERT_ITEM_OK 10886
#define IDS_EXTENSION_ALERT_ITEM_DETAILS 10887
#define IDS_EXTENSION_PROMPT_APP_CONNECT_FROM_INCOGNITO 10888
#define IDS_EXTENSION_PROMPT_EXTENSION_CONNECT_FROM_INCOGNITO 10889
#define IDS_EXTENSION_PROMPT_WILL_HAVE_ACCESS_TO 10890
#define IDS_EXTENSION_PROMPT_WILL_NOW_HAVE_ACCESS_TO 10891
#define IDS_EXTENSION_PROMPT_WANTS_ACCESS_TO 10892
#define IDS_EXTENSION_PROMPT_CAN_ACCESS 10893
#define IDS_EXTENSION_PROMPT_GRANT_PERMISSIONS_CHECKBOX 10894
#define IDS_EXTENSION_PROMPT_MESSAGE_FROM_ADMIN 10895
#define IDS_EXTENSION_PERMISSION_LINE 10896
#define IDS_EXTENSION_RATING_COUNT 10897
#define IDS_EXTENSION_PROMPT_RATING_ACCESSIBLE_TEXT 10898
#define IDS_EXTENSION_PROMPT_NO_RATINGS_ACCESSIBLE_TEXT 10899
#define IDS_EXTENSION_USER_COUNT 10900
#define IDS_EXTENSION_PROMPT_STORE_LINK 10901
#define IDS_EXTENSION_PROMPT_WARNING_FULL_ACCESS 10902
#define IDS_EXTENSION_PROMPT_WARNING_ALL_HOSTS 10903
#define IDS_EXTENSION_PROMPT_WARNING_ALL_HOSTS_READ_ONLY 10904
#define IDS_EXTENSION_PROMPT_WARNING_AUDIO_CAPTURE 10905
#define IDS_EXTENSION_PROMPT_WARNING_VIDEO_CAPTURE 10906
#define IDS_EXTENSION_PROMPT_WARNING_AUDIO_AND_VIDEO_CAPTURE 10907
#define IDS_EXTENSION_PROMPT_WARNING_BLUETOOTH 10908
#define IDS_EXTENSION_PROMPT_WARNING_BLUETOOTH_DEVICES 10909
#define IDS_EXTENSION_PROMPT_WARNING_BLUETOOTH_PRIVATE 10910
#define IDS_EXTENSION_PROMPT_WARNING_BLUETOOTH_SERIAL 10911
#define IDS_EXTENSION_PROMPT_WARNING_BOOKMARKS 10912
#define IDS_EXTENSION_PROMPT_WARNING_READING_LIST 10913
#define IDS_EXTENSION_PROMPT_WARNING_CLIPBOARD 10914
#define IDS_EXTENSION_PROMPT_WARNING_CLIPBOARD_READWRITE 10915
#define IDS_EXTENSION_PROMPT_WARNING_CLIPBOARD_WRITE 10916
#define IDS_EXTENSION_PROMPT_WARNING_DEBUGGER 10917
#define IDS_EXTENSION_PROMPT_WARNING_DECLARATIVE_WEB_REQUEST 10918
#define IDS_EXTENSION_PROMPT_WARNING_DECLARATIVE_NET_REQUEST 10919
#define IDS_EXTENSION_PROMPT_WARNING_DOCUMENT_SCAN 10920
#define IDS_EXTENSION_PROMPT_WARNING_ENTERPRISE_HARDWARE_PLATFORM 10921
#define IDS_EXTENSION_PROMPT_WARNING_FAVICON 10922
#define IDS_EXTENSION_PROMPT_WARNING_GEOLOCATION 10923
#define IDS_EXTENSION_PROMPT_WARNING_HISTORY_READ 10924
#define IDS_EXTENSION_PROMPT_WARNING_HISTORY_READ_ON_ALL_DEVICES 10925
#define IDS_EXTENSION_PROMPT_WARNING_HISTORY_WRITE_ON_ALL_DEVICES 10926
#define IDS_EXTENSION_PROMPT_WARNING_HOME_PAGE_SETTING_OVERRIDE 10927
#define IDS_EXTENSION_PROMPT_WARNING_1_HOST 10928
#define IDS_EXTENSION_PROMPT_WARNING_1_HOST_READ_ONLY 10929
#define IDS_EXTENSION_PROMPT_WARNING_2_HOSTS 10930
#define IDS_EXTENSION_PROMPT_WARNING_2_HOSTS_READ_ONLY 10931
#define IDS_EXTENSION_PROMPT_WARNING_3_HOSTS 10932
#define IDS_EXTENSION_PROMPT_WARNING_3_HOSTS_READ_ONLY 10933
#define IDS_EXTENSION_PROMPT_WARNING_HOSTS_LIST 10934
#define IDS_EXTENSION_PROMPT_WARNING_HOSTS_LIST_READ_ONLY 10935
#define IDS_EXTENSION_PROMPT_WARNING_HOST_AND_SUBDOMAIN 10936
#define IDS_EXTENSION_PROMPT_WARNING_HOST_AND_SUBDOMAIN_LIST 10937
#define IDS_EXTENSION_PROMPT_WARNING_INPUT 10938
#define IDS_EXTENSION_PROMPT_WARNING_LOGIN 10939
#define IDS_EXTENSION_PROMPT_WARNING_LOGIN_SCREEN_UI 10940
#define IDS_EXTENSION_PROMPT_WARNING_LOGIN_SCREEN_STORAGE 10941
#define IDS_EXTENSION_PROMPT_WARNING_MANAGEMENT 10942
#define IDS_EXTENSION_PROMPT_WARNING_MDNS 10943
#define IDS_EXTENSION_PROMPT_WARNING_NETWORK_STATE 10944
#define IDS_EXTENSION_PROMPT_WARNING_NETWORKING_PRIVATE 10945
#define IDS_EXTENSION_PROMPT_WARNING_PRINTING 10946
#define IDS_EXTENSION_PROMPT_WARNING_PRINTING_METRICS 10947
#define IDS_EXTENSION_PROMPT_WARNING_SEARCH_SETTINGS_OVERRIDE 10948
#define IDS_EXTENSION_PROMPT_WARNING_SERIAL 10949
#define IDS_EXTENSION_PROMPT_WARNING_SOCKET_ANY_HOST 10950
#define IDS_EXTENSION_PROMPT_WARNING_SOCKET_HOSTS_IN_DOMAIN 10951
#define IDS_EXTENSION_PROMPT_WARNING_SOCKET_HOSTS_IN_DOMAINS 10952
#define IDS_EXTENSION_PROMPT_WARNING_SOCKET_SPECIFIC_HOST 10953
#define IDS_EXTENSION_PROMPT_WARNING_SOCKET_SPECIFIC_HOSTS 10954
#define IDS_EXTENSION_PROMPT_WARNING_SPEECH_RECOGNITION 10955
#define IDS_EXTENSION_PROMPT_WARNING_START_PAGE_SETTING_OVERRIDE 10956
#define IDS_EXTENSION_PROMPT_WARNING_SYSTEM_STORAGE 10957
#define IDS_EXTENSION_PROMPT_WARNING_TAB_GROUPS 10958
#define IDS_EXTENSION_PROMPT_WARNING_TOPSITES 10959
#define IDS_EXTENSION_PROMPT_WARNING_TTS_ENGINE 10960
#define IDS_EXTENSION_PROMPT_WARNING_U2F_DEVICES 10961
#define IDS_EXTENSION_PROMPT_WARNING_NOTIFICATIONS 10962
#define IDS_EXTENSION_PROMPT_WARNING_USB_DEVICE 10963
#define IDS_EXTENSION_PROMPT_WARNING_USB_DEVICE_LIST 10964
#define IDS_EXTENSION_PROMPT_WARNING_USB_DEVICE_LIST_ITEM_UNKNOWN_PRODUCT 10965
#define IDS_EXTENSION_PROMPT_WARNING_USB_DEVICE_LIST_ITEM_UNKNOWN_VENDOR 10966
#define IDS_EXTENSION_PROMPT_WARNING_USB_DEVICE_UNKNOWN_PRODUCT 10967
#define IDS_EXTENSION_PROMPT_WARNING_USB_DEVICE_UNKNOWN_VENDOR 10968
#define IDS_EXTENSION_PROMPT_WARNING_VPN 10969
#define IDS_EXTENSION_PROMPT_WARNING_CONTENT_SETTINGS 10970
#define IDS_EXTENSION_PROMPT_WARNING_PRIVACY 10971
#define IDS_EXTENSION_PROMPT_WARNING_DOWNLOADS 10972
#define IDS_EXTENSION_PROMPT_WARNING_DOWNLOADS_OPEN 10973
#define IDS_EXTENSION_PROMPT_WARNING_IDENTITY_EMAIL 10974
#define IDS_EXTENSION_PROMPT_WARNING_WALLPAPER 10975
#define IDS_EXTENSION_PROMPT_WARNING_FILE_SYSTEM_DIRECTORY 10976
#define IDS_EXTENSION_PROMPT_WARNING_FILE_SYSTEM_WRITE_DIRECTORY 10977
#define IDS_EXTENSION_PROMPT_WARNING_MEDIA_GALLERIES_READ 10978
#define IDS_EXTENSION_PROMPT_WARNING_MEDIA_GALLERIES_READ_WRITE 10979
#define IDS_EXTENSION_PROMPT_WARNING_MEDIA_GALLERIES_READ_DELETE 10980
#define IDS_EXTENSION_PROMPT_WARNING_MEDIA_GALLERIES_READ_WRITE_DELETE 10981
#define IDS_EXTENSION_PROMPT_WARNING_SYNCFILESYSTEM 10982
#define IDS_EXTENSION_PROMPT_WARNING_NATIVE_MESSAGING 10983
#define IDS_EXTENSION_PROMPT_WARNING_SCREENLOCK_PRIVATE 10984
#define IDS_EXTENSION_PROMPT_WARNING_ACTIVITY_LOG_PRIVATE 10985
#define IDS_EXTENSION_PROMPT_WARNING_DESKTOP_CAPTURE 10986
#define IDS_EXTENSION_PROMPT_WARNING_ACCESSIBILITY_FEATURES_MODIFY 10987
#define IDS_EXTENSION_PROMPT_WARNING_ACCESSIBILITY_FEATURES_READ 10988
#define IDS_EXTENSION_PROMPT_WARNING_ACCESSIBILITY_FEATURES_READ_MODIFY 10989
#define IDS_EXTENSION_PROMPT_WARNING_PLATFORMKEYS 10990
#define IDS_EXTENSION_PROMPT_WARNING_CERTIFICATEPROVIDER 10991
#define IDS_EXTENSION_PROMPT_WARNING_SETTINGS_PRIVATE 10992
#define IDS_EXTENSION_PROMPT_WARNING_AUTOFILL_PRIVATE 10993
#define IDS_EXTENSION_PROMPT_WARNING_PASSWORDS_PRIVATE 10994
#define IDS_EXTENSION_PROMPT_WARNING_USERS_PRIVATE 10995
#define IDS_EXTENSION_PROMPT_WARNING_NEW_TAB_PAGE_OVERRIDE 10996
#define IDS_EXTENSION_PROMPT_WARNING_TRANSIENT_BACKGROUND 10997
#define IDS_EXTENSION_PROMPT_WARNING_ENTERPRISE_DEVICE_ATTRIBUTES 10998
#define IDS_EXTENSION_PROMPT_WARNING_ENTERPRISE_KIOSK_INPUT 10999
#define IDS_EXTENSION_PROMPT_WARNING_ENTERPRISE_NETWORKING_ATTRIBUTES 11000
#define IDS_EXTENSION_PROMPT_WARNING_ENTERPRISE_PLATFORMKEYS 11001
#define IDS_EXTENSION_PROMPT_WARNING_ENTERPRISE_REPORTING_PRIVATE_ENABLED_LINUX_AND_MACOS 11003
#define IDS_EXTENSION_PROMPT_WARNING_ENTERPRISE_REPORTING_PRIVATE 11004
#define IDS_EXTENSION_PROMPT_WARNING_ENTERPRISE_REMOTE_APPS 11005
#define IDS_EXTENSION_PROMPT_WARNING_CHROMEOS_ATTACHED_DEVICE_INFO 11006
#define IDS_EXTENSION_PROMPT_WARNING_CHROMEOS_BLUETOOTH_PERIPHERALS_INFO 11007
#define IDS_EXTENSION_PROMPT_WARNING_CHROMEOS_DIAGNOSTICS 11008
#define IDS_EXTENSION_PROMPT_WARNING_CHROMEOS_DIAGNOSTICS_NETWORK_INFO_FOR_MLAB 11009
#define IDS_EXTENSION_PROMPT_WARNING_CHROMEOS_EVENTS 11010
#define IDS_EXTENSION_PROMPT_WARNING_CHROMEOS_MANAGEMENT_AUDIO 11011
#define IDS_EXTENSION_PROMPT_WARNING_CHROMEOS_TELEMETRY 11012
#define IDS_EXTENSION_PROMPT_WARNING_CHROMEOS_TELEMETRY_SERIAL_NUMBER 11013
#define IDS_EXTENSION_PROMPT_WARNING_CHROMEOS_TELEMETRY_NETWORK_INFORMATION 11014
#define IDS_EXTENSION_CANT_DOWNGRADE_VERSION 11015
#define IDS_APP_CANT_DOWNGRADE_VERSION 11016
#define IDS_EXTENSION_MOVE_DIRECTORY_TO_PROFILE_FAILED 11019
#define IDS_EXTENSION_INSTALL_NOT_ENABLED 11020
#define IDS_EXTENSION_INSTALL_INCORRECT_APP_CONTENT_TYPE 11021
#define IDS_EXTENSION_INSTALL_INCORRECT_INSTALL_HOST 11022
#define IDS_EXTENSION_INSTALL_UNEXPECTED_ID 11023
#define IDS_EXTENSION_INSTALL_DISALLOWED_ON_SITE 11024
#define IDS_EXTENSION_INSTALL_UNEXPECTED_VERSION 11025
#define IDS_EXTENSION_INSTALL_DEPENDENCY_OLD_VERSION 11026
#define IDS_EXTENSION_INSTALL_DEPENDENCY_NOT_SHARED_MODULE 11027
#define IDS_EXTENSION_INSTALL_DEPENDENCY_NOT_ALLOWLISTED 11028
#define IDS_EXTENSION_INSTALL_GALLERY_ONLY 11029
#define IDS_EXTENSION_INSTALL_KIOSK_MODE_ONLY 11030
#define IDS_EXTENSION_OVERLAPPING_WEB_EXTENT 11031
#define IDS_EXTENSION_INVALID_IMAGE_PATH 11032
#define IDS_EXTENSION_INSTALLED_PAGE_ACTION_INFO 11035
#define IDS_EXTENSION_INSTALLED_PAGE_ACTION_INFO_WITH_SHORTCUT 11036
#define IDS_EXTENSION_INSTALLED_BROWSER_ACTION_INFO 11037
#define IDS_EXTENSION_INSTALLED_BROWSER_ACTION_INFO_WITH_SHORTCUT 11038
#define IDS_EXTENSION_INSTALLED_OMNIBOX_KEYWORD_INFO 11039
#define IDS_EXTENSION_INSTALLED_MANAGE_INFO 11040
#define IDS_EXTENSION_INSTALLED_MANAGE_SHORTCUTS 11041
#define IDS_EXTENSION_LAUNCH_WEB_AUTH_FLOW_TAB_INFO_BAR_TEXT 11042
#define IDS_EXTENSION_INSTALLED_DICE_PROMO_SYNC_MESSAGE 11043
#define IDS_EXTENSIONS_DIRECTORY_CONFIRMATION_DIALOG_TITLE 11044
#define IDS_EXTENSIONS_DIRECTORY_CONFIRMATION_DIALOG_MESSAGE_READ_ONLY 11045
#define IDS_EXTENSIONS_DIRECTORY_CONFIRMATION_DIALOG_MESSAGE_WRITABLE 11046
#define IDS_DIRECT_SOCKETS_CONNECTION_BUBBLE_TITLE_LABEL 11047
#define IDS_DIRECT_SOCKETS_CONNECTION_BUBBLE_ADDRESS_LABEL 11048
#define IDS_DIRECT_SOCKETS_CONNECTION_BUBBLE_PORT_LABEL 11049
#define IDS_EXTENSIONS_LOAD_ERROR_ALERT_HEADING 11050
#define IDS_EXTENSIONS_LOAD_ERROR_MESSAGE 11051
#define IDS_EXTENSIONS_WANTS_ACCESS_TO_SITE 11052
#define IDS_EXTENSIONS_HAS_ACCESS_TO_SITE 11053
#define IDS_EXTENSIONS_REQUEST_ACCESS_BUTTON 11054
#define IDS_EXTENSIONS_REQUEST_ACCESS_BUTTON_DISMISSED_TEXT 11055
#define IDS_EXTENSIONS_REQUEST_ACCESS_BUTTON_TOOLTIP_SINGLE_EXTENSION 11056
#define IDS_EXTENSIONS_REQUEST_ACCESS_BUTTON_TOOLTIP_MULTIPLE_EXTENSIONS 11057
#define IDS_EXTENSIONS_TOOLBAR_ACTION_HOVER_CARD_TITLE_HAS_ACCESS 11058
#define IDS_EXTENSIONS_TOOLBAR_ACTION_HOVER_CARD_TITLE_BLOCKED_ACCESS 11059
#define IDS_EXTENSIONS_TOOLBAR_ACTION_HOVER_CARD_TITLE_REQUESTS_ACCESS 11060
#define IDS_EXTENSIONS_TOOLBAR_ACTION_HOVER_CARD_DESCRIPTION_ALL_EXTENSIONS_ALLOWED_ACCESS 11061
#define IDS_EXTENSIONS_TOOLBAR_ACTION_HOVER_CARD_DESCRIPTION_ALL_EXTENSIONS_BLOCKED_ACCESS 11062
#define IDS_EXTENSIONS_TOOLBAR_ACTION_HOVER_CARD_DESCRIPTION_EXTENSION_HAS_ACCESS 11063
#define IDS_EXTENSIONS_TOOLBAR_ACTION_HOVER_CARD_DESCRIPTION_EXTENSION_REQUESTS_ACCESS 11064
#define IDS_EXTENSIONS_TOOLBAR_ACTION_HOVER_CARD_POLICY_LABEL_PINNED_TEXT 11065
#define IDS_EXTENSIONS_TOOLBAR_ACTION_HOVER_CARD_POLICY_LABEL_INSTALLED_TEXT 11066
#define IDS_EXTENSIONS_CONTEXT_MENU_SITE_PERMISSIONS 11067
#define IDS_EXTENSIONS_CONTEXT_MENU_CANT_ACCESS_PAGE 11068
#define IDS_EXTENSIONS_CONTEXT_MENU_PAGE_ACCESS 11069
#define IDS_EXTENSIONS_CONTEXT_MENU_PAGE_ACCESS_ALL_EXTENSIONS_GRANTED 11070
#define IDS_EXTENSIONS_CONTEXT_MENU_PAGE_ACCESS_ALL_EXTENSIONS_BLOCKED 11071
#define IDS_EXTENSIONS_CONTEXT_MENU_PAGE_ACCESS_RUN_ON_CLICK_V2 11072
#define IDS_EXTENSIONS_CONTEXT_MENU_PAGE_ACCESS_RUN_ON_SITE_V2 11073
#define IDS_EXTENSIONS_CONTEXT_MENU_PAGE_ACCESS_RUN_ON_ALL_SITES_V2 11074
#define IDS_EXTENSIONS_CONTEXT_MENU_PAGE_ACCESS_PERMISSIONS_PAGE 11075
#define IDS_EXTENSIONS_CONTEXT_MENU_PAGE_ACCESS_RUN_ON_CLICK 11076
#define IDS_EXTENSIONS_CONTEXT_MENU_PAGE_ACCESS_RUN_ON_SITE 11077
#define IDS_EXTENSIONS_CONTEXT_MENU_PAGE_ACCESS_RUN_ON_ALL_SITES 11078
#define IDS_EXTENSIONS_CONTEXT_MENU_PAGE_ACCESS_LEARN_MORE 11079
#define IDS_EXTENSIONS_CONTEXT_MENU_PIN_TO_TOOLBAR 11080
#define IDS_EXTENSIONS_CONTEXT_MENU_UNPIN_FROM_TOOLBAR 11081
#define IDS_EXTENSIONS_OPTIONS_MENU_ITEM 11082
#define IDS_EXTENSIONS_INSTALLED_BY_ADMIN 11083
#define IDS_EXTENSIONS_DISABLE 11084
#define IDS_EXTENSIONS_PIN_TO_TOOLBAR 11085
#define IDS_EXTENSIONS_UNPIN_FROM_TOOLBAR 11086
#define IDS_EXTENSIONS_PINNED_BY_ADMIN 11087
#define IDS_EXTENSIONS_PIN_TO_TOOLBAR_ACCESSIBLE_NAME 11088
#define IDS_EXTENSIONS_UNPIN_FROM_TOOLBAR_ACCESSIBLE_NAME 11089
#define IDS_EXTENSIONS_PINNED_BY_ADMIN_ACCESSIBLE_NAME 11090
#define IDS_EXTENSIONS_SUBMENU_OPEN_SIDE_PANEL_ITEM 11091
#define IDS_EXTENSIONS_SUBMENU_CLOSE_SIDE_PANEL_ITEM 11092
#define IDS_MANAGE_EXTENSION 11093
#define IDS_MANAGE_EXTENSIONS 11094
#define IDS_VIEW_WEB_PERMISSIONS 11095
#define IDS_EXTENSION_ACTION_INSPECT_POPUP 11096
#define IDS_EXTENSIONS_LOCKED_SUPERVISED_USER 11100
#define IDS_EXTENSION_LOAD_FROM_DIRECTORY 11101
#define IDS_EXTENSION_COMMANDS_GENERIC_ACTIVATE 11102
#define IDS_EXTENSIONS_SUPERVISED_USER_PARENTAL_PERMISSION_FAILURE 11103
#define IDS_EXTENSION_PACK_DIALOG_HEADING 11104
#define IDS_EXTENSION_PACK_DIALOG_SELECT_KEY 11105
#define IDS_EXTENSION_PACK_DIALOG_KEY_FILE_TYPE_DESCRIPTION 11106
#define IDS_EXTENSION_PACK_DIALOG_ERROR_ROOT_REQUIRED 11107
#define IDS_EXTENSION_PACK_DIALOG_ERROR_ROOT_INVALID 11108
#define IDS_EXTENSION_PACK_DIALOG_ERROR_KEY_INVALID 11109
#define IDS_EXTENSION_PACK_DIALOG_SUCCESS_BODY_NEW 11110
#define IDS_EXTENSION_PACK_DIALOG_SUCCESS_BODY_UPDATE 11111
#define IDS_EXTENSION_PROMPT_INSTALL_FRICTION_CONTINUE_BUTTON 11112
#define IDS_EXTENSION_PROMPT_INSTALL_FRICTION_TITLE 11113
#define IDS_EXTENSION_PROMPT_INSTALL_FRICTION_WARNING_TEXT 11114
#define IDS_EXTENSION_PROMPT_INSTALL_BUTTON 11115
#define IDS_EXTENSION_INSTALL_PROMPT_ACCEPT_BUTTON_EXTENSION 11116
#define IDS_EXTENSION_INSTALL_PROMPT_ACCEPT_BUTTON_APP 11117
#define IDS_EXTENSION_INSTALL_PROMPT_ACCEPT_BUTTON_THEME 11118
#define IDS_EXTENSION_INSTALL_PROMPT_ASK_A_PARENT_BUTTON 11119
#define IDS_EXTENSION_INSTALL_BLOCKED_BY_PARENT_PROMPT_TITLE 11120
#define IDS_EXTENSION_ENABLE_BLOCKED_BY_PARENT_PROMPT_TITLE 11121
#define IDS_PARENT_PERMISSION_PROMPT_GO_GET_A_PARENT_FOR_EXTENSION_LABEL 11122
#define IDS_PARENT_PERMISSION_PROMPT_EXTENSION_TYPE_EXTENSION 11123
#define IDS_PARENT_PERMISSION_PROMPT_EXTENSION_TYPE_APP 11124
#define IDS_PARENT_PERMISSION_PROMPT_CHILD_WANTS_TO_INSTALL_LABEL 11125
#define IDS_PARENT_PERMISSION_PROMPT_APPROVE_BUTTON 11126
#define IDS_PARENT_PERMISSION_PROMPT_CANCEL_BUTTON 11127
#define IDS_PARENT_PERMISSION_PROMPT_SELECT_PARENT_LABEL 11128
#define IDS_PARENT_PERMISSION_PROMPT_PARENT_ACCOUNT_LABEL 11129
#define IDS_PARENT_PERMISSION_PROMPT_PARENT_ACCOUNT_VERIFY_LABEL 11130
#define IDS_PARENT_PROMPT_ENTER_PASSWORD_TO_ALLOW_EXTENSION_LABEL 11131
#define IDS_SKIP_PARENT_PERMISSION_EXTENSION_INFORMATION 11132
#define IDS_PARENT_PERMISSION_PROMPT_ENTER_PASSWORD_LABEL 11133
#define IDS_PARENT_PERMISSION_PROMPT_PASSWORD_INCORRECT_LABEL 11134
#define IDS_EXTENSION_INSTALL_PROMPT_REQUEST_BUTTON 11135
#define IDS_EXTENSION_PROMPT_UNINSTALL_BUTTON 11136
#define IDS_EXTENSION_PROMPT_UNINSTALL_REPORT_ABUSE 11137
#define IDS_EXTENSION_PROMPT_UNINSTALL_REPORT_ABUSE_FROM_EXTENSION 11138
#define IDS_EXTENSION_PROMPT_UNINSTALL_TITLE 11139
#define IDS_EXTENSION_PROMPT_UNINSTALL_APP_BUTTON 11140
#define IDS_EXTENSION_PROMPT_MULTIPLE_UNINSTALL_NAME_BULLET_POINT 11141
#define IDS_EXTENSION_PROMPT_MULTIPLE_UNINSTALL_TITLE 11142
#define IDS_EXTENSION_PROMPT_UNINSTALL_TRIGGERED_BY_EXTENSION 11143
#define IDS_EXTENSION_PROMPT_RE_ENABLE_BUTTON 11144
#define IDS_EXTENSION_PROMPT_PERMISSIONS_BUTTON 11145
#define IDS_EXTENSION_PROMPT_PERMISSIONS_ACCEPT_BUTTON 11146
#define IDS_EXTENSION_PROMPT_PERMISSIONS_ABORT_BUTTON 11147
#define IDS_EXTENSION_PROMPT_REMOTE_INSTALL_BUTTON_EXTENSION 11148
#define IDS_EXTENSION_PROMPT_REMOTE_INSTALL_BUTTON_APP 11149
#define IDS_EXTENSION_PROMPT_REPAIR_BUTTON_EXTENSION 11150
#define IDS_EXTENSION_PROMPT_REPAIR_BUTTON_APP 11151
#define IDS_EXTENSION_WEB_STORE_TITLE 11152
#define IDS_EXTENSION_WEB_STORE_TITLE_SHORT 11153
#define IDS_EXTENSIONS_SHOW_DETAILS 11154
#define IDS_EXTENSIONS_HIDE_DETAILS 11155
#define IDS_WEBSTORE_DOWNLOAD_ACCESS_DENIED 11156
#define IDS_EXTENSION_WARNINGS_WRENCH_MENU_ITEM 11157
#define IDS_EXTENSION_EXTERNAL_INSTALL_ALERT_EXTENSION 11158
#define IDS_EXTENSION_EXTERNAL_INSTALL_ALERT_APP 11159
#define IDS_EXTENSION_EXTERNAL_INSTALL_ALERT_THEME 11160
#define IDS_EXTENSION_EXTERNAL_INSTALL_ALERT_BUBBLE_TITLE 11161
#define IDS_EXTENSION_EXTERNAL_INSTALL_ALERT_BUBBLE_HEADING_APP 11162
#define IDS_EXTENSION_EXTERNAL_INSTALL_ALERT_BUBBLE_HEADING_EXTENSION 11163
#define IDS_EXTENSION_EXTERNAL_INSTALL_ALERT_BUBBLE_HEADING_THEME 11164
#define IDS_EXTENSIONS_ADDED_WITHOUT_KNOWLEDGE 11165
#define IDS_EXTENSIONS_ADDED_WITHOUT_KNOWLEDGE_LEARN_MORE 11166
#define IDS_EXTENSION_SETTINGS_OVERRIDDEN_DIALOG_CHANGE_IT_BACK 11167
#define IDS_EXTENSION_SETTINGS_OVERRIDDEN_DIALOG_KEEP_IT 11168
#define IDS_EXTENSION_NTP_OVERRIDDEN_DIALOG_TITLE_GENERIC 11169
#define IDS_EXTENSION_NTP_OVERRIDDEN_DIALOG_TITLE_BACK_TO_GOOGLE 11170
#define IDS_EXTENSION_NTP_OVERRIDDEN_DIALOG_BODY_GENERIC 11171
#define IDS_EXTENSION_SEARCH_OVERRIDDEN_DIALOG_TITLE_GENERIC 11172
#define IDS_EXTENSION_SEARCH_OVERRIDDEN_DIALOG_TITLE_BACK_TO_GOOGLE 11173
#define IDS_EXTENSION_SEARCH_OVERRIDDEN_DIALOG_TITLE_BACK_TO_OTHER 11174
#define IDS_EXTENSION_SEARCH_OVERRIDDEN_DIALOG_BODY_GENERIC 11175
#define IDS_FORCE_INSTALLED_DEPRECATED_APPS_CONTENT 11176
#define IDS_FORCE_INSTALLED_PREINSTALLED_DEPRECATED_APPS_TITLE 11177
#define IDS_FORCE_INSTALLED_PREINSTALLED_DEPRECATED_APPS_CONTENT 11178
#define IDS_FORCE_INSTALLED_PREINSTALLED_DEPRECATED_APPS_GO_TO_SITE_BUTTON 11179
#define IDS_DEPRECATED_APPS_RENDERER_TITLE_PLURAL 11180
#define IDS_DEPRECATED_APPS_RENDERER_TITLE_WITH_APP_NAME 11181
#define IDS_DEPRECATED_APPS_MONITOR_RENDERER 11182
#define IDS_DEPRECATED_APPS_LEARN_MORE 11183
#define IDS_DEPRECATED_APPS_LEARN_MORE_AX_LABEL 11184
#define IDS_DEPRECATED_APPS_DELETION_LINK 11185
#define IDS_DEPRECATED_APPS_OK_LABEL 11186
#define IDS_DEPRECATED_APPS_CANCEL_LABEL 11187
#define IDS_EXTENSIONS_MENU_TITLE 11188
#define IDS_EXTENSIONS_MENU_CONTEXT_MENU_TOOLTIP 11189
#define IDS_EXTENSIONS_MENU_CONTEXT_MENU_TOOLTIP_ACCESSIBLE_NAME 11190
#define IDS_EXTENSIONS_MENU_PIN_BUTTON_TOOLTIP 11191
#define IDS_EXTENSIONS_MENU_UNPIN_BUTTON_TOOLTIP 11192
#define IDS_EXTENSIONS_MENU_ACCESSING_SITE_DATA_SHORT 11193
#define IDS_EXTENSIONS_MENU_ACCESSING_SITE_DATA 11194
#define IDS_EXTENSIONS_MENU_WANTS_TO_ACCESS_SITE_DATA_SHORT 11195
#define IDS_EXTENSIONS_MENU_WANTS_TO_ACCESS_SITE_DATA 11196
#define IDS_EXTENSIONS_MENU_CANT_ACCESS_SITE_DATA_SHORT 11197
#define IDS_EXTENSIONS_MENU_CANT_ACCESS_SITE_DATA 11198
#define IDS_EXTENSIONS_MENU_SITE_SETTINGS_TOGGLE_ON_TOOLTIP 11199
#define IDS_EXTENSIONS_MENU_SITE_SETTINGS_TOGGLE_OFF_TOOLTIP 11200
#define IDS_EXTENSIONS_MENU_SITE_SETTINGS_TOGGLE_ACCESSIBLE_NAME 11201
#define IDS_EXTENSIONS_MENU_SITE_SETTINGS_TOGGLE_ON_ACCESSIBLE_NAME 11202
#define IDS_EXTENSIONS_MENU_SITE_SETTINGS_TOGGLE_OFF_ACCESSIBLE_NAME 11203
#define IDS_EXTENSIONS_MENU_MESSAGE_SECTION_RESTRICTED_ACCESS_TEXT 11204
#define IDS_EXTENSIONS_MENU_MESSAGE_SECTION_POLICY_BLOCKED_ACCESS_TEXT 11205
#define IDS_EXTENSIONS_MENU_MESSAGE_SECTION_USER_BLOCKED_ACCESS_TEXT 11206
#define IDS_EXTENSIONS_MENU_MESSAGE_SECTION_ENTERPRISE_TOOLTIP_ICON_TEXT 11207
#define IDS_EXTENSIONS_MENU_MESSAGE_SECTION_USER_CUSTOMIZED_ACCESS_TEXT 11208
#define IDS_EXTENSIONS_MENU_MESSAGE_SECTION_RELOAD_CONTAINER_DESCRIPTION_TEXT 11209
#define IDS_EXTENSIONS_MENU_MESSAGE_SECTION_RELOAD_CONTAINER_BUTTON_TEXT 11210
#define IDS_EXTENSIONS_MENU_MESSAGE_SECTION_RELOAD_CONTAINER_BUTTON_TOOLTIP 11211
#define IDS_EXTENSIONS_MENU_REQUESTS_ACCESS_SECTION_TITLE 11212
#define IDS_EXTENSIONS_MENU_REQUESTS_ACCESS_SECTION_ALLOW_BUTTON_TEXT 11213
#define IDS_EXTENSIONS_MENU_REQUESTS_ACCESS_SECTION_ALLOW_BUTTON_TOOLTIP 11214
#define IDS_EXTENSIONS_MENU_REQUESTS_ACCESS_SECTION_DISMISS_BUTTON_TEXT 11215
#define IDS_EXTENSIONS_MENU_REQUESTS_ACCESS_SECTION_DISMISS_BUTTON_TOOLTIP 11216
#define IDS_EXTENSIONS_MENU_EXTENSION_SITE_ACCESS_TOGGLE_ON_TOOLTIP 11217
#define IDS_EXTENSIONS_MENU_EXTENSION_SITE_ACCESS_TOGGLE_OFF_TOOLTIP 11218
#define IDS_EXTENSIONS_MENU_EXTENSION_SITE_ACCESS_TOGGLE_ACCESSIBLE_NAME 11219
#define IDS_EXTENSIONS_MENU_EXTENSION_CONTEXT_MENU_BUTTON_TOOLTIP 11220
#define IDS_EXTENSIONS_MENU_EXTENSION_CONTEXT_MENU_BUTTON_ACCESSIBLE_NAME 11221
#define IDS_EXTENSIONS_MENU_EXTENSION_CONTEXT_MENU_BUTTON_PINNED_ACCESSIBLE_NAME 11222
#define IDS_EXTENSIONS_MENU_MAIN_PAGE_EXTENSION_SITE_ACCESS_NONE 11223
#define IDS_EXTENSIONS_MENU_MAIN_PAGE_OPEN_CHROME_WEBSTORE_TOOLTIP 11224
#define IDS_EXTENSIONS_MENU_MAIN_PAGE_EXTENSION_SITE_ACCESS_TOOLTIP 11225
#define IDS_EXTENSIONS_MENU_MAIN_PAGE_ENTERPRISE_EXTENSION_SITE_ACCESS_TOOLTIP 11226
#define IDS_EXTENSIONS_MENU_MAIN_PAGE_EXTENSION_SITE_ACCESS_ACCESSIBLE_NAME 11227
#define IDS_EXTENSIONS_MENU_MAIN_PAGE_ENTERPRISE_EXTENSION_SITE_ACCESS_ACCESSIBLE_NAME 11228
#define IDS_EXTENSIONS_MENU_MAIN_PAGE_EXTENSION_BUTTON_HAS_ACCESS_TOOLTIP 11229
#define IDS_EXTENSIONS_MENU_MAIN_PAGE_EXTENSION_BUTTON_BLOCKED_ACCESS_TOOLTIP 11230
#define IDS_EXTENSIONS_MENU_MAIN_PAGE_EXTENSION_BUTTON_REQUESTS_TOOLTIP 11231
#define IDS_EXTENSIONS_MENU_MAIN_PAGE_EXTENSION_SITE_ACCESS_ON_CLICK 11232
#define IDS_EXTENSIONS_MENU_MAIN_PAGE_EXTENSION_SITE_ACCESS_ON_SITE 11233
#define IDS_EXTENSIONS_MENU_MAIN_PAGE_EXTENSION_SITE_ACCESS_ON_ALL_SITES 11234
#define IDS_EXTENSIONS_MENU_SITE_PERMISSIONS_PAGE_SETTINGS_BUTTON 11235
#define IDS_EXTENSIONS_MENU_SITE_PERMISSIONS_PAGE_SETTINGS_BUTTON_TOOLTIP 11236
#define IDS_EXTENSIONS_MENU_SITE_PERMISSIONS_PAGE_SHOW_REQUESTS_LABEL 11237
#define IDS_EXTENSIONS_MENU_SITE_PERMISSIONS_PAGE_SHOW_REQUESTS_TOGGLE_ON 11238
#define IDS_EXTENSIONS_MENU_SITE_PERMISSIONS_PAGE_SHOW_REQUESTS_TOGGLE_OFF 11239
#define IDS_EXTENSIONS_MENU_SITE_PERMISSIONS_PAGE_SITE_ACCESS_LABEL 11240
#define IDS_EXTENSIONS_MENU_SITE_PERMISSIONS_PAGE_SITE_ACCESS_ON_CLICK_TEXT 11241
#define IDS_EXTENSIONS_MENU_SITE_PERMISSIONS_PAGE_SITE_ACCESS_ON_SITE_TEXT 11242
#define IDS_EXTENSIONS_MENU_SITE_PERMISSIONS_PAGE_SITE_ACCESS_ON_ALL_SITES_TEXT 11243
#define IDS_EXTENSIONS_MENU_SITE_PERMISSIONS_PAGE_SITE_ACCESS_ON_CLICK_DESCRIPTION 11244
#define IDS_EXTENSIONS_MENU_SITE_PERMISSIONS_PAGE_SITE_ACCESS_ON_SITE_DESCRIPTION 11245
#define IDS_EXTENSIONS_MENU_SITE_PERMISSIONS_PAGE_SITE_ACCESS_ON_ALL_SITES_DESCRIPTION 11246
#define IDS_EXTENSIONS_SETTINGS_API_TITLE_HOME_PAGE_BUBBLE 11247
#define IDS_EXTENSIONS_SETTINGS_API_FIRST_LINE_HOME_PAGE_SPECIFIC 11248
#define IDS_EXTENSIONS_SETTINGS_API_FIRST_LINE_HOME_PAGE 11249
#define IDS_EXTENSIONS_SETTINGS_API_SECOND_LINE_SEARCH_ENGINE 11250
#define IDS_EXTENSIONS_PRINTING_API_PRINT_REQUEST_BUBBLE_TITLE 11251
#define IDS_EXTENSIONS_PRINTING_API_PRINT_REQUEST_BUBBLE_HEADING 11252
#define IDS_EXTENSIONS_PRINTING_API_PRINT_REQUEST_ALLOW 11253
#define IDS_EXTENSIONS_PRINTING_API_PRINT_REQUEST_DENY 11254
#define IDS_EXTENSIONS_DOCUMENT_SCAN_API_DISCOVERY_REQUEST_BUBBLE_TITLE 11255
#define IDS_EXTENSIONS_DOCUMENT_SCAN_API_DISCOVERY_REQUEST_BUBBLE_HEADING 11256
#define IDS_EXTENSIONS_DOCUMENT_SCAN_API_DISCOVERY_REQUEST_ALLOW 11257
#define IDS_EXTENSIONS_DOCUMENT_SCAN_API_DISCOVERY_REQUEST_DENY 11258
#define IDS_EXTENSIONS_DOCUMENT_SCAN_API_START_SCAN_REQUEST_BUBBLE_TITLE 11259
#define IDS_EXTENSIONS_DOCUMENT_SCAN_API_START_SCAN_REQUEST_BUBBLE_HEADING 11260
#define IDS_EXTENSIONS_DOCUMENT_SCAN_API_START_SCAN_REQUEST_ALLOW 11261
#define IDS_EXTENSIONS_DOCUMENT_SCAN_API_START_SCAN_REQUEST_DENY 11262
#define IDS_EXTENSIONS_NTP_CONTROLLED_FIRST_LINE 11263
#define IDS_EXTENSIONS_PROXY_CONTROLLED_FIRST_LINE 11264
#define IDS_EXTENSIONS_PROXY_CONTROLLED_FIRST_LINE_EXTENSION_SPECIFIC 11265
#define IDS_EXTENSIONS_SETTINGS_API_THIRD_LINE_CONFIRMATION 11266
#define IDS_EXTENSION_CONTROLLED_RESTORE_SETTINGS 11267
#define IDS_EXTENSION_CONTROLLED_KEEP_CHANGES 11268
#define IDS_SUB_APPS_INSTALL_DIALOG_TITLE 11269
#define IDS_SUB_APPS_INSTALL_DIALOG_DESCRIPTION 11270
#define IDS_SUB_APPS_INSTALL_DIALOG_PERMISSIONS_DESCRIPTION 11271
#define IDS_SUB_APPS_INSTALL_DIALOG_MANAGE_PERMISSIONS_LINK 11272
#define IDS_SUB_APPS_INSTALL_DIALOG_PERMISSIONS_BUTTON 11273
#define IDS_SUB_APPS_INSTALL_DIALOG_CANCEL_BUTTON 11274
#define IDS_WEB_APP_MENU_BUTTON_TOOLTIP 11275
#define IDS_WEB_APP_ENABLE_WINDOW_CONTROLS_OVERLAY_TOOLTIP 11276
#define IDS_WEB_APP_DISABLE_WINDOW_CONTROLS_OVERLAY_TOOLTIP 11277
#define IDS_WEB_APP_WINDOW_CONTROLS_OVERLAY_ENABLED_ALERT 11278
#define IDS_WEB_APP_WINDOW_CONTROLS_OVERLAY_DISABLED_ALERT 11279
#define IDS_APP_HOME_TITLE 11280
#define IDS_APP_HOME_OPEN_IN_WINDOW 11281
#define IDS_APP_HOME_LAUNCH_AT_STARTUP 11282
#define IDS_APP_HOME_CREATE_SHORTCUT 11283
#define IDS_APP_HOME_INSTALL_LOCALLY 11284
#define IDS_APP_HOME_UNINSTALL_APP 11285
#define IDS_APP_HOME_REMOVE_APP 11286
#define IDS_APP_HOME_APP_SETTINGS 11287
#define IDS_ACCNAME_APP_HOME_NOT_INSTALLED 11288
#define IDS_APP_HOME_APP_NO_APPS 11289
#define IDS_APP_HOME_APP_LEARN_INSTALL 11290
#define IDS_WEB_APP_SETTINGS_TITLE 11291
#define IDS_WEB_APP_SETTINGS_LINK 11292
#define IDS_WEB_APP_SETTINGS_LINK_TOOLTIP 11293
#define IDS_COMPONENTS_TITLE 11294
#define IDS_COMPONENTS_VERSION 11295
#define IDS_COMPONENTS_NONE_INSTALLED 11296
#define IDS_COMPONENTS_NO_COMPONENTS 11297
#define IDS_COMPONENTS_CHECK_FOR_UPDATE 11298
#define IDS_COMPONENTS_STATUS_LABEL 11299
#define IDS_COMPONENTS_CHECKING_LABEL 11300
#define IDS_COMPONENTS_SVC_STATUS_NEW 11304
#define IDS_COMPONENTS_SVC_STATUS_CHECKING 11305
#define IDS_COMPONENTS_SVC_STATUS_UPDATE 11306
#define IDS_COMPONENTS_SVC_STATUS_DNL_DIFF 11307
#define IDS_COMPONENTS_SVC_STATUS_DNL 11308
#define IDS_COMPONENTS_SVC_STATUS_DOWNLOADED 11309
#define IDS_COMPONENTS_SVC_STATUS_UPDT_DIFF 11310
#define IDS_COMPONENTS_SVC_STATUS_UPDATING 11311
#define IDS_COMPONENTS_SVC_STATUS_UPDATED 11312
#define IDS_COMPONENTS_SVC_STATUS_UPTODATE 11313
#define IDS_COMPONENTS_SVC_STATUS_UPDATE_ERROR 11314
#define IDS_COMPONENTS_UNKNOWN 11315
#define IDS_COMPONENTS_EVT_STATUS_STARTED 11316
#define IDS_COMPONENTS_EVT_STATUS_SLEEPING 11317
#define IDS_COMPONENTS_EVT_STATUS_FOUND 11318
#define IDS_COMPONENTS_EVT_STATUS_READY 11319
#define IDS_COMPONENTS_EVT_STATUS_UPDATED 11320
#define IDS_COMPONENTS_EVT_STATUS_ALREADY_UP_TO_DATE 11321
#define IDS_COMPONENTS_EVT_STATUS_UPDATE_ERROR 11322
#define IDS_COMPONENTS_EVT_STATUS_DOWNLOADING 11323
#define IDS_COMPONENTS_EVT_STATUS_UPDATING 11324
#define IDS_PASSWORD_MANAGER_ACCOUNT_CHOOSER_TITLE 11325
#define IDS_PASSWORD_GENERATION_SUGGESTION_GPM 11326
#define IDS_PASSWORD_GENERATION_SUGGESTION_GPM_WITHOUT_STRONG 11327
#define IDS_PASSWORD_GENERATION_SUGGESTION_TRUSTED_ADVICE 11328
#define IDS_PASSWORD_GENERATION_SUGGESTION_SAFETY_FIRST 11329
#define IDS_PASSWORD_GENERATION_SUGGESTION_TRY_SOMETHING_NEW 11330
#define IDS_PASSWORD_GENERATION_SUGGESTION_CONVENIENCE 11331
#define IDS_PASSWORD_GENERATION_EDIT_PASSWORD 11332
#define IDS_PASSWORD_GENERATION_NUDGE_CANCEL_BUTTON 11333
#define IDS_PASSWORD_MANAGER_CONFIRM_SAVED_TITLE 11334
#define IDS_PASSWORD_MANAGER_CONFIRM_UPDATE_TITLE 11335
#define IDS_PASSWORD_GENERATION_EDITING_SUGGESTION 11336
#define IDS_SAVE_PASSWORD 11337
#define IDS_SAVE_ACCOUNT 11338
#define IDS_ADD_USERNAME_TITLE 11339
#define IDS_ADD_USERNAME 11340
#define IDS_ADD_USERNAME_BODY 11341
#define IDS_UPDATE_PASSWORD 11342
#define IDS_VERIFY_IT_IS_YOU 11343
#define IDS_PASSWORD_ERROR_DESCRIPTION_SIGN_IN 11344
#define IDS_PASSWORD_ERROR_DESCRIPTION_SIGN_UP 11345
#define IDS_PASSWORD_ERROR_VERIFY_BUTTON_TITLE 11351
#define IDS_SAVE_PASSWORD_DIFFERENT_DOMAINS_TITLE 11353
#define IDS_UPDATE_PASSWORD_DIFFERENT_DOMAINS_TITLE 11354
#define IDS_SAVE_PASSWORD_FOOTER 11355
#define IDS_PASSWORD_BUBBLES_PASSWORD_MANAGER_LINK_TEXT_SYNCED_TO_ACCOUNT 11356
#define IDS_PASSWORD_BUBBLES_FOOTER_SYNCED_TO_ACCOUNT 11357
#define IDS_PASSWORD_BUBBLES_FOOTER_SAVING_ON_DEVICE 11358
#define IDS_PASSWORD_GENERATION_CONFIRMATION_GOOGLE_PASSWORD_MANAGER 11359
#define IDS_PASSWORD_GENERATION_PROMPT_GOOGLE_PASSWORD_MANAGER 11360
#define IDS_PASSWORD_GENERATION_HELP_TEXT_TRUSTED_ADVICE 11361
#define IDS_PASSWORD_GENERATION_HELP_TEXT_SAFETY_FIRST 11362
#define IDS_PASSWORD_GENERATION_HELP_TEXT_TRY_SOMETHING_NEW 11363
#define IDS_PASSWORD_GENERATION_HELP_TEXT_CONVENIENCE 11364
#define IDS_PASSWORD_GENERATION_NUDGE_TITLE 11365
#define IDS_PASSWORD_GENERATION_BENEFITS 11366
#define IDS_PASSWORD_GENERATION_CROSS_DEVICE 11367
#define IDS_PASSWORD_GENERATION_SECURITY 11368
#define IDS_PASSWORD_GENERATION_PROACTIVE_CHECK 11369
#define IDS_PASSWORD_GENERATION_HELP_TEXT 11370
#define IDS_PASSWORD_MANAGEMENT_BUBBLE_FOOTER_ACCOUNT_STORE_USERS 11371
#define IDS_PASSWORD_MANAGER_GENERATED_PASSWORD_SAVED_MESSAGE_DESCRIPTION 11372
#define IDS_PASSWORD_MANAGER_SAVE_PASSWORD_SIGNED_IN_MESSAGE_DESCRIPTION 11373
#define IDS_PASSWORD_MANAGER_UPDATE_PASSWORD_SIGNED_IN_MESSAGE_DESCRIPTION 11374
#define IDS_PASSWORD_CROSS_DOMAIN_FILLING_CONFIRMATION_TITLE 11375
#define IDS_PASSWORD_CROSS_DOMAIN_FILLING_CONFIRMATION_DESCRIPTION 11376
#define IDS_PASSWORD_CROSS_DOMAIN_FILLING_CONFIRMATION_CONFIRM_BUTTON_LABEL 11377
#define IDS_PASSWORD_MANAGER_ACCOUNT_CHOOSER_SIGN_IN 11378
#define IDS_PASSWORD_MANAGER_MANAGE_PASSWORDS_BUTTON 11379
#define IDS_PASSWORD_MANAGER_MANAGE_PASSWORD_BUTTON 11380
#define IDS_SETTINGS_PASSWORDS_ANDROID_APP 11381
#define IDS_SHARED_PASSWORDS_NOTIFICATION_GOT_IT_BUTTON 11382
#define IDS_SHARED_PASSWORDS_NOTIFICATION_TEXT_SINGLE_PASSWORD 11383
#define IDS_SHARED_PASSWORDS_NOTIFICATION_TEXT_MULTIPLE_PASSWORD 11384
#define IDS_SHARED_PASSWORDS_NOTIFICATION_TITLE 11385
#define IDS_PASSWORD_MANAGER_ONBOARDING_TITLE_A 11386
#define IDS_PASSWORD_MANAGER_ONBOARDING_TITLE_B 11387
#define IDS_PASSWORD_MANAGER_ONBOARDING_TITLE_C 11388
#define IDS_PASSWORD_MANAGER_ONBOARDING_DETAILS_A 11389
#define IDS_PASSWORD_MANAGER_ONBOARDING_DETAILS_B 11390
#define IDS_PASSWORD_MANAGER_DICE_PROMO_SIGNIN_MESSAGE 11391
#define IDS_PASSWORD_MANAGER_DICE_PROMO_SYNC_MESSAGE 11392
#define IDS_WEBRTC_LOGS_TITLE 11393
#define IDS_WEBRTC_TEXT_LOGS_LOG_COUNT_BANNER_FORMAT 11394
#define IDS_WEBRTC_EVENT_LOGS_LOG_COUNT_BANNER_FORMAT 11395
#define IDS_WEBRTC_LOGS_LOG_HEADER_FORMAT 11396
#define IDS_WEBRTC_LOGS_LOG_LOCAL_FILE_LABEL_FORMAT 11397
#define IDS_WEBRTC_LOGS_NO_LOCAL_LOG_FILE_MESSAGE 11398
#define IDS_WEBRTC_LOGS_LOG_UPLOAD_TIME_FORMAT 11399
#define IDS_WEBRTC_LOGS_LOG_FAILED_UPLOAD_TIME_FORMAT 11400
#define IDS_WEBRTC_LOGS_LOG_REPORT_ID_FORMAT 11401
#define IDS_WEBRTC_LOGS_BUG_LINK_LABEL 11402
#define IDS_WEBRTC_LOGS_LOG_PENDING_MESSAGE 11403
#define IDS_WEBRTC_LOGS_LOG_ACTIVELY_UPLOADED_MESSAGE 11404
#define IDS_WEBRTC_LOGS_LOG_NOT_UPLOADED_MESSAGE 11405
#define IDS_WEBRTC_LOGS_EVENT_LOG_LOCAL_LOG_ID 11406
#define IDS_WEBRTC_LOGS_NO_TEXT_LOGS_MESSAGE 11407
#define IDS_WEBRTC_LOGS_NO_EVENT_LOGS_MESSAGE 11408
#define IDS_PLUGIN_HIDE 11409
#define IDS_PLUGIN_BLOCKED 11410
#define IDS_PLUGIN_BLOCKED_BY_POLICY 11411
#define IDS_PLUGIN_NOT_AUTHORIZED 11413
#define IDS_PLUGIN_DISABLED 11414
#define IDS_PLUGIN_DEPRECATED 11415
#define IDS_SESSION_CRASHED_BUBBLE_TITLE 11416
#define IDS_SESSION_CRASHED_BUBBLE_UMA_LINK_TEXT 11417
#define IDS_IDLE_BUBBLE_TITLE_CLEAR 11418
#define IDS_SETTINGS_STORAGE_PRESSURE_BUBBLE_VIEW_TITLE 11419
#define IDS_SETTINGS_STORAGE_PRESSURE_BUBBLE_VIEW_MESSAGE 11420
#define IDS_SETTINGS_STORAGE_PRESSURE_BUBBLE_VIEW_BUTTON_LABEL 11421
#define IDS_BAD_FLAGS_WARNING_MESSAGE 11422
#define IDS_BAD_FEATURES_WARNING_MESSAGE 11423
#define IDS_BAD_ENVIRONMENT_VARIABLES_WARNING_MESSAGE 11424
#define IDS_BLOCKED_DISPLAYING_INSECURE_CONTENT_TITLE 11425
#define IDS_BLOCKED_DISPLAYING_INSECURE_CONTENT 11426
#define IDS_ALLOW_INSECURE_CONTENT_BUTTON 11427
#define IDS_ADD_TO_SHELF_INFOBAR_TITLE 11428
#define IDS_ADD_TO_SHELF_INFOBAR_ADD_BUTTON 11429
#define IDS_ABOUT_SYS_TITLE 11430
#define IDS_ABOUT_SYS_DESC 11431
#define IDS_ABOUT_SYS_TABLE_TITLE 11432
#define IDS_ABOUT_SYS_LOG_FILE_TABLE_TITLE 11433
#define IDS_ABOUT_SYS_EXPAND_ALL 11434
#define IDS_ABOUT_SYS_COLLAPSE_ALL 11435
#define IDS_ABOUT_SYS_EXPAND 11436
#define IDS_ABOUT_SYS_COLLAPSE 11437
#define IDS_ABOUT_SYS_PARSE_ERROR 11438
#define IDS_ABOUT_BROWSER_SWITCH_TITLE 11440
#define IDS_ABOUT_BROWSER_SWITCH_OPENING_TITLE_UNKNOWN_BROWSER 11441
#define IDS_ABOUT_BROWSER_SWITCH_OPENING_TITLE_KNOWN_BROWSER 11442
#define IDS_ABOUT_BROWSER_SWITCH_ERROR_TITLE_UNKNOWN_BROWSER 11443
#define IDS_ABOUT_BROWSER_SWITCH_ERROR_TITLE_KNOWN_BROWSER 11444
#define IDS_ABOUT_BROWSER_SWITCH_COUNTDOWN_TITLE_UNKNOWN_BROWSER 11445
#define IDS_ABOUT_BROWSER_SWITCH_COUNTDOWN_TITLE_KNOWN_BROWSER 11446
#define IDS_ABOUT_BROWSER_SWITCH_GENERIC_ERROR_UNKNOWN_BROWSER 11447
#define IDS_ABOUT_BROWSER_SWITCH_GENERIC_ERROR_KNOWN_BROWSER 11448
#define IDS_ABOUT_BROWSER_SWITCH_PROTOCOL_ERROR 11449
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_DESC 11450
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_TITLE 11451
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_NOTHING_SHOWN 11452
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_LBS_DISABLED 11453
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_URL_CHECKER_TITLE 11454
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_URL_CHECKER_DESC 11455
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_OPEN_BROWSER 11456
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_OPEN_BROWSER_PROTOCOL_REASON 11457
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_OPEN_BROWSER_RULE_REASON 11458
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_OPEN_BROWSER_INVERT_RULE_REASON 11459
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_OPEN_BROWSER_DEFAULT_REASON 11460
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_INVALID_URL 11461
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_XML_TITLE 11462
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_XML_DESC 11463
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_XML_SOURCE 11464
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_XML_NOT_CONFIGURED 11465
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_XML_SITELIST_NOT_FETCHED 11466
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_XML_SITELIST_DOWNLOAD_BUTTON 11467
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_XML_SITELIST_LAST_DOWNLOAD_DATE 11468
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_XML_SITELIST_NEXT_DOWNLOAD_DATE 11469
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_FORCE_OPEN_IN_TITLE 11470
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_FORCE_OPEN_IN_DESCRIPTION 11471
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_FORCE_OPEN_IN_FIRST_PARAGRAPH 11472
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_FORCE_OPEN_IN_SECOND_PARAGRAPH 11473
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_FORCE_OPEN_TABLE_COLUMN_RULE 11474
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_FORCE_OPEN_TABLE_COLUMN_OPENS_IN 11475
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_FORCE_OPEN_TABLE_COLUMN_SOURCE 11476
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_IGNORE_TITLE 11477
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_IGNORE_DESCRIPTION 11478
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_IGNORE_FIRST_PARAGRAPH 11479
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_IGNORE_SECOND_PARAGRAPH 11480
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_IGNORE_TABLE_COLUMN_RULE 11481
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_IGNORE_TABLE_COLUMN_SOURCE 11482
#define IDS_NACL_APP_MISSING_ARCH_MESSAGE 11486
#define IDS_OMNIBOX_PLACEHOLDER_TEXT 11491
#define IDS_PASTE_AND_GO 11492
#define IDS_PASTE_AND_SEARCH 11493
#define IDS_PASTE_AND_GO_EMPTY 11494
#define IDS_OMNIBOX_KEYWORD_HINT 11495
#define IDS_OMNIBOX_EXTENSION_KEYWORD_HINT 11496
#define IDS_OMNIBOX_KEYWORD_HINT_KEY_ACCNAME 11497
#define IDS_OMNIBOX_KEYWORD_HINT_TOUCH 11498
#define IDS_OMNIBOX_EXTENSION_KEYWORD_HINT_TOUCH 11499
#define IDS_OMNIBOX_KEYWORD_TEXT 11500
#define IDS_OMNIBOX_KEYWORD_TEXT_MD 11501
#define IDS_OMNIBOX_CLEAR_ALL 11502
#define IDS_OMNIBOX_WHY_THIS_SUGGESTION 11503
#define IDS_OMNIBOX_REMOVE_SUGGESTION 11504
#define IDS_OMNIBOX_REMOVE_SUGGESTION_BUBBLE_TITLE 11505
#define IDS_OMNIBOX_REMOVE_SUGGESTION_BUBBLE_DESCRIPTION 11506
#define IDS_CONTEXT_MENU_SHOW_FULL_URLS 11507
#define IDS_CONTEXT_MENU_SHOW_GOOGLE_LENS_SHORTCUT 11508
#define IDS_GOOGLE_SEARCH_BOX_EMPTY_HINT_MD 11509
#define IDS_GOOGLE_SEARCH_BOX_EMPTY_HINT_SHORT 11510
#define IDS_GOOGLE_SEARCH_BOX_EMPTY_HINT_MULTIMODAL 11511
#define IDS_NTP_CUSTOM_LINKS_ADD_SHORTCUT_TOOLTIP 11512
#define IDS_NTP_CUSTOM_LINKS_ADD_SHORTCUT_TITLE 11513
#define IDS_NTP_CUSTOM_LINKS_EDIT_SHORTCUT_TOOLTIP 11514
#define IDS_NTP_CUSTOM_LINKS_EDIT_SHORTCUT 11515
#define IDS_NTP_CUSTOM_LINKS_MORE_ACTIONS 11516
#define IDS_UPLOAD_IMAGE_FORMAT 11517
#define IDS_NTP_CUSTOM_LINKS_NAME 11518
#define IDS_NTP_CUSTOM_LINKS_URL 11519
#define IDS_NTP_CUSTOM_LINKS_REMOVE 11520
#define IDS_NTP_CUSTOM_LINKS_CANCEL 11521
#define IDS_NTP_CUSTOM_LINKS_DONE 11522
#define IDS_NTP_CUSTOM_LINKS_INVALID_URL 11523
#define IDS_NTP_CUSTOM_LINKS_CANT_CREATE 11524
#define IDS_NTP_CUSTOM_LINKS_CANT_EDIT 11525
#define IDS_NTP_CUSTOM_LINKS_CANT_REMOVE 11526
#define IDS_NTP_CONFIRM_MSG_SHORTCUT_REMOVED 11527
#define IDS_NTP_CONFIRM_MSG_SHORTCUT_EDITED 11528
#define IDS_NTP_CONFIRM_MSG_SHORTCUT_ADDED 11529
#define IDS_NTP_CUSTOM_LINKS_ALREADY_EXISTS 11530
#define IDS_NTP_CONFIRM_MSG_RESTORE_DEFAULTS 11531
#define IDS_NTP_CUSTOM_BG_CHROME_WALLPAPERS 11532
#define IDS_NTP_CUSTOM_BG_UPLOAD_AN_IMAGE 11533
#define IDS_NTP_CUSTOM_BG_SELECT_A_COLLECTION 11534
#define IDS_NTP_CUSTOM_BG_DAILY_REFRESH 11535
#define IDS_NTP_CUSTOM_BG_RESTORE_DEFAULT 11536
#define IDS_NTP_CUSTOM_BG_CANCEL 11537
#define IDS_NTP_CONNECTION_ERROR_NO_PERIOD 11538
#define IDS_NTP_CONNECTION_ERROR 11539
#define IDS_NTP_ERROR_MORE_INFO 11540
#define IDS_NTP_CUSTOM_BG_BACKGROUNDS_UNAVAILABLE 11541
#define IDS_NTP_CUSTOM_BG_BACK_LABEL 11542
#define IDS_NTP_CUSTOM_BG_IMAGE_SELECTED 11543
#define IDS_NTP_CUSTOM_BG_CUSTOMIZE_NTP_LABEL 11544
#define IDS_NTP_CUSTOM_BG_CUSTOMIZE_NTP_WALLPAPER_SEARCH_LABEL 11545
#define IDS_NTP_DISMISS_PROMO 11546
#define IDS_NTP_DOODLE_SHARE_LABEL 11547
#define IDS_NTP_DOODLE_SHARE_DIALOG_CLOSE_LABEL 11548
#define IDS_NTP_DOODLE_SHARE_DIALOG_FACEBOOK_LABEL 11549
#define IDS_NTP_DOODLE_SHARE_DIALOG_TWITTER_LABEL 11550
#define IDS_NTP_DOODLE_SHARE_DIALOG_MAIL_LABEL 11551
#define IDS_NTP_DOODLE_SHARE_DIALOG_COPY_LABEL 11552
#define IDS_NTP_DOODLE_SHARE_DIALOG_LINK_LABEL 11553
#define IDS_NTP_CUSTOMIZE_APPEARANCE_LABEL 11554
#define IDS_NTP_CUSTOMIZE_THEMES_HEADER 11555
#define IDS_NTP_CUSTOMIZE_MENU_BACKGROUND_LABEL 11556
#define IDS_NTP_CUSTOMIZE_MENU_BACKGROUND_DISABLED_LABEL 11557
#define IDS_NTP_CUSTOMIZE_MENU_SHORTCUTS_LABEL 11558
#define IDS_NTP_CUSTOMIZE_MENU_TOOLBAR_LABEL 11559
#define IDS_NTP_CUSTOMIZE_MENU_MODULES_LABEL 11560
#define IDS_NTP_CUSTOMIZE_MENU_COLOR_LABEL 11561
#define IDS_NTP_CUSTOMIZE_NO_BACKGROUND_LABEL 11562
#define IDS_NTP_CUSTOMIZE_CHROME_CHANGE_THEME_LABEL 11563
#define IDS_NTP_CUSTOMIZE_CHROME_RESET_TO_CLASSIC_CHROME_LABEL 11564
#define IDS_NTP_CUSTOMIZE_CHROME_FOLLOW_THEME_LABEL 11565
#define IDS_NTP_CUSTOMIZE_UPLOADED_IMAGE_LABEL 11566
#define IDS_NTP_CUSTOMIZE_YOUR_UPLOADED_IMAGE_LABEL 11567
#define IDS_NTP_CUSTOMIZE_YOUR_SEARCHED_IMAGE_LABEL 11568
#define IDS_NTP_CUSTOMIZE_UPLOAD_FROM_DEVICE_LABEL 11569
#define IDS_NTP_CUSTOMIZE_CHROME_CURRENT_THEME_LABEL 11570
#define IDS_NTP_CUSTOMIZE_HIDE_SHORTCUTS_LABEL 11571
#define IDS_NTP_CUSTOMIZE_HIDE_SHORTCUTS_DESC 11572
#define IDS_NTP_CUSTOMIZE_SHOW_CARDS_LABEL 11573
#define IDS_NTP_CUSTOMIZE_SHOW_SHORTCUTS_LABEL 11574
#define IDS_NTP_CUSTOMIZE_MY_SHORTCUTS_LABEL 11575
#define IDS_NTP_CUSTOMIZE_MOST_VISITED_LABEL 11576
#define IDS_NTP_CUSTOMIZE_MOST_VISITED_DESC 11577
#define IDS_NTP_CUSTOMIZE_MY_SHORTCUTS_DESC 11578
#define IDS_NTP_CUSTOMIZE_HIDE_ALL_CARDS_LABEL 11579
#define IDS_NTP_CUSTOMIZE_CUSTOMIZE_CARDS_LABEL 11580
#define IDS_NTP_CUSTOMIZE_3PT_THEME_DESC 11581
#define IDS_NTP_CUSTOMIZE_3PT_THEME_UNINSTALL 11582
#define IDS_NTP_CUSTOMIZE_COLOR_PICKER_LABEL 11583
#define IDS_NTP_CUSTOMIZE_COLOR_HUE_SLIDER_TITLE 11584
#define IDS_NTP_CUSTOMIZE_COLOR_HUE_SLIDER_DELETE_TITLE 11585
#define IDS_NTP_CUSTOMIZE_COLOR_HUE_SLIDER_DELETE_A11Y_LABEL 11586
#define IDS_NTP_THEME_MANAGED_DIALOG_TITLE 11587
#define IDS_NTP_THEME_MANAGED_DIALOG_BODY 11588
#define IDS_NTP_THEMES_CONTAINER_LABEL 11589
#define IDS_NTP_CUSTOMIZE_DEFAULT_LABEL 11590
#define IDS_NTP_CUSTOMIZE_GREY_DEFAULT_LABEL 11591
#define IDS_NTP_COLORS_WARM_GREY 11592
#define IDS_NTP_COLORS_COOL_GREY 11593
#define IDS_NTP_COLORS_MIDNIGHT_BLUE 11594
#define IDS_NTP_COLORS_BLACK 11595
#define IDS_NTP_COLORS_BEIGE_AND_WHITE 11596
#define IDS_NTP_COLORS_YELLOW_AND_WHITE 11597
#define IDS_NTP_COLORS_GREEN_AND_WHITE 11598
#define IDS_NTP_COLORS_LIGHT_TEAL_AND_WHITE 11599
#define IDS_NTP_COLORS_LIGHT_PURPLE_AND_WHITE 11600
#define IDS_NTP_COLORS_PINK_AND_WHITE 11601
#define IDS_NTP_COLORS_BEIGE 11602
#define IDS_NTP_COLORS_ORANGE 11603
#define IDS_NTP_COLORS_LIGHT_GREEN 11604
#define IDS_NTP_COLORS_LIGHT_TEAL 11605
#define IDS_NTP_COLORS_LIGHT_BLUE 11606
#define IDS_NTP_COLORS_PINK 11607
#define IDS_NTP_COLORS_DARK_PINK_AND_RED 11608
#define IDS_NTP_COLORS_DARK_RED_AND_ORANGE 11609
#define IDS_NTP_COLORS_DARK_GREEN 11610
#define IDS_NTP_COLORS_DARK_TEAL 11611
#define IDS_NTP_COLORS_DARK_BLUE 11612
#define IDS_NTP_COLORS_DARK_PURPLE 11613
#define IDS_NTP_COLORS_BLUE 11614
#define IDS_NTP_COLORS_GREY 11615
#define IDS_NTP_COLORS_AQUA 11616
#define IDS_NTP_COLORS_GREEN 11617
#define IDS_NTP_COLORS_VIRIDIAN 11618
#define IDS_NTP_COLORS_CITRON 11619
#define IDS_NTP_COLORS_APRICOT 11620
#define IDS_NTP_COLORS_ROSE 11621
#define IDS_NTP_COLORS_FUCHSIA 11622
#define IDS_NTP_COLORS_VIOLET 11623
#define IDS_NTP_UNDO_DISMISS_PROMO_BUTTON_TOAST 11624
#define IDS_NTP_CUSTOMIZE_CHROME_COLOR_SCHEME_MODE_GROUP_LABEL 11625
#define IDS_NTP_CUSTOMIZE_CHROME_COLOR_SCHEME_MODE_LIGHT_LABEL 11626
#define IDS_NTP_CUSTOMIZE_CHROME_COLOR_SCHEME_MODE_DARK_LABEL 11627
#define IDS_NTP_CUSTOMIZE_CHROME_COLOR_SCHEME_MODE_SYSTEM_LABEL 11628
#define IDS_NTP_CUSTOMIZE_CHROME_WEBSTORE_LABEL 11629
#define IDS_NTP_WEBSTORE_SHOPPING_CATEOGRY_LABEL 11630
#define IDS_NTP_WEBSTORE_WRITTING_HELP_COLLECTION_LABEL 11631
#define IDS_NTP_WEBSTORE_PRODUCTIVITY_CATEOGRY_LABEL 11632
#define IDS_NTP_WEBSTORE_TOAST_MESSAGE 11633
#define IDS_NTP_WEBSTORE_TOAST_BUTTON_TEXT 11634
#define IDS_NTP_WALLPAPER_SEARCH_FEEDBACK_PLACEHOLDER 11635
#define IDS_NTP_WALLPAPER_SEARCH_GENERIC_ERROR_DESCRIPTION 11636
#define IDS_NTP_WALLPAPER_SEARCH_GENERIC_ERROR_DESCRIPTION_WITH_HISTORY 11637
#define IDS_NTP_WALLPAPER_SEARCH_GENERIC_ERROR_DESCRIPTION_WITH_INSPIRATION 11638
#define IDS_NTP_WALLPAPER_SEARCH_GENERIC_ERROR_DESCRIPTION_WITH_HISTORY_AND_INSPIRATION 11639
#define IDS_NTP_WALLPAPER_SEARCH_GENERIC_ERROR_TITLE 11640
#define IDS_NTP_WALLPAPER_SEARCH_TILE_LABEL 11641
#define IDS_NTP_WALLPAPER_SEARCH_PAGE_HEADER 11642
#define IDS_NTP_WALLPAPER_SEARCH_HISTORY_HEADER 11643
#define IDS_NTP_WALLPAPER_SEARCH_OFFLINE_DESCRIPTION 11644
#define IDS_NTP_WALLPAPER_SEARCH_OFFLINE_DESCRIPTION_WITH_HISTORY 11645
#define IDS_NTP_WALLPAPER_SEARCH_OFFLINE_TITLE 11646
#define IDS_NTP_WALLPAPER_SEARCH_OPTIONAL_DETAILS_LABEL 11647
#define IDS_NTP_WALLPAPER_SEARCH_COLOR_RED_LABEL 11648
#define IDS_NTP_WALLPAPER_SEARCH_COLOR_BLUE_LABEL 11649
#define IDS_NTP_WALLPAPER_SEARCH_COLOR_YELLOW_LABEL 11650
#define IDS_NTP_WALLPAPER_SEARCH_COLOR_GREEN_LABEL 11651
#define IDS_NTP_WALLPAPER_SEARCH_COLOR_BLACK_LABEL 11652
#define IDS_NTP_WALLPAPER_SEARCH_REQUEST_THROTTLED_DESCRIPTION 11653
#define IDS_NTP_WALLPAPER_SEARCH_REQUEST_THROTTLED_TITLE 11654
#define IDS_NTP_WALLPAPER_SEARCH_SUBMIT_BTN_TEXT 11655
#define IDS_NTP_WALLPAPER_SEARCH_TRY_AGAIN_CTA 11656
#define IDS_NTP_WALLPAPER_SEARCH_HISTORY_RESULT_LABEL_NO_DESCRIPTOR 11657
#define IDS_NTP_WALLPAPER_SEARCH_HISTORY_RESULT_LABEL 11658
#define IDS_NTP_WALLPAPER_SEARCH_HISTORY_RESULT_LABEL_WITH_DESCRIPTOR_B 11659
#define IDS_NTP_WALLPAPER_SEARCH_HISTORY_RESULT_LABEL_WITH_DESCRIPTOR_C 11660
#define IDS_NTP_WALLPAPER_SEARCH_HISTORY_RESULT_LABEL_WITH_DESCRIPTORS_B_AND_C 11661
#define IDS_NTP_WALLPAPER_SEARCH_RESULT_LABEL 11662
#define IDS_NTP_WALLPAPER_SEARCH_RESULT_LABEL_WITH_DESCRIPTOR_B 11663
#define IDS_NTP_WALLPAPER_SEARCH_RESULT_LABEL_WITH_DESCRIPTOR_C 11664
#define IDS_NTP_WALLPAPER_SEARCH_RESULT_LABEL_WITH_DESCRIPTORS_B_AND_C 11665
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_LABEL 11666
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_DEFAULT_OPTION_LABEL 11667
#define IDS_NTP_WALLPAPER_SEARCH_MOOD_LABEL 11668
#define IDS_NTP_WALLPAPER_SEARCH_MOOD_DEFAULT_OPTION_LABEL 11669
#define IDS_NTP_WALLPAPER_SEARCH_STYLE_LABEL 11670
#define IDS_NTP_WALLPAPER_SEARCH_STYLE_DEFAULT_OPTION_LABEL 11671
#define IDS_LEARN_MORE_ABOUT_FEATURE_A11Y_LABEL 11672
#define IDS_THUMBS_DOWN_OPENS_FEEDBACK_FORM_A11Y_LABEL 11673
#define IDS_THUMBS_UP_RESULTS_A11Y_LABEL 11674
#define IDS_NTP_WALLPAPER_SEARCH_INSPIRATION_HEADER 11675
#define IDS_NTP_WALLPAPER_SEARCH_LOADING_A11Y_MESSAGE 11676
#define IDS_NTP_WALLPAPER_SEARCH_SUCCESS_A11Y_MESSAGE 11677
#define IDS_NTP_WALLPAPER_SEARCH_DISCLAIMER 11678
#define IDS_NTP_WALLPAPER_SEARCH_INSPIRATION_CARD_TOGGLE_TITLE 11679
#define IDS_NTP_WALLPAPER_SEARCH_DESCRIPTORS_CHANGED_A11Y_MESSAGE 11680
#define IDS_NTP_WALLPAPER_SEARCH_SIGNED_OUT_DESCRIPTION 11681
#define IDS_NTP_WALLPAPER_SEARCH_SIGNED_OUT_TITLE 11682
#define IDS_NTP_CUSTOMIZE_TOOLBAR_CHOOSE_ICONS_HEADER 11683
#define IDS_NTP_CUSTOMIZE_TOOLBAR_CATEGORY_NAVIGATION 11684
#define IDS_NTP_CUSTOMIZE_TOOLBAR_CATEGORY_YOUR_CHROME 11685
#define IDS_NTP_CUSTOMIZE_TOOLBAR_CATEGORY_SIDE_PANELS 11686
#define IDS_NTP_CUSTOMIZE_TOOLBAR_CATEGORY_TOOLS_AND_ACTIONS 11687
#define IDS_NTP_MODULES_INFO_BUTTON_TITLE 11688
#define IDS_NTP_MODULES_DISMISS_TOAST_MESSAGE 11689
#define IDS_NTP_MODULES_DISABLE_TOAST_MESSAGE 11690
#define IDS_NTP_MODULES_HISTORY_CLUSTERS_DISABLE_TOAST_MESSAGE 11691
#define IDS_NTP_MODULES_DISMISS_BUTTON_TEXT 11692
#define IDS_NTP_MODULES_DRIVE_MORE_ACTIONS_BUTTON_TEXT 11693
#define IDS_NTP_MODULES_DISABLE_BUTTON_TEXT 11694
#define IDS_NTP_MODULES_DISABLE_BUTTON_TEXT_V2 11695
#define IDS_NTP_MODULES_MORE_ACTIONS 11696
#define IDS_NTP_MODULES_CUSTOMIZE_BUTTON_TEXT 11697
#define IDS_NTP_MODULES_STATEFUL_TASKS_VIEWED_TODAY 11698
#define IDS_NTP_MODULES_STATEFUL_TASKS_VIEWED_YESTERDAY 11699
#define IDS_NTP_MODULES_STATEFUL_TASKS_VIEWED_PAST_WEEK 11700
#define IDS_NTP_MODULES_STATEFUL_TASKS_VIEWED_PAST_MONTH 11701
#define IDS_NTP_MODULES_STATEFUL_TASKS_VIEWED_PREVIOUSLY 11702
#define IDS_NTP_MODULES_SHOPPING_TASKS_SENTENCE 11703
#define IDS_NTP_MODULES_SHOPPING_TASKS_LOWER 11704
#define IDS_NTP_MODULES_RECIPE_INFO 11705
#define IDS_NTP_MODULES_RECIPE_EXTENDED_INFO 11706
#define IDS_NTP_MODULES_RECIPE_TASKS_SENTENCE 11707
#define IDS_NTP_MODULES_RECIPE_TASKS_LOWER 11708
#define IDS_NTP_MODULES_RECIPE_TASKS_LOWER_THESE 11709
#define IDS_NTP_MODULES_RECIPE_VIEWED_TASKS_SENTENCE 11710
#define IDS_NTP_MODULES_RECIPE_VIEWED_TASKS_LOWER 11711
#define IDS_NTP_MODULES_RECIPE_VIEWED_TASKS_LOWER_THESE 11712
#define IDS_NTP_MODULES_CART_SENTENCE 11713
#define IDS_NTP_MODULES_CART_SENTENCE_V2 11714
#define IDS_NTP_MODULES_CART_LOWER 11715
#define IDS_NTP_MODULES_CART_LOWER_THESE 11716
#define IDS_NTP_MODULES_CART_LOWER_YOUR 11717
#define IDS_NTP_MODULES_QUEST_CART_ANNOTATION 11718
#define IDS_NTP_MODULES_QUEST_CART_TILE_LABEL_PLURAL 11719
#define IDS_NTP_MODULES_QUEST_CART_TILE_LABEL_SINGULAR 11720
#define IDS_NTP_MODULES_QUEST_CART_TILE_LABEL_DEFAULT 11721
#define IDS_NTP_MODULES_CART_INFO 11722
#define IDS_NTP_MODULES_CART_ITEM_COUNT_SINGULAR 11723
#define IDS_NTP_MODULES_CART_ITEM_COUNT_MULTIPLE 11724
#define IDS_NTP_MODULES_DRIVE_DISABLE_BUTTON_TEXT 11725
#define IDS_NTP_MODULES_DRIVE_DISABLE_BUTTON_TEXT_V2 11726
#define IDS_NTP_MODULES_DRIVE_DISMISS_BUTTON_TEXT 11727
#define IDS_NTP_MODULES_DRIVE_SENTENCE 11728
#define IDS_NTP_MODULES_DRIVE_SENTENCE2 11729
#define IDS_NTP_MODULES_DRIVE_FILES_SENTENCE 11730
#define IDS_NTP_MODULES_DUMMY_LOWER 11731
#define IDS_NTP_MODULES_DUMMY_TITLE 11732
#define IDS_NTP_MODULES_DRIVE_TITLE 11733
#define IDS_NTP_MODULES_DRIVE_TITLE_V2 11734
#define IDS_NTP_MODULES_DRIVE_INFO 11735
#define IDS_NTP_MODULES_GOOGLE_CALENDAR_DISMISS_BUTTON_TEXT 11736
#define IDS_NTP_MODULES_GOOGLE_CALENDAR_DISMISS_TOAST_MESSAGE 11737
#define IDS_NTP_MODULES_GOOGLE_CALENDAR_DISABLE_TOAST_MESSAGE 11738
#define IDS_NTP_MODULES_GOOGLE_CALENDAR_MORE_ACTIONS 11739
#define IDS_NTP_MODULES_GOOGLE_CALENDAR_TITLE 11740
#define IDS_NTP_MODULES_GOOGLE_CALENDAR_DISABLE_BUTTON_TEXT 11741
#define IDS_NTP_MODULES_OUTLOOK_CALENDAR_TITLE 11742
#define IDS_NTP_MODULES_OUTLOOK_CALENDAR_DISABLE_BUTTON_TEXT 11743
#define IDS_NTP_MODULES_CALENDAR_JOIN_MEETING_BUTTON_TEXT 11744
#define IDS_NTP_MODULES_CALENDAR_IN_PROGRESS 11745
#define IDS_NTP_MODULES_CALENDAR_IN_X_MIN 11746
#define IDS_NTP_MODULES_CALENDAR_IN_X_HR 11747
#define IDS_NTP_MODULES_CALENDAR_SEE_MORE 11748
#define IDS_NTP_MODULES_PHOTOS_TITLE 11749
#define IDS_NTP_MODULES_PHOTOS_MEMORIES_TITLE 11750
#define IDS_NTP_MODULES_PHOTOS_MEMORIES_HIDE_TODAY 11751
#define IDS_NTP_MODULES_PHOTOS_MEMORIES_HIDDEN_TODAY 11752
#define IDS_NTP_MODULES_PHOTOS_SOFT_OPT_OUT 11753
#define IDS_NTP_MODULES_PHOTOS_MEMORIES_DISABLE 11754
#define IDS_NTP_MODULES_PHOTOS_MEMORIES_DISABLED 11755
#define IDS_NTP_MODULES_PHOTOS_INFO 11756
#define IDS_NTP_MODULES_PHOTOS_MEMORIES_EXPLORE 11757
#define IDS_NTP_MODULES_PHOTOS_MEMORIES_WELCOME_TITLE 11758
#define IDS_NTP_MODULES_PHOTOS_MEMORIES_PERSONALIZED_WELCOME_TITLE_TEMPLATE 11759
#define IDS_NTP_MODULES_PHOTOS_MEMORIES_RH_WELCOME_TITLE 11760
#define IDS_NTP_MODULES_PHOTOS_MEMORIES_FAVORITE_PEOPLE_WELCOME_TITLE 11761
#define IDS_NTP_MODULES_PHOTOS_MEMORIES_TRIPS_WELCOME_TITLE 11762
#define IDS_NTP_MODULES_PHOTOS_MEMORIES_WELCOME_TEXT 11763
#define IDS_NTP_MODULES_PHOTOS_MEMORIES_WELCOME_BUTTON_OPT_IN 11764
#define IDS_NTP_MODULES_PHOTOS_MEMORIES_WELCOME_BUTTON_OPT_OUT 11765
#define IDS_NTP_MODULES_PHOTOS_MEMORIES_WELCOME_BUTTON_SOFT_OPT_OUT 11766
#define IDS_NTP_MODULES_PHOTOS_MEMORIES_WELCOME_EXAMPLE 11767
#define IDS_NTP_MODULES_PHOTOS_BALOON_ILLUSTRATION_TITLE 11768
#define IDS_NTP_MODULES_PHOTOS_NEW 11769
#define IDS_NTP_MODULES_KALEIDOSCOPE_TITLE 11770
#define IDS_NTP_MODULES_SHOPPING_TASKS_INFO_TITLE 11771
#define IDS_NTP_MODULES_TASKS_INFO 11772
#define IDS_NTP_MODULES_SHOPPING_TASKS_INFO_CLOSE 11773
#define IDS_NTP_MODULES_SHOPPING_TASKS_RELATED 11774
#define IDS_NTP_MODULES_RECIPE_TASKS_RECOMMENDED 11775
#define IDS_NTP_MODULES_CART_WARM_WELCOME 11776
#define IDS_NTP_MODULES_CART_MODULE_MENU_HIDE_TOAST_MESSAGE 11777
#define IDS_NTP_MODULES_CART_CART_MENU_HIDE_MERCHANT 11778
#define IDS_NTP_MODULES_CART_CART_MENU_HIDE_MERCHANT_TOAST_MESSAGE 11779
#define IDS_NTP_MODULES_CART_CART_MENU_REMOVE_MERCHANT 11780
#define IDS_NTP_MODULES_CART_CART_MENU_REMOVE_MERCHANT_TOAST_MESSAGE 11781
#define IDS_NTP_MODULES_CART_DISCOUNT_CHIP_AMOUNT 11782
#define IDS_NTP_MODULES_CART_DISCOUNT_CHIP_UP_TO_AMOUNT 11783
#define IDS_NTP_MODULES_CART_DISCOUNT_CONSENT_CONTENT 11784
#define IDS_NTP_MODULES_CART_DISCOUNT_CONSENT_ACCEPT 11785
#define IDS_NTP_MODULES_CART_DISCOUNT_CONSENT_ACCEPT_CONFIRMATION 11786
#define IDS_NTP_MODULES_CART_DISCOUNT_CONSENT_REJECT 11787
#define IDS_NTP_MODULES_CART_DISCOUNT_CONSENT_REJECT_CONFIRMATION 11788
#define IDS_NTP_MODULES_CART_DISCOUNT_CONSENT_CONFIRMATION_DISMISS 11789
#define IDS_NTP_MODULES_CART_DISCOUNT_CONSENT_CONTENT_V2 11790
#define IDS_NTP_MODULES_CART_DISCOUNT_CONSENT_CONTENT_V3 11791
#define IDS_NTP_MODULES_CART_DISCOUNT_CONSENT_STEP_1_WITH_MERCHANT_NAME 11792
#define IDS_NTP_MODULES_CART_DISCOUNT_CONSENT_STEP_1_WITH_TWO_MERCHANT_NAMES 11793
#define IDS_NTP_MODULES_CART_DISCOUNT_CONSENT_STEP_1_WITH_THREE_MERCHANT_NAMES 11794
#define IDS_NTP_MODULES_CART_DISCOUNT_CONSENT_STEP_1_CONTINUE 11795
#define IDS_NTP_MODULES_CART_DISCOUNT_CONSENT_TITLE 11796
#define IDS_NTP_MODULES_CUSTOMIZE_IPH 11797
#define IDS_NTP_MODULES_NEW_TAG_LABEL 11798
#define IDS_NTP_MODULES_FIRST_RUN_EXPERIENCE_TITLE 11799
#define IDS_NTP_MODULES_FIRST_RUN_EXPERIENCE_BODY_LINE_1 11800
#define IDS_NTP_MODULES_FIRST_RUN_EXPERIENCE_BODY_LINE_2 11801
#define IDS_NTP_MODULES_FIRST_RUN_EXPERIENCE_OPT_IN 11802
#define IDS_NTP_MODULES_FIRST_RUN_EXPERIENCE_OPT_OUT 11803
#define IDS_NTP_MODULES_FIRST_RUN_EXPERIENCE_OPT_OUT_TOAST 11804
#define IDS_NTP_MODULES_FEED_TITLE 11805
#define IDS_NTP_MODULES_HISTORY_CLUSTERS_RESUME_BROWSING 11806
#define IDS_NTP_MODULES_HISTORY_CLUSTERS_RESUME_BROWSING_FOR 11807
#define IDS_NTP_MODULES_SHOW_ALL 11808
#define IDS_NTP_MODULES_HISTORY_CLUSTERS_BOOKMARKED 11809
#define IDS_NTP_MODULES_HISTORY_CLUSTERS_INFO 11810
#define IDS_NTP_MODULES_HISTORY_CLUSTERS_WITH_DISCOUNT_INFO 11811
#define IDS_NTP_MODULES_HISTORY_CLUSTERS_SENTENCE2 11812
#define IDS_NTP_MODULES_HISTORY_CLUSTERS_DISABLE_TOAST_NAME 11813
#define IDS_NTP_MODULES_HISTORY_CLUSTERS_DISMISS_BUTTON 11814
#define IDS_NTP_MODULES_HISTORY_CLUSTERS_DISABLE_DROPDOWN_TEXT 11815
#define IDS_NTP_MODULES_HISTORY_CLUSTERS_DONE_BUTTON 11816
#define IDS_NTP_MODULES_HISTORY_CLUSTERS_OPEN_ALL_IN_NEW_TAB_GROUP_BUTTON_TEXT 11817
#define IDS_NTP_MODULES_HISTORY_CLUSTERS_SHOW_ALL_BUTTON 11818
#define IDS_ACCNAME_SHOW_ALL 11819
#define IDS_ACCNAME_SEARCH_SUGG 11820
#define IDS_NTP_MODULES_TAB_RESUMPTION_DISMISS_BUTTON 11821
#define IDS_NTP_TAB_RESUMPTION_TITLE 11822
#define IDS_NTP_MODULES_TAB_RESUMPTION_INFO 11823
#define IDS_NTP_MODULES_TAB_RESUMPTION_SENTENCE 11824
#define IDS_NTP_MODULES_TAB_RESUMPTION_RECENTLY_OPENED 11825
#define IDS_NTP_MODULES_TAB_RESUMPTION_DEVICE_PREFIX 11826
#define IDS_NTP_MODULES_MOST_RELEVANT_TAB_RESUMPTION_DISMISS_BUTTON 11827
#define IDS_NTP_MODULES_MOST_RELEVANT_TAB_RESUMPTION_TITLE 11828
#define IDS_NTP_MODULES_MOST_RELEVANT_TAB_RESUMPTION_SEE_MORE 11829
#define IDS_EXTENSIONS_PROMO_PERFORMANCE 11830
#define IDS_EXTENSIONS_PROMO_PRIVACY 11831
#define IDS_EXTENSIONS_PROMO_NEUTRAL 11832
#define IDS_STAR_VIEW_MENU_ADD_BOOKMARK 11833
#define IDS_STAR_VIEW_MENU_EDIT_BOOKMARK 11834
#define IDS_STAR_VIEW_MENU_MOVE_TO_READ_LATER 11835
#define IDS_STAR_VIEW_MENU_MARK_AS_READ 11836
#define IDS_READ_LATER_TITLE 11837
#define IDS_READ_LATER_MENU_UNREAD_HEADER 11838
#define IDS_READ_LATER_MENU_READ_HEADER 11839
#define IDS_READ_LATER_MENU_TOOLTIP_MARK_AS_READ 11840
#define IDS_READ_LATER_MENU_TOOLTIP_MARK_AS_UNREAD 11841
#define IDS_READ_LATER_MENU_EMPTY_STATE_ADD_FROM_DIALOG_SUBHEADER 11842
#define IDS_READ_LATER_MENU_EMPTY_STATE_HEADER 11843
#define IDS_READ_LATER_MENU_EMPTY_STATE_SUBHEADER 11844
#define IDS_READ_LATER_ADD_CURRENT_TAB 11845
#define IDS_READ_LATER_CANT_ADD_CURRENT_TAB 11846
#define IDS_READ_LATER_MARK_CURRENT_TAB_READ 11847
#define IDS_READ_LATER_REMOVE_CURRENT_TAB 11848
#define IDS_READ_LATER_CONTEXT_MENU_MARK_AS_UNREAD 11849
#define IDS_READ_LATER_CONTEXT_MENU_MARK_AS_READ 11850
#define IDS_READ_LATER_CONTEXT_MENU_DELETE 11851
#define IDS_READING_LIST_MENU 11852
#define IDS_READING_LIST_MENU_ADD_TAB 11853
#define IDS_READING_LIST_MENU_SHOW_UI 11854
#define IDS_ACCNAME_SIDE_PANEL_RESIZE 11855
#define IDS_ACCNAME_SIDE_PANEL_SELECTOR 11856
#define IDS_ACCNAME_SIDE_PANEL_COMPANION_SHOW 11857
#define IDS_ACCNAME_SIDE_PANEL_COMPANION_HIDE 11858
#define IDS_SIDE_PANEL_COMPANION_TITLE 11859
#define IDS_SIDE_PANEL_COMPANION_TOOLBAR_TOOLTIP 11860
#define IDS_SIDE_PANEL_COMPANION_PROMO 11861
#define IDS_SIDE_PANEL_COMPANION_PROMO_PINNING 11862
#define IDS_SIDE_PANEL_COMPANION_PROMO_SCREEN_READER 11863
#define IDS_SIDE_PANEL_COMPANION_ERROR_PAGE_FIRST_LINE 11864
#define IDS_SIDE_PANEL_COMPANION_ERROR_PAGE_SECOND_LINE 11865
#define IDS_SIDE_PANEL_CUSTOMIZE_CHROME_TITLE 11866
#define IDS_SIDE_PANEL_LENS_OVERLAY_TOOLBAR_TOOLTIP 11867
#define IDS_SIDE_PANEL_TOOLBAR_BUTTON_CXMENU_UNPIN 11868
#define IDS_SIDE_PANEL_TOOLBAR_BUTTON_CXMENU_PIN 11869
#define IDS_SIDE_PANEL_HEADER_UNPIN_BUTTON_TOOLTIP 11870
#define IDS_SIDE_PANEL_HEADER_PIN_BUTTON_TOOLTIP 11871
#define IDS_SIDE_PANEL_UNPINNED 11872
#define IDS_SIDE_PANEL_PINNED 11873
#define IDS_PINNED_ACTION_BUTTON_ACCESSIBLE_TITLE 11874
#define IDS_SIDE_PANEL_GENERIC_PINNABLE_IPH 11875
#define IDS_SIDE_PANEL_GENERIC_PINNABLE_IPH_SCREENREADER 11876
#define IDS_SIDE_PANEL_LENS_OVERLAY_PINNABLE_IPH 11877
#define IDS_SIDE_PANEL_LENS_OVERLAY_PINNABLE_IPH_SCREENREADER 11878
#define IDS_SIDE_PANEL_LENS_OVERLAY_PINNABLE_FOLLOWUP_IPH 11879
#define IDS_SIDE_PANEL_LENS_OVERLAY_PINNABLE_FOLLOWUP_IPH_SCREENREADER 11880
#define IDS_BOOKMARKS_SORT_BY_TYPE 11881
#define IDS_BOOKMARKS_ALL_BOOKMARKS 11882
#define IDS_BOOKMARKS_ALL_BOOKMARKS_OPEN_SIDE_PANEL 11883
#define IDS_BOOKMARKS_LABEL_TRACKED_PRODUCTS 11884
#define IDS_BOOKMARKS_SORT_NEWEST 11885
#define IDS_BOOKMARKS_SORT_NEWEST_LOWER 11886
#define IDS_BOOKMARKS_SORT_OLDEST 11887
#define IDS_BOOKMARKS_SORT_OLDEST_LOWER 11888
#define IDS_BOOKMARKS_SORT_ALPHABETICALLY 11889
#define IDS_BOOKMARKS_SORT_REVERSE_ALPHABETICALLY 11890
#define IDS_BOOKMARKS_SORT_LAST_OPENED 11891
#define IDS_BOOKMARKS_SORT_LAST_OPENED_LOWER 11892
#define IDS_BOOKMARKS_VISUAL_VIEW 11893
#define IDS_BOOKMARKS_COMPACT_VIEW 11894
#define IDS_BOOKMARKS_SORT_MENU_A11Y_LABEL 11895
#define IDS_BOOKMARKS_CREATE_NEW_FOLDER_A11Y_LABEL 11896
#define IDS_BOOKMARKS_NEW_FOLDER_TOOLTIP 11897
#define IDS_BOOKMARKS_EDIT_BOOKMARK_LIST_A11Y_LABEL 11898
#define IDS_BOOKMARKS_EMPTY_STATE_TITLE 11899
#define IDS_BOOKMARKS_EMPTY_STATE_BODY 11900
#define IDS_BOOKMARKS_EMPTY_STATE_TITLE_FOLDER 11901
#define IDS_BOOKMARKS_EMPTY_STATE_BODY_FOLDER 11902
#define IDS_BOOKMARKS_EMPTY_STATE_TITLE_GUEST 11903
#define IDS_BOOKMARKS_EMPTY_STATE_BODY_GUEST 11904
#define IDS_BOOKMARKS_EMPTY_STATE_TITLE_SEARCH 11905
#define IDS_BOOKMARKS_EMPTY_STATE_BODY_SEARCH 11906
#define IDS_BOOKMARK_FOLDER_CHILD_COUNT 11907
#define IDS_BOOKMARKS_EDIT_BOOKMARK 11908
#define IDS_BOOKMARKS_EDIT_MOVE_TO_ANOTHER_FOLDER 11909
#define IDS_BOOKMARKS_EDIT_MORE 11910
#define IDS_BOOKMARKS_EDIT_MOVE_TO 11911
#define IDS_BOOKMARKS_EDIT_NEW_FOLDER 11912
#define IDS_BOOKMARKS_EDIT_CANCEL 11913
#define IDS_BOOKMARKS_EDIT_SAVE 11914
#define IDS_BOOKMARKS_EDIT_NAME 11915
#define IDS_BOOKMARKS_EDIT_URL 11916
#define IDS_BOOKMARK_DELETION_COUNT 11917
#define IDS_UNDO_BOOKMARK_DELETION 11918
#define IDS_BOOKMARKS_MOVE_TO_BOOKMARKS_BAR 11919
#define IDS_BOOKMARKS_MOVE_TO_ALL_BOOKMARKS 11920
#define IDS_BOOKMARKS_EDIT 11921
#define IDS_BOOKMARKS_RENAME 11922
#define IDS_BOOKMARKS_URL_FOLDER_DESCRIPTION 11923
#define IDS_BOOKMARKS_DISABLED_FEATURE 11924
#define IDS_BOOKMARKS_BACK_BUTTON_LABEL 11925
#define IDS_BOOKMARKS_BACK_BUTTON_TOOLTIP 11926
#define IDS_BOOKMARKS_FORWARD_BUTTON_LABEL 11927
#define IDS_BOOKMARK_OPTIONS_LABEL 11928
#define IDS_FOLDER_OPTIONS_LABEL 11929
#define IDS_BOOKMARKS_OPEN_FOLDER_LABEL 11930
#define IDS_BOOKMARKS_OPEN_BOOKMARK_LABEL 11931
#define IDS_BOOKMARKS_SELECT_FOLDER_LABEL 11932
#define IDS_BOOKMARKS_SELECT_BOOKMARK_LABEL 11933
#define IDS_BOOKMARKS_DESELECT_FOLDER_LABEL 11934
#define IDS_BOOKMARKS_DESELECT_BOOKMARK_LABEL 11935
#define IDS_BOOKMARK_ACCESSIBLE_DESCRIPTION_PRICE_TRACKING 11936
#define IDS_BOOKMARK_ACCESSIBLE_DESCRIPTION_PRICE_CHANGE 11937
#define IDS_BOOKMARKS_CHECKBOX_LABEL 11938
#define IDS_BOOKMARKS_PRIMARY_FILTER_HEADING 11939
#define IDS_BOOKMARKS_SECONDARY_FILTER_HEADING 11940
#define IDS_SHOW_READING_MODE_SIDE_PANEL 11941
#define IDS_READING_MODE_TITLE 11942
#define IDS_READING_MODE_NOT_SELECTABLE_HEADER 11943
#define IDS_READING_MODE_EMPTY_STATE_HEADER 11944
#define IDS_READING_MODE_EMPTY_STATE_SUBHEADER 11945
#define IDS_READING_MODE_TOOLBAR_LABEL 11946
#define IDS_READING_MODE_READ_ALOUD_TOOLBAR_LABEL 11947
#define IDS_READING_MODE_FONT_SIZE 11948
#define IDS_READING_MODE_FONT_NAME_COMBOBOX_LABEL 11949
#define IDS_READING_MODE_DECREASE_FONT_SIZE_BUTTON_LABEL 11950
#define IDS_READING_MODE_INCREASE_FONT_SIZE_BUTTON_LABEL 11951
#define IDS_READING_MODE_DISABLE_LINKS_BUTTON_LABEL 11952
#define IDS_READING_MODE_ENABLE_LINKS_BUTTON_LABEL 11953
#define IDS_READING_MODE_DISABLE_IMAGES_BUTTON_LABEL 11954
#define IDS_READING_MODE_ENABLE_IMAGES_BUTTON_LABEL 11955
#define IDS_READING_MODE_COLORS_COMBOBOX_LABEL 11956
#define IDS_READING_MODE_LINE_SPACING_COMBOBOX_LABEL 11957
#define IDS_READING_MODE_LETTER_SPACING_COMBOBOX_LABEL 11958
#define IDS_READING_MODE_SPACING_COMBOBOX_STANDARD 11959
#define IDS_READING_MODE_SPACING_COMBOBOX_LOOSE 11960
#define IDS_READING_MODE_SPACING_COMBOBOX_VERY_LOOSE 11961
#define IDS_READING_MODE_SPACING_COMBOBOX_WIDE 11962
#define IDS_READING_MODE_SPACING_COMBOBOX_VERY_WIDE 11963
#define IDS_READING_MODE_DEFAULT_COLOR_LABEL 11964
#define IDS_READING_MODE_LIGHT_COLOR_LABEL 11965
#define IDS_READING_MODE_DARK_COLOR_LABEL 11966
#define IDS_READING_MODE_YELLOW_COLOR_LABEL 11967
#define IDS_READING_MODE_BLUE_COLOR_LABEL 11968
#define IDS_READ_ANYTHING_LOADING 11969
#define IDS_READING_MODE_FONT_RESET 11970
#define IDS_READING_MODE_TURN_HIGHLIGHT_OFF 11971
#define IDS_READING_MODE_TURN_HIGHLIGHT_ON 11972
#define IDS_READING_MODE_PLAY_DESCRIPTION 11973
#define IDS_READING_MODE_PLAY_SPEECH 11974
#define IDS_READING_MODE_PAUSE_SPEECH 11975
#define IDS_READING_MODE_PLAY_TOOLTIP 11976
#define IDS_READING_MODE_PREVIEW_TOOLTIP 11977
#define IDS_READING_MODE_PAUSE_TOOLTIP 11978
#define IDS_READING_MODE_STOP_SPEECH 11979
#define IDS_READING_MODE_NAVIGATE_PREVIOUS_SENTENCE 11980
#define IDS_READING_MODE_NAVIGATE_NEXT_SENTENCE 11981
#define IDS_READING_MODE_MORE_OPTIONS 11982
#define IDS_READING_MODE_VOICE_SPEED 11983
#define IDS_READING_MODE_VOICE_SPEED_WITH_RATE 11984
#define IDS_READING_MODE_VOICE_SELECTION 11985
#define IDS_READING_MODE_ITEM_SELECTED 11986
#define IDS_READING_MODE_LANGUAGE_MENU 11987
#define IDS_READING_MODE_LANGUAGE_MENU_TITLE 11988
#define IDS_READING_MODE_LANGUAGE_MENU_CLOSE 11989
#define IDS_READING_MODE_LANGUAGE_MENU_NO_RESULTS 11990
#define IDS_READING_MODE_LANGUAGE_MENU_SEARCH_LABEL 11991
#define IDS_READING_MODE_LANGUAGE_MENU_SEARCH_CLEAR 11992
#define IDS_READING_MODE_LANGUAGE_MENU_DOWNLOADING 11993
#define IDS_READING_MODE_VOICE_MENU_DOWNLOADING 11994
#define IDS_READING_MODE_LANGUAGE_DOWNLOAD_UNAVAILALBLE 11995
#define IDS_READING_MODE_LANGUAGE_DOWNLOAD_UNAVAILALBLE_LEARN_MORE_LINK 11996
#define IDS_READING_MODE_LANGUAGE_MENU_VOICES_UNAVAILABLE 11997
#define IDS_READING_MODE_LANGUAGE_MENU_NO_INTERNET 11998
#define IDS_READING_MODE_LANGUAGE_MENU_DOWNLOAD_FAILED 11999
#define IDS_READING_MODE_LANGUAGE_MENU_NO_SPACE 12000
#define IDS_READING_MODE_VOICE_MENU_PREVIEW_LANGUAGE 12001
#define IDS_READING_MODE_LANGUAGE_MENU_NO_SPACE_BUT_VOICES_EXIST 12002
#define IDS_READING_MODE_VOICE_DOWNLOADED_TITLE 12003
#define IDS_READING_MODE_VOICE_DOWNLOADED_MESSAGE 12004
#define IDS_READING_MODE_SIDE_PANEL_PROMO 12005
#define IDS_READING_MODE_SIDE_PANEL_PROMO_PINNING 12006
#define IDS_READING_MODE_VOICE_PREVIEW_STRING 12007
#define IDS_READING_MODE_FONT_LOADING_STRING 12008
#define IDS_GOOGLE_LENS_TITLE 12009
#define IDS_LENS_DEFAULT_TITLE 12010
#define IDS_TOOLTIP_BACK 12011
#define IDS_ACCDESCRIPTION_BACK 12012
#define IDS_TOOLTIP_CHROMELABS_BUTTON 12013
#define IDS_TOOLTIP_LEFT_ALIGNED_SIDE_PANEL_BUTTON 12014
#define IDS_TOOLTIP_CHROMELABS_COMBOBOX 12015
#define IDS_TOOLTIP_CHROMELABS_FEEDBACK_BUTTON 12016
#define IDS_TOOLTIP_FORWARD 12017
#define IDS_ACCDESCRIPTION_FORWARD 12018
#define IDS_TOOLTIP_DOWNLOAD_ICON 12019
#define IDS_TOOLTIP_HOME 12020
#define IDS_TOOLTIP_RELOAD 12021
#define IDS_TOOLTIP_RELOAD_WITH_MENU 12022
#define IDS_TOOLTIP_STOP 12023
#define IDS_TOOLTIP_EXTENSIONS_BUTTON 12024
#define IDS_TOOLTIP_OVERFLOW_BUTTON 12025
#define IDS_TOOLTIP_EXTENSIONS_BUTTON_ALL_EXTENSIONS_BLOCKED 12026
#define IDS_TOOLTIP_EXTENSIONS_BUTTON_ANY_EXTENSION_HAS_ACCESS 12027
#define IDS_ACC_NAME_EXTENSIONS_BUTTON 12028
#define IDS_ACC_NAME_EXTENSIONS_BUTTON_ALL_EXTENSIONS_BLOCKED 12029
#define IDS_ACC_NAME_EXTENSIONS_BUTTON_ANY_EXTENSION_HAS_ACCESS 12030
#define IDS_TOOLTIP_EXTENSIONS_SITE_ACCESS_BUTTON 12031
#define IDS_TOOLTIP_SIDE_PANEL_SHOW 12032
#define IDS_TOOLTIP_SIDE_PANEL_HIDE 12033
#define IDS_TOOLTIP_SIDE_PANEL 12034
#define IDS_TOOLTIP_LOCATION_ICON 12036
#define IDS_TOOLTIP_NEW_TAB 12037
#define IDS_TOOLTIP_MIC_SEARCH 12038
#define IDS_TOOLTIP_LENS_SEARCH 12039
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_CLOSE_BUTTON_LABEL 12040
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_TITLE 12041
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_TITLE_SHORT 12042
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_DRAG_TITLE 12043
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_UPLOAD_FILE_TITLE 12044
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_OR_TEXT 12045
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_TEXT_PLACEHOLDER 12046
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_SEARCH_BUTTON_LABEL 12047
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_DRAG_DROP_TITLE 12048
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_LOADING_TEXT 12049
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_OFFLINE_TEXT 12050
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_OFFLINE_SUBTITLE_TEXT 12051
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_OFFLINE_BUTTON_LABEL 12052
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_ERROR_FILE_TYPE 12053
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_ERROR_FILE_SIZE 12054
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_ERROR_MULTIPLE_FILES 12055
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_VALIDATION_ERROR_SCHEME 12056
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_VALIDATION_ERROR_CONFORMANCE 12057
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_ERROR_MULTIPLE_URLS 12058
#define IDS_TOOLTIP_SAVE_CREDIT_CARD 12059
#define IDS_TOOLTIP_SAVE_CREDIT_CARD_PENDING 12060
#define IDS_TOOLTIP_SAVE_CVC 12061
#define IDS_TOOLTIP_SAVE_IBAN 12062
#define IDS_TOOLTIP_MIGRATE_LOCAL_CARD 12063
#define IDS_TOOLTIP_TRANSLATE 12064
#define IDS_TOOLTIP_ZOOM 12065
#define IDS_TOOLTIP_ZOOM_EXTENSION_ICON 12066
#define IDS_ZOOM_SET_DEFAULT 12067
#define IDS_TOOLTIP_FIND 12068
#define IDS_TOOLTIP_TAB_SEARCH 12069
#define IDS_TOOLTIP_TAB_ORGANIZE 12070
#define IDS_TAB_ORGANIZE 12071
#define IDS_TOOLTIP_TAB_ORGANIZE_CLOSE 12072
#define IDS_TAB_ORGANIZATION_FEEDBACK_PLACEHOLDER 12073
#define IDS_TAB_ORGANIZE_MENU 12074
#define IDS_TAB_ORGANIZATION_SUCCESS_IPH 12075
#define IDS_TAB_ORGANIZATION_SUCCESS_IPH_SCREENREADER 12076
#define IDS_IPH_EXPERIMENTAL_AI_PROMO 12077
#define IDS_IPH_EXPERIMENTAL_AI_PROMO_BODY 12078
#define IDS_IPH_EXPERIMENTAL_AI_PROMO_BUTTON_CONTINUE 12079
#define IDS_TOOLTIP_INTENT_PICKER_ICON 12080
#define IDS_INTENT_PICKER_BUBBLE_VIEW_OPEN_WITH 12081
#define IDS_INTENT_PICKER_BUBBLE_VIEW_OPEN_IN_APP 12082
#define IDS_INTENT_PICKER_BUBBLE_VIEW_REMEMBER_SELECTION 12083
#define IDS_INTENT_PICKER_BUBBLE_VIEW_OPEN 12084
#define IDS_INTENT_PICKER_BUBBLE_VIEW_STAY_IN_CHROME 12085
#define IDS_INTENT_PICKER_BUBBLE_VIEW_INITIATING_ORIGIN 12086
#define IDS_INTENT_CHIP_OPEN_IN_APP 12087
#define IDR_INTENT_PICKER_SUPPORTED_LINKS_INFOBAR_MESSAGE 12088
#define IDR_INTENT_PICKER_SUPPORTED_LINKS_INFOBAR_OK_LABEL 12089
#define IDS_ACCESSIBLE_INCOGNITO_WINDOW_TITLE_FORMAT 12107
#define IDS_ACCESSIBLE_GUEST_WINDOW_TITLE_FORMAT 12108
#define IDS_ACCESSIBLE_WINDOW_TITLE_WITH_PROFILE_FORMAT 12109
#define IDS_ACCNAME_APP_UPGRADE_RECOMMENDED 12110
#define IDS_ACCNAME_FULLSCREEN 12111
#define IDS_ACCNAME_EXIT_FULLSCREEN 12112
#define IDS_ACCNAME_HOME 12113
#define IDS_ACCNAME_RELOAD 12114
#define IDS_ACCNAME_FIND 12115
#define IDS_ACCNAME_BOOKMARKS 12116
#define IDS_ACCNAME_SAVED_TAB_GROUPS 12117
#define IDS_ACCNAME_SAVED_TAB_GROUPS_CHEVRON 12118
#define IDS_SAVED_TAB_GROUPS_OVERFLOW_BUTTON_TOOLTIP 12119
#define IDS_TAB_GROUP_EDITOR_BUBBLE_FOOTER_SYNC_DISABLED 12120
#define IDS_TAB_GROUP_EDITOR_BUBBLE_FOOTER_SYNC_ENABLED 12121
#define IDS_TAB_GROUP_EDITOR_BUBBLE_FOOTER_LEARN_MORE 12122
#define IDS_ACCNAME_TAB_GROUPS_EVERYTHING 12123
#define IDS_TAB_GROUPS_EVERYTHING_BUTTON_TOOLTIP 12124
#define IDS_ACCNAME_BOOKMARKS_CHEVRON 12125
#define IDS_ACCNAME_BOOKMARK_BUTTON_ROLE_DESCRIPTION 12126
#define IDS_ACCNAME_BOOKMARK_FOLDER_BUTTON_ROLE_DESCRIPTION 12127
#define IDS_ACCNAME_SAVED_TAB_GROUP_BUTTON_ROLE_DESCRIPTION 12128
#define IDS_ACCNAME_CHROMELABS_BUTTON 12129
#define IDS_ACCNAME_LEFT_ALIGNED_SIDE_PANEL_BUTTON 12130
#define IDS_ACCESSIBLE_TEXT_CHROMELABS_BUTTON_ADDED_BY_ENTERPRISE_POLICY 12131
#define IDS_ACCESSIBLE_TEXT_CHROMELABS_BUTTON_REMOVED_BY_ENTERPRISE_POLICY 12132
#define IDS_ACCNAME_CHROMELABS_COMBOBOX 12133
#define IDS_ACCNAME_CHROMELABS_COMBOBOX_MAC 12134
#define IDS_ACCNAME_SEPARATOR 12135
#define IDS_ACCNAME_EXTENSIONS 12136
#define IDS_ACCNAME_NEWTAB 12137
#define IDS_ACCNAME_MINIMIZE 12138
#define IDS_ACCNAME_MAXIMIZE 12139
#define IDS_ACCNAME_RESTORE 12140
#define IDS_ACCNAME_CLOSE_TAB 12141
#define IDS_ACCNAME_ZOOM_SET_DEFAULT 12142
#define IDS_ACCNAME_TAB_SEARCH 12143
#define IDS_ACCNAME_TAB_ORGANIZE 12144
#define IDS_ACCNAME_TAB_SCROLL_LEADING 12145
#define IDS_ACCNAME_TAB_SCROLL_TRAILING 12146
#define IDS_ACCNAME_MUTE_TAB 12147
#define IDS_ACCNAME_WEB_APP_DETAILED_INSTALL_DIALOG_LEADING_SCROLL_BUTTON 12148
#define IDS_ACCNAME_WEB_APP_DETAILED_INSTALL_DIALOG_TRAILING_SCROLL_BUTTON 12149
#define IDS_ALLOWED_CLIPBOARD_TITLE 12150
#define IDS_BLOCKED_CLIPBOARD_TITLE 12151
#define IDS_ALLOWED_CLIPBOARD_MESSAGE 12152
#define IDS_ALLOWED_CLIPBOARD_BLOCK 12153
#define IDS_ALLOWED_CLIPBOARD_NO_ACTION 12154
#define IDS_BLOCKED_CLIPBOARD_MESSAGE 12155
#define IDS_BLOCKED_CLIPBOARD_UNBLOCK 12156
#define IDS_BLOCKED_CLIPBOARD_NO_ACTION 12157
#define IDS_BACK_NAVIGATION_MENU_PROMO 12158
#define IDS_BACK_NAVIGATION_MENU_PROMO_ACCESSIBLE_TEXT 12159
#define IDS_BOOKMARK_PROMO_0 12160
#define IDS_BOOKMARK_PROMO_1 12161
#define IDS_BOOKMARK_PROMO_2 12162
#define IDS_CHROME_TIP 12163
#define IDS_EXTENSIONS_MENU_IPH_ENTRY_POINT_TITLE 12164
#define IDS_EXTENSIONS_MENU_IPH_ENTRY_POINT_BODY 12165
#define IDS_EXTENSIONS_REQUEST_ACCESS_BUTTON_IPH_ENTRY_POINT_TITLE 12166
#define IDS_EXTENSIONS_REQUEST_ACCESS_BUTTON_IPH_ENTRY_POINT_BODY 12167
#define IDS_GLOBAL_MEDIA_CONTROLS_PROMO 12168
#define IDS_INCOGNITOWINDOW_PROMO_0 12169
#define IDS_INCOGNITOWINDOW_PROMO_1 12170
#define IDS_INCOGNITOWINDOW_PROMO_2 12171
#define IDS_INCOGNITOWINDOW_PROMO_3 12172
#define IDS_NEWTAB_PROMO_0 12173
#define IDS_NEWTAB_PROMO_1 12174
#define IDS_NEWTAB_PROMO_2 12175
#define IDS_POWER_BOOKMARKS_SIDE_PANEL_PROMO 12176
#define IDS_POWER_BOOKMARKS_SIDE_PANEL_PROMO_PINNING 12177
#define IDS_READING_LIST_DISCOVERY_PROMO 12178
#define IDS_READING_LIST_DISCOVERY_PROMO_PINNING 12179
#define IDS_READING_LIST_ENTRY_POINT_PROMO 12180
#define IDS_DESKTOP_PWA_INSTALL_PROMO 12181
#define IDS_DESKTOP_PWA_LINK_CAPTURING_TEXT 12182
#define IDS_DESKTOP_PWA_LINK_CAPTURING_SETTINGS 12183
#define IDS_UPDATED_CONNECTION_SECURITY_INDICATORS_PROMO 12184
#define IDS_READING_LIST_IN_SIDE_PANEL_PROMO 12185
#define IDS_READING_LIST_IN_SIDE_PANEL_PROMO_PINNING 12186
#define IDS_TAB_GROUPS_NEW_GROUP_PROMO 12187
#define IDS_TAB_GROUPS_UNNAMED_GROUP_TOOLTIP 12188
#define IDS_TAB_GROUPS_NAMED_GROUP_TOOLTIP 12189
#define IDS_TAB_AUDIO_MUTING_PROMO 12190
#define IDS_SHARED_HIGHLIGHTING_PROMO 12191
#define IDS_BATTERY_SAVER_MODE_PROMO_TITLE 12192
#define IDS_BATTERY_SAVER_MODE_PROMO_TEXT 12193
#define IDS_BATTERY_SAVER_MODE_PROMO_ACTION_TEXT 12194
#define IDS_MEMORY_SAVER_MODE_PROMO_TEXT 12195
#define IDS_MEMORY_SAVER_MODE_PROMO_ACTION_TEXT 12196
#define IDS_DISCARD_RING_PROMO_TITLE 12197
#define IDS_DISCARD_RING_PROMO_TEXT 12198
#define IDS_DISCARD_RING_PROMO_ACTION_TEXT 12199
#define IDS_DISCARD_RING_SETTINGS_TOAST 12200
#define IDS_TUTORIAL_GENERIC_SUCCESS_TITLE 12201
#define IDS_TUTORIAL_TAB_GROUP_ADD_TAB_TO_GROUP 12202
#define IDS_TUTORIAL_ADD_TAB_TO_GROUP_WITH_EXISTING_GROUP_IN_TAB_STRIP 12203
#define IDS_TUTORIAL_TAB_GROUP_EDIT_BUBBLE 12204
#define IDS_TUTORIAL_TAB_GROUP_DRAG_TAB 12205
#define IDS_TUTORIAL_TAB_GROUP_COLLAPSE 12206
#define IDS_TUTORIAL_TAB_GROUP_SUCCESS_DESCRIPTION 12207
#define IDS_TUTORIAL_SAVED_TAB_GROUP_ADD_TAB_TO_GROUP 12208
#define IDS_TUTORIAL_SAVED_TAB_GROUP_OPEN_EDITOR 12209
#define IDS_TUTORIAL_SAVED_TAB_GROUP_NAME_SAVE_GROUP 12210
#define IDS_TUTORIAL_SAVED_TAB_GROUP_HIDE_GROUP 12211
#define IDS_TUTORIAL_SAVED_TAB_GROUP_REOPEN_GROUP 12212
#define IDS_TUTORIAL_SAVED_TAB_GROUP_SUCCESS_DESCRIPTION 12213
#define IDS_TUTORIAL_SIDE_PANEL_READING_LIST_OPEN_SIDE_PANEL 12214
#define IDS_TUTORIAL_SIDE_PANEL_READING_LIST_ADD_TAB 12215
#define IDS_TUTORIAL_SIDE_PANEL_READING_LIST_MARK_READ 12216
#define IDS_TUTORIAL_SIDE_PANEL_READING_LIST_CLICK_DROPDOWN 12217
#define IDS_TUTORIAL_SIDE_PANEL_READING_LIST_SUCCESS_BODY 12218
#define IDS_IPH_CUSTOMIZE_CHROME_REFRESH_BODY 12219
#define IDS_IPH_CUSTOMIZE_CHROME_REFRESH_POINTER_BODY 12220
#define IDS_IPH_CUSTOMIZE_CHROME_REFRESH_CUSTOM_ACTION 12221
#define IDS_TUTORIAL_CUSTOMIZE_CHROME_START_TUTORIAL_IPH 12222
#define IDS_TUTORIAL_CUSTOMIZE_CHROME_OPEN_SIDE_PANEL 12223
#define IDS_TUTORIAL_CUSTOMIZE_CHROME_CHANGE_THEME 12224
#define IDS_TUTORIAL_CUSTOMIZE_CHROME_SELECT_COLLECTION 12225
#define IDS_TUTORIAL_CUSTOMIZE_CHROME_APPLY_THEME 12226
#define IDS_TUTORIAL_CUSTOMIZE_CHROME_CLICK_BACK_ARROW 12227
#define IDS_TUTORIAL_CUSTOMIZE_CHROME_SUCCESS_BODY 12228
#define IDS_TUTORIAL_PASSWORD_MANAGER_OPEN_MENU 12229
#define IDS_TUTORIAL_PASSWORD_MANAGER_CLICK_PASSWORDS_MENU 12230
#define IDS_TUTORIAL_PASSWORD_MANAGER_SELECT_SETTINGS 12231
#define IDS_TUTORIAL_PASSWORD_MANAGER_ADD_SHORTCUT 12232
#define IDS_TUTORIAL_PASSWORD_MANAGER_CLICK_INSTALL 12233
#define IDS_BROWSER_HANGMONITOR_RENDERER_TITLE 12235
#define IDS_BROWSER_HANGMONITOR_RENDERER 12236
#define IDS_BROWSER_HANGMONITOR_IFRAME_TITLE 12237
#define IDS_BROWSER_HANGMONITOR_RENDERER_WAIT 12238
#define IDS_BROWSER_HANGMONITOR_RENDERER_END 12239
#define IDS_BROWSER_HANGMONITOR_PLUGIN_INFOBAR 12240
#define IDS_BROWSER_HANGMONITOR_PLUGIN_INFOBAR_KILLBUTTON 12241
#define IDS_PASSWORDS_AUTO_SIGNIN_TITLE 12242
#define IDS_PASSWORDS_AUTO_SIGNIN_DESCRIPTION 12243
#define IDS_PASSWORDS_VIA_FEDERATION 12244
#define IDS_CONFIRM_MESSAGEBOX_YES_BUTTON_LABEL 12245
#define IDS_CONFIRM_MESSAGEBOX_NO_BUTTON_LABEL 12246
#define IDS_NEAR_OOM_REDUCTION_MESSAGE_TITLE 12247
#define IDS_NEAR_OOM_REDUCTION_MESSAGE_DESCRIPTION 12248
#define IDS_TAILORED_SECURITY_UNCONSENTED_MESSAGE_TITLE 12249
#define IDS_TAILORED_SECURITY_UNCONSENTED_MESSAGE_ACCEPT 12250
#define IDS_TAILORED_SECURITY_DISPLAY_SOURCE 12251
#define IDS_PASSWORD_MANAGER_CANCEL_BUTTON 12252
#define IDS_PASSWORD_MANAGER_USERNAME_LABEL 12253
#define IDS_PASSWORD_MANAGER_PASSWORD_LABEL 12254
#define IDS_PASSWORD_MANAGER_UPDATED_BUBBLE_TITLE 12255
#define IDS_PASSWORD_MANAGER_MORE_TO_FIX_BODY_MESSAGE_GOOGLE_PASSWORD_MANAGER 12256
#define IDS_PASSWORD_MANAGER_SAFE_STATE_BODY_MESSAGE_GOOGLE_PASSWORD_MANAGER 12257
#define IDS_PASSWORD_MANAGER_CHECK_REMAINING_BUTTON 12258
#define IDS_PASSWORD_MANAGER_SAVE_BUTTON 12259
#define IDS_PASSWORD_MANAGER_SAVE_BUBBLE_OPT_IN_BUTTON 12260
#define IDS_PASSWORD_MANAGER_MOVE_BUBBLE_OK_BUTTON 12261
#define IDS_PASSWORD_MANAGER_MOVE_BUBBLE_CANCEL_BUTTON 12262
#define IDS_PASSWORD_MANAGER_UPDATE_BUTTON 12263
#define IDS_PASSWORD_MANAGER_BUBBLE_BLOCKLIST_BUTTON 12264
#define IDS_PASSWORD_MANAGER_DESTINATION_DROPDOWN_ACCESSIBLE_NAME 12265
#define IDS_PASSWORD_MANAGER_DESTINATION_DROPDOWN_SAVE_TO_ACCOUNT 12266
#define IDS_PASSWORD_MANAGER_DESTINATION_DROPDOWN_SAVE_TO_DEVICE 12267
#define IDS_PASSWORD_MANAGER_IPH_TITLE_SAVE_TO_ACCOUNT 12268
#define IDS_PASSWORD_MANAGER_IPH_BODY_SAVE_REAUTH_FAIL 12269
#define IDS_PASSWORD_MANAGER_IPH_BODY_SAVE_TO_ACCOUNT 12270
#define IDS_PASSWORD_MANAGER_IPH_MANAGEMENT_BUBBLE_AFTER_SAVE 12271
#define IDS_PASSWORD_MANAGER_IPH_MANAGEMENT_BUBBLE_AFTER_SAVE_SCREENREADER 12272
#define IDS_PASSWORD_MANAGER_IPH_SHARE_PASSWORD_BUTTON 12273
#define IDS_PASSWORD_MANAGER_IPH_SHARE_PASSWORD_BUTTON_SCREENREADER 12274
#define IDS_PASSWORD_MANAGER_IPH_ACCOUNT_STORAGE_TOGGLE 12275
#define IDS_PASSWORD_MANAGER_IPH_CREATE_SHORTCUT_TITLE 12276
#define IDS_PASSWORD_MANAGER_IPH_MANAGEMENT_BUBBLE_DURING_SIGNIN 12277
#define IDS_PASSWORD_MANAGER_IPH_MANAGEMENT_BUBBLE_DURING_SIGNIN_SCREENREADER 12278
#define IDS_PASSWORD_MANAGER_TOOLTIP_SAVE 12279
#define IDS_PASSWORD_MANAGER_TOOLTIP_MANAGE 12280
#define IDS_PASSWORD_MANAGER_TOOLTIP_MOVE 12281
#define IDS_PASSWORD_MANAGER_TOOLTIP_PROTECT 12282
#define IDS_PASSWORD_MANAGER_TOOLTIP_SHARED_NOTIFICATION 12283
#define IDS_PASSWORD_MANAGER_TOOLTIP_KEYCHAIN_ERROR 12284
#define IDS_PASSWORD_MANAGER_IMPORT_DIALOG_TITLE 12285
#define IDS_PASSWORD_MANAGER_EXPORT_DIALOG_TITLE 12286
#define IDS_PASSWORD_MANAGER_MOVE_TITLE 12287
#define IDS_PASSWORD_MANAGER_MOVE_HINT 12288
#define IDS_PASSWORD_MANAGER_UNSYNCED_CREDENTIALS_BUBBLE_TITLE_GPM 12289
#define IDS_PASSWORD_MANAGER_UNSYNCED_CREDENTIALS_BUBBLE_DESCRIPTION_GPM 12290
#define IDS_PASSWORD_MANAGER_SAVE_UNSYNCED_CREDENTIALS_BUTTON_GPM 12291
#define IDS_PASSWORD_MANAGER_DISCARD_UNSYNCED_CREDENTIALS_BUTTON 12292
#define IDS_IMPORT_FROM_FIREFOX 12312
#define IDS_IMPORT_FROM_ICEWEASEL 12313
#define IDS_IMPORT_FROM_SAFARI 12314
#define IDS_IMPORT_FROM_BOOKMARKS_HTML_FILE 12315
#define IDS_IMPORTER_LOCK_TITLE 12319
#define IDS_IMPORTER_LOCK_TEXT 12320
#define IDS_IMPORTER_LOCK_OK 12321
#define IDS_FEEDBACK_REPORT_APP_TITLE 12322
#define IDS_FEEDBACK_REPORT_PAGE_TITLE 12323
#define IDS_FEEDBACK_REPORT_PAGE_TITLE_SAD_TAB_FLOW 12324
#define IDS_FEEDBACK_MINIMIZE_BUTTON_LABEL 12325
#define IDS_FEEDBACK_CLOSE_BUTTON_LABEL 12326
#define IDS_FEEDBACK_FREE_TEXT_LABEL 12327
#define IDS_FEEDBACK_FREE_TEXT_AI_LABEL 12328
#define IDS_FEEDBACK_REPORT_URL_LABEL 12329
#define IDS_FEEDBACK_USER_EMAIL_LABEL 12330
#define IDS_FEEDBACK_ANONYMOUS_EMAIL_OPTION 12331
#define IDS_FEEDBACK_CONSENT_CHECKBOX_LABEL 12332
#define IDS_FEEDBACK_SCREENSHOT_LABEL 12333
#define IDS_FEEDBACK_SCREENSHOT_A11Y_TEXT 12334
#define IDS_FEEDBACK_OFFLINE_DIALOG_TITLE 12335
#define IDS_FEEDBACK_OFFLINE_DIALOG_TEXT 12336
#define IDS_FEEDBACK_INCLUDE_SYSTEM_INFORMATION_CHKBOX 12337
#define IDS_FEEDBACK_ATTACH_FILE_NOTE 12340
#define IDS_FEEDBACK_ATTACH_FILE_LABEL 12341
#define IDS_FEEDBACK_ATTACH_FILE_TO_BIG 12342
#define IDS_FEEDBACK_INCLUDE_AUTOFILL_METADATA_CHECKBOX 12343
#define IDS_FEEDBACK_IWLWIFI_DEBUG_DUMP_EXPLAINER 12344
#define IDS_FEEDBACK_LOG_ID_CHECKBOX_LABEL 12345
#define IDS_FEEDBACK_PRIVACY_NOTE 12346
#define IDS_FEEDBACK_NO_DESCRIPTION 12347
#define IDS_FEEDBACK_OFFENSIVE_CHECKBOX_LABEL 12348
#define IDS_FEEDBACK_SEND_REPORT 12349
#define IDS_FEEDBACK_AUTOFILL_METADATA_PAGE_TITLE 12350
#define IDS_FEEDBACK_SYSINFO_PAGE_TITLE 12351
#define IDS_FEEDBACK_SYSINFO_PAGE_LOADING 12352
#define IDS_FEEDBACK_ADDITIONAL_INFO_LABEL 12353
#define IDS_CLEAR_BROWSING_DATA_TITLE 12354
#define IDS_CLEAR_BROWSING_DATA_HISTORY_NOTICE 12355
#define IDS_CLEAR_BROWSING_DATA_HISTORY_NOTICE_TITLE 12356
#define IDS_CLEAR_BROWSING_DATA_HISTORY_NOTICE_OK 12357
#define IDS_CLEAR_BROWSING_DATA_PASSWORDS_NOTICE 12358
#define IDS_CLEAR_BROWSING_DATA_PASSWORDS_NOTICE_TITLE 12359
#define IDS_CLEAR_BROWSING_DATA_PASSWORDS_NOTICE_OK 12360
#define IDS_MEDIA_SELECTED_MIC_LABEL 12361
#define IDS_MEDIA_SELECTED_CAMERA_LABEL 12362
#define IDS_MEDIA_MENU_NO_DEVICE_TITLE 12363
#define IDS_MEDIA_CONTROLS_TITLE_PLACEHOLDER_INCOGNITO 12364
#define IDS_ZOOMLEVELS_CHROME_ERROR_PAGES_LABEL 12365
#define IDS_STORAGE_ACCESS_MANAGE_TEXT 12366
#define IDS_STORAGE_ACCESS_MANAGE_TOOLTIP 12367
#define IDS_REPORT_AN_ISSUE 12378
#define IDS_REENABLE_UPDATES 12379
#define IDS_PICTURE_IN_PICTURE_TITLE_TEXT 12380
#define IDS_PICTURE_IN_PICTURE_PAUSE_CONTROL_TEXT 12381
#define IDS_PICTURE_IN_PICTURE_PLAY_CONTROL_TEXT 12382
#define IDS_PICTURE_IN_PICTURE_REPLAY_CONTROL_TEXT 12383
#define IDS_PICTURE_IN_PICTURE_BACK_TO_TAB_CONTROL_TEXT 12384
#define IDS_PICTURE_IN_PICTURE_SKIP_AD_CONTROL_TEXT 12385
#define IDS_PICTURE_IN_PICTURE_MUTE_MICROPHONE_TEXT 12386
#define IDS_PICTURE_IN_PICTURE_UNMUTE_MICROPHONE_TEXT 12387
#define IDS_PICTURE_IN_PICTURE_TURN_ON_CAMERA_TEXT 12388
#define IDS_PICTURE_IN_PICTURE_TURN_OFF_CAMERA_TEXT 12389
#define IDS_PICTURE_IN_PICTURE_HANG_UP_TEXT 12390
#define IDS_PICTURE_IN_PICTURE_CLOSE_CONTROL_TEXT 12391
#define IDS_PICTURE_IN_PICTURE_MINIMIZE_CONTROL_TEXT 12392
#define IDS_PICTURE_IN_PICTURE_RESIZE_HANDLE_TEXT 12393
#define IDS_PICTURE_IN_PICTURE_PLAY_PAUSE_CONTROL_ACCESSIBLE_TEXT 12394
#define IDS_PICTURE_IN_PICTURE_NEXT_TRACK_CONTROL_ACCESSIBLE_TEXT 12395
#define IDS_PICTURE_IN_PICTURE_PREVIOUS_TRACK_CONTROL_ACCESSIBLE_TEXT 12396
#define IDS_PICTURE_IN_PICTURE_PREVIOUS_SLIDE_CONTROL_ACCESSIBLE_TEXT 12397
#define IDS_PICTURE_IN_PICTURE_NEXT_SLIDE_CONTROL_ACCESSIBLE_TEXT 12398
#define IDS_AUTO_PICTURE_IN_PICTURE_DESCRIPTION 12399
#define IDS_LOAD_STATE_WAITING_FOR_SOCKET_SLOT 12400
#define IDS_LOAD_STATE_WAITING_FOR_DELEGATE 12401
#define IDS_LOAD_STATE_WAITING_FOR_DELEGATE_GENERIC 12402
#define IDS_LOAD_STATE_WAITING_FOR_CACHE 12403
#define IDS_LOAD_STATE_ESTABLISHING_PROXY_TUNNEL 12404
#define IDS_LOAD_STATE_RESOLVING_PROXY_FOR_URL 12405
#define IDS_LOAD_STATE_RESOLVING_HOST_IN_PAC_FILE 12406
#define IDS_LOAD_STATE_DOWNLOADING_PAC_FILE 12407
#define IDS_LOAD_STATE_RESOLVING_HOST 12408
#define IDS_LOAD_STATE_CONNECTING 12409
#define IDS_LOAD_STATE_SSL_HANDSHAKE 12410
#define IDS_LOAD_STATE_SENDING_REQUEST 12411
#define IDS_LOAD_STATE_SENDING_REQUEST_WITH_PROGRESS 12412
#define IDS_LOAD_STATE_WAITING_FOR_RESPONSE 12413
#define IDS_TAB_CXMENU_NEWTABTORIGHT 12414
#define IDS_TAB_CXMENU_NEWTABTOLEFT 12415
#define IDS_TAB_CXMENU_RELOAD 12416
#define IDS_TAB_CXMENU_DUPLICATE 12417
#define IDS_TAB_CXMENU_CLOSETAB 12418
#define IDS_TAB_CXMENU_CLOSEOTHERTABS 12419
#define IDS_TAB_CXMENU_CLOSETABSTORIGHT 12420
#define IDS_TAB_CXMENU_CLOSETABSTOLEFT 12421
#define IDS_TAB_CXMENU_CLOSEALLTABS 12422
#define IDS_TAB_CXMENU_FOCUS_THIS_TAB 12423
#define IDS_TAB_CXMENU_PIN_TAB 12424
#define IDS_TAB_CXMENU_UNPIN_TAB 12425
#define IDS_TAB_CXMENU_SOUND_MUTE_SITE 12426
#define IDS_TAB_CXMENU_SOUND_UNMUTE_SITE 12427
#define IDS_TAB_CXMENU_READ_LATER 12428
#define IDS_TAB_CXMENU_ADD_TAB_TO_GROUP 12429
#define IDS_TAB_CXMENU_ADD_TAB_TO_NEW_GROUP 12430
#define IDS_TAB_CXMENU_SUBMENU_NEW_GROUP 12431
#define IDS_TAB_CXMENU_REMOVE_TAB_FROM_GROUP 12432
#define IDS_TAB_CXMENU_PLACEHOLDER_GROUP_TITLE 12433
#define IDS_TAB_CXMENU_MOVE_TABS_TO_NEW_WINDOW 12434
#define IDS_TAB_CXMENU_MOVETOANOTHERWINDOW 12435
#define IDS_TAB_CXMENU_MOVETOANOTHERNEWWINDOW 12436
#define IDS_TAB_CXMENU_ORGANIZE_TABS 12437
#define IDS_TAB_CXMENU_COMMERCE_PRODUCT_SPEC 12438
#define IDS_WEBUI_TAB_STRIP_PROMO 12442
#define IDS_TOOLTIP_WEBUI_TAB_STRIP_TAB_COUNTER 12443
#define IDS_WEBUI_TAB_STRIP_TAB_COUNTER_CXMENU_NEW_TAB 12444
#define IDS_WEBUI_TAB_STRIP_TAB_COUNTER_CXMENU_CLOSE_TAB 12445
#define IDS_TAB_SEARCH_PROMO 12446
#define IDS_TAB_SEARCH_SEARCH_TABS 12447
#define IDS_TAB_SEARCH_NO_RESULTS_FOUND 12448
#define IDS_TAB_SEARCH_CLOSE_TAB 12449
#define IDS_TAB_SEARCH_SUBMIT_FEEDBACK 12450
#define IDS_TAB_SEARCH_A11Y_TAB_CLOSED 12451
#define IDS_TAB_SEARCH_A11Y_FOUND_TAB 12452
#define IDS_TAB_SEARCH_A11Y_FOUND_TABS 12453
#define IDS_TAB_SEARCH_A11Y_FOUND_TAB_FOR 12454
#define IDS_TAB_SEARCH_A11Y_FOUND_TABS_FOR 12455
#define IDS_TAB_SEARCH_A11Y_OPEN_TAB 12456
#define IDS_TAB_SEARCH_A11Y_RECENTLY_CLOSED_TAB 12457
#define IDS_TAB_SEARCH_A11Y_RECENTLY_CLOSED_TAB_GROUP 12458
#define IDS_TAB_SEARCH_MEDIA_TABS 12459
#define IDS_TAB_SEARCH_OPEN_TABS 12460
#define IDS_TAB_SEARCH_RECENTLY_CLOSED 12461
#define IDS_TAB_SEARCH_RECENTLY_CLOSED_TABS 12462
#define IDS_TAB_SEARCH_ONE_TAB 12463
#define IDS_TAB_SEARCH_TAB_COUNT 12464
#define IDS_TAB_SEARCH_EXPAND_RECENTLY_CLOSED_ITEMS 12465
#define IDS_TAB_SEARCH_EXPAND_RECENTLY_CLOSED 12466
#define IDS_TAB_SEARCH_COLLAPSE_RECENTLY_CLOSED 12467
#define IDS_TAB_SEARCH_TAB_NAME 12468
#define IDS_TAB_ORGANIZATION_TAB_NAME 12469
#define IDS_TAB_ORGANIZATION_CREATE_GROUP 12470
#define IDS_TAB_ORGANIZATION_CREATE_GROUPS 12471
#define IDS_TAB_ORGANIZATION_DISMISS 12472
#define IDS_TAB_ORGANIZATION_NEW_TABS 12473
#define IDS_TAB_ORGANIZATION_NOT_STARTED_TITLE 12474
#define IDS_TAB_ORGANIZATION_NOT_STARTED_TITLE_FRE 12475
#define IDS_TAB_ORGANIZATION_NOT_STARTED_BODY 12476
#define IDS_TAB_ORGANIZATION_NOT_STARTED_BODY_FRE 12477
#define IDS_TAB_ORGANIZATION_NOT_STARTED_BODY_LINK_FRE 12478
#define IDS_TAB_ORGANIZATION_NOT_STARTED_BODY_SIGNED_OUT 12479
#define IDS_TAB_ORGANIZATION_NOT_STARTED_BODY_UNSYNCED 12480
#define IDS_TAB_ORGANIZATION_NOT_STARTED_BODY_UNSYNCED_HISTORY 12481
#define IDS_TAB_ORGANIZATION_NOT_STARTED_BODY_SYNC_PAUSED 12482
#define IDS_TAB_ORGANIZATION_NOT_STARTED_BUTTON 12483
#define IDS_TAB_ORGANIZATION_NOT_STARTED_BUTTON_FRE 12484
#define IDS_TAB_ORGANIZATION_NOT_STARTED_BUTTON_UNSYNCED 12485
#define IDS_TAB_ORGANIZATION_NOT_STARTED_BUTTON_UNSYNCED_HISTORY 12486
#define IDS_TAB_ORGANIZATION_NOT_STARTED_BUTTON_SYNC_PAUSED 12487
#define IDS_TAB_ORGANIZATION_NOT_STARTED_BUTTON_ARIA_LABEL 12488
#define IDS_TAB_ORGANIZATION_NOT_STARTED_BUTTON_FRE_ARIA_LABEL 12489
#define IDS_TAB_ORGANIZATION_NOT_STARTED_BUTTON_UNSYNCED_ARIA_LABEL 12490
#define IDS_TAB_ORGANIZATION_NOT_STARTED_BUTTON_UNSYNCED_HISTORY_ARIA_LABEL 12491
#define IDS_TAB_ORGANIZATION_NOT_STARTED_BUTTON_SYNC_PAUSED_ARIA_LABEL 12492
#define IDS_TAB_ORGANIZATION_IN_PROGRESS_TITLE 12493
#define IDS_TAB_ORGANIZATION_SUCCESS_MISSING_ACTIVE_TAB_TITLE 12494
#define IDS_TAB_ORGANIZATION_SUCCESS_TITLE 12495
#define IDS_TAB_ORGANIZATION_SUCCESS_TITLE_SINGLE 12496
#define IDS_TAB_ORGANIZATION_SUCCESS_TITLE_MULTI 12497
#define IDS_TAB_ORGANIZATION_FAILURE_TITLE_GENERIC 12498
#define IDS_TAB_ORGANIZATION_FAILURE_TITLE_GROUPING 12499
#define IDS_TAB_ORGANIZATION_FAILURE_BODY_GENERIC 12500
#define IDS_TAB_ORGANIZATION_FAILURE_BODY_GROUPING 12501
#define IDS_TAB_ORGANIZATION_TIP_TITLE 12502
#define IDS_TAB_ORGANIZATION_TIP_BODY 12503
#define IDS_TAB_ORGANIZATION_TIP_ACTION 12504
#define IDS_TAB_ORGANIZATION_TIP_ARIA_DESCRIPTION 12505
#define IDS_TAB_ORGANIZATION_DISCLAIMER 12506
#define IDS_TAB_ORGANIZATION_LEARN_MORE 12507
#define IDS_TAB_ORGANIZATION_LEARN_MORE_ARIA_LABEL 12508
#define IDS_TAB_ORGANIZATION_CLOSE_TAB_ARIA_LABEL 12509
#define IDS_TAB_ORGANIZATION_CLOSE_TAB_TOOLTIP 12510
#define IDS_TAB_ORGANIZATION_CLEAR_SUGGESTIONS 12511
#define IDS_TAB_ORGANIZATION_CLEAR_ARIA_LABEL 12512
#define IDS_TAB_ORGANIZATION_INPUT_ARIA_LABEL 12513
#define IDS_TAB_ORGANIZATION_EDIT_ARIA_LABEL 12514
#define IDS_TAB_ORGANIZATION_REJECT_ARIA_LABEL 12515
#define IDS_TAB_ORGANIZATION_THUMBS_DOWN 12516
#define IDS_TAB_ORGANIZATION_THUMBS_UP 12517
#define IDS_BROWSER_WINDOW_TITLE_MENU_ENTRY 12518
#define IDS_TABS_TITLE_CXMENU 12519
#define IDS_SAVED_TAB_GROUP_TABS_COUNT 12520
#define IDS_CREATE_NEW_TAB_GROUP 12521
#define IDS_SAVED_TAB_GROUPS_MENU 12522
#define IDS_OPEN_GROUP_IN_BROWSER_MENU 12523
#define IDS_SAVED_TAB_GROUPS_V2_INTRO_IPH_APP_MENU_SYNCED_BODY 12524
#define IDS_SAVED_TAB_GROUPS_V2_INTRO_DEFAULT_BODY_A11Y 12525
#define IDS_SAVED_TAB_GROUPS_V2_INTRO_IPH_APP_MENU_NOT_SYNCED_BODY 12526
#define IDS_SAVED_TAB_GROUPS_V2_INTRO_IPH_BOOKMARKS_BAR_SYNCED_BODY 12527
#define IDS_SAVED_TAB_GROUPS_V2_INTRO_IPH_BOOKMARKS_BAR_NOT_SYNCED_BODY 12528
#define IDS_TAB_GROUP_DELETION_DIALOG_MISSING_EMAIL 12529
#define IDS_TAB_GROUP_DELETION_DIALOG_BODY_SYNCED_DELETE 12530
#define IDS_TAB_GROUP_DELETION_DIALOG_BODY_SYNCED_UNGROUP 12531
#define IDS_TAB_GROUP_DELETION_DIALOG_BODY_NOT_SYNCED_DELETE 12532
#define IDS_TAB_GROUP_DELETION_DIALOG_BODY_NOT_SYNCED_UNGROUP 12533
#define IDS_TAB_GROUP_DELETION_DIALOG_DONT_ASK 12534
#define IDS_TAB_GROUP_DELETION_DIALOG_TITLE_DELETE 12535
#define IDS_TAB_GROUP_DELETION_DIALOG_TITLE_UNGROUP 12536
#define IDS_TAB_GROUP_DELETION_DIALOG_TITLE_CLOSE_TAB_AND_DELETE 12537
#define IDS_TAB_GROUP_DELETION_DIALOG_TITLE_REMOVE_TAB_AND_DELETE 12538
#define IDS_TAB_GROUP_DELETION_DIALOG_OK_TEXT_DELETE 12539
#define IDS_TAB_GROUP_DELETION_DIALOG_OK_TEXT_UNGROUP 12540
#define IDS_TAB_GROUP_HEADER_CXMENU_TAB_GROUP_TITLE_ACCESSIBLE_NAME 12541
#define IDS_TAB_GROUP_HEADER_CXMENU_SAVE_GROUP 12542
#define IDS_TAB_GROUP_HEADER_CXMENU_UNSAVE_GROUP 12543
#define IDS_TAB_GROUP_HEADER_CXMENU_NEW_TAB_IN_GROUP 12544
#define IDS_TAB_GROUP_HEADER_CXMENU_UNGROUP 12545
#define IDS_TAB_GROUP_HEADER_CXMENU_CLOSE_GROUP 12546
#define IDS_TAB_GROUP_HEADER_CXMENU_HIDE_GROUP 12547
#define IDS_TAB_GROUP_HEADER_CXMENU_DELETE_GROUP 12548
#define IDS_TAB_GROUP_HEADER_CXMENU_MOVE_GROUP_TO_NEW_WINDOW 12549
#define IDS_TAB_GROUP_HEADER_CXMENU_OPEN_GROUP_IN_NEW_WINDOW 12550
#define IDS_TAB_GROUP_HEADER_CXMENU_PIN_GROUP 12551
#define IDS_TAB_GROUP_HEADER_CXMENU_UNPIN_GROUP 12552
#define IDS_TAB_GROUP_HEADER_CXMENU_SEND_FEEDBACK 12553
#define IDS_TAB_GROUP_HEADER_BUBBLE_TITLE_PLACEHOLDER 12554
#define IDS_APP_MENU_RELOAD 12555
#define IDS_APP_MENU_NEW_WEB_PAGE 12556
#define IDS_APP_MENU_COPY_LINK 12557
#define IDS_APP_MENU_CREATE_QR_CODE 12558
#define IDS_APP_MENU_BUTTON_UPDATE 12559
#define IDS_APP_MENU_BUTTON_UPDATE_ALT1 12560
#define IDS_APP_MENU_BUTTON_UPDATE_ALT2 12561
#define IDS_APP_MENU_BUTTON_UPDATE_ALT3 12562
#define IDS_APP_MENU_BUTTON_ERROR 12563
#define IDS_MEDIA_SCREEN_CAPTURE_CONFIRMATION_TITLE 12564
#define IDS_MEDIA_SCREEN_CAPTURE_CONFIRMATION_TEXT 12565
#define IDS_MEDIA_SCREEN_AND_AUDIO_CAPTURE_CONFIRMATION_TEXT 12566
#define IDS_MEDIA_SCREEN_CAPTURE_NOTIFICATION_TEXT 12567
#define IDS_MEDIA_SCREEN_CAPTURE_WITH_AUDIO_NOTIFICATION_TEXT 12568
#define IDS_MEDIA_WINDOW_CAPTURE_NOTIFICATION_TEXT 12569
#define IDS_MEDIA_TAB_CAPTURE_NOTIFICATION_TEXT 12570
#define IDS_MEDIA_TAB_CAPTURE_WITH_AUDIO_NOTIFICATION_TEXT 12571
#define IDS_MEDIA_SCREEN_CAPTURE_NOTIFICATION_HIDE 12572
#define IDS_MEDIA_SCREEN_CAPTURE_NOTIFICATION_SOURCE 12573
#define IDS_MEDIA_SCREEN_CAPTURE_NOTIFICATION_STOP 12574
#define IDS_PLATFORM_KEYS_SELECT_CERT_DIALOG_TEXT 12577
#define IDS_UNSAFE_FRAME_MESSAGE 12578
#define IDS_CLIENT_CERT_DIALOG_TITLE 12579
#define IDS_CLIENT_CERT_DIALOG_TEXT 12580
#define IDS_CRYPTO_MODULE_AUTH_DIALOG_TITLE 12581
#define IDS_CRYPTO_MODULE_AUTH_DIALOG_TEXT_CERT_ENROLLMENT 12582
#define IDS_CRYPTO_MODULE_AUTH_DIALOG_TEXT_CLIENT_AUTH 12583
#define IDS_CRYPTO_MODULE_AUTH_DIALOG_TEXT_LIST_CERTS 12584
#define IDS_CRYPTO_MODULE_AUTH_DIALOG_TEXT_CERT_IMPORT 12585
#define IDS_CRYPTO_MODULE_AUTH_DIALOG_TEXT_CERT_EXPORT 12586
#define IDS_CRYPTO_MODULE_AUTH_DIALOG_PASSWORD_FIELD 12587
#define IDS_CRYPTO_MODULE_AUTH_DIALOG_OK_BUTTON_LABEL 12588
#define IDS_FR_ENABLE_LOGGING 12590
#define IDS_CRASHED_TAB_FEEDBACK_MESSAGE 12594
#define IDS_CRASHED_TAB_FEEDBACK_LINK 12595
#define IDS_KILLED_TAB_FEEDBACK_MESSAGE 12597
#define IDS_RELAUNCH_BUTTON 12599
#define IDS_HELP_MANAGED_BY_YOUR_PARENT 12600
#define IDS_TOOLBAR_INFORM_SET_HOME_PAGE 12603
#define IDS_MANAGE_EXTENSIONS_SETTING_WINDOWS_TITLE 12604
#define IDS_CONTROLLED_SETTING_POLICY 12605
#define IDS_CONTROLLED_SETTING_EXTENSION 12606
#define IDS_CONTROLLED_SETTING_EXTENSION_WITHOUT_NAME 12607
#define IDS_CONTROLLED_SETTING_RECOMMENDED 12608
#define IDS_CONTROLLED_SETTING_HAS_RECOMMENDATION 12609
#define IDS_CONTROLLED_SETTING_CHILD_RESTRICTION 12610
#define IDS_CONTROLLED_SETTING_PARENT 12611
#define IDS_EXTENSIONS_INSTALL_LOCATION_UNKNOWN 12612
#define IDS_EXTENSIONS_INSTALL_LOCATION_3RD_PARTY 12613
#define IDS_EXTENSIONS_INSTALL_LOCATION_ENTERPRISE 12614
#define IDS_EXTENSIONS_INSTALL_LOCATION_SHARED_MODULE 12615
#define IDS_EXTENSIONS_BLOCKLISTED_MALWARE 12616
#define IDS_EXTENSIONS_BLOCKLISTED_SECURITY_VULNERABILITY 12617
#define IDS_EXTENSIONS_BLOCKLISTED_CWS_POLICY_VIOLATION 12618
#define IDS_EXTENSIONS_BLOCKLISTED_POTENTIALLY_UNWANTED 12619
#define IDS_EXTENSIONS_SAFE_BROWSING_CRX_ALLOWLIST_WARNING 12620
#define IDS_EXTENSIONS_SAFE_BROWSING_CRX_ALLOWLIST_WARNING_LEARN_MORE 12621
#define IDS_EXTENSIONS_ACCESS_REQUESTS_LEARN_MORE 12622
#define IDS_RESET_PROFILE_SETTINGS_EXPLANATION 12623
#define IDS_RESET_PROFILE_SETTINGS_EXPLANATION_IN_BULLET_POINTS 12624
#define IDS_TRIGGERED_RESET_PROFILE_SETTINGS_TITLE 12625
#define IDS_TRIGGERED_RESET_PROFILE_SETTINGS_EXPLANATION 12626
#define IDS_TRIGGERED_RESET_PROFILE_SETTINGS_DEFAULT_TOOL_NAME 12627
#define IDS_RESET_PROFILE_SETTINGS_LOCALE 12628
#define IDS_RESET_PROFILE_SETTINGS_STARTUP_URLS 12629
#define IDS_RESET_PROFILE_SETTINGS_STARTUP_TYPE 12630
#define IDS_RESET_PROFILE_SETTINGS_HOMEPAGE 12631
#define IDS_RESET_PROFILE_SETTINGS_HOMEPAGE_IS_NTP 12632
#define IDS_RESET_PROFILE_SETTINGS_YES 12633
#define IDS_RESET_PROFILE_SETTINGS_NO 12634
#define IDS_RESET_PROFILE_SETTINGS_SHOW_HOME_BUTTON 12635
#define IDS_RESET_PROFILE_SETTINGS_DSE 12636
#define IDS_RESET_PROFILE_SETTINGS_EXTENSIONS 12637
#define IDS_RESET_PROFILE_SETTINGS_SHORTCUTS 12638
#define IDS_RESET_PROFILE_SETTINGS_PROCESSING_SHORTCUTS 12639
#define IDS_AUTOFILL_DIALOG_PLACEHOLDER_EXPIRY_MONTH 12641
#define IDS_AUTOFILL_DIALOG_PLACEHOLDER_EXPIRY_YEAR 12642
#define IDS_AUTOFILL_FROM_GOOGLE_ACCOUNT 12643
#define IDS_SHOW_WINDOW_DECORATIONS 12644
#define IDS_OMNIBOX_ICON_SEND_TAB_TO_SELF 12645
#define IDS_OMNIBOX_TOOLTIP_SEND_TAB_TO_SELF 12646
#define IDS_OMNIBOX_BUBBLE_ITEM_SUBTITLE_TODAY_SEND_TAB_TO_SELF 12647
#define IDS_OMNIBOX_BUBBLE_ITEM_SUBTITLE_DAY_SEND_TAB_TO_SELF 12648
#define IDS_OMNIBOX_BUBBLE_ITEM_SUBTITLE_DAYS_SEND_TAB_TO_SELF 12649
#define IDS_TOOLBAR_BUTTON_SEND_TAB_TO_SELF_FROM_DEVICE 12650
#define IDS_TOOLBAR_BUTTON_SEND_TAB_TO_SELF_TITLE 12651
#define IDS_TOOLBAR_BUTTON_SEND_TAB_TO_SELF_BUTTON_LABEL 12652
#define IDS_TOOLBAR_BUTTON_SEND_TAB_TO_SELF_BUTTON_A11Y_NAME 12653
#define IDS_TOOLBAR_BUTTON_SEND_TAB_TO_SELF_BUTTON_HINT_TEXT 12654
#define IDS_MENU_SEND_TAB_TO_SELF 12655
#define IDS_SEND_TAB_TO_SELF 12656
#define IDS_SEND_TAB_TO_SELF_SENDING_ANNOUNCE 12659
#define IDS_SEND_TAB_TO_SELF_MANAGE_DEVICES_LINK 12660
#define IDS_SEND_TAB_TO_SELF_SIGN_IN_PROMO_LABEL 12661
#define IDS_SEND_TAB_TO_SELF_NO_TARGET_DEVICE_LABEL 12662
#define IDS_CONTEXT_MENU_GENERATE_QR_CODE_PAGE 12663
#define IDS_CONTEXT_MENU_GENERATE_QR_CODE_IMAGE 12664
#define IDS_CONTEXT_MENU_GENERATE_QR_CODE_LINK 12665
#define IDS_OMNIBOX_QRCODE_GENERATOR_ICON_LABEL 12666
#define IDS_OMNIBOX_QRCODE_GENERATOR_ICON_TOOLTIP 12667
#define IDS_BROWSER_SHARING_QR_CODE_DIALOG_TITLE 12668
#define IDS_SHARING_HUB_GENERATE_QR_CODE_LABEL 12669
#define IDS_BROWSER_SHARING_QR_CODE_DIALOG_URL_TEXTFIELD_ACCESSIBLE_NAME 12670
#define IDS_BROWSER_SHARING_QR_CODE_DIALOG_TOOLTIP 12671
#define IDS_BROWSER_SHARING_QR_CODE_DIALOG_DOWNLOAD_BUTTON_LABEL 12672
#define IDS_BROWSER_SHARING_QR_CODE_DIALOG_COPY_BUTTON_LABEL 12673
#define IDS_BROWSER_SHARING_QR_CODE_DIALOG_ERROR_TOO_LONG 12674
#define IDS_BROWSER_SHARING_QR_CODE_DIALOG_ERROR_UNKNOWN 12675
#define IDS_SHARING_HUB_TITLE 12676
#define IDS_SHARING_HUB_TOOLTIP 12677
#define IDS_SHARING_HUB_SCREENSHOT_LABEL 12678
#define IDS_SHARING_HUB_COPY_LINK_LABEL 12679
#define IDS_SHARING_HUB_SAVE_PAGE_LABEL 12680
#define IDS_SHARING_HUB_MEDIA_ROUTER_LABEL 12681
#define IDS_SHARING_HUB_SHARE_LABEL 12682
#define IDS_BROWSER_SHARING_SCREENSHOT_POST_CAPTURE_TITLE 12683
#define IDS_BROWSER_SHARING_SCREENSHOT_DIALOG_DOWNLOAD_BUTTON_LABEL 12684
#define IDS_BROWSER_SHARING_SCREENSHOT_DIALOG_EDIT_BUTTON_LABEL 12685
#define IDS_BROWSER_SHARING_SCREENSHOT_DIALOG_SHARE_BUTTON_LABEL 12686
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_SELECTION 12687
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_CROP 12688
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_TEXT 12689
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_ELLIPSE 12690
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_RECTANGLE 12691
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_LINE 12692
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_ARROW 12693
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_BRUSH 12694
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_EMOJI 12695
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_HIGHLIGHTER 12696
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_UNDO 12697
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_REDO 12698
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_ZOOM_IN 12699
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_ZOOM_OUT 12700
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_COMMIT_CROP 12701
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_COMMIT_CROP 12702
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_CANCEL_CROP 12703
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_CANCEL_CROP 12704
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_BUTTON_DOWNLOAD_IMAGE 12705
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_BUTTON_COPY 12706
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TITLE 12707
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_BUTTON_TEXT_CLEAR 12708
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_ALIGN_LEFT 12709
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_ALIGN_CENTER 12710
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_ALIGN_RIGHT 12711
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_SHADOW_NONE 12712
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_SHADOW_SMALL 12713
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_SHADOW_LARGE 12714
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_FONT_DEFAULT 12715
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_FONT_MONOSPACE 12716
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_FONT_ITALIC 12717
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_FONT_OUTLINE 12718
#define IDS_CONTEXT_MENU_SHOW_CLIPBOARD_HISTORY_MENU 12719
#define IDS_CONTEXT_MENU_PASTE_FROM_CLIPBOARD 12720
#define IDS_SHARING_REMOTE_COPY_NOTIFICATION_TITLE_TEXT_CONTENT_UNKNOWN_DEVICE 12721
#define IDS_SHARING_REMOTE_COPY_NOTIFICATION_TITLE_TEXT_CONTENT 12722
#define IDS_SHARING_REMOTE_COPY_NOTIFICATION_TITLE_IMAGE_CONTENT_UNKNOWN_DEVICE 12723
#define IDS_SHARING_REMOTE_COPY_NOTIFICATION_TITLE_IMAGE_CONTENT 12724
#define IDS_SHARING_REMOTE_COPY_NOTIFICATION_DESCRIPTION 12725
#define IDS_CONTENT_CONTEXT_SHARING_CLICK_TO_CALL_MULTIPLE_DEVICES 12726
#define IDS_CONTENT_CONTEXT_SHARING_CLICK_TO_CALL_SINGLE_DEVICE 12727
#define IDS_CONTENT_CONTEXT_SHARING_SHARED_CLIPBOARD_MULTIPLE_DEVICES 12728
#define IDS_CONTENT_CONTEXT_SHARING_SHARED_CLIPBOARD_SINGLE_DEVICE 12729
#define IDS_CONTENT_CONTEXT_SHARING_SHARED_CLIPBOARD_NOTIFICATION_TITLE_UNKNOWN_DEVICE 12730
#define IDS_CONTENT_CONTEXT_SHARING_SHARED_CLIPBOARD_NOTIFICATION_TITLE 12731
#define IDS_CONTENT_CONTEXT_SHARING_SHARED_CLIPBOARD_NOTIFICATION_DESCRIPTION 12732
#define IDS_OMNIBOX_TOOLTIP_SHARED_CLIPBOARD 12733
#define IDS_COLLECTED_COOKIES_DIALOG_TITLE 12734
#define IDS_COLLECTED_COOKIES_ALLOWED_COOKIES_LABEL 12735
#define IDS_COLLECTED_COOKIES_BLOCKED_COOKIES_LABEL 12736
#define IDS_COLLECTED_COOKIES_BLOCKED_THIRD_PARTY_BLOCKING_ENABLED 12737
#define IDS_COLLECTED_COOKIES_ALLOW_BUTTON 12738
#define IDS_COLLECTED_COOKIES_SESSION_ONLY_BUTTON 12739
#define IDS_COLLECTED_COOKIES_BLOCK_BUTTON 12740
#define IDS_COLLECTED_COOKIES_ALLOW_RULE_CREATED 12741
#define IDS_COLLECTED_COOKIES_BLOCK_RULE_CREATED 12742
#define IDS_COLLECTED_COOKIES_SESSION_RULE_CREATED 12743
#define IDS_COLLECTED_COOKIES_ALLOWED_COOKIES_TAB_LABEL 12744
#define IDS_COLLECTED_COOKIES_BLOCKED_COOKIES_TAB_LABEL 12745
#define IDS_COLLECTED_COOKIES_ALLOWED_AUX_TEXT 12746
#define IDS_COLLECTED_COOKIES_BLOCKED_AUX_TEXT 12747
#define IDS_COLLECTED_COOKIES_CLEAR_ON_EXIT_AUX_TEXT 12748
#define IDS_COLLECTED_COOKIES_INFOBAR_MESSAGE 12749
#define IDS_COLLECTED_COOKIES_INFOBAR_BUTTON 12750
#define IDS_COLLECTED_COOKIES_PARTITIONED_COOKIE 12751
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_TITLE 12752
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_SUBTITLE 12753
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_SETTINGS_LINK 12754
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_FIRST_PARTY_TITLE 12755
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_FIRST_PARTY_SUBTITLE 12756
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_THIRD_PARTY_TITLE 12757
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_THIRD_PARTY_SUBTITLE 12758
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_EMPTY_STATE_LABEL 12759
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_ALLOW_MENU_ITEM 12760
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_ALLOW_THIRD_PARTY_MENU_ITEM 12761
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_BLOCK_MENU_ITEM 12762
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_SESSION_ONLY_MENU_ITEM 12763
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_ALLOWED_STATE_SUBTITLE 12764
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_BLOCKED_STATE_SUBTITLE 12765
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_SESSION_ONLY_STATE_SUBTITLE 12766
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_PARTITIONED_STATE_SUBTITLE 12767
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_PARTITIONED_SESSION_ONLY_STATE_SUBTITLE 12768
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_CONTEXT_MENU_TOOLTIP 12769
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_DELETE_BUTTON_TOOLTIP 12770
#define IDS_ACCNAME_INFOBAR_CONTAINER 12771
#define IDS_ACCNAME_INFOBAR 12772
#define IDS_ONE_CLICK_BUBBLE_UNDO 12773
#define IDS_ONE_CLICK_SIGNIN_BUBBLE_MESSAGE 12774
#define IDS_ONE_CLICK_SIGNIN_DIALOG_OK_BUTTON 12775
#define IDS_ONE_CLICK_SIGNIN_DIALOG_UNDO_BUTTON 12776
#define IDS_ONE_CLICK_SIGNIN_DIALOG_ADVANCED 12777
#define IDS_ENTERPRISE_SIGNIN_CANCEL 12778
#define IDS_ENTERPRISE_SIGNIN_CREATE_NEW_PROFILE 12779
#define IDS_ENTERPRISE_SIGNIN_CREATE_NEW_WORK_PROFILE 12780
#define IDS_ENTERPRISE_SIGNIN_CONTINUE 12781
#define IDS_ENTERPRISE_SIGNIN_ALERT 12782
#define IDS_PROFILE_WILL_BE_DELETED_DIALOG_TITLE 12783
#define IDS_PROFILE_WILL_BE_DELETED_DIALOG_DESCRIPTION 12784
#define IDS_MANAGED_WITH_HYPERLINK 12787
#define IDS_MANAGED_BY_WITH_HYPERLINK 12788
#define IDS_PROFILE_MANAGED_BY_WITH_HYPERLINK 12789
#define IDS_BROWSER_MANAGED_AND_PROFILE_MANAGED_BY_WITH_HYPERLINK 12790
#define IDS_BROWSER_AND_PROFILE_DIFFERENT_MANAGED_BY_WITH_HYPERLINK 12791
#define IDS_BROWSER_AND_PROFILE_SAME_MANAGED_BY_WITH_HYPERLINK 12792
#define IDS_MANAGED_BY_PARENT_WITH_HYPERLINK 12793
#define IDS_BROWSER_MANAGED_AND_PROFILE_MANAGED_BY_TOOLTIP 12794
#define IDS_BROWSER_AND_PROFILE_DIFFERENT_MANAGED_BY_TOOLTIP 12795
#define IDS_COOKIES_COOKIE_EXPIRES_SESSION 12796
#define IDS_COOKIES_COOKIE_SENDFOR_ANY 12797
#define IDS_COOKIES_COOKIE_SENDFOR_SECURE 12798
#define IDS_COOKIES_COOKIE_SENDFOR_SAME_SITE 12799
#define IDS_COOKIES_COOKIE_SENDFOR_SECURE_SAME_SITE 12800
#define IDS_COOKIES_COOKIE_ACCESSIBLE_TO_SCRIPT_YES 12801
#define IDS_COOKIES_COOKIE_ACCESSIBLE_TO_SCRIPT_NO 12802
#define IDS_COOKIES_COOKIES 12803
#define IDS_COOKIES_WEB_DATABASES 12804
#define IDS_COOKIES_LOCAL_STORAGE 12805
#define IDS_COOKIES_SESSION_STORAGE 12806
#define IDS_COOKIES_INDEXED_DBS 12807
#define IDS_COOKIES_FILE_SYSTEMS 12808
#define IDS_COOKIES_FILE_SYSTEM_USAGE_NONE 12809
#define IDS_COOKIES_SERVICE_WORKER 12810
#define IDS_COOKIES_SERVICE_WORKERS 12811
#define IDS_COOKIES_SHARED_WORKERS 12812
#define IDS_COOKIES_CACHE_STORAGE 12813
#define IDS_APP_DEFAULT_PAGE_NAME 12814
#define IDS_APP_LAUNCHER_TAB_TITLE 12815
#define IDS_NEW_TAB_GUEST_SESSION_HEADING 12816
#define IDS_NEW_TAB_GUEST_SESSION_DESCRIPTION 12817
#define IDS_NEW_TAB_GUEST_SESSION_LEARN_MORE_ACCESSIBILITY_TEXT 12818
#define IDS_NEW_TAB_TILE_GRID_ACCESSIBLE_DESCRIPTION 12819
#define IDS_NEW_TAB_APP_INSTALL_HINT_LABEL 12820
#define IDS_NEW_TAB_MOST_VISITED 12821
#define IDS_NEW_TAB_RESTORE_THUMBNAILS_SHORT_LINK 12822
#define IDS_NEW_TAB_ATTRIBUTION_INTRO 12823
#define IDS_NEW_TAB_THUMBNAIL_REMOVED_NOTIFICATION 12824
#define IDS_NEW_TAB_REMOVE_THUMBNAIL_TOOLTIP 12825
#define IDS_NEW_TAB_PAGE_SWITCHER_CHANGE_TITLE 12826
#define IDS_NEW_TAB_PAGE_SWITCHER_SAME_TITLE 12827
#define IDS_NEW_TAB_VOICE_AUDIO_ERROR 12828
#define IDS_NEW_TAB_VOICE_CLOSE_TOOLTIP 12829
#define IDS_NEW_TAB_VOICE_DETAILS 12830
#define IDS_NEW_TAB_VOICE_LANGUAGE_ERROR 12831
#define IDS_NEW_TAB_VOICE_LISTENING 12832
#define IDS_NEW_TAB_VOICE_NETWORK_ERROR 12833
#define IDS_NEW_TAB_VOICE_NO_TRANSLATION 12834
#define IDS_NEW_TAB_VOICE_NO_VOICE 12835
#define IDS_NEW_TAB_VOICE_OTHER_ERROR 12836
#define IDS_NEW_TAB_VOICE_PERMISSION_ERROR 12837
#define IDS_NEW_TAB_VOICE_LEARN_MORE_ACCESSIBILITY_LABEL 12838
#define IDS_NEW_TAB_VOICE_READY 12839
#define IDS_NEW_TAB_VOICE_TRY_AGAIN 12840
#define IDS_NEW_TAB_VOICE_WAITING 12841
#define IDS_NEW_TAB_VOICE_SEARCH_CLOSED 12842
#define IDS_NEW_TAB_APP_OPTIONS 12843
#define IDS_NEW_TAB_APP_DETAILS 12844
#define IDS_NEW_TAB_APP_CREATE_SHORTCUT 12845
#define IDS_NEW_TAB_APP_INSTALL_LOCALLY 12846
#define IDS_APP_CONTEXT_MENU_SHOW_INFO 12847
#define IDS_APP_CONTEXT_MENU_OPEN_PINNED 12848
#define IDS_APP_CONTEXT_MENU_OPEN_REGULAR 12849
#define IDS_APP_CONTEXT_MENU_OPEN_WINDOW 12850
#define IDS_APP_CONTEXT_MENU_OPEN_FULLSCREEN 12851
#define IDS_APP_CONTEXT_MENU_OPEN_MAXIMIZED 12852
#define IDS_APP_CONTEXT_MENU_OPEN_TAB 12853
#define IDS_APP_CONTEXT_MENU_RUN_ON_OS_LOGIN 12858
#define IDS_APPS_PAGE_DEPRECATED_APP_TITLE 12861
#define IDS_DEVICE_SIGNALS_CONSENT_DIALOG_TITLE 12862
#define IDS_DEVICE_SIGNALS_CONSENT_DIALOG_PROCEED_BUTTON 12863
#define IDS_DEVICE_SIGNALS_CONSENT_DIALOG_CANCEL_BUTTON 12864
#define IDS_DEVICE_SIGNALS_CONSENT_DIALOG_BODY_TEXT 12865
#define IDS_DEVICE_SIGNALS_CONSENT_DIALOG_DEFAULT_BODY_TEXT 12866
#define IDS_SYNC_CONFIRMATION_SETTINGS_INFO 12867
#define IDS_SYNC_CONFIRMATION_CONFIRM_BUTTON_LABEL 12868
#define IDS_SYNC_CONFIRMATION_SETTINGS_BUTTON_LABEL 12869
#define IDS_SYNC_CONFIRMATION_REFRESHED_SETTINGS_BUTTON_LABEL 12870
#define IDS_SYNC_CONFIRMATION_TANGIBLE_SYNC_TITLE 12871
#define IDS_SYNC_CONFIRMATION_TANGIBLE_SYNC_INFO_TITLE 12872
#define IDS_SYNC_CONFIRMATION_TANGIBLE_SYNC_INFO_TITLE_SIGNIN_INTERCEPT_V2 12874
#define IDS_SYNC_CONFIRMATION_TANGIBLE_SYNC_BOOKMARKS 12875
#define IDS_SYNC_CONFIRMATION_TANGIBLE_SYNC_READING_LIST 12876
#define IDS_SYNC_CONFIRMATION_TANGIBLE_SYNC_AUTOFILL 12877
#define IDS_SYNC_CONFIRMATION_TANGIBLE_SYNC_EXTENSIONS 12878
#define IDS_SYNC_CONFIRMATION_TANGIBLE_SYNC_HISTORY_AND_MORE 12879
#define IDS_SYNC_CONFIRMATION_TANGIBLE_SYNC_INFO_DESC 12880
#define IDS_SYNC_CONFIRMATION_WELCOME_TITLE_SIGNIN_INTERCEPT 12882
#define IDS_SYNC_CONFIRMATION_TURN_ON_SYNC_BUTTON_LABEL 12883
#define IDS_SYNC_DISABLED_CONFIRMATION_CHROME_SYNC_TITLE 12884
#define IDS_SYNC_DISABLED_CONFIRMATION_DETAILS 12885
#define IDS_SYNC_DISABLED_CONFIRMATION_CONFIRM_BUTTON_LABEL 12886
#define IDS_SYNC_DISABLED_CONFIRMATION_CONFIRM_BUTTON_MANAGED_ACCOUNT_SIGNOUT_DISALLOWED_LABEL 12887
#define IDS_SYNC_DISABLED_CONFIRMATION_UNDO_BUTTON_LABEL 12888
#define IDS_SYNC_LOADING_CONFIRMATION_TITLE 12889
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_BUBBLE_NEW_PROFILE_BUTTON_LABEL 12890
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_AVATAR_BUTTON_SEPARATE_BROWSING_TEXT 12891
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_AVATAR_BUTTON_SWITCH_PROFILE_TEXT 12892
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_BUBBLE_CREATE_PROFILE_BUTTON_LABEL 12893
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_BUBBLE_STAY_HERE_BUTTON_LABEL 12894
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_BUBBLE_CANCEL_BUTTON_LABEL 12895
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_BUBBLE_CANCEL_SWITCH_BUTTON_LABEL 12896
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_BUBBLE_CONFIRM_SWITCH_BUTTON_LABEL 12897
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_SWITCH_BUBBLE_CONTINUE_BUTTON_LABEL 12898
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_BUBBLE_CHROME_SIGNIN_ACCEPT_TEXT 12899
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_ENTERPRISE_BUBBLE_DESC 12900
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_ENTERPRISE_BUBBLE_DESC_MANAGED_BY_TOKEN 12901
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_MANAGED_DISCLAIMER 12902
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_MANAGED_BY_DISCLAIMER 12903
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_BUBBLE_CHROME_SIGNIN_IPH_TITLE_SIGNIN_REMINDER 12904
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_BUBBLE_CHROME_SIGNIN_IPH_OK_BUTTON 12905
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_BUBBLE_CHROME_SIGNIN_IPH_SETTINGS_BUTTON 12906
#define IDS_CHROME_SIGNOUT_CONFIRMATION_PROMPT_TITLE 12907
#define IDS_CHROME_SIGNOUT_CONFIRMATION_PROMPT_SIGNOUT_BUTTON 12908
#define IDS_CHROME_SIGNOUT_CONFIRMATION_PROMPT_DELETE_AND_SIGNOUT_BUTTON 12909
#define IDS_CLOSE_WARNING_FOR_CLEAR_COOKIES_ON_EXIT_TEXT_LINK 12910
#define IDS_CLOSE_WARNING_FOR_CLEAR_COOKIES_ON_EXIT_CLOSE 12911
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_ENTERPRISE_PROFILE_NAME 12912
#define IDS_SIGNIN_ERROR_TITLE 12913
#define IDS_SIGNIN_ERROR_EMAIL_TITLE 12914
#define IDS_SIGNIN_ERROR_CLOSE_BUTTON_LABEL 12915
#define IDS_SIGNIN_ERROR_OK_BUTTON_LABEL 12916
#define IDS_SIGNIN_ERROR_SWITCH_BUTTON_LABEL 12917
#define IDS_SIGNIN_ACCESSIBLE_CLOSE_BUTTON 12918
#define IDS_SIGNIN_ACCESSIBLE_BACK_BUTTON 12919
#define IDS_SIGNIN_EMAIL_CONFIRMATION_CREATE_PROFILE_RADIO_BUTTON_TITLE 12920
#define IDS_SIGNIN_EMAIL_CONFIRMATION_CREATE_PROFILE_RADIO_BUTTON_SUBTITLE 12921
#define IDS_SIGNIN_EMAIL_CONFIRMATION_START_SYNC_RADIO_BUTTON_TITLE 12922
#define IDS_SIGNIN_EMAIL_CONFIRMATION_START_SYNC_RADIO_BUTTON_SUBTITLE 12923
#define IDS_SIGNIN_EMAIL_CONFIRMATION_CLOSE_BUTTON_LABEL 12924
#define IDS_SIGNIN_EMAIL_CONFIRMATION_CONFIRM_BUTTON_LABEL 12925
#define IDS_ACCOUNT_PASSWORDS_REAUTH_TITLE 12926
#define IDS_ACCOUNT_PASSWORDS_WITH_PASSKEYS_REAUTH_TITLE 12927
#define IDS_ACCOUNT_PASSWORDS_REAUTH_DESC 12928
#define IDS_ACCOUNT_PASSWORDS_WITH_PASSKEYS_REAUTH_DESC 12929
#define IDS_ACCOUNT_PASSWORDS_REAUTH_DESC_ALREADY_SAVED_LOCALLY 12930
#define IDS_ACCOUNT_PASSWORDS_WITH_PASSKEYS_REAUTH_DESC_ALREADY_SAVED_LOCALLY 12931
#define IDS_ACCOUNT_PASSWORDS_REAUTH_CONFIRM_BUTTON_LABEL 12932
#define IDS_ACCOUNT_PASSWORDS_REAUTH_CLOSE_BUTTON_LABEL 12933
#define IDS_ACCOUNT_PASSWORDS_REAUTH_CLOSE_BUTTON_LABEL_ALREADY_SAVED_LOCALLY 12934
#define IDS_PLUGIN_CRASHED_PROMPT 12935
#define IDS_RELOAD_PAGE_WITH_PLUGIN 12937
#define IDS_PLUGIN_INITIALIZATION_ERROR_PROMPT 12938
#define IDS_EXTERNAL_PROTOCOL_TITLE 12939
#define IDS_EXTERNAL_PROTOCOL_MESSAGE_WITH_INITIATING_ORIGIN 12940
#define IDS_EXTERNAL_PROTOCOL_MESSAGE 12941
#define IDS_EXTERNAL_PROTOCOL_OK_BUTTON_TEXT 12942
#define IDS_EXTERNAL_PROTOCOL_CANCEL_BUTTON_TEXT 12943
#define IDS_EXTERNAL_PROTOCOL_CHECKBOX_PER_ORIGIN_TEXT 12944
#define IDS_DIRECTORY_LISTING_HEADER 12946
#define IDS_DIRECTORY_LISTING_PARENT 12947
#define IDS_DIRECTORY_LISTING_NAME 12948
#define IDS_DIRECTORY_LISTING_SIZE 12949
#define IDS_DIRECTORY_LISTING_DATE_MODIFIED 12950
#define IDS_SAVE_PAGE_DESC_HTML_ONLY 12951
#define IDS_SAVE_PAGE_DESC_SINGLE_FILE 12952
#define IDS_SAVE_PAGE_DESC_COMPLETE 12953
#define IDS_PROFILE_ERROR_DIALOG_TITLE 12954
#define IDS_COULDNT_OPEN_PROFILE_ERROR 12955
#define IDS_OPEN_PROFILE_DATA_LOSS 12956
#define IDS_PROFILE_ERROR_DIALOG_CHECKBOX 12957
#define IDS_PROFILE_ERROR_FEEDBACK_DESCRIPTION 12958
#define IDS_COULDNT_STARTUP_PROFILE_ERROR 12959
#define IDS_REFUSE_TO_RUN_AS_ROOT 12960
#define IDS_REFUSE_TO_RUN_AS_ROOT_2 12961
#define IDS_CANT_WRITE_USER_DIRECTORY_TITLE 12963
#define IDS_RECENT_TABS_MENU 12964
#define IDS_RECENTLY_CLOSED_WINDOW 12965
#define IDS_RECENTLY_CLOSED_GROUP 12966
#define IDS_RECENTLY_CLOSED_GROUP_UNNAMED 12967
#define IDS_RECENT_TABS_NO_DEVICE_TABS 12968
#define IDS_RECENT_TABS_LOGIN_FOR_DEVICE_TABS 12969
#define IDS_HISTORY_MENU 12970
#define IDS_DEFAULT_DOWNLOAD_FILENAME 12971
#define IDS_DEFAULT_BROWSER_INFOBAR_OK_BUTTON_LABEL 12973
#define IDS_DEFAULT_BROWSER_INFOBAR_REFRESH_OK_BUTTON_LABEL 12974
#define IDS_MINIMIZE_WINDOW_MENU 12975
#define IDS_MAXIMIZE_WINDOW_MENU 12976
#define IDS_RESTORE_WINDOW_MENU 12977
#define IDS_CLOSE_WINDOW_MENU 12978
#define IDS_SHOW_WINDOW_DECORATIONS_MENU 12979
#define IDS_USED_EXISTING_BROWSER 12980
#define IDS_DECLINE_RECOVERY 12981
#define IDS_SYNC_ACCOUNT_SYNCING 12982
#define IDS_SYNC_ACCOUNT_SYNCING_CUSTOM_DATA_TYPES 12983
#define IDS_SIGNIN_ERROR_DISPLAY_SOURCE 12984
#define IDS_SIGNIN_ERROR_BUBBLE_VIEW_TITLE 12985
#define IDS_SYNC_ERROR_BUBBLE_VIEW_TITLE 12986
#define IDS_SYNC_ERROR_PASSWORDS_BUBBLE_VIEW_TITLE 12987
#define IDS_SYNC_ERROR_USER_MENU_TITLE 12988
#define IDS_SYNC_ERROR_PASSWORDS_USER_MENU_TITLE 12989
#define IDS_SYNC_ERROR_PASSWORDS_USER_MENU_TITLE_SIGNED_IN_ONLY 12990
#define IDS_SYNC_ERROR_RECOVERABILITY_DEGRADED_FOR_EVERYTHING_USER_MENU_TITLE 12991
#define IDS_SYNC_ERROR_RECOVERABILITY_DEGRADED_FOR_PASSWORDS_USER_MENU_TITLE 12992
#define IDS_SYNC_ERROR_USER_MENU_SIGNIN_BUTTON 12993
#define IDS_SYNC_NEEDS_VERIFICATION_BUBBLE_VIEW_TITLE 12994
#define IDS_SYNC_ERROR_USER_MENU_PASSPHRASE_BUTTON 12995
#define IDS_SYNC_ERROR_USER_MENU_RECOVERABILITY_BUTTON 12996
#define IDS_SYNC_ERROR_USER_MENU_RETRIEVE_KEYS_BUTTON 12997
#define IDS_SYNC_ERROR_USER_MENU_SIGNOUT_BUTTON 12998
#define IDS_SYNC_ERROR_USER_MENU_CONFIRM_SYNC_SETTINGS_BUTTON 12999
#define IDS_SIGNIN_PAUSED_USER_MENU_VERIFY_MESSAGE 13000
#define IDS_SYNC_OVERVIEW 13006
#define IDS_SYNC_START_SYNC_BUTTON_LABEL 13007
#define IDS_SIGNED_IN_WITH_SYNC_DISABLED_BY_POLICY 13008
#define IDS_SYNC_SETTINGS_NOT_CONFIRMED 13010
#define IDS_SYNC_SETUP_IN_PROGRESS 13011
#define IDS_SYNC_STATUS_UNRECOVERABLE_ERROR 13012
#define IDS_SYNC_STATUS_UNRECOVERABLE_ERROR_NEEDS_SIGNOUT 13013
#define IDS_SYNC_STATUS_NEEDS_PASSWORD 13014
#define IDS_SYNC_STATUS_NEEDS_PASSWORD_BUTTON 13015
#define IDS_SYNC_STATUS_NEEDS_KEYS_BUTTON 13016
#define IDS_SYNC_RELOGIN_ERROR 13017
#define IDS_SYNC_RELOGIN_BUTTON 13018
#define IDS_SYNC_ADVANCED_OPTIONS 13023
#define IDS_SYNC_FULL_ENCRYPTION_BODY_CUSTOM 13025
#define IDS_SYNC_FULL_ENCRYPTION_BODY_CUSTOM_WITH_DATE 13026
#define IDS_PARTIAL_TRANSLATE_BUBBLE_WAITING_TITLE 13027
#define IDS_TRANSLATE_BUBBLE_BEFORE_TRANSLATE_TITLE 13028
#define IDS_TRANSLATE_BUBBLE_TRANSLATED_TITLE 13029
#define IDS_PARTIAL_TRANSLATE_BUBBLE_COULD_NOT_TRANSLATE_TITLE 13030
#define IDS_TRANSLATE_BUBBLE_COULD_NOT_TRANSLATE_TITLE 13031
#define IDS_TRANSLATE_BUBBLE_SOURCE_LANG_COMBOBOX_ACCNAME 13032
#define IDS_TRANSLATE_BUBBLE_TARGET_LANG_COMBOBOX_ACCNAME 13033
#define IDS_TRANSLATE_BUBBLE_TRANSLATION_COMPLETE_ANNOUNCEMENT 13034
#define IDS_TRANSLATE_BUBBLE_ADVANCED_BUTTON 13035
#define IDS_TRANSLATE_BUBBLE_ADVANCED_MENU_BUTTON 13036
#define IDS_TRANSLATE_BUBBLE_CHANGE_TARGET_LANGUAGE 13037
#define IDS_TRANSLATE_BUBBLE_CHANGE_SOURCE_LANGUAGE 13038
#define IDS_PARTIAL_TRANSLATE_BUBBLE_CHANGE_SOURCE_LANGUAGE 13039
#define IDS_TRANSLATE_BUBBLE_ACCEPT 13040
#define IDS_TRANSLATE_BUBBLE_DENY 13041
#define IDS_TRANSLATE_BUBBLE_ALWAYS_TRANSLATE_LANG 13042
#define IDS_TRANSLATE_BUBBLE_NEVER_TRANSLATE_LANG 13043
#define IDS_TRANSLATE_BUBBLE_NEVER_TRANSLATE_SITE 13044
#define IDS_TRANSLATE_BUBBLE_TRANSLATING 13045
#define IDS_TRANSLATE_BUBBLE_REVERT 13046
#define IDS_TRANSLATE_BUBBLE_TRY_AGAIN 13047
#define IDS_TRANSLATE_BUBBLE_ALWAYS 13048
#define IDS_TRANSLATE_BUBBLE_OPTIONS_MENU_BUTTON 13049
#define IDS_TRANSLATE_BUBBLE_PAGE_LANGUAGE 13050
#define IDS_TRANSLATE_BUBBLE_TRANSLATION_LANGUAGE 13051
#define IDS_TRANSLATE_BUBBLE_ADVANCED_TARGET 13052
#define IDS_TRANSLATE_BUBBLE_ADVANCED_SOURCE 13053
#define IDS_PARTIAL_TRANSLATE_BUBBLE_ADVANCED_SOURCE 13054
#define IDS_PARTIAL_TRANSLATE_BUBBLE_TRANSLATE_FULL_PAGE 13055
#define IDS_TRANSLATE_BUBBLE_RESET 13056
#define IDS_NOTIFICATION_BUTTON_SETTINGS 13057
#define IDS_NOTIFICATION_BUTTON_CLOSE 13058
#define IDS_NOTIFICATION_BUTTON_MORE 13059
#define IDS_NOTIFICATION_REPLY_PLACEHOLDER 13060
#define IDS_NOTIFICATION_MUTED_MESSAGE 13061
#define IDS_NOTIFICATION_MUTED_TITLE 13062
#define IDS_NOTIFICATION_MUTED_ACTION_SHOW 13063
#define IDS_NOTIFICATION_MUTED_ACTION_SNOOZE 13064
#define IDS_FILE_MENU_LINUX 13185
#define IDS_EDIT_MENU_LINUX 13186
#define IDS_VIEW_MENU_LINUX 13187
#define IDS_HISTORY_MENU_LINUX 13188
#define IDS_TOOLS_MENU_LINUX 13189
#define IDS_HELP_MENU_LINUX 13190
#define IDS_REOPEN_CLOSED_TABS_LINUX 13191
#define IDS_OPEN_FILE_LINUX 13192
#define IDS_OPEN_LOCATION_LINUX 13193
#define IDS_CLOSE_WINDOW_LINUX 13194
#define IDS_CLOSE_TAB_LINUX 13195
#define IDS_STOP_MENU_LINUX 13196
#define IDS_RELOAD_MENU_LINUX 13197
#define IDS_TEXT_DEFAULT_LINUX 13198
#define IDS_TEXT_BIGGER_LINUX 13199
#define IDS_TEXT_SMALLER_LINUX 13200
#define IDS_HISTORY_HOME_LINUX 13201
#define IDS_HISTORY_BACK_LINUX 13202
#define IDS_HISTORY_FORWARD_LINUX 13203
#define IDS_HISTORY_VISITED_LINUX 13204
#define IDS_HISTORY_CLOSED_LINUX 13205
#define IDS_HISTORY_CLOSED_RESTORE_WINDOW_LINUX 13206
#define IDS_ALLOWED_GEOLOCATION_TITLE 13207
#define IDS_BLOCKED_GEOLOCATION_TITLE 13208
#define IDS_ALLOWED_GEOLOCATION_MESSAGE 13209
#define IDS_ALLOWED_GEOLOCATION_BLOCK 13210
#define IDS_ALLOWED_GEOLOCATION_NO_ACTION 13211
#define IDS_BLOCKED_GEOLOCATION_MESSAGE 13212
#define IDS_BLOCKED_GEOLOCATION_UNBLOCK 13213
#define IDS_BLOCKED_GEOLOCATION_NO_ACTION 13214
#define IDS_GEOLOCATION 13215
#define IDS_GEOLOCATION_WILL_ASK_AGAIN 13216
#define IDS_GEOLOCATION_TURNED_OFF 13220
#define IDS_ALLOWED_MIDI_SYSEX_TITLE 13221
#define IDS_BLOCKED_MIDI_SYSEX_TITLE 13222
#define IDS_ALLOWED_MIDI_SYSEX_MESSAGE 13223
#define IDS_ALLOWED_MIDI_SYSEX_BLOCK 13224
#define IDS_ALLOWED_MIDI_SYSEX_NO_ACTION 13225
#define IDS_BLOCKED_MIDI_SYSEX_MESSAGE 13226
#define IDS_BLOCKED_MIDI_SYSEX_UNBLOCK 13227
#define IDS_BLOCKED_MIDI_SYSEX_NO_ACTION 13228
#define IDS_MICROPHONE_CAMERA_ALLOWED 13229
#define IDS_MICROPHONE_CAMERA_BLOCKED 13230
#define IDS_MICROPHONE_ACCESSED 13231
#define IDS_CAMERA_ACCESSED 13232
#define IDS_MICROPHONE_BLOCKED 13233
#define IDS_CAMERA_BLOCKED 13234
#define IDS_MICROPHONE_CAMERA_ALLOWED_TITLE 13235
#define IDS_MICROPHONE_CAMERA_BLOCKED_TITLE 13236
#define IDS_MICROPHONE_ACCESSED_TITLE 13237
#define IDS_CAMERA_ACCESSED_TITLE 13238
#define IDS_MICROPHONE_BLOCKED_TITLE 13239
#define IDS_CAMERA_BLOCKED_TITLE 13240
#define IDS_MEDIASTREAM_SETTING_CHANGED_MESSAGE 13241
#define IDS_A11Y_OMNIBOX_CHIP_HINT 13251
#define IDS_MICROPHONE_CAMERA_IN_USE 13252
#define IDS_MICROPHONE_CAMERA_NOT_ALLOWED 13253
#define IDS_MICROPHONE_IN_USE 13254
#define IDS_CAMERA_IN_USE 13255
#define IDS_MICROPHONE_NOT_ALLOWED 13256
#define IDS_CAMERA_NOT_ALLOWED 13257
#define IDS_CAMERA_CANNOT_ACCESS 13258
#define IDS_MICROPHONE_CANNOT_ACCESS 13259
#define IDS_CAMERA_MICROPHONE_CANNOT_ACCESS 13260
#define IDS_MANAGE_PASSWORDS_CONFIRM_GENERATED_TEXT 13261
#define IDS_PASSWORDS_WEB_LINK 13262
#define IDS_MANAGE_PASSWORDS_LINK 13264
#define IDS_MANAGE_PASSWORDS_TITLE 13265
#define IDS_MANAGE_PASSWORDS_NO_PASSWORDS_TITLE 13266
#define IDS_MANAGE_PASSWORDS_DIFFERENT_DOMAIN_TITLE 13267
#define IDS_MANAGE_PASSWORDS_DIFFERENT_DOMAIN_NO_PASSWORDS_TITLE 13268
#define IDS_MANAGE_PASSWORDS_SHOW_PASSWORD 13269
#define IDS_MANAGE_PASSWORDS_HIDE_PASSWORD 13270
#define IDS_MANAGE_PASSWORDS_EMPTY_NOTE 13271
#define IDS_MANAGE_PASSWORDS_EDIT_USERNAME_TOOLTIP 13272
#define IDS_MANAGE_PASSWORDS_EDIT_NOTE_TOOLTIP 13273
#define IDS_MANAGE_PASSWORDS_NOTE_ACCESSIBLE_NAME 13274
#define IDS_MANAGE_PASSWORDS_NOTE_TEXTFIELD 13275
#define IDS_MANAGE_PASSWORDS_UPDATE 13276
#define IDS_MANAGE_PASSWORDS_USERNAME_ACCESSIBLE_NAME 13277
#define IDS_MANAGE_PASSWORDS_USERNAME_TEXTFIELD 13278
#define IDS_MANAGE_PASSWORDS_AUTO_SIGNIN_TITLE_MD 13279
#define IDS_AUTO_SIGNIN_FIRST_RUN_TITLE_MANY_DEVICES 13280
#define IDS_AUTO_SIGNIN_FIRST_RUN_TITLE_LOCAL_DEVICE 13281
#define IDS_AUTO_SIGNIN_FIRST_RUN_TEXT 13282
#define IDS_AUTO_SIGNIN_FIRST_RUN_OK 13283
#define IDS_FILE_SELECTION_DIALOG_INFOBAR 13292
#define IDS_ABOUT_LINUX_PROXY_CONFIG_TITLE 13293
#define IDS_ABOUT_LINUX_PROXY_CONFIG_BODY 13294
#define IDS_IMAGE_FILES 13295
#define IDS_AUDIO_FILES 13296
#define IDS_VIDEO_FILES 13297
#define IDS_CUSTOM_FILES 13298
#define IDS_SENSORS_ALLOWED_TOOLTIP 13299
#define IDS_MOTION_SENSORS_ALLOWED_TOOLTIP 13300
#define IDS_SENSORS_BLOCKED_TOOLTIP 13301
#define IDS_MOTION_SENSORS_BLOCKED_TOOLTIP 13302
#define IDS_BLOCKED_SENSORS_UNBLOCK 13303
#define IDS_BLOCKED_SENSORS_NO_ACTION 13304
#define IDS_ALLOWED_SENSORS_TITLE 13305
#define IDS_BLOCKED_SENSORS_TITLE 13306
#define IDS_ALLOWED_SENSORS_MESSAGE 13307
#define IDS_ALLOWED_MOTION_SENSORS_MESSAGE 13308
#define IDS_BLOCKED_SENSORS_MESSAGE 13309
#define IDS_BLOCKED_MOTION_SENSORS_MESSAGE 13310
#define IDS_ALLOWED_SENSORS_NO_ACTION 13311
#define IDS_ALLOWED_SENSORS_BLOCK 13312
#define IDS_LIVE_CAPTION_PROMO 13319
#define IDS_LIVE_CAPTION_PROMO_SCREENREADER 13320
#define IDS_ENABLE_CARET_BROWSING_INFO 13321
#define IDS_CARET_BROWSING_DO_NOT_ASK 13322
#define IDS_ENABLE_CARET_BROWSING_TITLE 13323
#define IDS_ENABLE_CARET_BROWSING_TURN_ON 13324
#define IDS_MEDIA_GALLERIES_DIALOG_HEADER 13325
#define IDS_MEDIA_GALLERIES_DIALOG_SUBTEXT_READ_WRITE 13326
#define IDS_MEDIA_GALLERIES_DIALOG_SUBTEXT_READ_DELETE 13327
#define IDS_MEDIA_GALLERIES_DIALOG_SUBTEXT_READ_ONLY 13328
#define IDS_MEDIA_GALLERIES_PERMISSION_SUGGESTIONS 13329
#define IDS_MEDIA_GALLERIES_LAST_ATTACHED 13330
#define IDS_MEDIA_GALLERIES_DIALOG_ADD_GALLERY 13331
#define IDS_MEDIA_GALLERIES_DIALOG_CONFIRM 13332
#define IDS_MEDIA_GALLERIES_DIALOG_ADD_GALLERY_TITLE 13333
#define IDS_MEDIA_GALLERIES_DIALOG_DEVICE_ATTACHED 13334
#define IDS_MEDIA_GALLERIES_DIALOG_DEVICE_NOT_ATTACHED 13335
#define IDS_MEDIA_GALLERIES_DIALOG_DELETE 13336
#define IDS_CHROME_SHORTCUT_DESCRIPTION 13358
#define IDS_WEBSTORE_NAME_STORE 13359
#define IDS_DESKTOP_MEDIA_PICKER_TITLE 13360
#define IDS_DISPLAY_MEDIA_PICKER_TITLE 13361
#define IDS_DESKTOP_MEDIA_PICKER_TITLE_SCREEN_ONLY 13362
#define IDS_DESKTOP_MEDIA_PICKER_TITLE_WINDOW_ONLY 13363
#define IDS_DESKTOP_MEDIA_PICKER_TEXT 13364
#define IDS_DISPLAY_MEDIA_PICKER_TEXT 13365
#define IDS_DESKTOP_MEDIA_PICKER_TEXT_DELEGATED 13366
#define IDS_DESKTOP_MEDIA_PICKER_AUDIO_SHARE_SCREEN_WITH_MUTE_WARNING 13367
#define IDS_DESKTOP_MEDIA_PICKER_ALSO_SHARE_SYSTEM_AUDIO 13368
#define IDS_DESKTOP_MEDIA_PICKER_ALSO_SHARE_TAB_AUDIO 13369
#define IDS_DESKTOP_MEDIA_PICKER_AUDIO_SHARE_HINT_TAB 13370
#define IDS_DESKTOP_MEDIA_PICKER_AUDIO_SHARE_HINT_TAB_OR_SCREEN 13371
#define IDS_DESKTOP_MEDIA_PICKER_SOURCE_TYPE_SCREEN 13372
#define IDS_DESKTOP_MEDIA_PICKER_SOURCE_TYPE_WINDOW 13373
#define IDS_DESKTOP_MEDIA_PICKER_SINGLE_SCREEN_NAME 13374
#define IDS_DESKTOP_MEDIA_PICKER_MULTIPLE_SCREEN_NAME 13375
#define IDS_DESKTOP_MEDIA_PICKER_MANAGED 13376
#define IDS_DESKTOP_MEDIA_PICKER_PERMISSION_BUTTON_MAC 13377
#define IDS_DESKTOP_MEDIA_PICKER_RESELECT_SCREEN 13378
#define IDS_DESKTOP_MEDIA_PICKER_RESELECT_WINDOW 13379
#define IDS_DESKTOP_MEDIA_PICKER_SOURCE_TYPE_THIS_TAB 13380
#define IDS_DESKTOP_MEDIA_PICKER_SOURCE_TYPE_OTHER_TAB 13381
#define IDS_DESKTOP_MEDIA_PICKER_EMPTY_PREVIEW 13382
#define IDS_DESKTOP_MEDIA_PICKER_PREVIEW_ACCESSIBLE_NAME 13383
#define IDS_DESKTOP_MEDIA_SOURCE_EMPTY_ACCESSIBLE_NAME 13384
#define IDS_SHARE_THIS_TAB_DIALOG_TITLE 13385
#define IDS_SHARE_THIS_TAB_DIALOG_TEXT 13386
#define IDS_SHARE_THIS_TAB_DIALOG_ALLOW 13387
#define IDS_SHARE_THIS_TAB_AUDIO_SHARE 13388
#define IDS_TAB_CAPTURE_TERMINATED_BY_POLICY_TITLE 13389
#define IDS_TAB_CAPTURE_TERMINATED_BY_POLICY_TEXT 13390
#define IDS_TOOLTIP_TAB_ALERT_STATE_MEDIA_RECORDING 13391
#define IDS_TOOLTIP_TAB_ALERT_STATE_AUDIO_RECORDING 13392
#define IDS_TOOLTIP_TAB_ALERT_STATE_VIDEO_RECORDING 13393
#define IDS_TOOLTIP_TAB_ALERT_STATE_TAB_CAPTURING 13394
#define IDS_TOOLTIP_TAB_ALERT_STATE_AUDIO_PLAYING 13395
#define IDS_TOOLTIP_TAB_ALERT_STATE_AUDIO_MUTING 13396
#define IDS_TOOLTIP_TAB_ALERT_STATE_BLUETOOTH_CONNECTED 13397
#define IDS_TOOLTIP_TAB_ALERT_STATE_BLUETOOTH_SCAN_ACTIVE 13398
#define IDS_TOOLTIP_TAB_ALERT_STATE_USB_CONNECTED 13399
#define IDS_TOOLTIP_TAB_ALERT_STATE_HID_CONNECTED 13400
#define IDS_TOOLTIP_TAB_ALERT_STATE_SERIAL_CONNECTED 13401
#define IDS_TOOLTIP_TAB_ALERT_STATE_PIP_PLAYING 13402
#define IDS_TOOLTIP_TAB_ALERT_STATE_DESKTOP_CAPTURING 13403
#define IDS_TOOLTIP_TAB_ALERT_STATE_VR_PRESENTING 13404
#define IDS_TAB_AX_LABEL_MEDIA_RECORDING_FORMAT 13405
#define IDS_TAB_AX_LABEL_AUDIO_RECORDING_FORMAT 13406
#define IDS_TAB_AX_LABEL_VIDEO_RECORDING_FORMAT 13407
#define IDS_TAB_AX_LABEL_TAB_CAPTURING_FORMAT 13408
#define IDS_TAB_AX_LABEL_PIP_PLAYING_FORMAT 13409
#define IDS_TAB_AX_LABEL_AUDIO_PLAYING_FORMAT 13410
#define IDS_TAB_AX_LABEL_AUDIO_MUTING_FORMAT 13411
#define IDS_TAB_AX_LABEL_BLUETOOTH_CONNECTED_FORMAT 13412
#define IDS_TAB_AX_LABEL_BLUETOOTH_SCAN_ACTIVE_FORMAT 13413
#define IDS_TAB_AX_LABEL_USB_CONNECTED_FORMAT 13414
#define IDS_TAB_AX_LABEL_HID_CONNECTED_FORMAT 13415
#define IDS_TAB_AX_LABEL_SERIAL_CONNECTED_FORMAT 13416
#define IDS_TAB_AX_LABEL_NETWORK_ERROR_FORMAT 13417
#define IDS_TAB_AX_LABEL_CRASHED_FORMAT 13418
#define IDS_TAB_AX_LABEL_DESKTOP_CAPTURING_FORMAT 13419
#define IDS_TAB_AX_LABEL_VR_PRESENTING 13420
#define IDS_TAB_AX_LABEL_UNNAMED_GROUP_FORMAT 13421
#define IDS_TAB_AX_LABEL_NAMED_GROUP_FORMAT 13422
#define IDS_TAB_AX_LABEL_PINNED_FORMAT 13423
#define IDS_TAB_AX_LABEL_PERMISSION_REQUESTED_FORMAT 13424
#define IDS_GROUP_AX_LABEL_UNNAMED_GROUP_FORMAT 13425
#define IDS_GROUP_AX_LABEL_NAMED_GROUP_FORMAT 13426
#define IDS_GROUP_AX_LABEL_COLLAPSED 13427
#define IDS_GROUP_AX_LABEL_EXPANDED 13428
#define IDS_GROUP_AX_LABEL_UNNAMED_SAVED_GROUP_FORMAT 13429
#define IDS_GROUP_AX_LABEL_NAMED_SAVED_GROUP_FORMAT 13430
#define IDS_SAVED_GROUP_AX_LABEL_OPENED 13431
#define IDS_SAVED_GROUP_AX_LABEL_CLOSED 13432
#define IDS_TAB_AX_ANNOUNCE_MOVED_RIGHT 13433
#define IDS_TAB_AX_ANNOUNCE_MOVED_LEFT 13434
#define IDS_TAB_AX_ANNOUNCE_MOVED_FIRST 13435
#define IDS_TAB_AX_ANNOUNCE_MOVED_LAST 13436
#define IDS_TAB_AX_ANNOUNCE_TAB_ADDED_TO_UNNAMED_GROUP 13437
#define IDS_TAB_AX_ANNOUNCE_TAB_ADDED_TO_NAMED_GROUP 13438
#define IDS_TAB_AX_ANNOUNCE_TAB_REMOVED_FROM_UNNAMED_GROUP 13439
#define IDS_TAB_AX_ANNOUNCE_TAB_REMOVED_FROM_NAMED_GROUP 13440
#define IDS_PAGE_LOADING_AX_TITLE_FORMAT 13441
#define IDS_TAB_AX_INACTIVE_TAB 13442
#define IDS_TAB_AX_MEMORY_SAVINGS 13443
#define IDS_TAB_AX_MEMORY_USAGE 13444
#define IDS_TAB_AX_HIGH_MEMORY_USAGE 13445
#define IDS_PROFILE_IN_USE_LINUX_QUIT 13446
#define IDS_PROFILE_IN_USE_LINUX_RELAUNCH 13447
#define IDS_DESKTOP_MEDIA_PICKER_SHARE 13465
#define IDS_PUSH_MESSAGING_GENERIC_NOTIFICATION_BODY 13466
#define IDS_DEVICE_PERMISSIONS_DIALOG_SELECT 13467
#define IDS_DEVICE_PERMISSIONS_DIALOG_LOADING_LABEL 13468
#define IDS_DEVICE_PERMISSIONS_DIALOG_LOADING_LABEL_TOOLTIP 13469
#define IDS_DEVICE_LOG_TITLE 13470
#define IDS_DEVICE_AUTO_REFRESH 13471
#define IDS_DEVICE_LOG_REFRESH 13472
#define IDS_DEVICE_LOG_CLEAR 13473
#define IDS_DEVICE_LOG_CLEAR_TYPES 13474
#define IDS_DEVICE_LOG_NO_ENTRIES 13475
#define IDS_DEVICE_LOG_LEVEL_LABEL 13476
#define IDS_DEVICE_LOG_LEVEL_ERROR 13477
#define IDS_DEVICE_LOG_LEVEL_USER 13478
#define IDS_DEVICE_LOG_LEVEL_EVENT 13479
#define IDS_DEVICE_LOG_LEVEL_DEBUG 13480
#define IDS_DEVICE_LOG_TYPE_LOGIN 13481
#define IDS_DEVICE_LOG_TYPE_NETWORK 13482
#define IDS_DEVICE_LOG_TYPE_POWER 13483
#define IDS_DEVICE_LOG_TYPE_BLUETOOTH 13484
#define IDS_DEVICE_LOG_TYPE_USB 13485
#define IDS_DEVICE_LOG_TYPE_HID 13486
#define IDS_DEVICE_LOG_TYPE_PRINTER 13487
#define IDS_DEVICE_LOG_TYPE_FIDO 13488
#define IDS_DEVICE_LOG_TYPE_SERIAL 13489
#define IDS_DEVICE_LOG_TYPE_CAMERA 13490
#define IDS_DEVICE_LOG_TYPE_GEOLOCATION 13491
#define IDS_DEVICE_LOG_TYPE_EXTENSIONS 13492
#define IDS_DEVICE_LOG_TYPE_DISPLAY 13493
#define IDS_DEVICE_LOG_TYPE_FIRMWARE 13494
#define IDS_DEVICE_LOG_FILEINFO 13495
#define IDS_DEVICE_LOG_TIME_DETAIL 13496
#define IDS_DEVICE_LOG_ENTRY 13497
#define IDS_WEBUSB_DEVICE_DETECTED_NOTIFICATION 13499
#define IDS_WEBUSB_DEVICE_DETECTED_NOTIFICATION_TITLE 13500
#define IDS_WEBHID_SYSTEM_TRAY_ICON_HID_SETTINGS 13501
#define IDS_WEBHID_SYSTEM_TRAY_ICON_ABOUT_HID_DEVICE 13502
#define IDS_WEBUSB_SYSTEM_TRAY_ICON_USB_SETTINGS 13503
#define IDS_WEBUSB_SYSTEM_TRAY_ICON_ABOUT_USB_DEVICE 13504
#define IDS_DEVICE_CONNECTED_BY_EXTENSION 13507
#define IDS_DEFAULT_AUDIO_DEVICE_NAME 13516
#define IDS_BLUETOOTH_DEVICE_CHOOSER_TURN_ADAPTER_OFF 13518
#define IDS_BLUETOOTH_DEVICE_CHOOSER_TURN_ON_BLUETOOTH_LINK_TEXT 13519
#define IDS_BLUETOOTH_DEVICE_CHOOSER_AUTHORIZE_BLUETOOTH_LINK_TEXT 13520
#define IDS_BLUETOOTH_DEVICE_CHOOSER_RE_SCAN 13521
#define IDS_BLUETOOTH_DEVICE_CHOOSER_RE_SCAN_TOOLTIP 13522
#define IDS_DEVICE_CHOOSER_GET_HELP_LINK_WITH_SCANNING_STATUS 13523
#define IDS_DEVICE_CHOOSER_GET_HELP_LINK_WITH_RE_SCAN_LINK 13524
#define IDS_DEVICE_CHOOSER_PAIRED_STATUS_TEXT 13525
#define IDS_DEVICE_CHOOSER_DEVICE_NAME_AND_PAIRED_STATUS_TEXT 13526
#define IDS_DEVICE_CHOOSER_ACCNAME_COMPATIBLE_DEVICES_LIST 13527
#define IDS_DEVICE_CHOOSER_DEVICE_NAME_UNKNOWN_DEVICE_WITH_VENDOR_NAME 13528
#define IDS_DEVICE_CHOOSER_DEVICE_NAME_UNKNOWN_DEVICE_WITH_VENDOR_ID_AND_PRODUCT_ID 13529
#define IDS_USB_POLICY_DEVICE_DESCRIPTION_FOR_PRODUCT_ID_AND_VENDOR_NAME 13530
#define IDS_USB_POLICY_DEVICE_DESCRIPTION_FOR_PRODUCT_ID_AND_VENDOR_ID 13531
#define IDS_USB_POLICY_DEVICE_DESCRIPTION_FOR_VENDOR_ID 13532
#define IDS_USB_POLICY_DEVICE_DESCRIPTION_FOR_VENDOR_NAME 13533
#define IDS_USB_POLICY_DEVICE_DESCRIPTION_FOR_ANY_VENDOR 13534
#define IDS_SERIAL_PORT_CHOOSER_PROMPT 13535
#define IDS_SERIAL_PORT_CHOOSER_NAME_WITH_PATH 13536
#define IDS_SERIAL_PORT_CHOOSER_CONNECT_BUTTON_TEXT 13537
#define IDS_SERIAL_PORT_CHOOSER_LOADING_LABEL 13538
#define IDS_SERIAL_PORT_CHOOSER_LOADING_LABEL_TOOLTIP 13539
#define IDS_SERIAL_POLICY_DESCRIPTION_FOR_USB_PRODUCT_ID_AND_VENDOR_NAME 13540
#define IDS_SERIAL_POLICY_DESCRIPTION_FOR_USB_PRODUCT_ID_AND_VENDOR_ID 13541
#define IDS_SERIAL_POLICY_DESCRIPTION_FOR_USB_VENDOR_ID 13542
#define IDS_SERIAL_POLICY_DESCRIPTION_FOR_USB_VENDOR_NAME 13543
#define IDS_SERIAL_POLICY_DESCRIPTION_FOR_ANY_PORT 13544
#define IDS_HID_CHOOSER_PROMPT 13545
#define IDS_HID_CHOOSER_ITEM_WITHOUT_NAME 13546
#define IDS_HID_CHOOSER_LOADING_LABEL 13547
#define IDS_HID_CHOOSER_LOADING_LABEL_TOOLTIP 13548
#define IDS_HID_POLICY_DESCRIPTION_FOR_VENDOR_ID_AND_PRODUCT_ID 13549
#define IDS_HID_POLICY_DESCRIPTION_FOR_VENDOR_ID 13550
#define IDS_HID_POLICY_DESCRIPTION_FOR_USAGE_AND_USAGE_PAGE 13551
#define IDS_HID_POLICY_DESCRIPTION_FOR_USAGE_PAGE 13552
#define IDS_HID_POLICY_DESCRIPTION_FOR_ANY_DEVICE 13553
#define IDS_WEB_APP_FILE_HANDLING_LIST_SEPARATOR 13554
#define IDS_WEB_APP_FILE_HANDLING_DIALOG_QUESTION 13555
#define IDS_WEB_APP_FILE_HANDLING_DIALOG_QUESTION_MULTIPLE 13556
#define IDS_WEB_APP_FILE_HANDLING_DIALOG_STICKY_CHOICE 13557
#define IDS_WEB_APP_FILE_HANDLING_POSITIVE_BUTTON 13558
#define IDS_WEB_APP_FILE_HANDLING_NEGATIVE_BUTTON 13559
#define IDS_WEB_APP_PERMISSION_NEGATIVE_BUTTON 13560
#define IDS_PROTOCOL_HANDLER_INTENT_PICKER_QUESTION 13561
#define IDS_FONT_ACCESS_CHOOSER_PROMPT_ORIGIN 13562
#define IDS_FONT_ACCESS_CHOOSER_NO_FONTS_FOUND_PROMPT 13563
#define IDS_FONT_ACCESS_CHOOSER_IMPORT_BUTTON_TEXT 13564
#define IDS_FONT_ACCESS_CHOOSER_CANCEL_BUTTON_TEXT 13565
#define IDS_FONT_ACCESS_CHOOSER_SELECT_ALL_CHECKBOX_TEXT 13566
#define IDS_FONT_ACCESS_CHOOSER_LOADING_LABEL 13567
#define IDS_FONT_ACCESS_CHOOSER_LOADING_LABEL_TOOLTIP 13568
#define IDS_IME_API_ACTIVATED_WARNING 13569
#define IDS_IME_API_NEVER_SHOW 13570
#define IDS_BLOCKED_ADS_PROMPT_TOOLTIP 13571
#define IDS_REDIRECT_BLOCKED_MESSAGE 13574
#define IDS_REDIRECT_BLOCKED_TITLE 13575
#define IDS_REDIRECT_BLOCKED_TOOLTIP 13576
#define IDS_ALWAYS_ALLOW_REDIRECTS 13577
#define IDS_OPEN_REDIRECT 13578
#define IDS_UTILITY_PROCESS_SYSTEM_SIGNALS_NAME 13579
#define IDS_CONTROLLED_BY_AUTOMATION 13582
#define IDS_CHROME_FOR_TESTING_DISCLAIMER 13583
#define IDS_DOWNLOAD_CHROME 13584
#define IDS_DOWNLOAD_OPEN_CONFIRMATION_DIALOG_TITLE 13586
#define IDS_DOWNLOAD_OPEN_CONFIRMATION_DIALOG_MESSAGE 13587
#define IDS_CONFIRM_FILE_UPLOAD_TITLE 13588
#define IDS_CONFIRM_FILE_UPLOAD_TEXT 13589
#define IDS_CONFIRM_FILE_UPLOAD_OK_BUTTON 13590
#define IDS_FILE_SYSTEM_ACCESS_WRITE_PERMISSION_TITLE 13591
#define IDS_FILE_SYSTEM_ACCESS_WRITE_PERMISSION_ALLOW_TEXT 13592
#define IDS_FILE_SYSTEM_ACCESS_ORIGIN_SCOPED_WRITE_PERMISSION_FILE_TEXT 13593
#define IDS_FILE_SYSTEM_ACCESS_ORIGIN_SCOPED_WRITE_PERMISSION_DIRECTORY_TEXT 13594
#define IDS_FILE_SYSTEM_ACCESS_ORIGIN_SCOPED_READ_PERMISSION_FILE_TEXT 13595
#define IDS_FILE_SYSTEM_ACCESS_ORIGIN_SCOPED_READ_PERMISSION_DIRECTORY_TEXT 13596
#define IDS_FILE_SYSTEM_ACCESS_WRITE_PERMISSION_FILE_TEXT 13597
#define IDS_FILE_SYSTEM_ACCESS_WRITE_PERMISSION_DIRECTORY_TEXT 13598
#define IDS_FILE_SYSTEM_ACCESS_READ_PERMISSION_FILE_TEXT 13599
#define IDS_FILE_SYSTEM_ACCESS_READ_PERMISSION_DIRECTORY_TEXT 13600
#define IDS_FILE_SYSTEM_ACCESS_EDIT_FILE_PERMISSION_TITLE 13601
#define IDS_FILE_SYSTEM_ACCESS_EDIT_DIRECTORY_PERMISSION_TITLE 13602
#define IDS_FILE_SYSTEM_ACCESS_READ_FILE_PERMISSION_TITLE 13603
#define IDS_FILE_SYSTEM_ACCESS_READ_DIRECTORY_PERMISSION_TITLE 13604
#define IDS_FILE_SYSTEM_ACCESS_EDIT_FILE_PERMISSION_ALLOW_TEXT 13605
#define IDS_FILE_SYSTEM_ACCESS_EDIT_DIRECTORY_PERMISSION_ALLOW_TEXT 13606
#define IDS_FILE_SYSTEM_ACCESS_VIEW_FILE_PERMISSION_ALLOW_TEXT 13607
#define IDS_FILE_SYSTEM_ACCESS_VIEW_DIRECTORY_PERMISSION_ALLOW_TEXT 13608
#define IDS_FILE_SYSTEM_ACCESS_RESTORE_PERMISSION_DESCRIPTION 13609
#define IDS_FILE_SYSTEM_ACCESS_WRITE_USAGE_TOOLTIP 13610
#define IDS_FILE_SYSTEM_ACCESS_DIRECTORY_USAGE_TOOLTIP 13611
#define IDS_FILE_SYSTEM_ACCESS_USAGE_BUBBLE_SINGLE_WRITABLE_FILE_TEXT 13612
#define IDS_FILE_SYSTEM_ACCESS_USAGE_BUBBLE_WRITABLE_FILES_TEXT 13613
#define IDS_FILE_SYSTEM_ACCESS_USAGE_BUBBLE_SINGLE_WRITABLE_DIRECTORY_TEXT 13614
#define IDS_FILE_SYSTEM_ACCESS_USAGE_BUBBLE_WRITABLE_DIRECTORIES_TEXT 13615
#define IDS_FILE_SYSTEM_ACCESS_USAGE_BUBBLE_WRITABLE_FILES_AND_DIRECTORIES_TEXT 13616
#define IDS_FILE_SYSTEM_ACCESS_USAGE_BUBBLE_SINGLE_READABLE_FILE_TEXT 13617
#define IDS_FILE_SYSTEM_ACCESS_USAGE_BUBBLE_READABLE_FILES_TEXT 13618
#define IDS_FILE_SYSTEM_ACCESS_USAGE_BUBBLE_SINGLE_READABLE_DIRECTORY_TEXT 13619
#define IDS_FILE_SYSTEM_ACCESS_USAGE_BUBBLE_READABLE_DIRECTORIES_TEXT 13620
#define IDS_FILE_SYSTEM_ACCESS_USAGE_BUBBLE_READABLE_FILES_AND_DIRECTORIES_TEXT 13621
#define IDS_FILE_SYSTEM_ACCESS_USAGE_BUBBLE_READ_AND_WRITE 13622
#define IDS_FILE_SYSTEM_ACCESS_USAGE_BUBBLE_SAVE_CHANGES 13623
#define IDS_FILE_SYSTEM_ACCESS_USAGE_BUBBLE_VIEW_CHANGES 13624
#define IDS_FILE_SYSTEM_ACCESS_USAGE_BUBBLE_FILES_TEXT 13625
#define IDS_FILE_SYSTEM_ACCESS_USAGE_EXPAND 13626
#define IDS_FILE_SYSTEM_ACCESS_USAGE_COLLAPSE 13627
#define IDS_FILE_SYSTEM_ACCESS_USAGE_REMOVE_ACCESS 13628
#define IDS_FILE_SYSTEM_ACCESS_CHOOSER_OPEN_READABLE_DIRECTORY_TITLE 13629
#define IDS_FILE_SYSTEM_ACCESS_CHOOSER_OPEN_WRITABLE_DIRECTORY_TITLE 13630
#define IDS_FILE_SYSTEM_ACCESS_CHOOSER_OPEN_SAVE_FILE_TITLE 13631
#define IDS_FILE_SYSTEM_ACCESS_RESTRICTED_DIRECTORY_TITLE 13632
#define IDS_FILE_SYSTEM_ACCESS_RESTRICTED_DIRECTORY_TEXT 13633
#define IDS_FILE_SYSTEM_ACCESS_RESTRICTED_DIRECTORY_BUTTON 13634
#define IDS_FILE_SYSTEM_ACCESS_RESTRICTED_FILE_TITLE 13635
#define IDS_FILE_SYSTEM_ACCESS_RESTRICTED_FILE_TEXT 13636
#define IDS_FILE_SYSTEM_ACCESS_RESTRICTED_FILE_BUTTON 13637
#define IDS_FILE_SYSTEM_ACCESS_DANGEROUS_FILE_TITLE 13638
#define IDS_FILE_SYSTEM_ACCESS_DANGEROUS_FILE_TEXT 13639
#define IDS_FILE_SYSTEM_ACCESS_DANGEROUS_FILE_DONT_SAVE 13640
#define IDS_FILE_SYSTEM_ACCESS_DANGEROUS_FILE_SAVE 13641
#define IDS_RELAUNCH_ACCEPT_BUTTON 13642
#define IDS_RELAUNCH_REQUIRED_CANCEL_BUTTON 13643
#define IDS_IDLE_TIMEOUT_INCOGNITO 13644
#define IDS_IDLE_TIMEOUT_CLOSE_COUNTDOWN 13645
#define IDS_IDLE_TIMEOUT_CLEAR_COUNTDOWN 13646
#define IDS_WEBAUTHN_GENERIC_TITLE 13647
#define IDS_WEBAUTHN_CONTINUE 13648
#define IDS_WEBAUTHN_TRANSPORT_USB 13649
#define IDS_WEBAUTHN_TRANSPORT_INTERNAL 13651
#define IDS_WEBAUTHN_TRANSPORT_CABLE 13652
#define IDS_WEBAUTHN_TRANSPORT_AOA 13653
#define IDS_WEBAUTHN_TRANSPORT_WINDOWS_HELLO_OR_SECURITY_KEY 13654
#define IDS_WEBAUTHN_TRANSPORT_WINDOWS_HELLO 13655
#define IDS_WEBAUTHN_TRANSPORT_ICLOUD_KEYCHAIN 13656
#define IDS_WEBAUTHN_TRANSPORT_EXTERNAL_SECURITY_KEY 13657
#define IDS_WEBAUTHN_USB_ACTIVATE_DESCRIPTION 13658
#define IDS_WEBAUTHN_ERROR_GENERIC_TITLE 13659
#define IDS_WEBAUTHN_ERROR_WRONG_KEY_TITLE 13660
#define IDS_WEBAUTHN_ERROR_WRONG_DEVICE_TITLE 13661
#define IDS_WEBAUTHN_ERROR_WRONG_DEVICE_REGISTER_DESCRIPTION 13662
#define IDS_WEBAUTHN_ERROR_WRONG_KEY_SIGN_DESCRIPTION 13663
#define IDS_WEBAUTHN_ERROR_TIMEOUT_DESCRIPTION 13664
#define IDS_WEBAUTHN_ERROR_INTERNAL_UNRECOGNIZED_TITLE 13665
#define IDS_WEBAUTHN_ERROR_INTERNAL_UNRECOGNIZED_DESCRIPTION 13666
#define IDS_WEBAUTHN_WINDOWS_HELLO_NOT_ENABLED_TITLE 13667
#define IDS_WEBAUTHN_WINDOWS_HELLO_NOT_ENABLED_DESCRIPTION 13668
#define IDS_WEBAUTHN_ERROR_NO_PASSKEYS_TITLE 13669
#define IDS_WEBAUTHN_ERROR_NO_PASSKEYS_DESCRIPTION 13670
#define IDS_WEBAUTHN_BLUETOOTH_POWER_ON_AUTO_TITLE 13671
#define IDS_WEBAUTHN_BLUETOOTH_POWER_ON_AUTO_DESCRIPTION 13672
#define IDS_WEBAUTHN_BLUETOOTH_POWER_ON_AUTO_NEXT 13673
#define IDS_WEBAUTHN_BLUETOOTH_POWER_ON_MANUAL_TITLE 13674
#define IDS_WEBAUTHN_BLUETOOTH_POWER_ON_MANUAL_DESCRIPTION 13675
#define IDS_WEBAUTHN_BLUETOOTH_POWER_ON_MANUAL_NEXT 13676
#define IDS_WEBAUTHN_TRANSPORT_POPUP_USB 13678
#define IDS_WEBAUTHN_TRANSPORT_POPUP_PAIR_PHONE 13679
#define IDS_WEBAUTHN_TRANSPORT_POPUP_INTERNAL 13680
#define IDS_WEBAUTHN_TRANSPORT_POPUP_CABLE 13681
#define IDS_WEBAUTHN_TRANSPORT_POPUP_AOA 13682
#define IDS_WEBAUTHN_CABLE_ACTIVATE_TITLE 13683
#define IDS_WEBAUTHN_CABLE_ACTIVATE_TITLE_DEVICE 13684
#define IDS_WEBAUTHN_CABLE_ACTIVATE_DESCRIPTION 13685
#define IDS_WEBAUTHN_CABLE_ACTIVATE_DEVICE_NAME_DESCRIPTION 13686
#define IDS_WEBAUTHN_CABLEV2_CONNECTING_TITLE 13687
#define IDS_WEBAUTHN_CABLEV2_CONNECTED_DESCRIPTION 13688
#define IDS_WEBAUTHN_CABLEV2_ERROR_DESCRIPTION 13689
#define IDS_WEBAUTHN_CABLEV2_ERROR_CLOSE 13690
#define IDS_WEBAUTHN_CABLEV2_SERVERLINK_TROUBLE 13691
#define IDS_WEBAUTHN_CABLEV2_AOA_TITLE 13692
#define IDS_WEBAUTHN_CABLEV2_AOA_DESCRIPTION 13693
#define IDS_WEBAUTHN_CABLEV2_AOA_REQUEST_DESCRIPTION 13694
#define IDS_WEBAUTHN_PASSKEY_PHONE_OR_TABLET_LABEL 13695
#define IDS_WEBAUTHN_PASSKEY_PHONE_TABLET_OR_SECURITY_KEY_LABEL 13696
#define IDS_WEBAUTHN_PASSKEY_DIFFERENT_PHONE_OR_TABLET_LABEL 13697
#define IDS_WEBAUTHN_PASSKEY_DIFFERENT_PHONE_TABLET_OR_SECURITY_KEY_LABEL 13698
#define IDS_WEBAUTHN_PHONE_CONFIRMATION_TITLE 13699
#define IDS_WEBAUTHN_CABLE_ACTIVATE_DESCRIPTION_SHORT 13700
#define IDS_WEBAUTHN_PIN_ENTRY_TITLE 13701
#define IDS_WEBAUTHN_PIN_ENTRY_DESCRIPTION 13702
#define IDS_WEBAUTHN_PIN_ENTRY_PIN_LABEL 13703
#define IDS_WEBAUTHN_PIN_ENTRY_NEXT 13704
#define IDS_WEBAUTHN_PIN_SETUP_DESCRIPTION 13705
#define IDS_WEBAUTHN_PIN_SETUP_CONFIRMATION_LABEL 13706
#define IDS_WEBAUTHN_PIN_ENTRY_ERROR_INVALID_CHARACTERS 13707
#define IDS_WEBAUTHN_PIN_ENTRY_ERROR_TOO_SHORT 13708
#define IDS_WEBAUTHN_PIN_ENTRY_ERROR_FAILED_RETRIES 13709
#define IDS_WEBAUTHN_PIN_ENTRY_ERROR_FAILED 13710
#define IDS_WEBAUTHN_PIN_SETUP_ERROR_FAILED 13711
#define IDS_WEBAUTHN_PIN_TAP_AGAIN_DESCRIPTION 13712
#define IDS_WEBAUTHN_PIN_ENTRY_ERROR_MISMATCH 13713
#define IDS_WEBAUTHN_CLIENT_PIN_SOFT_BLOCK_DESCRIPTION 13714
#define IDS_WEBAUTHN_CLIENT_PIN_HARD_BLOCK_DESCRIPTION 13715
#define IDS_WEBAUTHN_CLIENT_PIN_AUTHENTICATOR_REMOVED_DESCRIPTION 13716
#define IDS_WEBAUTHN_PIN_ENTRY_ERROR_SAME_AS_CURRENT 13717
#define IDS_WEBAUTHN_USE_PHONE_WITH_NAME 13718
#define IDS_WEBAUTHN_INLINE_ENROLLMENT_CANCEL_LABEL 13719
#define IDS_WEBAUTHN_UV_RETRY_TITLE 13720
#define IDS_WEBAUTHN_UV_RETRY_DESCRIPTION 13721
#define IDS_WEBAUTHN_UV_RETRY_ERROR_FAILED_RETRIES 13722
#define IDS_WEBAUTHN_UV_ERROR_LOCKED 13723
#define IDS_WEBAUTHN_FORCE_PIN_CHANGE 13724
#define IDS_WEBAUTHN_UNKNOWN_ACCOUNT 13725
#define IDS_WEBAUTHN_RESIDENT_KEY_PRIVACY 13726
#define IDS_WEBAUTHN_RESIDENT_KEY_PREFERRED_PRIVACY 13727
#define IDS_WEBAUTHN_ERROR_MISSING_CAPABILITY_TITLE 13728
#define IDS_WEBAUTHN_ERROR_MISSING_CAPABILITY_DESC 13729
#define IDS_WEBAUTHN_STORAGE_FULL_DESC 13730
#define IDS_WEBAUTHN_REQUEST_ATTESTATION_PERMISSION_TITLE 13731
#define IDS_WEBAUTHN_REQUEST_ATTESTATION_PERMISSION_DESC 13732
#define IDS_WEBAUTHN_REQUEST_ENTERPRISE_ATTESTATION_PERMISSION_TITLE 13733
#define IDS_WEBAUTHN_REQUEST_ENTERPRISE_ATTESTATION_PERMISSION_DESC 13734
#define IDS_WEBAUTHN_ALLOW_ATTESTATION 13735
#define IDS_WEBAUTHN_DENY_ATTESTATION 13736
#define IDS_WEBAUTHN_RETRY 13737
#define IDS_WEBAUTHN_PLATFORM_AUTHENTICATOR_OFF_THE_RECORD_INTERSTITIAL_TITLE 13738
#define IDS_WEBAUTHN_PLATFORM_AUTHENTICATOR_OFF_THE_RECORD_INTERSTITIAL_DESCRIPTION 13739
#define IDS_WEBAUTHN_PLATFORM_AUTHENTICATOR_OFF_THE_RECORD_INTERSTITIAL_DENY 13740
#define IDS_WEBAUTHN_MANAGE_DEVICES 13741
#define IDS_WEBAUTHN_CREATE_PASSKEY_TITLE 13742
#define IDS_WEBAUTHN_CREATE_PASSKEY_EXTRA 13743
#define IDS_WEBAUTHN_CREATE_PASSKEY_EXTRA_INCOGNITO 13744
#define IDS_WEBAUTHN_CREATE_PASSKEY_EXTRA_WIN 13745
#define IDS_WEBAUTHN_CREATE_PASSKEY_EXTRA_WIN_INCOGNITO 13746
#define IDS_WEBAUTHN_CREATE_PASSKEY_CHOOSE_DEVICE_TITLE 13747
#define IDS_WEBAUTHN_USE_PASSKEY_CHOOSE_DEVICE_TITLE 13748
#define IDS_WEBAUTHN_USE_PASSKEY_CHOOSE_DEVICE_BODY 13749
#define IDS_WEBAUTHN_USE_PASSKEY_TITLE 13750
#define IDS_WEBAUTHN_CHOOSE_PASSKEY_TITLE 13751
#define IDS_WEBAUTHN_CHOOSE_PASSKEY_BODY 13752
#define IDS_WEBAUTHN_CREATE_PASSKEY_QR_TITLE 13753
#define IDS_WEBAUTHN_CREATE_PASSKEY_QR_BODY 13754
#define IDS_WEBAUTHN_USE_PASSKEY_QR_TITLE 13755
#define IDS_WEBAUTHN_USE_PASSKEY_QR_BODY 13756
#define IDS_WEBAUTHN_QR_CODE_ALT_TEXT 13757
#define IDS_WEBAUTHN_USE_A_DIFFERENT_PASSKEY 13758
#define IDS_WEBAUTHN_QR_CREATE_PASSKEY_ON_SECURITY_KEY_LABEL 13759
#define IDS_WEBAUTHN_QR_USE_PASSKEY_ON_SECURITY_KEY_LABEL 13760
#define IDS_WEBAUTHN_CHOOSE_PASSKEY_FOR_RP_TITLE 13761
#define IDS_WEBAUTHN_THIS_DEVICE_LABEL 13762
#define IDS_WEBAUTHN_FROM_PHONE_LABEL 13763
#define IDS_WEBAUTHN_OTHER_DEVICES_LABEL 13764
#define IDS_WEBAUTHN_SOURCE_CHROME_PROFILE 13765
#define IDS_WEBAUTHN_SOURCE_CHROME_PROFILE_NEW 13766
#define IDS_WEBAUTHN_SOURCE_ICLOUD_KEYCHAIN 13767
#define IDS_WEBAUTHN_SOURCE_ICLOUD_KEYCHAIN_NEW 13768
#define IDS_WEBAUTHN_SOURCE_CUSTOM_VENDOR 13769
#define IDS_WEBAUTHN_SOURCE_WINDOWS_HELLO 13770
#define IDS_WEBAUTHN_SOURCE_WINDOWS_HELLO_NEW 13771
#define IDS_WEBAUTHN_SOURCE_GOOGLE_PASSWORD_MANAGER 13772
#define IDS_WEBAUTHN_SOURCE_PHONE 13773
#define IDS_WEBAUTHN_CREATE 13774
#define IDS_WEBAUTHN_CREATE_PASSKEY 13775
#define IDS_WEBAUTHN_GPM_CREATE_PASSKEY_TITLE 13776
#define IDS_WEBAUTHN_GPM_CREATE_PASSKEY_DESC 13777
#define IDS_WEBAUTHN_SAVE_ANOTHER_WAY 13778
#define IDS_WEBAUTHN_GPM_START_SAVING_TITLE 13779
#define IDS_WEBAUTHN_GPM_START_SAVING_DESC 13780
#define IDS_WEBAUTHN_GPM_AVAILABLE_ACROSS_DEVICES 13781
#define IDS_WEBAUTHN_GPM_FASTER_SIGN_IN 13782
#define IDS_WEBAUTHN_GPM_SAFER 13783
#define IDS_WEBAUTHN_GPM_TRUST_THIS_COMPUTER_CREATION_TITLE 13784
#define IDS_WEBAUTHN_GPM_TRUST_THIS_COMPUTER_CREATION_DESC 13785
#define IDS_WEBAUTHN_GPM_TRUST_THIS_COMPUTER_ASSERTION_TITLE 13786
#define IDS_WEBAUTHN_GPM_TRUST_THIS_COMPUTER_ASSERTION_DESC 13787
#define IDS_WEBAUTHN_USE_A_DIFFERENT_DEVICE 13788
#define IDS_WEBAUTHN_TOUCH_ID_ASSERTION_DESC 13789
#define IDS_WEBAUTHN_TOUCH_ID_CONTINUE 13790
#define IDS_WEBAUTHN_TOUCH_ID_LOCKED 13791
#define IDS_WEBAUTHN_TOUCH_ID_ENTER_PASSWORD 13792
#define IDS_WEBAUTHN_GPM_ERROR_TITLE 13793
#define IDS_WEBAUTHN_GPM_ERROR_DESC 13794
#define IDS_WEBAUTHN_SIGN_IN_AGAIN_TITLE 13795
#define IDS_WEBAUTHN_SIGN_IN_AGAIN_DESCRIPTION 13796
#define IDS_WEBAUTHN_GPM_INCOGNITO_CREATE_TITLE 13797
#define IDS_WEBAUTHN_GPM_INCOGNITO_CREATE_DESC 13798
#define IDS_WEBAUTHN_GPM_PIN_OPTION_NUMBERS 13799
#define IDS_WEBAUTHN_GPM_PIN_OPTION_ALPHANUMERIC 13800
#define IDS_WEB_DIGITAL_CREDENTIALS_QR_TITLE 13801
#define IDS_WEB_DIGITAL_CREDENTIALS_QR_BODY 13802
#define IDS_WEB_DIGITAL_CREDENTIALS_QR_CODE_ALT_TEXT 13803
#define IDS_ACCNAME_SIDE_SEARCH_TOOL 13804
#define IDS_ACCNAME_SIDE_SEARCH_TOOLBAR_BUTTON_ACTIVATED 13805
#define IDS_ACCNAME_SIDE_SEARCH_TOOLBAR_BUTTON_NOT_ACTIVATED 13806
#define IDS_ACCNAME_SIDE_SEARCH_CLOSE_BUTTON 13807
#define IDS_ACCNAME_SIDE_SEARCH_FEEDBACK_BUTTON 13808
#define IDS_SIDE_SEARCH_ENTRYPOINT_LABEL 13809
#define IDS_TOOLTIP_SIDE_SEARCH_TOOLBAR_BUTTON_ACTIVATED 13810
#define IDS_TOOLTIP_SIDE_SEARCH_TOOLBAR_BUTTON_NOT_ACTIVATED 13811
#define IDS_TOOLTIP_SIDE_SEARCH_CLOSE_BUTTON 13812
#define IDS_TOOLTIP_SIDE_SEARCH_FEEDBACK_BUTTON 13813
#define IDS_CABLEV2_MAKE_CREDENTIAL_NOTIFICATION_TITLE 13814
#define IDS_CABLEV2_GET_ASSERTION_NOTIFICATION_TITLE 13815
#define IDS_INCOGNITO_PROFILE_MENU_TITLE 13816
#define IDS_INCOGNITO_WINDOW_COUNT_MESSAGE 13817
#define IDS_INCOGNITO_PROFILE_MENU_CLOSE_BUTTON 13818
#define IDS_INCOGNITO_PROFILE_MENU_CLOSE_BUTTON_NEW 13819
#define IDS_INCOGNITO_CLEAR_BROWSING_DATA_DIALOG_PRIMARY_TEXT 13820
#define IDS_INCOGNITO_CLEAR_BROWSING_DATA_DIALOG_SECONDARY_TEXT 13821
#define IDS_INCOGNITO_CLEAR_BROWSING_DATA_DIALOG_CLOSE_WINDOWS_BUTTON 13822
#define IDS_INCOGNITO_HISTORY_BUBBLE_PRIMARY_TEXT 13823
#define IDS_INCOGNITO_HISTORY_BUBBLE_SECONDARY_TEXT 13824
#define IDS_INCOGNITO_HISTORY_BUBBLE_CLOSE_INCOGNITO_BUTTON_TEXT 13825
#define IDS_INCOGNITO_HISTORY_BUBBLE_CANCEL_BUTTON_TEXT 13826
#define IDS_GUEST_WINDOW_COUNT_MESSAGE 13827
#define IDS_GUEST_PROFILE_MENU_CLOSE_BUTTON 13828
#define IDS_NOTIFICATION_DEFAULT_HELPFUL_BUTTON_TEXT 13829
#define IDS_NOTIFICATION_DEFAULT_UNHELPFUL_BUTTON_TEXT 13830
#define IDS_DEEP_SCANNING_DIALOG_TITLE 13831
#define IDS_DEEP_SCANNING_DIALOG_UPLOAD_PENDING_MESSAGE 13832
#define IDS_DEEP_SCANNING_DIALOG_PRINT_PENDING_MESSAGE 13833
#define IDS_DEEP_SCANNING_DIALOG_SUCCESS_MESSAGE 13834
#define IDS_DEEP_SCANNING_DIALOG_PRINT_SUCCESS_MESSAGE 13835
#define IDS_DEEP_SCANNING_DIALOG_UPLOAD_FAILURE_MESSAGE 13836
#define IDS_DEEP_SCANNING_DIALOG_UPLOAD_FAIL_CLOSED_MESSAGE 13837
#define IDS_DEEP_SCANNING_DIALOG_UPLOAD_WARNING_MESSAGE 13838
#define IDS_DEEP_SCANNING_DIALOG_PRINT_WARNING_MESSAGE 13839
#define IDS_DEEP_SCANNING_DIALOG_TIMEOUT_MESSAGE 13840
#define IDS_DEEP_SCANNING_DIALOG_PROCEED_BUTTON 13841
#define IDS_DEEP_SCANNING_DIALOG_CANCEL_WARNING_BUTTON 13842
#define IDS_DEEP_SCANNING_DIALOG_CANCEL_UPLOAD_BUTTON 13843
#define IDS_DEEP_SCANNING_DIALOG_LARGE_FILE_FAILURE_MESSAGE 13844
#define IDS_DEEP_SCANNING_DIALOG_LARGE_PRINT_FAILURE_MESSAGE 13845
#define IDS_DEEP_SCANNING_DIALOG_ENCRYPTED_FILE_FAILURE_MESSAGE 13846
#define IDS_DEEP_SCANNING_DIALOG_CUSTOM_MESSAGE 13847
#define IDS_DEEP_SCANNING_DIALOG_DOWNLOADS_CUSTOM_MESSAGE 13848
#define IDS_DEEP_SCANNING_DIALOG_CUSTOM_MESSAGE_LEARN_MORE_LINK 13849
#define IDS_DEEP_SCANNING_DIALOG_DOWNLOADS_DISCARD_FILE_BUTTON 13850
#define IDS_DEEP_SCANNING_DIALOG_UPLOAD_BYPASS_JUSTIFICATION_LABEL 13851
#define IDS_DEEP_SCANNING_DIALOG_PASTE_BYPASS_JUSTIFICATION_LABEL 13852
#define IDS_DEEP_SCANNING_DIALOG_PRINT_BYPASS_JUSTIFICATION_LABEL 13853
#define IDS_DEEP_SCANNING_DIALOG_DOWNLOAD_BYPASS_JUSTIFICATION_LABEL 13854
#define IDS_DEEP_SCANNING_DIALOG_BYPASS_JUSTIFICATION_TEXT_LIMIT_LABEL 13855
#define IDS_DATA_CONTROLS_CLIPBOARD_PASTE_BLOCK_TITLE 13856
#define IDS_DATA_CONTROLS_CLIPBOARD_PASTE_WARN_TITLE 13857
#define IDS_DATA_CONTROLS_CLIPBOARD_COPY_BLOCK_TITLE 13858
#define IDS_DATA_CONTROLS_CLIPBOARD_COPY_WARN_TITLE 13859
#define IDS_DATA_CONTROLS_BLOCKED_LABEL 13860
#define IDS_DATA_CONTROLS_WARNED_LABEL 13861
#define IDS_DATA_CONTROLS_PASTE_WARN_CONTINUE_BUTTON 13862
#define IDS_DATA_CONTROLS_COPY_WARN_CONTINUE_BUTTON 13863
#define IDS_DATA_CONTROLS_PASTE_WARN_CANCEL_BUTTON 13864
#define IDS_DATA_CONTROLS_COPY_WARN_CANCEL_BUTTON 13865
#define IDS_DATA_SHARING_BUBBLE_DIALOG_TITLE 13866
#define IDS_DEEP_SCANNING_DIALOG_OPEN_NOW_TITLE 13867
#define IDS_DEEP_SCANNING_DIALOG_OPEN_NOW_MESSAGE 13868
#define IDS_DEEP_SCANNING_DIALOG_OPEN_NOW_ACCEPT_BUTTON 13869
#define IDS_DEEP_SCANNING_INFO_DIALOG_TITLE 13870
#define IDS_APP_DEEP_SCANNING_INFO_DIALOG_MESSAGE 13871
#define IDS_DEEP_SCANNING_INFO_DIALOG_MESSAGE 13872
#define IDS_DEEP_SCANNING_INFO_DIALOG_ACCEPT_BUTTON 13873
#define IDS_DEEP_SCANNING_INFO_DIALOG_CANCEL_BUTTON 13874
#define IDS_DEEP_SCANNING_INFO_DIALOG_OPEN_NOW_BUTTON 13875
#define IDS_DEEP_SCANNING_TIMED_OUT_DIALOG_TITLE 13876
#define IDS_DEEP_SCANNING_TIMED_OUT_DIALOG_MESSAGE 13877
#define IDS_DEEP_SCANNING_TIMED_OUT_DIALOG_ACCEPT_BUTTON 13878
#define IDS_DEEP_SCANNING_TIMED_OUT_DIALOG_CANCEL_BUTTON 13879
#define IDS_DEEP_SCANNING_TIMED_OUT_DIALOG_OPEN_NOW_BUTTON 13880
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_IPH_BUBBLE_TEXT 13881
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_IPH_BUBBLE_CLOSE_BUTTON_ARIA_LABEL_TEXT 13882
#define IDS_TAILORED_SECURITY_ENABLED_DIALOG_TITLE 13883
#define IDS_TAILORED_SECURITY_DISABLED_DIALOG_TITLE 13884
#define IDS_TAILORED_SECURITY_ENABLED_DIALOG_MAIN_TEXT 13885
#define IDS_TAILORED_SECURITY_DISABLED_DIALOG_MAIN_TEXT 13886
#define IDS_TAILORED_SECURITY_DISABLED_DIALOG_ACCEPT_BUTTON 13887
#define IDS_TAILORED_SECURITY_DIALOG_SETTINGS_BUTTON 13888
#define IDS_TAILORED_SECURITY_UNCONSENTED_MODAL_TITLE 13889
#define IDS_TAILORED_SECURITY_UNCONSENTED_MODAL_BODY 13890
#define IDS_TAILORED_SECURITY_UNCONSENTED_ACCEPT_BUTTON 13891
#define IDS_TAILORED_SECURITY_UNCONSENTED_CANCEL_BUTTON 13892
#define IDS_TAILORED_SECURITY_CONSENTED_ENABLE_MESSAGE_TITLE 13893
#define IDS_TAILORED_SECURITY_CONSENTED_ENABLE_MESSAGE_DESCRIPTION 13894
#define IDS_TAILORED_SECURITY_CONSENTED_DISABLE_MESSAGE_TITLE 13895
#define IDS_TAILORED_SECURITY_CONSENTED_DISABLE_MESSAGE_DESCRIPTION 13896
#define IDS_TAILORED_SECURITY_CONSENTED_MESSAGE_OK_BUTTON 13897
#define IDS_PROMPT_APP_UNINSTALL_TITLE 13898
#define IDS_APP_UNINSTALL_PROMPT_REMOVE_DATA_CHECKBOX_FOR_NON_GOOGLE 13899
#define IDS_APP_UNINSTALL_PROMPT_REMOVE_DATA_CHECKBOX_FOR_GOOGLE 13900
#define IDS_APP_UNINSTALL_PROMPT_LEARN_MORE 13901
#define IDS_APP_UNINSTALL_PROMPT_ADDITIONAL_UNINSTALLS_MESSAGE 13902
#define IDS_SUB_APPS_UNINSTALL_NOTIFICATION_TITLE 13903
#define IDS_SUB_APPS_UNINSTALL_NOTIFICATION_DESCRIPTION 13904
#define IDS_UTILITY_PROCESS_SPEECH_RECOGNITION_SERVICE_NAME 13905
#define IDS_APP_PAUSE_PROMPT_TITLE 13906
#define IDS_APP_PAUSE_HEADING 13907
#define IDS_APP_PAUSE_HEADING_FOR_WEB_APPS 13908
#define IDS_APP_BLOCK_PROMPT_TITLE 13909
#define IDS_APP_BLOCK_HEADING_FOR_CHILD 13910
#define IDS_APP_BLOCK_HEADING 13911
#define IDS_APP_LOCAL_BLOCK_PROMPT_TITLE 13912
#define IDS_APP_LOCAL_BLOCK_PROMPT_MULTIPLE_TITLE 13913
#define IDS_APP_LOCAL_BLOCK_HEADING 13914
#define IDS_ENTERPRISE_EXTENSION_REQUEST_APPROVED_TITLE 13915
#define IDS_ENTERPRISE_EXTENSION_REQUEST_REJECTED_TITLE 13916
#define IDS_ENTERPRISE_EXTENSION_REQUEST_FORCE_INSTALLED_TITLE 13917
#define IDS_ENTERPRISE_EXTENSION_REQUEST_CLICK_TO_INSTALL 13918
#define IDS_ENTERPRISE_EXTENSION_REQUEST_CLICK_TO_VIEW 13919
#define IDS_ENTERPRISE_EXTENSION_REQUEST_JUSTIFICATION 13920
#define IDS_ENTERPRISE_EXTENSION_REQUEST_JUSTIFICATION_PLACEHOLDER 13921
#define IDS_ENTERPRISE_EXTENSION_REQUEST_JUSTIFICATION_LENGTH_LIMIT 13922
#define IDS_NAME_WINDOW_PROMPT_TITLE 13923
#define IDS_NAME_WINDOW_PROMPT_FIELD_LABEL 13924
#define IDS_CHROMELABS_RELAUNCH_BUTTON_LABEL 13925
#define IDS_WINDOW_TITLE_EXPERIMENTS 13926
#define IDS_CHROMELABS_SEND_FEEDBACK 13927
#define IDS_CHROMELABS_SEND_FEEDBACK_DESCRIPTION_PLACEHOLDER 13928
#define IDS_CHROMELABS_DEFAULT 13929
#define IDS_CHROMELABS_ENABLED 13930
#define IDS_CHROMELABS_DISABLED 13931
#define IDS_CHROMELABS_ENABLED_WITH_VARIATION_NAME 13932
#define IDS_CUSTOMIZE_CHROME_SIDE_PANEL_EXPERIMENT_NAME 13933
#define IDS_CUSTOMIZE_CHROME_SIDE_PANEL_DESCRIPTION 13934
#define IDS_CHROMEREFRESH2023_EXPERIMENT_NAME 13935
#define IDS_CHROMEREFRESH2023_DESCRIPTION 13936
#define IDS_CHROMEREFRESH2023_WITHOUT_OMNIBOX 13937
#define IDS_CHROMEWEBUIREFRESH2023_EXPERIMENT_NAME 13938
#define IDS_CHROMEWEBUIREFRESH2023_DESCRIPTION 13939
#define IDS_TAB_SCROLLING_EXPERIMENT_NAME 13940
#define IDS_TAB_SCROLLING_EXPERIMENT_DESCRIPTION 13941
#define IDS_TABS_SHRINK_TO_PINNED_TAB_WIDTH 13942
#define IDS_TABS_SHRINK_TO_MEDIUM_WIDTH 13943
#define IDS_TABS_SHRINK_TO_LARGE_WIDTH 13944
#define IDS_TABS_DO_NOT_SHRINK 13945
#define IDS_LENS_REGION_SEARCH_BUBBLE_TEXT 13946
#define IDS_LENS_SEARCH_BUBBLE_DIALOG_TITLE 13947
#define IDS_LENS_OVERLAY_COPY 13948
#define IDS_LENS_OVERLAY_COPY_TOAST_MESSAGE 13949
#define IDS_LENS_OVERLAY_MORE_OPTIONS_BUTTON_LABEL 13950
#define IDS_LENS_OVERLAY_MY_ACTIVITY 13951
#define IDS_LENS_OVERLAY_TOAST_DISMISS_MESSAGE 13952
#define IDS_LENS_OVERLAY_TRANSLATE 13953
#define IDS_LENS_OVERLAY_SELECT_TEXT 13954
#define IDS_LENS_OVERLAY_LEARN_MORE 13955
#define IDS_LENS_OVERLAY_INITIAL_TOAST_LABEL 13956
#define IDS_LENS_OVERLAY_INITIAL_TOAST_MESSAGE 13957
#define IDS_LENS_OVERLAY_CURSOR_TOOLTIP_DRAG_MESSAGE 13958
#define IDS_LENS_OVERLAY_CURSOR_TOOLTIP_TEXT_HIGHLIGHT_MESSAGE 13959
#define IDS_LENS_OVERLAY_CURSOR_TOOLTIP_CLICK_MESSAGE 13960
#define IDS_LENS_OVERLAY_CURSOR_TOOLTIP_LIVE_PAGE_MESSAGE 13961
#define IDS_LENS_OVERLAY_FIND_IN_PAGE_ENTRYPOINT_MESSAGE 13962
#define IDS_LENS_OVERLAY_FIND_IN_PAGE_ENTRYPOINT_LABEL 13963
#define IDS_LENS_SEND_FEEDBACK 13964
#define IDS_LENS_SEND_FEEDBACK_PLACEHOLDER 13965
#define IDS_LENS_PERMISSION_BUBBLE_DIALOG_CANCEL_BUTTON 13966
#define IDS_LENS_PERMISSION_BUBBLE_DIALOG_CONTINUE_BUTTON 13967
#define IDS_LENS_PERMISSION_BUBBLE_DIALOG_DESCRIPTION 13968
#define IDS_LENS_PERMISSION_BUBBLE_DIALOG_LEARN_MORE_LINK 13969
#define IDS_LENS_PERMISSION_BUBBLE_DIALOG_TITLE 13970
#define IDS_THUMBNAIL_TAB_STRIP_EXPERIMENT_NAME 13971
#define IDS_THUMBNAIL_TAB_STRIP_EXPERIMENT_DESCRIPTION 13972
#define IDS_TAILORED_SECURITY_UNCONSENTED_PROMOTION_NOTIFICATION_DESCRIPTION 13975
#define IDS_TAILORED_SECURITY_UNCONSENTED_PROMOTION_NOTIFICATION_ACCEPT 13976
#define IDS_ACCOUNT_SELECTION_SHEET_TITLE_EXPLICIT_SIGN_IN 13977
#define IDS_ACCOUNT_SELECTION_SHEET_TITLE_EXPLICIT_SIGN_UP 13978
#define IDS_ACCOUNT_SELECTION_SHEET_TITLE_EXPLICIT_USE 13979
#define IDS_ACCOUNT_SELECTION_SHEET_TITLE_EXPLICIT_CONTINUE 13980
#define IDS_ACCOUNT_SELECTION_SHEET_SUBTITLE 13981
#define IDS_ACCOUNT_SELECTION_CONTINUE 13982
#define IDS_ACCOUNT_SELECTION_CHOOSE_AN_ACCOUNT 13983
#define IDS_ACCOUNT_SELECTION_CHOOSE_AN_ACCOUNT_BUTTON 13984
#define IDS_ACCOUNT_SELECTION_DATA_SHARING_CONSENT_NO_PP_OR_TOS 13985
#define IDS_ACCOUNT_SELECTION_DATA_SHARING_CONSENT_NO_PP 13986
#define IDS_ACCOUNT_SELECTION_DATA_SHARING_CONSENT_NO_TOS 13987
#define IDS_ACCOUNT_SELECTION_DATA_SHARING_CONSENT 13988
#define IDS_ACCOUNT_SELECTION_USE_OTHER_ACCOUNT 13989
#define IDS_ACCOUNT_SELECTION_BACK 13990
#define IDS_SIGNIN_CONTINUE 13991
#define IDS_IDP_SIGNIN_STATUS_MISMATCH_DIALOG_BODY 13992
#define IDS_IDP_SIGNIN_STATUS_MISMATCH_BUTTON_TEXT 13993
#define IDS_SIGNIN_GENERIC_ERROR_DIALOG_SUMMARY 13994
#define IDS_SIGNIN_GENERIC_ERROR_DIALOG_DESCRIPTION 13995
#define IDS_SIGNIN_UNAUTHORIZED_CLIENT_ERROR_DIALOG_SUMMARY 13996
#define IDS_SIGNIN_UNAUTHORIZED_CLIENT_ERROR_DIALOG_DESCRIPTION 13997
#define IDS_SIGNIN_INVALID_REQUEST_ERROR_DIALOG_SUMMARY 13998
#define IDS_SIGNIN_INVALID_REQUEST_ERROR_DIALOG_DESCRIPTION 13999
#define IDS_SIGNIN_ACCESS_DENIED_ERROR_DIALOG_SUMMARY 14000
#define IDS_SIGNIN_ACCESS_DENIED_ERROR_DIALOG_DESCRIPTION 14001
#define IDS_SIGNIN_SERVER_ERROR_DIALOG_SUMMARY 14002
#define IDS_SIGNIN_SERVER_ERROR_DIALOG_DESCRIPTION 14003
#define IDS_SIGNIN_TEMPORARILY_UNAVAILABLE_ERROR_DIALOG_SUMMARY 14004
#define IDS_SIGNIN_TEMPORARILY_UNAVAILABLE_ERROR_DIALOG_DESCRIPTION 14005
#define IDS_SIGNIN_ERROR_DIALOG_GOT_IT_BUTTON 14006
#define IDS_SIGNIN_ERROR_DIALOG_MORE_DETAILS_BUTTON 14007
#define IDS_SIGNIN_ERROR_DIALOG_MORE_DETAILS_PROMPT 14008
#define IDS_SIGNIN_ERROR_DIALOG_TRY_OTHER_WAYS_PROMPT 14009
#define IDS_SIGNIN_ERROR_DIALOG_MORE_DETAILS_RETRY_PROMPT 14010
#define IDS_SIGNIN_ERROR_DIALOG_TRY_OTHER_WAYS_RETRY_PROMPT 14011
#define IDS_MULTI_IDP_ACCOUNT_SELECTION_SHEET_TITLE_EXPLICIT 14012
#define IDS_VERIFY_SHEET_TITLE 14013
#define IDS_VERIFY_SHEET_TITLE_AUTO_REAUTHN 14014
#define IDS_AUTO_REAUTHN_OPTOUT_CHECKBOX 14015
#define IDS_PRIVACY_SANDBOX_DIALOG_CONSENT_TITLE 14047
#define IDS_PRIVACY_SANDBOX_BUBBLE_NOTICE_TITLE 14048
#define IDS_PRIVACY_SANDBOX_DIALOG_CONSENT_BODY_HEADER_1 14049
#define IDS_PRIVACY_SANDBOX_BUBBLE_NOTICE_DESCRIPTION 14050
#define IDS_PRIVACY_SANDBOX_BUBBLE_NOTICE_SETTINGS_LINK 14051
#define IDS_PRIVACY_SANDBOX_BUBBLE_NOTICE_DESCRIPTION_ESTIMATES_INTERESTS_LINK 14052
#define IDS_PRIVACY_SANDBOX_BUBBLE_NOTICE_DESCRIPTION_ESTIMATES_INTERESTS_LINK_A11Y_NAME 14053
#define IDS_PRIVACY_SANDBOX_DIALOG_CONSENT_BODY_DESCRIPTION_1 14054
#define IDS_PRIVACY_SANDBOX_DIALOG_CONSENT_BODY_HEADER_2 14055
#define IDS_PRIVACY_SANDBOX_DIALOG_CONSENT_LEARN_MORE_SECTION_2_HEADER 14056
#define IDS_PRIVACY_SANDBOX_DIALOG_CONSENT_LEARN_MORE_SECTION_2_BULLET_POINT_3 14057
#define IDS_PRIVACY_SANDBOX_DIALOG_CONSENT_ACCEPT_BUTTON 14058
#define IDS_PRIVACY_SANDBOX_DIALOG_CONSENT_DECLINE_BUTTON 14059
#define IDS_PRIVACY_SANDBOX_DIALOG_NOTICE_BODY_HEADER_1 14060
#define IDS_PRIVACY_SANDBOX_DIALOG_NOTICE_BODY_DESCRIPTION_1 14061
#define IDS_PRIVACY_SANDBOX_DIALOG_NOTICE_BODY_HEADER_2 14062
#define IDS_PRIVACY_SANDBOX_DIALOG_NOTICE_ACKNOWLEDGE_BUTTON 14063
#define IDS_PRIVACY_SANDBOX_DIALOG_NOTICE_OPEN_SETTINGS_BUTTON 14064
#define IDS_BATTERY_SAVER_BUTTON_TOOLTIP 14065
#define IDS_BATTERY_SAVER_BUTTON_ACCNAME 14066
#define IDS_BATTERY_SAVER_BUBBLE_TITLE 14067
#define IDS_BATTERY_SAVER_BUBBLE_DESCRIPTION 14068
#define IDS_BATTERY_SAVER_SESSION_TURN_OFF 14069
#define IDS_MEMORY_SAVER_CHIP_LABEL 14070
#define IDS_MEMORY_SAVER_CHIP_ACCNAME 14071
#define IDS_MEMORY_SAVER_CHIP_WITH_SAVINGS_ACCNAME 14072
#define IDS_MEMORY_SAVER_CHIP_SAVINGS_LABEL 14073
#define IDS_MEMORY_SAVER_DIALOG_TITLE 14074
#define IDS_MEMORY_SAVER_DIALOG_SETTINGS_BUTTON 14075
#define IDS_MEMORY_SAVER_DIALOG_SAVINGS_ACCNAME 14076
#define IDS_MEMORY_SAVER_DIALOG_BUTTON_ADD_TO_EXCLUSION_LIST 14077
#define IDS_MEMORY_SAVER_DIALOG_SAVINGS_LABEL 14078
#define IDS_MEMORY_SAVER_DIALOG_SMALL_SAVINGS_LABEL 14079
#define IDS_MEMORY_SAVER_DIALOG_MEDIUM_SAVINGS_LABEL 14080
#define IDS_MEMORY_SAVER_DIALOG_LARGE_SAVINGS_LABEL 14081
#define IDS_MEMORY_SAVER_DIALOG_VERY_LARGE_SAVINGS_LABEL 14082
#define IDS_HOVERCARD_TAB_MEMORY_USAGE 14083
#define IDS_HOVERCARD_TAB_HIGH_MEMORY_USAGE 14084
#define IDS_HOVERCARD_INACTIVE_TAB_MEMORY_SAVINGS 14085
#define IDS_HOVERCARD_INACTIVE_TAB 14086
#define IDS_PERFORMANCE_INTERVENTION_DIALOG_TITLE 14087
#define IDS_PERFORMANCE_INTERVENTION_DEACTIVATE_TABS_BUTTON 14088
#define IDS_PERFORMANCE_INTERVENTION_DISMISS_BUTTON 14089
#define IDS_ACCNAME_SIDEBAR_WEBVIEW_LOCATION_BAR 14090
#define IDS_SIDEBAR_WEBVIEW_TITLE 14091
#define IDS_PROTECTED_AUDIENCE_DEBUGGING_DISCLAIMER 14095
#define IDS_TEST_THIRD_PARTY_COOKIE_BLOCKING_PHASEOUT_INFO 14096
#define IDS_OVERFLOW_MENU_ITEM_TEXT_PROFILE 14097
#define IDS_OVERFLOW_MENU_ITEM_TEXT_DOWNLOADS 14098
#define IDS_OVERFLOW_MENU_ITEM_TEXT_EXTENSIONS 14099
#define IDS_OVERFLOW_MENU_ITEM_TEXT_FORWARD 14100
#define IDS_OVERFLOW_MENU_ITEM_TEXT_HOME 14101
#define IDS_OVERFLOW_MENU_ITEM_TEXT_LABS 14102
#define IDS_OVERFLOW_MENU_ITEM_TEXT_MEDIA_CONTROLS 14103
#define IDS_OVERFLOW_MENU_ITEM_TEXT_NEW_TAB 14104
#define IDS_OVERFLOW_MENU_ITEM_TEXT_SIDE_PANEL 14105
#define IDS_PROMISE_STATUS_WAITING 14106
#define IDS_PROMISE_STATUS_INSTALLING 14107
#define IDS_PROMISE_APP_ACCESSIBLE_LABEL_WAITING 14108
#define IDS_PROMISE_APP_ACCESSIBLE_LABEL_INSTALLING 14109
#define IDS_PROMISE_APP_PLACEHOLDER_ACCESSIBLE_LABEL_WAITING 14110
#define IDS_PROMISE_APP_PLACEHOLDER_ACCESSIBLE_LABEL_INSTALLING 14111
#define IDS_IWA_INSTALLER_DISABLED_TITLE 14112
#define IDS_IWA_INSTALLER_DISABLED_CHANGE_PREFERENCE 14113
#define IDS_IWA_INSTALLER_DISABLED_SUBTITLE 14114
#define IDS_IWA_INSTALLER_ALREADY_INSTALLED_TITLE 14115
#define IDS_IWA_INSTALLER_ALREADY_INSTALLED_SUBTITLE 14116
#define IDS_IWA_INSTALLER_BODY_SCREENREADER_NAME 14117
#define IDS_IWA_INSTALLER_DETAILS_SCREENREADER_NAME 14118
#define IDS_IWA_INSTALLER_PROGRESS_SCREENREADER_NAME 14119
#define IDS_IWA_INSTALLER_INSTALL_SUBTITLE 14120
#define IDS_IWA_INSTALLER_INSTALL_PROGRESS 14121
#define IDS_IWA_INSTALLER_SHOW_METADATA_SUBTITLE 14122
#define IDS_IWA_INSTALLER_SHOW_METADATA_APP_NAME_LABEL 14123
#define IDS_IWA_INSTALLER_SHOW_METADATA_APP_VERSION_LABEL 14124
#define IDS_IWA_INSTALLER_CONFIRM_TITLE 14125
#define IDS_IWA_INSTALLER_CONFIRM_SUBTITLE 14126
#define IDS_IWA_INSTALLER_CONFIRM_LEARN_MORE 14127
#define IDS_IWA_INSTALLER_CONFIRM_CONTINUE 14128
#define IDS_IWA_INSTALLER_INSTALL_FAILED_TITLE 14129
#define IDS_IWA_INSTALLER_INSTALL_FAILED_SUBTITLE 14130
#define IDS_IWA_INSTALLER_INSTALL_FAILED_RETRY 14131
#define IDS_IWA_INSTALLER_SUCCESS_SUBTITLE 14132
#define IDS_IWA_INSTALLER_SUCCESS_FINISH 14133
#define IDS_IWA_INSTALLER_SUCCESS_LAUNCH_APPLICATION 14134
#define IDS_IWA_INSTALLER_VERIFICATION_TITLE 14135
#define IDS_IWA_INSTALLER_VERIFICATION_SUBTITLE 14136
#define IDS_IWA_INSTALLER_VERIFICATION_STATUS 14137
#define IDS_IWA_INSTALLER_VERIFICATION_ERROR_TITLE 14138
#define IDS_IWA_INSTALLER_VERIFICATION_ERROR_SUBTITLE 14139
#define IDS_THUMBS_DOWN 14141
#define IDS_THUMBS_UP 14142
#define IDS_EXPERIMENTAL_FEATURE_DISCLAIMER 14143

// ---------------------------------------------------------------------------
// From locale_settings.h:

#define IDS_SPELLCHECK_DICTIONARY 17000
#define IDS_EDITBOOKMARK_DIALOG_WIDTH_CHARS 17001
#define IDS_EDITBOOKMARK_DIALOG_HEIGHT_LINES 17002
#define IDS_THEMES_GALLERY_URL 17003
#define IDS_WEBSTORE_URL 17004
#define IDS_MEDIA_GALLERIES_DIALOG_CONTENT_WIDTH_CHARS 17005
#define IDS_SETTINGS_CLEAR_DATA_MYACTIVITY_URL_IN_DIALOG 17008
#define IDS_SETTINGS_CLEAR_DATA_MYACTIVITY_URL_IN_HISTORY 17009

// ---------------------------------------------------------------------------
// From omnibox_pedal_synonyms.h:

#define IDS_OMNIBOX_PEDALS_IGNORE_GROUP 41380
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CLEAR_BROWSING_DATA_ONE_REQUIRED_CLEAR_BROWSER_CACHE 41381
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CLEAR_BROWSING_DATA_ONE_OPTIONAL_GOOGLE_CHROME 41382
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CLEAR_BROWSING_DATA_ONE_REQUIRED_DELETE 41383
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CLEAR_BROWSING_DATA_ONE_REQUIRED_INFORMATION 41384
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_PASSWORDS_ONE_REQUIRED_MANAGE_CHROME_PASSWORDS 41385
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_PASSWORDS_ONE_OPTIONAL_GOOGLE_CHROME 41386
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_PASSWORDS_ONE_OPTIONAL_MANAGER 41387
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_PASSWORDS_ONE_REQUIRED_PASSWORDS 41388
#define IDS_OMNIBOX_PEDAL_SYNONYMS_UPDATE_CREDIT_CARD_ONE_REQUIRED_MANAGE_PAYMENT_METHODS 41389
#define IDS_OMNIBOX_PEDAL_SYNONYMS_UPDATE_CREDIT_CARD_ONE_OPTIONAL_GOOGLE_CHROME 41390
#define IDS_OMNIBOX_PEDAL_SYNONYMS_UPDATE_CREDIT_CARD_ONE_REQUIRED_CHANGE 41391
#define IDS_OMNIBOX_PEDAL_SYNONYMS_UPDATE_CREDIT_CARD_ONE_REQUIRED_CREDIT_CARD_INFORMATION 41392
#define IDS_OMNIBOX_PEDAL_SYNONYMS_LAUNCH_INCOGNITO_ONE_REQUIRED_ENTER_INCOGNITO_MODE 41393
#define IDS_OMNIBOX_PEDAL_SYNONYMS_LAUNCH_INCOGNITO_ONE_OPTIONAL_GOOGLE_CHROME 41394
#define IDS_OMNIBOX_PEDAL_SYNONYMS_LAUNCH_INCOGNITO_ONE_OPTIONAL_CREATE 41395
#define IDS_OMNIBOX_PEDAL_SYNONYMS_LAUNCH_INCOGNITO_ONE_REQUIRED_INCOGNITO_WINDOW 41396
#define IDS_OMNIBOX_PEDAL_SYNONYMS_TRANSLATE_ONE_REQUIRED_TRANSLATE_THIS_PAGE 41397
#define IDS_OMNIBOX_PEDAL_SYNONYMS_TRANSLATE_ONE_OPTIONAL_GOOGLE_CHROME 41398
#define IDS_OMNIBOX_PEDAL_SYNONYMS_TRANSLATE_ONE_REQUIRED_CHANGE_LANGUAGE 41399
#define IDS_OMNIBOX_PEDAL_SYNONYMS_TRANSLATE_ONE_REQUIRED_THIS_PAGE 41400
#define IDS_OMNIBOX_PEDAL_SYNONYMS_UPDATE_CHROME_ONE_REQUIRED_UPDATE_CHROME 41401
#define IDS_OMNIBOX_PEDAL_SYNONYMS_UPDATE_CHROME_ONE_REQUIRED_GOOGLE_CHROME 41402
#define IDS_OMNIBOX_PEDAL_SYNONYMS_UPDATE_CHROME_ONE_REQUIRED_INSTALL 41403
#define IDS_OMNIBOX_PEDAL_SYNONYMS_RUN_CHROME_SAFETY_CHECK_ONE_REQUIRED_RUN_CHROME_SAFETY_CHECK 41404
#define IDS_OMNIBOX_PEDAL_SYNONYMS_RUN_CHROME_SAFETY_CHECK_ONE_OPTIONAL_ACTIVATE 41405
#define IDS_OMNIBOX_PEDAL_SYNONYMS_RUN_CHROME_SAFETY_CHECK_ONE_OPTIONAL_GOOGLE_CHROME 41406
#define IDS_OMNIBOX_PEDAL_SYNONYMS_RUN_CHROME_SAFETY_CHECK_ONE_REQUIRED_CHECKUP 41407
#define IDS_OMNIBOX_PEDAL_SYNONYMS_RUN_CHROME_SAFETY_CHECK_ONE_REQUIRED_PASSWORDS 41408
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_SECURITY_SETTINGS_ONE_REQUIRED_MANAGE_SECURITY_SETTINGS 41409
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_SECURITY_SETTINGS_ANY_OPTIONAL_GOOGLE_CHROME 41410
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_SECURITY_SETTINGS_ONE_REQUIRED_ENHANCED_PROTECTION 41411
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_SECURITY_SETTINGS_ONE_OPTIONAL_ALTER 41412
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_COOKIES_ONE_REQUIRED_CHROME_COOKIE_SETTINGS 41413
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_COOKIES_ONE_REQUIRED_COOKIE_SETTINGS 41414
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_COOKIES_ANY_REQUIRED_GOOGLE_CHROME 41415
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_COOKIES_ANY_OPTIONAL_THIRD_PARTY 41416
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_ADDRESSES_ONE_REQUIRED_ADD_ADDRESS 41417
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_ADDRESSES_ONE_REQUIRED_CONTROL 41418
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_ADDRESSES_ONE_REQUIRED_SHIPPING_ADDRESSES 41419
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_ADDRESSES_ONE_OPTIONAL_GOOGLE_CHROME 41420
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_SYNC_ONE_REQUIRED_CHANGE_CHROME_BROWSER_SYNC_SETTINGS 41421
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_SYNC_ONE_REQUIRED_SYNC_SETTINGS 41422
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_SYNC_ANY_REQUIRED_GOOGLE_CHROME 41423
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_SITE_SETTINGS_ONE_REQUIRED_ADJUST_SITE_PERMISSIONS 41424
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_SITE_SETTINGS_ONE_REQUIRED_SITE_PERMISSIONS 41425
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_SITE_SETTINGS_ANY_REQUIRED_GOOGLE_CHROME 41426
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_DOC_ONE_REQUIRED_CREATE_GOOGLE_DOC 41427
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_DOC_ONE_REQUIRED_GOOGLE_WORKSPACE 41428
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_DOC_ANY_REQUIRED_CREATE 41429
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_DOC_ONE_REQUIRED_DOCUMENT 41430
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_SHEET_ONE_REQUIRED_CREATE_GOOGLE_SHEET 41431
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_SHEET_ANY_REQUIRED_CREATE 41432
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_SHEET_ONE_REQUIRED_GOOGLE_WORKSPACE 41433
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_SHEET_ONE_REQUIRED_SPREADSHEET 41434
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_SLIDE_ONE_REQUIRED_CREATE_GOOGLE_SLIDE 41435
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_SLIDE_ONE_REQUIRED_CREATE 41436
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_SLIDE_ONE_REQUIRED_PRESENTATION 41437
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_SLIDE_ANY_REQUIRED_WORKSPACE 41438
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_CALENDAR_EVENT_ONE_REQUIRED_CREATE_GOOGLE_CAL_INVITE 41439
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_CALENDAR_EVENT_ANY_REQUIRED_SCHEDULE 41440
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_CALENDAR_EVENT_ANY_REQUIRED_WORKSPACE 41441
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_CALENDAR_EVENT_ONE_REQUIRED_MEETING 41442
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_SITE_ONE_REQUIRED_CREATE_GOOGLE_SITE 41443
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_SITE_ANY_REQUIRED_CREATE 41444
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_SITE_ANY_REQUIRED_WORKSPACE 41445
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_SITE_ONE_REQUIRED_WEBSITE 41446
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_KEEP_NOTE_ONE_REQUIRED_CREATE_GOOGLE_KEEP_NOTE 41447
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_KEEP_NOTE_ANY_REQUIRED_CREATE 41448
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_KEEP_NOTE_ANY_REQUIRED_WORKSPACE 41449
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_KEEP_NOTE_ONE_REQUIRED_NOTES 41450
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_FORM_ONE_REQUIRED_CREATE_GOOGLE_FORM 41451
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_FORM_ANY_REQUIRED_CREATE 41452
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_FORM_ANY_REQUIRED_WORKSPACE 41453
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_FORM_ONE_REQUIRED_SURVEY 41454
#define IDS_OMNIBOX_PEDAL_SYNONYMS_SEE_CHROME_TIPS_ONE_REQUIRED_CHROME_FEATURES 41455
#define IDS_OMNIBOX_PEDAL_SYNONYMS_SEE_CHROME_TIPS_ONE_OPTIONAL_MAKE_THE_MOST_OF 41456
#define IDS_OMNIBOX_PEDAL_SYNONYMS_SEE_CHROME_TIPS_ANY_OPTIONAL_BROWSER 41457
#define IDS_OMNIBOX_PEDAL_SYNONYMS_SEE_CHROME_TIPS_ONE_REQUIRED_NEW_CHROME_FEATURES 41458
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_GOOGLE_ACCOUNT_ONE_REQUIRED_CONTROL_MY_GOOGLE_ACCOUNT 41459
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_GOOGLE_ACCOUNT_ONE_REQUIRED_GOOGLE_ACCOUNT 41460
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_GOOGLE_ACCOUNT_ANY_OPTIONAL_BROWSER 41461
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_GOOGLE_ACCOUNT_ONE_REQUIRED_CONTROL 41462
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CHANGE_GOOGLE_PASSWORD_ONE_REQUIRED_CHANGE_GMAIL_PASSWORD 41463
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CHANGE_GOOGLE_PASSWORD_ONE_REQUIRED_GOOGLE_ACCOUNT_PASSWORD 41464
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CHANGE_GOOGLE_PASSWORD_ANY_OPTIONAL_BROWSER 41465
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CHANGE_GOOGLE_PASSWORD_ONE_REQUIRED_CHANGE 41466
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CLOSE_INCOGNITO_WINDOWS_ONE_REQUIRED_CLOSE_INCOGNITO_WINDOW 41467
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CLOSE_INCOGNITO_WINDOWS_ONE_REQUIRED_DELETE 41468
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CLOSE_INCOGNITO_WINDOWS_ONE_REQUIRED_INCOGNITO_WINDOW 41469
#define IDS_OMNIBOX_PEDAL_SYNONYMS_PLAY_CHROME_DINO_GAME_ONE_REQUIRED_CHROME_DINO 41470
#define IDS_OMNIBOX_PEDAL_SYNONYMS_PLAY_CHROME_DINO_GAME_ONE_REQUIRED_PLAY_CHROME_DINO_GAME 41471
#define IDS_OMNIBOX_PEDAL_SYNONYMS_FIND_MY_PHONE_ONE_REQUIRED_FIND_LOST_PHONE 41472
#define IDS_OMNIBOX_PEDAL_SYNONYMS_FIND_MY_PHONE_ONE_REQUIRED_HELP_ME_LOCATE 41473
#define IDS_OMNIBOX_PEDAL_SYNONYMS_FIND_MY_PHONE_ONE_REQUIRED_LOST_DEVICE 41474
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_GOOGLE_PRIVACY_ONE_REQUIRED_CHANGE_GOOGLE_PRIVACY_SETTINGS 41475
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_GOOGLE_PRIVACY_ONE_REQUIRED_MANAGE_GOOGLE_PRIVACY_SETTINGS 41476
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_CHROME_SETTINGS_ONE_REQUIRED_CHANGE_CHROME_SETTINGS 41477
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_CHROME_SETTINGS_ONE_OPTIONAL_CONTROL 41478
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_CHROME_SETTINGS_ONE_REQUIRED_CHROME_BROWSER_SETTINGS 41479
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_CHROME_DOWNLOADS_ONE_REQUIRED_MANAGE_CHROME_DOWNLOADS 41480
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_CHROME_DOWNLOADS_ONE_REQUIRED_CONTROL 41481
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_CHROME_DOWNLOADS_ONE_REQUIRED_CHROME_BROWSER_DOWNLOADS 41482
#define IDS_OMNIBOX_PEDAL_SYNONYMS_VIEW_CHROME_HISTORY_ONE_REQUIRED_SEE_CHROME_HISTORY 41483
#define IDS_OMNIBOX_PEDAL_SYNONYMS_VIEW_CHROME_HISTORY_ONE_REQUIRED_REVISIT 41484
#define IDS_OMNIBOX_PEDAL_SYNONYMS_VIEW_CHROME_HISTORY_ONE_REQUIRED_GOOGLE_CHROME_BROWSING_HISTORY 41485
#define IDS_OMNIBOX_PEDAL_SYNONYMS_SHARE_THIS_PAGE_ONE_REQUIRED_SHARE_THIS_PAGE 41486
#define IDS_OMNIBOX_PEDAL_SYNONYMS_SHARE_THIS_PAGE_ONE_REQUIRED_SHARE_LINK_WITH_QR_CODE 41487
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_CHROME_ACCESSIBILITY_ONE_REQUIRED_CUSTOMIZE_CHROME_ACCESSIBILITY 41488
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_CHROME_ACCESSIBILITY_ONE_OPTIONAL_CUSTOMIZE 41489
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_CHROME_ACCESSIBILITY_ONE_REQUIRED_ACCESSIBILITY_SETTINGS 41490
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CUSTOMIZE_CHROME_FONTS_ONE_REQUIRED_CHANGE_BROWSER_FONT 41491
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CUSTOMIZE_CHROME_FONTS_ONE_OPTIONAL_CUSTOMIZE 41492
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CUSTOMIZE_CHROME_FONTS_ONE_REQUIRED_GOOGLE_CHROME 41493
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CUSTOMIZE_CHROME_FONTS_ONE_REQUIRED_FONT_SIZING 41494
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_CHROME_THEMES_ONE_REQUIRED_CUSTOMIZE_CHROME_APPEARANCE 41495
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_CHROME_THEMES_ONE_OPTIONAL_CUSTOMIZE 41496
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_CHROME_THEMES_ONE_REQUIRED_CHROME_BACKGROUNDS 41497
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CUSTOMIZE_SEARCH_ENGINES_ONE_REQUIRED_ADD_CUSTOM_SEARCH 41498
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CUSTOMIZE_SEARCH_ENGINES_ONE_OPTIONAL_CUSTOMIZE 41499
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CUSTOMIZE_SEARCH_ENGINES_ONE_REQUIRED_CUSTOM_SEARCH_ENGINES 41500
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CUSTOMIZE_SEARCH_ENGINES_ONE_OPTIONAL_GOOGLE_CHROME 41501
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_CHROMEOS_ACCESSIBILITY_ONE_REQUIRED_CUSTOMIZE_CHROMEOS_ACCESSIBILITY 41502
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_CHROMEOS_ACCESSIBILITY_ONE_OPTIONAL_CUSTOMIZE 41503
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_CHROMEOS_ACCESSIBILITY_ONE_REQUIRED_ACCESSIBILITY_SETTINGS 41504
#define IDS_OMNIBOX_PEDAL_SYNONYMS_SET_CHROME_AS_DEFAULT_BROWSER_ONE_REQUIRED_ALWAYS_OPEN_LINKS_IN_CHROME 41505
#define IDS_OMNIBOX_PEDAL_SYNONYMS_SET_CHROME_AS_DEFAULT_BROWSER_ONE_REQUIRED_HOW_TO_MAKE_CHROME_MY_DEFAULT_BROWSER 41506
#define IDS_OMNIBOX_PEDAL_SYNONYMS_SET_CHROME_AS_DEFAULT_BROWSER_ONE_OPTIONAL_SELECT 41507
#define IDS_OMNIBOX_PEDAL_SYNONYMS_SET_CHROME_AS_DEFAULT_BROWSER_ONE_OPTIONAL_DEFAULT_BROWSER 41508

// ---------------------------------------------------------------------------
// From platform_locale_settings.h:

#define IDS_STANDARD_FONT_FAMILY 17100
#define IDS_FIXED_FONT_FAMILY 17101
#define IDS_SERIF_FONT_FAMILY 17102
#define IDS_SANS_SERIF_FONT_FAMILY 17103
#define IDS_NTP_FONT_FAMILY 17104
#define IDS_CURSIVE_FONT_FAMILY 17105
#define IDS_FANTASY_FONT_FAMILY 17106
#define IDS_MATH_FONT_FAMILY 17107
#define IDS_MINIMUM_FONT_SIZE 17108
#define IDS_MINIMUM_LOGICAL_FONT_SIZE 17109

// ---------------------------------------------------------------------------
// From services_strings.h:

#define IDS_PROXY_RESOLVER_DISPLAY_NAME 46400
#define IDS_WINDOWS_SYSTEM_PROXY_RESOLVER_DISPLAY_NAME 46401
#define IDS_PDF_OCR_RESULT_BEGIN 46402
#define IDS_PDF_OCR_RESULT_END 46403

// ---------------------------------------------------------------------------
// From ui_strings.h:

#define IDS_TIME_SECS 50980
#define IDS_TIME_LONG_SECS 50981
#define IDS_TIME_LONG_SECS_2ND 50982
#define IDS_TIME_MINS 50983
#define IDS_TIME_LONG_MINS 50984
#define IDS_TIME_LONG_MINS_1ST 50985
#define IDS_TIME_LONG_MINS_2ND 50986
#define IDS_TIME_HOURS 50987
#define IDS_TIME_HOURS_1ST 50988
#define IDS_TIME_HOURS_2ND 50989
#define IDS_TIME_DAYS 50990
#define IDS_TIME_DAYS_1ST 50991
#define IDS_TIME_MONTHS 50992
#define IDS_TIME_YEARS 50993
#define IDS_TIME_REMAINING_SECS 50994
#define IDS_TIME_REMAINING_LONG_SECS 50995
#define IDS_TIME_REMAINING_MINS 50996
#define IDS_TIME_REMAINING_LONG_MINS 50997
#define IDS_TIME_REMAINING_HOURS 50998
#define IDS_TIME_REMAINING_DAYS 50999
#define IDS_TIME_REMAINING_MONTHS 51000
#define IDS_TIME_REMAINING_YEARS 51001
#define IDS_TIME_ELAPSED_SECS 51002
#define IDS_TIME_ELAPSED_LONG_SECS 51003
#define IDS_TIME_ELAPSED_MINS 51004
#define IDS_TIME_ELAPSED_LONG_MINS 51005
#define IDS_TIME_ELAPSED_HOURS 51006
#define IDS_TIME_ELAPSED_DAYS 51007
#define IDS_TIME_ELAPSED_MONTHS 51008
#define IDS_TIME_ELAPSED_YEARS 51009
#define IDS_TIME_TITLE_CASE_ELAPSED_LONG_SECS 51010
#define IDS_TIME_TITLE_CASE_ELAPSED_LONG_MINS 51011
#define IDS_TIME_TITLE_CASE_ELAPSED_HOURS 51012
#define IDS_TIME_TITLE_CASE_ELAPSED_DAYS 51013
#define IDS_TIME_TITLE_CASE_ELAPSED_MONTHS 51014
#define IDS_TIME_TITLE_CASE_ELAPSED_YEARS 51015
#define IDS_PAST_TIME_TODAY 51016
#define IDS_PAST_TIME_YESTERDAY 51017
#define IDS_APP_MENU_EMPTY_SUBMENU 51018
#define IDS_CLIPBOARD_MENU_HTML 51019
#define IDS_CLIPBOARD_MENU_IMAGE 51020
#define IDS_CLIPBOARD_MENU_RTF_CONTENT 51021
#define IDS_CLIPBOARD_MENU_WEB_SMART_PASTE 51022
#define IDS_CLIPBOARD_MENU_CLIPBOARD 51023
#define IDS_CLIPBOARD_MENU_DELETE_ALL 51024
#define IDS_EXTENSION_PINNED 51025
#define IDS_EXTENSION_UNPINNED 51026
#define IDS_NEW_BADGE 51027
#define IDS_NEW_BADGE_SCREEN_READER_MESSAGE 51028
#define IDS_SENTENCE_END 51029
#define IDS_CONCAT_TWO_STRINGS_WITH_COMMA 51030
#define IDS_CONCAT_THREE_STRINGS_WITH_COMMA 51031
#define IDS_CONCAT_TWO_STRINGS_WITH_PERIODS 51032
#define IDS_SELECT_UPLOAD_FOLDER_DIALOG_TITLE 51036
#define IDS_CONTENT_CONTEXT_WRITING_DIRECTION_MENU 51044
#define IDS_CONTENT_CONTEXT_WRITING_DIRECTION_DEFAULT 51045
#define IDS_CONTENT_CONTEXT_WRITING_DIRECTION_LTR 51046
#define IDS_CONTENT_CONTEXT_WRITING_DIRECTION_RTL 51047
#define IDS_SELECT_FOLDER_DIALOG_TITLE 51048
#define IDS_SAVE_AS_DIALOG_TITLE 51049
#define IDS_OPEN_FILE_DIALOG_TITLE 51050
#define IDS_OPEN_FILES_DIALOG_TITLE 51051
#define IDS_SAVEAS_ALL_FILES 51052
#define IDS_SELECT_UPLOAD_FOLDER_DIALOG_UPLOAD_BUTTON 51053
#define IDS_APP_ACCNAME_BACK 51054
#define IDS_APP_ACCNAME_CENTER 51055
#define IDS_APP_ACCNAME_CLOSE 51056
#define IDS_APP_ACCNAME_MINIMIZE 51057
#define IDS_APP_ACCNAME_MAXIMIZE 51058
#define IDS_APP_ACCNAME_RESTORE 51059
#define IDS_APP_ACCNAME_MENU 51060
#define IDS_APP_ACCNAME_COLOR_CHOOSER_HEX_INPUT 51061
#define IDS_APP_SCROLLBAR_CXMENU_SCROLLHERE 51062
#define IDS_APP_SCROLLBAR_CXMENU_SCROLLLEFTEDGE 51063
#define IDS_APP_SCROLLBAR_CXMENU_SCROLLRIGHTEDGE 51064
#define IDS_APP_SCROLLBAR_CXMENU_SCROLLHOME 51065
#define IDS_APP_SCROLLBAR_CXMENU_SCROLLEND 51066
#define IDS_APP_SCROLLBAR_CXMENU_SCROLLPAGEUP 51067
#define IDS_APP_SCROLLBAR_CXMENU_SCROLLPAGEDOWN 51068
#define IDS_APP_SCROLLBAR_CXMENU_SCROLLLEFT 51069
#define IDS_APP_SCROLLBAR_CXMENU_SCROLLRIGHT 51070
#define IDS_APP_SCROLLBAR_CXMENU_SCROLLUP 51071
#define IDS_APP_SCROLLBAR_CXMENU_SCROLLDOWN 51072
#define IDS_APP_TABLE_COLUMN_NOT_SORTED_ACCNAME 51073
#define IDS_APP_TABLE_COLUMN_SORTED_ASC_ACCNAME 51074
#define IDS_APP_TABLE_COLUMN_SORTED_DESC_ACCNAME 51075
#define IDS_APP_UNDO 51076
#define IDS_APP_CUT 51077
#define IDS_APP_COPY 51078
#define IDS_APP_PASTE 51079
#define IDS_APP_DELETE 51080
#define IDS_APP_SELECT_ALL 51081
#define IDS_APP_SELECT 51082
#define IDS_CONTENT_CONTEXT_EMOJI 51083
#define IDS_APP_OK 51086
#define IDS_APP_CANCEL 51087
#define IDS_APP_CLOSE 51088
#define IDS_APP_ESC_KEY 51089
#define IDS_APP_TAB_KEY 51090
#define IDS_APP_INSERT_KEY 51091
#define IDS_APP_HOME_KEY 51092
#define IDS_APP_DELETE_KEY 51093
#define IDS_APP_END_KEY 51094
#define IDS_APP_PAGEUP_KEY 51095
#define IDS_APP_PAGEDOWN_KEY 51096
#define IDS_APP_LEFT_ARROW_KEY 51097
#define IDS_APP_RIGHT_ARROW_KEY 51098
#define IDS_APP_UP_ARROW_KEY 51099
#define IDS_APP_DOWN_ARROW_KEY 51100
#define IDS_APP_ENTER_KEY 51101
#define IDS_APP_SPACE_KEY 51102
#define IDS_APP_F1_KEY 51103
#define IDS_APP_F5_KEY 51104
#define IDS_APP_F6_KEY 51105
#define IDS_APP_F11_KEY 51106
#define IDS_APP_BACKSPACE_KEY 51107
#define IDS_APP_COMMA_KEY 51108
#define IDS_APP_PERIOD_KEY 51109
#define IDS_APP_MEDIA_NEXT_TRACK_KEY 51110
#define IDS_APP_MEDIA_PLAY_PAUSE_KEY 51111
#define IDS_APP_MEDIA_PREV_TRACK_KEY 51112
#define IDS_APP_MEDIA_STOP_KEY 51113
#define IDS_APP_ALT_KEY 51114
#define IDS_APP_COMMAND_KEY 51115
#define IDS_APP_CTRL_KEY 51116
#define IDS_APP_SEARCH_KEY 51117
#define IDS_APP_SHIFT_KEY 51118
#define IDS_APP_ACCELERATOR_WITH_MODIFIER 51123
#define IDS_APP_BYTES 51124
#define IDS_APP_KIBIBYTES 51125
#define IDS_APP_MEBIBYTES 51126
#define IDS_APP_GIBIBYTES 51127
#define IDS_APP_TEBIBYTES 51128
#define IDS_APP_PEBIBYTES 51129
#define IDS_APP_BYTES_PER_SECOND 51130
#define IDS_APP_KIBIBYTES_PER_SECOND 51131
#define IDS_APP_MEBIBYTES_PER_SECOND 51132
#define IDS_APP_GIBIBYTES_PER_SECOND 51133
#define IDS_APP_TEBIBYTES_PER_SECOND 51134
#define IDS_APP_PEBIBYTES_PER_SECOND 51135
#define IDS_MESSAGE_CENTER_ACCESSIBLE_NAME 51136
#define IDS_MESSAGE_CENTER_NOTIFICATION_ACCESSIBLE_NAME 51137
#define IDS_MESSAGE_CENTER_NOTIFICATION_ACCESSIBLE_NAME_PLURAL 51138
#define IDS_MESSAGE_CENTER_EXPAND_NOTIFICATION 51139
#define IDS_MESSAGE_CENTER_COLLAPSE_NOTIFICATION 51140
#define IDS_MESSAGE_CENTER_LIST_NOTIFICATION_MESSAGE_WITH_DIVIDER 51141
#define IDS_MESSAGE_CENTER_LIST_NOTIFICATION_HEADER_OVERFLOW_INDICATOR 51142
#define IDS_MESSAGE_CENTER_NOTIFICATION_PROGRESS_PERCENTAGE 51143
#define IDS_MESSAGE_CENTER_NOTIFICATION_CHROMEOS_SYSTEM 51144
#define IDS_MESSAGE_CENTER_NOTIFICATION_INLINE_REPLY_PLACEHOLDER 51145
#define IDS_MESSAGE_CENTER_NOTIFICATION_INLINE_REPLY_ACCESSIBLE_NAME 51146
#define IDS_MESSAGE_NOTIFICATION_NOW_STRING_SHORTEST 51147
#define IDS_MESSAGE_NOTIFICATION_DURATION_MINUTES_SHORTEST 51148
#define IDS_MESSAGE_NOTIFICATION_DURATION_HOURS_SHORTEST 51149
#define IDS_MESSAGE_NOTIFICATION_DURATION_DAYS_SHORTEST 51150
#define IDS_MESSAGE_NOTIFICATION_DURATION_YEARS_SHORTEST 51151
#define IDS_MESSAGE_NOTIFICATION_DURATION_MINUTES_SHORTEST_FUTURE 51152
#define IDS_MESSAGE_NOTIFICATION_DURATION_HOURS_SHORTEST_FUTURE 51153
#define IDS_MESSAGE_NOTIFICATION_DURATION_DAYS_SHORTEST_FUTURE 51154
#define IDS_MESSAGE_NOTIFICATION_DURATION_YEARS_SHORTEST_FUTURE 51155
#define IDS_MESSAGE_CENTER_BLOCK_ALL_NOTIFICATIONS_SITE 51156
#define IDS_MESSAGE_CENTER_BLOCK_ALL_NOTIFICATIONS_APP 51157
#define IDS_MESSAGE_CENTER_BLOCK_ALL_NOTIFICATIONS 51158
#define IDS_MESSAGE_CENTER_DONT_BLOCK_NOTIFICATIONS 51159
#define IDS_MESSAGE_CENTER_SETTINGS_DONE 51160
#define IDS_MESSAGE_CENTER_CLOSE_NOTIFICATION_BUTTON_ACCESSIBLE_NAME 51161
#define IDS_MESSAGE_CENTER_CLOSE_NOTIFICATION_BUTTON_TOOLTIP 51162
#define IDS_MESSAGE_CENTER_NOTIFICATION_SNOOZE_BUTTON_TOOLTIP 51163
#define IDS_MESSAGE_NOTIFICATION_SETTINGS_BUTTON_ACCESSIBLE_NAME 51164
#define IDS_MESSAGE_NOTIFICATION_ACCESSIBLE_NAME 51165
#define IDS_MESSAGE_NOTIFICATION_SEND_TAB_TO_SELF_DEVICE_INFO 51166
#define IDS_MESSAGE_NOTIFICATION_SEND_TAB_TO_SELF_CONFIRMATION_SUCCESS 51167
#define IDS_MESSAGE_NOTIFICATION_SEND_TAB_TO_SELF_CONFIRMATION_FAILURE_TITLE 51168
#define IDS_MESSAGE_NOTIFICATION_SEND_TAB_TO_SELF_CONFIRMATION_FAILURE_MESSAGE 51169
#define IDS_CLIPBOARD_HISTORY_MENU_PNG_IMAGE 51171
#define IDS_CLIPBOARD_HISTORY_MENU_HTML_IMAGE 51172
#define IDS_CLIPBOARD_HISTORY_MENU_TITLE 51173
#define IDS_CLIPBOARD_HISTORY_DELETE_ITEM_TEXT 51174
#define IDS_CLIPBOARD_HISTORY_DELETE_BUTTON_HOVER_TEXT 51175
#define IDS_CLIPBOARD_HISTORY_ITEM_DELETION 51176
#define IDS_DISPLAY_TOUCH_CALIBRATION_EXIT_LABEL 51177
#define IDS_DISPLAY_TOUCH_CALIBRATION_HINT_LABEL_TEXT 51178
#define IDS_DISPLAY_TOUCH_CALIBRATION_HINT_SUBLABEL_TEXT 51179
#define IDS_DISPLAY_TOUCH_CALIBRATION_TAP_HERE_LABEL 51180
#define IDS_DISPLAY_TOUCH_CALIBRATION_FINISH_LABEL 51181
#define IDS_DISPLAY_NAME_UNKNOWN 51182
#define IDS_DISPLAY_NAME_INTERNAL 51183
#define IDS_CROSTINI_USE_LOW_DENSITY 51184
#define IDS_CROSTINI_USE_HIGH_DENSITY 51185
#define IDS_CROSTINI_APP_RESTART_BODY 51186
#define IDS_SATURATED_BADGE_CONTENT 51187
#define IDS_BADGE_UNREAD_NOTIFICATIONS_SATURATED 51188
#define IDS_BADGE_UNREAD_NOTIFICATIONS_UNSPECIFIED 51189
#define IDS_BADGE_UNREAD_NOTIFICATIONS 51190
#define IDS_BROWSER_SHARING_CLICK_TO_CALL_DIALOG_TITLE_LABEL 51191
#define IDS_BROWSER_SHARING_CLICK_TO_CALL_DIALOG_TITLE_NO_DEVICES 51192
#define IDS_BROWSER_SHARING_CLICK_TO_CALL_DIALOG_CALL_BUTTON_LABEL 51193
#define IDS_BROWSER_SHARING_OMNIBOX_SENDING_LABEL 51194
#define IDS_BROWSER_SHARING_DIALOG_DEVICE_SUBTITLE_LAST_ACTIVE_DAYS 51195
#define IDS_BROWSER_SHARING_CLICK_TO_CALL_DIALOG_INITIATING_ORIGIN 51196
#define IDS_BROWSER_SHARING_CONTENT_TYPE_TEXT 51197
#define IDS_BROWSER_SHARING_CONTENT_TYPE_NUMBER 51198
#define IDS_BROWSER_SHARING_ERROR_DIALOG_TITLE_GENERIC_ERROR 51199
#define IDS_BROWSER_SHARING_ERROR_DIALOG_TITLE_INTERNAL_ERROR 51200
#define IDS_BROWSER_SHARING_ERROR_DIALOG_TEXT_NETWORK_ERROR 51201
#define IDS_BROWSER_SHARING_ERROR_DIALOG_TEXT_DEVICE_ACK_TIMEOUT 51202
#define IDS_BROWSER_SHARING_ERROR_DIALOG_TEXT_INTERNAL_ERROR 51203
#define IDS_BROWSER_SHARING_SHARED_CLIPBOARD_ERROR_DIALOG_TITLE_PAYLOAD_TOO_LARGE 51204
#define IDS_BROWSER_SHARING_SHARED_CLIPBOARD_ERROR_DIALOG_TEXT_PAYLOAD_TOO_LARGE 51205
#define IDS_SETTINGS_PASSWORD_SHOW 51209
#define IDS_SETTINGS_PASSWORD_HIDE 51210
#define IDS_TABLE_VIEW_AX_ANNOUNCE_ROW_SELECTED 51211
#define IDS_LINK_COPIED 51212

#endif  // CEF_INCLUDE_CEF_PACK_STRINGS_H_
