﻿// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

using Cake.Common.Tools.DotNet.Execute;
using Cake.Core.IO;

namespace Cake.Common.Tests.Fixtures.Tools.DotNet.Execute
{
    internal sealed class DotNetExecutorFixture : DotNetFixture<DotNetExecuteSettings>
    {
        public FilePath AssemblyPath { get; set; }

        public ProcessArgumentBuilder Arguments { get; set; }

        protected override void RunTool()
        {
            var tool = new DotNetExecutor(FileSystem, Environment, ProcessRunner, Tools);
            tool.Execute(AssemblyPath, Arguments, Settings);
        }
    }
}