/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util;

import java.io.File;
import java.util.Date;
import java.util.Vector;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.FileUtils;

public class SourceFileScanner {
    protected Task task;
    private FileUtils fileUtils;

    public SourceFileScanner(Task task) {
        this.task = task;
        this.fileUtils = FileUtils.newFileUtils();
    }

    public String[] restrict(String[] stringArray, File file, File file2, FileNameMapper fileNameMapper) {
        Object[] objectArray;
        long l = new Date().getTime();
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("os.name").toLowerCase();
        if (string.indexOf("windows") >= 0) {
            l += 2000L;
        }
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < stringArray.length) {
            objectArray = fileNameMapper.mapFileName(stringArray[n]);
            if (objectArray == null || objectArray.length == 0) {
                this.task.log(stringArray[n] + " skipped - don't know how to handle it", 3);
            } else {
                File file3 = null;
                file3 = file == null ? new File(stringArray[n]) : this.fileUtils.resolveFile(file, stringArray[n]);
                if (file3.lastModified() > l) {
                    this.task.log("Warning: " + stringArray[n] + " modified in the future.", 1);
                }
                boolean bl = false;
                stringBuffer.setLength(0);
                int n2 = 0;
                while (!bl && n2 < objectArray.length) {
                    File file4 = null;
                    file4 = file2 == null ? new File((String)objectArray[n2]) : this.fileUtils.resolveFile(file2, (String)objectArray[n2]);
                    if (!file4.exists()) {
                        this.task.log(stringArray[n] + " added as " + file4.getAbsolutePath() + " doesn't exist.", 3);
                        vector.addElement(stringArray[n]);
                        bl = true;
                    } else if (file3.lastModified() > file4.lastModified()) {
                        this.task.log(stringArray[n] + " added as " + file4.getAbsolutePath() + " is outdated.", 3);
                        vector.addElement(stringArray[n]);
                        bl = true;
                    } else {
                        if (stringBuffer.length() > 0) {
                            stringBuffer.append(", ");
                        }
                        stringBuffer.append(file4.getAbsolutePath());
                    }
                    ++n2;
                }
                if (!bl) {
                    this.task.log(stringArray[n] + " omitted as " + stringBuffer.toString() + (objectArray.length == 1 ? " is" : " are ") + " up to date.", 3);
                }
            }
            ++n;
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public File[] restrictAsFiles(String[] stringArray, File file, File file2, FileNameMapper fileNameMapper) {
        String[] stringArray2 = this.restrict(stringArray, file, file2, fileNameMapper);
        File[] fileArray = new File[stringArray2.length];
        int n = 0;
        while (n < stringArray2.length) {
            fileArray[n] = new File(file, stringArray2[n]);
            ++n;
        }
        return fileArray;
    }
}

